/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloserUtil;
import java.io.File;
import java.io.InputStream;

class Indexer
implements Runnable {
    private final File index;
    private final InputStream stream;

    Indexer(File index, InputStream stream) {
        this.index = index;
        this.stream = stream;
    }

    @Override
    public void run() {
        SamReader in = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).enable(SamReaderFactory.Option.INCLUDE_SOURCE_IN_RECORDS).disable(SamReaderFactory.Option.VALIDATE_CRC_CHECKSUMS).open(SamInputResource.of(this.stream));
        BAMIndexer indexer = new BAMIndexer(this.index, in.getFileHeader());
        for (SAMRecord rec : in) {
            indexer.processAlignment(rec);
        }
        indexer.finish();
        CloserUtil.close(in);
    }
}

