/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import proguard.util.StringMatcher;

public class VariableStringMatcher
extends StringMatcher {
    private final char[] allowedCharacters;
    private final char[] disallowedCharacters;
    private final int minimumLength;
    private final int maximumLength;
    private final StringMatcher nextMatcher;
    private String string;
    private int matchingBeginOffset;
    private int matchingEndOffset;
    private String matchingString;

    public VariableStringMatcher(char[] cArray, char[] cArray2, int n, int n2, StringMatcher stringMatcher) {
        this.allowedCharacters = cArray;
        this.disallowedCharacters = cArray2;
        this.minimumLength = n;
        this.maximumLength = n2;
        this.nextMatcher = stringMatcher;
    }

    public String getMatchingString() {
        if (this.string == null) {
            throw new UnsupportedOperationException("Can't handle regular expression with referenced wildcard");
        }
        return this.matchingString == null ? (this.matchingString = this.string.substring(this.matchingBeginOffset, this.matchingEndOffset)) : this.matchingString;
    }

    @Override
    protected boolean matches(String string, int n, int n2) {
        int n3;
        int n4 = n2 - n;
        if (this.nextMatcher == null) {
            boolean bl;
            boolean bl2 = bl = n4 >= this.minimumLength && n4 <= this.maximumLength && this.areAllowedCharacters(string, n, n2);
            if (bl) {
                this.rememberMatchingString(string, n, n2);
            } else {
                this.resetMatchingString();
            }
            return bl;
        }
        if (n4 < this.minimumLength || !this.areAllowedCharacters(string, n, n + this.minimumLength)) {
            this.resetMatchingString();
            return false;
        }
        int n5 = Math.min(this.maximumLength, n4);
        for (n3 = this.minimumLength; n3 < n5; ++n3) {
            int n6 = n + n3;
            if (this.matchesNextMatcher(string, n, n6, n2)) {
                return true;
            }
            if (this.isAllowedCharacter(string.charAt(n6))) continue;
            this.resetMatchingString();
            return false;
        }
        n3 = n + n5;
        if (this.matchesNextMatcher(string, n, n3, n2)) {
            return true;
        }
        this.resetMatchingString();
        return false;
    }

    private boolean areAllowedCharacters(String string, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (this.isAllowedCharacter(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isAllowedCharacter(char c) {
        if (this.allowedCharacters != null) {
            for (int i = 0; i < this.allowedCharacters.length; ++i) {
                if (this.allowedCharacters[i] != c) continue;
                return true;
            }
            return false;
        }
        if (this.disallowedCharacters != null) {
            for (int i = 0; i < this.disallowedCharacters.length; ++i) {
                if (this.disallowedCharacters[i] != c) continue;
                return false;
            }
        }
        return true;
    }

    private boolean matchesNextMatcher(String string, int n, int n2, int n3) {
        this.rememberMatchingString(string, n, n2);
        return this.nextMatcher.matches(string, n2, n3);
    }

    private void rememberMatchingString(String string, int n, int n2) {
        this.string = string;
        this.matchingBeginOffset = n;
        this.matchingEndOffset = n2;
        this.matchingString = null;
    }

    private void resetMatchingString() {
        this.string = null;
        this.matchingBeginOffset = 0;
        this.matchingEndOffset = 0;
        this.matchingString = null;
    }
}

