# r4dd - rack infrastructure control daemon
#
# Copyright (C) 2016  Linutronix GmbH
# Author: Benedikt Spranger <b.spranger@linutronix.de>
#
# This file is part of r4d.
#
# r4d is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# r4d is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ELBE.  If not, see <http://www.gnu.org/licenses/>.

import logging

from importlib import import_module
from pkgutil import iter_modules

log = logging.getLogger (__name__)

def register_modules (parent, modul):
    for _, x, _ in iter_modules (modul.__path__):
        text = "register module " + x + ": "
        try:
            log.info (modul.__name__ + "." + x)
            module = import_module (modul.__name__ + "." + x)
            module.register (parent)
            log.info (text + "OK.")
        except Exception as e:
            log.error (text + "failed.")
            log.error (e)
