/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.check;

import java.math.BigDecimal;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.cobertura.check.CoverageResultEntry;
import net.sourceforge.cobertura.dsl.Arguments;
import net.sourceforge.cobertura.dsl.ArgumentsBuilder;
import net.sourceforge.cobertura.dsl.Cobertura;
import net.sourceforge.cobertura.reporting.CoverageThresholdsReport;
import net.sourceforge.cobertura.reporting.ReportName;
import net.sourceforge.cobertura.util.Header;
import org.apache.oro.text.regex.MalformedPatternException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckCoverageMain {
    private static final Logger logger = LoggerFactory.getLogger(CheckCoverageMain.class);

    public CheckCoverageMain(String[] args) throws MalformedPatternException {
        int exitStatus = CheckCoverageMain.checkCoverage(args);
        System.exit(exitStatus);
    }

    private static int checkCoverageTypeStatusAndLogMessage(CoverageResultEntry entry, int branchStatus, int lineStatus) {
        if (entry.getCoverageType().equals((Object)CoverageResultEntry.CoverageType.BRANCH)) {
            logger.error(entry.getName() + " failed coverage check. Branch coverage rate of " + CheckCoverageMain.percentage(entry.getCurrentCoverage()) + "% is below " + CheckCoverageMain.percentage(entry.getExpectedCoverage()) + "%");
            return branchStatus;
        }
        logger.error(entry.getName() + " failed coverage check. Line coverage rate of " + CheckCoverageMain.percentage(entry.getCurrentCoverage()) + "% is below " + CheckCoverageMain.percentage(entry.getExpectedCoverage()) + "%");
        return lineStatus;
    }

    private static double inRangeAndDivideByOneHundred(String coverageRateAsPercentage) {
        return CheckCoverageMain.inRangeAndDivideByOneHundred(Integer.valueOf(coverageRateAsPercentage));
    }

    private static double inRangeAndDivideByOneHundred(int coverageRateAsPercentage) {
        if (coverageRateAsPercentage >= 0 && coverageRateAsPercentage <= 100) {
            return (double)coverageRateAsPercentage / 100.0;
        }
        throw new IllegalArgumentException("The value " + coverageRateAsPercentage + "% is invalid.  Percentages must be between 0 and 100.");
    }

    private static String percentage(double coverateRate) {
        BigDecimal decimal = new BigDecimal(coverateRate * 100.0);
        return decimal.setScale(1, 1).toString();
    }

    public static int checkCoverage(String[] args) throws MalformedPatternException {
        Header.print(System.out);
        ArgumentsBuilder builder = new ArgumentsBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--branch")) {
                builder.setClassBranchCoverageThreshold(CheckCoverageMain.inRangeAndDivideByOneHundred(args[++i]));
                continue;
            }
            if (args[i].equals("--datafile")) {
                builder.setDataFile(args[++i]);
                continue;
            }
            if (args[i].equals("--line")) {
                builder.setClassLineCoverageThreshold(CheckCoverageMain.inRangeAndDivideByOneHundred(args[++i]));
                continue;
            }
            if (args[i].equals("--regex")) {
                StringTokenizer tokenizer = new StringTokenizer(args[++i], ":");
                builder.addMinimumCoverageRates(tokenizer.nextToken(), CheckCoverageMain.inRangeAndDivideByOneHundred(tokenizer.nextToken()), CheckCoverageMain.inRangeAndDivideByOneHundred(tokenizer.nextToken()));
                continue;
            }
            if (args[i].equals("--packagebranch")) {
                builder.setPackageBranchCoverageThreshold(CheckCoverageMain.inRangeAndDivideByOneHundred(args[++i]));
                continue;
            }
            if (args[i].equals("--packageline")) {
                builder.setPackageLineCoverageThreshold(CheckCoverageMain.inRangeAndDivideByOneHundred(args[++i]));
                continue;
            }
            if (args[i].equals("--totalbranch")) {
                builder.setTotalBranchCoverageThreshold(CheckCoverageMain.inRangeAndDivideByOneHundred(args[++i]));
                continue;
            }
            if (!args[i].equals("--totalline")) continue;
            builder.setTotalLineCoverageThreshold(CheckCoverageMain.inRangeAndDivideByOneHundred(args[++i]));
        }
        Arguments arguments = builder.build();
        CoverageThresholdsReport coverageThresholdsReport = (CoverageThresholdsReport)new Cobertura(arguments).checkThresholds().report().getByName(ReportName.THRESHOLDS_REPORT);
        List<CoverageResultEntry> coverageResultEntries = coverageThresholdsReport.getCoverageResultEntries();
        int exitStatus = 0;
        for (CoverageResultEntry entry : coverageResultEntries) {
            if (!entry.isBelowExpectedCoverage()) continue;
            switch (entry.getCoverageLevel()) {
                case CLASS: {
                    exitStatus |= CheckCoverageMain.checkCoverageTypeStatusAndLogMessage(entry, 2, 4);
                    break;
                }
                case PACKAGE: {
                    exitStatus |= CheckCoverageMain.checkCoverageTypeStatusAndLogMessage(entry, 32, 64);
                    break;
                }
                case PROJECT: {
                    exitStatus |= CheckCoverageMain.checkCoverageTypeStatusAndLogMessage(entry, 8, 16);
                }
            }
        }
        return exitStatus;
    }

    public static void main(String[] args) throws MalformedPatternException {
        int exitStatus = CheckCoverageMain.checkCoverage(args);
        System.exit(exitStatus);
    }
}

