/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 11:06:54 GMT 2018
 */

package uk.ac.sanger.artemis.circular;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.util.Vector;
import org.emboss.jemboss.JembossParams;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.FeaturePatternPredicate;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.circular.DNADraw;
import uk.ac.sanger.artemis.circular.Track;
import uk.ac.sanger.artemis.circular.Wizard;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankDocumentEntry;
import uk.ac.sanger.artemis.io.MSPcrunchDocumentEntry;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class Wizard_ESTest extends Wizard_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      BufferedReader bufferedReader0 = Wizard.getReader("");
      assertNull(bufferedReader0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Track[] trackArray0 = Wizard.getTracks();
      assertNotNull(trackArray0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeaturePatternPredicate featurePatternPredicate0 = new FeaturePatternPredicate((AminoAcidSequence) null);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featurePatternPredicate0, "");
      filteredEntryGroup0.createEntry();
      Bases bases0 = new Bases((Sequence) null);
      // Undeclared exception!
      Wizard.readEntry((DNADraw) null, bases0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      // Undeclared exception!
      try { 
        Wizard.getReader((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.File", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      // Undeclared exception!
      try { 
        Wizard.deleteTrack(2376);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 4
         //
         verifyException("uk.ac.sanger.artemis.circular.Wizard", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      BufferedReader bufferedReader0 = Wizard.getReader("Calculating user graph points");
      assertNull(bufferedReader0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/Calculating user graph points");
      byte[] byteArray0 = new byte[2];
      FileSystemHandling.appendDataToFile(evoSuiteFile0, byteArray0);
      BufferedReader bufferedReader0 = Wizard.getReader("Calculating user graph points");
      assertNotNull(bufferedReader0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("header", "qualifier=not");
      Bases bases0 = new Bases(fastaStreamSequence0);
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(blastEntryInformation0);
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(blastEntryInformation0, mSPcrunchDocumentEntry0, true);
      Entry entry0 = new Entry(bases0, genbankDocumentEntry0);
      Track track0 = Wizard.addTrack(entry0);
      assertEquals(0.7, track0.getPosition(), 0.01);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      Wizard wizard0 = null;
      try {
        wizard0 = new Wizard(dNADraw0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Wizard wizard0 = null;
      try {
        wizard0 = new Wizard((DNADraw) null);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.getPublicServers();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("header", "qualifier=not");
      Bases bases0 = new Bases(fastaStreamSequence0);
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(blastEntryInformation0);
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(blastEntryInformation0, mSPcrunchDocumentEntry0, true);
      Entry entry0 = new Entry(bases0, genbankDocumentEntry0);
      DNADraw dNADraw1 = Wizard.getDNADrawFromArtemisEntry(dNADraw0, simpleEntryGroup0, entry0);
      assertSame(dNADraw1, dNADraw0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.getPublicServers();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      // Undeclared exception!
      try { 
        Wizard.getDNADrawFromArtemisEntry(dNADraw0, simpleEntryGroup0, (Entry) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Wizard", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Wizard wizard0 = null;
      try {
        wizard0 = new Wizard("");
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Wizard.deleteTrack(0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      // Undeclared exception!
      try { 
        Wizard.getDNADrawFromFile(dNADraw0);
        fail("Expecting exception: SecurityException");
      
      } catch(SecurityException e) {
         //
         // Permission Denied
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }
}
