//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Detector/DetectorItemCatalog.cpp
//! @brief     Implements class DetectorItemCatalog
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Model/Detector/DetectorItemCatalog.h"
#include "GUI/Model/Detector/RectangularDetectorItem.h"
#include "GUI/Model/Detector/SphericalDetectorItem.h"

DetectorItem* DetectorItemCatalog::create(Type type)
{
    switch (type) {
    case Type::Spherical:
        return new SphericalDetectorItem();
    case Type::Rectangular:
        return new RectangularDetectorItem();
    }
    ASSERT(false);
}

QVector<DetectorItemCatalog::Type> DetectorItemCatalog::types()
{
    return {Type::Spherical, Type::Rectangular};
}

UiInfo DetectorItemCatalog::uiInfo(Type type)
{
    switch (type) {
    case Type::Spherical:
        return {"Spherical detector", "", ""};
    case Type::Rectangular:
        return {"Rectangular detector", "", ""};
    }
    ASSERT(false);
}

DetectorItemCatalog::Type DetectorItemCatalog::type(const DetectorItem* item)
{
    if (dynamic_cast<const SphericalDetectorItem*>(item))
        return Type::Spherical;
    if (dynamic_cast<const RectangularDetectorItem*>(item))
        return Type::Rectangular;

    ASSERT(false);
}
