//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/RectangleView.h
//! @brief     Defines RectangleView class
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_MASK_RECTANGLEVIEW_H
#define BORNAGAIN_GUI_VIEW_MASK_RECTANGLEVIEW_H

#include "GUI/View/Mask/RectangleBaseView.h"

class RectangleItem;

//! This is a View of rectangular mask (represented by RectangleItem) on GraphicsScene.
//! Given view follows standard QGraphicsScene notations: (x,y) is top left corner.

class RectangleView : public RectangleBaseView {
    Q_OBJECT

public:
    int type() const override { return MaskEditorHelper::RECTANGLE; }

    explicit RectangleView(RectangleItem* item);

    QPainterPath shape() const override;
    MaskItemObject* parameterizedItem() const override;

protected slots:
    void onChangedX() override;
    void onChangedY() override;
    void onPropertyChange() override;

protected:
    void mouseMoveEvent(QGraphicsSceneMouseEvent* event) override;

protected:
    void update_position() override;
    QRectF mask_rectangle() override;
    qreal left() const override;
    qreal right() const override;
    qreal top() const override;
    qreal bottom() const override;

private:
    RectangleItem* m_item;
};

#endif // BORNAGAIN_GUI_VIEW_MASK_RECTANGLEVIEW_H
