//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Resample/Particle/ReMesocrystal.h
//! @brief     Defines class ReMesocrystal.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_RESAMPLE_PARTICLE_REMESOCRYSTAL_H
#define BORNAGAIN_RESAMPLE_PARTICLE_REMESOCRYSTAL_H

#include "Resample/Particle/IReParticle.h"
#include "Sample/Lattice/Lattice3D.h"

class ReParticle;

//! A reprocessed Mesocrystal.

class ReMesocrystal : public IReParticle {
public:
    ReMesocrystal(const std::optional<size_t>& i_layer, const Lattice3D& lattice,
                  const IReParticle& basis, const ReParticle& outer_shape,
                  double position_variance = 0.0);
    ~ReMesocrystal() override;

    ReMesocrystal* clone() const override;

    void setAmbientMaterial(const Material& material) override
    {
        m_basis->setAmbientMaterial(material);
    }

    double volume() const override;
    double radialExtension() const override;

    Span zSpan() const override;

    complex_t theFF(const WavevectorInfo& wavevectors) const override;
    SpinMatrix thePolFF(const WavevectorInfo& wavevectors) const override;

private:
    void calculateLargestReciprocalDistance();
    complex_t debyeWallerFactor(const R3& q_i) const;

    Lattice3D m_lattice;
    std::unique_ptr<IReParticle> m_basis;
    std::unique_ptr<ReParticle> m_outer_shape; //!< The outer shape of this mesocrystal
    double m_position_variance;
    double m_max_rec_length;
};

#endif // BORNAGAIN_RESAMPLE_PARTICLE_REMESOCRYSTAL_H
