{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetBounce: Single;
    procedure SetBounce(const Value: Single);
    function GetEnabled: boolean;
    procedure SetEnabled(const Value: boolean);
    function GetFrictionCoefficients: TVector2;
    procedure SetFrictionCoefficients(const Value: TVector2);
    function GetMinBounceSpeed: Single;
    procedure SetMinBounceSpeed(const Value: Single);
    function GetSlipFactors: TVector2;
    procedure SetSlipFactors(const Value: TVector2);
    function GetSoftnessConstantForceMix: Single;
    procedure SetSoftnessConstantForceMix(const Value: Single);
    function GetSoftnessErrorCorrection: Single;
    procedure SetSoftnessErrorCorrection(const Value: Single);
    function GetSurfaceSpeed: TVector2;
    procedure SetSurfaceSpeed(const Value: TVector2);
  public
    procedure SetAppliedParameters(const Value: array of string);
    procedure SetAppliedParameters(const Value: TCastleStringList);
    property Bounce: Single read GetBounce write SetBounce;
    property Enabled: boolean read GetEnabled write SetEnabled;
    property FrictionCoefficients: TVector2 read GetFrictionCoefficients write SetFrictionCoefficients;
    property MinBounceSpeed: Single read GetMinBounceSpeed write SetMinBounceSpeed;
    property SlipFactors: TVector2 read GetSlipFactors write SetSlipFactors;
    property SoftnessConstantForceMix: Single read GetSoftnessConstantForceMix write SetSoftnessConstantForceMix;
    property SoftnessErrorCorrection: Single read GetSoftnessErrorCorrection write SetSoftnessErrorCorrection;
    property SurfaceSpeed: TVector2 read GetSurfaceSpeed write SetSurfaceSpeed;

{$endif read_interface}

{$ifdef read_implementation}

{ TCollisionCollectionNode ----------------------------------------------- }

procedure TCollisionCollectionNode.SetAppliedParameters(const Value: array of string);
begin
  FdAppliedParameters.Send(Value);
end;

procedure TCollisionCollectionNode.SetAppliedParameters(const Value: TCastleStringList);
begin
  FdAppliedParameters.Send(Value);
end;

function TCollisionCollectionNode.GetBounce: Single;
begin
  Result := FdBounce.Value;
end;

procedure TCollisionCollectionNode.SetBounce(const Value: Single);
begin
  FdBounce.Send(Value);
end;

function TCollisionCollectionNode.GetEnabled: boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TCollisionCollectionNode.SetEnabled(const Value: boolean);
begin
  FdEnabled.Send(Value);
end;

function TCollisionCollectionNode.GetFrictionCoefficients: TVector2;
begin
  Result := FdFrictionCoefficients.Value;
end;

procedure TCollisionCollectionNode.SetFrictionCoefficients(const Value: TVector2);
begin
  FdFrictionCoefficients.Send(Value);
end;

function TCollisionCollectionNode.GetMinBounceSpeed: Single;
begin
  Result := FdMinBounceSpeed.Value;
end;

procedure TCollisionCollectionNode.SetMinBounceSpeed(const Value: Single);
begin
  FdMinBounceSpeed.Send(Value);
end;

function TCollisionCollectionNode.GetSlipFactors: TVector2;
begin
  Result := FdSlipFactors.Value;
end;

procedure TCollisionCollectionNode.SetSlipFactors(const Value: TVector2);
begin
  FdSlipFactors.Send(Value);
end;

function TCollisionCollectionNode.GetSoftnessConstantForceMix: Single;
begin
  Result := FdSoftnessConstantForceMix.Value;
end;

procedure TCollisionCollectionNode.SetSoftnessConstantForceMix(const Value: Single);
begin
  FdSoftnessConstantForceMix.Send(Value);
end;

function TCollisionCollectionNode.GetSoftnessErrorCorrection: Single;
begin
  Result := FdSoftnessErrorCorrection.Value;
end;

procedure TCollisionCollectionNode.SetSoftnessErrorCorrection(const Value: Single);
begin
  FdSoftnessErrorCorrection.Send(Value);
end;

function TCollisionCollectionNode.GetSurfaceSpeed: TVector2;
begin
  Result := FdSurfaceSpeed.Value;
end;

procedure TCollisionCollectionNode.SetSurfaceSpeed(const Value: TVector2);
begin
  FdSurfaceSpeed.Send(Value);
end;

{$endif read_implementation}
