# CiviCRM 5.8.0

Released December 5, 2018

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     |   no    |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Configurable quicksearch settings
  ([13039](https://github.com/civicrm/civicrm-core/pull/13039) and
  [13056](https://github.com/civicrm/civicrm-core/pull/13056))**

  This permits (some) custom fields to be added to quicksearch as searchable
  fields. By adding a setting in Search Preferences to configure the search
  fields in the quicksearch box in the menu bar.

- **Permit additional (freeform) relative date filters - e.g 'last 18 months',
  'last 45 days' ([12682](https://github.com/civicrm/civicrm-core/pull/12682))**

  This change adds support for a greater range of date options for relative
  searches (e.g last 45 days, last 18 months). It requires option values to be
  added by an extension or by an experienced admin, and has a limited UI.

- **Allow contribution search by recurring payment processor ID / Transaction ID
  ([12818](https://github.com/civicrm/civicrm-core/pull/12818))**

  This change adds three new fields to the contribution search form: recurring
  contribution transaction ID, payment processor ID and processor ID.

- **[dev/core#495](https://lab.civicrm.org/dev/core/issues/495) Migrate simple
  Preferences & Settings forms to using a Generic class.
  [13054](https://github.com/civicrm/civicrm-core/pull/13054),
  [13062](https://github.com/civicrm/civicrm-core/pull/13062),
  [13047](https://github.com/civicrm/civicrm-core/pull/13047),
  [13046](https://github.com/civicrm/civicrm-core/pull/13046),
  [13048](https://github.com/civicrm/civicrm-core/pull/13048),
  [13040](https://github.com/civicrm/civicrm-core/pull/13040),
  [13004](https://github.com/civicrm/civicrm-core/pull/13004),
  [13026](https://github.com/civicrm/civicrm-core/pull/13026),
  [13027](https://github.com/civicrm/civicrm-core/pull/13027),
  [13025](https://github.com/civicrm/civicrm-core/pull/13025),
  [12731](https://github.com/civicrm/civicrm-core/pull/12731),
  [12940](https://github.com/civicrm/civicrm-core/pull/12940),
  [13022](https://github.com/civicrm/civicrm-core/pull/13022),
  [13023](https://github.com/civicrm/civicrm-core/pull/13023),
  [12906](https://github.com/civicrm/civicrm-core/pull/12906),
  [12919](https://github.com/civicrm/civicrm-core/pull/12919),
  [12925](https://github.com/civicrm/civicrm-core/pull/12925) and
  [12960](https://github.com/civicrm/civicrm-core/pull/12960)**

  Introduce generic settings form (fully metadata driven) - this provides a
  supported methodology for extensions to add settings forms and to alter core
  settings forms (albeit not all core forms are converted to that point).

- **Add icons to contact summary tabs
  ([13018](https://github.com/civicrm/civicrm-core/pull/13018))**

  This change makes it so that an extension using hook_civicrm_tabset can
  specify icons for the contact summary tabs. If no icon is specified
  fa-puzzle-piece is used.

- **Extract selectedChild tabheader functionality and enable for Manage Events
  ([12747](https://github.com/civicrm/civicrm-core/pull/12747))**

  This takes the existing functionality of adding "selectedChild=" to a url for
  a tabbed page and makes it work across all the pages tabs. The tab will have
  an id of 'tab-x' where x is the thing to use after '='.

  This change adds the ability to link to a specific tab for an event (and
  generally cleans up the code related to linking to tabs).

- **Fix search performance issues and reliability on some characters issues by
  removing lower case double-conversion
  ([12494](https://github.com/civicrm/civicrm-core/pull/12494),
  [13035](https://github.com/civicrm/civicrm-core/pull/13035),
  [13034](https://github.com/civicrm/civicrm-core/pull/13034),
  [12993](https://github.com/civicrm/civicrm-core/pull/12993),
  [12987](https://github.com/civicrm/civicrm-core/pull/12987),
  [12988](https://github.com/civicrm/civicrm-core/pull/12988),
  [12991](https://github.com/civicrm/civicrm-core/pull/12991),
  [13053](https://github.com/civicrm/civicrm-core/pull/13053) and
  [13055](https://github.com/civicrm/civicrm-core/pull/13055))**

  These changes make performance improvements to searching by moving from using
  the php strtolower function and mysql LOWER function to mysql handling
  comparing strings in a non case specific way.

- **[dev/core#6](https://lab.civicrm.org/dev/core/issues/6) Add help text for
  "is public" setting on form to edit custom field sets
  ([13060](https://github.com/civicrm/civicrm-core/pull/13060))**

   This change improves user experience of the form to edit custom field sets by
   adding help text to the field "Is this Custom Data Set public?".

- **[dev/core#463](https://lab.civicrm.org/dev/core/issues/463) Add in support
  for Extension Utils when generating DAO files for Extensions
  ([12986](https://github.com/civicrm/civicrm-core/pull/12986))**

  When creating a new entity (e.g DiscountItem) via an extension the new entity
  will need a DAO class. Our Civix code currently supports this - at least
  somewhat - but will not wrap any translatable strings with ts rather than the
  (correct for extensions) E::ts . Adding this to core will allow civix to
  leverage it to better create extension DAO objects.

- **Continue ongoing work to replace jcalendar with datepicker widget - event
  search form search to datepicker and cleanup template
  ([12978](https://github.com/civicrm/civicrm-core/pull/12978)) and participant
  registration form
  ([12979](https://github.com/civicrm/civicrm-core/pull/12979)) and manage
  events fees page ([12977](https://github.com/civicrm/civicrm-core/pull/12977))
  and manage events registration page
  ([12975](https://github.com/civicrm/civicrm-core/pull/12975)) and relationship
  form ([12972](https://github.com/civicrm/civicrm-core/pull/12972)) and event
  fees page ([12992](https://github.com/civicrm/civicrm-core/pull/12992)) and
  Update subscription form
  ([12868](https://github.com/civicrm/civicrm-core/pull/12868))***

  These changes move date picking fields from using jcalendar to use the
  datepicker widget in the following places: Event Search form, Participant
  Registration Form, Manage Event Fees Page, Manage Events Registration page,
  Relationships form, Event Fees page and the Update Subscription form.

- **[dev/core#472](https://lab.civicrm.org/dev/core/issues/472) Allow for
  CiviCRM APIv3 Explorer to find API Examples in extensions in the format of
  api/v3/examples/Entity just in the same format as core
  ([13006](https://github.com/civicrm/civicrm-core/pull/13006))**

  This change makes it so that APIv3 Explorer displays examples found in
  extensions.

- **Translate description in DAO files
  ([13005](https://github.com/civicrm/civicrm-core/pull/13005))**

  This change makes it so that the Description field in the DAO is translated so
  that if the getfields api returns the translated string.

- **Replace translation and calendar image icons
  ([13003](https://github.com/civicrm/civicrm-core/pull/13003))**

  This change makes it so that translation and calendar symbols use font
  icons instead of images.

- **[dev/core#457](https://lab.civicrm.org/dev/core/issues/457) Add new hook
  exportIds ([12957](https://github.com/civicrm/civicrm-core/pull/12957))**

  This change extends CRM_Utils_Hook::export($exportTempTable, $headerRows,
  $sqlColumns, $exportMode, $componentTable, $ids); so that it can return id
  columns.

- **CRM_Core_Resources - Allow container to swap the implementation
  ([12959](https://github.com/civicrm/civicrm-core/pull/12959))**

  This change makes it so that CRM_Core_Resources can be modified in an
  extension using the hook hook_civicrm_container.

- **Do not treat an empty array as not set in caches.
  ([12784](https://github.com/civicrm/civicrm-core/pull/12784))**

  This change improves performance by respecting empty arrays as a cache hit.

- **Fix typo in hook that enables links to be added to a block
  ([12913](https://github.com/civicrm/civicrm-core/pull/12913))**

  This change fixes the $op sent to hook_civicrm_links($op, $objectName,
  $objectId, &$links, &$mask, &$values) from CRM_Core_Block to accept
  create.new.shortcuts in addition to create.new.shorcuts (the misspelled op
  name before this change).

- **Send an 500 http response code when an exception is encountered.
  ([11821](https://github.com/civicrm/civicrm-core/pull/11821) and
  [12902](https://github.com/civicrm/civicrm-core/pull/12902))**

  This change makes it so that instead of always exiting with a 200 code, When
  CRM_Utils_System is called with a status > 0, CiviCRM exits with a 500 code.

- **Register "short" and "long" cache services
  ([12873](https://github.com/civicrm/civicrm-core/pull/12873))**

  This change makes it so that extension developers can use Civi::cache('short')
  or Civi::cache('default') for a short-lived/latency-optimized PSR-16 cache or
  Civi::cache('long') for a long-lived/durability-optimized PSR-16 cache before
  this change only Civi::cache('default') was available.

- **Remove crm.admin.js
  ([12884](https://github.com/civicrm/civicrm-core/pull/12884))**

  This change is both a performance improvement (removes an unnecessary
  javascript file) and a ui improvement because it improved the icon picker ui.

- **Style improvement of radio form elements
  ([12736](https://github.com/civicrm/civicrm-core/pull/12736))**

  This change adds more space between radio form elements and their labels.

- **Use description from schema if available when using entityForm
  ([12971](https://github.com/civicrm/civicrm-core/pull/12971))**

  This change adds the ability to show the description from the entity schema
  instead of hardcoding it in the class when using entityForm.

- **On reports make current employer available as a field for display
  ([12904](https://github.com/civicrm/civicrm-core/pull/12904))**

  This change makes it so that the field "Current Employer" is available as a
  column on reports.

- **[dev/core#487](https://lab.civicrm.org/dev/core/issues/487) Replace ancient
  menubar plugin with something responsive
  ([13804](https://github.com/civicrm/civicrm-core/pull/13084)) (preliminary
  work)**

  This makes some behind-the-scenes changes in order to support a new
  [SmartMenus-based menu extension](https://github.com/aydun/uk.squiffle.kam)
  that is anticipated to replace the current menu in core.

### CiviCase

- **Added relationship active filter in CiviCRM Case reports.
  ([12711](https://github.com/civicrm/civicrm-core/pull/12711))**

  This change adds a filter for is relationship active to CiviCRM Case reports.

### CiviContribute

- **Add validate api action for ContributionPage.submit
  ([12829](https://github.com/civicrm/civicrm-core/pull/12829))**

  This change ensures that api calls using the action
  ContributionPage.submit check that the parameters are valid for the form.

- **[dev/financial#33](https://lab.civicrm.org/dev/financial/issues/33) Proposal -
  Add in hook alterPostIpn or similar
  ([12928](https://github.com/civicrm/civicrm-core/pull/12928))**

  This change adds a hook alterIPNData which allows extension authors the ability
  to do custom processing on IPNs such as sending google analytics information
  based on the IPN data.

- **Show contact name on recurring contribution view and improve consistency
  with Contribution/Membership view
  ([12819](https://github.com/civicrm/civicrm-core/pull/12819))**

  This change improves the ui by including the Contact name in the view of a
  recurring payment.

- **Show recurring contribution links based on payment processor capabilities
  ([12821](https://github.com/civicrm/civicrm-core/pull/12821))**

  This change makes it so that the edit link for recurring contributions is
  hidden/shown based on the payment processor capabilities.

### CiviEvent

- **Mark event start date as required and refactoring
  ([13049](https://github.com/civicrm/civicrm-core/pull/13049))**

  This change makes it so the event start date field has a red * next to it to
  indicate that it is a required field.

### CiviMail

- **[dev/core#481](https://lab.civicrm.org/dev/core/issues/481) New
  Organization: There is no possible to uncheck in the field "Bulk Mailings?"
  ([13019](https://github.com/civicrm/civicrm-core/pull/13019))**

  This change improves the UI when creating a new organization by making the
  "Bulk Mailings" field a checkbox (that can be checked and unchecked) instead
  of a radio that once checked cannot be unchecked.

- **Adding [CiviMail Draft] on test mailing (for mosaico)
  ([12758](https://github.com/civicrm/civicrm-core/pull/12758))**

  This change adds the text [CiviMail Draft] to the subject of any email that is
  sent using the send test functionality.

- **[dev/core#456](https://lab.civicrm.org/dev/core/issues/456) Improve UX of
  scheduling mass SMS
  ([13001](https://github.com/civicrm/civicrm-core/pull/13001))**

  This change improves the UI of the schedule SMS mailings form by making it so
  one has to choose "Send Immediately" OR "Schedule SMS". Before this change one
  could check the box to "Send Immediately" AND a date to Schedule SMS.

### Drupal Integration

- **[CRM-17667](https://issues.civicrm.org/jira/browse/CRM-17667) Drush: Mail
  queue processing does not work
  ([354](https://github.com/civicrm/civicrm-drupal/pull/354))**

  This change makes it so one can use the drush command `drush
  civicrm-process-mail-queue` to execute the scheduled mailing job.

- **Add a drush command to rebuild SQL triggers
  ([545](https://github.com/civicrm/civicrm-drupal/pull/545))**

  This change makes it so that the drush command `drush
  civicrm-sql-rebuild-triggers` rebuilds triggers and can dump the SQL commands
  into a file.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[dev/core#477](https://lab.civicrm.org/dev/core/issues/477) Print Summary is
  missing some contact info
  ([13030](https://github.com/civicrm/civicrm-core/pull/13030))**

  This change fixes a bug where when using the action "Print Summary" for a
  contact record the employer and job title were not being printed in the
  summary so that the employer and job title fields are printed.

- **[dev/core#119](https://lab.civicrm.org/dev/core/issues/119) Notice error
  ([13063](https://github.com/civicrm/civicrm-core/pull/13063))**

  Fixes a bug where when going to view a location of an event (a url like:
  /civicrm/contact/map/event?eid=3&reset=1) would result in an undefined
  variable notice so that no notice is thrown.

- **PHP 7.3 support (Fix misplaced hyphens in regex)
  ([13064](https://github.com/civicrm/civicrm-core/pull/13064))**

  This change fixes a bug for users with a PHP 7.3 where importing contributions
  with custom field values would result in an error message "preg_match():
  Compilation failed: invalid range in character class at offset 7" when
  creating a new contribution with custom field values

- **[dev/core#287](https://lab.civicrm.org/dev/core/issues/287) Child groups
  with all parents disabled shows in group list
  ([12797](https://github.com/civicrm/civicrm-core/pull/12797) and
  [13061](https://github.com/civicrm/civicrm-core/pull/13061))**

  This change ensures that when a parent group is disabled, so are its children
  groups.

- **Fix custom Home URL parsing
  ([13031](https://github.com/civicrm/civicrm-core/pull/13031))**

  This change fixes a bug where Custom Home URLs without a query string would
  result in an E_NOTICE and fragments would be removed from the URL so that no
  E_NOTICE is thrown and fragments are not removed from the custom url.

- **Fix Activity api to cope with renamed record type labels (e.g renaming
  'Target' to 'Directed At')
  ([13008](https://github.com/civicrm/civicrm-core/pull/13008))**

  This change makes it so the Activity API filters activity contacts options
  based on the option name instead of the option label.

- **[dev/core#474](https://lab.civicrm.org/dev/core/issues/474) Missing log
  table warning on status page even if logging is disabled.
  ([13010](https://github.com/civicrm/civicrm-core/pull/13010))**

  This change makes it so that the "Missing log table" warning only shows up if
  logging is enabled.

- **[dev/translation#15](https://lab.civicrm.org/dev/translation/issues/15)
  Backend credit card contribution are left as Pending if contribution statuses
  are localized ([12999](https://github.com/civicrm/civicrm-core/pull/12999))**

  This fixes a bug where backend credit card contributions were being set as
  "Pending" if contribution statuses were localized so that if contributions
  statuses are localized backend credit card contributions are set
  appropriately.

- **api bug - Fix mishandling of mixed case strings in some api requests on
  custom values([12930](https://github.com/civicrm/civicrm-core/pull/12930))**

  This change makes it so that the custom data api searches for custom data with
  uppercase letters correctly.

- **Add ts to untranslated string
  ([12989](https://github.com/civicrm/civicrm-core/pull/12989))**

  This change ensures the text "Error" is translated on error messages thrown
  when processing an image on a contact.

- **[dev/core#459](https://lab.civicrm.org/dev/core/issues/459) Fix "crmURL"
  parameters in various templates
  ([12968](https://github.com/civicrm/civicrm-core/pull/12968))**

  This fixes a bug where some URLs were being generated with double & (e.g.
  `http://civicrm.local/wp-admin/admin.php?page=CiviCRM&q=civicrm/contact/view/delete&&reset=1&delete=1&cid=202`).

- **[dev/core#412](https://lab.civicrm.org/dev/core/issues/412) Avoid truncated
  UTF-8 strings when using substr()
  ([12935](https://github.com/civicrm/civicrm-core/pull/12935))**

  This change fixes a bug where export forms with custom group names with a
  UTF-8 character at the 10th character were not allowing users to pick fields
  to export properly so that one can pick multiple fields for export on the
  export form with custom group names with a UTF-8 character at the 10th
  character.

- **[dev/core#452](https://lab.civicrm.org/dev/core/issues/452) Error when
  exporting CSV batch (PHP 7.1)
  ([12946](https://github.com/civicrm/civicrm-core/pull/12946))**

  This change fixes a bug for users using PHP 7.1 where exporting csv batches
  would crash so that users using PHP 7.1 can export csv batches.

- **Status page: hush menu should be on top of other headers
  ([12936](https://github.com/civicrm/civicrm-core/pull/12936))**

  This change fixes a bug where on the CiviCRM Status Page, when one went to
  hide a status message some of the options in the to hide dropdown menu were
  getting hidden by the header for the next status message so that the dropdown
  menu appears over the status headers.

- **Correct inconsistent fileID reference
  ([12931](https://github.com/civicrm/civicrm-core/pull/12931))**

  This change fixes a bug where updating a custom field of type file on a
  contact thru the api would result in a new file being created instead
  of updating the custom field.

- **Contact layout editor support - Skip html encoding rich-text fields
  ([12841](https://github.com/civicrm/civicrm-core/pull/12841))**

  This change fixes a bug where rich text custom fields saved thru the api were
  being escaped so that the html is preserved (not escaped).

- **[dev/core#418](https://lab.civicrm.org/dev/core/issues/418) ensure all valid
  relationship types are available
  ([12891](https://github.com/civicrm/civicrm-core/pull/12891))**

  This change ensures that the select when adding a relationship to a group of
  search results shows all Relationships types including any relationship types
  that are any contact type to any contact type.

- **[dev/core#389](https://lab.civicrm.org/dev/core/issues/389) When using
  custom fields for smart group criteria, relative dates create static dates
  instead ([12824](https://github.com/civicrm/civicrm-core/pull/12824))**

  This change makes it so that when saving smart groups with custom fields in
  which a relative date (example: last 2 weeks) is specified, the last 2 weeks
  means 2 weeks from the current date and is not hardcoded to be the last 2
  weeks from when the smart group was created.

- **[dev/core#425](https://lab.civicrm.org/dev/core/issues/425) "Force Secure
  URLs" setting sometimes does not behave as expected, deprecate it ... Slowly :)
  ([12908](https://github.com/civicrm/civicrm-core/pull/12908))**

  This change moves forward work to get the "Force Secure URLs" setting to work
  as expected by logging a message if CiviCRM thinks SSL is not enabled.

- **[dev/core#423](https://lab.civicrm.org/dev/core/issues/423) Upgrading gives
  error "Incorrect datetime value: '0000-00-00 00:00:00'" in MySQL 5.7
  ([12898](https://github.com/civicrm/civicrm-core/pull/12898))**

  This change fixes a bug when upgrading from CiviCRM 4.7.12 to 5.3.2 where
  MySQL was throwing an  "Incorrect datetime value: '0000-00-00 00:00:00' for
  column 'trxn_date'" so that upgrades can make this jump with no error.

- **Added missing field name in custom-field deletion dialog
  ([12869](https://github.com/civicrm/civicrm-core/pull/12869))**

  This change ensures that when deleting a custom field, the name of the custom
  field shows up in the dialog asking you to confirm that you want to delete.

- **[dev/core#411](https://lab.civicrm.org/dev/core/issues/411) Default currency
  shown on forms if payment is made with different currency
  ([12875](https://github.com/civicrm/civicrm-core/pull/12875))**

  This change fixes a bug where the default currency was being displayed on the
  View Participant page and Contribution page regardless of which currency was
  used so that the currency used to make the payment is displayed always.

- **Make datatables in Activities Relationship tab adjust to screen size
  ([12893](https://github.com/civicrm/civicrm-core/pull/12893))**

  This change ensures that the datatables on the Activities Relationship tab
  adjusts to screen size when the screen size is changed.

- **Disable ONLY_FULL_GROUP_BY sql mode when doing add2group function on the
  Activity Detail report to avoid fatal error
  ([12966](https://github.com/civicrm/civicrm-core/pull/12966))**

  This fixes a bug where the add to group action on the Activity Details
  report resulted in a fatal error for civicrm instances that had
  ONLY_FULL_GROUP_BY enabled.

- **Problem with Custom Field in Contact Reports
  ([13044](https://github.com/civicrm/civicrm-core/pull/13044))**

  This change makes it so that custom fields of the data type string are
  available in the Summary Fields Filters tab for the Constituent Summary
  report.

- **Fix typo in smarty help
  ([13075](https://github.com/civicrm/civicrm-core/pull/13075))**

- **Remove redundant jstree script from search form
  ([13153](https://github.com/civicrm/civicrm-core/pull/13153))**

### CiviCampaign

- **[dev/core#422](https://lab.civicrm.org/dev/core/issues/422) Can't use
  advanced search to find survey results by result code
  ([12897](https://github.com/civicrm/civicrm-core/pull/12897))**

  This fixes a bug where searching on the "activity result" field (available
  when using CiviCampaign) would result in no results, so that one can search on
  the "activity result" field.

### CiviCase

- **Activities can be linked to multiple cases. Handle caseIds being an array
  ([13021](https://github.com/civicrm/civicrm-core/pull/13021))**

  This change makes it so that an Activity can be linked to more than one case.

### CiviContribute

- **[CRM-21311](https://issues.civicrm.org/jira/browse/CRM-21311) Fix
  CIVICRM-668 Credit card type is unset on submission causing credit card
  payment to fail with CVV validation error message
  ([12615](https://github.com/civicrm/civicrm-core/pull/12615))**

  This change fixes a bug where if one changes the default credit card name for
  a Credit card, for example "Amex" to "American Express" then one cannot create
  a contribution with that credit card type so that one can alter the credit
  card names without breaking contributioning with them.

- **[dev/financial#23](https://lab.civicrm.org/dev/financial/issues/23)
  Submitting a contribution page with 0 amount triggers PHP notices
  ([12926](https://github.com/civicrm/civicrm-core/pull/12926))**

  This change removes an e-notice when submitting a contribution page with a 0
  transaction amount.

- **[dev/core#491](https://lab.civicrm.org/dev/core/issues/491) Report results
  don't show inactive campaigns
  ([13036](https://github.com/civicrm/civicrm-core/pull/13036))**

  This change makes it so that inactive campaigns show up on the Contribution
  Details Report.

- **[dev/core#479](https://lab.civicrm.org/dev/core/issues/479) Contribution
  Summary report throw DB error with custom data and soft credit fields
  ([13017](https://github.com/civicrm/civicrm-core/pull/13017))**

  This change fixes a bug in the Contribution Summary Report where using a soft
  credit amount stats column and a filter on any custom field would result in a
  DB error so that the report runs as expected.

- **[dev/core#526](https://lab.civicrm.org/dev/core/issues/526) Feedback cannot
  be translated when saving Contribution Page forms in languages other than
  English ([13108](https://github.com/civicrm/civicrm-core/pull/13108))**

- **[dev/core#534](https://lab.civicrm.org/dev/core/issues/534) Print Invoice
  and Pay Now buttons do not appear on Contact Dashboard
  ([13131](https://github.com/civicrm/civicrm-core/pull/13131) and
  [13137](https://github.com/civicrm/civicrm-core/pull/13137))**

- **Fix check for financial acls to look for setting rather than sub-key of
  non-standard civicontribute_settings' setting
  ([13150](https://github.com/civicrm/civicrm-core/pull/13150))**

- **[dev/core#552](https://lab.civicrm.org/dev/core/issues/552) Contribution net
  amount not re-calculated when fee amount is changed
  ([13177](https://github.com/civicrm/civicrm-core/pull/13177) and [13178](https://github.com/civicrm/civicrm-core/pull/13178))**

### CiviEvent

- **Prevent hard error when a string is too long for a field.
  ([13014](https://github.com/civicrm/civicrm-core/pull/13014))**

  This change fixes a bug where if an event registration's source field was too
  long for the database, the event registration would fail, so that the source
  field is truncated so that it can be saved to the database.

- **Fix caching issues with Event permissions
  ([12769](https://github.com/civicrm/civicrm-core/pull/12769))**

  This change fixes a bug when checking permissions for events where the
  permissions for the first event were being cached and all subsequent events
  were returned as having no permission regardless of what their permissions
  were.

- **Fix payment hangs when registering a user for a paid event without recording
  payment ([12914](https://github.com/civicrm/civicrm-core/pull/12914))**

  This fixes a bug where registering a user on the back end for a paid event
  without recording a payment would result in the payment hanging so that it
  does not hang.

- **Replace deprecated event function
  ([13093](https://github.com/civicrm/civicrm-core/pull/13093))**

- **Fix links for tabs on manage event
  ([13172](https://github.com/civicrm/civicrm-core/pull/13172))**

### CiviMail

- **[dev/core#461](https://lab.civicrm.org/dev/core/issues/461) Duplicate
  Message template is generated when it is saved through schedule reminder form
  ([12982](https://github.com/civicrm/civicrm-core/pull/12982))**

  This change fixes a bug where saving a message thru the schedule reminder form
  would result in duplicate message templates being created so that the message
  template is only saved once.

- **[CRM-19751](https://issues.civicrm.org/jira/browse/CRM-19751) Once "multiple
  bulk" setting, cannot search for opt out or on hold contacts
  ([12883](https://github.com/civicrm/civicrm-core/pull/12883))**

  This begins work to fix a bug for CiviCRM Instances that have the CiviMail
  setting "Enable multiple bulk email address for a contact" enabled where
  searching for contacts using the criteria "Opt Out" or "On Hold" is filtering
  incorrectly.

- **[dev/core#448](https://lab.civicrm.org/dev/core/issues/448) When creating a
  CiviCRM Mailing including a Smart Group, All contacts met by the criteria of
  the smart group are added. There is no check performed to make sure that
  contacts removed from the smart group aren't included
  ([12945](https://github.com/civicrm/civicrm-core/pull/12945))**

  This change ensures that when creating a CiviCRM Mailing including a Smart
  Group users who have previously un-subscribed from that Smart Group are not
  included.

- **[dev/core#443](https://lab.civicrm.org/dev/core/issues/443) Fix Non-static
  method calls at CRM_Utils_Mail_Incoming class
  ([12934](https://github.com/civicrm/civicrm-core/pull/12934))**

  This change fixes a strict warning thrown by CRM_Utils_Mail_Incoming for users
  with a PHP 7.1 set up.

- **[dev/mail#26](https://lab.civicrm.org/dev/mail/issues/26) getRecipients()
  appears to use a WHERE clause as an ORDER BY clause
  ([12765](https://github.com/civicrm/civicrm-core/pull/12765))**

  This change fixes a bug where the order_by for the list of recipients for a
  mailing was being ignored so that the order by is respected.

- **[dev/core#357](https://lab.civicrm.org/dev/core/issues/357) Email signature
  stopped working since ??? 4.6 ??
  ([12828](https://github.com/civicrm/civicrm-core/pull/12828))**

  This change fixes the Email signature functionality when sending an email.

- **[dev/core#394](https://lab.civicrm.org/dev/core/issues/394) Wildcards are
  ignored in some smart group criteria, when the smart group is directly
  generated for a mailing
  ([12910](https://github.com/civicrm/civicrm-core/pull/12910))**

  This change ensures that wildcards (like %a%) are respected in smart group
  criteria when a smart group is being generated for a mailing.

- **[dev/core#384](https://lab.civicrm.org/dev/core/issues/384) Mobile phone
  number selection issues with SMS
  ([12890](https://github.com/civicrm/civicrm-core/pull/12890))**

  This change makes it so one can send SMS using CiviSMS to non primary phones
  of type "mobile".

### CiviMember

- **[dev/core#166](https://lab.civicrm.org/dev/core/issues/166)
  updateAllMemberships in memberschip BAO crasches out of memory on large
  numbers of members
  ([12306](https://github.com/civicrm/civicrm-core/pull/12306),
  [12927](https://github.com/civicrm/civicrm-core/pull/12927) and
  [12918](https://github.com/civicrm/civicrm-core/pull/12918))**

  These changes fix a bug where for databases with large numbers of memberships
  (the user who reported this problem had 1.3 million memberships) the scheduled task to
  update membership statuses was crashing with an out of memory error so that
  databases with large numbers of memberships can run the scheduled task to
  update membership statuses.

- **Fix period_type, duration_unit, duration_frequency to be required on
  membership type form
  ([13227](https://github.com/civicrm/civicrm-core/pull/13227))**

  These fields had become un-required as a regression in 5.5.

### Drupal Integration

- **Intelligently adjust menubar for D7 toolbar toggle
  ([12937](https://github.com/civicrm/civicrm-core/pull/12937))**

  This change improves the ui by making the Civi menubar set to 100% minus the
  width of the toolbar toggle, but only if the toolbar toggle is actually
  present on the screen. Before this change the menu was set to a width of 97%
  which was problematic because 97% is a guestimate and some Drupal sites do not
  use the toolbar module.

- **Added a path to the drupal8 path candidates to find civicrm.config.php
  ([12903](https://github.com/civicrm/civicrm-core/pull/12903))**

  This change fixes a bug when running the civibuild command `Civibuild
  create drup8 --type=drupal8-clean` would result in a fatal error
  "Failed to locate template for civicrm.config.php" so that Civibuild generates
  the installation files and goes to the next step.

- **[CRM-20298](https://issues.civicrm.org/jira/browse/CRM-20298) Drupal Views:
  Custom fields of type Money should use the same filter operators as Integer
  fields ([435](https://github.com/civicrm/civicrm-drupal/pull/435))**

  This change makes it so that in Drupal views, civicrm custom fields of type
  money use the filter operators for Integers (instead of the filter operators
  for text).

- **civicrm_handler_field_link_pcp: avoid PHP notice
  ([547](https://github.com/civicrm/civicrm-drupal/pull/547))**

  This change fixes a php notice thrown by drupal views that use fields that use
  the handler civicrm_handler_field_link_pcp.

### Wordpress Integration

- **[dev/wordpress#12](https://lab.civicrm.org/dev/wordpress/issues/12) A
  civicrm shortcode for a contribution page on the homepage results in a "Too
  many redirects" error instead of the thank you page
  ([13043](https://github.com/civicrm/civicrm-core/pull/13043))**

  This change fixes a bug where putting a wordpress shortcode on the homepage
  would result in a too many redirect error instead of the thank you page.

- **Allow user-defined shortcode components to be rendered
  ([134](https://github.com/civicrm/civicrm-wordpress/pull/134))**

  This change makes it so that Wordpress plugins and CiviCRM Extensions which
  define custom components for the [civicrm] shortcode, shortcodes work.

- **Do not start session when running under WP-CLI
  ([135](https://github.com/civicrm/civicrm-wordpress/pull/135))**

  This fixes a bug where when running WP-CLI when the Apache user has
  permissions that the shell user does not would result in a PHP Warning.

- **Fix WP-CLI class for PHP 7.2
  ([133](https://github.com/civicrm/civicrm-wordpress/pull/133))**

  This change makes it so one can use WP-CLI in PHP 7.2.

- **[dev/core#460](https://lab.civicrm.org/dev/core/issues/460) Fix malformed
  redirect URLs ([12969](https://github.com/civicrm/civicrm-core/pull/12969))**

  This change fixes a bug where malformed redirect URLs were being formed for
  Wordpress users on event registration and confirmation pages.

- **[dev/wordpress#12](https://lab.civicrm.org/dev/wordpress/issues/12) A
  civicrm shortcode for a contribution page on the homepage results in a "Too
  many redirects" error instead of the thank you page
  ([13099](https://github.com/civicrm/civicrm-core/pull/13099))**

  This resolves a problem retrieving URL parameters when the URL is URL-encoded,
  as frequently happens in WordPress.

## <a name="misc"></a>Miscellany

- **Slay dragons ([12495](https://github.com/civicrm/civicrm-core/pull/12495))**

- **Support CiviTutorial - Fix isAjaxMode to also recognize angular ajax
  ([12921](https://github.com/civicrm/civicrm-core/pull/12921))**

- **(NFC) Fix Namespace issue in Api3DocTrait when calling smarty
  ([13007](https://github.com/civicrm/civicrm-core/pull/13007))**

- **Export code cleanup and testing enhancements - this is an ongoing cleanup
  with an end goal of fixing some known bugs
  ([12586](https://github.com/civicrm/civicrm-core/pull/12586)) and
  ([12864](https://github.com/civicrm/civicrm-core/pull/12864))**

- **Coding practices fix - Improve type checking in getContactPhone and use
  CRM_Utils_Request::r…
  ([12687](https://github.com/civicrm/civicrm-core/pull/12687))**

- **Code cleanup on activity api and activity dashboard query
  ([12994](https://github.com/civicrm/civicrm-core/pull/12994)) and
  ([12949](https://github.com/civicrm/civicrm-core/pull/12949))**

- **Code cleanup in api_v3_CaseTest
  ([12950](https://github.com/civicrm/civicrm-core/pull/12950))**

- **Code cleanup Membership form - submit status message
  ([12693](https://github.com/civicrm/civicrm-core/pull/12693)) and tidy up
  receipt code ([12695](https://github.com/civicrm/civicrm-core/pull/12695))**

- **Code cleanup and testing on query to generate annual totals
  ([12810](https://github.com/civicrm/civicrm-core/pull/12810))**

- **Code cleanup - commenting on  dupesInGroup()
  ([12920](https://github.com/civicrm/civicrm-core/pull/12920))**

- **Code cleanup - Fix spelling error ("sript" vs "script")
  ([12912](https://github.com/civicrm/civicrm-core/pull/12912))**

- **Code cleanup on recurring create action
  ([12900](https://github.com/civicrm/civicrm-core/pull/12900)) and viewing
  recurring rcords
  ([12899](https://github.com/civicrm/civicrm-core/pull/12899))**

- **Code cleanup (drupal) style fix for contact image handler
  ([537](https://github.com/civicrm/civicrm-drupal/pull/537))**

- **Code cleanup (wordpress) Give comments and docblocks some TLC
  ([137](https://github.com/civicrm/civicrm-wordpress/pull/137))**

- **Code cleanup  Fix comment as hook name was changed
  ([13009](https://github.com/civicrm/civicrm-core/pull/13009))**

- **[CRM-21677](https://issues.civicrm.org/jira/browse/CRM-21677) Report code
  style improvements (no user impact)
  ([13028](https://github.com/civicrm/civicrm-core/pull/13028),
  [12922](https://github.com/civicrm/civicrm-core/pull/12922),
  [12916](https://github.com/civicrm/civicrm-core/pull/12916), and
  [12892](https://github.com/civicrm/civicrm-core/pull/12892))**

- **Duplicate upgrade step for 5.7.beta1 in 5.8.alpha1 to capture anyone …
  ([13033](https://github.com/civicrm/civicrm-core/pull/13033))**

- **Don't format date twice for RecurringEntity form
  ([12974](https://github.com/civicrm/civicrm-core/pull/12974))**

- **Add `ext/` folder to .gitignore
  ([12905](https://github.com/civicrm/civicrm-core/pull/12905))**

- **Bring structural consistency to the plugin
  ([138](https://github.com/civicrm/civicrm-wordpress/pull/138))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andrew Hunt; Agileware - Alok Patel; Andrei
Mondoc; Australian Greens - Seamus Lee; calbasi.net - Joan Cervan Andreu; Caltha
- Tomasz Pietrzkowski; CEDC - Laryn Kragt Bakker; Chris Burgess; Christian Wach;
CiviCoop - Klaas Eikelboom; CiviCRM - Coleman Watts, Tim Otten; CiviDesk -
Yashodha Chaku; Community IT Academy - William Mortada; CompuCorp - Davi
Alexandre; Coop SymbioTIC - Mathieu Lutfy, Samuel Vanhove; Derek Lewis;
Electronic Frontier Foundation - Mark Burdett; Fuzion - Jitendra Purohit; Ginkgo
Street Labs - Frank Gómez; Giovanni Dalmas; Jens Schuppe; JMA Consulting -
Monish Deb; John Kingsnorth; Joinery - Allen Shaw; Joost Fock; Ken West;
Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
Nicol Wistreich; OSSeed Technologies - Madhavi Malgaonkar; Pradeep Nayak;
Progressive Technology Project - Jamie McClelland; Skvare - Mark Hanna; Third
Sector Design - Michael McAndrew; Wikimedia Foundation - Eileen McNaughton,
Elliott Eggleston

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Agileware Team; British Humanist Association - Andrew West; Campaign
Against Arms Trade - Kirk Jackson; Circle Interactive - Dave Jenkins; CiviFirst
- John Kirk; Clairepickle; Clare Marsh; CompuCorp - Jamie Novick; Donald Lobo;
iXiam - Vangelis Pantazis; JMA Consulting - Joe Murray; JonScreat; Korlon -
Stuart Gaston; Lighthouse Design and Consulting - Brian Shaughnessy; MJCO -
Mikey O'Toole; Richard van Oosterhout; sleewok; Tadpole Collective - Kevin
Cristiano; Tech To The People - Xavier Dutoit

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
