 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_FIND_GENERATED_FORWARDS_H
#define SEQAN_HEADER_FIND_GENERATED_FORWARDS_H

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AbndmAlgo

struct AbndmAlgo;       	// "projects/library/seqan/find/find_abndm.h"(76)

//____________________________________________________________________________
// AlignTextBanded

struct AlignTextBanded;       	// "projects/library/seqan/find/find_myers_ukkonen.h"(46)

//____________________________________________________________________________
// AlignTextGlobal

struct AlignTextGlobal;       	// "projects/library/seqan/find/find_myers_ukkonen.h"(45)

//____________________________________________________________________________
// AlignTextLocal

struct AlignTextLocal;       	// "projects/library/seqan/find/find_myers_ukkonen.h"(44)

//____________________________________________________________________________
// DPSearch

template <typename TScore> struct DPSearch;       	// "projects/library/seqan/find/find_score.h"(32)

//____________________________________________________________________________
// DefaultFinder

template <typename TObject > struct DefaultFinder;       	// "projects/library/seqan/find/find_base.h"(41)

//____________________________________________________________________________
// DefaultHash

class DefaultHash;       	// "projects/library/seqan/find/find_wumanber.h"(63)

//____________________________________________________________________________
// DefaultPattern

template <typename TObject > struct DefaultPattern;       	// "projects/library/seqan/find/find_base.h"(54)

//____________________________________________________________________________
// FileReader

template <typename TFormat, typename TFile, typename TSpec> struct FileReader;       	// "projects/library/seqan/find/find_horspool.h"(308)

//____________________________________________________________________________
// Finder

template <typename THaystack, typename TSpec > class Finder;       	// "projects/library/seqan/find/find_base.h"(343)

//____________________________________________________________________________
// Haystack

template <typename TFinder> struct Haystack;       	// "projects/library/seqan/find/find_base.h"(69)

//____________________________________________________________________________
// Hierarchical

struct Hierarchical;       	// "projects/library/seqan/find/find_pex.h"(30)

//____________________________________________________________________________
// Index

template <typename TObject, typename TSpec > class Index;       	// "projects/library/seqan/find/find_swift.h"(34)

//____________________________________________________________________________
// Needle

template <typename TPattern> struct Needle;       	// "projects/library/seqan/find/find_base.h"(84)

//____________________________________________________________________________
// NonHierarchical

struct NonHierarchical;       	// "projects/library/seqan/find/find_pex.h"(31)

//____________________________________________________________________________
// Pattern

template <typename TNeedle, typename TSpec > class Pattern;       	// "projects/library/seqan/find/find_base.h"(114)

//____________________________________________________________________________
// Pex

template <typename TVerification, typename TMultiFinder > struct Pex;       	// "projects/library/seqan/find/find_pex.h"(34)

//____________________________________________________________________________
// PexMultiFinder

template <typename T> struct PexMultiFinder;       	// "projects/library/seqan/find/find_pex.h"(53)

//____________________________________________________________________________
// Pipe

//template <typename TInput, typename TSpec > struct Pipe;       	// "projects/library/seqan/find/find_swift.h"(179)

//____________________________________________________________________________
// Swift

template <typename TSpec > struct Swift;       	// "projects/library/seqan/find/find_swift.h"(44)

//____________________________________________________________________________
// SwiftParameters

struct SwiftParameters;       	// "projects/library/seqan/find/find_swift.h"(65)

//____________________________________________________________________________
// WuManber

template <typename THash > class WuManber;       	// "projects/library/seqan/find/find_wumanber.h"(238)

//____________________________________________________________________________
// _AhoCorasick

struct _AhoCorasick;       	// "projects/library/seqan/find/find_ahocorasick.h"(46)

//____________________________________________________________________________
// _BndmAlgo

struct _BndmAlgo;       	// "projects/library/seqan/find/find_bndm.h"(44)

//____________________________________________________________________________
// _BomAlgo

struct _BomAlgo;       	// "projects/library/seqan/find/find_bom.h"(44)

//____________________________________________________________________________
// _Horspool

struct _Horspool;       	// "projects/library/seqan/find/find_horspool.h"(43)

//____________________________________________________________________________
// _MultipatternFinder

struct _MultipatternFinder;       	// "projects/library/seqan/find/find_multi.h"(29)

//____________________________________________________________________________
// _MultipleShiftAnd

struct _MultipleShiftAnd;       	// "projects/library/seqan/find/find_multiple_shiftand.h"(44)

//____________________________________________________________________________
// _MyersUkkonen

template <typename TSpec> struct _MyersUkkonen;       	// "projects/library/seqan/find/find_myers_ukkonen.h"(49)

//____________________________________________________________________________
// _MyersUkkonenHP0

template <typename T> struct _MyersUkkonenHP0;       	// "projects/library/seqan/find/find_myers_ukkonen.h"(62)

//____________________________________________________________________________
// _PexRange

template <typename TPosition,typename TScore,typename TVerifier,typename TNeedle> struct _PexRange;       	// "projects/library/seqan/find/find_pex.h"(64)

//____________________________________________________________________________
// _Quasar

struct _Quasar;       	// "projects/library/seqan/find/find_quasar.h"(33)

//____________________________________________________________________________
// _SetHorspool

struct _SetHorspool;       	// "projects/library/seqan/find/find_set_horspool.h"(44)

//____________________________________________________________________________
// _ShiftAnd

struct _ShiftAnd;       	// "projects/library/seqan/find/find_shiftand.h"(44)

//____________________________________________________________________________
// _ShiftOr

struct _ShiftOr;       	// "projects/library/seqan/find/find_shiftor.h"(44)

//____________________________________________________________________________
// _SwiftBucket

template <typename TSpec, typename TSize, typename TShortSize > struct _SwiftBucket;       	// "projects/library/seqan/find/find_swift.h"(79)

//____________________________________________________________________________
// _SwiftBucketParams

template <typename TSpec, typename TSize, typename TShortSize > struct _SwiftBucketParams;       	// "projects/library/seqan/find/find_swift.h"(98)

//____________________________________________________________________________
// _SwiftHit

template <typename THstkPos> struct _SwiftHit;       	// "projects/library/seqan/find/find_swift.h"(113)

//____________________________________________________________________________
// _SwiftLocal

struct _SwiftLocal;       	// "projects/library/seqan/find/find_swift.h"(36)

//____________________________________________________________________________
// _SwiftSemiGlobal

struct _SwiftSemiGlobal;       	// "projects/library/seqan/find/find_swift.h"(39)

//____________________________________________________________________________
// _WildShiftAnd

struct _WildShiftAnd;       	// "projects/library/seqan/find/find_wild_shiftand.h"(31)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AhoCorasick

typedef Tag<_AhoCorasick> AhoCorasick;       	// "projects/library/seqan/find/find_ahocorasick.h"(47)

//____________________________________________________________________________
// BndmAlgo

typedef Tag<_BndmAlgo> BndmAlgo;       	// "projects/library/seqan/find/find_bndm.h"(45)

//____________________________________________________________________________
// BomAlgo

typedef Tag<_BomAlgo> BomAlgo;       	// "projects/library/seqan/find/find_bom.h"(45)

//____________________________________________________________________________
// Horspool

typedef Tag<_Horspool> Horspool;       	// "projects/library/seqan/find/find_horspool.h"(44)

//____________________________________________________________________________
// MultipatternFinder

typedef Tag<_MultipatternFinder> MultipatternFinder;       	// "projects/library/seqan/find/find_multi.h"(30)

//____________________________________________________________________________
// MultipleShiftAnd

typedef Tag<_MultipleShiftAnd> MultipleShiftAnd;       	// "projects/library/seqan/find/find_multiple_shiftand.h"(45)

//____________________________________________________________________________
// MyersUkkonen

typedef Tag<_MyersUkkonen<AlignTextLocal> >  MyersUkkonen;       	// "projects/library/seqan/find/find_myers_ukkonen.h"(51)

//____________________________________________________________________________
// MyersUkkonenBanded

typedef Tag<_MyersUkkonen<AlignTextBanded> > MyersUkkonenBanded;       	// "projects/library/seqan/find/find_myers_ukkonen.h"(53)

//____________________________________________________________________________
// MyersUkkonenGlobal

typedef Tag<_MyersUkkonen<AlignTextGlobal> > MyersUkkonenGlobal;       	// "projects/library/seqan/find/find_myers_ukkonen.h"(52)

//____________________________________________________________________________
// PexHierarchical

typedef Pex<Hierarchical,AhoCorasick>   PexHierarchical;       	// "projects/library/seqan/find/find_pex.h"(36)

//____________________________________________________________________________
// PexNonHierarchical

typedef Pex<NonHierarchical,AhoCorasick>  PexNonHierarchical;       	// "projects/library/seqan/find/find_pex.h"(37)

//____________________________________________________________________________
// Quasar

typedef Tag<_Quasar> Quasar;       	// "projects/library/seqan/find/find_quasar.h"(34)

//____________________________________________________________________________
// SetHorspool

typedef Tag<_SetHorspool> SetHorspool;       	// "projects/library/seqan/find/find_set_horspool.h"(45)

//____________________________________________________________________________
// ShiftAnd

typedef Tag<_ShiftAnd> ShiftAnd;       	// "projects/library/seqan/find/find_shiftand.h"(45)

//____________________________________________________________________________
// ShiftOr

typedef Tag<_ShiftOr> ShiftOr;       	// "projects/library/seqan/find/find_shiftor.h"(45)

//____________________________________________________________________________
// SwiftLocal

typedef Tag<_SwiftLocal> SwiftLocal;       	// "projects/library/seqan/find/find_swift.h"(37)

//____________________________________________________________________________
// SwiftSemiGlobal

typedef Tag<_SwiftSemiGlobal> SwiftSemiGlobal;       	// "projects/library/seqan/find/find_swift.h"(40)

//____________________________________________________________________________
// WildShiftAnd

typedef Tag<_WildShiftAnd> WildShiftAnd;       	// "projects/library/seqan/find/find_wild_shiftand.h"(32)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _createAcTrie

template <typename TNeedle> inline void _createAcTrie(Pattern<TNeedle, AhoCorasick> & me);       	// "projects/library/seqan/find/find_ahocorasick.h"(120)

//____________________________________________________________________________
// _createTree

template <typename TNeedle, typename TMultiFinder> void _createTree(Pattern<TNeedle, Pex<Hierarchical, TMultiFinder > > &me, unsigned start, unsigned end, unsigned k, unsigned parent, unsigned direction ,unsigned idx, unsigned plen);       	// "projects/library/seqan/find/find_pex.h"(424)

//____________________________________________________________________________
// _dataHost

template <typename TNeedle, typename TSpec> inline Holder<TNeedle> & _dataHost(Pattern<TNeedle, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(143)
template <typename TNeedle, typename TSpec> inline Holder<TNeedle> & _dataHost(Pattern<TNeedle, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(149)

//____________________________________________________________________________
// _findAbndm_LargeNeedle

template <typename TFinder, typename TNeedle> inline bool _findAbndm_LargeNeedle(TFinder & finder, Pattern<TNeedle, AbndmAlgo> & me);       	// "projects/library/seqan/find/find_abndm.h"(371)

//____________________________________________________________________________
// _findAbndm_SmallNeedle

template <typename TFinder, typename TNeedle> inline bool _findAbndm_SmallNeedle(TFinder & finder, Pattern<TNeedle, AbndmAlgo> & me);       	// "projects/library/seqan/find/find_abndm.h"(237)

//____________________________________________________________________________
// _findBndm_LargeNeedle

template <typename TFinder, typename TNeedle> inline bool _findBndm_LargeNeedle(TFinder & finder, Pattern<TNeedle, BndmAlgo> & me);       	// "projects/library/seqan/find/find_bndm.h"(184)

//____________________________________________________________________________
// _findBndm_SmallNeedle

template <typename TFinder, typename TNeedle> inline bool _findBndm_SmallNeedle(TFinder & finder, Pattern<TNeedle, BndmAlgo> & me);       	// "projects/library/seqan/find/find_bndm.h"(160)

//____________________________________________________________________________
// _findMyersLargePatterns

template <typename TFinder, typename TNeedle, typename TSpec> inline bool _findMyersLargePatterns (TFinder & finder, Pattern<TNeedle, Tag<_MyersUkkonen<TSpec> > > & me);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(362)
template <typename TFinder, typename TNeedle, typename TSpec> inline bool _findMyersLargePatterns( TFinder & finder, Pattern<TNeedle, Tag<_MyersUkkonen<AlignTextBanded> > > & me);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(505)

//____________________________________________________________________________
// _findMyersSmallPatterns

template <typename TFinder, typename TNeedle, typename TSpec> inline bool _findMyersSmallPatterns (TFinder & finder, Pattern<TNeedle, Tag<_MyersUkkonen<TSpec> > > & me);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(457)
template <typename TFinder, typename TNeedle> inline bool _findMyersSmallPatterns( TFinder & finder, Pattern<TNeedle, Tag<_MyersUkkonen<AlignTextBanded> > > & me);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(775)

//____________________________________________________________________________
// _findShiftAnd_LargeNeedle

template <typename TFinder, typename TNeedle> inline bool _findShiftAnd_LargeNeedle(TFinder & finder, Pattern<TNeedle, ShiftAnd> & me);       	// "projects/library/seqan/find/find_shiftand.h"(180)
template <typename TFinder, typename TNeedle> bool _findShiftAnd_LargeNeedle(TFinder & finder, Pattern<TNeedle, MultipleShiftAnd> & me);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(313)
template <typename TFinder, typename TNeedle> inline bool _findShiftAnd_LargeNeedle(TFinder & finder, Pattern<TNeedle, WildShiftAnd> & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(590)

//____________________________________________________________________________
// _findShiftAnd_SmallNeedle

template <typename TFinder, typename TNeedle> inline bool _findShiftAnd_SmallNeedle(TFinder & finder, Pattern<TNeedle, ShiftAnd> & me);       	// "projects/library/seqan/find/find_shiftand.h"(160)
template <typename TFinder, typename TNeedle> bool _findShiftAnd_SmallNeedle(TFinder & finder, Pattern<TNeedle, MultipleShiftAnd> & me);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(261)
template <typename TFinder, typename TNeedle> inline bool _findShiftAnd_SmallNeedle(TFinder & finder, Pattern<TNeedle, WildShiftAnd> & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(567)

//____________________________________________________________________________
// _findShiftOr_LargeNeedle

template <typename TFinder, typename TNeedle> bool _findShiftOr_LargeNeedle(TFinder & finder, Pattern<TNeedle, ShiftOr> & me);       	// "projects/library/seqan/find/find_shiftor.h"(212)

//____________________________________________________________________________
// _findShiftOr_SmallNeedle

template <typename TFinder, typename TNeedle> bool _findShiftOr_SmallNeedle(TFinder & finder, Pattern<TNeedle, ShiftOr> & me);       	// "projects/library/seqan/find/find_shiftor.h"(178)

//____________________________________________________________________________
// _find_score_simple_proportional

template <typename TFinder, typename TNeedle, typename TScore> bool _find_score_simple_proportional(TFinder & finder, Pattern<TNeedle, DPSearch<TScore> > & me);       	// "projects/library/seqan/find/find_score.h"(350)

//____________________________________________________________________________
// _finderSetNonEmpty

template <typename T> inline void _finderSetNonEmpty(T & me);       	// "projects/library/seqan/find/find_base.h"(494)
template <typename THaystack, typename TSpec> inline void _finderSetNonEmpty(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(503)

//____________________________________________________________________________
// _getCharacterClass

template <typename TValue,typename TNeedle2> String <unsigned> _getCharacterClass(TNeedle2 const & host,unsigned start,unsigned end);       	// "projects/library/seqan/find/find_wild_shiftand.h"(261)

//____________________________________________________________________________
// _getRoot

template <typename TNeedle, typename TMultiFinder> int _getRoot(Pattern<TNeedle, Pex<NonHierarchical, TMultiFinder > > & me);       	// "projects/library/seqan/find/find_pex.h"(213)
template <typename TNeedle, typename TMultiFinder> int _getRoot(Pattern<TNeedle, Pex<Hierarchical, TMultiFinder > > &);       	// "projects/library/seqan/find/find_pex.h"(220)

//____________________________________________________________________________
// _isInt

inline bool _isInt(String<char> const & number);       	// "projects/library/seqan/find/find_wild_shiftand.h"(99)

//____________________________________________________________________________
// _length_wo_wild

template <typename TNeedle> unsigned _length_wo_wild(TNeedle const & needle);       	// "projects/library/seqan/find/find_wild_shiftand.h"(189)

//____________________________________________________________________________
// _myersCoreSmall

template <typename TWord, typename TAlignSpec> inline int _myersCoreSmall(TWord &VP, TWord &VN, TWord const &bitmap, int scoreBit, Tag<_MyersUkkonen<TAlignSpec> >);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(743)

//____________________________________________________________________________
// _myersCoreSmallDiag

template <typename TWord, typename TAlignSpec> inline int _myersCoreSmallDiag(TWord &VP, TWord &VN, TWord const &bitmap, int scoreBit, Tag<_MyersUkkonen<TAlignSpec> >);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(758)

//____________________________________________________________________________
// _patternFirstInit

template <typename TNeedle, typename TSpec, typename TNeedle2> inline void _patternFirstInit(Pattern<TNeedle, Tag<_MyersUkkonen<TSpec> > > & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(174)
template <typename TNeedle, typename TNeedle2> inline void _patternFirstInit(Pattern<TNeedle, Tag<_MyersUkkonen<AlignTextBanded> > > & me, TNeedle2 & ndl);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(199)

//____________________________________________________________________________
// _patternInit

template <typename TNeedle, typename TSpec, typename TFinder> void _patternInit(Pattern<TNeedle, Tag<_MyersUkkonen<TSpec> > > &me, TFinder &);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(284)
template <typename TNeedle, typename TFinder> void _patternInit(Pattern<TNeedle, Tag<_MyersUkkonen<AlignTextBanded> > > &me, TFinder &finder);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(312)
template <typename TIndex, typename TFloat, typename _TSize, typename TSpec> inline void _patternInit(Pattern<TIndex, Swift<TSpec> > &pattern, TFloat errorRate, _TSize minLengthForAll);       	// "projects/library/seqan/find/find_swift.h"(333)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, Quasar> & me);       	// "projects/library/seqan/find/find_quasar.h"(109)
template <typename TNeedle, typename TFinder, typename TMultiFinder> void _patternInit(Pattern<TNeedle, Pex<NonHierarchical, TMultiFinder > > &me, TFinder &);       	// "projects/library/seqan/find/find_pex.h"(266)
template <typename TNeedle, typename TFinder, typename TMultiFinder> void _patternInit(Pattern<TNeedle, Pex<Hierarchical, TMultiFinder > > &me, TFinder &);       	// "projects/library/seqan/find/find_pex.h"(479)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, ShiftAnd> & me);       	// "projects/library/seqan/find/find_shiftand.h"(130)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, Horspool> &);       	// "projects/library/seqan/find/find_horspool.h"(125)
template <typename TNeedle, typename TScore> inline void _patternInit (Pattern<TNeedle, DPSearch<TScore> > & me);       	// "projects/library/seqan/find/find_score.h"(299)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, MultipleShiftAnd> & me);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(218)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, BomAlgo> & me);       	// "projects/library/seqan/find/find_bom.h"(129)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, ShiftOr> & me);       	// "projects/library/seqan/find/find_shiftor.h"(129)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, WildShiftAnd> & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(518)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, SetHorspool> & me);       	// "projects/library/seqan/find/find_set_horspool.h"(175)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, BndmAlgo> & me);       	// "projects/library/seqan/find/find_bndm.h"(131)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, AhoCorasick> & me);       	// "projects/library/seqan/find/find_ahocorasick.h"(225)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, AbndmAlgo> & me);       	// "projects/library/seqan/find/find_abndm.h"(196)

//____________________________________________________________________________
// _printMask

inline void _printMask(String <unsigned> const & mask,String <char> name);       	// "projects/library/seqan/find/find_abndm.h"(33)
inline void _printMask(String <unsigned> const & mask,unsigned start, unsigned len,String <char> name);       	// "projects/library/seqan/find/find_abndm.h"(46)

//____________________________________________________________________________
// _printR

template <typename TNeedle> void _printR(Pattern<TNeedle, AbndmAlgo> & me);       	// "projects/library/seqan/find/find_abndm.h"(127)

//____________________________________________________________________________
// _printSwiftBuckets

template <typename TNeedle, typename TIndexSpec, typename TSpec > inline void _printSwiftBuckets(Pattern< Index<TNeedle, TIndexSpec>, Swift<TSpec> > &p);       	// "projects/library/seqan/find/find_swift.h"(288)

//____________________________________________________________________________
// _printSwiftParams

template <typename TParams> inline void _printSwiftParams(TParams &bucketParams);       	// "projects/library/seqan/find/find_swift.h"(276)

//____________________________________________________________________________
// _swiftBucketNo

template <typename TIndex, typename TSpec, typename TParams, typename TSize> inline unsigned _swiftBucketNo(Pattern<TIndex, Swift<TSpec> > const &, TParams &bucketParams, TSize seqNo);       	// "projects/library/seqan/find/find_swift.h"(324)

//____________________________________________________________________________
// _swiftBucketParams

template <typename TIndex, typename TSpec, typename TSize> inline typename Pattern<TIndex, Swift<TSpec> >::TBucketParams & _swiftBucketParams(Pattern<TIndex, Swift<TSpec> > & pattern, TSize seqNo);       	// "projects/library/seqan/find/find_swift.h"(314)

//____________________________________________________________________________
// _swiftMultiFlushBuckets

template <typename THaystack, typename TIndex, typename TSpec > inline bool _swiftMultiFlushBuckets( Finder<THaystack, Swift<TSpec> > &finder, Pattern<TIndex, Swift<TSpec> > &pattern);       	// "projects/library/seqan/find/find_swift.h"(612)

//____________________________________________________________________________
// _swiftMultiProcessQGram

template <typename THaystack, typename TIndex, typename TSpec, typename THValue > inline bool _swiftMultiProcessQGram( Finder<THaystack, Swift<TSpec> > &finder, Pattern<TIndex, Swift<TSpec> > &pattern, THValue hash);       	// "projects/library/seqan/find/find_swift.h"(491)

//____________________________________________________________________________
// _validate

template <typename TNeedle2> bool _validate(TNeedle2 const & needle);       	// "projects/library/seqan/find/find_wild_shiftand.h"(111)

//____________________________________________________________________________
// atBegin

template <typename THaystack, typename TSpec> inline bool atBegin(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(513)

//____________________________________________________________________________
// atEnd

template <typename THaystack, typename TSpec> inline bool atEnd(Finder<THaystack, Swift<TSpec> > & me);       	// "projects/library/seqan/find/find_swift.h"(218)
template <typename THaystack, typename TSpec> inline bool atEnd(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(521)

//____________________________________________________________________________
// beginPosition

template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type beginPosition(Finder<THaystack, Swift<TSpec> > & finder);       	// "projects/library/seqan/find/find_swift.h"(720)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type beginPosition(Finder<THaystack, Swift<TSpec> > const & finder);       	// "projects/library/seqan/find/find_swift.h"(728)
template <typename TNeedle, typename TSpec> inline typename Position<Pattern<TNeedle, TSpec> >::Type & beginPosition(Pattern<TNeedle, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(176)
template <typename TNeedle, typename TSpec> inline typename Position<Pattern<TNeedle, TSpec> const >::Type & beginPosition(Pattern<TNeedle, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(182)

//____________________________________________________________________________
// clear

template <typename TNeedle, typename TIndexSpec, typename TSpec> inline void clear(Pattern<Index<TNeedle, TIndexSpec>, Swift<TSpec> > & me);       	// "projects/library/seqan/find/find_swift.h"(692)
template <typename THaystack, typename TSpec> inline void clear(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(484)

//____________________________________________________________________________
// container

template <typename THaystack, typename TSpec> inline typename _Parameter<THaystack>::Type container(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(420)
template <typename THaystack, typename TSpec> inline typename _Parameter<THaystack>::Type container(Finder<THaystack, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(428)

//____________________________________________________________________________
// empty

template <typename TNeedle, typename TIndexSpec, typename TSpec> inline bool empty(Pattern<Index<TNeedle, TIndexSpec>, Swift<TSpec> > & me);       	// "projects/library/seqan/find/find_swift.h"(685)
template <typename THaystack, typename TSpec> inline bool empty(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(476)

//____________________________________________________________________________
// endPosition

template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type endPosition(Finder<THaystack, Swift<TSpec> > & finder);       	// "projects/library/seqan/find/find_swift.h"(738)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type endPosition(Finder<THaystack, Swift<TSpec> > const & finder);       	// "projects/library/seqan/find/find_swift.h"(746)
template <typename TNeedle, typename TSpec> inline typename Position<Pattern<TNeedle, TSpec> >::Type & endPosition(Pattern<TNeedle, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(200)
template <typename TNeedle, typename TSpec> inline typename Position<Pattern<TNeedle, TSpec> const >::Type & endPosition(Pattern<TNeedle, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(206)

//____________________________________________________________________________
// find

template <typename TFinder, typename TNeedle, typename TSpec> inline bool find (TFinder & finder, Pattern<TNeedle, Tag<_MyersUkkonen<TSpec> > > & me);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(961)
template <typename TFinder, typename TNeedle, typename TSpec> inline bool find (TFinder & finder, Pattern<TNeedle, Tag<_MyersUkkonen<TSpec> > > & me, int const k);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(997)
template <typename THaystack, typename TNeedle, typename TIndexSpec, typename TSpec> inline bool find( Finder<THaystack, Swift<TSpec> > &finder, Pattern<Index<TNeedle, TIndexSpec>, Swift<TSpec> > &pattern, double errorRate);       	// "projects/library/seqan/find/find_swift.h"(799)
//template <typename THashes, typename TPipeSpec, typename TNeedle, typename TIndexSpec, typename TSpec> inline bool find( Finder<Pipe<THashes, TPipeSpec>, Swift<TSpec> > &finder, Pattern<Index<TNeedle, TIndexSpec>, Swift<TSpec> > &pattern, double errorRate, bool printDots);       	// "projects/library/seqan/find/find_swift.h"(843)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, Quasar> & me);       	// "projects/library/seqan/find/find_quasar.h"(138)
template <typename TFinder, typename TNeedle, typename TMultiFinder> inline bool find (TFinder & finder, Pattern<TNeedle, Pex<NonHierarchical, TMultiFinder > > & me);       	// "projects/library/seqan/find/find_pex.h"(335)
template <typename TFinder, typename TNeedle, typename TMultiFinder> inline bool find (TFinder & finder, Pattern<TNeedle, Pex<Hierarchical, TMultiFinder > > & me);       	// "projects/library/seqan/find/find_pex.h"(520)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, ShiftAnd> & me);       	// "projects/library/seqan/find/find_shiftand.h"(217)
template <typename TFinder, typename TNeedle2> bool find(TFinder & finder, Pattern<TNeedle2, Horspool> & me);       	// "projects/library/seqan/find/find_horspool.h"(448)
template <typename TFinder, typename TNeedle, typename TScore> inline bool find(TFinder & finder, Pattern<TNeedle, DPSearch<TScore> > & me);       	// "projects/library/seqan/find/find_score.h"(430)
template <typename TFinder, typename TNeedle, typename TScore> inline bool find(TFinder & finder, Pattern<TNeedle, DPSearch<TScore> > & me, int const limit_);       	// "projects/library/seqan/find/find_score.h"(440)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, MultipleShiftAnd> & me);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(386)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, BomAlgo> & me);       	// "projects/library/seqan/find/find_bom.h"(159)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, ShiftOr> & me);       	// "projects/library/seqan/find/find_shiftor.h"(248)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, WildShiftAnd> & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(631)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, SetHorspool> & me);       	// "projects/library/seqan/find/find_set_horspool.h"(213)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, BndmAlgo> & me);       	// "projects/library/seqan/find/find_bndm.h"(229)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, AhoCorasick> & me);       	// "projects/library/seqan/find/find_ahocorasick.h"(263)
template <typename TFinder, typename TNeedle> inline bool find (TFinder & finder, Pattern<TNeedle, AbndmAlgo > & me);       	// "projects/library/seqan/find/find_abndm.h"(575)
template <typename TFinder, typename TNeedle> inline bool find (TFinder & finder, Pattern<TNeedle, AbndmAlgo > & me, int const k);       	// "projects/library/seqan/find/find_abndm.h"(594)

//____________________________________________________________________________
// find_horspool

template <typename TFinder, typename TNeedle2> bool find_horspool(TFinder & finder, Pattern<TNeedle2, Horspool> & me, bool find_first);       	// "projects/library/seqan/find/find_horspool.h"(152)
template <typename TValue, typename TFormat, typename TFile, typename FileReaderTSpec, typename TFinderSpec, typename TNeedle2> bool find_horspool(Finder<String<TValue, FileReader<TFormat, TFile, FileReaderTSpec> >, TFinderSpec > & finder, Pattern<TNeedle2, Horspool> & me, bool find_first);       	// "projects/library/seqan/find/find_horspool.h"(315)

//____________________________________________________________________________
// getScore

template <typename TNeedle, typename TSpec> int getScore(Pattern<TNeedle, Tag<_MyersUkkonen<TSpec> > > & me);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(271)
template <typename TNeedle, typename TVerification, typename TMultiFinder> int getScore(Pattern<TNeedle, Pex<TVerification,TMultiFinder > > & me);       	// "projects/library/seqan/find/find_pex.h"(230)
template <typename TNeedle, typename TScore> inline typename Value<TScore>::Type getScore(Pattern<TNeedle, DPSearch<TScore> > & me);       	// "projects/library/seqan/find/find_score.h"(290)
template <typename TNeedle> int getScore(Pattern<TNeedle, AbndmAlgo > & me);       	// "projects/library/seqan/find/find_abndm.h"(228)

//____________________________________________________________________________
// goBegin

template <typename THaystack, typename TSpec> inline void goBegin(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(531)

//____________________________________________________________________________
// goEnd

template <typename THaystack, typename TSpec> inline void goEnd(Finder<THaystack, Swift<TSpec> > & me);       	// "projects/library/seqan/find/find_swift.h"(225)
template <typename THaystack, typename TSpec> inline void goEnd(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(540)

//____________________________________________________________________________
// haystack

template <typename TObject > inline typename Haystack<TObject>::Type & haystack(TObject &obj);       	// "projects/library/seqan/find/find_base.h"(703)
template <typename TObject > inline typename Haystack<TObject const>::Type & haystack(TObject const &obj);       	// "projects/library/seqan/find/find_base.h"(709)

//____________________________________________________________________________
// host

template <typename TNeedle, typename TSpec> inline typename Host<Pattern<TNeedle, Tag<_MyersUkkonen<TSpec> > > >::Type & host(Pattern<TNeedle, Tag<_MyersUkkonen<TSpec> > > & me);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(227)
template <typename TNeedle, typename TSpec> inline typename Host<Pattern<TNeedle, Tag<_MyersUkkonen<TSpec> > > const>::Type & host(Pattern<TNeedle, Tag<_MyersUkkonen<TSpec> > > const & me);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(235)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, Quasar>const>::Type & host(Pattern<TNeedle, Quasar> & me);       	// "projects/library/seqan/find/find_quasar.h"(119)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, Quasar>const>::Type & host(Pattern<TNeedle, Quasar> const & me);       	// "projects/library/seqan/find/find_quasar.h"(127)
template <typename TNeedle, typename TVerification, typename TMultiFinder> inline typename Host<Pattern<TNeedle, Pex<TVerification,TMultiFinder > > const>::Type & host(Pattern<TNeedle, Pex<TVerification,TMultiFinder > > & me);       	// "projects/library/seqan/find/find_pex.h"(196)
template <typename TNeedle, typename TVerification, typename TMultiFinder> inline typename Host<Pattern<TNeedle, Pex<TVerification,TMultiFinder > > const>::Type & host(Pattern<TNeedle, Pex<TVerification,TMultiFinder > > const & me);       	// "projects/library/seqan/find/find_pex.h"(204)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, ShiftAnd>const>::Type & host(Pattern<TNeedle, ShiftAnd> & me);       	// "projects/library/seqan/find/find_shiftand.h"(142)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, ShiftAnd>const>::Type & host(Pattern<TNeedle, ShiftAnd> const & me);       	// "projects/library/seqan/find/find_shiftand.h"(150)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, Horspool> >::Type & host(Pattern<TNeedle, Horspool> & me);       	// "projects/library/seqan/find/find_horspool.h"(132)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, Horspool> const>::Type & host(Pattern<TNeedle, Horspool> const & me);       	// "projects/library/seqan/find/find_horspool.h"(140)
template <typename THaystack, typename TSpec> inline typename _Parameter<THaystack>::Type host(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(404)
template <typename THaystack, typename TSpec> inline typename _Parameter<THaystack>::Type host(Finder<THaystack, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(412)
template <typename TNeedle, typename TScore> inline typename Host<Pattern<TNeedle, DPSearch<TScore> > >::Type & host(Pattern<TNeedle, DPSearch<TScore> > & me);       	// "projects/library/seqan/find/find_score.h"(144)
template <typename TNeedle, typename TScore> inline typename Host<Pattern<TNeedle, DPSearch<TScore> > const>::Type & host(Pattern<TNeedle, DPSearch<TScore> > const & me);       	// "projects/library/seqan/find/find_score.h"(152)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, MultipleShiftAnd>const>::Type & host(Pattern<TNeedle, MultipleShiftAnd> & me);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(236)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, MultipleShiftAnd>const>::Type & host(Pattern<TNeedle, MultipleShiftAnd> const & me);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(244)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, BomAlgo>const>::Type & host(Pattern<TNeedle, BomAlgo> & me);       	// "projects/library/seqan/find/find_bom.h"(140)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, BomAlgo>const>::Type & host(Pattern<TNeedle, BomAlgo> const & me);       	// "projects/library/seqan/find/find_bom.h"(148)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, ShiftOr>const>::Type & host(Pattern<TNeedle, ShiftOr> & me);       	// "projects/library/seqan/find/find_shiftor.h"(143)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, ShiftOr>const>::Type & host(Pattern<TNeedle, ShiftOr> const & me);       	// "projects/library/seqan/find/find_shiftor.h"(151)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, WildShiftAnd>const>::Type & host(Pattern<TNeedle, WildShiftAnd> & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(550)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, WildShiftAnd>const>::Type & host(Pattern<TNeedle, WildShiftAnd> const & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(558)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, SetHorspool>const>::Type & host(Pattern<TNeedle, SetHorspool> & me);       	// "projects/library/seqan/find/find_set_horspool.h"(188)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, SetHorspool>const>::Type & host(Pattern<TNeedle, SetHorspool> const & me);       	// "projects/library/seqan/find/find_set_horspool.h"(196)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, BndmAlgo>const>::Type & host(Pattern<TNeedle, BndmAlgo> & me);       	// "projects/library/seqan/find/find_bndm.h"(143)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, BndmAlgo>const>::Type & host(Pattern<TNeedle, BndmAlgo> const & me);       	// "projects/library/seqan/find/find_bndm.h"(151)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, AhoCorasick>const>::Type & host(Pattern<TNeedle, AhoCorasick> & me);       	// "projects/library/seqan/find/find_ahocorasick.h"(238)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, AhoCorasick>const>::Type & host(Pattern<TNeedle, AhoCorasick> const & me);       	// "projects/library/seqan/find/find_ahocorasick.h"(246)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, AbndmAlgo>const>::Type & host(Pattern<TNeedle, AbndmAlgo> & me);       	// "projects/library/seqan/find/find_abndm.h"(209)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, AbndmAlgo>const>::Type & host(Pattern<TNeedle, AbndmAlgo> const & me);       	// "projects/library/seqan/find/find_abndm.h"(217)

//____________________________________________________________________________
// hostIterator

template <typename THaystack, typename TSpec> inline typename Iterator<THaystack, Rooted>::Type & hostIterator(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(458)
template <typename THaystack, typename TSpec> inline typename Iterator<THaystack, Rooted>::Type const & hostIterator(Finder<THaystack, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(466)

//____________________________________________________________________________
// needle

template <typename TObject > inline typename Needle<TObject>::Type & needle(TObject &obj);       	// "projects/library/seqan/find/find_base.h"(252)
template <typename TObject > inline typename Needle<TObject const>::Type & needle(TObject const &obj);       	// "projects/library/seqan/find/find_base.h"(259)
template <typename TNeedle, typename TSpec > inline typename Needle< Pattern<TNeedle, TSpec> >::Type & needle(Pattern<TNeedle, TSpec> & obj);       	// "projects/library/seqan/find/find_base.h"(269)
template <typename TNeedle, typename TSpec > inline typename Needle< Pattern<TNeedle, TSpec> const>::Type & needle(Pattern<TNeedle, TSpec> const & obj);       	// "projects/library/seqan/find/find_base.h"(276)

//____________________________________________________________________________
// operator+

template <typename THaystack, typename TSpec, typename TIntegral> inline Finder<THaystack, TSpec> const operator+ (Finder<THaystack, TSpec> const & left, TIntegral right);       	// "projects/library/seqan/find/find_base.h"(617)

//____________________________________________________________________________
// operator++

template <typename THaystack, typename TSpec> inline Finder<THaystack, TSpec> & operator++(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(601)

//____________________________________________________________________________
// operator+=

template <typename THaystack, typename TSpec, typename TIntegral> inline Finder<THaystack, TSpec> & operator+= (Finder<THaystack, TSpec> & left, TIntegral right);       	// "projects/library/seqan/find/find_base.h"(630)

//____________________________________________________________________________
// operator-

template <typename THaystack, typename TSpec, typename TIntegral> inline Finder<THaystack, TSpec> const operator- (Finder<THaystack, TSpec> const & left, TIntegral right);       	// "projects/library/seqan/find/find_base.h"(643)
template <typename THaystack, typename TSpec, typename TIntegral> inline typename Difference<Finder<THaystack, TSpec> const>::Type operator- (Finder<THaystack, TSpec> const & left, Finder<THaystack, TSpec> const & right);       	// "projects/library/seqan/find/find_base.h"(651)

//____________________________________________________________________________
// operator--

template <typename THaystack, typename TSpec> inline Finder<THaystack, TSpec> & operator--(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(592)

//____________________________________________________________________________
// operator-=

template <typename THaystack, typename TSpec, typename TIntegral> inline Finder<THaystack, TSpec> & operator-= (Finder<THaystack, TSpec> & left, TIntegral right);       	// "projects/library/seqan/find/find_base.h"(664)

//____________________________________________________________________________
// position

template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type position(Finder<THaystack, Swift<TSpec> > & finder);       	// "projects/library/seqan/find/find_swift.h"(702)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type position(Finder<THaystack, Swift<TSpec> > const & finder);       	// "projects/library/seqan/find/find_swift.h"(710)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, TSpec> >::Type position(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(551)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, TSpec> >::Type position(Finder<THaystack, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(560)
template <typename TNeedle> inline typename Size<TNeedle>::Type position(Pattern<TNeedle, MultipleShiftAnd> & me);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(255)
template <typename TNeedle> inline typename Size<TNeedle>::Type position(Pattern<TNeedle, SetHorspool> & me);       	// "projects/library/seqan/find/find_set_horspool.h"(207)
template <typename TNeedle> inline typename Size<TNeedle>::Type position(Pattern<TNeedle, AhoCorasick> & me);       	// "projects/library/seqan/find/find_ahocorasick.h"(257)

//____________________________________________________________________________
// range

template <typename THaystack, typename TSpec> inline typename Infix<THaystack>::Type range(Finder<THaystack, Swift<TSpec> > &finder);       	// "projects/library/seqan/find/find_swift.h"(756)
template <typename THaystack, typename TSpec, typename TText> inline typename Infix<TText>::Type range(Finder<THaystack, Swift<TSpec> > &finder, TText &text);       	// "projects/library/seqan/find/find_swift.h"(772)
template <typename TNeedle, typename TIndexSpec, typename TSpec> inline typename Value<TNeedle>::Type & range(Pattern<Index<TNeedle, TIndexSpec>, Swift<TSpec> > &pattern);       	// "projects/library/seqan/find/find_swift.h"(788)

//____________________________________________________________________________
// scoreLimit

template <typename TNeedle, typename TSpec> inline int scoreLimit(Pattern<TNeedle, Tag<_MyersUkkonen<TSpec> > > const & me);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(247)
template <typename TNeedle, typename TVerification, typename TMultiFinder> inline int scoreLimit(Pattern<TNeedle, Pex<TVerification,TMultiFinder > > const & me);       	// "projects/library/seqan/find/find_pex.h"(241)
template <typename TNeedle, typename TScore> inline typename Value<TScore>::Type scoreLimit(Pattern<TNeedle, DPSearch<TScore> > const & me);       	// "projects/library/seqan/find/find_score.h"(245)
template <typename TNeedle> inline int scoreLimit(Pattern<TNeedle, AbndmAlgo > const & me);       	// "projects/library/seqan/find/find_abndm.h"(551)

//____________________________________________________________________________
// scoringScheme

template <typename TNeedle, typename TScore> inline TScore const & scoringScheme(Pattern<TNeedle, DPSearch<TScore> > & me);       	// "projects/library/seqan/find/find_score.h"(193)

//____________________________________________________________________________
// segment

template <typename TNeedle, typename TSpec> inline typename Infix<TNeedle>::Type segment(Pattern<TNeedle, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(223)
template <typename TNeedle, typename TSpec> inline typename Infix<TNeedle>::Type segment(Pattern<TNeedle, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(230)

//____________________________________________________________________________
// setBeginPosition

template <typename TNeedle, typename TSpec, typename TPosition> inline void setBeginPosition(Pattern<TNeedle, TSpec> & me, TPosition _pos);       	// "projects/library/seqan/find/find_base.h"(191)

//____________________________________________________________________________
// setContainer

template <typename THaystack, typename TSpec> inline void setContainer(Finder<THaystack, TSpec> & me, typename _Parameter<THaystack>::Type container_);       	// "projects/library/seqan/find/find_base.h"(447)

//____________________________________________________________________________
// setEndPosition

template <typename TNeedle, typename TSpec, typename TPosition> inline void setEndPosition(Pattern<TNeedle, TSpec> & me, TPosition _pos);       	// "projects/library/seqan/find/find_base.h"(214)

//____________________________________________________________________________
// setHaystack

template <typename THaystack, typename TSpec > inline void setHaystack(Finder<THaystack, TSpec> &obj, THaystack const &hstk);       	// "projects/library/seqan/find/find_base.h"(686)

//____________________________________________________________________________
// setHost

template <typename TNeedle, typename TSpec, typename TNeedle2> void setHost(Pattern<TNeedle, Tag<_MyersUkkonen<TSpec> > > & me, TNeedle2 & ndl);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(209)
template <typename TNeedle, typename TSpec, typename TNeedle2> void setHost(Pattern<TNeedle, Tag<_MyersUkkonen<TSpec> > > & me, TNeedle2 const & ndl);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(217)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, Quasar> & me, TNeedle2 const& needle);       	// "projects/library/seqan/find/find_quasar.h"(92)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, Quasar> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_quasar.h"(100)
template <typename TNeedle, typename TNeedle2, typename TVerification, typename TMultiFinder> void setHost (Pattern<TNeedle, Pex<TVerification,TMultiFinder > > & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_pex.h"(176)
template <typename TNeedle, typename TNeedle2, typename TVerification, typename TMultiFinder> void setHost (Pattern<TNeedle, Pex<TVerification,TMultiFinder > > & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_pex.h"(187)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, ShiftAnd> & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_shiftand.h"(80)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, ShiftAnd> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_shiftand.h"(121)
template <typename TNeedle, typename TNeedle2> void setHost(Pattern<TNeedle, Horspool> & me, TNeedle2 const & ndl);       	// "projects/library/seqan/find/find_horspool.h"(86)
template <typename TNeedle, typename TNeedle2> void setHost(Pattern<TNeedle, Horspool> & horsp, TNeedle2 & ndl);       	// "projects/library/seqan/find/find_horspool.h"(117)
template <typename TNeedle, typename TSpec, typename TNeedle2> inline void setHost(Pattern<TNeedle, TSpec> & me, TNeedle2 const & ndl);       	// "projects/library/seqan/find/find_base.h"(161)
template <typename TNeedle, typename TSpec, typename TNeedle2> inline void setHost(Pattern<TNeedle, TSpec> & me, TNeedle2 & ndl);       	// "projects/library/seqan/find/find_base.h"(168)
template <typename THaystack, typename TSpec> inline void setHost(Finder<THaystack, TSpec> & me, typename _Parameter<THaystack>::Type container_);       	// "projects/library/seqan/find/find_base.h"(438)
template <typename TNeedle, typename TScore, typename TNeedle2> void setHost(Pattern<TNeedle, DPSearch<TScore> > & me, TNeedle2 & ndl);       	// "projects/library/seqan/find/find_score.h"(164)
template <typename TNeedle, typename TScore, typename TNeedle2> void setHost(Pattern<TNeedle, DPSearch<TScore> > & me, TNeedle2 const & ndl);       	// "projects/library/seqan/find/find_score.h"(172)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, MultipleShiftAnd> & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(124)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, MultipleShiftAnd> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(209)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, BomAlgo> & me, TNeedle2 const& needle);       	// "projects/library/seqan/find/find_bom.h"(108)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, BomAlgo> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_bom.h"(120)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, ShiftOr> & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_shiftor.h"(79)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, ShiftOr> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_shiftor.h"(120)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, WildShiftAnd> & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_wild_shiftand.h"(289)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, WildShiftAnd> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_wild_shiftand.h"(509)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, SetHorspool> & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_set_horspool.h"(112)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, SetHorspool> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_set_horspool.h"(166)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, BndmAlgo> & me, TNeedle2 const& needle);       	// "projects/library/seqan/find/find_bndm.h"(82)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, BndmAlgo> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_bndm.h"(122)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, AhoCorasick> & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_ahocorasick.h"(187)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, AhoCorasick> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_ahocorasick.h"(216)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, AbndmAlgo> & me, TNeedle2 const& needle);       	// "projects/library/seqan/find/find_abndm.h"(140)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, AbndmAlgo> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_abndm.h"(188)

//____________________________________________________________________________
// setNeedle

template <typename TNeedle, typename TSpec > inline void setNeedle(Pattern<TNeedle, TSpec> &obj, TNeedle const &ndl);       	// "projects/library/seqan/find/find_base.h"(293)

//____________________________________________________________________________
// setPosition

template <typename THaystack, typename TSpec, typename TPosition> inline void setPosition(Finder<THaystack, TSpec> & me, TPosition pos_);       	// "projects/library/seqan/find/find_base.h"(582)

//____________________________________________________________________________
// setScoreLimit

template <typename TNeedle, typename TSpec, typename TScoreValue> inline void setScoreLimit(Pattern<TNeedle, Tag<_MyersUkkonen<TSpec> > > & me, TScoreValue _limit);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(260)
template <typename TNeedle, typename TScoreValue,typename TVerification, typename TMultiFinder> inline void setScoreLimit(Pattern<TNeedle, Pex<TVerification,TMultiFinder > > & me, TScoreValue _limit);       	// "projects/library/seqan/find/find_pex.h"(254)
template <typename TNeedle, typename TScore, typename TScoreValue> inline void setScoreLimit(Pattern<TNeedle, DPSearch<TScore> > & me, TScoreValue _limit);       	// "projects/library/seqan/find/find_score.h"(266)
template <typename TNeedle, typename TScoreValue> inline void setScoreLimit(Pattern<TNeedle, AbndmAlgo > & me, TScoreValue _limit);       	// "projects/library/seqan/find/find_abndm.h"(564)

//____________________________________________________________________________
// setScoringScheme

template <typename TNeedle, typename TScore, typename TScore2> inline void setScoringScheme(Pattern<TNeedle, DPSearch<TScore> > & me, TScore2 & score);       	// "projects/library/seqan/find/find_score.h"(215)
template <typename TNeedle, typename TScore, typename TScore2> inline void setScoringScheme(Pattern<TNeedle, DPSearch<TScore> > & me, TScore2 const & score);       	// "projects/library/seqan/find/find_score.h"(224)

//____________________________________________________________________________
// valid

template <typename TNeedle> inline bool valid(Pattern <TNeedle,WildShiftAnd> & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(531)
template <typename TNeedle> inline bool valid(Pattern <TNeedle,WildShiftAnd> const & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(539)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

