# Contributing to Eclipse Trace Compass

Thanks for your interest in this project.

## Project description

Eclipse Trace Compass™ is an open source application to solve performance and
reliability issues by reading and analyzing logs or traces of a system. Its goal
is to provide views, graphs, metrics, and more to help extract useful
information from traces, in a way that is more user-friendly and informative
than huge text dumps.

* https://projects.eclipse.org/projects/tools.tracecompass

## Developer resources

Information regarding source code management, builds, coding standards, and
more.

* https://projects.eclipse.org/projects/tools.tracecompass/developer

The project maintains the following source code repositories

* https://git.eclipse.org/r/plugins/gitiles/tracecompass/org.eclipse.tracecompass

This project uses Bugzilla to track ongoing development and issues.

* Search for issues:
   https://bugs.eclipse.org/bugs/buglist.cgi?product=Tracecompass
* Create a new report:
   https://bugs.eclipse.org/bugs/enter_bug.cgi?product=Tracecompass

Be sure to search for existing bugs before you create another one. Remember that
contributions are always welcome!

## Eclipse Development Process

This Eclipse Foundation open project is governed by the Eclipse Foundation
Development Process and operates under the terms of the Eclipse IP Policy.

* https://eclipse.org/projects/dev_process
* https://www.eclipse.org/org/documents/Eclipse_IP_Policy.pdf

## Eclipse Contributor Agreement

In order to be able to contribute to Eclipse Foundation projects you must
electronically sign the Eclipse Contributor Agreement (ECA).

* http://www.eclipse.org/legal/ECA.php

The ECA provides the Eclipse Foundation with a permanent record that you agree
that each of your contributions will comply with the commitments documented in
the Developer Certificate of Origin (DCO). Having an ECA on file associated with
the email address matching the "Author" field of your contribution's Git commits
fulfills the DCO's requirement that you sign-off on your contributions.

For more information, please see the Eclipse Committer Handbook:
https://www.eclipse.org/projects/handbook/#resources-commit

## Contact

Contact the project developers via the project's "dev" list.

* https://dev.eclipse.org/mailman/listinfo/tracecompass-dev

