/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.ImageTools;
import loci.formats.out.ImageIOWriter;

public class JPEGWriter
extends ImageIOWriter {
    public JPEGWriter() {
        super("Joint Photographic Experts Group", new String[]{"jpg", "jpeg", "jpe"}, "jpeg");
    }

    public void saveImage(Image image, boolean last) throws FormatException, IOException {
        BufferedImage img = this.cm == null ? ImageTools.makeBuffered(image) : ImageTools.makeBuffered(image, this.cm);
        int type = ImageTools.getPixelType(img);
        if (type == 3 || type == 2) {
            throw new FormatException("16-bit data not supported.");
        }
        super.saveImage(image, last);
    }

    public int[] getPixelTypes() {
        return new int[]{1};
    }
}

