/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueBrowser;
import javax.jms.QueueRequestor;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.IllegalStateException;
import org.springframework.jms.InvalidClientIDException;
import org.springframework.jms.InvalidDestinationException;
import org.springframework.jms.InvalidSelectorException;
import org.springframework.jms.JmsException;
import org.springframework.jms.JmsSecurityException;
import org.springframework.jms.MessageEOFException;
import org.springframework.jms.MessageFormatException;
import org.springframework.jms.MessageNotReadableException;
import org.springframework.jms.MessageNotWriteableException;
import org.springframework.jms.ResourceAllocationException;
import org.springframework.jms.TransactionInProgressException;
import org.springframework.jms.TransactionRolledBackException;
import org.springframework.jms.UncategorizedJmsException;
import org.springframework.util.Assert;

public abstract class JmsUtils {
    private static final Log logger = LogFactory.getLog(JmsUtils.class);

    public static void closeConnection(Connection con) {
        JmsUtils.closeConnection(con, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeConnection(Connection con, boolean stop) {
        block8: {
            if (con != null) {
                try {
                    if (stop) {
                        try {
                            con.stop();
                            break block8;
                        }
                        finally {
                            con.close();
                        }
                    }
                    con.close();
                }
                catch (JMSException ex) {
                    logger.debug("Could not close JMS Connection", ex);
                }
                catch (Throwable ex) {
                    logger.debug("Unexpected exception on closing JMS Connection", ex);
                }
            }
        }
    }

    public static void closeSession(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (JMSException ex) {
                logger.debug("Could not close JMS Session", ex);
            }
            catch (Throwable ex) {
                logger.debug("Unexpected exception on closing JMS Session", ex);
            }
        }
    }

    public static void closeMessageProducer(MessageProducer producer) {
        if (producer != null) {
            try {
                producer.close();
            }
            catch (JMSException ex) {
                logger.debug("Could not close JMS MessageProducer", ex);
            }
            catch (Throwable ex) {
                logger.debug("Unexpected exception on closing JMS MessageProducer", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeMessageConsumer(MessageConsumer consumer) {
        if (consumer != null) {
            boolean wasInterrupted = Thread.interrupted();
            try {
                consumer.close();
            }
            catch (JMSException ex) {
                logger.debug("Could not close JMS MessageConsumer", ex);
            }
            catch (Throwable ex) {
                logger.debug("Unexpected exception on closing JMS MessageConsumer", ex);
            }
            finally {
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static void closeQueueBrowser(QueueBrowser browser) {
        if (browser != null) {
            try {
                browser.close();
            }
            catch (JMSException ex) {
                logger.debug("Could not close JMS QueueBrowser", ex);
            }
            catch (Throwable ex) {
                logger.debug("Unexpected exception on closing JMS QueueBrowser", ex);
            }
        }
    }

    public static void closeQueueRequestor(QueueRequestor requestor) {
        if (requestor != null) {
            try {
                requestor.close();
            }
            catch (JMSException ex) {
                logger.debug("Could not close JMS QueueRequestor", ex);
            }
            catch (Throwable ex) {
                logger.debug("Unexpected exception on closing JMS QueueRequestor", ex);
            }
        }
    }

    public static void commitIfNecessary(Session session) throws JMSException {
        Assert.notNull(session, "Session must not be null");
        try {
            session.commit();
        }
        catch (javax.jms.TransactionInProgressException ex) {
        }
        catch (javax.jms.IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void rollbackIfNecessary(Session session) throws JMSException {
        Assert.notNull(session, "Session must not be null");
        try {
            session.rollback();
        }
        catch (javax.jms.TransactionInProgressException ex) {
        }
        catch (javax.jms.IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static JmsException convertJmsAccessException(JMSException ex) {
        Assert.notNull((Object)ex, "JMSException must not be null");
        if (ex instanceof javax.jms.IllegalStateException) {
            return new IllegalStateException((javax.jms.IllegalStateException)((Object)ex));
        }
        if (ex instanceof javax.jms.InvalidClientIDException) {
            return new InvalidClientIDException((javax.jms.InvalidClientIDException)ex);
        }
        if (ex instanceof javax.jms.InvalidDestinationException) {
            return new InvalidDestinationException((javax.jms.InvalidDestinationException)ex);
        }
        if (ex instanceof javax.jms.InvalidSelectorException) {
            return new InvalidSelectorException((javax.jms.InvalidSelectorException)ex);
        }
        if (ex instanceof JMSSecurityException) {
            return new JmsSecurityException((JMSSecurityException)ex);
        }
        if (ex instanceof javax.jms.MessageEOFException) {
            return new MessageEOFException((javax.jms.MessageEOFException)ex);
        }
        if (ex instanceof javax.jms.MessageFormatException) {
            return new MessageFormatException((javax.jms.MessageFormatException)ex);
        }
        if (ex instanceof javax.jms.MessageNotReadableException) {
            return new MessageNotReadableException((javax.jms.MessageNotReadableException)ex);
        }
        if (ex instanceof javax.jms.MessageNotWriteableException) {
            return new MessageNotWriteableException((javax.jms.MessageNotWriteableException)ex);
        }
        if (ex instanceof javax.jms.ResourceAllocationException) {
            return new ResourceAllocationException((javax.jms.ResourceAllocationException)ex);
        }
        if (ex instanceof javax.jms.TransactionInProgressException) {
            return new TransactionInProgressException((javax.jms.TransactionInProgressException)((Object)ex));
        }
        if (ex instanceof javax.jms.TransactionRolledBackException) {
            return new TransactionRolledBackException((javax.jms.TransactionRolledBackException)((Object)ex));
        }
        return new UncategorizedJmsException(ex);
    }
}

