/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "gf-sn-watcher-v0-gen.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.kde.StatusNotifierWatcher
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GfSnWatcherV0Gen
 * @title: GfSnWatcherV0Gen
 * @short_description: Generated C code for the org.kde.StatusNotifierWatcher D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-kde-StatusNotifierWatcher.top_of_page">org.kde.StatusNotifierWatcher</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.kde.StatusNotifierWatcher ---- */

static const _ExtendedGDBusArgInfo _gf_sn_watcher_v0_gen_method_info_register_item_IN_ARG_service =
{
  {
    -1,
    (gchar *) "service",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_sn_watcher_v0_gen_method_info_register_item_IN_ARG_pointers[] =
{
  &_gf_sn_watcher_v0_gen_method_info_register_item_IN_ARG_service.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_sn_watcher_v0_gen_method_info_register_item =
{
  {
    -1,
    (gchar *) "RegisterStatusNotifierItem",
    (GDBusArgInfo **) &_gf_sn_watcher_v0_gen_method_info_register_item_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-register-item",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_sn_watcher_v0_gen_method_info_register_host_IN_ARG_service =
{
  {
    -1,
    (gchar *) "service",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_sn_watcher_v0_gen_method_info_register_host_IN_ARG_pointers[] =
{
  &_gf_sn_watcher_v0_gen_method_info_register_host_IN_ARG_service.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_sn_watcher_v0_gen_method_info_register_host =
{
  {
    -1,
    (gchar *) "RegisterStatusNotifierHost",
    (GDBusArgInfo **) &_gf_sn_watcher_v0_gen_method_info_register_host_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-register-host",
  FALSE
};

static const GDBusMethodInfo * const _gf_sn_watcher_v0_gen_method_info_pointers[] =
{
  &_gf_sn_watcher_v0_gen_method_info_register_item.parent_struct,
  &_gf_sn_watcher_v0_gen_method_info_register_host.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gf_sn_watcher_v0_gen_signal_info_item_registered_ARG_service =
{
  {
    -1,
    (gchar *) "service",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_sn_watcher_v0_gen_signal_info_item_registered_ARG_pointers[] =
{
  &_gf_sn_watcher_v0_gen_signal_info_item_registered_ARG_service.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gf_sn_watcher_v0_gen_signal_info_item_registered =
{
  {
    -1,
    (gchar *) "StatusNotifierItemRegistered",
    (GDBusArgInfo **) &_gf_sn_watcher_v0_gen_signal_info_item_registered_ARG_pointers,
    NULL
  },
  "item-registered"
};

static const _ExtendedGDBusArgInfo _gf_sn_watcher_v0_gen_signal_info_item_unregistered_ARG_service =
{
  {
    -1,
    (gchar *) "service",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_sn_watcher_v0_gen_signal_info_item_unregistered_ARG_pointers[] =
{
  &_gf_sn_watcher_v0_gen_signal_info_item_unregistered_ARG_service.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gf_sn_watcher_v0_gen_signal_info_item_unregistered =
{
  {
    -1,
    (gchar *) "StatusNotifierItemUnregistered",
    (GDBusArgInfo **) &_gf_sn_watcher_v0_gen_signal_info_item_unregistered_ARG_pointers,
    NULL
  },
  "item-unregistered"
};

static const _ExtendedGDBusSignalInfo _gf_sn_watcher_v0_gen_signal_info_host_registered =
{
  {
    -1,
    (gchar *) "StatusNotifierHostRegistered",
    NULL,
    NULL
  },
  "host-registered"
};

static const GDBusSignalInfo * const _gf_sn_watcher_v0_gen_signal_info_pointers[] =
{
  &_gf_sn_watcher_v0_gen_signal_info_item_registered.parent_struct,
  &_gf_sn_watcher_v0_gen_signal_info_item_unregistered.parent_struct,
  &_gf_sn_watcher_v0_gen_signal_info_host_registered.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _gf_sn_watcher_v0_gen_property_info_registered_items =
{
  {
    -1,
    (gchar *) "RegisteredStatusNotifierItems",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "registered-items",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gf_sn_watcher_v0_gen_property_info_is_host_registered =
{
  {
    -1,
    (gchar *) "IsStatusNotifierHostRegistered",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "is-host-registered",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gf_sn_watcher_v0_gen_property_info_protocol_version =
{
  {
    -1,
    (gchar *) "ProtocolVersion",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "protocol-version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _gf_sn_watcher_v0_gen_property_info_pointers[] =
{
  &_gf_sn_watcher_v0_gen_property_info_registered_items.parent_struct,
  &_gf_sn_watcher_v0_gen_property_info_is_host_registered.parent_struct,
  &_gf_sn_watcher_v0_gen_property_info_protocol_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gf_sn_watcher_v0_gen_interface_info =
{
  {
    -1,
    (gchar *) "org.kde.StatusNotifierWatcher",
    (GDBusMethodInfo **) &_gf_sn_watcher_v0_gen_method_info_pointers,
    (GDBusSignalInfo **) &_gf_sn_watcher_v0_gen_signal_info_pointers,
    (GDBusPropertyInfo **) &_gf_sn_watcher_v0_gen_property_info_pointers,
    NULL
  },
  "sn-watcher-v0-gen",
};


/**
 * gf_sn_watcher_v0_gen_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-kde-StatusNotifierWatcher.top_of_page">org.kde.StatusNotifierWatcher</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gf_sn_watcher_v0_gen_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gf_sn_watcher_v0_gen_interface_info.parent_struct;
}

/**
 * gf_sn_watcher_v0_gen_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GfSnWatcherV0Gen interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gf_sn_watcher_v0_gen_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "registered-items");
  g_object_class_override_property (klass, property_id_begin++, "is-host-registered");
  g_object_class_override_property (klass, property_id_begin++, "protocol-version");
  return property_id_begin - 1;
}



/**
 * GfSnWatcherV0Gen:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-kde-StatusNotifierWatcher.top_of_page">org.kde.StatusNotifierWatcher</link>.
 */

/**
 * GfSnWatcherV0GenIface:
 * @parent_iface: The parent interface.
 * @handle_register_host: Handler for the #GfSnWatcherV0Gen::handle-register-host signal.
 * @handle_register_item: Handler for the #GfSnWatcherV0Gen::handle-register-item signal.
 * @get_is_host_registered: Getter for the #GfSnWatcherV0Gen:is-host-registered property.
 * @get_protocol_version: Getter for the #GfSnWatcherV0Gen:protocol-version property.
 * @get_registered_items: Getter for the #GfSnWatcherV0Gen:registered-items property.
 * @host_registered: Handler for the #GfSnWatcherV0Gen::host-registered signal.
 * @item_registered: Handler for the #GfSnWatcherV0Gen::item-registered signal.
 * @item_unregistered: Handler for the #GfSnWatcherV0Gen::item-unregistered signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-kde-StatusNotifierWatcher.top_of_page">org.kde.StatusNotifierWatcher</link>.
 */

typedef GfSnWatcherV0GenIface GfSnWatcherV0GenInterface;
G_DEFINE_INTERFACE (GfSnWatcherV0Gen, gf_sn_watcher_v0_gen, G_TYPE_OBJECT)

static void
gf_sn_watcher_v0_gen_default_init (GfSnWatcherV0GenIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GfSnWatcherV0Gen::handle-register-item:
   * @object: A #GfSnWatcherV0Gen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-kde-StatusNotifierWatcher.RegisterStatusNotifierItem">RegisterStatusNotifierItem()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_sn_watcher_v0_gen_complete_register_item() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-item",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfSnWatcherV0GenIface, handle_register_item),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GfSnWatcherV0Gen::handle-register-host:
   * @object: A #GfSnWatcherV0Gen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-kde-StatusNotifierWatcher.RegisterStatusNotifierHost">RegisterStatusNotifierHost()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_sn_watcher_v0_gen_complete_register_host() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-host",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfSnWatcherV0GenIface, handle_register_host),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * GfSnWatcherV0Gen::item-registered:
   * @object: A #GfSnWatcherV0Gen.
   * @arg_service: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-kde-StatusNotifierWatcher.StatusNotifierItemRegistered">"StatusNotifierItemRegistered"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("item-registered",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfSnWatcherV0GenIface, item_registered),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * GfSnWatcherV0Gen::item-unregistered:
   * @object: A #GfSnWatcherV0Gen.
   * @arg_service: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-kde-StatusNotifierWatcher.StatusNotifierItemUnregistered">"StatusNotifierItemUnregistered"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("item-unregistered",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfSnWatcherV0GenIface, item_unregistered),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * GfSnWatcherV0Gen::host-registered:
   * @object: A #GfSnWatcherV0Gen.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-kde-StatusNotifierWatcher.StatusNotifierHostRegistered">"StatusNotifierHostRegistered"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("host-registered",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfSnWatcherV0GenIface, host_registered),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /* GObject properties for D-Bus properties: */
  /**
   * GfSnWatcherV0Gen:registered-items:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierWatcher.RegisteredStatusNotifierItems">"RegisteredStatusNotifierItems"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("registered-items", "RegisteredStatusNotifierItems", "RegisteredStatusNotifierItems", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GfSnWatcherV0Gen:is-host-registered:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierWatcher.IsStatusNotifierHostRegistered">"IsStatusNotifierHostRegistered"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("is-host-registered", "IsStatusNotifierHostRegistered", "IsStatusNotifierHostRegistered", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GfSnWatcherV0Gen:protocol-version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierWatcher.ProtocolVersion">"ProtocolVersion"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("protocol-version", "ProtocolVersion", "ProtocolVersion", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * gf_sn_watcher_v0_gen_get_registered_items: (skip)
 * @object: A #GfSnWatcherV0Gen.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierWatcher.RegisteredStatusNotifierItems">"RegisteredStatusNotifierItems"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gf_sn_watcher_v0_gen_dup_registered_items() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
gf_sn_watcher_v0_gen_get_registered_items (GfSnWatcherV0Gen *object)
{
  return GF_SN_WATCHER_V0_GEN_GET_IFACE (object)->get_registered_items (object);
}

/**
 * gf_sn_watcher_v0_gen_dup_registered_items: (skip)
 * @object: A #GfSnWatcherV0Gen.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-kde-StatusNotifierWatcher.RegisteredStatusNotifierItems">"RegisteredStatusNotifierItems"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
gf_sn_watcher_v0_gen_dup_registered_items (GfSnWatcherV0Gen *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "registered-items", &value, NULL);
  return value;
}

/**
 * gf_sn_watcher_v0_gen_set_registered_items: (skip)
 * @object: A #GfSnWatcherV0Gen.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierWatcher.RegisteredStatusNotifierItems">"RegisteredStatusNotifierItems"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gf_sn_watcher_v0_gen_set_registered_items (GfSnWatcherV0Gen *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "registered-items", value, NULL);
}

/**
 * gf_sn_watcher_v0_gen_get_is_host_registered: (skip)
 * @object: A #GfSnWatcherV0Gen.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierWatcher.IsStatusNotifierHostRegistered">"IsStatusNotifierHostRegistered"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
gf_sn_watcher_v0_gen_get_is_host_registered (GfSnWatcherV0Gen *object)
{
  return GF_SN_WATCHER_V0_GEN_GET_IFACE (object)->get_is_host_registered (object);
}

/**
 * gf_sn_watcher_v0_gen_set_is_host_registered: (skip)
 * @object: A #GfSnWatcherV0Gen.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierWatcher.IsStatusNotifierHostRegistered">"IsStatusNotifierHostRegistered"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gf_sn_watcher_v0_gen_set_is_host_registered (GfSnWatcherV0Gen *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "is-host-registered", value, NULL);
}

/**
 * gf_sn_watcher_v0_gen_get_protocol_version: (skip)
 * @object: A #GfSnWatcherV0Gen.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierWatcher.ProtocolVersion">"ProtocolVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
gf_sn_watcher_v0_gen_get_protocol_version (GfSnWatcherV0Gen *object)
{
  return GF_SN_WATCHER_V0_GEN_GET_IFACE (object)->get_protocol_version (object);
}

/**
 * gf_sn_watcher_v0_gen_set_protocol_version: (skip)
 * @object: A #GfSnWatcherV0Gen.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierWatcher.ProtocolVersion">"ProtocolVersion"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gf_sn_watcher_v0_gen_set_protocol_version (GfSnWatcherV0Gen *object, gint value)
{
  g_object_set (G_OBJECT (object), "protocol-version", value, NULL);
}

/**
 * gf_sn_watcher_v0_gen_emit_item_registered:
 * @object: A #GfSnWatcherV0Gen.
 * @arg_service: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-kde-StatusNotifierWatcher.StatusNotifierItemRegistered">"StatusNotifierItemRegistered"</link> D-Bus signal.
 */
void
gf_sn_watcher_v0_gen_emit_item_registered (
    GfSnWatcherV0Gen *object,
    const gchar *arg_service)
{
  g_signal_emit_by_name (object, "item-registered", arg_service);
}

/**
 * gf_sn_watcher_v0_gen_emit_item_unregistered:
 * @object: A #GfSnWatcherV0Gen.
 * @arg_service: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-kde-StatusNotifierWatcher.StatusNotifierItemUnregistered">"StatusNotifierItemUnregistered"</link> D-Bus signal.
 */
void
gf_sn_watcher_v0_gen_emit_item_unregistered (
    GfSnWatcherV0Gen *object,
    const gchar *arg_service)
{
  g_signal_emit_by_name (object, "item-unregistered", arg_service);
}

/**
 * gf_sn_watcher_v0_gen_emit_host_registered:
 * @object: A #GfSnWatcherV0Gen.
 *
 * Emits the <link linkend="gdbus-signal-org-kde-StatusNotifierWatcher.StatusNotifierHostRegistered">"StatusNotifierHostRegistered"</link> D-Bus signal.
 */
void
gf_sn_watcher_v0_gen_emit_host_registered (
    GfSnWatcherV0Gen *object)
{
  g_signal_emit_by_name (object, "host-registered");
}

/**
 * gf_sn_watcher_v0_gen_call_register_item:
 * @proxy: A #GfSnWatcherV0GenProxy.
 * @arg_service: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-kde-StatusNotifierWatcher.RegisterStatusNotifierItem">RegisterStatusNotifierItem()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_sn_watcher_v0_gen_call_register_item_finish() to get the result of the operation.
 *
 * See gf_sn_watcher_v0_gen_call_register_item_sync() for the synchronous, blocking version of this method.
 */
void
gf_sn_watcher_v0_gen_call_register_item (
    GfSnWatcherV0Gen *proxy,
    const gchar *arg_service,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RegisterStatusNotifierItem",
    g_variant_new ("(s)",
                   arg_service),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_sn_watcher_v0_gen_call_register_item_finish:
 * @proxy: A #GfSnWatcherV0GenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_sn_watcher_v0_gen_call_register_item().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_sn_watcher_v0_gen_call_register_item().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_sn_watcher_v0_gen_call_register_item_finish (
    GfSnWatcherV0Gen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_sn_watcher_v0_gen_call_register_item_sync:
 * @proxy: A #GfSnWatcherV0GenProxy.
 * @arg_service: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-kde-StatusNotifierWatcher.RegisterStatusNotifierItem">RegisterStatusNotifierItem()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_sn_watcher_v0_gen_call_register_item() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_sn_watcher_v0_gen_call_register_item_sync (
    GfSnWatcherV0Gen *proxy,
    const gchar *arg_service,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RegisterStatusNotifierItem",
    g_variant_new ("(s)",
                   arg_service),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_sn_watcher_v0_gen_call_register_host:
 * @proxy: A #GfSnWatcherV0GenProxy.
 * @arg_service: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-kde-StatusNotifierWatcher.RegisterStatusNotifierHost">RegisterStatusNotifierHost()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_sn_watcher_v0_gen_call_register_host_finish() to get the result of the operation.
 *
 * See gf_sn_watcher_v0_gen_call_register_host_sync() for the synchronous, blocking version of this method.
 */
void
gf_sn_watcher_v0_gen_call_register_host (
    GfSnWatcherV0Gen *proxy,
    const gchar *arg_service,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RegisterStatusNotifierHost",
    g_variant_new ("(s)",
                   arg_service),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_sn_watcher_v0_gen_call_register_host_finish:
 * @proxy: A #GfSnWatcherV0GenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_sn_watcher_v0_gen_call_register_host().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_sn_watcher_v0_gen_call_register_host().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_sn_watcher_v0_gen_call_register_host_finish (
    GfSnWatcherV0Gen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_sn_watcher_v0_gen_call_register_host_sync:
 * @proxy: A #GfSnWatcherV0GenProxy.
 * @arg_service: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-kde-StatusNotifierWatcher.RegisterStatusNotifierHost">RegisterStatusNotifierHost()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_sn_watcher_v0_gen_call_register_host() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_sn_watcher_v0_gen_call_register_host_sync (
    GfSnWatcherV0Gen *proxy,
    const gchar *arg_service,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RegisterStatusNotifierHost",
    g_variant_new ("(s)",
                   arg_service),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_sn_watcher_v0_gen_complete_register_item:
 * @object: A #GfSnWatcherV0Gen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-kde-StatusNotifierWatcher.RegisterStatusNotifierItem">RegisterStatusNotifierItem()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_sn_watcher_v0_gen_complete_register_item (
    GfSnWatcherV0Gen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_sn_watcher_v0_gen_complete_register_host:
 * @object: A #GfSnWatcherV0Gen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-kde-StatusNotifierWatcher.RegisterStatusNotifierHost">RegisterStatusNotifierHost()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_sn_watcher_v0_gen_complete_register_host (
    GfSnWatcherV0Gen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GfSnWatcherV0GenProxy:
 *
 * The #GfSnWatcherV0GenProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GfSnWatcherV0GenProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GfSnWatcherV0GenProxy.
 */

struct _GfSnWatcherV0GenProxyPrivate
{
  GData *qdata;
};

static void gf_sn_watcher_v0_gen_proxy_iface_init (GfSnWatcherV0GenIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GfSnWatcherV0GenProxy, gf_sn_watcher_v0_gen_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GfSnWatcherV0GenProxy)
                         G_IMPLEMENT_INTERFACE (GF_TYPE_SN_WATCHER_V0_GEN, gf_sn_watcher_v0_gen_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GfSnWatcherV0GenProxy, gf_sn_watcher_v0_gen_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GF_TYPE_SN_WATCHER_V0_GEN, gf_sn_watcher_v0_gen_proxy_iface_init))

#endif
static void
gf_sn_watcher_v0_gen_proxy_finalize (GObject *object)
{
  GfSnWatcherV0GenProxy *proxy = GF_SN_WATCHER_V0_GEN_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gf_sn_watcher_v0_gen_proxy_parent_class)->finalize (object);
}

static void
gf_sn_watcher_v0_gen_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _gf_sn_watcher_v0_gen_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
gf_sn_watcher_v0_gen_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.kde.StatusNotifierWatcher: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
gf_sn_watcher_v0_gen_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _gf_sn_watcher_v0_gen_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.kde.StatusNotifierWatcher", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) gf_sn_watcher_v0_gen_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
gf_sn_watcher_v0_gen_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gf_sn_watcher_v0_gen_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GF_TYPE_SN_WATCHER_V0_GEN);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GF_TYPE_SN_WATCHER_V0_GEN);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gf_sn_watcher_v0_gen_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GfSnWatcherV0GenProxy *proxy = GF_SN_WATCHER_V0_GEN_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_sn_watcher_v0_gen_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_sn_watcher_v0_gen_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *const *
gf_sn_watcher_v0_gen_proxy_get_registered_items (GfSnWatcherV0Gen *object)
{
  GfSnWatcherV0GenProxy *proxy = GF_SN_WATCHER_V0_GEN_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "RegisteredStatusNotifierItems");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RegisteredStatusNotifierItems");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "RegisteredStatusNotifierItems", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
gf_sn_watcher_v0_gen_proxy_get_is_host_registered (GfSnWatcherV0Gen *object)
{
  GfSnWatcherV0GenProxy *proxy = GF_SN_WATCHER_V0_GEN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IsStatusNotifierHostRegistered");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
gf_sn_watcher_v0_gen_proxy_get_protocol_version (GfSnWatcherV0Gen *object)
{
  GfSnWatcherV0GenProxy *proxy = GF_SN_WATCHER_V0_GEN_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ProtocolVersion");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
gf_sn_watcher_v0_gen_proxy_init (GfSnWatcherV0GenProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gf_sn_watcher_v0_gen_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GF_TYPE_SN_WATCHER_V0_GEN_PROXY, GfSnWatcherV0GenProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gf_sn_watcher_v0_gen_interface_info ());
}

static void
gf_sn_watcher_v0_gen_proxy_class_init (GfSnWatcherV0GenProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gf_sn_watcher_v0_gen_proxy_finalize;
  gobject_class->get_property = gf_sn_watcher_v0_gen_proxy_get_property;
  gobject_class->set_property = gf_sn_watcher_v0_gen_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gf_sn_watcher_v0_gen_proxy_g_signal;
  proxy_class->g_properties_changed = gf_sn_watcher_v0_gen_proxy_g_properties_changed;

  gf_sn_watcher_v0_gen_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GfSnWatcherV0GenProxyPrivate));
#endif
}

static void
gf_sn_watcher_v0_gen_proxy_iface_init (GfSnWatcherV0GenIface *iface)
{
  iface->get_registered_items = gf_sn_watcher_v0_gen_proxy_get_registered_items;
  iface->get_is_host_registered = gf_sn_watcher_v0_gen_proxy_get_is_host_registered;
  iface->get_protocol_version = gf_sn_watcher_v0_gen_proxy_get_protocol_version;
}

/**
 * gf_sn_watcher_v0_gen_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-kde-StatusNotifierWatcher.top_of_page">org.kde.StatusNotifierWatcher</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_sn_watcher_v0_gen_proxy_new_finish() to get the result of the operation.
 *
 * See gf_sn_watcher_v0_gen_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gf_sn_watcher_v0_gen_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GF_TYPE_SN_WATCHER_V0_GEN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.kde.StatusNotifierWatcher", NULL);
}

/**
 * gf_sn_watcher_v0_gen_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_sn_watcher_v0_gen_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gf_sn_watcher_v0_gen_proxy_new().
 *
 * Returns: (transfer full) (type GfSnWatcherV0GenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfSnWatcherV0Gen *
gf_sn_watcher_v0_gen_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GF_SN_WATCHER_V0_GEN (ret);
  else
    return NULL;
}

/**
 * gf_sn_watcher_v0_gen_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-kde-StatusNotifierWatcher.top_of_page">org.kde.StatusNotifierWatcher</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gf_sn_watcher_v0_gen_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GfSnWatcherV0GenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfSnWatcherV0Gen *
gf_sn_watcher_v0_gen_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GF_TYPE_SN_WATCHER_V0_GEN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.kde.StatusNotifierWatcher", NULL);
  if (ret != NULL)
    return GF_SN_WATCHER_V0_GEN (ret);
  else
    return NULL;
}


/**
 * gf_sn_watcher_v0_gen_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gf_sn_watcher_v0_gen_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_sn_watcher_v0_gen_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gf_sn_watcher_v0_gen_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gf_sn_watcher_v0_gen_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GF_TYPE_SN_WATCHER_V0_GEN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.kde.StatusNotifierWatcher", NULL);
}

/**
 * gf_sn_watcher_v0_gen_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_sn_watcher_v0_gen_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gf_sn_watcher_v0_gen_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GfSnWatcherV0GenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfSnWatcherV0Gen *
gf_sn_watcher_v0_gen_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GF_SN_WATCHER_V0_GEN (ret);
  else
    return NULL;
}

/**
 * gf_sn_watcher_v0_gen_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gf_sn_watcher_v0_gen_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gf_sn_watcher_v0_gen_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GfSnWatcherV0GenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfSnWatcherV0Gen *
gf_sn_watcher_v0_gen_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GF_TYPE_SN_WATCHER_V0_GEN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.kde.StatusNotifierWatcher", NULL);
  if (ret != NULL)
    return GF_SN_WATCHER_V0_GEN (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GfSnWatcherV0GenSkeleton:
 *
 * The #GfSnWatcherV0GenSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GfSnWatcherV0GenSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GfSnWatcherV0GenSkeleton.
 */

struct _GfSnWatcherV0GenSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gf_sn_watcher_v0_gen_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GF_TYPE_SN_WATCHER_V0_GEN);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GF_TYPE_SN_WATCHER_V0_GEN);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gf_sn_watcher_v0_gen_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_sn_watcher_v0_gen_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gf_sn_watcher_v0_gen_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_sn_watcher_v0_gen_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gf_sn_watcher_v0_gen_skeleton_vtable =
{
  _gf_sn_watcher_v0_gen_skeleton_handle_method_call,
  _gf_sn_watcher_v0_gen_skeleton_handle_get_property,
  _gf_sn_watcher_v0_gen_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gf_sn_watcher_v0_gen_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gf_sn_watcher_v0_gen_interface_info ();
}

static GDBusInterfaceVTable *
gf_sn_watcher_v0_gen_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gf_sn_watcher_v0_gen_skeleton_vtable;
}

static GVariant *
gf_sn_watcher_v0_gen_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_gf_sn_watcher_v0_gen_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gf_sn_watcher_v0_gen_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gf_sn_watcher_v0_gen_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gf_sn_watcher_v0_gen_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.kde.StatusNotifierWatcher", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _gf_sn_watcher_v0_gen_emit_changed (gpointer user_data);

static void
gf_sn_watcher_v0_gen_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _gf_sn_watcher_v0_gen_emit_changed (skeleton);
}

static void
_gf_sn_watcher_v0_gen_on_signal_item_registered (
    GfSnWatcherV0Gen *object,
    const gchar *arg_service)
{
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_service));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.kde.StatusNotifierWatcher", "StatusNotifierItemRegistered",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gf_sn_watcher_v0_gen_on_signal_item_unregistered (
    GfSnWatcherV0Gen *object,
    const gchar *arg_service)
{
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_service));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.kde.StatusNotifierWatcher", "StatusNotifierItemUnregistered",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gf_sn_watcher_v0_gen_on_signal_host_registered (
    GfSnWatcherV0Gen *object)
{
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.kde.StatusNotifierWatcher", "StatusNotifierHostRegistered",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gf_sn_watcher_v0_gen_skeleton_iface_init (GfSnWatcherV0GenIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GfSnWatcherV0GenSkeleton, gf_sn_watcher_v0_gen_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GfSnWatcherV0GenSkeleton)
                         G_IMPLEMENT_INTERFACE (GF_TYPE_SN_WATCHER_V0_GEN, gf_sn_watcher_v0_gen_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GfSnWatcherV0GenSkeleton, gf_sn_watcher_v0_gen_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GF_TYPE_SN_WATCHER_V0_GEN, gf_sn_watcher_v0_gen_skeleton_iface_init))

#endif
static void
gf_sn_watcher_v0_gen_skeleton_finalize (GObject *object)
{
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gf_sn_watcher_v0_gen_skeleton_parent_class)->finalize (object);
}

static void
gf_sn_watcher_v0_gen_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_gf_sn_watcher_v0_gen_emit_changed (gpointer user_data)
{
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.kde.StatusNotifierWatcher",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_gf_sn_watcher_v0_gen_schedule_emit_changed (GfSnWatcherV0GenSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
gf_sn_watcher_v0_gen_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _gf_sn_watcher_v0_gen_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _gf_sn_watcher_v0_gen_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
gf_sn_watcher_v0_gen_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _gf_sn_watcher_v0_gen_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _gf_sn_watcher_v0_gen_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
gf_sn_watcher_v0_gen_skeleton_init (GfSnWatcherV0GenSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gf_sn_watcher_v0_gen_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GF_TYPE_SN_WATCHER_V0_GEN_SKELETON, GfSnWatcherV0GenSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_INT);
}

static const gchar *const *
gf_sn_watcher_v0_gen_skeleton_get_registered_items (GfSnWatcherV0Gen *object)
{
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
gf_sn_watcher_v0_gen_skeleton_get_is_host_registered (GfSnWatcherV0Gen *object)
{
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
gf_sn_watcher_v0_gen_skeleton_get_protocol_version (GfSnWatcherV0Gen *object)
{
  GfSnWatcherV0GenSkeleton *skeleton = GF_SN_WATCHER_V0_GEN_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
gf_sn_watcher_v0_gen_skeleton_class_init (GfSnWatcherV0GenSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gf_sn_watcher_v0_gen_skeleton_finalize;
  gobject_class->get_property = gf_sn_watcher_v0_gen_skeleton_get_property;
  gobject_class->set_property = gf_sn_watcher_v0_gen_skeleton_set_property;
  gobject_class->notify       = gf_sn_watcher_v0_gen_skeleton_notify;


  gf_sn_watcher_v0_gen_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gf_sn_watcher_v0_gen_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gf_sn_watcher_v0_gen_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gf_sn_watcher_v0_gen_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gf_sn_watcher_v0_gen_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GfSnWatcherV0GenSkeletonPrivate));
#endif
}

static void
gf_sn_watcher_v0_gen_skeleton_iface_init (GfSnWatcherV0GenIface *iface)
{
  iface->item_registered = _gf_sn_watcher_v0_gen_on_signal_item_registered;
  iface->item_unregistered = _gf_sn_watcher_v0_gen_on_signal_item_unregistered;
  iface->host_registered = _gf_sn_watcher_v0_gen_on_signal_host_registered;
  iface->get_registered_items = gf_sn_watcher_v0_gen_skeleton_get_registered_items;
  iface->get_is_host_registered = gf_sn_watcher_v0_gen_skeleton_get_is_host_registered;
  iface->get_protocol_version = gf_sn_watcher_v0_gen_skeleton_get_protocol_version;
}

/**
 * gf_sn_watcher_v0_gen_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-kde-StatusNotifierWatcher.top_of_page">org.kde.StatusNotifierWatcher</link>.
 *
 * Returns: (transfer full) (type GfSnWatcherV0GenSkeleton): The skeleton object.
 */
GfSnWatcherV0Gen *
gf_sn_watcher_v0_gen_skeleton_new (void)
{
  return GF_SN_WATCHER_V0_GEN (g_object_new (GF_TYPE_SN_WATCHER_V0_GEN_SKELETON, NULL));
}

