/*
 *  Copyright (c) 2017, Facebook, Inc.
 *  All rights reserved.
 *
 *  This source code is licensed under the BSD-style license found in the
 *  LICENSE file in the root directory of this source tree. An additional grant
 *  of patent rights can be found in the PATENTS file in the same directory.
 *
 */

/*
 *  THIS FILE IS AUTOGENERATED. DO NOT MODIFY IT; ALL CHANGES WILL BE LOST IN
 *  VAIN.
 *
 *  @generated
 */
#include "CarbonTestMessages.h"

namespace carbon {
namespace test {

constexpr const char* const TestRequest::name;

void TestRequest::serialize(carbon::CarbonProtocolWriter& writer) const {
  writer.writeStructBegin();
  writer.writeField(-1 /* field id */, asBase());
  writer.writeField(1 /* field id */, key());
  writer.writeField(2 /* field id */, testEnum());
  writer.writeField(3 /* field id */, testBool());
  writer.writeField(4 /* field id */, testChar());
  writer.writeField(5 /* field id */, testInt8());
  writer.writeField(6 /* field id */, testInt16());
  writer.writeField(7 /* field id */, testInt32());
  writer.writeField(8 /* field id */, testInt64());
  writer.writeField(9 /* field id */, testUInt8());
  writer.writeField(10 /* field id */, testUInt16());
  writer.writeField(11 /* field id */, testUInt32());
  writer.writeField(12 /* field id */, testUInt64());
  writer.writeField(13 /* field id */, testFloat());
  writer.writeField(14 /* field id */, testDouble());
  writer.writeField(15 /* field id */, testShortString());
  writer.writeField(16 /* field id */, testLongString());
  writer.writeField(17 /* field id */, testIobuf());
  writer.writeField(18 /* field id */, testStruct());
  writer.writeField(19 /* field id */, testList());
  writer.writeField(20 /* field id */, testOptionalString());
  writer.writeField(21 /* field id */, testOptionalIobuf());
  writer.writeField(22 /* field id */, testEnumVec());
  writer.writeField(23 /* field id */, testUnion());
  writer.writeField(24 /* field id */, testNestedVec());
  writer.writeField(25 /* field id */, testUMap());
  writer.writeField(26 /* field id */, testMap());
  writer.writeField(27 /* field id */, testComplexMap());
  writer.writeField(28 /* field id */, testUSet());
  writer.writeField(29 /* field id */, testSet());
  writer.writeField(30 /* field id */, testOptionalBool());
  writer.writeField(31 /* field id */, testOptionalVec());
  writer.writeField(100 /* field id */, testType());
  writer.writeStructEnd();
  writer.writeStop();
}

void TestRequest::deserialize(carbon::CarbonProtocolReader& reader) {
  reader.readStructBegin();
  while (true) {
    const auto pr = reader.readFieldHeader();
    const auto fieldType = pr.first;
    const auto fieldId = pr.second;

    if (fieldType == carbon::FieldType::Stop) {
      break;
    }

    switch (fieldId) {
      case -1: {
        reader.readField(_carbon_simplestruct_, fieldType);
        break;
      }
      case 1: {
        reader.readField(key(), fieldType);
        break;
      }
      case 2: {
        reader.readField(testEnum(), fieldType);
        break;
      }
      case 3: {
        reader.readField(testBool(), fieldType);
        break;
      }
      case 4: {
        reader.readField(testChar(), fieldType);
        break;
      }
      case 5: {
        reader.readField(testInt8(), fieldType);
        break;
      }
      case 6: {
        reader.readField(testInt16(), fieldType);
        break;
      }
      case 7: {
        reader.readField(testInt32(), fieldType);
        break;
      }
      case 8: {
        reader.readField(testInt64(), fieldType);
        break;
      }
      case 9: {
        reader.readField(testUInt8(), fieldType);
        break;
      }
      case 10: {
        reader.readField(testUInt16(), fieldType);
        break;
      }
      case 11: {
        reader.readField(testUInt32(), fieldType);
        break;
      }
      case 12: {
        reader.readField(testUInt64(), fieldType);
        break;
      }
      case 13: {
        reader.readField(testFloat(), fieldType);
        break;
      }
      case 14: {
        reader.readField(testDouble(), fieldType);
        break;
      }
      case 15: {
        reader.readField(testShortString(), fieldType);
        break;
      }
      case 16: {
        reader.readField(testLongString(), fieldType);
        break;
      }
      case 17: {
        reader.readField(testIobuf(), fieldType);
        break;
      }
      case 18: {
        reader.readField(testStruct(), fieldType);
        break;
      }
      case 19: {
        reader.readField(testList(), fieldType);
        break;
      }
      case 20: {
        reader.readField(testOptionalString(), fieldType);
        break;
      }
      case 21: {
        reader.readField(testOptionalIobuf(), fieldType);
        break;
      }
      case 22: {
        reader.readField(testEnumVec(), fieldType);
        break;
      }
      case 23: {
        reader.readField(testUnion(), fieldType);
        break;
      }
      case 24: {
        reader.readField(testNestedVec(), fieldType);
        break;
      }
      case 25: {
        reader.readField(testUMap(), fieldType);
        break;
      }
      case 26: {
        reader.readField(testMap(), fieldType);
        break;
      }
      case 27: {
        reader.readField(testComplexMap(), fieldType);
        break;
      }
      case 28: {
        reader.readField(testUSet(), fieldType);
        break;
      }
      case 29: {
        reader.readField(testSet(), fieldType);
        break;
      }
      case 30: {
        reader.readField(testOptionalBool(), fieldType);
        break;
      }
      case 31: {
        reader.readField(testOptionalVec(), fieldType);
        break;
      }
      case 100: {
        reader.readField(testType(), fieldType);
        break;
      }
      default: {
        reader.skip(fieldType);
        break;
      }
    }
  }
  reader.readStructEnd();
}

void TestReply::serialize(carbon::CarbonProtocolWriter& writer) const {
  writer.writeStructBegin();
  writer.writeField(1 /* field id */, result());
  writer.writeField(2 /* field id */, valInt32());
  writer.writeField(3 /* field id */, valInt64());
  writer.writeStructEnd();
  writer.writeStop();
}

void TestReply::deserialize(carbon::CarbonProtocolReader& reader) {
  reader.readStructBegin();
  while (true) {
    const auto pr = reader.readFieldHeader();
    const auto fieldType = pr.first;
    const auto fieldId = pr.second;

    if (fieldType == carbon::FieldType::Stop) {
      break;
    }

    switch (fieldId) {
      case 1: {
        reader.readField(result(), fieldType);
        break;
      }
      case 2: {
        reader.readField(valInt32(), fieldType);
        break;
      }
      case 3: {
        reader.readField(valInt64(), fieldType);
        break;
      }
      default: {
        reader.skip(fieldType);
        break;
      }
    }
  }
  reader.readStructEnd();
}

constexpr const char* const TestRequestStringKey::name;

void TestRequestStringKey::serialize(
    carbon::CarbonProtocolWriter& writer) const {
  writer.writeStructBegin();
  writer.writeField(1 /* field id */, key());
  writer.writeStructEnd();
  writer.writeStop();
}

void TestRequestStringKey::deserialize(carbon::CarbonProtocolReader& reader) {
  reader.readStructBegin();
  while (true) {
    const auto pr = reader.readFieldHeader();
    const auto fieldType = pr.first;
    const auto fieldId = pr.second;

    if (fieldType == carbon::FieldType::Stop) {
      break;
    }

    switch (fieldId) {
      case 1: {
        reader.readField(key(), fieldType);
        break;
      }
      default: {
        reader.skip(fieldType);
        break;
      }
    }
  }
  reader.readStructEnd();
}

void TestReplyStringKey::serialize(carbon::CarbonProtocolWriter& writer) const {
  writer.writeStructBegin();
  writer.writeField(1 /* field id */, result());
  writer.writeStructEnd();
  writer.writeStop();
}

void TestReplyStringKey::deserialize(carbon::CarbonProtocolReader& reader) {
  reader.readStructBegin();
  while (true) {
    const auto pr = reader.readFieldHeader();
    const auto fieldType = pr.first;
    const auto fieldId = pr.second;

    if (fieldType == carbon::FieldType::Stop) {
      break;
    }

    switch (fieldId) {
      case 1: {
        reader.readField(result(), fieldType);
        break;
      }
      default: {
        reader.skip(fieldType);
        break;
      }
    }
  }
  reader.readStructEnd();
}

void TestOptionalBool::serialize(carbon::CarbonProtocolWriter& writer) const {
  writer.writeStructBegin();
  writer.writeField(1 /* field id */, optionalBool());
  writer.writeStructEnd();
  writer.writeStop();
}

void TestOptionalBool::deserialize(carbon::CarbonProtocolReader& reader) {
  reader.readStructBegin();
  while (true) {
    const auto pr = reader.readFieldHeader();
    const auto fieldType = pr.first;
    const auto fieldId = pr.second;

    if (fieldType == carbon::FieldType::Stop) {
      break;
    }

    switch (fieldId) {
      case 1: {
        reader.readField(optionalBool(), fieldType);
        break;
      }
      default: {
        reader.skip(fieldType);
        break;
      }
    }
  }
  reader.readStructEnd();
}

void TestOptionalUnion::serialize(carbon::CarbonProtocolWriter& writer) const {
  writer.writeStructBegin();
  switch (_which_) {
    case 1: {
      writer.writeFieldAlways(1 /* field id */, umember1());
      break;
    }
    case 2: {
      writer.writeFieldAlways(2 /* field id */, umember2());
      break;
    }
    case 3: {
      writer.writeFieldAlways(3 /* field id */, umember3());
      break;
    }
    default:
      break;
  }
  writer.writeStructEnd();
  writer.writeStop();
}

void TestOptionalUnion::deserialize(carbon::CarbonProtocolReader& reader) {
  reader.readStructBegin();
  while (true) {
    const auto pr = reader.readFieldHeader();
    const auto fieldType = pr.first;
    const auto fieldId = pr.second;

    if (fieldType == carbon::FieldType::Stop) {
      break;
    }

    switch (fieldId) {
      case 1: {
        reader.readRawInto(emplace<1>());
        break;
      }
      case 2: {
        reader.readRawInto(emplace<2>());
        break;
      }
      case 3: {
        reader.readRawInto(emplace<3>());
        break;
      }
      default: {
        reader.skip(fieldType);
        break;
      }
    }
  }
  reader.readStructEnd();
}

} // test
} // carbon
