/***********************************************************************************

    Copyright (C) 2007-2019 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_DIARY_TAG_GUI_HEADER
#define LIFEOGRAPH_DIARY_TAG_GUI_HEADER


#include <gtkmm.h>

#include "diarydata.hpp"


namespace LIFEO
{

// CUSTOM TREESTORE
class TreeStoreExtra : public Gtk::TreeStore
{
    protected:
        TreeStoreExtra();

    public:
        class Colrec : public Gtk::TreeModel::ColumnRecord
        {
            public:
                Colrec()
                {
                    add( icon );
                    add( name );
                    add( ptr );
                    add( filter );
                }
                Gtk::TreeModelColumn< Glib::RefPtr< Gdk::Pixbuf > >     icon;
                Gtk::TreeModelColumn< Glib::ustring >                   name;
                Gtk::TreeModelColumn< Glib::RefPtr< Gdk::Pixbuf > >     filter;
                Gtk::TreeModelColumn< DiaryElement* >                   ptr;
        };

        Colrec colrec;

        static Glib::RefPtr< TreeStoreExtra > create();

    protected:
        virtual bool row_draggable_vfunc( const Gtk::TreeModel::Path& path ) const;
};

// PANEL EXTRA ITEMS
class PanelExtra : public Gtk::TreeView
{
    public:
                                    PanelExtra( BaseObjectType*,
                                                const Glib::RefPtr<Gtk::Builder>& );

        void                        handle_login();
        void                        handle_edit_enabled();
        void                        handle_logout();

        void                        populate();
        Gtk::TreeIter               add_elem_to_list( DiaryElement*,
                                                      const Gtk::TreeNodeChildren* = NULL );

        Gtk::TreeRow                get_row( const Gtk::TreePath& );

        void                        set_filtered_tag( const Tag* );

        void                        refresh_elem( DiaryElement* );

    protected:
        void                        on_drag_begin( const Glib::RefPtr< Gdk::DragContext >& );
        void                        on_drag_end( const Glib::RefPtr< Gdk::DragContext >& );
        bool                        on_drag_motion( const Glib::RefPtr< Gdk::DragContext >&,
                                                    int, int, guint );
        bool                        on_drag_drop( const Glib::RefPtr< Gdk::DragContext >&,
                                                  int, int, guint );
        bool                        on_button_press_event( GdkEventButton* );
        bool                        on_button_release_event( GdkEventButton* );
        void                        handle_treeview_row_expanded( const Gtk::TreeIter&,
                                                                  const Gtk::TreePath& );
        void                        handle_treeview_row_activated( const Gtk::TreePath&,
                                                                   Gtk::TreeViewColumn* );

        void                        cell_data_func_icon( Gtk::CellRenderer*,
                                                         const Gtk::TreeModel::iterator& );
        void                        cell_data_func_text( Gtk::CellRenderer*,
                                                         const Gtk::TreeModel::iterator& );
        void                        cell_data_func_filter( Gtk::CellRenderer*,
                                                           const Gtk::TreeModel::iterator& );

        // HELPER FUNCTION
        void                        tag_entry( Entry*, Tag* );

        Glib::RefPtr< TreeStoreExtra >
                                    m_treestore;

        Entry*                      m_ptr2entry;

    friend class Lifeograph;
};

} // end of namespace LIFEO

#endif

