; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -global-isel -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -global-isel -mcpu=mips32r6 -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32R6

@float_align1 = common global float 0.000000e+00, align 1
@float_align2 = common global float 0.000000e+00, align 2
@float_align4 = common global float 0.000000e+00, align 4
@float_align8 = common global float 0.000000e+00, align 8
@i32_align1 = common global i32 0, align 1
@i32_align2 = common global i32 0, align 2
@i32_align4 = common global i32 0, align 4
@i32_align8 = common global i32 0, align 8

define float @load_float_align1() {
; MIPS32-LABEL: load_float_align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(float_align1)
; MIPS32-NEXT:    addiu $2, $1, %lo(float_align1)
; MIPS32-NEXT:    # implicit-def: $at
; MIPS32-NEXT:    lwl $1, 3($2)
; MIPS32-NEXT:    lwr $1, 0($2)
; MIPS32-NEXT:    mtc1 $1, $f0
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_float_align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(float_align1)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(float_align1)
; MIPS32R6-NEXT:    lwc1 $f0, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load float, float* @float_align1, align 1
  ret float %0
}

define float @load_float_align2() {
; MIPS32-LABEL: load_float_align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(float_align2)
; MIPS32-NEXT:    addiu $2, $1, %lo(float_align2)
; MIPS32-NEXT:    # implicit-def: $at
; MIPS32-NEXT:    lwl $1, 3($2)
; MIPS32-NEXT:    lwr $1, 0($2)
; MIPS32-NEXT:    mtc1 $1, $f0
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_float_align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(float_align2)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(float_align2)
; MIPS32R6-NEXT:    lwc1 $f0, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load float, float* @float_align2, align 2
  ret float %0
}

define float @load_float_align4() {
; MIPS32-LABEL: load_float_align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(float_align4)
; MIPS32-NEXT:    addiu $1, $1, %lo(float_align4)
; MIPS32-NEXT:    lwc1 $f0, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_float_align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(float_align4)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(float_align4)
; MIPS32R6-NEXT:    lwc1 $f0, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load float, float* @float_align4, align 4
  ret float %0
}

define float @load_float_align8() {
; MIPS32-LABEL: load_float_align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(float_align8)
; MIPS32-NEXT:    addiu $1, $1, %lo(float_align8)
; MIPS32-NEXT:    lwc1 $f0, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_float_align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(float_align8)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(float_align8)
; MIPS32R6-NEXT:    lwc1 $f0, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load float, float* @float_align8, align 8
  ret float %0
}

define i32 @load_i32_align1() {
; MIPS32-LABEL: load_i32_align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i32_align1)
; MIPS32-NEXT:    addiu $1, $1, %lo(i32_align1)
; MIPS32-NEXT:    # implicit-def: $v0
; MIPS32-NEXT:    lwl $2, 3($1)
; MIPS32-NEXT:    lwr $2, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_i32_align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i32_align1)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i32_align1)
; MIPS32R6-NEXT:    lw $2, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load i32, i32* @i32_align1, align 1
  ret i32 %0
}

define i32 @load_i32_align2() {
; MIPS32-LABEL: load_i32_align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i32_align2)
; MIPS32-NEXT:    addiu $1, $1, %lo(i32_align2)
; MIPS32-NEXT:    # implicit-def: $v0
; MIPS32-NEXT:    lwl $2, 3($1)
; MIPS32-NEXT:    lwr $2, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_i32_align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i32_align2)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i32_align2)
; MIPS32R6-NEXT:    lw $2, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load i32, i32* @i32_align2, align 2
  ret i32 %0
}

define i32 @load_i32_align4() {
; MIPS32-LABEL: load_i32_align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i32_align4)
; MIPS32-NEXT:    addiu $1, $1, %lo(i32_align4)
; MIPS32-NEXT:    lw $2, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_i32_align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i32_align4)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i32_align4)
; MIPS32R6-NEXT:    lw $2, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load i32, i32* @i32_align4, align 4
  ret i32 %0
}

define i32 @load_i32_align8() {
; MIPS32-LABEL: load_i32_align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i32_align8)
; MIPS32-NEXT:    addiu $1, $1, %lo(i32_align8)
; MIPS32-NEXT:    lw $2, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_i32_align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i32_align8)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i32_align8)
; MIPS32R6-NEXT:    lw $2, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load i32, i32* @i32_align8, align 8
  ret i32 %0
}
