; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -canon-freeze -S | FileCheck %s
; A set of tests that have one phi node
declare void @call(i32)
declare i32 @get_step()

define void @add(i32 %init, i32 %n) {
; CHECK-LABEL: @add(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INIT_FROZEN:%.*]] = freeze i32 [[INIT:%.*]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT_FROZEN]], [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT]] = add i32 [[I]], 1
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [ %init, %entry], [%i.next, %loop ]
  %i.next = add i32 %i, 1
  %i.next.fr = freeze i32 %i.next
  %cond = icmp eq i32 %i.next.fr, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

define void @add_comm(i32 %init, i32 %n) {
; CHECK-LABEL: @add_comm(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INIT_FROZEN:%.*]] = freeze i32 [[INIT:%.*]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT_FROZEN]], [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT]] = add i32 1, [[I]]
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [ %init, %entry ], [ %i.next, %loop ]
  %i.next = add i32 1, %i
  %i.next.fr = freeze i32 %i.next
  %cond = icmp eq i32 %i.next.fr, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

define void @add_multiuses(i32 %init, i32 %n) {
; CHECK-LABEL: @add_multiuses(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INIT_FROZEN:%.*]] = freeze i32 [[INIT:%.*]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT_FROZEN]], [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT]] = add i32 [[I]], 1
; CHECK-NEXT:    call void @call(i32 [[I_NEXT]])
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [ %init, %entry ], [ %i.next, %loop ]
  %i.next = add i32 %i, 1
  %i.next.fr = freeze i32 %i.next
  call void @call(i32 %i.next.fr)
  %cond = icmp eq i32 %i.next.fr, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

define void @add_multiuses2(i32 %init, i32 %n) {
; CHECK-LABEL: @add_multiuses2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INIT_FROZEN:%.*]] = freeze i32 [[INIT:%.*]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT_FROZEN]], [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT]] = add i32 [[I]], 1
; CHECK-NEXT:    call void @call(i32 [[I_NEXT]])
; CHECK-NEXT:    call void @call(i32 [[I_NEXT]])
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [ %init, %entry ], [ %i.next, %loop ]
  %i.next = add i32 %i, 1
  %i.next.fr = freeze i32 %i.next
  call void @call(i32 %i.next.fr)
  %i.next.fr2 = freeze i32 %i.next
  call void @call(i32 %i.next.fr2)
  %cond = icmp eq i32 %i.next.fr, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

define void @add_flags(i32 %init, i32 %n) {
; CHECK-LABEL: @add_flags(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INIT_FROZEN:%.*]] = freeze i32 [[INIT:%.*]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT_FROZEN]], [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT]] = add i32 [[I]], 1
; CHECK-NEXT:    call void @call(i32 [[I_NEXT]])
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [ %init, %entry ], [ %i.next, %loop ]
  %i.next = add nuw nsw i32 %i, 1
  %i.next.fr = freeze i32 %i.next
  call void @call(i32 %i.next.fr)
  %cond = icmp eq i32 %i.next.fr, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

define void @add_ind(i32 %init, i32 %n) {
; CHECK-LABEL: @add_ind(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INIT_FROZEN:%.*]] = freeze i32 [[INIT:%.*]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT_FROZEN]], [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT]] = add i32 [[I]], 1
; CHECK-NEXT:    [[I_FR_NEXT:%.*]] = add nuw nsw i32 [[I]], 1
; CHECK-NEXT:    call void @call(i32 [[I_FR_NEXT]])
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_FR_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [ %init, %entry ], [ %i.next, %loop ]
  %i.next = add nuw nsw i32 %i, 1
  %i.fr = freeze i32 %i
  %i.fr.next = add nuw nsw i32 %i.fr, 1
  call void @call(i32 %i.fr.next)
  %cond = icmp eq i32 %i.fr.next, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

; Negative test
define void @add_ind_frozen(i32 %init, i32 %n) {
; CHECK-LABEL: @add_ind_frozen(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT:%.*]], [[ENTRY:%.*]] ], [ [[I_NEXT_FR:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_FR:%.*]] = freeze i32 [[I]]
; CHECK-NEXT:    [[I_NEXT_FR]] = add nuw nsw i32 [[I_FR]], 1
; CHECK-NEXT:    call void @call(i32 [[I_NEXT_FR]])
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT_FR]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [%init, %entry], [%i.next.fr, %loop]
  %i.fr = freeze i32 %i
  %i.next.fr = add nuw nsw i32 %i.fr, 1
  call void @call(i32 %i.next.fr)
  %cond = icmp eq i32 %i.next.fr, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

define void @add_flags_not_compared(i32 %init, i32 %n) {
; CHECK-LABEL: @add_flags_not_compared(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INIT_FROZEN:%.*]] = freeze i32 [[INIT:%.*]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT_FROZEN]], [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT]] = add i32 [[I]], 1
; CHECK-NEXT:    call void @call(i32 [[I_NEXT]])
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [ %init, %entry ], [ %i.next, %loop ]
  %i.next = add nuw nsw i32 %i, 1
  %i.next.fr = freeze i32 %i.next
  call void @call(i32 %i.next.fr)
  %cond = icmp eq i32 %i.next, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

; Negative test
define void @add_flags_not_compared_stepinst(i32 %init, i32 %n) {
; CHECK-LABEL: @add_flags_not_compared_stepinst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT:%.*]], [[ENTRY:%.*]] ], [ [[I_NEXT_FR:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT:%.*]] = add nuw nsw i32 [[I]], 1
; CHECK-NEXT:    [[I_NEXT_FR]] = freeze i32 [[I_NEXT]]
; CHECK-NEXT:    call void @call(i32 [[I_NEXT_FR]])
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [ %init, %entry ], [ %i.next.fr, %loop ]
  %i.next = add nuw nsw i32 %i, 1
  %i.next.fr = freeze i32 %i.next
  call void @call(i32 %i.next.fr)
  %cond = icmp eq i32 %i.next, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

; Negative test
; If pushing freeze through icmp is needed, this should be enabled.
; There is no correctness issue in pushing freeze into icmp here, just it's
; being conservative right now.
define void @add_flags_stepinst_frozen(i32 %init, i32 %n) {
; CHECK-LABEL: @add_flags_stepinst_frozen(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT:%.*]], [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT]] = add nuw nsw i32 [[I]], 1
; CHECK-NEXT:    call void @call(i32 [[I_NEXT]])
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT]], [[N:%.*]]
; CHECK-NEXT:    [[COND_FR:%.*]] = freeze i1 [[COND]]
; CHECK-NEXT:    br i1 [[COND_FR]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [ %init, %entry ], [ %i.next, %loop ]
  %i.next = add nuw nsw i32 %i, 1
  call void @call(i32 %i.next)
  %cond = icmp eq i32 %i.next, %n
  %cond.fr = freeze i1 %cond
  br i1 %cond.fr, label %loop, label %exit

exit:
  ret void
}

define void @sub(i32 %init, i32 %n) {
; CHECK-LABEL: @sub(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INIT_FROZEN:%.*]] = freeze i32 [[INIT:%.*]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT_FROZEN]], [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT]] = sub i32 [[I]], 1
; CHECK-NEXT:    call void @call(i32 [[I_NEXT]])
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [%init, %entry], [%i.next, %loop]
  %i.next = sub nuw nsw i32 %i, 1
  %i.next.fr = freeze i32 %i.next
  call void @call(i32 %i.next.fr)
  %cond = icmp eq i32 %i.next.fr, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

define void @init_const(i32 %n) {
; CHECK-LABEL: @init_const(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT]] = add i32 [[I]], 1
; CHECK-NEXT:    call void @call(i32 [[I_NEXT]])
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [ 0, %entry ], [ %i.next, %loop ]
  %i.next = add nuw nsw i32 %i, 1
  %i.next.fr = freeze i32 %i.next
  call void @call(i32 %i.next.fr)
  %cond = icmp eq i32 %i.next.fr, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

define void @step_init_arg(i32 %init, i32 %n, i32 %step) {
; CHECK-LABEL: @step_init_arg(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[STEP_FROZEN:%.*]] = freeze i32 [[STEP:%.*]]
; CHECK-NEXT:    [[INIT_FROZEN:%.*]] = freeze i32 [[INIT:%.*]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT_FROZEN]], [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT]] = add i32 [[I]], [[STEP_FROZEN]]
; CHECK-NEXT:    call void @call(i32 [[I_NEXT]])
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [%init, %entry], [%i.next, %loop]
  %i.next = add nuw nsw i32 %i, %step
  %i.next.fr = freeze i32 %i.next
  call void @call(i32 %i.next.fr)
  %cond = icmp eq i32 %i.next.fr, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

define void @step_init_arg_multiuses(i32 %init, i32 %n, i32 %step) {
; CHECK-LABEL: @step_init_arg_multiuses(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[STEP_FROZEN:%.*]] = freeze i32 [[STEP:%.*]]
; CHECK-NEXT:    [[INIT_FROZEN:%.*]] = freeze i32 [[INIT:%.*]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT_FROZEN]], [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT]] = add i32 [[I]], [[STEP_FROZEN]]
; CHECK-NEXT:    call void @call(i32 [[I_NEXT]])
; CHECK-NEXT:    call void @call(i32 [[I_NEXT]])
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [ %init, %entry ], [ %i.next, %loop ]
  %i.next = add nsw nuw i32 %i, %step
  %i.next.fr1 = freeze i32 %i.next
  call void @call(i32 %i.next.fr1)
  %i.next.fr2 = freeze i32 %i.next
  call void @call(i32 %i.next.fr2)
  %cond = icmp eq i32 %i.next, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

define void @step_init_arg_multiuses2(i32 %init, i32 %n, i32 %step) {
; CHECK-LABEL: @step_init_arg_multiuses2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[STEP_FROZEN:%.*]] = freeze i32 [[STEP:%.*]]
; CHECK-NEXT:    [[INIT_FROZEN:%.*]] = freeze i32 [[INIT:%.*]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT_FROZEN]], [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    call void @call(i32 [[I]])
; CHECK-NEXT:    call void @call(i32 [[I]])
; CHECK-NEXT:    [[I_NEXT]] = add i32 [[I]], [[STEP_FROZEN]]
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [ %init, %entry ], [ %i.next, %loop ]
  %i.fr1 = freeze i32 %i
  call void @call(i32 %i.fr1)
  %i.fr2 = freeze i32 %i
  call void @call(i32 %i.fr2)
  %i.next = add nsw nuw i32 %i, %step
  %cond = icmp eq i32 %i.next, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

define void @step_init_inst(i32 %n) {
; CHECK-LABEL: @step_init_inst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[STEP:%.*]] = call i32 @get_step()
; CHECK-NEXT:    [[INIT:%.*]] = call i32 @get_step()
; CHECK-NEXT:    [[STEP_FROZEN:%.*]] = freeze i32 [[STEP]]
; CHECK-NEXT:    [[INIT_FROZEN:%.*]] = freeze i32 [[INIT]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT_FROZEN]], [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT]] = add i32 [[I]], [[STEP_FROZEN]]
; CHECK-NEXT:    call void @call(i32 [[I_NEXT]])
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %step = call i32 @get_step()
  %init = call i32 @get_step()
  br label %loop

loop:
  %i = phi i32 [%init, %entry], [%i.next, %loop]
  %i.next = add nuw nsw i32 %i, %step
  %i.next.fr = freeze i32 %i.next
  call void @call(i32 %i.next.fr)
  %cond = icmp eq i32 %i.next.fr, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

; Negative test
define void @step_inst(i32 %init, i32 %n) {
; CHECK-LABEL: @step_inst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INIT:%.*]], [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT]] = add nuw nsw i32 [[I]], [[I]]
; CHECK-NEXT:    [[I_NEXT_FR:%.*]] = freeze i32 [[I_NEXT]]
; CHECK-NEXT:    call void @call(i32 [[I_NEXT_FR]])
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[I_NEXT_FR]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [%init, %entry], [%i.next, %loop]
  %i.next = add nuw nsw i32 %i, %i
  %i.next.fr = freeze i32 %i.next
  call void @call(i32 %i.next.fr)
  %cond = icmp eq i32 %i.next.fr, %n
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

; Negative test
define void @gep(i8* %init, i8* %end) {
; CHECK-LABEL: @gep(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i8* [ [[INIT:%.*]], [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[I_NEXT]] = getelementptr inbounds i8, i8* [[I]], i64 1
; CHECK-NEXT:    [[I_NEXT_FR:%.*]] = freeze i8* [[I_NEXT]]
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i8* [[I_NEXT_FR]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i8* [ %init, %entry], [%i.next, %loop ]
  %i.next = getelementptr inbounds i8, i8* %i, i64 1
  %i.next.fr = freeze i8* %i.next
  %cond = icmp eq i8* %i.next.fr, %end
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}
