/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.pdf;

import de.erichseifert.vectorgraphics2d.pdf.PDFObject;
import de.erichseifert.vectorgraphics2d.pdf.Page;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class PageTreeNode
implements PDFObject {
    private final PageTreeNode parent;
    private final List<Page> children;

    public PageTreeNode(PageTreeNode pageTreeNode) {
        this.parent = pageTreeNode;
        this.children = new LinkedList<Page>();
    }

    public String getType() {
        return "Pages";
    }

    public PageTreeNode getParent() {
        return this.parent;
    }

    public void add(Page page) {
        page.setParent(this);
        this.children.add(page);
    }

    public List<Page> getKids() {
        return Collections.unmodifiableList(this.children);
    }

    public int getCount() {
        return this.children.size();
    }
}

