[comment {-*- tcl -*- doctools}]
[manpage_begin img-intro n 1.4]
[moddesc Img]
[titledesc {Introduction to Img}]
[copyright {1995-2009 Jan Nijtmans <nijtmans@users.sourceforge.net>}]
[require Tk]
[require Img [opt 1.4]]
[description]

[package Img] is a [package Tk] extension, adding support for many
other Image formats, as listed below. The individual formats are
described in more detail on their own pages.

[list_begin definitions]

[lst_item [term bmp]]
Windows bitmap format.
See [cmd img-bmp].

[lst_item [term dted]]
DTED terrain elevation data interpreted as image.
See [cmd img-dted].

[lst_item [term gif]]
The venerable graphics interchange format (with transparency, but
without LZW. The latter due to patent issues).
See [cmd img-gif].

[lst_item [term ico]]
Windows icon files.
See [cmd img-ico].

[lst_item [term jpeg]]
The format for lossy compressed still pictures specified by the Joint
Picture Experts Group.
See [cmd img-jpeg].

[lst_item [term pcx]]
Paintbrush image format.
See [cmd img-pcx].

[lst_item [term pixmap]]
While the other formats are handlers for the [package Tk] photo image
type this is a new image type for [package Tk].
See [cmd img-pixmap].

[lst_item [term png]]
Portable Network Graphics, successor to GIF.
See [cmd img-png].

[lst_item [term ppm]]
Portable Pixmaps.
See [cmd img-ppm].

[lst_item [term ps]]
Postscript and PDF (Portable document format). Requires an external
application, [syscmd ghostview], for its operation.
See [cmd img-ps].

[lst_item [term raw]]
Raw matrix data interpreted as image.
See [cmd img-raw].

[lst_item [term sgi]]
Native SGI format.
See [cmd img-sgi].

[lst_item [term sun]]
Sun raster images.
See [cmd img-sun].

[lst_item [term tga]]
Targa files.
See [cmd img-tga].

[lst_item [term tiff]]
Tagged Interchange File Format.
See [cmd img-tiff].

[lst_item [term window]]
Put the content of a Tk window into an image.
See [cmd img-window].

[lst_item [term xbm]]
X Bitmaps.
See [cmd img-xbm].

[lst_item [term xpm]]
X Pixmaps.
See [cmd img-xpm].

[list_end]

This version only works with Tcl/Tk 8.3 or higher.
If you are using Tk 8.2, please use Img 1.3.
If you are using Tk 8.1 or lower please stick with Img 1.2.4 (which is still
available). 
And if you are using Tk4.2 or lower, please stick with Img
1.1.4 (which is also still available).

[see_also img-bmp img-dted img-gif img-ico img-jpeg img-pcx img-pixmap img-png img-ppm img-ps img-raw img-sgi img-sun img-tga img-tiff img-window img-xbm img-xpm]
[keywords {image handling} tk xpm xbm gif png ppm tiff tga sun sgi postscript ps pdf pixmap pcx ico bmp window jpeg]
[manpage_end]
