/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File DragWindow.h
// Baudouin Raoult - ECMWF Nov 98

#ifndef DragWindow_H
#define DragWindow_H


// 
#include "inc_stl.h"
#include <Xm/Xm.h>
#include <drop.h>

#include "DropSite.h"

class IconObject;
class IconObjectH;

class DragWindow : public DropSite  {
public:

// -- Exceptions
	// None

// -- Contructors

	DragWindow();

// -- Destructor

	virtual ~DragWindow(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	void install(Widget);
	vector<IconObjectH> selection();
	void selectAll();
	void selectNone();


	virtual Widget menu() = 0;

	virtual void move(IconObject*,int,int,IconObject*); 
	virtual void copy(IconObject*,int,int,IconObject*); 

	virtual void doubleClick(IconObject*) ; 
	virtual void rename(IconObject*,const string&) ; 
	virtual bool renamable(IconObject*) ; 

	virtual IconObject* objectOf(Icon);
	virtual const IconClass*  classOf(Icon);
	virtual Dropping*   dropping(IconObject*i,bool);
	virtual bool dropCopy() = 0;

// -- Overridden methods


// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members

	vector<IconObjectH> current_;
	Widget widget_;

	int menu_x_;
	int menu_y_;

// -- Methods
	
	virtual void click(XEvent*);

	void addIcon(IconObject*, int = 0, int = 0);
	void removeAllIcons();
	void removeIcon(IconObject*);
	void sortByName();
	void sortByClass();
	void toggleSize();
	void refreshIcon(IconObject*);
	void openIcon(IconObject*);
	void closeIcon(IconObject*);
	void iconPosition(IconObject*,int&,int&);

	IconObject* objectAt(int x,int y);

	//virtual Dropping* getDropping() = 0;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods


private:

// No copy allowed
	
	DragWindow(const DragWindow&);
	DragWindow& operator=(const DragWindow&);

// -- Members
	

// -- Methods

	void sendDropCB(Widget w,dropid *id);
	void receiveDropCB(Widget w,dropid *id);

	void sendmsgCB( Widget, XtPointer);
	void answerCB( Widget, XtPointer);
	void dropCB( Widget, XtPointer);

	void doubleClickCB( Widget, XtPointer);
	void moveCB( Widget, XtPointer);

	void renameCB( Widget, XtPointer);
	void renamableCB( Widget, XtPointer);

	void flyOverCB( Widget, XtPointer);

	void getFullNameCB(Widget, XtPointer);

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	static void inputCB(Widget, XtPointer, XEvent* event, Boolean *);

	static void sendDropCB(Widget w,dropid *id, void*);
	static void receiveDropCB(Widget w,dropid *id, void*);

	static void sendmsgCB( Widget, XtPointer, XtPointer );
	static void answerCB( Widget, XtPointer, XtPointer );
	static void dropCB( Widget, XtPointer, XtPointer );

	static void doubleClickCB( Widget, XtPointer, XtPointer );
	static void moveCB( Widget, XtPointer, XtPointer );

	static void renameCB( Widget, XtPointer, XtPointer );
	static void renamableCB( Widget, XtPointer, XtPointer );

	static void flyOverCB( Widget, XtPointer, XtPointer );
	
	static void getFullNameCB( Widget, XtPointer, XtPointer );

// -- Friends

	//friend ostream& operator<<(ostream& s,const DragWindow& p)
	//	{ p.print(s); return s; }

};

inline void destroy(DragWindow**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(DragWindow);
//#endif

#endif
