/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit https://www.gnu.org/licenses/old-licenses/gpl-2.0.html

   ISO 3166 countries & UN M.49 regions

   Written by Moritz Bunkus <moritz@bunkus.org>.
*/

// ------------------------------------------------------------------------
// NOTE: this file is auto-generated by the "dev:iso3166_list" rake target.
// ------------------------------------------------------------------------

#include "common/common_pch.h"

#include "common/iso3166.h"

namespace mtx::iso3166 {

std::vector<region_t> g_regions;

struct region_init_t {
  char const *alpha_2_code, *alpha_3_code;
  unsigned int number;
  char const *name, *official_name;
  bool is_deprecated;
};

static region_init_t const s_regions_init[] = {
  { "",   "",      2, u8"Africa",                                               u8"",                                                                                                                               false },
  { "",   "",     19, u8"Americas",                                             u8"",                                                                                                                               false },
  { "",   "",    142, u8"Asia",                                                 u8"",                                                                                                                               false },
  { "",   "",     53, u8"Australia and New Zealand",                            u8"",                                                                                                                               false },
  { "",   "",     29, u8"Caribbean",                                            u8"",                                                                                                                               false },
  { "",   "",     13, u8"Central America",                                      u8"",                                                                                                                               false },
  { "",   "",    143, u8"Central Asia",                                         u8"",                                                                                                                               false },
  { "",   "",    830, u8"Channel Islands",                                      u8"",                                                                                                                               false },
  { "",   "",     14, u8"Eastern Africa",                                       u8"",                                                                                                                               false },
  { "",   "",     30, u8"Eastern Asia",                                         u8"",                                                                                                                               false },
  { "",   "",    151, u8"Eastern Europe",                                       u8"",                                                                                                                               false },
  { "",   "",    150, u8"Europe",                                               u8"",                                                                                                                               false },
  { "",   "",    419, u8"Latin America and the Caribbean",                      u8"",                                                                                                                               false },
  { "",   "",     54, u8"Melanesia",                                            u8"",                                                                                                                               false },
  { "",   "",     57, u8"Micronesia",                                           u8"",                                                                                                                               false },
  { "",   "",     17, u8"Middle Africa",                                        u8"",                                                                                                                               false },
  { "",   "",      3, u8"North America",                                        u8"",                                                                                                                               false },
  { "",   "",     15, u8"Northern Africa",                                      u8"",                                                                                                                               false },
  { "",   "",     21, u8"Northern America",                                     u8"",                                                                                                                               false },
  { "",   "",    154, u8"Northern Europe",                                      u8"",                                                                                                                               false },
  { "",   "",      9, u8"Oceania",                                              u8"",                                                                                                                               false },
  { "",   "",     61, u8"Polynesia",                                            u8"",                                                                                                                               false },
  { "",   "",    680, u8"Sark",                                                 u8"",                                                                                                                               false },
  { "",   "",      5, u8"South America",                                        u8"",                                                                                                                               false },
  { "",   "",     35, u8"South-eastern Asia",                                   u8"",                                                                                                                               false },
  { "",   "",     18, u8"Southern Africa",                                      u8"",                                                                                                                               false },
  { "",   "",     34, u8"Southern Asia",                                        u8"",                                                                                                                               false },
  { "",   "",     39, u8"Southern Europe",                                      u8"",                                                                                                                               false },
  { "",   "",    202, u8"Sub-Saharan Africa",                                   u8"",                                                                                                                               false },
  { "",   "",     11, u8"Western Africa",                                       u8"",                                                                                                                               false },
  { "",   "",    145, u8"Western Asia",                                         u8"",                                                                                                                               false },
  { "",   "",    155, u8"Western Europe",                                       u8"",                                                                                                                               false },
  { "",   "",      1, u8"World",                                                u8"",                                                                                                                               false },
  { "AA", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "AC", "",      0, u8"Ascension Island",                                     u8"",                                                                                                                               false },
  { "AD", "AND",  20, u8"Andorra",                                              u8"Principality of Andorra",                                                                                                        false },
  { "AE", "ARE", 784, u8"United Arab Emirates",                                 u8"",                                                                                                                               false },
  { "AF", "AFG",   4, u8"Afghanistan",                                          u8"Islamic Republic of Afghanistan",                                                                                                false },
  { "AG", "ATG",  28, u8"Antigua and Barbuda",                                  u8"",                                                                                                                               false },
  { "AI", "AIA", 660, u8"Anguilla",                                             u8"",                                                                                                                               false },
  { "AL", "ALB",   8, u8"Albania",                                              u8"Republic of Albania",                                                                                                            false },
  { "AM", "ARM",  51, u8"Armenia",                                              u8"Republic of Armenia",                                                                                                            false },
  { "AN", "",      0, u8"Netherlands Antilles",                                 u8"",                                                                                                                               true  },
  { "AO", "AGO",  24, u8"Angola",                                               u8"Republic of Angola",                                                                                                             false },
  { "AQ", "ATA",  10, u8"Antarctica",                                           u8"All land and ice shelves south of the 60th parallel south",                                                                      false },
  { "AR", "ARG",  32, u8"Argentina",                                            u8"Argentine Republic",                                                                                                             false },
  { "AS", "ASM",  16, u8"American Samoa",                                       u8"Territory of American Samoa",                                                                                                    false },
  { "AT", "AUT",  40, u8"Austria",                                              u8"Republic of Austria",                                                                                                            false },
  { "AU", "AUS",  36, u8"Australia",                                            u8"Commonwealth of Australia",                                                                                                      false },
  { "AW", "ABW", 533, u8"Aruba",                                                u8"",                                                                                                                               false },
  { "AX", "ALA", 248, u8"Åland Islands",                                        u8"Åland",                                                                                                                          false },
  { "AZ", "AZE",  31, u8"Azerbaijan",                                           u8"Republic of Azerbaijan",                                                                                                         false },
  { "BA", "BIH",  70, u8"Bosnia and Herzegovina",                               u8"",                                                                                                                               false },
  { "BB", "BRB",  52, u8"Barbados",                                             u8"",                                                                                                                               false },
  { "BD", "BGD",  50, u8"Bangladesh",                                           u8"People's Republic of Bangladesh",                                                                                                false },
  { "BE", "BEL",  56, u8"Belgium",                                              u8"Kingdom of Belgium",                                                                                                             false },
  { "BF", "BFA", 854, u8"Burkina Faso",                                         u8"",                                                                                                                               false },
  { "BG", "BGR", 100, u8"Bulgaria",                                             u8"Republic of Bulgaria",                                                                                                           false },
  { "BH", "BHR",  48, u8"Bahrain",                                              u8"Kingdom of Bahrain",                                                                                                             false },
  { "BI", "BDI", 108, u8"Burundi",                                              u8"Republic of Burundi",                                                                                                            false },
  { "BJ", "BEN", 204, u8"Benin",                                                u8"Republic of Benin",                                                                                                              false },
  { "BL", "BLM", 652, u8"Saint Barthélemy",                                     u8"Collectivity of Saint-Barthélemy",                                                                                               false },
  { "BM", "BMU",  60, u8"Bermuda",                                              u8"",                                                                                                                               false },
  { "BN", "BRN",  96, u8"Brunei Darussalam",                                    u8"Nation of Brunei, the Abode of Peace",                                                                                           false },
  { "BO", "BOL",  68, u8"Bolivia (Plurinational State of)",                     u8"Plurinational State of Bolivia",                                                                                                 false },
  { "BQ", "BES", 535, u8"Bonaire, Sint Eustatius and Saba",                     u8"",                                                                                                                               false },
  { "BR", "BRA",  76, u8"Brazil",                                               u8"Federative Republic of Brazil",                                                                                                  false },
  { "BS", "BHS",  44, u8"Bahamas",                                              u8"Commonwealth of The Bahamas",                                                                                                    false },
  { "BT", "BTN",  64, u8"Bhutan",                                               u8"Kingdom of Bhutan",                                                                                                              false },
  { "BU", "",      0, u8"Burma",                                                u8"",                                                                                                                               true  },
  { "BV", "BVT",  74, u8"Bouvet Island",                                        u8"",                                                                                                                               false },
  { "BW", "BWA",  72, u8"Botswana",                                             u8"Republic of Botswana",                                                                                                           false },
  { "BY", "BLR", 112, u8"Belarus",                                              u8"Republic of Belarus",                                                                                                            false },
  { "BZ", "BLZ",  84, u8"Belize",                                               u8"",                                                                                                                               false },
  { "CA", "CAN", 124, u8"Canada",                                               u8"",                                                                                                                               false },
  { "CC", "CCK", 166, u8"Cocos (Keeling) Islands",                              u8"Territory of Cocos (Keeling) Islands",                                                                                           false },
  { "CD", "COD", 180, u8"Congo (the Democratic Republic of the)",               u8"Democratic Republic of the Congo",                                                                                               false },
  { "CF", "CAF", 140, u8"Central African Republic",                             u8"",                                                                                                                               false },
  { "CG", "COG", 178, u8"Congo",                                                u8"Republic of the Congo",                                                                                                          false },
  { "CH", "CHE", 756, u8"Switzerland",                                          u8"Swiss Confederation",                                                                                                            false },
  { "CI", "CIV", 384, u8"Côte d'Ivoire",                                        u8"Republic of Côte d'Ivoire",                                                                                                      false },
  { "CK", "COK", 184, u8"Cook Islands",                                         u8"",                                                                                                                               false },
  { "CL", "CHL", 152, u8"Chile",                                                u8"Republic of Chile",                                                                                                              false },
  { "CM", "CMR", 120, u8"Cameroon",                                             u8"Republic of Cameroon",                                                                                                           false },
  { "CN", "CHN", 156, u8"China",                                                u8"People's Republic of China",                                                                                                     false },
  { "CO", "COL", 170, u8"Colombia",                                             u8"Republic of Colombia",                                                                                                           false },
  { "CP", "",      0, u8"Clipperton Island",                                    u8"",                                                                                                                               false },
  { "CR", "CRI", 188, u8"Costa Rica",                                           u8"Republic of Costa Rica",                                                                                                         false },
  { "CS", "",      0, u8"Serbia and Montenegro",                                u8"",                                                                                                                               true  },
  { "CU", "CUB", 192, u8"Cuba",                                                 u8"Republic of Cuba",                                                                                                               false },
  { "CV", "CPV", 132, u8"Cabo Verde",                                           u8"Republic of Cabo Verde",                                                                                                         false },
  { "CW", "CUW", 531, u8"Curaçao",                                              u8"Country of Curaçao",                                                                                                             false },
  { "CX", "CXR", 162, u8"Christmas Island",                                     u8"Territory of Christmas Island",                                                                                                  false },
  { "CY", "CYP", 196, u8"Cyprus",                                               u8"Republic of Cyprus",                                                                                                             false },
  { "CZ", "CZE", 203, u8"Czechia",                                              u8"Czech Republic",                                                                                                                 false },
  { "DD", "",      0, u8"German Democratic Republic",                           u8"",                                                                                                                               true  },
  { "DE", "DEU", 276, u8"Germany",                                              u8"Federal Republic of Germany",                                                                                                    false },
  { "DG", "",      0, u8"Diego Garcia",                                         u8"",                                                                                                                               false },
  { "DJ", "DJI", 262, u8"Djibouti",                                             u8"Republic of Djibouti",                                                                                                           false },
  { "DK", "DNK", 208, u8"Denmark",                                              u8"Kingdom of Denmark",                                                                                                             false },
  { "DM", "DMA", 212, u8"Dominica",                                             u8"Commonwealth of Dominica",                                                                                                       false },
  { "DO", "DOM", 214, u8"Dominican Republic",                                   u8"",                                                                                                                               false },
  { "DZ", "DZA",  12, u8"Algeria",                                              u8"People's Democratic Republic of Algeria",                                                                                        false },
  { "EA", "",      0, u8"Ceuta, Melilla",                                       u8"",                                                                                                                               false },
  { "EC", "ECU", 218, u8"Ecuador",                                              u8"Republic of Ecuador",                                                                                                            false },
  { "EE", "EST", 233, u8"Estonia",                                              u8"Republic of Estonia",                                                                                                            false },
  { "EG", "EGY", 818, u8"Egypt",                                                u8"Arab Republic of Egypt",                                                                                                         false },
  { "EH", "ESH", 732, u8"Western Sahara",                                       u8"Sahrawi Arab Democratic Republic",                                                                                               false },
  { "ER", "ERI", 232, u8"Eritrea",                                              u8"State of Eritrea",                                                                                                               false },
  { "ES", "ESP", 724, u8"Spain",                                                u8"Kingdom of Spain",                                                                                                               false },
  { "ET", "ETH", 231, u8"Ethiopia",                                             u8"Federal Democratic Republic of Ethiopia",                                                                                        false },
  { "EU", "",      0, u8"European Union",                                       u8"",                                                                                                                               false },
  { "EZ", "",      0, u8"Eurozone",                                             u8"",                                                                                                                               false },
  { "FI", "FIN", 246, u8"Finland",                                              u8"Republic of Finland",                                                                                                            false },
  { "FJ", "FJI", 242, u8"Fiji",                                                 u8"Republic of Fiji",                                                                                                               false },
  { "FK", "FLK", 238, u8"Falkland Islands",                                     u8"",                                                                                                                               false },
  { "FM", "FSM", 583, u8"Micronesia (Federated States of)",                     u8"Federated States of Micronesia",                                                                                                 false },
  { "FO", "FRO", 234, u8"Faroe Islands",                                        u8"",                                                                                                                               false },
  { "FR", "FRA", 250, u8"France",                                               u8"French Republic",                                                                                                                false },
  { "FX", "",      0, u8"Metropolitan France",                                  u8"",                                                                                                                               true  },
  { "GA", "GAB", 266, u8"Gabon",                                                u8"Gabonese Republic",                                                                                                              false },
  { "GB", "GBR", 826, u8"United Kingdom of Great Britain and Northern Ireland", u8"",                                                                                                                               false },
  { "GD", "GRD", 308, u8"Grenada",                                              u8"",                                                                                                                               false },
  { "GE", "GEO", 268, u8"Georgia",                                              u8"",                                                                                                                               false },
  { "GF", "GUF", 254, u8"French Guiana",                                        u8"Guyane",                                                                                                                         false },
  { "GG", "GGY", 831, u8"Guernsey",                                             u8"Bailiwick of Guernsey",                                                                                                          false },
  { "GH", "GHA", 288, u8"Ghana",                                                u8"Republic of Ghana",                                                                                                              false },
  { "GI", "GIB", 292, u8"Gibraltar",                                            u8"",                                                                                                                               false },
  { "GL", "GRL", 304, u8"Greenland",                                            u8"Kalaallit Nunaat",                                                                                                               false },
  { "GM", "GMB", 270, u8"Gambia",                                               u8"Republic of The Gambia",                                                                                                         false },
  { "GN", "GIN", 324, u8"Guinea",                                               u8"Republic of Guinea",                                                                                                             false },
  { "GP", "GLP", 312, u8"Guadeloupe",                                           u8"",                                                                                                                               false },
  { "GQ", "GNQ", 226, u8"Equatorial Guinea",                                    u8"Republic of Equatorial Guinea",                                                                                                  false },
  { "GR", "GRC", 300, u8"Greece",                                               u8"Hellenic Republic",                                                                                                              false },
  { "GS", "SGS", 239, u8"South Georgia and the South Sandwich Islands",         u8"",                                                                                                                               false },
  { "GT", "GTM", 320, u8"Guatemala",                                            u8"Republic of Guatemala",                                                                                                          false },
  { "GU", "GUM", 316, u8"Guam",                                                 u8"Territory of Guam",                                                                                                              false },
  { "GW", "GNB", 624, u8"Guinea-Bissau",                                        u8"Republic of Guinea-Bissau",                                                                                                      false },
  { "GY", "GUY", 328, u8"Guyana",                                               u8"Co-operative Republic of Guyana",                                                                                                false },
  { "HK", "HKG", 344, u8"Hong Kong",                                            u8"Hong Kong Special Administrative Region of China",                                                                               false },
  { "HM", "HMD", 334, u8"Heard Island and McDonald Islands",                    u8"Territory of Heard Island and McDonald Islands",                                                                                 false },
  { "HN", "HND", 340, u8"Honduras",                                             u8"Republic of Honduras",                                                                                                           false },
  { "HR", "HRV", 191, u8"Croatia",                                              u8"Republic of Croatia",                                                                                                            false },
  { "HT", "HTI", 332, u8"Haiti",                                                u8"Republic of Haiti",                                                                                                              false },
  { "HU", "HUN", 348, u8"Hungary",                                              u8"",                                                                                                                               false },
  { "IC", "",      0, u8"Canary Islands",                                       u8"",                                                                                                                               false },
  { "ID", "IDN", 360, u8"Indonesia",                                            u8"Republic of Indonesia",                                                                                                          false },
  { "IE", "IRL", 372, u8"Ireland",                                              u8"",                                                                                                                               false },
  { "IL", "ISR", 376, u8"Israel",                                               u8"State of Israel",                                                                                                                false },
  { "IM", "IMN", 833, u8"Isle of Man",                                          u8"",                                                                                                                               false },
  { "IN", "IND", 356, u8"India",                                                u8"Republic of India",                                                                                                              false },
  { "IO", "IOT",  86, u8"British Indian Ocean Territory",                       u8"",                                                                                                                               false },
  { "IQ", "IRQ", 368, u8"Iraq",                                                 u8"Republic of Iraq",                                                                                                               false },
  { "IR", "IRN", 364, u8"Iran (Islamic Republic of)",                           u8"Islamic Republic of Iran",                                                                                                       false },
  { "IS", "ISL", 352, u8"Iceland",                                              u8"",                                                                                                                               false },
  { "IT", "ITA", 380, u8"Italy",                                                u8"Italian Republic",                                                                                                               false },
  { "JE", "JEY", 832, u8"Jersey",                                               u8"Bailiwick of Jersey",                                                                                                            false },
  { "JM", "JAM", 388, u8"Jamaica",                                              u8"",                                                                                                                               false },
  { "JO", "JOR", 400, u8"Jordan",                                               u8"Hashemite Kingdom of Jordan",                                                                                                    false },
  { "JP", "JPN", 392, u8"Japan",                                                u8"",                                                                                                                               false },
  { "KE", "KEN", 404, u8"Kenya",                                                u8"Republic of Kenya",                                                                                                              false },
  { "KG", "KGZ", 417, u8"Kyrgyzstan",                                           u8"Kyrgyz Republic",                                                                                                                false },
  { "KH", "KHM", 116, u8"Cambodia",                                             u8"Kingdom of Cambodia",                                                                                                            false },
  { "KI", "KIR", 296, u8"Kiribati",                                             u8"Republic of Kiribati",                                                                                                           false },
  { "KM", "COM", 174, u8"Comoros",                                              u8"Union of the Comoros",                                                                                                           false },
  { "KN", "KNA", 659, u8"Saint Kitts and Nevis",                                u8"",                                                                                                                               false },
  { "KP", "PRK", 408, u8"Korea (the Democratic People's Republic of)",          u8"Democratic People's Republic of Korea",                                                                                          false },
  { "KR", "KOR", 410, u8"Korea (the Republic of)",                              u8"Republic of Korea",                                                                                                              false },
  { "KW", "KWT", 414, u8"Kuwait",                                               u8"State of Kuwait",                                                                                                                false },
  { "KY", "CYM", 136, u8"Cayman Islands",                                       u8"",                                                                                                                               false },
  { "KZ", "KAZ", 398, u8"Kazakhstan",                                           u8"Republic of Kazakhstan",                                                                                                         false },
  { "LA", "LAO", 418, u8"Lao People's Democratic Republic",                     u8"",                                                                                                                               false },
  { "LB", "LBN", 422, u8"Lebanon",                                              u8"Lebanese Republic",                                                                                                              false },
  { "LC", "LCA", 662, u8"Saint Lucia",                                          u8"",                                                                                                                               false },
  { "LI", "LIE", 438, u8"Liechtenstein",                                        u8"Principality of Liechtenstein",                                                                                                  false },
  { "LK", "LKA", 144, u8"Sri Lanka",                                            u8"Democratic Socialist Republic of Sri Lanka",                                                                                     false },
  { "LR", "LBR", 430, u8"Liberia",                                              u8"Republic of Liberia",                                                                                                            false },
  { "LS", "LSO", 426, u8"Lesotho",                                              u8"Kingdom of Lesotho",                                                                                                             false },
  { "LT", "LTU", 440, u8"Lithuania",                                            u8"Republic of Lithuania",                                                                                                          false },
  { "LU", "LUX", 442, u8"Luxembourg",                                           u8"Grand Duchy of Luxembourg",                                                                                                      false },
  { "LV", "LVA", 428, u8"Latvia",                                               u8"Republic of Latvia",                                                                                                             false },
  { "LY", "LBY", 434, u8"Libya",                                                u8"State of Libya",                                                                                                                 false },
  { "MA", "MAR", 504, u8"Morocco",                                              u8"Kingdom of Morocco",                                                                                                             false },
  { "MC", "MCO", 492, u8"Monaco",                                               u8"Principality of Monaco",                                                                                                         false },
  { "MD", "MDA", 498, u8"Moldova (the Republic of)",                            u8"Republic of Moldova",                                                                                                            false },
  { "ME", "MNE", 499, u8"Montenegro",                                           u8"",                                                                                                                               false },
  { "MF", "MAF", 663, u8"Saint Martin (French part)",                           u8"Collectivity of Saint-Martin",                                                                                                   false },
  { "MG", "MDG", 450, u8"Madagascar",                                           u8"Republic of Madagascar",                                                                                                         false },
  { "MH", "MHL", 584, u8"Marshall Islands",                                     u8"Republic of the Marshall Islands",                                                                                               false },
  { "MK", "MKD", 807, u8"North Macedonia",                                      u8"Republic of North Macedonia",                                                                                                    false },
  { "ML", "MLI", 466, u8"Mali",                                                 u8"Republic of Mali",                                                                                                               false },
  { "MM", "MMR", 104, u8"Myanmar",                                              u8"Republic of the Union of Myanmar",                                                                                               false },
  { "MN", "MNG", 496, u8"Mongolia",                                             u8"",                                                                                                                               false },
  { "MO", "MAC", 446, u8"Macao",                                                u8"Macao Special Administrative Region of China",                                                                                   false },
  { "MP", "MNP", 580, u8"Northern Mariana Islands",                             u8"Commonwealth of the Northern Mariana Islands",                                                                                   false },
  { "MQ", "MTQ", 474, u8"Martinique",                                           u8"",                                                                                                                               false },
  { "MR", "MRT", 478, u8"Mauritania",                                           u8"Islamic Republic of Mauritania",                                                                                                 false },
  { "MS", "MSR", 500, u8"Montserrat",                                           u8"",                                                                                                                               false },
  { "MT", "MLT", 470, u8"Malta",                                                u8"Republic of Malta",                                                                                                              false },
  { "MU", "MUS", 480, u8"Mauritius",                                            u8"Republic of Mauritius",                                                                                                          false },
  { "MV", "MDV", 462, u8"Maldives",                                             u8"Republic of Maldives",                                                                                                           false },
  { "MW", "MWI", 454, u8"Malawi",                                               u8"Republic of Malawi",                                                                                                             false },
  { "MX", "MEX", 484, u8"Mexico",                                               u8"United Mexican States",                                                                                                          false },
  { "MY", "MYS", 458, u8"Malaysia",                                             u8"",                                                                                                                               false },
  { "MZ", "MOZ", 508, u8"Mozambique",                                           u8"Republic of Mozambique",                                                                                                         false },
  { "NA", "NAM", 516, u8"Namibia",                                              u8"Republic of Namibia",                                                                                                            false },
  { "NC", "NCL", 540, u8"New Caledonia",                                        u8"",                                                                                                                               false },
  { "NE", "NER", 562, u8"Niger",                                                u8"Republic of the Niger",                                                                                                          false },
  { "NF", "NFK", 574, u8"Norfolk Island",                                       u8"Territory of Norfolk Island",                                                                                                    false },
  { "NG", "NGA", 566, u8"Nigeria",                                              u8"Federal Republic of Nigeria",                                                                                                    false },
  { "NI", "NIC", 558, u8"Nicaragua",                                            u8"Republic of Nicaragua",                                                                                                          false },
  { "NL", "NLD", 528, u8"Netherlands",                                          u8"Kingdom of the Netherlands",                                                                                                     false },
  { "NO", "NOR", 578, u8"Norway",                                               u8"Kingdom of Norway",                                                                                                              false },
  { "NP", "NPL", 524, u8"Nepal",                                                u8"Federal Democratic Republic of Nepal",                                                                                           false },
  { "NR", "NRU", 520, u8"Nauru",                                                u8"Republic of Nauru",                                                                                                              false },
  { "NT", "",      0, u8"Neutral Zone",                                         u8"",                                                                                                                               true  },
  { "NU", "NIU", 570, u8"Niue",                                                 u8"",                                                                                                                               false },
  { "NZ", "NZL", 554, u8"New Zealand",                                          u8"",                                                                                                                               false },
  { "OM", "OMN", 512, u8"Oman",                                                 u8"Sultanate of Oman",                                                                                                              false },
  { "PA", "PAN", 591, u8"Panama",                                               u8"Republic of Panamá",                                                                                                             false },
  { "PE", "PER", 604, u8"Peru",                                                 u8"Republic of Perú",                                                                                                               false },
  { "PF", "PYF", 258, u8"French Polynesia",                                     u8"",                                                                                                                               false },
  { "PG", "PNG", 598, u8"Papua New Guinea",                                     u8"Independent State of Papua New Guinea",                                                                                          false },
  { "PH", "PHL", 608, u8"Philippines",                                          u8"Republic of the Philippines",                                                                                                    false },
  { "PK", "PAK", 586, u8"Pakistan",                                             u8"Islamic Republic of Pakistan",                                                                                                   false },
  { "PL", "POL", 616, u8"Poland",                                               u8"Republic of Poland",                                                                                                             false },
  { "PM", "SPM", 666, u8"Saint Pierre and Miquelon",                            u8"Overseas Collectivity of Saint-Pierre and Miquelon",                                                                             false },
  { "PN", "PCN", 612, u8"Pitcairn",                                             u8"Pitcairn, Henderson, Ducie and Oeno Islands",                                                                                    false },
  { "PR", "PRI", 630, u8"Puerto Rico",                                          u8"Commonwealth of Puerto Rico",                                                                                                    false },
  { "PS", "PSE", 275, u8"Palestine, State of",                                  u8"State of Palestine",                                                                                                             false },
  { "PT", "PRT", 620, u8"Portugal",                                             u8"Portuguese Republic",                                                                                                            false },
  { "PW", "PLW", 585, u8"Palau",                                                u8"Republic of Palau",                                                                                                              false },
  { "PY", "PRY", 600, u8"Paraguay",                                             u8"Republic of Paraguay",                                                                                                           false },
  { "QA", "QAT", 634, u8"Qatar",                                                u8"State of Qatar",                                                                                                                 false },
  { "QM", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "QN", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "QO", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "QP", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "QQ", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "QR", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "QS", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "QT", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "QU", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "QV", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "QW", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "QX", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "QY", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "QZ", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "RE", "REU", 638, u8"Réunion",                                              u8"",                                                                                                                               false },
  { "RO", "ROU", 642, u8"Romania",                                              u8"",                                                                                                                               false },
  { "RS", "SRB", 688, u8"Serbia",                                               u8"Republic of Serbia",                                                                                                             false },
  { "RU", "RUS", 643, u8"Russian Federation",                                   u8"",                                                                                                                               false },
  { "RW", "RWA", 646, u8"Rwanda",                                               u8"Republic of Rwanda",                                                                                                             false },
  { "SA", "SAU", 682, u8"Saudi Arabia",                                         u8"Kingdom of Saudi Arabia",                                                                                                        false },
  { "SB", "SLB",  90, u8"Solomon Islands",                                      u8"",                                                                                                                               false },
  { "SC", "SYC", 690, u8"Seychelles",                                           u8"Republic of Seychelles",                                                                                                         false },
  { "SD", "SDN", 729, u8"Sudan",                                                u8"Republic of the Sudan",                                                                                                          false },
  { "SE", "SWE", 752, u8"Sweden",                                               u8"Kingdom of Sweden",                                                                                                              false },
  { "SG", "SGP", 702, u8"Singapore",                                            u8"Republic of Singapore",                                                                                                          false },
  { "SH", "SHN", 654, u8"Saint Helena, Ascension Island and Tristan da Cunha",  u8"Saint Helena, Ascension and Tristan da Cunha",                                                                                   false },
  { "SI", "SVN", 705, u8"Slovenia",                                             u8"Republic of Slovenia",                                                                                                           false },
  { "SJ", "SJM", 744, u8"Svalbard, Jan Mayen",                                  u8"Svalbard and Jan Mayen",                                                                                                         false },
  { "SK", "SVK", 703, u8"Slovakia",                                             u8"Slovak Republic",                                                                                                                false },
  { "SL", "SLE", 694, u8"Sierra Leone",                                         u8"Republic of Sierra Leone",                                                                                                       false },
  { "SM", "SMR", 674, u8"San Marino",                                           u8"Republic of San Marino",                                                                                                         false },
  { "SN", "SEN", 686, u8"Senegal",                                              u8"Republic of Senegal",                                                                                                            false },
  { "SO", "SOM", 706, u8"Somalia",                                              u8"Federal Republic of Somalia",                                                                                                    false },
  { "SR", "SUR", 740, u8"Suriname",                                             u8"Republic of Suriname",                                                                                                           false },
  { "SS", "SSD", 728, u8"South Sudan",                                          u8"Republic of South Sudan",                                                                                                        false },
  { "ST", "STP", 678, u8"Sao Tome and Principe",                                u8"Democratic Republic of São Tomé and Príncipe",                                                                                   false },
  { "SU", "",      0, u8"Union of Soviet Socialist Republics",                  u8"",                                                                                                                               true  },
  { "SV", "SLV", 222, u8"El Salvador",                                          u8"Republic of El Salvador",                                                                                                        false },
  { "SX", "SXM", 534, u8"Sint Maarten (Dutch part)",                            u8"Sint Maarten",                                                                                                                   false },
  { "SY", "SYR", 760, u8"Syrian Arab Republic",                                 u8"",                                                                                                                               false },
  { "SZ", "SWZ", 748, u8"Eswatini",                                             u8"Kingdom of Eswatini",                                                                                                            false },
  { "TA", "",      0, u8"Tristan da Cunha",                                     u8"",                                                                                                                               false },
  { "TC", "TCA", 796, u8"Turks and Caicos Islands",                             u8"",                                                                                                                               false },
  { "TD", "TCD", 148, u8"Chad",                                                 u8"Republic of Chad",                                                                                                               false },
  { "TF", "ATF", 260, u8"French Southern Territories",                          u8"French Southern and Antarctic Lands",                                                                                            false },
  { "TG", "TGO", 768, u8"Togo",                                                 u8"Togolese Republic",                                                                                                              false },
  { "TH", "THA", 764, u8"Thailand",                                             u8"Kingdom of Thailand",                                                                                                            false },
  { "TJ", "TJK", 762, u8"Tajikistan",                                           u8"Republic of Tajikistan",                                                                                                         false },
  { "TK", "TKL", 772, u8"Tokelau",                                              u8"",                                                                                                                               false },
  { "TL", "TLS", 626, u8"Timor-Leste",                                          u8"Democratic Republic of Timor-Leste",                                                                                             false },
  { "TM", "TKM", 795, u8"Turkmenistan",                                         u8"",                                                                                                                               false },
  { "TN", "TUN", 788, u8"Tunisia",                                              u8"Republic of Tunisia",                                                                                                            false },
  { "TO", "TON", 776, u8"Tonga",                                                u8"Kingdom of Tonga",                                                                                                               false },
  { "TP", "",      0, u8"East Timor",                                           u8"",                                                                                                                               true  },
  { "TR", "TUR", 792, u8"Turkey",                                               u8"Republic of Turkey",                                                                                                             false },
  { "TT", "TTO", 780, u8"Trinidad and Tobago",                                  u8"Republic of Trinidad and Tobago",                                                                                                false },
  { "TV", "TUV", 798, u8"Tuvalu",                                               u8"",                                                                                                                               false },
  { "TW", "TWN", 158, u8"Taiwan (Province of China)",                           u8"Republic of China",                                                                                                              false },
  { "TZ", "TZA", 834, u8"Tanzania, the United Republic of",                     u8"United Republic of Tanzania",                                                                                                    false },
  { "UA", "UKR", 804, u8"Ukraine",                                              u8"",                                                                                                                               false },
  { "UG", "UGA", 800, u8"Uganda",                                               u8"Republic of Uganda",                                                                                                             false },
  { "UM", "UMI", 581, u8"United States Minor Outlying Islands",                 u8"BakerIsland, HowlandIsland, JarvisIsland, JohnstonAtoll, KingmanReef, MidwayAtoll, NavassaIsland, PalmyraAtoll, and WakeIsland", false },
  { "UN", "",      0, u8"United Nations",                                       u8"",                                                                                                                               false },
  { "US", "USA", 840, u8"United States of America",                             u8"",                                                                                                                               false },
  { "UY", "URY", 858, u8"Uruguay",                                              u8"Oriental Republic of Uruguay",                                                                                                   false },
  { "UZ", "UZB", 860, u8"Uzbekistan",                                           u8"Republic of Uzbekistan",                                                                                                         false },
  { "VA", "VAT", 336, u8"Holy See",                                             u8"",                                                                                                                               false },
  { "VC", "VCT", 670, u8"Saint Vincent and the Grenadines",                     u8"",                                                                                                                               false },
  { "VE", "VEN", 862, u8"Venezuela (Bolivarian Republic of)",                   u8"Bolivarian Republic of Venezuela",                                                                                               false },
  { "VG", "VGB",  92, u8"Virgin Islands (British)",                             u8"Virgin Islands",                                                                                                                 false },
  { "VI", "VIR", 850, u8"Virgin Islands (U.S.)",                                u8"Virgin Islands of the United States",                                                                                            false },
  { "VN", "VNM", 704, u8"Viet Nam",                                             u8"Socialist Republic of Viet Nam",                                                                                                 false },
  { "VU", "VUT", 548, u8"Vanuatu",                                              u8"Republic of Vanuatu",                                                                                                            false },
  { "WF", "WLF", 876, u8"Wallis and Futuna",                                    u8"Territory of the Wallis and Futuna Islands",                                                                                     false },
  { "WS", "WSM", 882, u8"Samoa",                                                u8"Independent State of Samoa",                                                                                                     false },
  { "XA", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XB", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XC", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XD", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XE", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XF", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XG", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XH", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XI", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XJ", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XK", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XL", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XM", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XN", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XO", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XP", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XQ", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XR", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XS", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XT", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XU", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XV", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XW", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XX", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XY", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "XZ", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
  { "YD", "",      0, u8"Democratic Yemen",                                     u8"",                                                                                                                               true  },
  { "YE", "YEM", 887, u8"Yemen",                                                u8"Republic of Yemen",                                                                                                              false },
  { "YT", "MYT", 175, u8"Mayotte",                                              u8"Department of Mayotte",                                                                                                          false },
  { "YU", "",      0, u8"Yugoslavia",                                           u8"",                                                                                                                               true  },
  { "ZA", "ZAF", 710, u8"South Africa",                                         u8"Republic of South Africa",                                                                                                       false },
  { "ZM", "ZMB", 894, u8"Zambia",                                               u8"Republic of Zambia",                                                                                                             false },
  { "ZR", "",      0, u8"Zaire",                                                u8"",                                                                                                                               true  },
  { "ZW", "ZWE", 716, u8"Zimbabwe",                                             u8"Republic of Zimbabwe",                                                                                                           false },
  { "ZZ", "",      0, u8"User-assigned",                                        u8"",                                                                                                                               false },
};

void
init() {
  g_regions.reserve(344);

  for (region_init_t const *region = s_regions_init, *end = region + 344; region < end; ++region)
    g_regions.emplace_back(region->alpha_2_code, region->alpha_3_code, region->number, region->name, region->official_name, region->is_deprecated);
}

} // namespace mtx::iso3166
