/*******************************************************************************
*                                                                              *
*   (C) 1997-2014 by Ernst W. Mayer.                                           *
*                                                                              *
*  This program is free software; you can redistribute it and/or modify it     *
*  under the terms of the GNU General Public License as published by the       *
*  Free Software Foundation; either version 2 of the License, or (at your      *
*  option) any later version.                                                  *
*                                                                              *
*  This program is distributed in the hope that it will be useful, but WITHOUT *
*  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
*  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for   *
*  more details.                                                               *
*                                                                              *
*  You should have received a copy of the GNU General Public License along     *
*  with this program; see the file GPL.txt.  If not, you may view one at       *
*  http://www.fsf.org/licenses/licenses.html, or obtain one by writing to the  *
*  Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA     *
*  02111-1307, USA.                                                            *
*                                                                              *
*******************************************************************************/

/****************************************************************************
 * We now include this header file if it was not included before.
 ****************************************************************************/
#ifndef radix1024_avx_negadwt_consts_included
#define radix1024_avx_negadwt_consts_included

	#include "types.h"

	const uint64 radix1024_avx_negadwt_consts[1024] = {	// 8 entries per line ==> RADIX/8 lines:
		0x3FF0000000000000ull,0x3FEFFFFD88586EE6ull,0x3FEFFFF621621D02ull,0x3FEFFFE9CB1E2E8Dull,0x3FEFFFD8858E8A92ull,0x3FEFFFC250B5DAEFull,0x3FEFFFA72C978C4Full,0x3FEFFF871937CE2Full,
		0x3FEFFF62169B92DBull,0x3FEFFF3824C88F6Full,0x3FEFFF0943C53BD1ull,0x3FEFFED57398D2B7ull,0x3FEFFE9CB44B51A1ull,0x3FEFFE5F05E578DBull,0x3FEFFE1C6870CB77ull,0x3FEFFDD4DBF78F52ull,
		0x3FEFFD886084CD0Dull,0x3FEFFD36F624500Cull,0x3FEFFCE09CE2A679ull,0x3FEFFC8554CD213Aull,0x3FEFFC251DF1D3F8ull,0x3FEFFBBFF85F9515ull,0x3FEFFB55E425FDAEull,0x3FEFFAE6E1556998ull,
		0x3FEFFA72EFFEF75Dull,0x3FEFF9FA10348837ull,0x3FEFF97C4208C014ull,0x3FEFF8F9858F058Bull,0x3FEFF871DADB81DFull,0x3FEFF7E5420320F9ull,0x3FEFF753BB1B9164ull,0x3FEFF6BD463B444Dull,
		0x3FEFF621E3796D7Eull,0x3FEFF58192EE0358ull,0x3FEFF4DC54B1BED3ull,0x3FEFF43228DE1B77ull,0x3FEFF3830F8D575Cull,0x3FEFF2CF08DA7321ull,0x3FEFF21614E131EDull,0x3FEFF15833BE1965ull,
		0x3FEFF095658E71ADull,0x3FEFEFCDAA704562ull,0x3FEFEF0102826191ull,0x3FEFEE2F6DE455BAull,0x3FEFED58ECB673C4ull,0x3FEFEC7D7F19CFFCull,0x3FEFEB9D2530410Full,0x3FEFEAB7DF1C6005ull,
		0x3FEFE9CDAD01883Aull,0x3FEFE8DE8F03D75Cull,0x3FEFE7EA85482D60ull,0x3FEFE6F18FF42C84ull,0x3FEFE5F3AF2E3940ull,0x3FEFE4F0E31D7A4Aull,0x3FEFE3E92BE9D886ull,0x3FEFE2DC89BBFF08ull,
		0x3FEFE1CAFCBD5B09ull,0x3FEFE0B485181BE3ull,0x3FEFDF9922F73307ull,0x3FEFDE78D68653FDull,0x3FEFDD539FF1F456ull,0x3FEFDC297F674BA9ull,0x3FEFDAFA7514538Cull,0x3FEFD9C68127C78Cull,
		0x3FEFD88DA3D12526ull,0x3FEFD74FDD40ABBFull,0x3FEFD60D2DA75C9Eull,0x3FEFD4C59536FAE4ull,0x3FEFD37914220B84ull,0x3FEFD227AA9BD53Bull,0x3FEFD0D158D86087ull,0x3FEFCF761F0C77A3ull,
		0x3FEFCE15FD6DA67Bull,0x3FEFCCB0F4323AA3ull,0x3FEFCB4703914354ull,0x3FEFC9D82BC2915Eull,0x3FEFC8646CFEB721ull,0x3FEFC6EBC77F0887ull,0x3FEFC56E3B7D9AF6ull,0x3FEFC3EBC935454Cull,
		0x3FEFC26470E19FD3ull,0x3FEFC0D832BF043Aull,0x3FEFBF470F0A8D88ull,0x3FEFBDB106021816ull,0x3FEFBC1617E44186ull,0x3FEFBA7644F068B5ull,0x3FEFB8D18D66ADB7ull,0x3FEFB727F187F1C7ull,
		0x3FEFB5797195D741ull,0x3FEFB3C60DD2C199ull,0x3FEFB20DC681D54Dull,0x3FEFB0509BE6F7DBull,0x3FEFAE8E8E46CFBBull,0x3FEFACC79DE6C44Full,0x3FEFAAFBCB0CFDDCull,0x3FEFA92B1600657Cull,
		0x3FEFA7557F08A517ull,0x3FEFA57B066E2754ull,0x3FEFA39BAC7A1791ull,0x3FEFA1B7717661D5ull,0x3FEF9FCE55ADB2C8ull,0x3FEF9DE0596B77A3ull,0x3FEF9BED7CFBDE29ull,0x3FEF99F5C0ABD496ull,
		0x3FEF97F924C9099Bull,0x3FEF95F7A9A1EC47ull,0x3FEF93F14F85AC08ull,0x3FEF91E616C43891ull,0x3FEF8FD5FFAE41DBull,0x3FEF8DC10A95380Dull,0x3FEF8BA737CB4B78ull,0x3FEF898887A36C84ull,
		0x3FEF8764FA714BA9ull,0x3FEF853C9089595Eull,0x3FEF830F4A40C60Cull,0x3FEF80DD27ED8204ull,0x3FEF7EA629E63D6Eull,0x3FEF7C6A50826840ull,0x3FEF7A299C1A322Aull,0x3FEF77E40D068A90ull,
		0x3FEF7599A3A12077ull,0x3FEF734A60446279ull,0x3FEF70F6434B7EB7ull,0x3FEF6E9D4D1262CAull,0x3FEF6C3F7DF5BBB7ull,0x3FEF69DCD652F5DEull,0x3FEF677556883CEEull,0x3FEF6508FEF47BD5ull,
		0x3FEF6297CFF75CB0ull,0x3FEF6021C9F148C2ull,0x3FEF5DA6ED43685Dull,0x3FEF5B273A4FA2D9ull,0x3FEF58A2B1789E84ull,0x3FEF56195321C090ull,0x3FEF538B1FAF2D07ull,0x3FEF50F81785C6B9ull,
		0x3FEF4E603B0B2F2Dull,0x3FEF4BC38AA5C694ull,0x3FEF492206BCABB4ull,0x3FEF467BAFB7BBDFull,0x3FEF43D085FF92DDull,0x3FEF412089FD8ADCull,0x3FEF3E6BBC1BBC65ull,0x3FEF3BB21CC4FE47ull,
		0x3FEF38F3AC64E589ull,0x3FEF36306B67C556ull,0x3FEF33685A3AAEF0ull,0x3FEF309B794B719Full,0x3FEF2DC9C9089A9Dull,0x3FEF2AF349E17507ull,0x3FEF2817FC4609CEull,0x3FEF2537E0A71F9Full,
		0x3FEF2252F7763ADAull,0x3FEF1F6941259D7Aull,0x3FEF1C7ABE284708ull,0x3FEF19876EF1F486ull,0x3FEF168F53F7205Dull,0x3FEF13926DAD024Eull,0x3FEF1090BC898F5Full,0x3FEF0D8A410379C5ull,
		0x3FEF0A7EFB9230D7ull,0x3FEF076EECADE0FAull,0x3FEF045A14CF738Cull,0x3FEF014074708ED3ull,0x3FEEFE220C0B95ECull,0x3FEEFAFEDC1BA8B7ull,0x3FEEF7D6E51CA3C0ull,0x3FEEF4AA278B2032ull,
		0x3FEEF178A3E473C2ull,0x3FEEEE425AA6B09Aull,0x3FEEEB074C50A544ull,0x3FEEE7C77961DC9Eull,0x3FEEE482E25A9DBCull,0x3FEEE13987BBEBDCull,0x3FEEDDEB6A078651ull,0x3FEEDA9889BFE86Aull,
		0x3FEED740E7684963ull,0x3FEED3E483849C51ull,0x3FEED0835E999009ull,0x3FEECD1D792C8F10ull,0x3FEEC9B2D3C3BF84ull,0x3FEEC6436EE60309ull,0x3FEEC2CF4B1AF6B2ull,0x3FEEBF5668EAF2EFull,
		0x3FEEBBD8C8DF0B74ull,0x3FEEB8566B810F29ull,0x3FEEB4CF515B8811ull,0x3FEEB1437AF9BB34ull,0x3FEEADB2E8E7A88Eull,0x3FEEAA1D9BB20AF3ull,0x3FEEA68393E65800ull,0x3FEEA2E4D212C000ull,
		0x3FEE9F4156C62DDAull,0x3FEE9B99229046F8ull,0x3FEE97EC36016B30ull,0x3FEE943A91AAB4B4ull,0x3FEE9084361DF7F2ull,0x3FEE8CC923EDC388ull,0x3FEE89095BAD6025ull,0x3FEE8544DDF0D075ull,
		0x3FEE817BAB4CD10Dull,0x3FEE7DADC456D850ull,0x3FEE79DB29A5165Aull,0x3FEE7603DBCE74E9ull,0x3FEE7227DB6A9744ull,0x3FEE6E472911DA27ull,0x3FEE6A61C55D53A7ull,0x3FEE6677B0E6D31Eull,
		0x3FEE6288EC48E112ull,0x3FEE5E95781EBF1Cull,0x3FEE5A9D550467D3ull,0x3FEE56A083968EB1ull,0x3FEE529F04729FFCull,0x3FEE4E98D836C0AFull,0x3FEE4A8DFF81CE5Eull,0x3FEE467E7AF35F23ull,
		0x3FEE426A4B2BC17Eull,0x3FEE3E5170CBFC46ull,0x3FEE3A33EC75CE85ull,0x3FEE3611BECBAF69ull,0x3FEE31EAE870CE25ull,0x3FEE2DBF6A0911D9ull,0x3FEE298F4439197Aull,0x3FEE255A77A63BB8ull,
		0x3FEE212104F686E5ull,0x3FEE1CE2ECD0C0D8ull,0x3FEE18A02FDC66D9ull,0x3FEE1458CEC1AD83ull,0x3FEE100CCA2980ACull,0x3FEE0BBC22BD8348ull,0x3FEE0766D9280F54ull,0x3FEE030CEE1435B8ull,
		0x3FEDFEAE622DBE2Bull,0x3FEDFA4B3621271Dull,0x3FEDF5E36A9BA59Cull,0x3FEDF177004B2534ull,0x3FEDED05F7DE47DAull,0x3FEDE890520465CEull,0x3FEDE4160F6D8D81ull,0x3FEDDF9730CA837Bull,
		0x3FEDDB13B6CCC23Cull,0x3FEDD68BA2267A25ull,0x3FEDD1FEF38A915Aull,0x3FEDCD6DABACA3A5ull,0x3FEDC8D7CB410260ull,0x3FEDC43D52FCB453ull,0x3FEDBF9E4395759Aull,0x3FEDBAFA9DC1B78Cull,
		0x3FEDB6526238A09Bull,0x3FEDB1A591B20C38ull,0x3FEDACF42CE68AB9ull,0x3FEDA83E348F613Bull,0x3FEDA383A9668988ull,0x3FED9EC48C26B1F3ull,0x3FED9A00DD8B3D46ull,0x3FED95389E50429Bull,
		0x3FED906BCF328D46ull,0x3FED8B9A70EF9CB4ull,0x3FED86C48445A44Full,0x3FED81EA09F38B62ull,0x3FED7D0B02B8ECF9ull,0x3FED78276F5617C5ull,0x3FED733F508C0DFFull,0x3FED6E52A71C8547ull,
		0x3FED696173C9E68Bull,0x3FED646BB7574DE5ull,0x3FED5F7172888A7Full,0x3FED5A72A6221E73ull,0x3FED556F52E93EB1ull,0x3FED506779A3D2D9ull,0x3FED4B5B1B187524ull,0x3FED464A380E7242ull,
		0x3FED4134D14DC93Aull,0x3FED3C1AE79F2B4Eull,0x3FED36FC7BCBFBDCull,0x3FED31D98E9E503Aull,0x3FED2CB220E0EF9Full,0x3FED2786335F52FCull,0x3FED2255C6E5A4E1ull,0x3FED1D20DC40C15Cull,
		0x3FED17E7743E35DCull,0x3FED12A98FAC410Cull,0x3FED0D672F59D2B9ull,0x3FED082054168BACull,0x3FED02D4FEB2BD92ull,0x3FECFD852FFF6AD4ull,0x3FECF830E8CE467Bull,0x3FECF2D829F1B40Eull,
		0x3FECED7AF43CC773ull,0x3FECE819488344CEull,0x3FECE2B32799A060ull,0x3FECDD489254FE65ull,0x3FECD7D9898B32F6ull,0x3FECD2660E12C1E5ull,0x3FECCCEE20C2DEA0ull,0x3FECC771C2736C09ull,
		0x3FECC1F0F3FCFC5Cull,0x3FECBC6BB638D10Bull,0x3FECB6E20A00DA99ull,0x3FECB153F02FB87Dull,0x3FECABC169A0B900ull,0x3FECA62A772FD918ull,0x3FECA08F19B9C449ull,0x3FEC9AEF521BD480ull,
		0x3FEC954B213411F5ull,0x3FEC8FA287E13305ull,0x3FEC89F587029C13ull,0x3FEC84441F785F61ull,0x3FEC7E8E52233CF3ull,0x3FEC78D41FE4A267ull,0x3FEC7315899EAAD7ull,0x3FEC6D5290341EB2ull,
		0x3FEC678B3488739Bull,0x3FEC61BF777FCC48ull,0x3FEC5BEF59FEF85Aull,0x3FEC561ADCEB743Eull,0x3FEC5042012B6907ull,0x3FEC4A64C7A5AC4Cull,0x3FEC44833141C004ull,0x3FEC3E9D3EE7D262ull,
		0x3FEC38B2F180BDB1ull,0x3FEC32C449F60830ull,0x3FEC2CD14931E3F1ull,0x3FEC26D9F01F2EAFull,0x3FEC20DE3FA971B0ull,0x3FEC1ADE38BCE19Aull,0x3FEC14D9DC465E57ull,0x3FEC0ED12B3372E9ull,
		0x3FEC08C426725549ull,0x3FEC02B2CEF1E641ull,0x3FEBFC9D25A1B147ull,0x3FEBF6832B71EC5Bull,0x3FEBF064E15377DDull,0x3FEBEA424837DE6Dull,0x3FEBE41B611154C1ull,0x3FEBDDF02CD2B982ull,
		0x3FEBD7C0AC6F952Aull,0x3FEBD18CE0DC19D5ull,0x3FEBCB54CB0D2327ull,0x3FEBC5186BF8361Cull,0x3FEBBED7C49380EAull,0x3FEBB892D5D5DAD5ull,0x3FEBB249A0B6C40Dull,0x3FEBABFC262E6586ull,
		0x3FEBA5AA673590D2ull,0x3FEB9F5464C5BFFCull,0x3FEB98FA1FD9155Eull,0x3FEB929B996A5B7Full,0x3FEB8C38D27504E9ull,0x3FEB85D1CBF52C02ull,0x3FEB7F6686E792E9ull,0x3FEB78F70449A34Bull,
		0x3FEB728345196E3Eull,0x3FEB6C0B4A55AC17ull,0x3FEB658F14FDBC47ull,0x3FEB5F0EA611A532ull,0x3FEB5889FE921405ull,0x3FEB52011F805C92ull,0x3FEB4B7409DE7925ull,0x3FEB44E2BEAF0A61ull,
		0x3FEB3E4D3EF55712ull,0x3FEB37B38BB54C09ull,0x3FEB3115A5F37BF3ull,0x3FEB2A738EB51F33ull,0x3FEB23CD470013B4ull,0x3FEB1D22CFDADCC7ull,0x3FEB16742A4CA2F5ull,0x3FEB0FC1575D33DBull,
		0x3FEB090A58150200ull,0x3FEB024F2D7D24A9ull,0x3FEAFB8FD89F57B6ull,0x3FEAF4CC5A85FB73ull,0x3FEAEE04B43C1474ull,0x3FEAE738E6CD4B67ull,0x3FEAE068F345ECEFull,0x3FEAD994DAB2E979ull,
		0x3FEAD2BC9E21D511ull,0x3FEACBE03EA0E73Bull,0x3FEAC4FFBD3EFAC8ull,0x3FEABE1B1B0B8DACull,0x3FEAB7325916C0D4ull,0x3FEAB045787157FFull,0x3FEAA9547A2CB98Eull,0x3FEAA25F5F5AEE60ull,
		0x3FEA9B66290EA1A3ull,0x3FEA9468D85B20AEull,0x3FEA8D676E545AD2ull,0x3FEA8661EC0EE133ull,0x3FEA7F58529FE69Dull,0x3FEA784AA31D3F55ull,0x3FEA7138DE9D60F5ull,0x3FEA6A230637623Bull,
		0x3FEA63091B02FAE2ull,0x3FEA5BEB1E188375ull,0x3FEA54C91090F523ull,0x3FEA4DA2F385E997ull,0x3FEA4678C8119AC8ull,0x3FEA3F4A8F4EE2D2ull,0x3FEA38184A593BC6ull,0x3FEA30E1FA4CBF81ull,
		0x3FEA29A7A0462782ull,0x3FEA22693D62CCB9ull,0x3FEA1B26D2C0A75Eull,0x3FEA13E0617E4EC7ull,0x3FEA0C95EABAF937ull,0x3FEA05476F967BB4ull,0x3FE9FDF4F13149DEull,0x3FE9F69E70AC75BCull,
		0x3FE9EF43EF29AF94ull,0x3FE9E7E56DCB45BDull,0x3FE9E082EDB42472ull,0x3FE9D91C7007D5A6ull,0x3FE9D1B1F5EA80D5ull,0x3FE9CA438080EADBull,0x3FE9C2D110F075C2ull,0x3FE9BB5AA85F2098ull,
		0x3FE9B3E047F38741ull,0x3FE9AC61F0D4E247ull,0x3FE9A4DFA42B06B2ull,0x3FE99D59631E65D5ull,0x3FE995CF2ED80D22ull,0x3FE98E410881A5FFull,0x3FE986AEF1457594ull,0x3FE97F18EA4E5C9Dull,
		0x3FE9777EF4C7D742ull,0x3FE96FE111DDFCE0ull,0x3FE9683F42BD7FE1ull,0x3FE960998893AD8Cull,0x3FE958EFE48E6DD7ull,0x3FE9514257DC4335ull,0x3FE94990E3AC4A6Cull,0x3FE941DB892E3A65ull,
		0x3FE93A22499263FBull,0x3FE932652609B1CFull,0x3FE92AA41FC5A815ull,0x3FE922DF37F8646Aull,0x3FE91B166FD49DA2ull,0x3FE91349C88DA397ull,0x3FE90B7943575EFEull,0x3FE903A4E1665133ull,
		0x3FE8FBCCA3EF940Dull,0x3FE8F3F08C28D9ABull,0x3FE8EC109B486C49ull,0x3FE8E42CD2852E09ull,0x3FE8DC45331698CCull,0x3FE8D459BE34BDF9ull,0x3FE8CC6A75184655ull,0x3FE8C47758FA71CAull,
		0x3FE8BC806B151741ull,0x3FE8B485ACA2A468ull,0x3FE8AC871EDE1D88ull,0x3FE8A484C3031D51ull,0x3FE89C7E9A4DD4AAull,0x3FE89474A5FB0A84ull,0x3FE88C66E7481BA1ull,0x3FE884555F72FA6Bull,
		0x3FE87C400FBA2EBFull,0x3FE87426F95CD5BCull,0x3FE86C0A1D9AA195ull,0x3FE863E97DB3D95Aull,0x3FE85BC51AE958CCull,0x3FE8539CF67C9029ull,0x3FE84B7111AF83FAull,0x3FE843416DC4CCE2ull,
		0x3FE83B0E0BFF976Eull,0x3FE832D6EDA3A3E0ull,0x3FE82A9C13F545FFull,0x3FE8225D803964E5ull,0x3FE81A1B33B57ACCull,0x3FE811D52FAF94DCull,0x3FE8098B756E52FAull,0x3FE8013E0638E795ull,
		0x3FE7F8ECE3571771ull,0x3FE7F0980E113978ull,0x3FE7E83F87B03686ull,0x3FE7DFE3517D8937ull,0x3FE7D7836CC33DB2ull,0x3FE7CF1FDACBF179ull,0x3FE7C6B89CE2D333ull,0x3FE7BE4DB453A27Cull,
		0x3FE7B5DF226AAFAFull,0x3FE7AD6CE874DBB6ull,0x3FE7A4F707BF97D2ull,0x3FE79C7D8198E56Eull,0x3FE79400574F55E5ull,0x3FE78B7F8A320A51ull,0x3FE782FB1B90B35Bull,0x3FE77A730CBB90FFull,
		0x3FE771E75F037261ull,0x3FE7695813B9B593ull,0x3FE760C52C304764ull,0x3FE7582EA9B9A329ull,0x3FE74F948DA8D28Dull,0x3FE746F6D9516D59ull,0x3FE73E558E079942ull,0x3FE735B0AD2009B2ull,
		0x3FE72D0837EFFF96ull,0x3FE7245C2FCD492Aull,0x3FE71BAC960E41BFull,0x3FE712F96C09D18Dull,0x3FE70A42B3176D7Aull,0x3FE701886C8F16E6ull,0x3FE6F8CA99C95B75ull,0x3FE6F0093C1F54DEull,
		0x3FE6E74454EAA8AFull,0x3FE6DE7BE585881Dull,0x3FE6D5AFEF4AAFCDull,0x3FE6CCE07395679Eull,0x3FE6C40D73C18275ull,0x3FE6BB36F12B5E05ull,0x3FE6B25CED2FE29Cull,0x3FE6A97F692C82E9ull,
		0x3FE6A09E667F3BCDull,0x3FE697B9E686941Cull,0x3FE68ED1EAA19C71ull,0x3FE685E6742FEEEFull,0x3FE67CF78491AF10ull,0x3FE674051D27896Cull,0x3FE66B0F3F52B386ull,0x3FE66215EC74EB91ull,
		0x3FE6591925F0783Dull,0x3FE65018ED28287Full,0x3FE64715437F535Bull,0x3FE63E0E2A59D7AAull,0x3FE63503A31C1BE9ull,0x3FE62BF5AF2B0DFDull,0x3FE622E44FEC22FFull,0x3FE619CF86C55702ull,
		0x3FE610B7551D2CDFull,0x3FE6079BBC5AADFAull,0x3FE5FE7CBDE56A10ull,0x3FE5F55A5B2576F8ull,0x3FE5EC3495837074ull,0x3FE5E30B6E6877F3ull,0x3FE5D9DEE73E345Cull,0x3FE5D0AF016ED1D5ull,
		0x3FE5C77BBE65018Cull,0x3FE5BE451F8BF981ull,0x3FE5B50B264F7448ull,0x3FE5ABCDD41BB0D9ull,0x3FE5A28D2A5D7250ull,0x3FE599492A81FFBCull,0x3FE59001D5F723DFull,0x3FE586B72E2B2CFEull,
		0x3FE57D69348CECA0ull,0x3FE57417EA8BB75Cull,0x3FE56AC35197649Full,0x3FE5616B6B204E6Full,0x3FE5581038975137ull,0x3FE54EB1BB6DCB8Full,0x3FE5454FF5159DFCull,0x3FE53BEAE7012ABEull,
		0x3FE5328292A35596ull,0x3FE52916F96F8388ull,0x3FE51FA81CD99AA6ull,0x3FE51635FE5601D7ull,0x3FE50CC09F59A09Bull,0x3FE503480159DED3ull,0x3FE4F9CC25CCA486ull,0x3FE4F04D0E2859ABull,
		0x3FE4E6CABBE3E5E9ull,0x3FE4DD453076B064ull,0x3FE4D3BC6D589F7Full,0x3FE4CA30740218A3ull,0x3FE4C0A145EC0004ull,0x3FE4B70EE48FB869ull,0x3FE4AD79516722F1ull,0x3FE4A3E08DEC9ED6ull,
		0x3FE49A449B9B0939ull,0x3FE490A57BEDBCDFull,0x3FE48703306091FFull,0x3FE47D5DBA6FDE01ull,0x3FE473B51B987347ull,0x3FE46A095557A0F1ull,0x3FE4605A692B32A2ull,0x3FE456A858917046ull,
		0x3FE44CF325091DD6ull,0x3FE4433AD0117B1Eull,0x3FE4397F5B2A4380ull,0x3FE42FC0C7D3ADBCull,0x3FE425FF178E6BB1ull,0x3FE41C3A4BDBAA27ull,0x3FE41272663D108Cull,0x3FE408A76834C0C0ull,
		0x3FE3FED9534556D4ull,0x3FE3F50828F1E8D2ull,0x3FE3EB33EABE0680ull,0x3FE3E15C9A2DB923ull,0x3FE3D78238C58344ull,0x3FE3CDA4C80A6076ull,0x3FE3C3C44981C518ull,0x3FE3B9E0BEB19E18ull,
		0x3FE3AFFA292050B9ull,0x3FE3A6108A54BA57ull,0x3FE39C23E3D63029ull,0x3FE39234372C7F04ull,0x3FE3884185DFEB22ull,0x3FE37E4BD1792FE2ull,0x3FE374531B817F8Dull,0x3FE36A576582831Bull,
		0x3FE36058B10659F3ull,0x3FE35656FF9799AFull,0x3FE34C5252C14DE1ull,0x3FE3424AAC0EF7D6ull,0x3FE338400D0C8E57ull,0x3FE32E3277467D6Bull,0x3FE32421EC49A61Full,0x3FE31A0E6DA35E45ull,
		0x3FE30FF7FCE17035ull,0x3FE305DE9B921A94ull,0x3FE2FBC24B441015ull,0x3FE2F1A30D86773Aull,0x3FE2E780E3E8EA17ull,0x3FE2DD5BCFFB7616ull,0x3FE2D333D34E9BB8ull,0x3FE2C908EF734E57ull,
		0x3FE2BEDB25FAF3EAull,0x3FE2B4AA787764C4ull,0x3FE2AA76E87AEB58ull,0x3FE2A040779843FCull,0x3FE2960727629CA8ull,0x3FE28BCAF96D94BBull,0x3FE2818BEF4D3CBAull,0x3FE2774A0A961613ull,
		0x3FE26D054CDD12DFull,0x3FE262BDB7B795A2ull,0x3FE258734CBB7110ull,0x3FE24E260D7EE7C9ull,0x3FE243D5FB98AC1Full,0x3FE23983189FDFD5ull,0x3FE22F2D662C13E2ull,0x3FE224D4E5D5482Eull,
		0x3FE21A799933EB59ull,0x3FE2101B81E0DA78ull,0x3FE205BAA17560D6ull,0x3FE1FB56F98B37B9ull,0x3FE1F0F08BBC861Bull,0x3FE1E68759A3E073ull,0x3FE1DC1B64DC4872ull,0x3FE1D1ACAF012CC2ull,
		0x3FE1C73B39AE68C8ull,0x3FE1BCC706804468ull,0x3FE1B250171373BFull,0x3FE1A7D66D0516E7ull,0x3FE19D5A09F2B9B8ull,0x3FE192DAEF7A5387ull,0x3FE188591F3A46E5ull,0x3FE17DD49AD16161ull,
		0x3FE1734D63DEDB49ull,0x3FE168C37C025765ull,0x3FE15E36E4DBE2BCull,0x3FE153A7A00BF453ull,0x3FE14915AF336CEBull,0x3FE13E8113F396C1ull,0x3FE133E9CFEE254Full,0x3FE1294FE4C5350Aull,
		0x3FE11EB3541B4B23ull,0x3FE114141F935545ull,0x3FE1097248D0A957ull,0x3FE0FECDD1770537ull,0x3FE0F426BB2A8E7Eull,0x3FE0E97D078FD23Bull,0x3FE0DED0B84BC4B6ull,0x3FE0D421CF03C12Bull,
		0x3FE0C9704D5D898Full,0x3FE0BEBC34FF4646ull,0x3FE0B405878F85ECull,0x3FE0A94C46B53D0Bull,0x3FE09E907417C5E1ull,0x3FE093D2115EE018ull,0x3FE089112032B08Cull,0x3FE07E4DA23BC103ull,
		0x3FE073879922FFEEull,0x3FE068BF0691C029ull,0x3FE05DF3EC31B8B7ull,0x3FE053264BAD0483ull,0x3FE0485626AE221Aull,0x3FE03D837EDFF370ull,0x3FE032AE55EDBD96ull,0x3FE027D6AD83287Eull,
		0x3FE01CFC874C3EB7ull,0x3FE0121FE4F56D2Cull,0x3FE00740C82B82E1ull,0x3FDFF8BE6537615Full,0x3FDFE2F64BE71210ull,0x3FDFCD2947C1FF58ull,0x3FDFB7575C24D2DEull,0x3FDFA1808C6CF7E1ull,
		0x3FDF8BA4DBF89ABAull,0x3FDF75C44E26A853ull,0x3FDF5FDEE656CDA3ull,0x3FDF49F4A7E97729ull,0x3FDF3405963FD067ull,0x3FDF1E11B4BBC35Cull,0x3FDF081906BFF7FEull,0x3FDEF21B8FAFD3B5ull,
		0x3FDEDC1952EF78D6ull,0x3FDEC61253E3C61Bull,0x3FDEB00695F25620ull,0x3FDE99F61C817EDBull,0x3FDE83E0EAF85114ull,0x3FDE6DC704BE97E2ull,0x3FDE57A86D3CD825ull,0x3FDE418527DC4FFAull,
		0x3FDE2B5D3806F63Bull,0x3FDE1530A12779F4ull,0x3FDDFEFF66A941DEull,0x3FDDE8C98BF86BD5ull,0x3FDDD28F1481CC58ull,0x3FDDBC5003B2EDF8ull,0x3FDDA60C5CFA10D9ull,0x3FDD8FC423C62A25ull,
		0x3FDD79775B86E389ull,0x3FDD632607AC9AAAull,0x3FDD4CD02BA8609Dull,0x3FDD3675CAEBF962ull,0x3FDD2016E8E9DB5Bull,0x3FDD09B389152EC1ull,0x3FDCF34BAEE1CD21ull,0x3FDCDCDF5DC440CEull,
		0x3FDCC66E9931C45Eull,0x3FDCAFF964A0421Eull,0x3FDC997FC3865389ull,0x3FDC8301B95B40C2ull,0x3FDC6C7F4997000Bull,0x3FDC55F877B23537ull,0x3FDC3F6D47263129ull,0x3FDC28DDBB6CF145ull,
		0x3FDC1249D8011EE7ull,0x3FDBFBB1A05E0EDCull,0x3FDBE51517FFC0D9ull,0x3FDBCE744262DEEFull,0x3FDBB7CF2304BD01ull,0x3FDBA125BD63583Eull,0x3FDB8A7814FD5693ull,0x3FDB73C62D520624ull,
		0x3FDB5D1009E15CC0ull,0x3FDB4655AE2BF758ull,0x3FDB2F971DB31972ull,0x3FDB18D45BF8ACA6ull,0x3FDB020D6C7F4009ull,0x3FDAEB4252CA07ABull,0x3FDAD473125CDC09ull,0x3FDABD9FAEBC3981ull,
		0x3FDAA6C82B6D3FCAull,0x3FDA8FEC8BF5B166ull,0x3FDA790CD3DBF31Bull,0x3FDA622906A70B63ull,0x3FDA4B4127DEA1E5ull,0x3FDA34553B0AFEE5ull,0x3FDA1D6543B50AC0ull,0x3FDA067145664D57ull,
		0x3FD9EF7943A8ED8Aull,0x3FD9D87D4207B0ACull,0x3FD9C17D440DF9F2ull,0x3FD9AA794D47C9EEull,0x3FD993716141BDFFull,0x3FD97C6583890FC3ull,0x3FD96555B7AB948Full,0x3FD94E420137BCE3ull,
		0x3FD9372A63BC93D7ull,0x3FD9200EE2C9BE97ull,0x3FD908EF81EF7BD1ull,0x3FD8F1CC44BEA32Aull,0x3FD8DAA52EC8A4B0ull,0x3FD8C37A439F884Full,0x3FD8AC4B86D5ED44ull,0x3FD89518FBFF098Eull,
		0x3FD87DE2A6AEA963ull,0x3FD866A88A792EA0ull,0x3FD84F6AAAF3903Full,0x3FD838290BB359C8ull,0x3FD820E3B04EAAC4ull,0x3FD8099A9C5C362Dull,0x3FD7F24DD37341E4ull,0x3FD7DAFD592BA622ull,
		0x3FD7C3A9311DCCE7ull,0x3FD7AC515EE2B172ull,0x3FD794F5E613DFAEull,0x3FD77D96CA4B73A6ull,0x3FD766340F2418F6ull,0x3FD74ECDB8390A3Eull,0x3FD73763C9261092ull,0x3FD71FF6458782ECull,
		0x3FD7088530FA459Full,0x3FD6F1108F1BC9C5ull,0x3FD6D998638A0CB6ull,0x3FD6C21CB1E39772ull,0x3FD6AA9D7DC77E17ull,0x3FD6931ACAD55F51ull,0x3FD67B949CAD63CBull,0x3FD6640AF6F03D9Eull,
		0x3FD64C7DDD3F27C6ull,0x3FD634ED533BE58Eull,0x3FD61D595C88C202ull,0x3FD605C1FCC88F64ull,0x3FD5EE27379EA693ull,0x3FD5D68910AEE687ull,0x3FD5BEE78B9DB3B6ull,0x3FD5A742AC0FF78Eull,
		0x3FD58F9A75AB1FDDull,0x3FD577EEEC151E48ull,0x3FD5604012F467B4ull,0x3FD5488DEDEFF3BEull,0x3FD530D880AF3C24ull,0x3FD5191FCEDA3C35ull,0x3FD50163DC197048ull,0x3FD4E9A4AC15D521ull,
		0x3FD4D1E24278E76Aull,0x3FD4BA1CA2ECA31Dull,0x3FD4A253D11B82F3ull,0x3FD48A87D0B07FD7ull,0x3FD472B8A5571054ull,0x3FD45AE652BB2800ull,0x3FD44310DC8936F0ull,0x3FD42B38466E2927ull,
		0x3FD4135C94176601ull,0x3FD3FB7DC932CFA5ull,0x3FD3E39BE96EC271ull,0x3FD3CBB6F87A146Eull,0x3FD3B3CEFA0414B7ull,0x3FD39BE3F1BC8AF0ull,0x3FD383F5E353B6ABull,0x3FD36C04D27A4EDFull,
		0x3FD35410C2E18152ull,0x3FD33C19B83AF207ull,0x3FD3241FB638BAAFull,0x3FD30C22C08D6A13ull,0x3FD2F422DAEC0387ull,0x3FD2DC200907FE51ull,0x3FD2C41A4E954520ull,0x3FD2AC11AF483572ull,
		0x3FD294062ED59F06ull,0x3FD27BF7D0F2C346ull,0x3FD263E6995554BAull,0x3FD24BD28BB37672ull,0x3FD233BBABC3BB71ull,0x3FD21BA1FD3D2622ull,0x3FD2038583D727BEull,0x3FD1EB6643499FBBull,
		0x3FD1D3443F4CDB3Eull,0x3FD1BB1F7B999480ull,0x3FD1A2F7FBE8F243ull,0x3FD18ACDC3F4873Aull,0x3FD172A0D7765177ull,0x3FD15A713A28B9D9ull,0x3FD1423EEFC69378ull,0x3FD12A09FC0B1B12ull,
		0x3FD111D262B1F677ull,0x3FD0F998277733F7ull,0x3FD0E15B4E1749CEull,0x3FD0C91BDA4F158Eull,0x3FD0B0D9CFDBDB90ull,0x3FD09895327B465Eull,0x3FD0804E05EB661Eull,0x3FD068044DEAB002ull,
		0x3FD04FB80E37FDAEull,0x3FD037694A928CACull,0x3FD01F1806B9FDD2ull,0x3FD006C4466E54B0ull,0x3FCFDCDC1ADFEDF9ull,0x3FCFAC2ABEFF5800ull,0x3FCF7B7480BD3802ull,0x3FCF4AB9679C9F5Dull,
		0x3FCF19F97B215F1Bull,0x3FCEE934C2D006C7ull,0x3FCEB86B462DE348ull,0x3FCE879D0CC0FDB0ull,0x3FCE56CA1E101A1Bull,0x3FCE25F281A2B685ull,0x3FCDF5163F01099Aull,0x3FCDC4355DB40195ull,
		0x3FCD934FE5454311ull,0x3FCD6265DD3F27E4ull,0x3FCD31774D2CBDEEull,0x3FCD00843C99C5F9ull,0x3FCCCF8CB312B286ull,0x3FCC9E90B824A6A9ull,0x3FCC6D90535D74DDull,0x3FCC3C8B8C4B9DD8ull,
		0x3FCC0B826A7E4F63ull,0x3FCBDA74F5856330ull,0x3FCBA96334F15DADull,0x3FCB784D30536CDAull,0x3FCB4732EF3D6722ull,0x3FCB16147941CA2Bull,0x3FCAE4F1D5F3B9ABull,0x3FCAB3CB0CE6FE44ull,
		0x3FCA82A025B00451ull,0x3FCA517127E3DABDull,0x3FCA203E1B1831DAull,0x3FC9EF0706E35A35ull,0x3FC9BDCBF2DC4366ull,0x3FC98C8CE69A7AECull,0x3FC95B49E9B62AFAull,0x3FC92A0303C8194Full,
		0x3FC8F8B83C69A60Bull,0x3FC8C7699B34CA7Full,0x3FC8961727C41804ull,0x3FC864C0E9B2B6D0ull,0x3FC83366E89C64C6ull,0x3FC802092C1D744Bull,0x3FC7D0A7BBD2CB1Cull,0x3FC79F429F59E11Dull,
		0x3FC76DD9DE50BF31ull,0x3FC73C6D8055FE0Bull,0x3FC70AFD8D08C4FFull,0x3FC6D98A0C08C8DBull,0x3FC6A81304F64AB2ull,0x3FC676987F7216B8ull,0x3FC6451A831D830Dull,0x3FC61399179A6E95ull,
		0x3FC5E214448B3FC6ull,0x3FC5B08C1192E381ull,0x3FC57F008654CBDEull,0x3FC54D71AA74EF03ull,0x3FC51BDF8597C5F2ull,0x3FC4EA4A1F624B61ull,0x3FC4B8B17F79FA88ull,0x3FC48715AD84CDF4ull,
		0x3FC45576B1293E5Aull,0x3FC423D4920E4166ull,0x3FC3F22F57DB4893ull,0x3FC3C0870A383FF6ull,0x3FC38EDBB0CD8D14ull,0x3FC35D2D53440DB2ull,0x3FC32B7BF94516A7ull,0x3FC2F9C7AA7A72AFull,
		0x3FC2C8106E8E613Aull,0x3FC296564D2B953Eull,0x3FC264994DFD3409ull,0x3FC232D978AED414ull,0x3FC20116D4EC7BCFull,0x3FC1CF516A62A077ull,0x3FC19D8940BE24E7ull,0x3FC16BBE5FAC5865ull,
		0x3FC139F0CEDAF577ull,0x3FC1082095F820B0ull,0x3FC0D64DBCB26786ull,0x3FC0A4784AB8BF1Dull,0x3FC072A047BA831Dull,0x3FC040C5BB67747Eull,0x3FC00EE8AD6FB85Bull,0x3FBFBA124B07AD86ull,
		0x3FBF564E56A9730Eull,0x3FBEF2858D27561Bull,0x3FBE8EB7FDE4AA3Full,0x3FBE2AE5B8457F77ull,0x3FBDC70ECBAE9FC9ull,0x3FBD633347858CE4ull,0x3FBCFF533B307DC1ull,0x3FBC9B6EB6165C43ull,
		0x3FBC3785C79EC2D5ull,0x3FBBD3987F31FA0Eull,0x3FBB6FA6EC38F64Cull,0x3FBB0BB11E1D5559ull,0x3FBAA7B724495C03ull,0x3FBA43B90E27F3C5ull,0x3FB9DFB6EB24A85Cull,0x3FB97BB0CAABA570ull,
		0x3FB917A6BC29B42Cull,0x3FB8B398CF0C38E0ull,0x3FB84F8712C130A1ull,0x3FB7EB7196B72EE4ull,0x3FB787586A5D5B21ull,0x3FB7233B9D236E71ull,0x3FB6BF1B3E79B129ull,0x3FB65AF75DD0F87Cull,
		0x3FB5F6D00A9AA419ull,0x3FB592A554489BC8ull,0x3FB52E774A4D4D0Aull,0x3FB4CA45FC1BA8B6ull,0x3FB4661179272096ull,0x3FB401D9D0E3A508ull,0x3FB39D9F12C5A299ull,0x3FB339614E41FFA6ull,
		0x3FB2D52092CE19F6ull,0x3FB270DCEFDFC45Aull,0x3FB20C9674ED444Dull,0x3FB1A84D316D4F8Aull,0x3FB1440134D709B3ull,0x3FB0DFB28EA201E7ull,0x3FB07B614E463064ull,0x3FB0170D833BF422ull,
		0x3FAF656E79F820E0ull,0x3FAE9CBD15FF5528ull,0x3FADD406F9808EC9ull,0x3FAD0B4C436F91D0ull,0x3FAC428D12C0D7E3ull,0x3FAB79C986698B79ull,0x3FAAB101BD5F8317ull,0x3FA9E835D6993C87ull,
		0x3FA91F65F10DD814ull,0x3FA856922BB513C1ull,0x3FA78DBAA5874686ull,0x3FA6C4DF7D7D5B84ull,0x3FA5FC00D290CD43ull,0x3FA5331EC3BBA0EBull,0x3FA46A396FF86179ull,0x3FA3A150F6421AFCull,
		0x3FA2D865759455CDull,0x3FA20F770CEB11C7ull,0x3FA14685DB42C17Full,0x3FA07D91FF984580ull,0x3F9F693731D1CF01ull,0x3F9DD7458C64AB3Aull,0x3F9C454F4CE53B1Dull,0x3F9AB354B1504FCAull,
		0x3F992155F7A3667Eull,0x3F978F535DDC9F04ull,0x3F95FD4D21FAB226ull,0x3F946B4381FCE81Bull,0x3F92D936BBE30EFDull,0x3F9147270DAD7133ull,0x3F8F6A296AB997CBull,0x3F8C45FFE1E48AD9ull,
		0x3F8921D1FCDEC784ull,0x3F85FDA037AC05E1ull,0x3F82D96B0E509703ull,0x3F7F6A65F9A2A3C6ull,0x3F7921F0FE670071ull,0x3F72D97822F996BCull,0x3F6921F8BECCA4BAull,0x3F5921FAAEE6472Eull
	};

#endif	/* #ifndef radix1024_avx_negadwt_consts_included */
