# Contributing to Font Awesome

Looking to contribute something to Font Awesome? **Here's how you can help.**

## Quick start

We only accept issues that are icon requests, bug reports, or feature requests.
Bugs must be isolated and reproducible problems that we can fix within the Font
Awesome core.

* [Request a new icon](https://github.com/FortAwesome/Font-Awesome/issues/new?assignees=&labels=new+icon&projects=&template=000_icon_request.yml&title=Icon+request%3A+)
* [Request a new brand icon](https://github.com/FortAwesome/Font-Awesome/issues/new?assignees=&labels=brand+icon&projects=&template=001_brand_request.yml&title=Brand+request%3A+)
* [Submit a bug report for Web (Kit, CSS, JS)](https://github.com/FortAwesome/Font-Awesome/issues/new?assignees=&labels=bug%2Cneeds-triage&projects=&template=100_web_bug_report.yml&title=Bug%3A+)
* [Submit a bug report for Desktop, Native, and other use cases](https://github.com/FortAwesome/Font-Awesome/issues/new?assignees=&labels=bug%2Cneeds-triage&projects=&template=101_other_bug_report.yml&title=Bug%3A+)
* [Request a new feature](https://github.com/FortAwesome/Font-Awesome/issues/new?assignees=&labels=feature&projects=&template=200_feature_request.yml&title=Feature+request%3A+)

## Pull requests

- **At the moment we are not accepting pull requests containing icons**
- Pull requests that do not solve an existing issue are essentially un-prioritized–don't expect these to be addressed quickly
- Most of the files in this repository are generated by a build system, so we may not be able to merge PRs directly
- Try not to pollute your pull request with unintended changes–keep them simple and small
- Try to share which browsers your code has been tested in before submitting a pull request
