<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

May 18, 2020

Host: Michael Dolan

Rotating Secretary: Michael Dolan

Attendees:
  * [ ] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [ ] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [X] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [ ] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [ ] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Joseph Goldstone - ARRI
  * [X] Troy Sobotka

Apologies:
  * Patrick Hodoul
  * Mei Chu

# **OCIO TSC Meeting Notes**

* Documentation
    - [Public working document, by Carol and Sean](https://docs.google.com/document/d/17IQR2tRYxqGXkExOLvP9S_dMkOkOID-NIIAGXGfyxNk/edit?usp=sharing)
    - Carol: Document is a first draft. Went through existing documentation 
      to outline what's there, and thoughts around it. The rest of the doc has 
      examples and info on static site generators, themes, etc. Sean added a 
      proposed plan of attack for getting the work started.
    - Doug: Good focus for the discussion. Thanks for putting it together!
    - Carol: Putting it all down is good for establishing priorities. Some 
      items can happen concurrently, but some first steps are needed.
    - Sean: First two points to decide on are the look and a static site 
      generator.
    - Carol: If there was a time to change things, it is now. We could go a 
      different direction if needed.
    - Michael: Many of us have expressed an openness to Sphinx alternatives if 
      something else makes more sense.
    - Sean: Trying to find the best solution. Three options seem to be: Write 
      everything by hand, use an auto-generation tool, or be stuck in some 
      middle ground of building your own tooling.
    - Carol: Looked at [Jekyll](https://jekyllrb.com/); has best integration 
      with GH pages, which would make it easy to use. I've never used 
      [Staticman](https://staticman.net/), but that looks like a good 
      integration which takes a static site and can add forms, tables, etc., 
      which trigger auto-rebuild or generation of issues, PRs, etc., which is 
      nice. Might be other tools, but these looked cool, to keep functionality 
      on website, but with GH handled changes.
    - Sean: My initial thinking is that most of the world knows Sphinx, so it 
      could be picked up by anyone. The more obscure you get, the harder it is 
      for others to pick it up. Could have one build for static site, and 
      another for API docs. One option is to use a 
      [VuePress](https://vuepress.vuejs.org/) website, and then RTD could use 
      the VuePress theme to house API docs.
    - Carol: I'm going to try and build some stuff locally to test.
    - Michael: We could reach out on Slack and in ocio mail lists for community 
      input.
    - Carol: I can reach out. The bulk of work will be rewriting the user guide.
    - Sean: I added points to end of doc around documentation and its 
      organization. Asked the question, "who is the end consumer?", and called 
      out 4 groups: artists, studio config maintainers, studio TDs 
      (troubleshooting OCIO integrations), and OCIO integrators. Who is the 
      target, and who do we focus docs on? Maybe all?
    - Carol: A lot of it can hopefully be to work with DCC vendors to help them 
      update their docs as well, and to understand coming changes. Then we can 
      point our docs to theirs.
    - Michael: The [Compatible Software](https://github.com/AcademySoftwareFoundation/OpenColorIO/blob/master/docs/CompatibleSoftware.rst) 
      page of the OCIO website was updated recently and contains many 
      up-to-date documentation links.
    - Doug: Also may want to add OCIO developers to the list of consumers, to 
      orient them to the code base.
    - Joseph: that would be great. Also a 6th group: people submitting 
      transforms to a config. Camera manufacturers, etc. What are procedures 
      for contribution? How to provide test cases?
    - Carol: Contributors is a block in there, and different contributor types.
    - Sean: We should also work on documentation for configs we provide. That 
      was something provided previously for the SPI configs: user case studies, 
      etc. Those docs should live in config repos, and the main docs could 
      point to the config websites.
    - Carol: Ideally they use the same process as the site
    - Doug: Config docs would be simpler, with no API generation.
    - Michael: At the next TSC meeting we can reconvene to discuss further, with 
      community input received this week.
    - Sean made #docs channel in Slack, and will add all TSC members as Slack 
      admins.
    - **TODO**: Carol will get documentation conversation started by posting 
      document in #docs channel as ocio-dev (possibly ocio-user too).

* [OpenColorIO-Config-ACES](https://github.com/AcademySoftwareFoundation/OpenColorIO-Config-ACES)
    - Michael: This repo has been created and the committer group is being 
      setup, which will include current active OCIO committers, plus Thomas 
      Mansencal and Michael Parsons. Sean, are you ok with the multiple repo 
      approach? I know you've expressed other approaches too.
    - Sean: Multiple repos are ok. The use case that convinced me was ability 
      to version up and generate artifacts independently for the configs.
    - General agreement that the ACES config is the best place to start, and 
      other configs can be explored/discussed later.
    - Michael: I added one issue to the new repo to discuss formation of a 
      config working group, which can determine next steps, and decide on a 
      chair.
    - **TODO**: Michael to make initial PR with LICENSE, etc.

* PR #1011
    - Doug: CLF-specific PR up and ready for review, with changes from the CLF 
      ACES working group. Would like to get it merged by tomorrow for the next
      working group meeting.
    - Michael: I will review today.
    - No voiced objections to merging it.

* Items for next TSC meeting agenda:
  - Next week is a holiday in US and UK. Group can still meet to discuss 
    documentation if there is interest, otherwise we can skip and keep
    the conversation going in the new #docs Slack channel.
