<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

July 20, 2020

Host: Michael Dolan

Attendees:
  * [ ] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [X] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [ ] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [ ] Carol Payne (_TSC_) - Netflix
  * [X] Mark Titchener (_TSC_) - Foundry
  * [ ] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] Troy Sobotka
  * [X] Joseph Goldstone - ARRI
  * [X] Chin-Ying Li
  * [X] Simran Brucherseifer

Apologies:
  * Mark Boorer
  * Patrick Hodoul

# **OCIO TSC Meeting Notes**

* OSD planning:
    - Wed-Thurs, August 19-20 (55 minute session).
    - Michael: We talked previously about having discussion for users and 
      integrators. Should we try to use this session for that?
    - Doug: Last year's OSD wasn't much discussion. Large room, large group. 
      Didn't feel like BoFs from previous years. Not sure the virtual format 
      will allow.
    - Michael: Good point. OSD may end up being a webinar format, where there 
      are limited speakers, but chat based Q&A throughout. If we focus more on
      a presentation format, how much overlap with DigiPro presentation?
    - Doug: Depends on whether DigiPro has a pay-wall. If it's free we can 
      encourage people to watch that presentation. The paper will be available 
      either way, but if DigiPro is not free, overlap may be needed. We can 
      prepare 55 min of material, pause for questions, and dynamically adjust 
      content based on volume of discussion.
    - **TODO**: Michael will follow up with Emily on virtual DigiPro attendance 
      policies.

* CLA (Apache, umbrella CLA):
    - Michael: There was discussion at the TAC meeting around switching to the 
      Apache CLA (from the current LF CLA) which is preferred by some 
      contributors. OpenCue already has this CLA (and OCIO used it previously),
      and if all projects agreed to switch we could potentially have an ASWF 
      umbrella CLA to allow contributions to all ASWF projects from a single 
      CLA. I expressed that now was probably not a good time for OCIO to switch 
      due to v2 "crunch time", but that we would discuss the change following 
      this push. Any objections to making this change later in the year when 
      time allows?
    - No objections raised.

* CMake PR; is it ready?
    - Michael: It's ready, but Sean has an additional Python-related fix which 
      we have been discussing the best way to merge. DCO issus created some 
      branch conflicts earlier so I resubmitted from a clean branch. Sean could 
      follow with a supplemental PR if we merge it now.
    - Sean: Patrick and I encountered issues with this change discovering 
      Python 3 on our systems (macOS and Linux respectively). The proposed fix 
      resolved these problems for both.
    - Michael: CI is passing, but that may be due to using explicit Python 
      paths in the CMake commands. Sounds like the current method os not 
      finding python-dev headers.
    - **TODO**: Merge the CMake changes as-is since CI is passing, and Sean 
      will submit fix in a followup PR since the change is small.

* Website design/logo refresh:
    - Doug: Month out from feature complete. Need the update docs before 
      inviting people in to v2. Pushing up to the wire. We need to focus on 
      docs in the coming weeks. Looking at Simran's toolchain data flow 
      diagram, this provides good overview of documentation approach. Is it 
      correct?
    - Sean: Yes, just need to add a node for generating RST from 
      pybind11 code.
    - Doug: Can we define concrete projects so contributors can work on this? 
      In the next two weeks we either need to get this working or stay with 
      existing system.
    - Sean: Docstring header PR is in. Need another PR for pybind11 docstring 
      header, and another for reorganization of doc structure. The RTD page 
      points to official OCIO repo, so we're live now, but API docs and new 
      style is missing. Any changes to master are getting pushed to RTD now. 
      Not as much holding back docs as it seems. 
    - Simran: An event hook in GH communicates to RTD when to update the site.
    - Michael: Can we open GH issues for logical chunks of work?
    - Sean: Remaining infrastructure work is to finish Python docs extraction. 
      The CMake workflow needs work, which uses another pybind11 component 
      that doesn't install with pybind11 by default, so will be need to be 
      pulled at runtime.
    - **TODO**: Sean will create PR with his current Python extraction work. 
      Chin-Ying Li willing to assist with this work to help finish doc 
      infrastructure.
    - Doug: There are two parts of docs: infrastructure and writing content. 
      Separate tasks. Infrastructure should be in place to see what final 
      product is going to look like. For content objective, Carol has been 
      writing table of contents/outline. Lots of discussion on that. AD team 
      can help write docs.
    - Sean: Would be good to get GH issues and volunteers for writing certain 
      sections of docs.
    - **TODO**: Break remaining work into GH issues to help with contribution.
    - **TODO**: Michael will reach out to LF creative services about help with 
      frontend work. Can collaborate with community on re-branding effort.
