//@ skip

function shouldBe(actual, expected) {
    if (actual !== expected)
        throw new Error('bad value: ' + actual);
}

/*
wasm/globals.wasm is generated by pack-asmjs <https://github.com/WebAssembly/polyfill-prototype-1> from the following script:

function asmModule(global, imports, buffer) {
    "use asm";

    var fround = global.Math.fround;
    var a = imports.a | 0;
    var b = fround(imports.b);
    var c = +imports.c;
    var x = 0;
    var y = fround(0);
    var z = 0.0;

    function getA() {
        return a | 0;
    }

    function getB() {
        return b;
    }

    function getC() {
        return c;
    }

    function getX() {
        return x | 0;
    }

    function getY() {
        return y;
    }

    function getZ() {
        return z;
    }

    function setX(newX) {
        newX = newX | 0;
        x = newX;
    }

    function setY(newY) {
        newY = fround(newY);
        y = newY;
    }

    function setZ(newZ) {
        newZ = +newZ;
        z = newZ;
    }

    function setXExpression(newX) {
        newX = newX | 0;
        return (x = newX) | 0;
    }

    function setYExpression(newY) {
        newY = fround(newY);
        return y = newY;
    }

    function setZExpression(newZ) {
        newZ = +newZ;
        return z = newZ;
    }

    return {
        getA: getA,
        getB: getB,
        getC: getC,
        getX: getX,
        getY: getY,
        getZ: getZ,
        setX: setX,
        setY: setY,
        setZ: setZ,
        setXExpression: setXExpression,
        setYExpression: setYExpression,
        setZExpression: setZExpression,
    };
}
*/

var imports = {
    a: 42,
    b: 4.2,
    c: 4.2,
};
var module = loadWebAssembly("wasm/globals.wasm", imports);

shouldBe(module.getA(), 42);
shouldBe(module.getB(), 4.199999809265137);
shouldBe(module.getC(), 4.2);

shouldBe(module.getX(), 0);
shouldBe(module.getY(), 0);
shouldBe(module.getZ(), 0);

module.setX(1);

shouldBe(module.getX(), 1);
shouldBe(module.getY(), 0);
shouldBe(module.getZ(), 0);

module.setY(0.1);

shouldBe(module.getX(), 1);
shouldBe(module.getY(), 0.10000000149011612);
shouldBe(module.getZ(), 0);

module.setZ(0.1);

shouldBe(module.getX(), 1);
shouldBe(module.getY(), 0.10000000149011612);
shouldBe(module.getZ(), 0.1);

shouldBe(module.setXExpression(2), 2);
shouldBe(module.getX(), 2);
shouldBe(module.setYExpression(0.2), 0.20000000298023224);
shouldBe(module.getY(), 0.20000000298023224);
shouldBe(module.setZExpression(0.2), 0.2);
shouldBe(module.getZ(), 0.2);
