/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PlotList.h>
#include <DataNode.h>
#include <Plot.h>

// ****************************************************************************
// Method: PlotList::PlotList
//
// Purpose: 
//   Init utility for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void PlotList::Init()
{

    PlotList::SelectAll();
}

// ****************************************************************************
// Method: PlotList::PlotList
//
// Purpose: 
//   Copy utility for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void PlotList::Copy(const PlotList &obj)
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the plots field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = plots.begin(); pos != plots.end(); ++pos)
        delete *pos;
    plots.clear();
    if(obj.plots.size() > 0)
        plots.reserve(obj.plots.size());
    // Duplicate the plots from obj.
    for(pos = obj.plots.begin(); pos != obj.plots.end(); ++pos)
    {
        Plot *oldPlot = (Plot *)(*pos);
        Plot *newPlot = new Plot(*oldPlot);
        plots.push_back(newPlot);
    }


    PlotList::SelectAll();
}

// Type map format string
const char *PlotList::TypeMapFormatString = PLOTLIST_TMFS;
const AttributeGroup::private_tmfs_t PlotList::TmfsStruct = {PLOTLIST_TMFS};


// ****************************************************************************
// Method: PlotList::PlotList
//
// Purpose: 
//   Default constructor for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotList::PlotList() : 
    AttributeSubject(PlotList::TypeMapFormatString)
{
    PlotList::Init();
}

// ****************************************************************************
// Method: PlotList::PlotList
//
// Purpose: 
//   Constructor for the derived classes of PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotList::PlotList(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    PlotList::Init();
}

// ****************************************************************************
// Method: PlotList::PlotList
//
// Purpose: 
//   Copy constructor for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotList::PlotList(const PlotList &obj) : 
    AttributeSubject(PlotList::TypeMapFormatString)
{
    PlotList::Copy(obj);
}

// ****************************************************************************
// Method: PlotList::PlotList
//
// Purpose: 
//   Copy constructor for derived classes of the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotList::PlotList(const PlotList &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    PlotList::Copy(obj);
}

// ****************************************************************************
// Method: PlotList::~PlotList
//
// Purpose: 
//   Destructor for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotList::~PlotList()
{
    AttributeGroupVector::iterator pos;

    // Destroy the plots field.
    for(pos = plots.begin(); pos != plots.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: PlotList::operator = 
//
// Purpose: 
//   Assignment operator for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotList& 
PlotList::operator = (const PlotList &obj)
{
    if (this == &obj) return *this;

    PlotList::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: PlotList::operator == 
//
// Purpose: 
//   Comparison operator == for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PlotList::operator == (const PlotList &obj) const
{
    bool plots_equal = (obj.plots.size() == plots.size());
    for(size_t i = 0; (i < plots.size()) && plots_equal; ++i)
    {
        // Make references to Plot from AttributeGroup *.
        const Plot &plots1 = *((const Plot *)(plots[i]));
        const Plot &plots2 = *((const Plot *)(obj.plots[i]));
        plots_equal = (plots1 == plots2);
    }

    // Create the return value
    return (plots_equal);
}

// ****************************************************************************
// Method: PlotList::operator != 
//
// Purpose: 
//   Comparison operator != for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PlotList::operator != (const PlotList &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: PlotList::TypeName
//
// Purpose: 
//   Type name method for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
PlotList::TypeName() const
{
    return "PlotList";
}

// ****************************************************************************
// Method: PlotList::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PlotList::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const PlotList *tmp = (const PlotList *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: PlotList::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PlotList::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new PlotList(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: PlotList::NewInstance
//
// Purpose: 
//   NewInstance method for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PlotList::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new PlotList(*this);
    else
        retval = new PlotList;

    return retval;
}

// ****************************************************************************
// Method: PlotList::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PlotList::SelectAll()
{
    Select(ID_plots, (void *)&plots);
}

// ****************************************************************************
// Method: PlotList::CreateSubAttributeGroup
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
PlotList::CreateSubAttributeGroup(int)
{
    return new Plot;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PlotList::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PlotList::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    PlotList defaultObject;
    bool addToParent = false;
    // Create a node for PlotList.
    DataNode *node = new DataNode("PlotList");

    if(completeSave || !FieldsEqual(ID_plots, &defaultObject))
    {
        addToParent = true;
        for(size_t i = 0; i < plots.size(); ++i)
            plots[i]->CreateNode(node, completeSave, true);
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: PlotList::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PlotList::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("PlotList");
    if(searchNode == 0)
        return;

    DataNode **children;

    // Clear all the Plots if we got any.
    bool clearedPlots = false;
    // Go through all of the children and construct a new
    // Plot for each one of them.
    children = searchNode->GetChildren();
    if(children != 0)
    {
        for(int i = 0; i < searchNode->GetNumChildren(); ++i)
        {
            if(children[i]->GetKey() == std::string("Plot"))
            {
                if (!clearedPlots)
                {
                    ClearPlots();
                    clearedPlots = true;
                }
                Plot temp;
                temp.SetFromNode(children[i]);
                AddPlots(temp);
            }
        }
    }

}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const AttributeGroupVector &
PlotList::GetPlots() const
{
    return plots;
}

AttributeGroupVector &
PlotList::GetPlots()
{
    return plots;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
PlotList::SelectPlots()
{
    Select(ID_plots, (void *)&plots);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PlotList::AddPlots
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PlotList::AddPlots(const Plot &obj)
{
    Plot *newPlot = new Plot(obj);
    plots.push_back(newPlot);

    // Indicate that things have changed by selecting it.
    Select(ID_plots, (void *)&plots);
}

// ****************************************************************************
// Method: PlotList::ClearPlots
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PlotList::ClearPlots()
{
    AttributeGroupVector::iterator pos;

    for(pos = plots.begin(); pos != plots.end(); ++pos)
        delete *pos;
    plots.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_plots, (void *)&plots);
}

// ****************************************************************************
// Method: PlotList::RemovePlots
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PlotList::RemovePlots(int index)
{
    AttributeGroupVector::iterator pos = plots.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        if(pos != plots.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != plots.end())
    {
        delete *pos;
        plots.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_plots, (void *)&plots);
}

// ****************************************************************************
// Method: PlotList::GetNumPlots
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

int
PlotList::GetNumPlots() const
{
    return (int)plots.size();
}

// ****************************************************************************
// Method: PlotList::GetPlots
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Plot &
PlotList::GetPlots(int i)
{
    return *((Plot *)plots[i]);
}

// ****************************************************************************
// Method: PlotList::GetPlots
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const Plot &
PlotList::GetPlots(int i) const
{
    return *((Plot *)plots[i]);
}

// ****************************************************************************
// Method: PlotList::operator []
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Plot &
PlotList::operator [] (int i)
{
    return *((Plot *)plots[i]);
}

// ****************************************************************************
// Method: PlotList::operator []
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const Plot &
PlotList::operator [] (int i) const
{
    return *((Plot *)plots[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PlotList::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PlotList::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_plots: return "plots";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PlotList::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
PlotList::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_plots: return FieldType_attVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: PlotList::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PlotList::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_plots: return "attVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PlotList::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PlotList::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const PlotList &obj = *((const PlotList*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_plots:
        {  // new scope
        bool plots_equal = (obj.plots.size() == plots.size());
        for(size_t i = 0; (i < plots.size()) && plots_equal; ++i)
        {
            // Make references to Plot from AttributeGroup *.
            const Plot &plots1 = *((const Plot *)(plots[i]));
            const Plot &plots2 = *((const Plot *)(obj.plots[i]));
            plots_equal = (plots1 == plots2);
        }

        retval = plots_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

void
PlotList::AddPlot(const Plot &p, int id)
{
    Plot *newPlot = new Plot(p);
    newPlot->SetId(id);
    plots.push_back(newPlot);

    // Indicate that things have changed by selecting the plot list.
    Select(0, (void *)&plots);
}

int
PlotList::FirstSelectedIndex() const
{
    for(int i = 0; i < GetNumPlots(); ++i)
        if(this->operator[](i).GetActiveFlag())
            return i;
    return -1;
}

