# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._logic_management_client_enums import *


class AgreementContent(msrest.serialization.Model):
    """The integration account agreement content.

    :param a_s2: The AS2 agreement content.
    :type a_s2: ~azure.mgmt.logic.models.AS2AgreementContent
    :param x12: The X12 agreement content.
    :type x12: ~azure.mgmt.logic.models.X12AgreementContent
    :param edifact: The EDIFACT agreement content.
    :type edifact: ~azure.mgmt.logic.models.EdifactAgreementContent
    """

    _attribute_map = {
        'a_s2': {'key': 'aS2', 'type': 'AS2AgreementContent'},
        'x12': {'key': 'x12', 'type': 'X12AgreementContent'},
        'edifact': {'key': 'edifact', 'type': 'EdifactAgreementContent'},
    }

    def __init__(
        self,
        *,
        a_s2: Optional["AS2AgreementContent"] = None,
        x12: Optional["X12AgreementContent"] = None,
        edifact: Optional["EdifactAgreementContent"] = None,
        **kwargs
    ):
        super(AgreementContent, self).__init__(**kwargs)
        self.a_s2 = a_s2
        self.x12 = x12
        self.edifact = edifact


class ApiDeploymentParameterMetadata(msrest.serialization.Model):
    """The API deployment parameter metadata.

    :param type: The type.
    :type type: str
    :param is_required: Indicates whether its required.
    :type is_required: bool
    :param display_name: The display name.
    :type display_name: str
    :param description: The description.
    :type description: str
    :param visibility: The visibility. Possible values include: "NotSpecified", "Default",
     "Internal".
    :type visibility: str or ~azure.mgmt.logic.models.ApiDeploymentParameterVisibility
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_required': {'key': 'isRequired', 'type': 'bool'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'visibility': {'key': 'visibility', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        is_required: Optional[bool] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        visibility: Optional[Union[str, "ApiDeploymentParameterVisibility"]] = None,
        **kwargs
    ):
        super(ApiDeploymentParameterMetadata, self).__init__(**kwargs)
        self.type = type
        self.is_required = is_required
        self.display_name = display_name
        self.description = description
        self.visibility = visibility


class ApiDeploymentParameterMetadataSet(msrest.serialization.Model):
    """The API deployment parameters metadata.

    :param package_content_link: The package content link parameter.
    :type package_content_link: ~azure.mgmt.logic.models.ApiDeploymentParameterMetadata
    :param redis_cache_connection_string: The package content link parameter.
    :type redis_cache_connection_string: ~azure.mgmt.logic.models.ApiDeploymentParameterMetadata
    """

    _attribute_map = {
        'package_content_link': {'key': 'packageContentLink', 'type': 'ApiDeploymentParameterMetadata'},
        'redis_cache_connection_string': {'key': 'redisCacheConnectionString', 'type': 'ApiDeploymentParameterMetadata'},
    }

    def __init__(
        self,
        *,
        package_content_link: Optional["ApiDeploymentParameterMetadata"] = None,
        redis_cache_connection_string: Optional["ApiDeploymentParameterMetadata"] = None,
        **kwargs
    ):
        super(ApiDeploymentParameterMetadataSet, self).__init__(**kwargs)
        self.package_content_link = package_content_link
        self.redis_cache_connection_string = redis_cache_connection_string


class Resource(msrest.serialization.Model):
    """The base resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ApiOperation(Resource):
    """The api operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param properties: The api operations properties.
    :type properties: ~azure.mgmt.logic.models.ApiOperationPropertiesDefinition
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'ApiOperationPropertiesDefinition'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["ApiOperationPropertiesDefinition"] = None,
        **kwargs
    ):
        super(ApiOperation, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class ApiOperationAnnotation(msrest.serialization.Model):
    """The Api Operation Annotation.

    :param status: The status annotation. Possible values include: "NotSpecified", "Preview",
     "Production".
    :type status: str or ~azure.mgmt.logic.models.StatusAnnotation
    :param family: The family.
    :type family: str
    :param revision: The revision.
    :type revision: int
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'revision': {'key': 'revision', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "StatusAnnotation"]] = None,
        family: Optional[str] = None,
        revision: Optional[int] = None,
        **kwargs
    ):
        super(ApiOperationAnnotation, self).__init__(**kwargs)
        self.status = status
        self.family = family
        self.revision = revision


class ApiOperationListResult(msrest.serialization.Model):
    """The list of managed API operations.

    :param value: The api operation definitions for an API.
    :type value: list[~azure.mgmt.logic.models.ApiOperation]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiOperation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApiOperation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ApiOperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApiOperationPropertiesDefinition(msrest.serialization.Model):
    """The api operations properties.

    :param summary: The summary of the api operation.
    :type summary: str
    :param description: The description of the api operation.
    :type description: str
    :param visibility: The visibility of the api operation.
    :type visibility: str
    :param trigger: The trigger type of api operation.
    :type trigger: str
    :param trigger_hint: The trigger hint for the api operation.
    :type trigger_hint: str
    :param pageable: Indicates whether the api operation is pageable.
    :type pageable: bool
    :param annotation: The annotation of api operation.
    :type annotation: ~azure.mgmt.logic.models.ApiOperationAnnotation
    :param api: The api reference.
    :type api: ~azure.mgmt.logic.models.ApiReference
    :param inputs_definition: The operation inputs definition schema.
    :type inputs_definition: ~azure.mgmt.logic.models.SwaggerSchema
    :param responses_definition: The operation responses definition schemas.
    :type responses_definition: dict[str, ~azure.mgmt.logic.models.SwaggerSchema]
    :param is_webhook: Indicates whether the API operation is webhook or not.
    :type is_webhook: bool
    :param is_notification: Indicates whether the API operation is notification or not.
    :type is_notification: bool
    """

    _attribute_map = {
        'summary': {'key': 'summary', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'visibility': {'key': 'visibility', 'type': 'str'},
        'trigger': {'key': 'trigger', 'type': 'str'},
        'trigger_hint': {'key': 'triggerHint', 'type': 'str'},
        'pageable': {'key': 'pageable', 'type': 'bool'},
        'annotation': {'key': 'annotation', 'type': 'ApiOperationAnnotation'},
        'api': {'key': 'api', 'type': 'ApiReference'},
        'inputs_definition': {'key': 'inputsDefinition', 'type': 'SwaggerSchema'},
        'responses_definition': {'key': 'responsesDefinition', 'type': '{SwaggerSchema}'},
        'is_webhook': {'key': 'isWebhook', 'type': 'bool'},
        'is_notification': {'key': 'isNotification', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        summary: Optional[str] = None,
        description: Optional[str] = None,
        visibility: Optional[str] = None,
        trigger: Optional[str] = None,
        trigger_hint: Optional[str] = None,
        pageable: Optional[bool] = None,
        annotation: Optional["ApiOperationAnnotation"] = None,
        api: Optional["ApiReference"] = None,
        inputs_definition: Optional["SwaggerSchema"] = None,
        responses_definition: Optional[Dict[str, "SwaggerSchema"]] = None,
        is_webhook: Optional[bool] = None,
        is_notification: Optional[bool] = None,
        **kwargs
    ):
        super(ApiOperationPropertiesDefinition, self).__init__(**kwargs)
        self.summary = summary
        self.description = description
        self.visibility = visibility
        self.trigger = trigger
        self.trigger_hint = trigger_hint
        self.pageable = pageable
        self.annotation = annotation
        self.api = api
        self.inputs_definition = inputs_definition
        self.responses_definition = responses_definition
        self.is_webhook = is_webhook
        self.is_notification = is_notification


class ResourceReference(msrest.serialization.Model):
    """The resource reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: The resource id.
    :type id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(ResourceReference, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None


class ApiReference(ResourceReference):
    """The Api reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: The resource id.
    :type id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param display_name: The display name of the api.
    :type display_name: str
    :param description: The description of the api.
    :type description: str
    :param icon_uri: The icon uri of the api.
    :type icon_uri: str
    :param swagger: The swagger of the api.
    :type swagger: object
    :param brand_color: The brand color of the api.
    :type brand_color: str
    :param category: The tier. Possible values include: "NotSpecified", "Enterprise", "Standard",
     "Premium".
    :type category: str or ~azure.mgmt.logic.models.ApiTier
    :param integration_service_environment: The integration service environment reference.
    :type integration_service_environment: ~azure.mgmt.logic.models.ResourceReference
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'icon_uri': {'key': 'iconUri', 'type': 'str'},
        'swagger': {'key': 'swagger', 'type': 'object'},
        'brand_color': {'key': 'brandColor', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'integration_service_environment': {'key': 'integrationServiceEnvironment', 'type': 'ResourceReference'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        icon_uri: Optional[str] = None,
        swagger: Optional[object] = None,
        brand_color: Optional[str] = None,
        category: Optional[Union[str, "ApiTier"]] = None,
        integration_service_environment: Optional["ResourceReference"] = None,
        **kwargs
    ):
        super(ApiReference, self).__init__(id=id, **kwargs)
        self.display_name = display_name
        self.description = description
        self.icon_uri = icon_uri
        self.swagger = swagger
        self.brand_color = brand_color
        self.category = category
        self.integration_service_environment = integration_service_environment


class ApiResourceBackendService(msrest.serialization.Model):
    """The API backend service.

    :param service_url: The service URL.
    :type service_url: str
    """

    _attribute_map = {
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        service_url: Optional[str] = None,
        **kwargs
    ):
        super(ApiResourceBackendService, self).__init__(**kwargs)
        self.service_url = service_url


class ApiResourceDefinitions(msrest.serialization.Model):
    """The Api resource definition.

    :param original_swagger_url: The original swagger url.
    :type original_swagger_url: str
    :param modified_swagger_url: The modified swagger url.
    :type modified_swagger_url: str
    """

    _attribute_map = {
        'original_swagger_url': {'key': 'originalSwaggerUrl', 'type': 'str'},
        'modified_swagger_url': {'key': 'modifiedSwaggerUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        original_swagger_url: Optional[str] = None,
        modified_swagger_url: Optional[str] = None,
        **kwargs
    ):
        super(ApiResourceDefinitions, self).__init__(**kwargs)
        self.original_swagger_url = original_swagger_url
        self.modified_swagger_url = modified_swagger_url


class ApiResourceGeneralInformation(msrest.serialization.Model):
    """The API general information.

    :param icon_url: The icon url.
    :type icon_url: str
    :param display_name: The display name.
    :type display_name: str
    :param description: The description.
    :type description: str
    :param terms_of_use_url: The terms of use url.
    :type terms_of_use_url: str
    :param release_tag: The release tag.
    :type release_tag: str
    :param tier: The tier. Possible values include: "NotSpecified", "Enterprise", "Standard",
     "Premium".
    :type tier: str or ~azure.mgmt.logic.models.ApiTier
    """

    _attribute_map = {
        'icon_url': {'key': 'iconUrl', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'terms_of_use_url': {'key': 'termsOfUseUrl', 'type': 'str'},
        'release_tag': {'key': 'releaseTag', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        icon_url: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        terms_of_use_url: Optional[str] = None,
        release_tag: Optional[str] = None,
        tier: Optional[Union[str, "ApiTier"]] = None,
        **kwargs
    ):
        super(ApiResourceGeneralInformation, self).__init__(**kwargs)
        self.icon_url = icon_url
        self.display_name = display_name
        self.description = description
        self.terms_of_use_url = terms_of_use_url
        self.release_tag = release_tag
        self.tier = tier


class ApiResourceMetadata(msrest.serialization.Model):
    """The api resource metadata.

    :param source: The source.
    :type source: str
    :param brand_color: The brand color.
    :type brand_color: str
    :param hide_key: The hide key.
    :type hide_key: str
    :param tags: A set of tags. The tags.
    :type tags: dict[str, str]
    :param api_type: The api type. Possible values include: "NotSpecified", "Rest", "Soap".
    :type api_type: str or ~azure.mgmt.logic.models.ApiType
    :param wsdl_service: The WSDL service.
    :type wsdl_service: ~azure.mgmt.logic.models.WsdlService
    :param wsdl_import_method: The WSDL import method. Possible values include: "NotSpecified",
     "SoapToRest", "SoapPassThrough".
    :type wsdl_import_method: str or ~azure.mgmt.logic.models.WsdlImportMethod
    :param connection_type: The connection type.
    :type connection_type: str
    :param provisioning_state: The provisioning state. Possible values include: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
     "Unregistered", "Completed", "Renewing", "Pending", "Waiting", "InProgress".
    :type provisioning_state: str or ~azure.mgmt.logic.models.WorkflowProvisioningState
    :param deployment_parameters: The connector deployment parameters metadata.
    :type deployment_parameters: ~azure.mgmt.logic.models.ApiDeploymentParameterMetadataSet
    """

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'brand_color': {'key': 'brandColor', 'type': 'str'},
        'hide_key': {'key': 'hideKey', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'api_type': {'key': 'ApiType', 'type': 'str'},
        'wsdl_service': {'key': 'wsdlService', 'type': 'WsdlService'},
        'wsdl_import_method': {'key': 'wsdlImportMethod', 'type': 'str'},
        'connection_type': {'key': 'connectionType', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_parameters': {'key': 'deploymentParameters', 'type': 'ApiDeploymentParameterMetadataSet'},
    }

    def __init__(
        self,
        *,
        source: Optional[str] = None,
        brand_color: Optional[str] = None,
        hide_key: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        api_type: Optional[Union[str, "ApiType"]] = None,
        wsdl_service: Optional["WsdlService"] = None,
        wsdl_import_method: Optional[Union[str, "WsdlImportMethod"]] = None,
        connection_type: Optional[str] = None,
        provisioning_state: Optional[Union[str, "WorkflowProvisioningState"]] = None,
        deployment_parameters: Optional["ApiDeploymentParameterMetadataSet"] = None,
        **kwargs
    ):
        super(ApiResourceMetadata, self).__init__(**kwargs)
        self.source = source
        self.brand_color = brand_color
        self.hide_key = hide_key
        self.tags = tags
        self.api_type = api_type
        self.wsdl_service = wsdl_service
        self.wsdl_import_method = wsdl_import_method
        self.connection_type = connection_type
        self.provisioning_state = provisioning_state
        self.deployment_parameters = deployment_parameters


class ApiResourcePolicies(msrest.serialization.Model):
    """The API resource policies.

    :param content: The API level only policies XML as embedded content.
    :type content: str
    :param content_link: The content link to the policies.
    :type content_link: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'content_link': {'key': 'contentLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        content: Optional[str] = None,
        content_link: Optional[str] = None,
        **kwargs
    ):
        super(ApiResourcePolicies, self).__init__(**kwargs)
        self.content = content
        self.content_link = content_link


class ApiResourceProperties(msrest.serialization.Model):
    """The API resource properties.

    :param name: The name.
    :type name: str
    :param connection_parameters: The connection parameters.
    :type connection_parameters: dict[str, object]
    :param metadata: The metadata.
    :type metadata: ~azure.mgmt.logic.models.ApiResourceMetadata
    :param runtime_urls: The runtime urls.
    :type runtime_urls: list[str]
    :param general_information: The api general information.
    :type general_information: ~azure.mgmt.logic.models.ApiResourceGeneralInformation
    :param capabilities: The capabilities.
    :type capabilities: list[str]
    :param backend_service: The backend service.
    :type backend_service: ~azure.mgmt.logic.models.ApiResourceBackendService
    :param policies: The policies for the API.
    :type policies: ~azure.mgmt.logic.models.ApiResourcePolicies
    :param api_definition_url: The API definition.
    :type api_definition_url: str
    :param api_definitions: The api definitions.
    :type api_definitions: ~azure.mgmt.logic.models.ApiResourceDefinitions
    :param integration_service_environment: The integration service environment reference.
    :type integration_service_environment: ~azure.mgmt.logic.models.ResourceReference
    :param provisioning_state: The provisioning state. Possible values include: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
     "Unregistered", "Completed", "Renewing", "Pending", "Waiting", "InProgress".
    :type provisioning_state: str or ~azure.mgmt.logic.models.WorkflowProvisioningState
    :param category: The category. Possible values include: "NotSpecified", "Enterprise",
     "Standard", "Premium".
    :type category: str or ~azure.mgmt.logic.models.ApiTier
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'connection_parameters': {'key': 'connectionParameters', 'type': '{object}'},
        'metadata': {'key': 'metadata', 'type': 'ApiResourceMetadata'},
        'runtime_urls': {'key': 'runtimeUrls', 'type': '[str]'},
        'general_information': {'key': 'generalInformation', 'type': 'ApiResourceGeneralInformation'},
        'capabilities': {'key': 'capabilities', 'type': '[str]'},
        'backend_service': {'key': 'backendService', 'type': 'ApiResourceBackendService'},
        'policies': {'key': 'policies', 'type': 'ApiResourcePolicies'},
        'api_definition_url': {'key': 'apiDefinitionUrl', 'type': 'str'},
        'api_definitions': {'key': 'apiDefinitions', 'type': 'ApiResourceDefinitions'},
        'integration_service_environment': {'key': 'integrationServiceEnvironment', 'type': 'ResourceReference'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        connection_parameters: Optional[Dict[str, object]] = None,
        metadata: Optional["ApiResourceMetadata"] = None,
        runtime_urls: Optional[List[str]] = None,
        general_information: Optional["ApiResourceGeneralInformation"] = None,
        capabilities: Optional[List[str]] = None,
        backend_service: Optional["ApiResourceBackendService"] = None,
        policies: Optional["ApiResourcePolicies"] = None,
        api_definition_url: Optional[str] = None,
        api_definitions: Optional["ApiResourceDefinitions"] = None,
        integration_service_environment: Optional["ResourceReference"] = None,
        provisioning_state: Optional[Union[str, "WorkflowProvisioningState"]] = None,
        category: Optional[Union[str, "ApiTier"]] = None,
        **kwargs
    ):
        super(ApiResourceProperties, self).__init__(**kwargs)
        self.name = name
        self.connection_parameters = connection_parameters
        self.metadata = metadata
        self.runtime_urls = runtime_urls
        self.general_information = general_information
        self.capabilities = capabilities
        self.backend_service = backend_service
        self.policies = policies
        self.api_definition_url = api_definition_url
        self.api_definitions = api_definitions
        self.integration_service_environment = integration_service_environment
        self.provisioning_state = provisioning_state
        self.category = category


class ArtifactProperties(msrest.serialization.Model):
    """The artifact properties definition.

    :param created_time: The artifact creation time.
    :type created_time: ~datetime.datetime
    :param changed_time: The artifact changed time.
    :type changed_time: ~datetime.datetime
    :param metadata: Any object.
    :type metadata: object
    """

    _attribute_map = {
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        created_time: Optional[datetime.datetime] = None,
        changed_time: Optional[datetime.datetime] = None,
        metadata: Optional[object] = None,
        **kwargs
    ):
        super(ArtifactProperties, self).__init__(**kwargs)
        self.created_time = created_time
        self.changed_time = changed_time
        self.metadata = metadata


class ArtifactContentPropertiesDefinition(ArtifactProperties):
    """The artifact content properties definition.

    :param created_time: The artifact creation time.
    :type created_time: ~datetime.datetime
    :param changed_time: The artifact changed time.
    :type changed_time: ~datetime.datetime
    :param metadata: Any object.
    :type metadata: object
    :param content: Any object.
    :type content: object
    :param content_type: The content type.
    :type content_type: str
    :param content_link: The content link.
    :type content_link: ~azure.mgmt.logic.models.ContentLink
    """

    _attribute_map = {
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'content': {'key': 'content', 'type': 'object'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'content_link': {'key': 'contentLink', 'type': 'ContentLink'},
    }

    def __init__(
        self,
        *,
        created_time: Optional[datetime.datetime] = None,
        changed_time: Optional[datetime.datetime] = None,
        metadata: Optional[object] = None,
        content: Optional[object] = None,
        content_type: Optional[str] = None,
        content_link: Optional["ContentLink"] = None,
        **kwargs
    ):
        super(ArtifactContentPropertiesDefinition, self).__init__(created_time=created_time, changed_time=changed_time, metadata=metadata, **kwargs)
        self.content = content
        self.content_type = content_type
        self.content_link = content_link


class AS2AcknowledgementConnectionSettings(msrest.serialization.Model):
    """The AS2 agreement acknowledgement connection settings.

    All required parameters must be populated in order to send to Azure.

    :param ignore_certificate_name_mismatch: Required. Indicates whether to ignore mismatch in
     certificate name.
    :type ignore_certificate_name_mismatch: bool
    :param support_http_status_code_continue: Required. Indicates whether to support HTTP status
     code 'CONTINUE'.
    :type support_http_status_code_continue: bool
    :param keep_http_connection_alive: Required. Indicates whether to keep the connection alive.
    :type keep_http_connection_alive: bool
    :param unfold_http_headers: Required. Indicates whether to unfold the HTTP headers.
    :type unfold_http_headers: bool
    """

    _validation = {
        'ignore_certificate_name_mismatch': {'required': True},
        'support_http_status_code_continue': {'required': True},
        'keep_http_connection_alive': {'required': True},
        'unfold_http_headers': {'required': True},
    }

    _attribute_map = {
        'ignore_certificate_name_mismatch': {'key': 'ignoreCertificateNameMismatch', 'type': 'bool'},
        'support_http_status_code_continue': {'key': 'supportHttpStatusCodeContinue', 'type': 'bool'},
        'keep_http_connection_alive': {'key': 'keepHttpConnectionAlive', 'type': 'bool'},
        'unfold_http_headers': {'key': 'unfoldHttpHeaders', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        ignore_certificate_name_mismatch: bool,
        support_http_status_code_continue: bool,
        keep_http_connection_alive: bool,
        unfold_http_headers: bool,
        **kwargs
    ):
        super(AS2AcknowledgementConnectionSettings, self).__init__(**kwargs)
        self.ignore_certificate_name_mismatch = ignore_certificate_name_mismatch
        self.support_http_status_code_continue = support_http_status_code_continue
        self.keep_http_connection_alive = keep_http_connection_alive
        self.unfold_http_headers = unfold_http_headers


class AS2AgreementContent(msrest.serialization.Model):
    """The integration account AS2 agreement content.

    All required parameters must be populated in order to send to Azure.

    :param receive_agreement: Required. The AS2 one-way receive agreement.
    :type receive_agreement: ~azure.mgmt.logic.models.AS2OneWayAgreement
    :param send_agreement: Required. The AS2 one-way send agreement.
    :type send_agreement: ~azure.mgmt.logic.models.AS2OneWayAgreement
    """

    _validation = {
        'receive_agreement': {'required': True},
        'send_agreement': {'required': True},
    }

    _attribute_map = {
        'receive_agreement': {'key': 'receiveAgreement', 'type': 'AS2OneWayAgreement'},
        'send_agreement': {'key': 'sendAgreement', 'type': 'AS2OneWayAgreement'},
    }

    def __init__(
        self,
        *,
        receive_agreement: "AS2OneWayAgreement",
        send_agreement: "AS2OneWayAgreement",
        **kwargs
    ):
        super(AS2AgreementContent, self).__init__(**kwargs)
        self.receive_agreement = receive_agreement
        self.send_agreement = send_agreement


class AS2EnvelopeSettings(msrest.serialization.Model):
    """The AS2 agreement envelope settings.

    All required parameters must be populated in order to send to Azure.

    :param message_content_type: Required. The message content type.
    :type message_content_type: str
    :param transmit_file_name_in_mime_header: Required. The value indicating whether to transmit
     file name in mime header.
    :type transmit_file_name_in_mime_header: bool
    :param file_name_template: Required. The template for file name.
    :type file_name_template: str
    :param suspend_message_on_file_name_generation_error: Required. The value indicating whether to
     suspend message on file name generation error.
    :type suspend_message_on_file_name_generation_error: bool
    :param autogenerate_file_name: Required. The value indicating whether to auto generate file
     name.
    :type autogenerate_file_name: bool
    """

    _validation = {
        'message_content_type': {'required': True},
        'transmit_file_name_in_mime_header': {'required': True},
        'file_name_template': {'required': True},
        'suspend_message_on_file_name_generation_error': {'required': True},
        'autogenerate_file_name': {'required': True},
    }

    _attribute_map = {
        'message_content_type': {'key': 'messageContentType', 'type': 'str'},
        'transmit_file_name_in_mime_header': {'key': 'transmitFileNameInMimeHeader', 'type': 'bool'},
        'file_name_template': {'key': 'fileNameTemplate', 'type': 'str'},
        'suspend_message_on_file_name_generation_error': {'key': 'suspendMessageOnFileNameGenerationError', 'type': 'bool'},
        'autogenerate_file_name': {'key': 'autogenerateFileName', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        message_content_type: str,
        transmit_file_name_in_mime_header: bool,
        file_name_template: str,
        suspend_message_on_file_name_generation_error: bool,
        autogenerate_file_name: bool,
        **kwargs
    ):
        super(AS2EnvelopeSettings, self).__init__(**kwargs)
        self.message_content_type = message_content_type
        self.transmit_file_name_in_mime_header = transmit_file_name_in_mime_header
        self.file_name_template = file_name_template
        self.suspend_message_on_file_name_generation_error = suspend_message_on_file_name_generation_error
        self.autogenerate_file_name = autogenerate_file_name


class AS2ErrorSettings(msrest.serialization.Model):
    """The AS2 agreement error settings.

    All required parameters must be populated in order to send to Azure.

    :param suspend_duplicate_message: Required. The value indicating whether to suspend duplicate
     message.
    :type suspend_duplicate_message: bool
    :param resend_if_mdn_not_received: Required. The value indicating whether to resend message If
     MDN is not received.
    :type resend_if_mdn_not_received: bool
    """

    _validation = {
        'suspend_duplicate_message': {'required': True},
        'resend_if_mdn_not_received': {'required': True},
    }

    _attribute_map = {
        'suspend_duplicate_message': {'key': 'suspendDuplicateMessage', 'type': 'bool'},
        'resend_if_mdn_not_received': {'key': 'resendIfMDNNotReceived', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        suspend_duplicate_message: bool,
        resend_if_mdn_not_received: bool,
        **kwargs
    ):
        super(AS2ErrorSettings, self).__init__(**kwargs)
        self.suspend_duplicate_message = suspend_duplicate_message
        self.resend_if_mdn_not_received = resend_if_mdn_not_received


class AS2MdnSettings(msrest.serialization.Model):
    """The AS2 agreement mdn settings.

    All required parameters must be populated in order to send to Azure.

    :param need_mdn: Required. The value indicating whether to send or request a MDN.
    :type need_mdn: bool
    :param sign_mdn: Required. The value indicating whether the MDN needs to be signed or not.
    :type sign_mdn: bool
    :param send_mdn_asynchronously: Required. The value indicating whether to send the asynchronous
     MDN.
    :type send_mdn_asynchronously: bool
    :param receipt_delivery_url: The receipt delivery URL.
    :type receipt_delivery_url: str
    :param disposition_notification_to: The disposition notification to header value.
    :type disposition_notification_to: str
    :param sign_outbound_mdn_if_optional: Required. The value indicating whether to sign the
     outbound MDN if optional.
    :type sign_outbound_mdn_if_optional: bool
    :param mdn_text: The MDN text.
    :type mdn_text: str
    :param send_inbound_mdn_to_message_box: Required. The value indicating whether to send inbound
     MDN to message box.
    :type send_inbound_mdn_to_message_box: bool
    :param mic_hashing_algorithm: Required. The signing or hashing algorithm. Possible values
     include: "NotSpecified", "None", "MD5", "SHA1", "SHA2256", "SHA2384", "SHA2512".
    :type mic_hashing_algorithm: str or ~azure.mgmt.logic.models.HashingAlgorithm
    """

    _validation = {
        'need_mdn': {'required': True},
        'sign_mdn': {'required': True},
        'send_mdn_asynchronously': {'required': True},
        'sign_outbound_mdn_if_optional': {'required': True},
        'send_inbound_mdn_to_message_box': {'required': True},
        'mic_hashing_algorithm': {'required': True},
    }

    _attribute_map = {
        'need_mdn': {'key': 'needMDN', 'type': 'bool'},
        'sign_mdn': {'key': 'signMDN', 'type': 'bool'},
        'send_mdn_asynchronously': {'key': 'sendMDNAsynchronously', 'type': 'bool'},
        'receipt_delivery_url': {'key': 'receiptDeliveryUrl', 'type': 'str'},
        'disposition_notification_to': {'key': 'dispositionNotificationTo', 'type': 'str'},
        'sign_outbound_mdn_if_optional': {'key': 'signOutboundMDNIfOptional', 'type': 'bool'},
        'mdn_text': {'key': 'mdnText', 'type': 'str'},
        'send_inbound_mdn_to_message_box': {'key': 'sendInboundMDNToMessageBox', 'type': 'bool'},
        'mic_hashing_algorithm': {'key': 'micHashingAlgorithm', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        need_mdn: bool,
        sign_mdn: bool,
        send_mdn_asynchronously: bool,
        sign_outbound_mdn_if_optional: bool,
        send_inbound_mdn_to_message_box: bool,
        mic_hashing_algorithm: Union[str, "HashingAlgorithm"],
        receipt_delivery_url: Optional[str] = None,
        disposition_notification_to: Optional[str] = None,
        mdn_text: Optional[str] = None,
        **kwargs
    ):
        super(AS2MdnSettings, self).__init__(**kwargs)
        self.need_mdn = need_mdn
        self.sign_mdn = sign_mdn
        self.send_mdn_asynchronously = send_mdn_asynchronously
        self.receipt_delivery_url = receipt_delivery_url
        self.disposition_notification_to = disposition_notification_to
        self.sign_outbound_mdn_if_optional = sign_outbound_mdn_if_optional
        self.mdn_text = mdn_text
        self.send_inbound_mdn_to_message_box = send_inbound_mdn_to_message_box
        self.mic_hashing_algorithm = mic_hashing_algorithm


class AS2MessageConnectionSettings(msrest.serialization.Model):
    """The AS2 agreement message connection settings.

    All required parameters must be populated in order to send to Azure.

    :param ignore_certificate_name_mismatch: Required. The value indicating whether to ignore
     mismatch in certificate name.
    :type ignore_certificate_name_mismatch: bool
    :param support_http_status_code_continue: Required. The value indicating whether to support
     HTTP status code 'CONTINUE'.
    :type support_http_status_code_continue: bool
    :param keep_http_connection_alive: Required. The value indicating whether to keep the
     connection alive.
    :type keep_http_connection_alive: bool
    :param unfold_http_headers: Required. The value indicating whether to unfold the HTTP headers.
    :type unfold_http_headers: bool
    """

    _validation = {
        'ignore_certificate_name_mismatch': {'required': True},
        'support_http_status_code_continue': {'required': True},
        'keep_http_connection_alive': {'required': True},
        'unfold_http_headers': {'required': True},
    }

    _attribute_map = {
        'ignore_certificate_name_mismatch': {'key': 'ignoreCertificateNameMismatch', 'type': 'bool'},
        'support_http_status_code_continue': {'key': 'supportHttpStatusCodeContinue', 'type': 'bool'},
        'keep_http_connection_alive': {'key': 'keepHttpConnectionAlive', 'type': 'bool'},
        'unfold_http_headers': {'key': 'unfoldHttpHeaders', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        ignore_certificate_name_mismatch: bool,
        support_http_status_code_continue: bool,
        keep_http_connection_alive: bool,
        unfold_http_headers: bool,
        **kwargs
    ):
        super(AS2MessageConnectionSettings, self).__init__(**kwargs)
        self.ignore_certificate_name_mismatch = ignore_certificate_name_mismatch
        self.support_http_status_code_continue = support_http_status_code_continue
        self.keep_http_connection_alive = keep_http_connection_alive
        self.unfold_http_headers = unfold_http_headers


class AS2OneWayAgreement(msrest.serialization.Model):
    """The integration account AS2 one-way agreement.

    All required parameters must be populated in order to send to Azure.

    :param sender_business_identity: Required. The sender business identity.
    :type sender_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :param receiver_business_identity: Required. The receiver business identity.
    :type receiver_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :param protocol_settings: Required. The AS2 protocol settings.
    :type protocol_settings: ~azure.mgmt.logic.models.AS2ProtocolSettings
    """

    _validation = {
        'sender_business_identity': {'required': True},
        'receiver_business_identity': {'required': True},
        'protocol_settings': {'required': True},
    }

    _attribute_map = {
        'sender_business_identity': {'key': 'senderBusinessIdentity', 'type': 'BusinessIdentity'},
        'receiver_business_identity': {'key': 'receiverBusinessIdentity', 'type': 'BusinessIdentity'},
        'protocol_settings': {'key': 'protocolSettings', 'type': 'AS2ProtocolSettings'},
    }

    def __init__(
        self,
        *,
        sender_business_identity: "BusinessIdentity",
        receiver_business_identity: "BusinessIdentity",
        protocol_settings: "AS2ProtocolSettings",
        **kwargs
    ):
        super(AS2OneWayAgreement, self).__init__(**kwargs)
        self.sender_business_identity = sender_business_identity
        self.receiver_business_identity = receiver_business_identity
        self.protocol_settings = protocol_settings


class AS2ProtocolSettings(msrest.serialization.Model):
    """The AS2 agreement protocol settings.

    All required parameters must be populated in order to send to Azure.

    :param message_connection_settings: Required. The message connection settings.
    :type message_connection_settings: ~azure.mgmt.logic.models.AS2MessageConnectionSettings
    :param acknowledgement_connection_settings: Required. The acknowledgement connection settings.
    :type acknowledgement_connection_settings:
     ~azure.mgmt.logic.models.AS2AcknowledgementConnectionSettings
    :param mdn_settings: Required. The MDN settings.
    :type mdn_settings: ~azure.mgmt.logic.models.AS2MdnSettings
    :param security_settings: Required. The security settings.
    :type security_settings: ~azure.mgmt.logic.models.AS2SecuritySettings
    :param validation_settings: Required. The validation settings.
    :type validation_settings: ~azure.mgmt.logic.models.AS2ValidationSettings
    :param envelope_settings: Required. The envelope settings.
    :type envelope_settings: ~azure.mgmt.logic.models.AS2EnvelopeSettings
    :param error_settings: Required. The error settings.
    :type error_settings: ~azure.mgmt.logic.models.AS2ErrorSettings
    """

    _validation = {
        'message_connection_settings': {'required': True},
        'acknowledgement_connection_settings': {'required': True},
        'mdn_settings': {'required': True},
        'security_settings': {'required': True},
        'validation_settings': {'required': True},
        'envelope_settings': {'required': True},
        'error_settings': {'required': True},
    }

    _attribute_map = {
        'message_connection_settings': {'key': 'messageConnectionSettings', 'type': 'AS2MessageConnectionSettings'},
        'acknowledgement_connection_settings': {'key': 'acknowledgementConnectionSettings', 'type': 'AS2AcknowledgementConnectionSettings'},
        'mdn_settings': {'key': 'mdnSettings', 'type': 'AS2MdnSettings'},
        'security_settings': {'key': 'securitySettings', 'type': 'AS2SecuritySettings'},
        'validation_settings': {'key': 'validationSettings', 'type': 'AS2ValidationSettings'},
        'envelope_settings': {'key': 'envelopeSettings', 'type': 'AS2EnvelopeSettings'},
        'error_settings': {'key': 'errorSettings', 'type': 'AS2ErrorSettings'},
    }

    def __init__(
        self,
        *,
        message_connection_settings: "AS2MessageConnectionSettings",
        acknowledgement_connection_settings: "AS2AcknowledgementConnectionSettings",
        mdn_settings: "AS2MdnSettings",
        security_settings: "AS2SecuritySettings",
        validation_settings: "AS2ValidationSettings",
        envelope_settings: "AS2EnvelopeSettings",
        error_settings: "AS2ErrorSettings",
        **kwargs
    ):
        super(AS2ProtocolSettings, self).__init__(**kwargs)
        self.message_connection_settings = message_connection_settings
        self.acknowledgement_connection_settings = acknowledgement_connection_settings
        self.mdn_settings = mdn_settings
        self.security_settings = security_settings
        self.validation_settings = validation_settings
        self.envelope_settings = envelope_settings
        self.error_settings = error_settings


class AS2SecuritySettings(msrest.serialization.Model):
    """The AS2 agreement security settings.

    All required parameters must be populated in order to send to Azure.

    :param override_group_signing_certificate: Required. The value indicating whether to send or
     request a MDN.
    :type override_group_signing_certificate: bool
    :param signing_certificate_name: The name of the signing certificate.
    :type signing_certificate_name: str
    :param encryption_certificate_name: The name of the encryption certificate.
    :type encryption_certificate_name: str
    :param enable_nrr_for_inbound_encoded_messages: Required. The value indicating whether to
     enable NRR for inbound encoded messages.
    :type enable_nrr_for_inbound_encoded_messages: bool
    :param enable_nrr_for_inbound_decoded_messages: Required. The value indicating whether to
     enable NRR for inbound decoded messages.
    :type enable_nrr_for_inbound_decoded_messages: bool
    :param enable_nrr_for_outbound_mdn: Required. The value indicating whether to enable NRR for
     outbound MDN.
    :type enable_nrr_for_outbound_mdn: bool
    :param enable_nrr_for_outbound_encoded_messages: Required. The value indicating whether to
     enable NRR for outbound encoded messages.
    :type enable_nrr_for_outbound_encoded_messages: bool
    :param enable_nrr_for_outbound_decoded_messages: Required. The value indicating whether to
     enable NRR for outbound decoded messages.
    :type enable_nrr_for_outbound_decoded_messages: bool
    :param enable_nrr_for_inbound_mdn: Required. The value indicating whether to enable NRR for
     inbound MDN.
    :type enable_nrr_for_inbound_mdn: bool
    :param sha2_algorithm_format: The Sha2 algorithm format. Valid values are Sha2, ShaHashSize,
     ShaHyphenHashSize, Sha2UnderscoreHashSize.
    :type sha2_algorithm_format: str
    """

    _validation = {
        'override_group_signing_certificate': {'required': True},
        'enable_nrr_for_inbound_encoded_messages': {'required': True},
        'enable_nrr_for_inbound_decoded_messages': {'required': True},
        'enable_nrr_for_outbound_mdn': {'required': True},
        'enable_nrr_for_outbound_encoded_messages': {'required': True},
        'enable_nrr_for_outbound_decoded_messages': {'required': True},
        'enable_nrr_for_inbound_mdn': {'required': True},
    }

    _attribute_map = {
        'override_group_signing_certificate': {'key': 'overrideGroupSigningCertificate', 'type': 'bool'},
        'signing_certificate_name': {'key': 'signingCertificateName', 'type': 'str'},
        'encryption_certificate_name': {'key': 'encryptionCertificateName', 'type': 'str'},
        'enable_nrr_for_inbound_encoded_messages': {'key': 'enableNRRForInboundEncodedMessages', 'type': 'bool'},
        'enable_nrr_for_inbound_decoded_messages': {'key': 'enableNRRForInboundDecodedMessages', 'type': 'bool'},
        'enable_nrr_for_outbound_mdn': {'key': 'enableNRRForOutboundMDN', 'type': 'bool'},
        'enable_nrr_for_outbound_encoded_messages': {'key': 'enableNRRForOutboundEncodedMessages', 'type': 'bool'},
        'enable_nrr_for_outbound_decoded_messages': {'key': 'enableNRRForOutboundDecodedMessages', 'type': 'bool'},
        'enable_nrr_for_inbound_mdn': {'key': 'enableNRRForInboundMDN', 'type': 'bool'},
        'sha2_algorithm_format': {'key': 'sha2AlgorithmFormat', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        override_group_signing_certificate: bool,
        enable_nrr_for_inbound_encoded_messages: bool,
        enable_nrr_for_inbound_decoded_messages: bool,
        enable_nrr_for_outbound_mdn: bool,
        enable_nrr_for_outbound_encoded_messages: bool,
        enable_nrr_for_outbound_decoded_messages: bool,
        enable_nrr_for_inbound_mdn: bool,
        signing_certificate_name: Optional[str] = None,
        encryption_certificate_name: Optional[str] = None,
        sha2_algorithm_format: Optional[str] = None,
        **kwargs
    ):
        super(AS2SecuritySettings, self).__init__(**kwargs)
        self.override_group_signing_certificate = override_group_signing_certificate
        self.signing_certificate_name = signing_certificate_name
        self.encryption_certificate_name = encryption_certificate_name
        self.enable_nrr_for_inbound_encoded_messages = enable_nrr_for_inbound_encoded_messages
        self.enable_nrr_for_inbound_decoded_messages = enable_nrr_for_inbound_decoded_messages
        self.enable_nrr_for_outbound_mdn = enable_nrr_for_outbound_mdn
        self.enable_nrr_for_outbound_encoded_messages = enable_nrr_for_outbound_encoded_messages
        self.enable_nrr_for_outbound_decoded_messages = enable_nrr_for_outbound_decoded_messages
        self.enable_nrr_for_inbound_mdn = enable_nrr_for_inbound_mdn
        self.sha2_algorithm_format = sha2_algorithm_format


class AS2ValidationSettings(msrest.serialization.Model):
    """The AS2 agreement validation settings.

    All required parameters must be populated in order to send to Azure.

    :param override_message_properties: Required. The value indicating whether to override incoming
     message properties with those in agreement.
    :type override_message_properties: bool
    :param encrypt_message: Required. The value indicating whether the message has to be encrypted.
    :type encrypt_message: bool
    :param sign_message: Required. The value indicating whether the message has to be signed.
    :type sign_message: bool
    :param compress_message: Required. The value indicating whether the message has to be
     compressed.
    :type compress_message: bool
    :param check_duplicate_message: Required. The value indicating whether to check for duplicate
     message.
    :type check_duplicate_message: bool
    :param interchange_duplicates_validity_days: Required. The number of days to look back for
     duplicate interchange.
    :type interchange_duplicates_validity_days: int
    :param check_certificate_revocation_list_on_send: Required. The value indicating whether to
     check for certificate revocation list on send.
    :type check_certificate_revocation_list_on_send: bool
    :param check_certificate_revocation_list_on_receive: Required. The value indicating whether to
     check for certificate revocation list on receive.
    :type check_certificate_revocation_list_on_receive: bool
    :param encryption_algorithm: Required. The encryption algorithm. Possible values include:
     "NotSpecified", "None", "DES3", "RC2", "AES128", "AES192", "AES256".
    :type encryption_algorithm: str or ~azure.mgmt.logic.models.EncryptionAlgorithm
    :param signing_algorithm: The signing algorithm. Possible values include: "NotSpecified",
     "Default", "SHA1", "SHA2256", "SHA2384", "SHA2512".
    :type signing_algorithm: str or ~azure.mgmt.logic.models.SigningAlgorithm
    """

    _validation = {
        'override_message_properties': {'required': True},
        'encrypt_message': {'required': True},
        'sign_message': {'required': True},
        'compress_message': {'required': True},
        'check_duplicate_message': {'required': True},
        'interchange_duplicates_validity_days': {'required': True},
        'check_certificate_revocation_list_on_send': {'required': True},
        'check_certificate_revocation_list_on_receive': {'required': True},
        'encryption_algorithm': {'required': True},
    }

    _attribute_map = {
        'override_message_properties': {'key': 'overrideMessageProperties', 'type': 'bool'},
        'encrypt_message': {'key': 'encryptMessage', 'type': 'bool'},
        'sign_message': {'key': 'signMessage', 'type': 'bool'},
        'compress_message': {'key': 'compressMessage', 'type': 'bool'},
        'check_duplicate_message': {'key': 'checkDuplicateMessage', 'type': 'bool'},
        'interchange_duplicates_validity_days': {'key': 'interchangeDuplicatesValidityDays', 'type': 'int'},
        'check_certificate_revocation_list_on_send': {'key': 'checkCertificateRevocationListOnSend', 'type': 'bool'},
        'check_certificate_revocation_list_on_receive': {'key': 'checkCertificateRevocationListOnReceive', 'type': 'bool'},
        'encryption_algorithm': {'key': 'encryptionAlgorithm', 'type': 'str'},
        'signing_algorithm': {'key': 'signingAlgorithm', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        override_message_properties: bool,
        encrypt_message: bool,
        sign_message: bool,
        compress_message: bool,
        check_duplicate_message: bool,
        interchange_duplicates_validity_days: int,
        check_certificate_revocation_list_on_send: bool,
        check_certificate_revocation_list_on_receive: bool,
        encryption_algorithm: Union[str, "EncryptionAlgorithm"],
        signing_algorithm: Optional[Union[str, "SigningAlgorithm"]] = None,
        **kwargs
    ):
        super(AS2ValidationSettings, self).__init__(**kwargs)
        self.override_message_properties = override_message_properties
        self.encrypt_message = encrypt_message
        self.sign_message = sign_message
        self.compress_message = compress_message
        self.check_duplicate_message = check_duplicate_message
        self.interchange_duplicates_validity_days = interchange_duplicates_validity_days
        self.check_certificate_revocation_list_on_send = check_certificate_revocation_list_on_send
        self.check_certificate_revocation_list_on_receive = check_certificate_revocation_list_on_receive
        self.encryption_algorithm = encryption_algorithm
        self.signing_algorithm = signing_algorithm


class AssemblyCollection(msrest.serialization.Model):
    """A collection of assembly definitions.

    :param value:
    :type value: list[~azure.mgmt.logic.models.AssemblyDefinition]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AssemblyDefinition]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AssemblyDefinition"]] = None,
        **kwargs
    ):
        super(AssemblyCollection, self).__init__(**kwargs)
        self.value = value


class AssemblyDefinition(Resource):
    """The assembly definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param properties: Required. The assembly properties.
    :type properties: ~azure.mgmt.logic.models.AssemblyProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'AssemblyProperties'},
    }

    def __init__(
        self,
        *,
        properties: "AssemblyProperties",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(AssemblyDefinition, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class AssemblyProperties(ArtifactContentPropertiesDefinition):
    """The assembly properties definition.

    All required parameters must be populated in order to send to Azure.

    :param created_time: The artifact creation time.
    :type created_time: ~datetime.datetime
    :param changed_time: The artifact changed time.
    :type changed_time: ~datetime.datetime
    :param metadata: Any object.
    :type metadata: object
    :param content: Any object.
    :type content: object
    :param content_type: The content type.
    :type content_type: str
    :param content_link: The content link.
    :type content_link: ~azure.mgmt.logic.models.ContentLink
    :param assembly_name: Required. The assembly name.
    :type assembly_name: str
    :param assembly_version: The assembly version.
    :type assembly_version: str
    :param assembly_culture: The assembly culture.
    :type assembly_culture: str
    :param assembly_public_key_token: The assembly public key token.
    :type assembly_public_key_token: str
    """

    _validation = {
        'assembly_name': {'required': True},
    }

    _attribute_map = {
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'content': {'key': 'content', 'type': 'object'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'content_link': {'key': 'contentLink', 'type': 'ContentLink'},
        'assembly_name': {'key': 'assemblyName', 'type': 'str'},
        'assembly_version': {'key': 'assemblyVersion', 'type': 'str'},
        'assembly_culture': {'key': 'assemblyCulture', 'type': 'str'},
        'assembly_public_key_token': {'key': 'assemblyPublicKeyToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        assembly_name: str,
        created_time: Optional[datetime.datetime] = None,
        changed_time: Optional[datetime.datetime] = None,
        metadata: Optional[object] = None,
        content: Optional[object] = None,
        content_type: Optional[str] = None,
        content_link: Optional["ContentLink"] = None,
        assembly_version: Optional[str] = None,
        assembly_culture: Optional[str] = None,
        assembly_public_key_token: Optional[str] = None,
        **kwargs
    ):
        super(AssemblyProperties, self).__init__(created_time=created_time, changed_time=changed_time, metadata=metadata, content=content, content_type=content_type, content_link=content_link, **kwargs)
        self.assembly_name = assembly_name
        self.assembly_version = assembly_version
        self.assembly_culture = assembly_culture
        self.assembly_public_key_token = assembly_public_key_token


class ErrorInfo(msrest.serialization.Model):
    """The error info.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error code.
    :type code: str
    """

    _validation = {
        'code': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: str,
        **kwargs
    ):
        super(ErrorInfo, self).__init__(**kwargs)
        self.code = code


class AzureResourceErrorInfo(ErrorInfo):
    """The azure resource error info.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error code.
    :type code: str
    :param message: Required. The error message.
    :type message: str
    :param details: The error details.
    :type details: list[~azure.mgmt.logic.models.AzureResourceErrorInfo]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[AzureResourceErrorInfo]'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[List["AzureResourceErrorInfo"]] = None,
        **kwargs
    ):
        super(AzureResourceErrorInfo, self).__init__(code=code, **kwargs)
        self.message = message
        self.details = details


class B2BPartnerContent(msrest.serialization.Model):
    """The B2B partner content.

    :param business_identities: The list of partner business identities.
    :type business_identities: list[~azure.mgmt.logic.models.BusinessIdentity]
    """

    _attribute_map = {
        'business_identities': {'key': 'businessIdentities', 'type': '[BusinessIdentity]'},
    }

    def __init__(
        self,
        *,
        business_identities: Optional[List["BusinessIdentity"]] = None,
        **kwargs
    ):
        super(B2BPartnerContent, self).__init__(**kwargs)
        self.business_identities = business_identities


class BatchConfiguration(Resource):
    """The batch configuration resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param properties: Required. The batch configuration properties.
    :type properties: ~azure.mgmt.logic.models.BatchConfigurationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'BatchConfigurationProperties'},
    }

    def __init__(
        self,
        *,
        properties: "BatchConfigurationProperties",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(BatchConfiguration, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class BatchConfigurationCollection(msrest.serialization.Model):
    """A collection of batch configurations.

    :param value:
    :type value: list[~azure.mgmt.logic.models.BatchConfiguration]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BatchConfiguration]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["BatchConfiguration"]] = None,
        **kwargs
    ):
        super(BatchConfigurationCollection, self).__init__(**kwargs)
        self.value = value


class BatchConfigurationProperties(ArtifactProperties):
    """The batch configuration properties definition.

    All required parameters must be populated in order to send to Azure.

    :param created_time: The artifact creation time.
    :type created_time: ~datetime.datetime
    :param changed_time: The artifact changed time.
    :type changed_time: ~datetime.datetime
    :param metadata: Any object.
    :type metadata: object
    :param batch_group_name: Required. The name of the batch group.
    :type batch_group_name: str
    :param release_criteria: Required. The batch release criteria.
    :type release_criteria: ~azure.mgmt.logic.models.BatchReleaseCriteria
    """

    _validation = {
        'batch_group_name': {'required': True},
        'release_criteria': {'required': True},
    }

    _attribute_map = {
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'batch_group_name': {'key': 'batchGroupName', 'type': 'str'},
        'release_criteria': {'key': 'releaseCriteria', 'type': 'BatchReleaseCriteria'},
    }

    def __init__(
        self,
        *,
        batch_group_name: str,
        release_criteria: "BatchReleaseCriteria",
        created_time: Optional[datetime.datetime] = None,
        changed_time: Optional[datetime.datetime] = None,
        metadata: Optional[object] = None,
        **kwargs
    ):
        super(BatchConfigurationProperties, self).__init__(created_time=created_time, changed_time=changed_time, metadata=metadata, **kwargs)
        self.batch_group_name = batch_group_name
        self.release_criteria = release_criteria


class BatchReleaseCriteria(msrest.serialization.Model):
    """The batch release criteria.

    :param message_count: The message count.
    :type message_count: int
    :param batch_size: The batch size in bytes.
    :type batch_size: int
    :param recurrence: The recurrence.
    :type recurrence: ~azure.mgmt.logic.models.WorkflowTriggerRecurrence
    """

    _attribute_map = {
        'message_count': {'key': 'messageCount', 'type': 'int'},
        'batch_size': {'key': 'batchSize', 'type': 'int'},
        'recurrence': {'key': 'recurrence', 'type': 'WorkflowTriggerRecurrence'},
    }

    def __init__(
        self,
        *,
        message_count: Optional[int] = None,
        batch_size: Optional[int] = None,
        recurrence: Optional["WorkflowTriggerRecurrence"] = None,
        **kwargs
    ):
        super(BatchReleaseCriteria, self).__init__(**kwargs)
        self.message_count = message_count
        self.batch_size = batch_size
        self.recurrence = recurrence


class BusinessIdentity(msrest.serialization.Model):
    """The integration account partner's business identity.

    All required parameters must be populated in order to send to Azure.

    :param qualifier: Required. The business identity qualifier e.g. as2identity, ZZ, ZZZ, 31, 32.
    :type qualifier: str
    :param value: Required. The user defined business identity value.
    :type value: str
    """

    _validation = {
        'qualifier': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'qualifier': {'key': 'qualifier', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        qualifier: str,
        value: str,
        **kwargs
    ):
        super(BusinessIdentity, self).__init__(**kwargs)
        self.qualifier = qualifier
        self.value = value


class CallbackUrl(msrest.serialization.Model):
    """The callback url.

    :param value: The URL value.
    :type value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        **kwargs
    ):
        super(CallbackUrl, self).__init__(**kwargs)
        self.value = value


class ContentHash(msrest.serialization.Model):
    """The content hash.

    :param algorithm: The algorithm of the content hash.
    :type algorithm: str
    :param value: The value of the content hash.
    :type value: str
    """

    _attribute_map = {
        'algorithm': {'key': 'algorithm', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        algorithm: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(ContentHash, self).__init__(**kwargs)
        self.algorithm = algorithm
        self.value = value


class ContentLink(msrest.serialization.Model):
    """The content link.

    :param uri: The content link URI.
    :type uri: str
    :param content_version: The content version.
    :type content_version: str
    :param content_size: The content size.
    :type content_size: long
    :param content_hash: The content hash.
    :type content_hash: ~azure.mgmt.logic.models.ContentHash
    :param metadata: The metadata.
    :type metadata: object
    """

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
        'content_version': {'key': 'contentVersion', 'type': 'str'},
        'content_size': {'key': 'contentSize', 'type': 'long'},
        'content_hash': {'key': 'contentHash', 'type': 'ContentHash'},
        'metadata': {'key': 'metadata', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        uri: Optional[str] = None,
        content_version: Optional[str] = None,
        content_size: Optional[int] = None,
        content_hash: Optional["ContentHash"] = None,
        metadata: Optional[object] = None,
        **kwargs
    ):
        super(ContentLink, self).__init__(**kwargs)
        self.uri = uri
        self.content_version = content_version
        self.content_size = content_size
        self.content_hash = content_hash
        self.metadata = metadata


class Correlation(msrest.serialization.Model):
    """The correlation property.

    :param client_tracking_id: The client tracking id.
    :type client_tracking_id: str
    """

    _attribute_map = {
        'client_tracking_id': {'key': 'clientTrackingId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_tracking_id: Optional[str] = None,
        **kwargs
    ):
        super(Correlation, self).__init__(**kwargs)
        self.client_tracking_id = client_tracking_id


class EdifactAcknowledgementSettings(msrest.serialization.Model):
    """The Edifact agreement acknowledgement settings.

    All required parameters must be populated in order to send to Azure.

    :param need_technical_acknowledgement: Required. The value indicating whether technical
     acknowledgement is needed.
    :type need_technical_acknowledgement: bool
    :param batch_technical_acknowledgements: Required. The value indicating whether to batch the
     technical acknowledgements.
    :type batch_technical_acknowledgements: bool
    :param need_functional_acknowledgement: Required. The value indicating whether functional
     acknowledgement is needed.
    :type need_functional_acknowledgement: bool
    :param batch_functional_acknowledgements: Required. The value indicating whether to batch
     functional acknowledgements.
    :type batch_functional_acknowledgements: bool
    :param need_loop_for_valid_messages: Required. The value indicating whether a loop is needed
     for valid messages.
    :type need_loop_for_valid_messages: bool
    :param send_synchronous_acknowledgement: Required. The value indicating whether to send
     synchronous acknowledgement.
    :type send_synchronous_acknowledgement: bool
    :param acknowledgement_control_number_prefix: The acknowledgement control number prefix.
    :type acknowledgement_control_number_prefix: str
    :param acknowledgement_control_number_suffix: The acknowledgement control number suffix.
    :type acknowledgement_control_number_suffix: str
    :param acknowledgement_control_number_lower_bound: Required. The acknowledgement control number
     lower bound.
    :type acknowledgement_control_number_lower_bound: int
    :param acknowledgement_control_number_upper_bound: Required. The acknowledgement control number
     upper bound.
    :type acknowledgement_control_number_upper_bound: int
    :param rollover_acknowledgement_control_number: Required. The value indicating whether to
     rollover acknowledgement control number.
    :type rollover_acknowledgement_control_number: bool
    """

    _validation = {
        'need_technical_acknowledgement': {'required': True},
        'batch_technical_acknowledgements': {'required': True},
        'need_functional_acknowledgement': {'required': True},
        'batch_functional_acknowledgements': {'required': True},
        'need_loop_for_valid_messages': {'required': True},
        'send_synchronous_acknowledgement': {'required': True},
        'acknowledgement_control_number_lower_bound': {'required': True},
        'acknowledgement_control_number_upper_bound': {'required': True},
        'rollover_acknowledgement_control_number': {'required': True},
    }

    _attribute_map = {
        'need_technical_acknowledgement': {'key': 'needTechnicalAcknowledgement', 'type': 'bool'},
        'batch_technical_acknowledgements': {'key': 'batchTechnicalAcknowledgements', 'type': 'bool'},
        'need_functional_acknowledgement': {'key': 'needFunctionalAcknowledgement', 'type': 'bool'},
        'batch_functional_acknowledgements': {'key': 'batchFunctionalAcknowledgements', 'type': 'bool'},
        'need_loop_for_valid_messages': {'key': 'needLoopForValidMessages', 'type': 'bool'},
        'send_synchronous_acknowledgement': {'key': 'sendSynchronousAcknowledgement', 'type': 'bool'},
        'acknowledgement_control_number_prefix': {'key': 'acknowledgementControlNumberPrefix', 'type': 'str'},
        'acknowledgement_control_number_suffix': {'key': 'acknowledgementControlNumberSuffix', 'type': 'str'},
        'acknowledgement_control_number_lower_bound': {'key': 'acknowledgementControlNumberLowerBound', 'type': 'int'},
        'acknowledgement_control_number_upper_bound': {'key': 'acknowledgementControlNumberUpperBound', 'type': 'int'},
        'rollover_acknowledgement_control_number': {'key': 'rolloverAcknowledgementControlNumber', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        need_technical_acknowledgement: bool,
        batch_technical_acknowledgements: bool,
        need_functional_acknowledgement: bool,
        batch_functional_acknowledgements: bool,
        need_loop_for_valid_messages: bool,
        send_synchronous_acknowledgement: bool,
        acknowledgement_control_number_lower_bound: int,
        acknowledgement_control_number_upper_bound: int,
        rollover_acknowledgement_control_number: bool,
        acknowledgement_control_number_prefix: Optional[str] = None,
        acknowledgement_control_number_suffix: Optional[str] = None,
        **kwargs
    ):
        super(EdifactAcknowledgementSettings, self).__init__(**kwargs)
        self.need_technical_acknowledgement = need_technical_acknowledgement
        self.batch_technical_acknowledgements = batch_technical_acknowledgements
        self.need_functional_acknowledgement = need_functional_acknowledgement
        self.batch_functional_acknowledgements = batch_functional_acknowledgements
        self.need_loop_for_valid_messages = need_loop_for_valid_messages
        self.send_synchronous_acknowledgement = send_synchronous_acknowledgement
        self.acknowledgement_control_number_prefix = acknowledgement_control_number_prefix
        self.acknowledgement_control_number_suffix = acknowledgement_control_number_suffix
        self.acknowledgement_control_number_lower_bound = acknowledgement_control_number_lower_bound
        self.acknowledgement_control_number_upper_bound = acknowledgement_control_number_upper_bound
        self.rollover_acknowledgement_control_number = rollover_acknowledgement_control_number


class EdifactAgreementContent(msrest.serialization.Model):
    """The Edifact agreement content.

    All required parameters must be populated in order to send to Azure.

    :param receive_agreement: Required. The EDIFACT one-way receive agreement.
    :type receive_agreement: ~azure.mgmt.logic.models.EdifactOneWayAgreement
    :param send_agreement: Required. The EDIFACT one-way send agreement.
    :type send_agreement: ~azure.mgmt.logic.models.EdifactOneWayAgreement
    """

    _validation = {
        'receive_agreement': {'required': True},
        'send_agreement': {'required': True},
    }

    _attribute_map = {
        'receive_agreement': {'key': 'receiveAgreement', 'type': 'EdifactOneWayAgreement'},
        'send_agreement': {'key': 'sendAgreement', 'type': 'EdifactOneWayAgreement'},
    }

    def __init__(
        self,
        *,
        receive_agreement: "EdifactOneWayAgreement",
        send_agreement: "EdifactOneWayAgreement",
        **kwargs
    ):
        super(EdifactAgreementContent, self).__init__(**kwargs)
        self.receive_agreement = receive_agreement
        self.send_agreement = send_agreement


class EdifactDelimiterOverride(msrest.serialization.Model):
    """The Edifact delimiter override settings.

    All required parameters must be populated in order to send to Azure.

    :param message_id: The message id.
    :type message_id: str
    :param message_version: The message version.
    :type message_version: str
    :param message_release: The message release.
    :type message_release: str
    :param data_element_separator: Required. The data element separator.
    :type data_element_separator: int
    :param component_separator: Required. The component separator.
    :type component_separator: int
    :param segment_terminator: Required. The segment terminator.
    :type segment_terminator: int
    :param repetition_separator: Required. The repetition separator.
    :type repetition_separator: int
    :param segment_terminator_suffix: Required. The segment terminator suffix. Possible values
     include: "NotSpecified", "None", "CR", "LF", "CRLF".
    :type segment_terminator_suffix: str or ~azure.mgmt.logic.models.SegmentTerminatorSuffix
    :param decimal_point_indicator: Required. The decimal point indicator. Possible values include:
     "NotSpecified", "Comma", "Decimal".
    :type decimal_point_indicator: str or ~azure.mgmt.logic.models.EdifactDecimalIndicator
    :param release_indicator: Required. The release indicator.
    :type release_indicator: int
    :param message_association_assigned_code: The message association assigned code.
    :type message_association_assigned_code: str
    :param target_namespace: The target namespace on which this delimiter settings has to be
     applied.
    :type target_namespace: str
    """

    _validation = {
        'data_element_separator': {'required': True},
        'component_separator': {'required': True},
        'segment_terminator': {'required': True},
        'repetition_separator': {'required': True},
        'segment_terminator_suffix': {'required': True},
        'decimal_point_indicator': {'required': True},
        'release_indicator': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'message_version': {'key': 'messageVersion', 'type': 'str'},
        'message_release': {'key': 'messageRelease', 'type': 'str'},
        'data_element_separator': {'key': 'dataElementSeparator', 'type': 'int'},
        'component_separator': {'key': 'componentSeparator', 'type': 'int'},
        'segment_terminator': {'key': 'segmentTerminator', 'type': 'int'},
        'repetition_separator': {'key': 'repetitionSeparator', 'type': 'int'},
        'segment_terminator_suffix': {'key': 'segmentTerminatorSuffix', 'type': 'str'},
        'decimal_point_indicator': {'key': 'decimalPointIndicator', 'type': 'str'},
        'release_indicator': {'key': 'releaseIndicator', 'type': 'int'},
        'message_association_assigned_code': {'key': 'messageAssociationAssignedCode', 'type': 'str'},
        'target_namespace': {'key': 'targetNamespace', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_element_separator: int,
        component_separator: int,
        segment_terminator: int,
        repetition_separator: int,
        segment_terminator_suffix: Union[str, "SegmentTerminatorSuffix"],
        decimal_point_indicator: Union[str, "EdifactDecimalIndicator"],
        release_indicator: int,
        message_id: Optional[str] = None,
        message_version: Optional[str] = None,
        message_release: Optional[str] = None,
        message_association_assigned_code: Optional[str] = None,
        target_namespace: Optional[str] = None,
        **kwargs
    ):
        super(EdifactDelimiterOverride, self).__init__(**kwargs)
        self.message_id = message_id
        self.message_version = message_version
        self.message_release = message_release
        self.data_element_separator = data_element_separator
        self.component_separator = component_separator
        self.segment_terminator = segment_terminator
        self.repetition_separator = repetition_separator
        self.segment_terminator_suffix = segment_terminator_suffix
        self.decimal_point_indicator = decimal_point_indicator
        self.release_indicator = release_indicator
        self.message_association_assigned_code = message_association_assigned_code
        self.target_namespace = target_namespace


class EdifactEnvelopeOverride(msrest.serialization.Model):
    """The Edifact envelope override settings.

    :param message_id: The message id on which this envelope settings has to be applied.
    :type message_id: str
    :param message_version: The message version on which this envelope settings has to be applied.
    :type message_version: str
    :param message_release: The message release version on which this envelope settings has to be
     applied.
    :type message_release: str
    :param message_association_assigned_code: The message association assigned code.
    :type message_association_assigned_code: str
    :param target_namespace: The target namespace on which this envelope settings has to be
     applied.
    :type target_namespace: str
    :param functional_group_id: The functional group id.
    :type functional_group_id: str
    :param sender_application_qualifier: The sender application qualifier.
    :type sender_application_qualifier: str
    :param sender_application_id: The sender application id.
    :type sender_application_id: str
    :param receiver_application_qualifier: The receiver application qualifier.
    :type receiver_application_qualifier: str
    :param receiver_application_id: The receiver application id.
    :type receiver_application_id: str
    :param controlling_agency_code: The controlling agency code.
    :type controlling_agency_code: str
    :param group_header_message_version: The group header message version.
    :type group_header_message_version: str
    :param group_header_message_release: The group header message release.
    :type group_header_message_release: str
    :param association_assigned_code: The association assigned code.
    :type association_assigned_code: str
    :param application_password: The application password.
    :type application_password: str
    """

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'message_version': {'key': 'messageVersion', 'type': 'str'},
        'message_release': {'key': 'messageRelease', 'type': 'str'},
        'message_association_assigned_code': {'key': 'messageAssociationAssignedCode', 'type': 'str'},
        'target_namespace': {'key': 'targetNamespace', 'type': 'str'},
        'functional_group_id': {'key': 'functionalGroupId', 'type': 'str'},
        'sender_application_qualifier': {'key': 'senderApplicationQualifier', 'type': 'str'},
        'sender_application_id': {'key': 'senderApplicationId', 'type': 'str'},
        'receiver_application_qualifier': {'key': 'receiverApplicationQualifier', 'type': 'str'},
        'receiver_application_id': {'key': 'receiverApplicationId', 'type': 'str'},
        'controlling_agency_code': {'key': 'controllingAgencyCode', 'type': 'str'},
        'group_header_message_version': {'key': 'groupHeaderMessageVersion', 'type': 'str'},
        'group_header_message_release': {'key': 'groupHeaderMessageRelease', 'type': 'str'},
        'association_assigned_code': {'key': 'associationAssignedCode', 'type': 'str'},
        'application_password': {'key': 'applicationPassword', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_id: Optional[str] = None,
        message_version: Optional[str] = None,
        message_release: Optional[str] = None,
        message_association_assigned_code: Optional[str] = None,
        target_namespace: Optional[str] = None,
        functional_group_id: Optional[str] = None,
        sender_application_qualifier: Optional[str] = None,
        sender_application_id: Optional[str] = None,
        receiver_application_qualifier: Optional[str] = None,
        receiver_application_id: Optional[str] = None,
        controlling_agency_code: Optional[str] = None,
        group_header_message_version: Optional[str] = None,
        group_header_message_release: Optional[str] = None,
        association_assigned_code: Optional[str] = None,
        application_password: Optional[str] = None,
        **kwargs
    ):
        super(EdifactEnvelopeOverride, self).__init__(**kwargs)
        self.message_id = message_id
        self.message_version = message_version
        self.message_release = message_release
        self.message_association_assigned_code = message_association_assigned_code
        self.target_namespace = target_namespace
        self.functional_group_id = functional_group_id
        self.sender_application_qualifier = sender_application_qualifier
        self.sender_application_id = sender_application_id
        self.receiver_application_qualifier = receiver_application_qualifier
        self.receiver_application_id = receiver_application_id
        self.controlling_agency_code = controlling_agency_code
        self.group_header_message_version = group_header_message_version
        self.group_header_message_release = group_header_message_release
        self.association_assigned_code = association_assigned_code
        self.application_password = application_password


class EdifactEnvelopeSettings(msrest.serialization.Model):
    """The Edifact agreement envelope settings.

    All required parameters must be populated in order to send to Azure.

    :param group_association_assigned_code: The group association assigned code.
    :type group_association_assigned_code: str
    :param communication_agreement_id: The communication agreement id.
    :type communication_agreement_id: str
    :param apply_delimiter_string_advice: Required. The value indicating whether to apply delimiter
     string advice.
    :type apply_delimiter_string_advice: bool
    :param create_grouping_segments: Required. The value indicating whether to create grouping
     segments.
    :type create_grouping_segments: bool
    :param enable_default_group_headers: Required. The value indicating whether to enable default
     group headers.
    :type enable_default_group_headers: bool
    :param recipient_reference_password_value: The recipient reference password value.
    :type recipient_reference_password_value: str
    :param recipient_reference_password_qualifier: The recipient reference password qualifier.
    :type recipient_reference_password_qualifier: str
    :param application_reference_id: The application reference id.
    :type application_reference_id: str
    :param processing_priority_code: The processing priority code.
    :type processing_priority_code: str
    :param interchange_control_number_lower_bound: Required. The interchange control number lower
     bound.
    :type interchange_control_number_lower_bound: long
    :param interchange_control_number_upper_bound: Required. The interchange control number upper
     bound.
    :type interchange_control_number_upper_bound: long
    :param rollover_interchange_control_number: Required. The value indicating whether to rollover
     interchange control number.
    :type rollover_interchange_control_number: bool
    :param interchange_control_number_prefix: The interchange control number prefix.
    :type interchange_control_number_prefix: str
    :param interchange_control_number_suffix: The interchange control number suffix.
    :type interchange_control_number_suffix: str
    :param sender_reverse_routing_address: The sender reverse routing address.
    :type sender_reverse_routing_address: str
    :param receiver_reverse_routing_address: The receiver reverse routing address.
    :type receiver_reverse_routing_address: str
    :param functional_group_id: The functional group id.
    :type functional_group_id: str
    :param group_controlling_agency_code: The group controlling agency code.
    :type group_controlling_agency_code: str
    :param group_message_version: The group message version.
    :type group_message_version: str
    :param group_message_release: The group message release.
    :type group_message_release: str
    :param group_control_number_lower_bound: Required. The group control number lower bound.
    :type group_control_number_lower_bound: long
    :param group_control_number_upper_bound: Required. The group control number upper bound.
    :type group_control_number_upper_bound: long
    :param rollover_group_control_number: Required. The value indicating whether to rollover group
     control number.
    :type rollover_group_control_number: bool
    :param group_control_number_prefix: The group control number prefix.
    :type group_control_number_prefix: str
    :param group_control_number_suffix: The group control number suffix.
    :type group_control_number_suffix: str
    :param group_application_receiver_qualifier: The group application receiver qualifier.
    :type group_application_receiver_qualifier: str
    :param group_application_receiver_id: The group application receiver id.
    :type group_application_receiver_id: str
    :param group_application_sender_qualifier: The group application sender qualifier.
    :type group_application_sender_qualifier: str
    :param group_application_sender_id: The group application sender id.
    :type group_application_sender_id: str
    :param group_application_password: The group application password.
    :type group_application_password: str
    :param overwrite_existing_transaction_set_control_number: Required. The value indicating
     whether to overwrite existing transaction set control number.
    :type overwrite_existing_transaction_set_control_number: bool
    :param transaction_set_control_number_prefix: The transaction set control number prefix.
    :type transaction_set_control_number_prefix: str
    :param transaction_set_control_number_suffix: The transaction set control number suffix.
    :type transaction_set_control_number_suffix: str
    :param transaction_set_control_number_lower_bound: Required. The transaction set control number
     lower bound.
    :type transaction_set_control_number_lower_bound: long
    :param transaction_set_control_number_upper_bound: Required. The transaction set control number
     upper bound.
    :type transaction_set_control_number_upper_bound: long
    :param rollover_transaction_set_control_number: Required. The value indicating whether to
     rollover transaction set control number.
    :type rollover_transaction_set_control_number: bool
    :param is_test_interchange: Required. The value indicating whether the message is a test
     interchange.
    :type is_test_interchange: bool
    :param sender_internal_identification: The sender internal identification.
    :type sender_internal_identification: str
    :param sender_internal_sub_identification: The sender internal sub identification.
    :type sender_internal_sub_identification: str
    :param receiver_internal_identification: The receiver internal identification.
    :type receiver_internal_identification: str
    :param receiver_internal_sub_identification: The receiver internal sub identification.
    :type receiver_internal_sub_identification: str
    """

    _validation = {
        'apply_delimiter_string_advice': {'required': True},
        'create_grouping_segments': {'required': True},
        'enable_default_group_headers': {'required': True},
        'interchange_control_number_lower_bound': {'required': True},
        'interchange_control_number_upper_bound': {'required': True},
        'rollover_interchange_control_number': {'required': True},
        'group_control_number_lower_bound': {'required': True},
        'group_control_number_upper_bound': {'required': True},
        'rollover_group_control_number': {'required': True},
        'overwrite_existing_transaction_set_control_number': {'required': True},
        'transaction_set_control_number_lower_bound': {'required': True},
        'transaction_set_control_number_upper_bound': {'required': True},
        'rollover_transaction_set_control_number': {'required': True},
        'is_test_interchange': {'required': True},
    }

    _attribute_map = {
        'group_association_assigned_code': {'key': 'groupAssociationAssignedCode', 'type': 'str'},
        'communication_agreement_id': {'key': 'communicationAgreementId', 'type': 'str'},
        'apply_delimiter_string_advice': {'key': 'applyDelimiterStringAdvice', 'type': 'bool'},
        'create_grouping_segments': {'key': 'createGroupingSegments', 'type': 'bool'},
        'enable_default_group_headers': {'key': 'enableDefaultGroupHeaders', 'type': 'bool'},
        'recipient_reference_password_value': {'key': 'recipientReferencePasswordValue', 'type': 'str'},
        'recipient_reference_password_qualifier': {'key': 'recipientReferencePasswordQualifier', 'type': 'str'},
        'application_reference_id': {'key': 'applicationReferenceId', 'type': 'str'},
        'processing_priority_code': {'key': 'processingPriorityCode', 'type': 'str'},
        'interchange_control_number_lower_bound': {'key': 'interchangeControlNumberLowerBound', 'type': 'long'},
        'interchange_control_number_upper_bound': {'key': 'interchangeControlNumberUpperBound', 'type': 'long'},
        'rollover_interchange_control_number': {'key': 'rolloverInterchangeControlNumber', 'type': 'bool'},
        'interchange_control_number_prefix': {'key': 'interchangeControlNumberPrefix', 'type': 'str'},
        'interchange_control_number_suffix': {'key': 'interchangeControlNumberSuffix', 'type': 'str'},
        'sender_reverse_routing_address': {'key': 'senderReverseRoutingAddress', 'type': 'str'},
        'receiver_reverse_routing_address': {'key': 'receiverReverseRoutingAddress', 'type': 'str'},
        'functional_group_id': {'key': 'functionalGroupId', 'type': 'str'},
        'group_controlling_agency_code': {'key': 'groupControllingAgencyCode', 'type': 'str'},
        'group_message_version': {'key': 'groupMessageVersion', 'type': 'str'},
        'group_message_release': {'key': 'groupMessageRelease', 'type': 'str'},
        'group_control_number_lower_bound': {'key': 'groupControlNumberLowerBound', 'type': 'long'},
        'group_control_number_upper_bound': {'key': 'groupControlNumberUpperBound', 'type': 'long'},
        'rollover_group_control_number': {'key': 'rolloverGroupControlNumber', 'type': 'bool'},
        'group_control_number_prefix': {'key': 'groupControlNumberPrefix', 'type': 'str'},
        'group_control_number_suffix': {'key': 'groupControlNumberSuffix', 'type': 'str'},
        'group_application_receiver_qualifier': {'key': 'groupApplicationReceiverQualifier', 'type': 'str'},
        'group_application_receiver_id': {'key': 'groupApplicationReceiverId', 'type': 'str'},
        'group_application_sender_qualifier': {'key': 'groupApplicationSenderQualifier', 'type': 'str'},
        'group_application_sender_id': {'key': 'groupApplicationSenderId', 'type': 'str'},
        'group_application_password': {'key': 'groupApplicationPassword', 'type': 'str'},
        'overwrite_existing_transaction_set_control_number': {'key': 'overwriteExistingTransactionSetControlNumber', 'type': 'bool'},
        'transaction_set_control_number_prefix': {'key': 'transactionSetControlNumberPrefix', 'type': 'str'},
        'transaction_set_control_number_suffix': {'key': 'transactionSetControlNumberSuffix', 'type': 'str'},
        'transaction_set_control_number_lower_bound': {'key': 'transactionSetControlNumberLowerBound', 'type': 'long'},
        'transaction_set_control_number_upper_bound': {'key': 'transactionSetControlNumberUpperBound', 'type': 'long'},
        'rollover_transaction_set_control_number': {'key': 'rolloverTransactionSetControlNumber', 'type': 'bool'},
        'is_test_interchange': {'key': 'isTestInterchange', 'type': 'bool'},
        'sender_internal_identification': {'key': 'senderInternalIdentification', 'type': 'str'},
        'sender_internal_sub_identification': {'key': 'senderInternalSubIdentification', 'type': 'str'},
        'receiver_internal_identification': {'key': 'receiverInternalIdentification', 'type': 'str'},
        'receiver_internal_sub_identification': {'key': 'receiverInternalSubIdentification', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        apply_delimiter_string_advice: bool,
        create_grouping_segments: bool,
        enable_default_group_headers: bool,
        interchange_control_number_lower_bound: int,
        interchange_control_number_upper_bound: int,
        rollover_interchange_control_number: bool,
        group_control_number_lower_bound: int,
        group_control_number_upper_bound: int,
        rollover_group_control_number: bool,
        overwrite_existing_transaction_set_control_number: bool,
        transaction_set_control_number_lower_bound: int,
        transaction_set_control_number_upper_bound: int,
        rollover_transaction_set_control_number: bool,
        is_test_interchange: bool,
        group_association_assigned_code: Optional[str] = None,
        communication_agreement_id: Optional[str] = None,
        recipient_reference_password_value: Optional[str] = None,
        recipient_reference_password_qualifier: Optional[str] = None,
        application_reference_id: Optional[str] = None,
        processing_priority_code: Optional[str] = None,
        interchange_control_number_prefix: Optional[str] = None,
        interchange_control_number_suffix: Optional[str] = None,
        sender_reverse_routing_address: Optional[str] = None,
        receiver_reverse_routing_address: Optional[str] = None,
        functional_group_id: Optional[str] = None,
        group_controlling_agency_code: Optional[str] = None,
        group_message_version: Optional[str] = None,
        group_message_release: Optional[str] = None,
        group_control_number_prefix: Optional[str] = None,
        group_control_number_suffix: Optional[str] = None,
        group_application_receiver_qualifier: Optional[str] = None,
        group_application_receiver_id: Optional[str] = None,
        group_application_sender_qualifier: Optional[str] = None,
        group_application_sender_id: Optional[str] = None,
        group_application_password: Optional[str] = None,
        transaction_set_control_number_prefix: Optional[str] = None,
        transaction_set_control_number_suffix: Optional[str] = None,
        sender_internal_identification: Optional[str] = None,
        sender_internal_sub_identification: Optional[str] = None,
        receiver_internal_identification: Optional[str] = None,
        receiver_internal_sub_identification: Optional[str] = None,
        **kwargs
    ):
        super(EdifactEnvelopeSettings, self).__init__(**kwargs)
        self.group_association_assigned_code = group_association_assigned_code
        self.communication_agreement_id = communication_agreement_id
        self.apply_delimiter_string_advice = apply_delimiter_string_advice
        self.create_grouping_segments = create_grouping_segments
        self.enable_default_group_headers = enable_default_group_headers
        self.recipient_reference_password_value = recipient_reference_password_value
        self.recipient_reference_password_qualifier = recipient_reference_password_qualifier
        self.application_reference_id = application_reference_id
        self.processing_priority_code = processing_priority_code
        self.interchange_control_number_lower_bound = interchange_control_number_lower_bound
        self.interchange_control_number_upper_bound = interchange_control_number_upper_bound
        self.rollover_interchange_control_number = rollover_interchange_control_number
        self.interchange_control_number_prefix = interchange_control_number_prefix
        self.interchange_control_number_suffix = interchange_control_number_suffix
        self.sender_reverse_routing_address = sender_reverse_routing_address
        self.receiver_reverse_routing_address = receiver_reverse_routing_address
        self.functional_group_id = functional_group_id
        self.group_controlling_agency_code = group_controlling_agency_code
        self.group_message_version = group_message_version
        self.group_message_release = group_message_release
        self.group_control_number_lower_bound = group_control_number_lower_bound
        self.group_control_number_upper_bound = group_control_number_upper_bound
        self.rollover_group_control_number = rollover_group_control_number
        self.group_control_number_prefix = group_control_number_prefix
        self.group_control_number_suffix = group_control_number_suffix
        self.group_application_receiver_qualifier = group_application_receiver_qualifier
        self.group_application_receiver_id = group_application_receiver_id
        self.group_application_sender_qualifier = group_application_sender_qualifier
        self.group_application_sender_id = group_application_sender_id
        self.group_application_password = group_application_password
        self.overwrite_existing_transaction_set_control_number = overwrite_existing_transaction_set_control_number
        self.transaction_set_control_number_prefix = transaction_set_control_number_prefix
        self.transaction_set_control_number_suffix = transaction_set_control_number_suffix
        self.transaction_set_control_number_lower_bound = transaction_set_control_number_lower_bound
        self.transaction_set_control_number_upper_bound = transaction_set_control_number_upper_bound
        self.rollover_transaction_set_control_number = rollover_transaction_set_control_number
        self.is_test_interchange = is_test_interchange
        self.sender_internal_identification = sender_internal_identification
        self.sender_internal_sub_identification = sender_internal_sub_identification
        self.receiver_internal_identification = receiver_internal_identification
        self.receiver_internal_sub_identification = receiver_internal_sub_identification


class EdifactFramingSettings(msrest.serialization.Model):
    """The Edifact agreement framing settings.

    All required parameters must be populated in order to send to Azure.

    :param service_code_list_directory_version: The service code list directory version.
    :type service_code_list_directory_version: str
    :param character_encoding: The character encoding.
    :type character_encoding: str
    :param protocol_version: Required. The protocol version.
    :type protocol_version: int
    :param data_element_separator: Required. The data element separator.
    :type data_element_separator: int
    :param component_separator: Required. The component separator.
    :type component_separator: int
    :param segment_terminator: Required. The segment terminator.
    :type segment_terminator: int
    :param release_indicator: Required. The release indicator.
    :type release_indicator: int
    :param repetition_separator: Required. The repetition separator.
    :type repetition_separator: int
    :param character_set: Required. The EDIFACT frame setting characterSet. Possible values
     include: "NotSpecified", "UNOB", "UNOA", "UNOC", "UNOD", "UNOE", "UNOF", "UNOG", "UNOH",
     "UNOI", "UNOJ", "UNOK", "UNOX", "UNOY", "KECA".
    :type character_set: str or ~azure.mgmt.logic.models.EdifactCharacterSet
    :param decimal_point_indicator: Required. The EDIFACT frame setting decimal indicator. Possible
     values include: "NotSpecified", "Comma", "Decimal".
    :type decimal_point_indicator: str or ~azure.mgmt.logic.models.EdifactDecimalIndicator
    :param segment_terminator_suffix: Required. The EDIFACT frame setting segment terminator
     suffix. Possible values include: "NotSpecified", "None", "CR", "LF", "CRLF".
    :type segment_terminator_suffix: str or ~azure.mgmt.logic.models.SegmentTerminatorSuffix
    """

    _validation = {
        'protocol_version': {'required': True},
        'data_element_separator': {'required': True},
        'component_separator': {'required': True},
        'segment_terminator': {'required': True},
        'release_indicator': {'required': True},
        'repetition_separator': {'required': True},
        'character_set': {'required': True},
        'decimal_point_indicator': {'required': True},
        'segment_terminator_suffix': {'required': True},
    }

    _attribute_map = {
        'service_code_list_directory_version': {'key': 'serviceCodeListDirectoryVersion', 'type': 'str'},
        'character_encoding': {'key': 'characterEncoding', 'type': 'str'},
        'protocol_version': {'key': 'protocolVersion', 'type': 'int'},
        'data_element_separator': {'key': 'dataElementSeparator', 'type': 'int'},
        'component_separator': {'key': 'componentSeparator', 'type': 'int'},
        'segment_terminator': {'key': 'segmentTerminator', 'type': 'int'},
        'release_indicator': {'key': 'releaseIndicator', 'type': 'int'},
        'repetition_separator': {'key': 'repetitionSeparator', 'type': 'int'},
        'character_set': {'key': 'characterSet', 'type': 'str'},
        'decimal_point_indicator': {'key': 'decimalPointIndicator', 'type': 'str'},
        'segment_terminator_suffix': {'key': 'segmentTerminatorSuffix', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        protocol_version: int,
        data_element_separator: int,
        component_separator: int,
        segment_terminator: int,
        release_indicator: int,
        repetition_separator: int,
        character_set: Union[str, "EdifactCharacterSet"],
        decimal_point_indicator: Union[str, "EdifactDecimalIndicator"],
        segment_terminator_suffix: Union[str, "SegmentTerminatorSuffix"],
        service_code_list_directory_version: Optional[str] = None,
        character_encoding: Optional[str] = None,
        **kwargs
    ):
        super(EdifactFramingSettings, self).__init__(**kwargs)
        self.service_code_list_directory_version = service_code_list_directory_version
        self.character_encoding = character_encoding
        self.protocol_version = protocol_version
        self.data_element_separator = data_element_separator
        self.component_separator = component_separator
        self.segment_terminator = segment_terminator
        self.release_indicator = release_indicator
        self.repetition_separator = repetition_separator
        self.character_set = character_set
        self.decimal_point_indicator = decimal_point_indicator
        self.segment_terminator_suffix = segment_terminator_suffix


class EdifactMessageFilter(msrest.serialization.Model):
    """The Edifact message filter for odata query.

    All required parameters must be populated in order to send to Azure.

    :param message_filter_type: Required. The message filter type. Possible values include:
     "NotSpecified", "Include", "Exclude".
    :type message_filter_type: str or ~azure.mgmt.logic.models.MessageFilterType
    """

    _validation = {
        'message_filter_type': {'required': True},
    }

    _attribute_map = {
        'message_filter_type': {'key': 'messageFilterType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_filter_type: Union[str, "MessageFilterType"],
        **kwargs
    ):
        super(EdifactMessageFilter, self).__init__(**kwargs)
        self.message_filter_type = message_filter_type


class EdifactMessageIdentifier(msrest.serialization.Model):
    """The Edifact message identifier.

    All required parameters must be populated in order to send to Azure.

    :param message_id: Required. The message id on which this envelope settings has to be applied.
    :type message_id: str
    """

    _validation = {
        'message_id': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_id: str,
        **kwargs
    ):
        super(EdifactMessageIdentifier, self).__init__(**kwargs)
        self.message_id = message_id


class EdifactOneWayAgreement(msrest.serialization.Model):
    """The Edifact one way agreement.

    All required parameters must be populated in order to send to Azure.

    :param sender_business_identity: Required. The sender business identity.
    :type sender_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :param receiver_business_identity: Required. The receiver business identity.
    :type receiver_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :param protocol_settings: Required. The EDIFACT protocol settings.
    :type protocol_settings: ~azure.mgmt.logic.models.EdifactProtocolSettings
    """

    _validation = {
        'sender_business_identity': {'required': True},
        'receiver_business_identity': {'required': True},
        'protocol_settings': {'required': True},
    }

    _attribute_map = {
        'sender_business_identity': {'key': 'senderBusinessIdentity', 'type': 'BusinessIdentity'},
        'receiver_business_identity': {'key': 'receiverBusinessIdentity', 'type': 'BusinessIdentity'},
        'protocol_settings': {'key': 'protocolSettings', 'type': 'EdifactProtocolSettings'},
    }

    def __init__(
        self,
        *,
        sender_business_identity: "BusinessIdentity",
        receiver_business_identity: "BusinessIdentity",
        protocol_settings: "EdifactProtocolSettings",
        **kwargs
    ):
        super(EdifactOneWayAgreement, self).__init__(**kwargs)
        self.sender_business_identity = sender_business_identity
        self.receiver_business_identity = receiver_business_identity
        self.protocol_settings = protocol_settings


class EdifactProcessingSettings(msrest.serialization.Model):
    """The Edifact agreement protocol settings.

    All required parameters must be populated in order to send to Azure.

    :param mask_security_info: Required. The value indicating whether to mask security information.
    :type mask_security_info: bool
    :param preserve_interchange: Required. The value indicating whether to preserve interchange.
    :type preserve_interchange: bool
    :param suspend_interchange_on_error: Required. The value indicating whether to suspend
     interchange on error.
    :type suspend_interchange_on_error: bool
    :param create_empty_xml_tags_for_trailing_separators: Required. The value indicating whether to
     create empty xml tags for trailing separators.
    :type create_empty_xml_tags_for_trailing_separators: bool
    :param use_dot_as_decimal_separator: Required. The value indicating whether to use dot as
     decimal separator.
    :type use_dot_as_decimal_separator: bool
    """

    _validation = {
        'mask_security_info': {'required': True},
        'preserve_interchange': {'required': True},
        'suspend_interchange_on_error': {'required': True},
        'create_empty_xml_tags_for_trailing_separators': {'required': True},
        'use_dot_as_decimal_separator': {'required': True},
    }

    _attribute_map = {
        'mask_security_info': {'key': 'maskSecurityInfo', 'type': 'bool'},
        'preserve_interchange': {'key': 'preserveInterchange', 'type': 'bool'},
        'suspend_interchange_on_error': {'key': 'suspendInterchangeOnError', 'type': 'bool'},
        'create_empty_xml_tags_for_trailing_separators': {'key': 'createEmptyXmlTagsForTrailingSeparators', 'type': 'bool'},
        'use_dot_as_decimal_separator': {'key': 'useDotAsDecimalSeparator', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        mask_security_info: bool,
        preserve_interchange: bool,
        suspend_interchange_on_error: bool,
        create_empty_xml_tags_for_trailing_separators: bool,
        use_dot_as_decimal_separator: bool,
        **kwargs
    ):
        super(EdifactProcessingSettings, self).__init__(**kwargs)
        self.mask_security_info = mask_security_info
        self.preserve_interchange = preserve_interchange
        self.suspend_interchange_on_error = suspend_interchange_on_error
        self.create_empty_xml_tags_for_trailing_separators = create_empty_xml_tags_for_trailing_separators
        self.use_dot_as_decimal_separator = use_dot_as_decimal_separator


class EdifactProtocolSettings(msrest.serialization.Model):
    """The Edifact agreement protocol settings.

    All required parameters must be populated in order to send to Azure.

    :param validation_settings: Required. The EDIFACT validation settings.
    :type validation_settings: ~azure.mgmt.logic.models.EdifactValidationSettings
    :param framing_settings: Required. The EDIFACT framing settings.
    :type framing_settings: ~azure.mgmt.logic.models.EdifactFramingSettings
    :param envelope_settings: Required. The EDIFACT envelope settings.
    :type envelope_settings: ~azure.mgmt.logic.models.EdifactEnvelopeSettings
    :param acknowledgement_settings: Required. The EDIFACT acknowledgement settings.
    :type acknowledgement_settings: ~azure.mgmt.logic.models.EdifactAcknowledgementSettings
    :param message_filter: Required. The EDIFACT message filter.
    :type message_filter: ~azure.mgmt.logic.models.EdifactMessageFilter
    :param processing_settings: Required. The EDIFACT processing Settings.
    :type processing_settings: ~azure.mgmt.logic.models.EdifactProcessingSettings
    :param envelope_overrides: The EDIFACT envelope override settings.
    :type envelope_overrides: list[~azure.mgmt.logic.models.EdifactEnvelopeOverride]
    :param message_filter_list: The EDIFACT message filter list.
    :type message_filter_list: list[~azure.mgmt.logic.models.EdifactMessageIdentifier]
    :param schema_references: Required. The EDIFACT schema references.
    :type schema_references: list[~azure.mgmt.logic.models.EdifactSchemaReference]
    :param validation_overrides: The EDIFACT validation override settings.
    :type validation_overrides: list[~azure.mgmt.logic.models.EdifactValidationOverride]
    :param edifact_delimiter_overrides: The EDIFACT delimiter override settings.
    :type edifact_delimiter_overrides: list[~azure.mgmt.logic.models.EdifactDelimiterOverride]
    """

    _validation = {
        'validation_settings': {'required': True},
        'framing_settings': {'required': True},
        'envelope_settings': {'required': True},
        'acknowledgement_settings': {'required': True},
        'message_filter': {'required': True},
        'processing_settings': {'required': True},
        'schema_references': {'required': True},
    }

    _attribute_map = {
        'validation_settings': {'key': 'validationSettings', 'type': 'EdifactValidationSettings'},
        'framing_settings': {'key': 'framingSettings', 'type': 'EdifactFramingSettings'},
        'envelope_settings': {'key': 'envelopeSettings', 'type': 'EdifactEnvelopeSettings'},
        'acknowledgement_settings': {'key': 'acknowledgementSettings', 'type': 'EdifactAcknowledgementSettings'},
        'message_filter': {'key': 'messageFilter', 'type': 'EdifactMessageFilter'},
        'processing_settings': {'key': 'processingSettings', 'type': 'EdifactProcessingSettings'},
        'envelope_overrides': {'key': 'envelopeOverrides', 'type': '[EdifactEnvelopeOverride]'},
        'message_filter_list': {'key': 'messageFilterList', 'type': '[EdifactMessageIdentifier]'},
        'schema_references': {'key': 'schemaReferences', 'type': '[EdifactSchemaReference]'},
        'validation_overrides': {'key': 'validationOverrides', 'type': '[EdifactValidationOverride]'},
        'edifact_delimiter_overrides': {'key': 'edifactDelimiterOverrides', 'type': '[EdifactDelimiterOverride]'},
    }

    def __init__(
        self,
        *,
        validation_settings: "EdifactValidationSettings",
        framing_settings: "EdifactFramingSettings",
        envelope_settings: "EdifactEnvelopeSettings",
        acknowledgement_settings: "EdifactAcknowledgementSettings",
        message_filter: "EdifactMessageFilter",
        processing_settings: "EdifactProcessingSettings",
        schema_references: List["EdifactSchemaReference"],
        envelope_overrides: Optional[List["EdifactEnvelopeOverride"]] = None,
        message_filter_list: Optional[List["EdifactMessageIdentifier"]] = None,
        validation_overrides: Optional[List["EdifactValidationOverride"]] = None,
        edifact_delimiter_overrides: Optional[List["EdifactDelimiterOverride"]] = None,
        **kwargs
    ):
        super(EdifactProtocolSettings, self).__init__(**kwargs)
        self.validation_settings = validation_settings
        self.framing_settings = framing_settings
        self.envelope_settings = envelope_settings
        self.acknowledgement_settings = acknowledgement_settings
        self.message_filter = message_filter
        self.processing_settings = processing_settings
        self.envelope_overrides = envelope_overrides
        self.message_filter_list = message_filter_list
        self.schema_references = schema_references
        self.validation_overrides = validation_overrides
        self.edifact_delimiter_overrides = edifact_delimiter_overrides


class EdifactSchemaReference(msrest.serialization.Model):
    """The Edifact schema reference.

    All required parameters must be populated in order to send to Azure.

    :param message_id: Required. The message id.
    :type message_id: str
    :param message_version: Required. The message version.
    :type message_version: str
    :param message_release: Required. The message release version.
    :type message_release: str
    :param sender_application_id: The sender application id.
    :type sender_application_id: str
    :param sender_application_qualifier: The sender application qualifier.
    :type sender_application_qualifier: str
    :param association_assigned_code: The association assigned code.
    :type association_assigned_code: str
    :param schema_name: Required. The schema name.
    :type schema_name: str
    """

    _validation = {
        'message_id': {'required': True},
        'message_version': {'required': True},
        'message_release': {'required': True},
        'schema_name': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'message_version': {'key': 'messageVersion', 'type': 'str'},
        'message_release': {'key': 'messageRelease', 'type': 'str'},
        'sender_application_id': {'key': 'senderApplicationId', 'type': 'str'},
        'sender_application_qualifier': {'key': 'senderApplicationQualifier', 'type': 'str'},
        'association_assigned_code': {'key': 'associationAssignedCode', 'type': 'str'},
        'schema_name': {'key': 'schemaName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_id: str,
        message_version: str,
        message_release: str,
        schema_name: str,
        sender_application_id: Optional[str] = None,
        sender_application_qualifier: Optional[str] = None,
        association_assigned_code: Optional[str] = None,
        **kwargs
    ):
        super(EdifactSchemaReference, self).__init__(**kwargs)
        self.message_id = message_id
        self.message_version = message_version
        self.message_release = message_release
        self.sender_application_id = sender_application_id
        self.sender_application_qualifier = sender_application_qualifier
        self.association_assigned_code = association_assigned_code
        self.schema_name = schema_name


class EdifactValidationOverride(msrest.serialization.Model):
    """The Edifact validation override settings.

    All required parameters must be populated in order to send to Azure.

    :param message_id: Required. The message id on which the validation settings has to be applied.
    :type message_id: str
    :param enforce_character_set: Required. The value indicating whether to validate character Set.
    :type enforce_character_set: bool
    :param validate_edi_types: Required. The value indicating whether to validate EDI types.
    :type validate_edi_types: bool
    :param validate_xsd_types: Required. The value indicating whether to validate XSD types.
    :type validate_xsd_types: bool
    :param allow_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     allow leading and trailing spaces and zeroes.
    :type allow_leading_and_trailing_spaces_and_zeroes: bool
    :param trailing_separator_policy: Required. The trailing separator policy. Possible values
     include: "NotSpecified", "NotAllowed", "Optional", "Mandatory".
    :type trailing_separator_policy: str or ~azure.mgmt.logic.models.TrailingSeparatorPolicy
    :param trim_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     trim leading and trailing spaces and zeroes.
    :type trim_leading_and_trailing_spaces_and_zeroes: bool
    """

    _validation = {
        'message_id': {'required': True},
        'enforce_character_set': {'required': True},
        'validate_edi_types': {'required': True},
        'validate_xsd_types': {'required': True},
        'allow_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'trailing_separator_policy': {'required': True},
        'trim_leading_and_trailing_spaces_and_zeroes': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'enforce_character_set': {'key': 'enforceCharacterSet', 'type': 'bool'},
        'validate_edi_types': {'key': 'validateEDITypes', 'type': 'bool'},
        'validate_xsd_types': {'key': 'validateXSDTypes', 'type': 'bool'},
        'allow_leading_and_trailing_spaces_and_zeroes': {'key': 'allowLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'trailing_separator_policy': {'key': 'trailingSeparatorPolicy', 'type': 'str'},
        'trim_leading_and_trailing_spaces_and_zeroes': {'key': 'trimLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        message_id: str,
        enforce_character_set: bool,
        validate_edi_types: bool,
        validate_xsd_types: bool,
        allow_leading_and_trailing_spaces_and_zeroes: bool,
        trailing_separator_policy: Union[str, "TrailingSeparatorPolicy"],
        trim_leading_and_trailing_spaces_and_zeroes: bool,
        **kwargs
    ):
        super(EdifactValidationOverride, self).__init__(**kwargs)
        self.message_id = message_id
        self.enforce_character_set = enforce_character_set
        self.validate_edi_types = validate_edi_types
        self.validate_xsd_types = validate_xsd_types
        self.allow_leading_and_trailing_spaces_and_zeroes = allow_leading_and_trailing_spaces_and_zeroes
        self.trailing_separator_policy = trailing_separator_policy
        self.trim_leading_and_trailing_spaces_and_zeroes = trim_leading_and_trailing_spaces_and_zeroes


class EdifactValidationSettings(msrest.serialization.Model):
    """The Edifact agreement validation settings.

    All required parameters must be populated in order to send to Azure.

    :param validate_character_set: Required. The value indicating whether to validate character set
     in the message.
    :type validate_character_set: bool
    :param check_duplicate_interchange_control_number: Required. The value indicating whether to
     check for duplicate interchange control number.
    :type check_duplicate_interchange_control_number: bool
    :param interchange_control_number_validity_days: Required. The validity period of interchange
     control number.
    :type interchange_control_number_validity_days: int
    :param check_duplicate_group_control_number: Required. The value indicating whether to check
     for duplicate group control number.
    :type check_duplicate_group_control_number: bool
    :param check_duplicate_transaction_set_control_number: Required. The value indicating whether
     to check for duplicate transaction set control number.
    :type check_duplicate_transaction_set_control_number: bool
    :param validate_edi_types: Required. The value indicating whether to Whether to validate EDI
     types.
    :type validate_edi_types: bool
    :param validate_xsd_types: Required. The value indicating whether to Whether to validate XSD
     types.
    :type validate_xsd_types: bool
    :param allow_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     allow leading and trailing spaces and zeroes.
    :type allow_leading_and_trailing_spaces_and_zeroes: bool
    :param trim_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     trim leading and trailing spaces and zeroes.
    :type trim_leading_and_trailing_spaces_and_zeroes: bool
    :param trailing_separator_policy: Required. The trailing separator policy. Possible values
     include: "NotSpecified", "NotAllowed", "Optional", "Mandatory".
    :type trailing_separator_policy: str or ~azure.mgmt.logic.models.TrailingSeparatorPolicy
    """

    _validation = {
        'validate_character_set': {'required': True},
        'check_duplicate_interchange_control_number': {'required': True},
        'interchange_control_number_validity_days': {'required': True},
        'check_duplicate_group_control_number': {'required': True},
        'check_duplicate_transaction_set_control_number': {'required': True},
        'validate_edi_types': {'required': True},
        'validate_xsd_types': {'required': True},
        'allow_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'trim_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'trailing_separator_policy': {'required': True},
    }

    _attribute_map = {
        'validate_character_set': {'key': 'validateCharacterSet', 'type': 'bool'},
        'check_duplicate_interchange_control_number': {'key': 'checkDuplicateInterchangeControlNumber', 'type': 'bool'},
        'interchange_control_number_validity_days': {'key': 'interchangeControlNumberValidityDays', 'type': 'int'},
        'check_duplicate_group_control_number': {'key': 'checkDuplicateGroupControlNumber', 'type': 'bool'},
        'check_duplicate_transaction_set_control_number': {'key': 'checkDuplicateTransactionSetControlNumber', 'type': 'bool'},
        'validate_edi_types': {'key': 'validateEDITypes', 'type': 'bool'},
        'validate_xsd_types': {'key': 'validateXSDTypes', 'type': 'bool'},
        'allow_leading_and_trailing_spaces_and_zeroes': {'key': 'allowLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'trim_leading_and_trailing_spaces_and_zeroes': {'key': 'trimLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'trailing_separator_policy': {'key': 'trailingSeparatorPolicy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        validate_character_set: bool,
        check_duplicate_interchange_control_number: bool,
        interchange_control_number_validity_days: int,
        check_duplicate_group_control_number: bool,
        check_duplicate_transaction_set_control_number: bool,
        validate_edi_types: bool,
        validate_xsd_types: bool,
        allow_leading_and_trailing_spaces_and_zeroes: bool,
        trim_leading_and_trailing_spaces_and_zeroes: bool,
        trailing_separator_policy: Union[str, "TrailingSeparatorPolicy"],
        **kwargs
    ):
        super(EdifactValidationSettings, self).__init__(**kwargs)
        self.validate_character_set = validate_character_set
        self.check_duplicate_interchange_control_number = check_duplicate_interchange_control_number
        self.interchange_control_number_validity_days = interchange_control_number_validity_days
        self.check_duplicate_group_control_number = check_duplicate_group_control_number
        self.check_duplicate_transaction_set_control_number = check_duplicate_transaction_set_control_number
        self.validate_edi_types = validate_edi_types
        self.validate_xsd_types = validate_xsd_types
        self.allow_leading_and_trailing_spaces_and_zeroes = allow_leading_and_trailing_spaces_and_zeroes
        self.trim_leading_and_trailing_spaces_and_zeroes = trim_leading_and_trailing_spaces_and_zeroes
        self.trailing_separator_policy = trailing_separator_policy


class ErrorProperties(msrest.serialization.Model):
    """Error properties indicate why the Logic service was not able to process the incoming request. The reason is provided in the error message.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorProperties, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ErrorResponse(msrest.serialization.Model):
    """Error response indicates Logic service is not able to process the incoming request. The error property contains the error details.

    :param error: The error properties.
    :type error: ~azure.mgmt.logic.models.ErrorProperties
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorProperties'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorProperties"] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class Expression(msrest.serialization.Model):
    """The expression.

    :param text: The text.
    :type text: str
    :param value: Any object.
    :type value: object
    :param subexpressions: The sub expressions.
    :type subexpressions: list[~azure.mgmt.logic.models.Expression]
    :param error: The azure resource error info.
    :type error: ~azure.mgmt.logic.models.AzureResourceErrorInfo
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'subexpressions': {'key': 'subexpressions', 'type': '[Expression]'},
        'error': {'key': 'error', 'type': 'AzureResourceErrorInfo'},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        value: Optional[object] = None,
        subexpressions: Optional[List["Expression"]] = None,
        error: Optional["AzureResourceErrorInfo"] = None,
        **kwargs
    ):
        super(Expression, self).__init__(**kwargs)
        self.text = text
        self.value = value
        self.subexpressions = subexpressions
        self.error = error


class ExpressionRoot(Expression):
    """The expression root.

    :param text: The text.
    :type text: str
    :param value: Any object.
    :type value: object
    :param subexpressions: The sub expressions.
    :type subexpressions: list[~azure.mgmt.logic.models.Expression]
    :param error: The azure resource error info.
    :type error: ~azure.mgmt.logic.models.AzureResourceErrorInfo
    :param path: The path.
    :type path: str
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'subexpressions': {'key': 'subexpressions', 'type': '[Expression]'},
        'error': {'key': 'error', 'type': 'AzureResourceErrorInfo'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        value: Optional[object] = None,
        subexpressions: Optional[List["Expression"]] = None,
        error: Optional["AzureResourceErrorInfo"] = None,
        path: Optional[str] = None,
        **kwargs
    ):
        super(ExpressionRoot, self).__init__(text=text, value=value, subexpressions=subexpressions, error=error, **kwargs)
        self.path = path


class ExpressionTraces(msrest.serialization.Model):
    """The expression traces.

    :param inputs:
    :type inputs: list[~azure.mgmt.logic.models.ExpressionRoot]
    """

    _attribute_map = {
        'inputs': {'key': 'inputs', 'type': '[ExpressionRoot]'},
    }

    def __init__(
        self,
        *,
        inputs: Optional[List["ExpressionRoot"]] = None,
        **kwargs
    ):
        super(ExpressionTraces, self).__init__(**kwargs)
        self.inputs = inputs


class ExtendedErrorInfo(msrest.serialization.Model):
    """The extended error info.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error code. Possible values include: "NotSpecified",
     "IntegrationServiceEnvironmentNotFound", "InternalServerError", "InvalidOperationId".
    :type code: str or ~azure.mgmt.logic.models.ErrorResponseCode
    :param message: Required. The error message.
    :type message: str
    :param details: The error message details.
    :type details: list[~azure.mgmt.logic.models.ExtendedErrorInfo]
    :param inner_error: The inner error.
    :type inner_error: object
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ExtendedErrorInfo]'},
        'inner_error': {'key': 'innerError', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        code: Union[str, "ErrorResponseCode"],
        message: str,
        details: Optional[List["ExtendedErrorInfo"]] = None,
        inner_error: Optional[object] = None,
        **kwargs
    ):
        super(ExtendedErrorInfo, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details
        self.inner_error = inner_error


class FlowAccessControlConfiguration(msrest.serialization.Model):
    """The access control configuration.

    :param triggers: The access control configuration for invoking workflow triggers.
    :type triggers: ~azure.mgmt.logic.models.FlowAccessControlConfigurationPolicy
    :param contents: The access control configuration for accessing workflow run contents.
    :type contents: ~azure.mgmt.logic.models.FlowAccessControlConfigurationPolicy
    :param actions: The access control configuration for workflow actions.
    :type actions: ~azure.mgmt.logic.models.FlowAccessControlConfigurationPolicy
    :param workflow_management: The access control configuration for workflow management.
    :type workflow_management: ~azure.mgmt.logic.models.FlowAccessControlConfigurationPolicy
    """

    _attribute_map = {
        'triggers': {'key': 'triggers', 'type': 'FlowAccessControlConfigurationPolicy'},
        'contents': {'key': 'contents', 'type': 'FlowAccessControlConfigurationPolicy'},
        'actions': {'key': 'actions', 'type': 'FlowAccessControlConfigurationPolicy'},
        'workflow_management': {'key': 'workflowManagement', 'type': 'FlowAccessControlConfigurationPolicy'},
    }

    def __init__(
        self,
        *,
        triggers: Optional["FlowAccessControlConfigurationPolicy"] = None,
        contents: Optional["FlowAccessControlConfigurationPolicy"] = None,
        actions: Optional["FlowAccessControlConfigurationPolicy"] = None,
        workflow_management: Optional["FlowAccessControlConfigurationPolicy"] = None,
        **kwargs
    ):
        super(FlowAccessControlConfiguration, self).__init__(**kwargs)
        self.triggers = triggers
        self.contents = contents
        self.actions = actions
        self.workflow_management = workflow_management


class FlowAccessControlConfigurationPolicy(msrest.serialization.Model):
    """The access control configuration policy.

    :param allowed_caller_ip_addresses: The allowed caller IP address ranges.
    :type allowed_caller_ip_addresses: list[~azure.mgmt.logic.models.IpAddressRange]
    :param open_authentication_policies: The authentication policies for workflow.
    :type open_authentication_policies: ~azure.mgmt.logic.models.OpenAuthenticationAccessPolicies
    """

    _attribute_map = {
        'allowed_caller_ip_addresses': {'key': 'allowedCallerIpAddresses', 'type': '[IpAddressRange]'},
        'open_authentication_policies': {'key': 'openAuthenticationPolicies', 'type': 'OpenAuthenticationAccessPolicies'},
    }

    def __init__(
        self,
        *,
        allowed_caller_ip_addresses: Optional[List["IpAddressRange"]] = None,
        open_authentication_policies: Optional["OpenAuthenticationAccessPolicies"] = None,
        **kwargs
    ):
        super(FlowAccessControlConfigurationPolicy, self).__init__(**kwargs)
        self.allowed_caller_ip_addresses = allowed_caller_ip_addresses
        self.open_authentication_policies = open_authentication_policies


class FlowEndpoints(msrest.serialization.Model):
    """The flow endpoints configuration.

    :param outgoing_ip_addresses: The outgoing ip address.
    :type outgoing_ip_addresses: list[~azure.mgmt.logic.models.IpAddress]
    :param access_endpoint_ip_addresses: The access endpoint ip address.
    :type access_endpoint_ip_addresses: list[~azure.mgmt.logic.models.IpAddress]
    """

    _attribute_map = {
        'outgoing_ip_addresses': {'key': 'outgoingIpAddresses', 'type': '[IpAddress]'},
        'access_endpoint_ip_addresses': {'key': 'accessEndpointIpAddresses', 'type': '[IpAddress]'},
    }

    def __init__(
        self,
        *,
        outgoing_ip_addresses: Optional[List["IpAddress"]] = None,
        access_endpoint_ip_addresses: Optional[List["IpAddress"]] = None,
        **kwargs
    ):
        super(FlowEndpoints, self).__init__(**kwargs)
        self.outgoing_ip_addresses = outgoing_ip_addresses
        self.access_endpoint_ip_addresses = access_endpoint_ip_addresses


class FlowEndpointsConfiguration(msrest.serialization.Model):
    """The endpoints configuration.

    :param workflow: The workflow endpoints.
    :type workflow: ~azure.mgmt.logic.models.FlowEndpoints
    :param connector: The connector endpoints.
    :type connector: ~azure.mgmt.logic.models.FlowEndpoints
    """

    _attribute_map = {
        'workflow': {'key': 'workflow', 'type': 'FlowEndpoints'},
        'connector': {'key': 'connector', 'type': 'FlowEndpoints'},
    }

    def __init__(
        self,
        *,
        workflow: Optional["FlowEndpoints"] = None,
        connector: Optional["FlowEndpoints"] = None,
        **kwargs
    ):
        super(FlowEndpointsConfiguration, self).__init__(**kwargs)
        self.workflow = workflow
        self.connector = connector


class GenerateUpgradedDefinitionParameters(msrest.serialization.Model):
    """The parameters to generate upgraded definition.

    :param target_schema_version: The target schema version.
    :type target_schema_version: str
    """

    _attribute_map = {
        'target_schema_version': {'key': 'targetSchemaVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_schema_version: Optional[str] = None,
        **kwargs
    ):
        super(GenerateUpgradedDefinitionParameters, self).__init__(**kwargs)
        self.target_schema_version = target_schema_version


class GetCallbackUrlParameters(msrest.serialization.Model):
    """The callback url parameters.

    :param not_after: The expiry time.
    :type not_after: ~datetime.datetime
    :param key_type: The key type. Possible values include: "NotSpecified", "Primary", "Secondary".
    :type key_type: str or ~azure.mgmt.logic.models.KeyType
    """

    _attribute_map = {
        'not_after': {'key': 'notAfter', 'type': 'iso-8601'},
        'key_type': {'key': 'keyType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        not_after: Optional[datetime.datetime] = None,
        key_type: Optional[Union[str, "KeyType"]] = None,
        **kwargs
    ):
        super(GetCallbackUrlParameters, self).__init__(**kwargs)
        self.not_after = not_after
        self.key_type = key_type


class IntegrationAccount(Resource):
    """The integration account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param sku: The sku.
    :type sku: ~azure.mgmt.logic.models.IntegrationAccountSku
    :param integration_service_environment: The integration service environment.
    :type integration_service_environment: ~azure.mgmt.logic.models.IntegrationServiceEnvironment
    :param state: The workflow state. Possible values include: "NotSpecified", "Completed",
     "Enabled", "Disabled", "Deleted", "Suspended".
    :type state: str or ~azure.mgmt.logic.models.WorkflowState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'IntegrationAccountSku'},
        'integration_service_environment': {'key': 'properties.integrationServiceEnvironment', 'type': 'IntegrationServiceEnvironment'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["IntegrationAccountSku"] = None,
        integration_service_environment: Optional["IntegrationServiceEnvironment"] = None,
        state: Optional[Union[str, "WorkflowState"]] = None,
        **kwargs
    ):
        super(IntegrationAccount, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.integration_service_environment = integration_service_environment
        self.state = state


class IntegrationAccountAgreement(Resource):
    """The integration account agreement.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :ivar created_time: The created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: ~datetime.datetime
    :param metadata: The metadata.
    :type metadata: object
    :param agreement_type: Required. The agreement type. Possible values include: "NotSpecified",
     "AS2", "X12", "Edifact".
    :type agreement_type: str or ~azure.mgmt.logic.models.AgreementType
    :param host_partner: Required. The integration account partner that is set as host partner for
     this agreement.
    :type host_partner: str
    :param guest_partner: Required. The integration account partner that is set as guest partner
     for this agreement.
    :type guest_partner: str
    :param host_identity: Required. The business identity of the host partner.
    :type host_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :param guest_identity: Required. The business identity of the guest partner.
    :type guest_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :param content: Required. The agreement content.
    :type content: ~azure.mgmt.logic.models.AgreementContent
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'agreement_type': {'required': True},
        'host_partner': {'required': True},
        'guest_partner': {'required': True},
        'host_identity': {'required': True},
        'guest_identity': {'required': True},
        'content': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'agreement_type': {'key': 'properties.agreementType', 'type': 'str'},
        'host_partner': {'key': 'properties.hostPartner', 'type': 'str'},
        'guest_partner': {'key': 'properties.guestPartner', 'type': 'str'},
        'host_identity': {'key': 'properties.hostIdentity', 'type': 'BusinessIdentity'},
        'guest_identity': {'key': 'properties.guestIdentity', 'type': 'BusinessIdentity'},
        'content': {'key': 'properties.content', 'type': 'AgreementContent'},
    }

    def __init__(
        self,
        *,
        agreement_type: Union[str, "AgreementType"],
        host_partner: str,
        guest_partner: str,
        host_identity: "BusinessIdentity",
        guest_identity: "BusinessIdentity",
        content: "AgreementContent",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        metadata: Optional[object] = None,
        **kwargs
    ):
        super(IntegrationAccountAgreement, self).__init__(location=location, tags=tags, **kwargs)
        self.created_time = None
        self.changed_time = None
        self.metadata = metadata
        self.agreement_type = agreement_type
        self.host_partner = host_partner
        self.guest_partner = guest_partner
        self.host_identity = host_identity
        self.guest_identity = guest_identity
        self.content = content


class IntegrationAccountAgreementFilter(msrest.serialization.Model):
    """The integration account agreement filter for odata query.

    All required parameters must be populated in order to send to Azure.

    :param agreement_type: Required. The agreement type of integration account agreement. Possible
     values include: "NotSpecified", "AS2", "X12", "Edifact".
    :type agreement_type: str or ~azure.mgmt.logic.models.AgreementType
    """

    _validation = {
        'agreement_type': {'required': True},
    }

    _attribute_map = {
        'agreement_type': {'key': 'agreementType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        agreement_type: Union[str, "AgreementType"],
        **kwargs
    ):
        super(IntegrationAccountAgreementFilter, self).__init__(**kwargs)
        self.agreement_type = agreement_type


class IntegrationAccountAgreementListResult(msrest.serialization.Model):
    """The list of integration account agreements.

    :param value: The list of integration account agreements.
    :type value: list[~azure.mgmt.logic.models.IntegrationAccountAgreement]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationAccountAgreement]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationAccountAgreement"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationAccountAgreementListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationAccountCertificate(Resource):
    """The integration account certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :ivar created_time: The created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: ~datetime.datetime
    :param metadata: The metadata.
    :type metadata: object
    :param key: The key details in the key vault.
    :type key: ~azure.mgmt.logic.models.KeyVaultKeyReference
    :param public_certificate: The public certificate.
    :type public_certificate: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'key': {'key': 'properties.key', 'type': 'KeyVaultKeyReference'},
        'public_certificate': {'key': 'properties.publicCertificate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        metadata: Optional[object] = None,
        key: Optional["KeyVaultKeyReference"] = None,
        public_certificate: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationAccountCertificate, self).__init__(location=location, tags=tags, **kwargs)
        self.created_time = None
        self.changed_time = None
        self.metadata = metadata
        self.key = key
        self.public_certificate = public_certificate


class IntegrationAccountCertificateListResult(msrest.serialization.Model):
    """The list of integration account certificates.

    :param value: The list of integration account certificates.
    :type value: list[~azure.mgmt.logic.models.IntegrationAccountCertificate]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationAccountCertificate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationAccountCertificate"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationAccountCertificateListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationAccountListResult(msrest.serialization.Model):
    """The list of integration accounts.

    :param value: The list of integration accounts.
    :type value: list[~azure.mgmt.logic.models.IntegrationAccount]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationAccount]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationAccount"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationAccountListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationAccountMap(Resource):
    """The integration account map.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param map_type: Required. The map type. Possible values include: "NotSpecified", "Xslt",
     "Xslt20", "Xslt30", "Liquid".
    :type map_type: str or ~azure.mgmt.logic.models.MapType
    :param parameters_schema: The parameters schema of integration account map.
    :type parameters_schema:
     ~azure.mgmt.logic.models.IntegrationAccountMapPropertiesParametersSchema
    :ivar created_time: The created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: ~datetime.datetime
    :param content: The content.
    :type content: str
    :param content_type: The content type.
    :type content_type: str
    :ivar content_link: The content link.
    :vartype content_link: ~azure.mgmt.logic.models.ContentLink
    :param metadata: The metadata.
    :type metadata: object
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'map_type': {'required': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'content_link': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'map_type': {'key': 'properties.mapType', 'type': 'str'},
        'parameters_schema': {'key': 'properties.parametersSchema', 'type': 'IntegrationAccountMapPropertiesParametersSchema'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'content': {'key': 'properties.content', 'type': 'str'},
        'content_type': {'key': 'properties.contentType', 'type': 'str'},
        'content_link': {'key': 'properties.contentLink', 'type': 'ContentLink'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        map_type: Union[str, "MapType"],
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        parameters_schema: Optional["IntegrationAccountMapPropertiesParametersSchema"] = None,
        content: Optional[str] = None,
        content_type: Optional[str] = None,
        metadata: Optional[object] = None,
        **kwargs
    ):
        super(IntegrationAccountMap, self).__init__(location=location, tags=tags, **kwargs)
        self.map_type = map_type
        self.parameters_schema = parameters_schema
        self.created_time = None
        self.changed_time = None
        self.content = content
        self.content_type = content_type
        self.content_link = None
        self.metadata = metadata


class IntegrationAccountMapFilter(msrest.serialization.Model):
    """The integration account map filter for odata query.

    All required parameters must be populated in order to send to Azure.

    :param map_type: Required. The map type of integration account map. Possible values include:
     "NotSpecified", "Xslt", "Xslt20", "Xslt30", "Liquid".
    :type map_type: str or ~azure.mgmt.logic.models.MapType
    """

    _validation = {
        'map_type': {'required': True},
    }

    _attribute_map = {
        'map_type': {'key': 'mapType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        map_type: Union[str, "MapType"],
        **kwargs
    ):
        super(IntegrationAccountMapFilter, self).__init__(**kwargs)
        self.map_type = map_type


class IntegrationAccountMapListResult(msrest.serialization.Model):
    """The list of integration account maps.

    :param value: The list of integration account maps.
    :type value: list[~azure.mgmt.logic.models.IntegrationAccountMap]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationAccountMap]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationAccountMap"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationAccountMapListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationAccountMapPropertiesParametersSchema(msrest.serialization.Model):
    """The parameters schema of integration account map.

    :param ref: The reference name.
    :type ref: str
    """

    _attribute_map = {
        'ref': {'key': 'ref', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ref: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationAccountMapPropertiesParametersSchema, self).__init__(**kwargs)
        self.ref = ref


class IntegrationAccountPartner(Resource):
    """The integration account partner.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param partner_type: Required. The partner type. Possible values include: "NotSpecified",
     "B2B".
    :type partner_type: str or ~azure.mgmt.logic.models.PartnerType
    :ivar created_time: The created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: ~datetime.datetime
    :param metadata: The metadata.
    :type metadata: object
    :param content: Required. The partner content.
    :type content: ~azure.mgmt.logic.models.PartnerContent
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'partner_type': {'required': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'content': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'partner_type': {'key': 'properties.partnerType', 'type': 'str'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'content': {'key': 'properties.content', 'type': 'PartnerContent'},
    }

    def __init__(
        self,
        *,
        partner_type: Union[str, "PartnerType"],
        content: "PartnerContent",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        metadata: Optional[object] = None,
        **kwargs
    ):
        super(IntegrationAccountPartner, self).__init__(location=location, tags=tags, **kwargs)
        self.partner_type = partner_type
        self.created_time = None
        self.changed_time = None
        self.metadata = metadata
        self.content = content


class IntegrationAccountPartnerFilter(msrest.serialization.Model):
    """The integration account partner filter for odata query.

    All required parameters must be populated in order to send to Azure.

    :param partner_type: Required. The partner type of integration account partner. Possible values
     include: "NotSpecified", "B2B".
    :type partner_type: str or ~azure.mgmt.logic.models.PartnerType
    """

    _validation = {
        'partner_type': {'required': True},
    }

    _attribute_map = {
        'partner_type': {'key': 'partnerType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        partner_type: Union[str, "PartnerType"],
        **kwargs
    ):
        super(IntegrationAccountPartnerFilter, self).__init__(**kwargs)
        self.partner_type = partner_type


class IntegrationAccountPartnerListResult(msrest.serialization.Model):
    """The list of integration account partners.

    :param value: The list of integration account partners.
    :type value: list[~azure.mgmt.logic.models.IntegrationAccountPartner]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationAccountPartner]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationAccountPartner"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationAccountPartnerListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationAccountSchema(Resource):
    """The integration account schema.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param schema_type: Required. The schema type. Possible values include: "NotSpecified", "Xml".
    :type schema_type: str or ~azure.mgmt.logic.models.SchemaType
    :param target_namespace: The target namespace of the schema.
    :type target_namespace: str
    :param document_name: The document name.
    :type document_name: str
    :param file_name: The file name.
    :type file_name: str
    :ivar created_time: The created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: ~datetime.datetime
    :param metadata: The metadata.
    :type metadata: object
    :param content: The content.
    :type content: str
    :param content_type: The content type.
    :type content_type: str
    :ivar content_link: The content link.
    :vartype content_link: ~azure.mgmt.logic.models.ContentLink
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'schema_type': {'required': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'content_link': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'schema_type': {'key': 'properties.schemaType', 'type': 'str'},
        'target_namespace': {'key': 'properties.targetNamespace', 'type': 'str'},
        'document_name': {'key': 'properties.documentName', 'type': 'str'},
        'file_name': {'key': 'properties.fileName', 'type': 'str'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'content': {'key': 'properties.content', 'type': 'str'},
        'content_type': {'key': 'properties.contentType', 'type': 'str'},
        'content_link': {'key': 'properties.contentLink', 'type': 'ContentLink'},
    }

    def __init__(
        self,
        *,
        schema_type: Union[str, "SchemaType"],
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        target_namespace: Optional[str] = None,
        document_name: Optional[str] = None,
        file_name: Optional[str] = None,
        metadata: Optional[object] = None,
        content: Optional[str] = None,
        content_type: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationAccountSchema, self).__init__(location=location, tags=tags, **kwargs)
        self.schema_type = schema_type
        self.target_namespace = target_namespace
        self.document_name = document_name
        self.file_name = file_name
        self.created_time = None
        self.changed_time = None
        self.metadata = metadata
        self.content = content
        self.content_type = content_type
        self.content_link = None


class IntegrationAccountSchemaFilter(msrest.serialization.Model):
    """The integration account schema filter for odata query.

    All required parameters must be populated in order to send to Azure.

    :param schema_type: Required. The schema type of integration account schema. Possible values
     include: "NotSpecified", "Xml".
    :type schema_type: str or ~azure.mgmt.logic.models.SchemaType
    """

    _validation = {
        'schema_type': {'required': True},
    }

    _attribute_map = {
        'schema_type': {'key': 'schemaType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        schema_type: Union[str, "SchemaType"],
        **kwargs
    ):
        super(IntegrationAccountSchemaFilter, self).__init__(**kwargs)
        self.schema_type = schema_type


class IntegrationAccountSchemaListResult(msrest.serialization.Model):
    """The list of integration account schemas.

    :param value: The list of integration account schemas.
    :type value: list[~azure.mgmt.logic.models.IntegrationAccountSchema]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationAccountSchema]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationAccountSchema"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationAccountSchemaListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationAccountSession(Resource):
    """The integration account session.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :ivar created_time: The created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: ~datetime.datetime
    :param content: The session content.
    :type content: object
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'content': {'key': 'properties.content', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        content: Optional[object] = None,
        **kwargs
    ):
        super(IntegrationAccountSession, self).__init__(location=location, tags=tags, **kwargs)
        self.created_time = None
        self.changed_time = None
        self.content = content


class IntegrationAccountSessionFilter(msrest.serialization.Model):
    """The integration account session filter.

    All required parameters must be populated in order to send to Azure.

    :param changed_time: Required. The changed time of integration account sessions.
    :type changed_time: ~datetime.datetime
    """

    _validation = {
        'changed_time': {'required': True},
    }

    _attribute_map = {
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        changed_time: datetime.datetime,
        **kwargs
    ):
        super(IntegrationAccountSessionFilter, self).__init__(**kwargs)
        self.changed_time = changed_time


class IntegrationAccountSessionListResult(msrest.serialization.Model):
    """The list of integration account sessions.

    :param value: The list of integration account sessions.
    :type value: list[~azure.mgmt.logic.models.IntegrationAccountSession]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationAccountSession]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationAccountSession"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationAccountSessionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationAccountSku(msrest.serialization.Model):
    """The integration account sku.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The sku name. Possible values include: "NotSpecified", "Free", "Basic",
     "Standard".
    :type name: str or ~azure.mgmt.logic.models.IntegrationAccountSkuName
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "IntegrationAccountSkuName"],
        **kwargs
    ):
        super(IntegrationAccountSku, self).__init__(**kwargs)
        self.name = name


class IntegrationServiceEnvironmenEncryptionConfiguration(msrest.serialization.Model):
    """The encryption configuration for the integration service environment.

    :param encryption_key_reference: The encryption key reference.
    :type encryption_key_reference:
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmenEncryptionKeyReference
    """

    _attribute_map = {
        'encryption_key_reference': {'key': 'encryptionKeyReference', 'type': 'IntegrationServiceEnvironmenEncryptionKeyReference'},
    }

    def __init__(
        self,
        *,
        encryption_key_reference: Optional["IntegrationServiceEnvironmenEncryptionKeyReference"] = None,
        **kwargs
    ):
        super(IntegrationServiceEnvironmenEncryptionConfiguration, self).__init__(**kwargs)
        self.encryption_key_reference = encryption_key_reference


class IntegrationServiceEnvironmenEncryptionKeyReference(msrest.serialization.Model):
    """The encryption key details for the integration service environment.

    :param key_vault: The key vault reference.
    :type key_vault: ~azure.mgmt.logic.models.ResourceReference
    :param key_name: Gets the key name in the Key Vault.
    :type key_name: str
    :param key_version: Gets the version of the key specified in the keyName property.
    :type key_version: str
    """

    _attribute_map = {
        'key_vault': {'key': 'keyVault', 'type': 'ResourceReference'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault: Optional["ResourceReference"] = None,
        key_name: Optional[str] = None,
        key_version: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationServiceEnvironmenEncryptionKeyReference, self).__init__(**kwargs)
        self.key_vault = key_vault
        self.key_name = key_name
        self.key_version = key_version


class IntegrationServiceEnvironment(Resource):
    """The integration service environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param properties: The integration service environment properties.
    :type properties: ~azure.mgmt.logic.models.IntegrationServiceEnvironmentProperties
    :param sku: The sku.
    :type sku: ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'IntegrationServiceEnvironmentProperties'},
        'sku': {'key': 'sku', 'type': 'IntegrationServiceEnvironmentSku'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["IntegrationServiceEnvironmentProperties"] = None,
        sku: Optional["IntegrationServiceEnvironmentSku"] = None,
        **kwargs
    ):
        super(IntegrationServiceEnvironment, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties
        self.sku = sku


class IntegrationServiceEnvironmentAccessEndpoint(msrest.serialization.Model):
    """The integration service environment access endpoint.

    :param type: The access endpoint type. Possible values include: "NotSpecified", "External",
     "Internal".
    :type type: str or ~azure.mgmt.logic.models.IntegrationServiceEnvironmentAccessEndpointType
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "IntegrationServiceEnvironmentAccessEndpointType"]] = None,
        **kwargs
    ):
        super(IntegrationServiceEnvironmentAccessEndpoint, self).__init__(**kwargs)
        self.type = type


class IntegrationServiceEnvironmentListResult(msrest.serialization.Model):
    """The list of integration service environments.

    :param value:
    :type value: list[~azure.mgmt.logic.models.IntegrationServiceEnvironment]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationServiceEnvironment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationServiceEnvironment"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationServiceEnvironmentListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationServiceEnvironmentNetworkDependency(msrest.serialization.Model):
    """The azure async operation resource.

    :param category: The network dependency category type. Possible values include: "NotSpecified",
     "AzureStorage", "AzureManagement", "AzureActiveDirectory", "SSLCertificateVerification",
     "DiagnosticLogsAndMetrics", "IntegrationServiceEnvironmentConnectors", "RedisCache",
     "AccessEndpoints", "RecoveryService", "SQL", "RegionalService".
    :type category: str or
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkDependencyCategoryType
    :param display_name: The display name.
    :type display_name: str
    :param endpoints: The endpoints.
    :type endpoints: list[~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkEndpoint]
    """

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[IntegrationServiceEnvironmentNetworkEndpoint]'},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "IntegrationServiceEnvironmentNetworkDependencyCategoryType"]] = None,
        display_name: Optional[str] = None,
        endpoints: Optional[List["IntegrationServiceEnvironmentNetworkEndpoint"]] = None,
        **kwargs
    ):
        super(IntegrationServiceEnvironmentNetworkDependency, self).__init__(**kwargs)
        self.category = category
        self.display_name = display_name
        self.endpoints = endpoints


class IntegrationServiceEnvironmentNetworkDependencyHealth(msrest.serialization.Model):
    """The integration service environment subnet network health.

    :param error: The error if any occurred during the operation.
    :type error: ~azure.mgmt.logic.models.ExtendedErrorInfo
    :param state: The network dependency health state. Possible values include: "NotSpecified",
     "Healthy", "Unhealthy", "Unknown".
    :type state: str or
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkDependencyHealthState
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ExtendedErrorInfo'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        error: Optional["ExtendedErrorInfo"] = None,
        state: Optional[Union[str, "IntegrationServiceEnvironmentNetworkDependencyHealthState"]] = None,
        **kwargs
    ):
        super(IntegrationServiceEnvironmentNetworkDependencyHealth, self).__init__(**kwargs)
        self.error = error
        self.state = state


class IntegrationServiceEnvironmentNetworkEndpoint(msrest.serialization.Model):
    """The network endpoint.

    :param accessibility: The accessibility state. Possible values include: "NotSpecified",
     "Unknown", "Available", "NotAvailable".
    :type accessibility: str or
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkEndPointAccessibilityState
    :param domain_name: The domain name.
    :type domain_name: str
    :param ports: The ports.
    :type ports: list[str]
    """

    _attribute_map = {
        'accessibility': {'key': 'accessibility', 'type': 'str'},
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'ports': {'key': 'ports', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        accessibility: Optional[Union[str, "IntegrationServiceEnvironmentNetworkEndPointAccessibilityState"]] = None,
        domain_name: Optional[str] = None,
        ports: Optional[List[str]] = None,
        **kwargs
    ):
        super(IntegrationServiceEnvironmentNetworkEndpoint, self).__init__(**kwargs)
        self.accessibility = accessibility
        self.domain_name = domain_name
        self.ports = ports


class IntegrationServiceEnvironmentProperties(msrest.serialization.Model):
    """The integration service environment properties.

    :param provisioning_state: The provisioning state. Possible values include: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
     "Unregistered", "Completed", "Renewing", "Pending", "Waiting", "InProgress".
    :type provisioning_state: str or ~azure.mgmt.logic.models.WorkflowProvisioningState
    :param state: The integration service environment state. Possible values include:
     "NotSpecified", "Completed", "Enabled", "Disabled", "Deleted", "Suspended".
    :type state: str or ~azure.mgmt.logic.models.WorkflowState
    :param integration_service_environment_id: Gets the tracking id.
    :type integration_service_environment_id: str
    :param endpoints_configuration: The endpoints configuration.
    :type endpoints_configuration: ~azure.mgmt.logic.models.FlowEndpointsConfiguration
    :param network_configuration: The network configuration.
    :type network_configuration: ~azure.mgmt.logic.models.NetworkConfiguration
    :param encryption_configuration: The encryption configuration.
    :type encryption_configuration:
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmenEncryptionConfiguration
    """

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'integration_service_environment_id': {'key': 'integrationServiceEnvironmentId', 'type': 'str'},
        'endpoints_configuration': {'key': 'endpointsConfiguration', 'type': 'FlowEndpointsConfiguration'},
        'network_configuration': {'key': 'networkConfiguration', 'type': 'NetworkConfiguration'},
        'encryption_configuration': {'key': 'encryptionConfiguration', 'type': 'IntegrationServiceEnvironmenEncryptionConfiguration'},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "WorkflowProvisioningState"]] = None,
        state: Optional[Union[str, "WorkflowState"]] = None,
        integration_service_environment_id: Optional[str] = None,
        endpoints_configuration: Optional["FlowEndpointsConfiguration"] = None,
        network_configuration: Optional["NetworkConfiguration"] = None,
        encryption_configuration: Optional["IntegrationServiceEnvironmenEncryptionConfiguration"] = None,
        **kwargs
    ):
        super(IntegrationServiceEnvironmentProperties, self).__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.state = state
        self.integration_service_environment_id = integration_service_environment_id
        self.endpoints_configuration = endpoints_configuration
        self.network_configuration = network_configuration
        self.encryption_configuration = encryption_configuration


class IntegrationServiceEnvironmentSku(msrest.serialization.Model):
    """The integration service environment sku.

    :param name: The sku name. Possible values include: "NotSpecified", "Premium", "Developer".
    :type name: str or ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuName
    :param capacity: The sku capacity.
    :type capacity: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "IntegrationServiceEnvironmentSkuName"]] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(IntegrationServiceEnvironmentSku, self).__init__(**kwargs)
        self.name = name
        self.capacity = capacity


class IntegrationServiceEnvironmentSkuCapacity(msrest.serialization.Model):
    """The integration service environment sku capacity.

    :param minimum: The minimum capacity.
    :type minimum: int
    :param maximum: The maximum capacity.
    :type maximum: int
    :param default: The default capacity.
    :type default: int
    :param scale_type: The sku scale type. Possible values include: "Manual", "Automatic", "None".
    :type scale_type: str or ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuScaleType
    """

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        minimum: Optional[int] = None,
        maximum: Optional[int] = None,
        default: Optional[int] = None,
        scale_type: Optional[Union[str, "IntegrationServiceEnvironmentSkuScaleType"]] = None,
        **kwargs
    ):
        super(IntegrationServiceEnvironmentSkuCapacity, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.default = default
        self.scale_type = scale_type


class IntegrationServiceEnvironmentSkuDefinition(msrest.serialization.Model):
    """The integration service environment sku definition.

    :param resource_type: The resource type.
    :type resource_type: str
    :param sku: The sku.
    :type sku: ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuDefinitionSku
    :param capacity: The sku capacity.
    :type capacity: ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuCapacity
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'IntegrationServiceEnvironmentSkuDefinitionSku'},
        'capacity': {'key': 'capacity', 'type': 'IntegrationServiceEnvironmentSkuCapacity'},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        sku: Optional["IntegrationServiceEnvironmentSkuDefinitionSku"] = None,
        capacity: Optional["IntegrationServiceEnvironmentSkuCapacity"] = None,
        **kwargs
    ):
        super(IntegrationServiceEnvironmentSkuDefinition, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.sku = sku
        self.capacity = capacity


class IntegrationServiceEnvironmentSkuDefinitionSku(msrest.serialization.Model):
    """The sku.

    :param name: The sku name. Possible values include: "NotSpecified", "Premium", "Developer".
    :type name: str or ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuName
    :param tier: The sku tier.
    :type tier: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "IntegrationServiceEnvironmentSkuName"]] = None,
        tier: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationServiceEnvironmentSkuDefinitionSku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier


class IntegrationServiceEnvironmentSkuList(msrest.serialization.Model):
    """The list of integration service environment skus.

    :param value: The list of integration service environment skus.
    :type value: list[~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuDefinition]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationServiceEnvironmentSkuDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationServiceEnvironmentSkuDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationServiceEnvironmentSkuList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationServiceEnvironmentSubnetNetworkHealth(msrest.serialization.Model):
    """The integration service environment subnet network health.

    All required parameters must be populated in order to send to Azure.

    :param outbound_network_dependencies: The outbound network dependencies.
    :type outbound_network_dependencies:
     list[~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkDependency]
    :param outbound_network_health: The integration service environment network health.
    :type outbound_network_health:
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkDependencyHealth
    :param network_dependency_health_state: Required. The integration service environment network
     health state. Possible values include: "NotSpecified", "Unknown", "Available", "NotAvailable".
    :type network_dependency_health_state: str or
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkEndPointAccessibilityState
    """

    _validation = {
        'network_dependency_health_state': {'required': True},
    }

    _attribute_map = {
        'outbound_network_dependencies': {'key': 'outboundNetworkDependencies', 'type': '[IntegrationServiceEnvironmentNetworkDependency]'},
        'outbound_network_health': {'key': 'outboundNetworkHealth', 'type': 'IntegrationServiceEnvironmentNetworkDependencyHealth'},
        'network_dependency_health_state': {'key': 'networkDependencyHealthState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        network_dependency_health_state: Union[str, "IntegrationServiceEnvironmentNetworkEndPointAccessibilityState"],
        outbound_network_dependencies: Optional[List["IntegrationServiceEnvironmentNetworkDependency"]] = None,
        outbound_network_health: Optional["IntegrationServiceEnvironmentNetworkDependencyHealth"] = None,
        **kwargs
    ):
        super(IntegrationServiceEnvironmentSubnetNetworkHealth, self).__init__(**kwargs)
        self.outbound_network_dependencies = outbound_network_dependencies
        self.outbound_network_health = outbound_network_health
        self.network_dependency_health_state = network_dependency_health_state


class IpAddress(msrest.serialization.Model):
    """The ip address.

    :param address: The address.
    :type address: str
    """

    _attribute_map = {
        'address': {'key': 'address', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        address: Optional[str] = None,
        **kwargs
    ):
        super(IpAddress, self).__init__(**kwargs)
        self.address = address


class IpAddressRange(msrest.serialization.Model):
    """The ip address range.

    :param address_range: The IP address range.
    :type address_range: str
    """

    _attribute_map = {
        'address_range': {'key': 'addressRange', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        address_range: Optional[str] = None,
        **kwargs
    ):
        super(IpAddressRange, self).__init__(**kwargs)
        self.address_range = address_range


class JsonSchema(msrest.serialization.Model):
    """The JSON schema.

    :param title: The JSON title.
    :type title: str
    :param content: The JSON content.
    :type content: str
    """

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        content: Optional[str] = None,
        **kwargs
    ):
        super(JsonSchema, self).__init__(**kwargs)
        self.title = title
        self.content = content


class KeyVaultKey(msrest.serialization.Model):
    """The key vault key.

    :param kid: The key id.
    :type kid: str
    :param attributes: The key attributes.
    :type attributes: ~azure.mgmt.logic.models.KeyVaultKeyAttributes
    """

    _attribute_map = {
        'kid': {'key': 'kid', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'KeyVaultKeyAttributes'},
    }

    def __init__(
        self,
        *,
        kid: Optional[str] = None,
        attributes: Optional["KeyVaultKeyAttributes"] = None,
        **kwargs
    ):
        super(KeyVaultKey, self).__init__(**kwargs)
        self.kid = kid
        self.attributes = attributes


class KeyVaultKeyAttributes(msrest.serialization.Model):
    """The key attributes.

    :param enabled: Whether the key is enabled or not.
    :type enabled: bool
    :param created: When the key was created.
    :type created: long
    :param updated: When the key was updated.
    :type updated: long
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'created': {'key': 'created', 'type': 'long'},
        'updated': {'key': 'updated', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        created: Optional[int] = None,
        updated: Optional[int] = None,
        **kwargs
    ):
        super(KeyVaultKeyAttributes, self).__init__(**kwargs)
        self.enabled = enabled
        self.created = created
        self.updated = updated


class KeyVaultKeyCollection(msrest.serialization.Model):
    """Collection of key vault keys.

    :param value: The key vault keys.
    :type value: list[~azure.mgmt.logic.models.KeyVaultKey]
    :param skip_token: The skip token.
    :type skip_token: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[KeyVaultKey]'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["KeyVaultKey"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        super(KeyVaultKeyCollection, self).__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class KeyVaultKeyReference(msrest.serialization.Model):
    """The reference to the key vault key.

    All required parameters must be populated in order to send to Azure.

    :param key_vault: Required. The key vault reference.
    :type key_vault: ~azure.mgmt.logic.models.KeyVaultKeyReferenceKeyVault
    :param key_name: Required. The private key name in key vault.
    :type key_name: str
    :param key_version: The private key version in key vault.
    :type key_version: str
    """

    _validation = {
        'key_vault': {'required': True},
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_vault': {'key': 'keyVault', 'type': 'KeyVaultKeyReferenceKeyVault'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault: "KeyVaultKeyReferenceKeyVault",
        key_name: str,
        key_version: Optional[str] = None,
        **kwargs
    ):
        super(KeyVaultKeyReference, self).__init__(**kwargs)
        self.key_vault = key_vault
        self.key_name = key_name
        self.key_version = key_version


class KeyVaultKeyReferenceKeyVault(msrest.serialization.Model):
    """The key vault reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: The resource id.
    :type id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(KeyVaultKeyReferenceKeyVault, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None


class KeyVaultReference(ResourceReference):
    """The key vault reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: The resource id.
    :type id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(KeyVaultReference, self).__init__(id=id, **kwargs)


class ListKeyVaultKeysDefinition(msrest.serialization.Model):
    """The list key vault keys definition.

    All required parameters must be populated in order to send to Azure.

    :param key_vault: Required. The key vault reference.
    :type key_vault: ~azure.mgmt.logic.models.KeyVaultReference
    :param skip_token: The skip token.
    :type skip_token: str
    """

    _validation = {
        'key_vault': {'required': True},
    }

    _attribute_map = {
        'key_vault': {'key': 'keyVault', 'type': 'KeyVaultReference'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault: "KeyVaultReference",
        skip_token: Optional[str] = None,
        **kwargs
    ):
        super(ListKeyVaultKeysDefinition, self).__init__(**kwargs)
        self.key_vault = key_vault
        self.skip_token = skip_token


class ManagedApi(Resource):
    """The managed api definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param properties: The api resource properties.
    :type properties: ~azure.mgmt.logic.models.ApiResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'ApiResourceProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["ApiResourceProperties"] = None,
        **kwargs
    ):
        super(ManagedApi, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class ManagedApiListResult(msrest.serialization.Model):
    """The list of managed APIs.

    :param value: The managed APIs.
    :type value: list[~azure.mgmt.logic.models.ManagedApi]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedApi]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ManagedApi"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ManagedApiListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkConfiguration(msrest.serialization.Model):
    """The network configuration.

    :param virtual_network_address_space: Gets the virtual network address space.
    :type virtual_network_address_space: str
    :param access_endpoint: The access endpoint.
    :type access_endpoint: ~azure.mgmt.logic.models.IntegrationServiceEnvironmentAccessEndpoint
    :param subnets: The subnets.
    :type subnets: list[~azure.mgmt.logic.models.ResourceReference]
    """

    _attribute_map = {
        'virtual_network_address_space': {'key': 'virtualNetworkAddressSpace', 'type': 'str'},
        'access_endpoint': {'key': 'accessEndpoint', 'type': 'IntegrationServiceEnvironmentAccessEndpoint'},
        'subnets': {'key': 'subnets', 'type': '[ResourceReference]'},
    }

    def __init__(
        self,
        *,
        virtual_network_address_space: Optional[str] = None,
        access_endpoint: Optional["IntegrationServiceEnvironmentAccessEndpoint"] = None,
        subnets: Optional[List["ResourceReference"]] = None,
        **kwargs
    ):
        super(NetworkConfiguration, self).__init__(**kwargs)
        self.virtual_network_address_space = virtual_network_address_space
        self.access_endpoint = access_endpoint
        self.subnets = subnets


class OpenAuthenticationAccessPolicies(msrest.serialization.Model):
    """AuthenticationPolicy of type Open.

    :param policies: Open authentication policies.
    :type policies: dict[str, ~azure.mgmt.logic.models.OpenAuthenticationAccessPolicy]
    """

    _attribute_map = {
        'policies': {'key': 'policies', 'type': '{OpenAuthenticationAccessPolicy}'},
    }

    def __init__(
        self,
        *,
        policies: Optional[Dict[str, "OpenAuthenticationAccessPolicy"]] = None,
        **kwargs
    ):
        super(OpenAuthenticationAccessPolicies, self).__init__(**kwargs)
        self.policies = policies


class OpenAuthenticationAccessPolicy(msrest.serialization.Model):
    """Open authentication access policy defined by user.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Type of provider for OAuth. Possible values include: "AAD".
    :vartype type: str or ~azure.mgmt.logic.models.OpenAuthenticationProviderType
    :param claims: The access policy claims.
    :type claims: list[~azure.mgmt.logic.models.OpenAuthenticationPolicyClaim]
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'claims': {'key': 'claims', 'type': '[OpenAuthenticationPolicyClaim]'},
    }

    def __init__(
        self,
        *,
        claims: Optional[List["OpenAuthenticationPolicyClaim"]] = None,
        **kwargs
    ):
        super(OpenAuthenticationAccessPolicy, self).__init__(**kwargs)
        self.type = None
        self.claims = claims


class OpenAuthenticationPolicyClaim(msrest.serialization.Model):
    """Open authentication policy claim.

    :param name: The name of the claim.
    :type name: str
    :param value: The value of the claim.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(OpenAuthenticationPolicyClaim, self).__init__(**kwargs)
        self.name = name
        self.value = value


class Operation(msrest.serialization.Model):
    """Logic REST API operation.

    :param origin: Operation: origin.
    :type origin: str
    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.logic.models.OperationDisplay
    :param properties: The properties.
    :type properties: object
    """

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        origin: Optional[str] = None,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        properties: Optional[object] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.origin = origin
        self.name = name
        self.display = display
        self.properties = properties


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    :param provider: Service provider: Microsoft.Logic.
    :type provider: str
    :param resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :type resource: str
    :param operation: Operation type: Read, write, delete, etc.
    :type operation: str
    :param description: Operation: description.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Logic operations. It contains a list of operations and a URL link to get the next set of results.

    :param value: List of Logic operations supported by the Logic resource provider.
    :type value: list[~azure.mgmt.logic.models.Operation]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationResultProperties(msrest.serialization.Model):
    """The run operation result properties.

    :param start_time: The start time of the workflow scope repetition.
    :type start_time: ~datetime.datetime
    :param end_time: The end time of the workflow scope repetition.
    :type end_time: ~datetime.datetime
    :param correlation: The correlation properties.
    :type correlation: ~azure.mgmt.logic.models.RunActionCorrelation
    :param status: The status of the workflow scope repetition. Possible values include:
     "NotSpecified", "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended",
     "Cancelled", "Failed", "Faulted", "TimedOut", "Aborted", "Ignored".
    :type status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :param code: The workflow scope repetition code.
    :type code: str
    :param error: Any object.
    :type error: object
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'correlation': {'key': 'correlation', 'type': 'RunActionCorrelation'},
        'status': {'key': 'status', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'error': {'key': 'error', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        correlation: Optional["RunActionCorrelation"] = None,
        status: Optional[Union[str, "WorkflowStatus"]] = None,
        code: Optional[str] = None,
        error: Optional[object] = None,
        **kwargs
    ):
        super(OperationResultProperties, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.correlation = correlation
        self.status = status
        self.code = code
        self.error = error


class OperationResult(OperationResultProperties):
    """The operation result definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param start_time: The start time of the workflow scope repetition.
    :type start_time: ~datetime.datetime
    :param end_time: The end time of the workflow scope repetition.
    :type end_time: ~datetime.datetime
    :param correlation: The correlation properties.
    :type correlation: ~azure.mgmt.logic.models.RunActionCorrelation
    :param status: The status of the workflow scope repetition. Possible values include:
     "NotSpecified", "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended",
     "Cancelled", "Failed", "Faulted", "TimedOut", "Aborted", "Ignored".
    :type status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :param code: The workflow scope repetition code.
    :type code: str
    :param error: Any object.
    :type error: object
    :ivar tracking_id: Gets the tracking id.
    :vartype tracking_id: str
    :ivar inputs: Gets the inputs.
    :vartype inputs: object
    :ivar inputs_link: Gets the link to inputs.
    :vartype inputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar outputs: Gets the outputs.
    :vartype outputs: object
    :ivar outputs_link: Gets the link to outputs.
    :vartype outputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar tracked_properties: Gets the tracked properties.
    :vartype tracked_properties: object
    :param retry_history: Gets the retry histories.
    :type retry_history: list[~azure.mgmt.logic.models.RetryHistory]
    :param iteration_count:
    :type iteration_count: int
    """

    _validation = {
        'tracking_id': {'readonly': True},
        'inputs': {'readonly': True},
        'inputs_link': {'readonly': True},
        'outputs': {'readonly': True},
        'outputs_link': {'readonly': True},
        'tracked_properties': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'correlation': {'key': 'correlation', 'type': 'RunActionCorrelation'},
        'status': {'key': 'status', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'error': {'key': 'error', 'type': 'object'},
        'tracking_id': {'key': 'trackingId', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': 'object'},
        'inputs_link': {'key': 'inputsLink', 'type': 'ContentLink'},
        'outputs': {'key': 'outputs', 'type': 'object'},
        'outputs_link': {'key': 'outputsLink', 'type': 'ContentLink'},
        'tracked_properties': {'key': 'trackedProperties', 'type': 'object'},
        'retry_history': {'key': 'retryHistory', 'type': '[RetryHistory]'},
        'iteration_count': {'key': 'iterationCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        correlation: Optional["RunActionCorrelation"] = None,
        status: Optional[Union[str, "WorkflowStatus"]] = None,
        code: Optional[str] = None,
        error: Optional[object] = None,
        retry_history: Optional[List["RetryHistory"]] = None,
        iteration_count: Optional[int] = None,
        **kwargs
    ):
        super(OperationResult, self).__init__(start_time=start_time, end_time=end_time, correlation=correlation, status=status, code=code, error=error, **kwargs)
        self.tracking_id = None
        self.inputs = None
        self.inputs_link = None
        self.outputs = None
        self.outputs_link = None
        self.tracked_properties = None
        self.retry_history = retry_history
        self.iteration_count = iteration_count


class PartnerContent(msrest.serialization.Model):
    """The integration account partner content.

    :param b2_b: The B2B partner content.
    :type b2_b: ~azure.mgmt.logic.models.B2BPartnerContent
    """

    _attribute_map = {
        'b2_b': {'key': 'b2b', 'type': 'B2BPartnerContent'},
    }

    def __init__(
        self,
        *,
        b2_b: Optional["B2BPartnerContent"] = None,
        **kwargs
    ):
        super(PartnerContent, self).__init__(**kwargs)
        self.b2_b = b2_b


class RecurrenceSchedule(msrest.serialization.Model):
    """The recurrence schedule.

    :param minutes: The minutes.
    :type minutes: list[int]
    :param hours: The hours.
    :type hours: list[int]
    :param week_days: The days of the week.
    :type week_days: list[str or ~azure.mgmt.logic.models.DaysOfWeek]
    :param month_days: The month days.
    :type month_days: list[int]
    :param monthly_occurrences: The monthly occurrences.
    :type monthly_occurrences: list[~azure.mgmt.logic.models.RecurrenceScheduleOccurrence]
    """

    _attribute_map = {
        'minutes': {'key': 'minutes', 'type': '[int]'},
        'hours': {'key': 'hours', 'type': '[int]'},
        'week_days': {'key': 'weekDays', 'type': '[str]'},
        'month_days': {'key': 'monthDays', 'type': '[int]'},
        'monthly_occurrences': {'key': 'monthlyOccurrences', 'type': '[RecurrenceScheduleOccurrence]'},
    }

    def __init__(
        self,
        *,
        minutes: Optional[List[int]] = None,
        hours: Optional[List[int]] = None,
        week_days: Optional[List[Union[str, "DaysOfWeek"]]] = None,
        month_days: Optional[List[int]] = None,
        monthly_occurrences: Optional[List["RecurrenceScheduleOccurrence"]] = None,
        **kwargs
    ):
        super(RecurrenceSchedule, self).__init__(**kwargs)
        self.minutes = minutes
        self.hours = hours
        self.week_days = week_days
        self.month_days = month_days
        self.monthly_occurrences = monthly_occurrences


class RecurrenceScheduleOccurrence(msrest.serialization.Model):
    """The recurrence schedule occurrence.

    :param day: The day of the week. Possible values include: "Sunday", "Monday", "Tuesday",
     "Wednesday", "Thursday", "Friday", "Saturday".
    :type day: str or ~azure.mgmt.logic.models.DayOfWeek
    :param occurrence: The occurrence.
    :type occurrence: int
    """

    _attribute_map = {
        'day': {'key': 'day', 'type': 'str'},
        'occurrence': {'key': 'occurrence', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        day: Optional[Union[str, "DayOfWeek"]] = None,
        occurrence: Optional[int] = None,
        **kwargs
    ):
        super(RecurrenceScheduleOccurrence, self).__init__(**kwargs)
        self.day = day
        self.occurrence = occurrence


class RegenerateActionParameter(msrest.serialization.Model):
    """The access key regenerate action content.

    :param key_type: The key type. Possible values include: "NotSpecified", "Primary", "Secondary".
    :type key_type: str or ~azure.mgmt.logic.models.KeyType
    """

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_type: Optional[Union[str, "KeyType"]] = None,
        **kwargs
    ):
        super(RegenerateActionParameter, self).__init__(**kwargs)
        self.key_type = key_type


class RepetitionIndex(msrest.serialization.Model):
    """The workflow run action repetition index.

    All required parameters must be populated in order to send to Azure.

    :param scope_name: The scope.
    :type scope_name: str
    :param item_index: Required. The index.
    :type item_index: int
    """

    _validation = {
        'item_index': {'required': True},
    }

    _attribute_map = {
        'scope_name': {'key': 'scopeName', 'type': 'str'},
        'item_index': {'key': 'itemIndex', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        item_index: int,
        scope_name: Optional[str] = None,
        **kwargs
    ):
        super(RepetitionIndex, self).__init__(**kwargs)
        self.scope_name = scope_name
        self.item_index = item_index


class Request(msrest.serialization.Model):
    """A request.

    :param headers: A list of all the headers attached to the request.
    :type headers: object
    :param uri: The destination for the request.
    :type uri: str
    :param method: The HTTP method used for the request.
    :type method: str
    """

    _attribute_map = {
        'headers': {'key': 'headers', 'type': 'object'},
        'uri': {'key': 'uri', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        headers: Optional[object] = None,
        uri: Optional[str] = None,
        method: Optional[str] = None,
        **kwargs
    ):
        super(Request, self).__init__(**kwargs)
        self.headers = headers
        self.uri = uri
        self.method = method


class RequestHistory(Resource):
    """The request history.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param properties: The request history properties.
    :type properties: ~azure.mgmt.logic.models.RequestHistoryProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'RequestHistoryProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["RequestHistoryProperties"] = None,
        **kwargs
    ):
        super(RequestHistory, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class RequestHistoryListResult(msrest.serialization.Model):
    """The list of workflow request histories.

    :param value: A list of workflow request histories.
    :type value: list[~azure.mgmt.logic.models.RequestHistory]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RequestHistory]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RequestHistory"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RequestHistoryListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RequestHistoryProperties(msrest.serialization.Model):
    """The request history.

    :param start_time: The time the request started.
    :type start_time: ~datetime.datetime
    :param end_time: The time the request ended.
    :type end_time: ~datetime.datetime
    :param request: The request.
    :type request: ~azure.mgmt.logic.models.Request
    :param response: The response.
    :type response: ~azure.mgmt.logic.models.Response
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'request': {'key': 'request', 'type': 'Request'},
        'response': {'key': 'response', 'type': 'Response'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        request: Optional["Request"] = None,
        response: Optional["Response"] = None,
        **kwargs
    ):
        super(RequestHistoryProperties, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.request = request
        self.response = response


class Response(msrest.serialization.Model):
    """A response.

    :param headers: A list of all the headers attached to the response.
    :type headers: object
    :param status_code: The status code of the response.
    :type status_code: int
    :param body_link: Details on the location of the body content.
    :type body_link: ~azure.mgmt.logic.models.ContentLink
    """

    _attribute_map = {
        'headers': {'key': 'headers', 'type': 'object'},
        'status_code': {'key': 'statusCode', 'type': 'int'},
        'body_link': {'key': 'bodyLink', 'type': 'ContentLink'},
    }

    def __init__(
        self,
        *,
        headers: Optional[object] = None,
        status_code: Optional[int] = None,
        body_link: Optional["ContentLink"] = None,
        **kwargs
    ):
        super(Response, self).__init__(**kwargs)
        self.headers = headers
        self.status_code = status_code
        self.body_link = body_link


class RetryHistory(msrest.serialization.Model):
    """The retry history.

    :param start_time: Gets the start time.
    :type start_time: ~datetime.datetime
    :param end_time: Gets the end time.
    :type end_time: ~datetime.datetime
    :param code: Gets the status code.
    :type code: str
    :param client_request_id: Gets the client request Id.
    :type client_request_id: str
    :param service_request_id: Gets the service request Id.
    :type service_request_id: str
    :param error: Gets the error response.
    :type error: ~azure.mgmt.logic.models.ErrorResponse
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'code': {'key': 'code', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'service_request_id': {'key': 'serviceRequestId', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        code: Optional[str] = None,
        client_request_id: Optional[str] = None,
        service_request_id: Optional[str] = None,
        error: Optional["ErrorResponse"] = None,
        **kwargs
    ):
        super(RetryHistory, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.code = code
        self.client_request_id = client_request_id
        self.service_request_id = service_request_id
        self.error = error


class RunCorrelation(msrest.serialization.Model):
    """The correlation properties.

    :param client_tracking_id: The client tracking identifier.
    :type client_tracking_id: str
    :param client_keywords: The client keywords.
    :type client_keywords: list[str]
    """

    _attribute_map = {
        'client_tracking_id': {'key': 'clientTrackingId', 'type': 'str'},
        'client_keywords': {'key': 'clientKeywords', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        client_tracking_id: Optional[str] = None,
        client_keywords: Optional[List[str]] = None,
        **kwargs
    ):
        super(RunCorrelation, self).__init__(**kwargs)
        self.client_tracking_id = client_tracking_id
        self.client_keywords = client_keywords


class RunActionCorrelation(RunCorrelation):
    """The workflow run action correlation properties.

    :param client_tracking_id: The client tracking identifier.
    :type client_tracking_id: str
    :param client_keywords: The client keywords.
    :type client_keywords: list[str]
    :param action_tracking_id: The action tracking identifier.
    :type action_tracking_id: str
    """

    _attribute_map = {
        'client_tracking_id': {'key': 'clientTrackingId', 'type': 'str'},
        'client_keywords': {'key': 'clientKeywords', 'type': '[str]'},
        'action_tracking_id': {'key': 'actionTrackingId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_tracking_id: Optional[str] = None,
        client_keywords: Optional[List[str]] = None,
        action_tracking_id: Optional[str] = None,
        **kwargs
    ):
        super(RunActionCorrelation, self).__init__(client_tracking_id=client_tracking_id, client_keywords=client_keywords, **kwargs)
        self.action_tracking_id = action_tracking_id


class SetTriggerStateActionDefinition(msrest.serialization.Model):
    """The set trigger state action definition.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. The source.
    :type source: ~azure.mgmt.logic.models.WorkflowTriggerReference
    """

    _validation = {
        'source': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'WorkflowTriggerReference'},
    }

    def __init__(
        self,
        *,
        source: "WorkflowTriggerReference",
        **kwargs
    ):
        super(SetTriggerStateActionDefinition, self).__init__(**kwargs)
        self.source = source


class Sku(msrest.serialization.Model):
    """The sku type.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name. Possible values include: "NotSpecified", "Free", "Shared",
     "Basic", "Standard", "Premium".
    :type name: str or ~azure.mgmt.logic.models.SkuName
    :param plan: The reference to plan.
    :type plan: ~azure.mgmt.logic.models.ResourceReference
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'plan': {'key': 'plan', 'type': 'ResourceReference'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "SkuName"],
        plan: Optional["ResourceReference"] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.plan = plan


class SubResource(msrest.serialization.Model):
    """The sub resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = None


class SwaggerCustomDynamicList(msrest.serialization.Model):
    """The swagger custom dynamic list.

    :param operation_id: The operation id to fetch dynamic schema.
    :type operation_id: str
    :param built_in_operation: The built in operation.
    :type built_in_operation: str
    :param items_path: The path to a response property (relative to the response object, not the
     response body) which contains an array of dynamic value items.
    :type items_path: str
    :param item_value_path: The path to a property which defines the value which should be used.
    :type item_value_path: str
    :param item_title_path: The path to an item property which defines the display name of the
     item.
    :type item_title_path: str
    :param parameters: The parameters.
    :type parameters: dict[str, ~azure.mgmt.logic.models.SwaggerCustomDynamicProperties]
    """

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'built_in_operation': {'key': 'builtInOperation', 'type': 'str'},
        'items_path': {'key': 'itemsPath', 'type': 'str'},
        'item_value_path': {'key': 'itemValuePath', 'type': 'str'},
        'item_title_path': {'key': 'itemTitlePath', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{SwaggerCustomDynamicProperties}'},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        built_in_operation: Optional[str] = None,
        items_path: Optional[str] = None,
        item_value_path: Optional[str] = None,
        item_title_path: Optional[str] = None,
        parameters: Optional[Dict[str, "SwaggerCustomDynamicProperties"]] = None,
        **kwargs
    ):
        super(SwaggerCustomDynamicList, self).__init__(**kwargs)
        self.operation_id = operation_id
        self.built_in_operation = built_in_operation
        self.items_path = items_path
        self.item_value_path = item_value_path
        self.item_title_path = item_title_path
        self.parameters = parameters


class SwaggerCustomDynamicProperties(msrest.serialization.Model):
    """The swagger custom dynamic properties.

    :param operation_id: The operation id to fetch dynamic schema.
    :type operation_id: str
    :param value_path: Json pointer to the dynamic schema on the response body.
    :type value_path: str
    :param parameters: The operation parameters.
    :type parameters: dict[str, ~azure.mgmt.logic.models.SwaggerCustomDynamicProperties]
    """

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'value_path': {'key': 'valuePath', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{SwaggerCustomDynamicProperties}'},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        value_path: Optional[str] = None,
        parameters: Optional[Dict[str, "SwaggerCustomDynamicProperties"]] = None,
        **kwargs
    ):
        super(SwaggerCustomDynamicProperties, self).__init__(**kwargs)
        self.operation_id = operation_id
        self.value_path = value_path
        self.parameters = parameters


class SwaggerCustomDynamicSchema(msrest.serialization.Model):
    """The swagger custom dynamic schema.

    :param operation_id: The operation id to fetch dynamic schema.
    :type operation_id: str
    :param value_path: Json pointer to the dynamic schema on the response body.
    :type value_path: str
    :param parameters: The operation parameters.
    :type parameters: dict[str, object]
    """

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'value_path': {'key': 'valuePath', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        value_path: Optional[str] = None,
        parameters: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(SwaggerCustomDynamicSchema, self).__init__(**kwargs)
        self.operation_id = operation_id
        self.value_path = value_path
        self.parameters = parameters


class SwaggerCustomDynamicTree(msrest.serialization.Model):
    """The swagger custom dynamic tree.

    :param settings: The tree settings.
    :type settings: ~azure.mgmt.logic.models.SwaggerCustomDynamicTreeSettings
    :param open: The tree on-open configuration.
    :type open: ~azure.mgmt.logic.models.SwaggerCustomDynamicTreeCommand
    :param browse: The tree on-browse configuration.
    :type browse: ~azure.mgmt.logic.models.SwaggerCustomDynamicTreeCommand
    """

    _attribute_map = {
        'settings': {'key': 'settings', 'type': 'SwaggerCustomDynamicTreeSettings'},
        'open': {'key': 'open', 'type': 'SwaggerCustomDynamicTreeCommand'},
        'browse': {'key': 'browse', 'type': 'SwaggerCustomDynamicTreeCommand'},
    }

    def __init__(
        self,
        *,
        settings: Optional["SwaggerCustomDynamicTreeSettings"] = None,
        open: Optional["SwaggerCustomDynamicTreeCommand"] = None,
        browse: Optional["SwaggerCustomDynamicTreeCommand"] = None,
        **kwargs
    ):
        super(SwaggerCustomDynamicTree, self).__init__(**kwargs)
        self.settings = settings
        self.open = open
        self.browse = browse


class SwaggerCustomDynamicTreeCommand(msrest.serialization.Model):
    """The swagger tree command.

    :param operation_id: The path to an item property which defines the display name of the item.
    :type operation_id: str
    :param items_path: The path to an item property which defines the display name of the item.
    :type items_path: str
    :param item_value_path: The path to an item property which defines the display name of the
     item.
    :type item_value_path: str
    :param item_title_path: The path to an item property which defines the display name of the
     item.
    :type item_title_path: str
    :param item_full_title_path: The path to an item property which defines the display name of the
     item.
    :type item_full_title_path: str
    :param item_is_parent: The path to an item property which defines the display name of the item.
    :type item_is_parent: str
    :param selectable_filter: The path to an item property which defines the display name of the
     item.
    :type selectable_filter: str
    :param parameters: Dictionary of :code:`<SwaggerCustomDynamicTreeParameter>`.
    :type parameters: dict[str, ~azure.mgmt.logic.models.SwaggerCustomDynamicTreeParameter]
    """

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'items_path': {'key': 'itemsPath', 'type': 'str'},
        'item_value_path': {'key': 'itemValuePath', 'type': 'str'},
        'item_title_path': {'key': 'itemTitlePath', 'type': 'str'},
        'item_full_title_path': {'key': 'itemFullTitlePath', 'type': 'str'},
        'item_is_parent': {'key': 'itemIsParent', 'type': 'str'},
        'selectable_filter': {'key': 'selectableFilter', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{SwaggerCustomDynamicTreeParameter}'},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        items_path: Optional[str] = None,
        item_value_path: Optional[str] = None,
        item_title_path: Optional[str] = None,
        item_full_title_path: Optional[str] = None,
        item_is_parent: Optional[str] = None,
        selectable_filter: Optional[str] = None,
        parameters: Optional[Dict[str, "SwaggerCustomDynamicTreeParameter"]] = None,
        **kwargs
    ):
        super(SwaggerCustomDynamicTreeCommand, self).__init__(**kwargs)
        self.operation_id = operation_id
        self.items_path = items_path
        self.item_value_path = item_value_path
        self.item_title_path = item_title_path
        self.item_full_title_path = item_full_title_path
        self.item_is_parent = item_is_parent
        self.selectable_filter = selectable_filter
        self.parameters = parameters


class SwaggerCustomDynamicTreeParameter(msrest.serialization.Model):
    """The swagger custom dynamic tree parameter.

    :param selected_item_value_path: Gets or sets a path to a property in the currently selected
     item to pass as a value to a parameter for the given operation.
    :type selected_item_value_path: str
    :param value: The parameter value.
    :type value: object
    :param parameter_reference: The parameter reference.
    :type parameter_reference: str
    :param required: Indicates whether the parameter is required.
    :type required: bool
    """

    _attribute_map = {
        'selected_item_value_path': {'key': 'selectedItemValuePath', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'parameter_reference': {'key': 'parameterReference', 'type': 'str'},
        'required': {'key': 'required', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        selected_item_value_path: Optional[str] = None,
        value: Optional[object] = None,
        parameter_reference: Optional[str] = None,
        required: Optional[bool] = None,
        **kwargs
    ):
        super(SwaggerCustomDynamicTreeParameter, self).__init__(**kwargs)
        self.selected_item_value_path = selected_item_value_path
        self.value = value
        self.parameter_reference = parameter_reference
        self.required = required


class SwaggerCustomDynamicTreeSettings(msrest.serialization.Model):
    """The swagger custom dynamic tree settings.

    :param can_select_parent_nodes: Indicates whether parent nodes can be selected.
    :type can_select_parent_nodes: bool
    :param can_select_leaf_nodes: Indicates whether leaf nodes can be selected.
    :type can_select_leaf_nodes: bool
    """

    _attribute_map = {
        'can_select_parent_nodes': {'key': 'CanSelectParentNodes', 'type': 'bool'},
        'can_select_leaf_nodes': {'key': 'CanSelectLeafNodes', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        can_select_parent_nodes: Optional[bool] = None,
        can_select_leaf_nodes: Optional[bool] = None,
        **kwargs
    ):
        super(SwaggerCustomDynamicTreeSettings, self).__init__(**kwargs)
        self.can_select_parent_nodes = can_select_parent_nodes
        self.can_select_leaf_nodes = can_select_leaf_nodes


class SwaggerExternalDocumentation(msrest.serialization.Model):
    """The swagger external documentation.

    :param description: The document description.
    :type description: str
    :param uri: The documentation Uri.
    :type uri: str
    :param extensions: The vendor extensions.
    :type extensions: dict[str, object]
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'extensions': {'key': 'extensions', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        uri: Optional[str] = None,
        extensions: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(SwaggerExternalDocumentation, self).__init__(**kwargs)
        self.description = description
        self.uri = uri
        self.extensions = extensions


class SwaggerSchema(msrest.serialization.Model):
    """The swagger schema.

    :param ref: The reference.
    :type ref: str
    :param type: The type. Possible values include: "String", "Number", "Integer", "Boolean",
     "Array", "File", "Object", "Null".
    :type type: str or ~azure.mgmt.logic.models.SwaggerSchemaType
    :param title: The title.
    :type title: str
    :param items: The items schema.
    :type items: ~azure.mgmt.logic.models.SwaggerSchema
    :param properties: The object properties.
    :type properties: dict[str, ~azure.mgmt.logic.models.SwaggerSchema]
    :param additional_properties: The additional properties.
    :type additional_properties: object
    :param required: The object required properties.
    :type required: list[str]
    :param max_properties: The maximum number of allowed properties.
    :type max_properties: int
    :param min_properties: The minimum number of allowed properties.
    :type min_properties: int
    :param all_of: The schemas which must pass validation when this schema is used.
    :type all_of: list[~azure.mgmt.logic.models.SwaggerSchema]
    :param discriminator: The discriminator.
    :type discriminator: str
    :param read_only: Indicates whether this property must be present in the a request.
    :type read_only: bool
    :param xml: The xml representation format for a property.
    :type xml: ~azure.mgmt.logic.models.SwaggerXml
    :param external_docs: The external documentation.
    :type external_docs: ~azure.mgmt.logic.models.SwaggerExternalDocumentation
    :param example: The example value.
    :type example: object
    :param notification_url_extension: Indicates the notification url extension. If this is set,
     the property's value should be a callback url for a webhook.
    :type notification_url_extension: bool
    :param dynamic_schema_old: The dynamic schema configuration.
    :type dynamic_schema_old: ~azure.mgmt.logic.models.SwaggerCustomDynamicSchema
    :param dynamic_schema_new: The dynamic schema configuration.
    :type dynamic_schema_new: ~azure.mgmt.logic.models.SwaggerCustomDynamicProperties
    :param dynamic_list_new: The dynamic list.
    :type dynamic_list_new: ~azure.mgmt.logic.models.SwaggerCustomDynamicList
    :param dynamic_tree: The dynamic values tree configuration.
    :type dynamic_tree: ~azure.mgmt.logic.models.SwaggerCustomDynamicTree
    """

    _attribute_map = {
        'ref': {'key': 'ref', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'items': {'key': 'items', 'type': 'SwaggerSchema'},
        'properties': {'key': 'properties', 'type': '{SwaggerSchema}'},
        'additional_properties': {'key': 'additionalProperties', 'type': 'object'},
        'required': {'key': 'required', 'type': '[str]'},
        'max_properties': {'key': 'maxProperties', 'type': 'int'},
        'min_properties': {'key': 'minProperties', 'type': 'int'},
        'all_of': {'key': 'allOf', 'type': '[SwaggerSchema]'},
        'discriminator': {'key': 'discriminator', 'type': 'str'},
        'read_only': {'key': 'readOnly', 'type': 'bool'},
        'xml': {'key': 'xml', 'type': 'SwaggerXml'},
        'external_docs': {'key': 'externalDocs', 'type': 'SwaggerExternalDocumentation'},
        'example': {'key': 'example', 'type': 'object'},
        'notification_url_extension': {'key': 'notificationUrlExtension', 'type': 'bool'},
        'dynamic_schema_old': {'key': 'dynamicSchemaOld', 'type': 'SwaggerCustomDynamicSchema'},
        'dynamic_schema_new': {'key': 'dynamicSchemaNew', 'type': 'SwaggerCustomDynamicProperties'},
        'dynamic_list_new': {'key': 'dynamicListNew', 'type': 'SwaggerCustomDynamicList'},
        'dynamic_tree': {'key': 'dynamicTree', 'type': 'SwaggerCustomDynamicTree'},
    }

    def __init__(
        self,
        *,
        ref: Optional[str] = None,
        type: Optional[Union[str, "SwaggerSchemaType"]] = None,
        title: Optional[str] = None,
        items: Optional["SwaggerSchema"] = None,
        properties: Optional[Dict[str, "SwaggerSchema"]] = None,
        additional_properties: Optional[object] = None,
        required: Optional[List[str]] = None,
        max_properties: Optional[int] = None,
        min_properties: Optional[int] = None,
        all_of: Optional[List["SwaggerSchema"]] = None,
        discriminator: Optional[str] = None,
        read_only: Optional[bool] = None,
        xml: Optional["SwaggerXml"] = None,
        external_docs: Optional["SwaggerExternalDocumentation"] = None,
        example: Optional[object] = None,
        notification_url_extension: Optional[bool] = None,
        dynamic_schema_old: Optional["SwaggerCustomDynamicSchema"] = None,
        dynamic_schema_new: Optional["SwaggerCustomDynamicProperties"] = None,
        dynamic_list_new: Optional["SwaggerCustomDynamicList"] = None,
        dynamic_tree: Optional["SwaggerCustomDynamicTree"] = None,
        **kwargs
    ):
        super(SwaggerSchema, self).__init__(**kwargs)
        self.ref = ref
        self.type = type
        self.title = title
        self.items = items
        self.properties = properties
        self.additional_properties = additional_properties
        self.required = required
        self.max_properties = max_properties
        self.min_properties = min_properties
        self.all_of = all_of
        self.discriminator = discriminator
        self.read_only = read_only
        self.xml = xml
        self.external_docs = external_docs
        self.example = example
        self.notification_url_extension = notification_url_extension
        self.dynamic_schema_old = dynamic_schema_old
        self.dynamic_schema_new = dynamic_schema_new
        self.dynamic_list_new = dynamic_list_new
        self.dynamic_tree = dynamic_tree


class SwaggerXml(msrest.serialization.Model):
    """The Swagger XML.

    :param name: The xml element or attribute name.
    :type name: str
    :param namespace: The xml namespace.
    :type namespace: str
    :param prefix: The name prefix.
    :type prefix: str
    :param attribute: Indicates whether the property should be an attribute instead of an element.
    :type attribute: bool
    :param wrapped: Indicates whether the array elements are wrapped in a container element.
    :type wrapped: bool
    :param extensions: The vendor extensions.
    :type extensions: dict[str, object]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'prefix': {'key': 'prefix', 'type': 'str'},
        'attribute': {'key': 'attribute', 'type': 'bool'},
        'wrapped': {'key': 'wrapped', 'type': 'bool'},
        'extensions': {'key': 'extensions', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        namespace: Optional[str] = None,
        prefix: Optional[str] = None,
        attribute: Optional[bool] = None,
        wrapped: Optional[bool] = None,
        extensions: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(SwaggerXml, self).__init__(**kwargs)
        self.name = name
        self.namespace = namespace
        self.prefix = prefix
        self.attribute = attribute
        self.wrapped = wrapped
        self.extensions = extensions


class TrackingEvent(msrest.serialization.Model):
    """The tracking event.

    All required parameters must be populated in order to send to Azure.

    :param event_level: Required. The event level. Possible values include: "LogAlways",
     "Critical", "Error", "Warning", "Informational", "Verbose".
    :type event_level: str or ~azure.mgmt.logic.models.EventLevel
    :param event_time: Required. The event time.
    :type event_time: ~datetime.datetime
    :param record_type: Required. The record type. Possible values include: "NotSpecified",
     "Custom", "AS2Message", "AS2MDN", "X12Interchange", "X12FunctionalGroup", "X12TransactionSet",
     "X12InterchangeAcknowledgment", "X12FunctionalGroupAcknowledgment",
     "X12TransactionSetAcknowledgment", "EdifactInterchange", "EdifactFunctionalGroup",
     "EdifactTransactionSet", "EdifactInterchangeAcknowledgment",
     "EdifactFunctionalGroupAcknowledgment", "EdifactTransactionSetAcknowledgment".
    :type record_type: str or ~azure.mgmt.logic.models.TrackingRecordType
    :param record: The record.
    :type record: object
    :param error: The error.
    :type error: ~azure.mgmt.logic.models.TrackingEventErrorInfo
    """

    _validation = {
        'event_level': {'required': True},
        'event_time': {'required': True},
        'record_type': {'required': True},
    }

    _attribute_map = {
        'event_level': {'key': 'eventLevel', 'type': 'str'},
        'event_time': {'key': 'eventTime', 'type': 'iso-8601'},
        'record_type': {'key': 'recordType', 'type': 'str'},
        'record': {'key': 'record', 'type': 'object'},
        'error': {'key': 'error', 'type': 'TrackingEventErrorInfo'},
    }

    def __init__(
        self,
        *,
        event_level: Union[str, "EventLevel"],
        event_time: datetime.datetime,
        record_type: Union[str, "TrackingRecordType"],
        record: Optional[object] = None,
        error: Optional["TrackingEventErrorInfo"] = None,
        **kwargs
    ):
        super(TrackingEvent, self).__init__(**kwargs)
        self.event_level = event_level
        self.event_time = event_time
        self.record_type = record_type
        self.record = record
        self.error = error


class TrackingEventErrorInfo(msrest.serialization.Model):
    """The tracking event error info.

    :param message: The message.
    :type message: str
    :param code: The code.
    :type code: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        code: Optional[str] = None,
        **kwargs
    ):
        super(TrackingEventErrorInfo, self).__init__(**kwargs)
        self.message = message
        self.code = code


class TrackingEventsDefinition(msrest.serialization.Model):
    """The tracking events definition.

    All required parameters must be populated in order to send to Azure.

    :param source_type: Required. The source type.
    :type source_type: str
    :param track_events_options: The track events options. Possible values include: "None",
     "DisableSourceInfoEnrich".
    :type track_events_options: str or ~azure.mgmt.logic.models.TrackEventsOperationOptions
    :param events: Required. The events.
    :type events: list[~azure.mgmt.logic.models.TrackingEvent]
    """

    _validation = {
        'source_type': {'required': True},
        'events': {'required': True},
    }

    _attribute_map = {
        'source_type': {'key': 'sourceType', 'type': 'str'},
        'track_events_options': {'key': 'trackEventsOptions', 'type': 'str'},
        'events': {'key': 'events', 'type': '[TrackingEvent]'},
    }

    def __init__(
        self,
        *,
        source_type: str,
        events: List["TrackingEvent"],
        track_events_options: Optional[Union[str, "TrackEventsOperationOptions"]] = None,
        **kwargs
    ):
        super(TrackingEventsDefinition, self).__init__(**kwargs)
        self.source_type = source_type
        self.track_events_options = track_events_options
        self.events = events


class Workflow(Resource):
    """The workflow type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :ivar provisioning_state: Gets the provisioning state. Possible values include: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
     "Unregistered", "Completed", "Renewing", "Pending", "Waiting", "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.logic.models.WorkflowProvisioningState
    :ivar created_time: Gets the created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: Gets the changed time.
    :vartype changed_time: ~datetime.datetime
    :param state: The state. Possible values include: "NotSpecified", "Completed", "Enabled",
     "Disabled", "Deleted", "Suspended".
    :type state: str or ~azure.mgmt.logic.models.WorkflowState
    :ivar version: Gets the version.
    :vartype version: str
    :ivar access_endpoint: Gets the access endpoint.
    :vartype access_endpoint: str
    :param endpoints_configuration: The endpoints configuration.
    :type endpoints_configuration: ~azure.mgmt.logic.models.FlowEndpointsConfiguration
    :param access_control: The access control configuration.
    :type access_control: ~azure.mgmt.logic.models.FlowAccessControlConfiguration
    :ivar sku: The sku.
    :vartype sku: ~azure.mgmt.logic.models.Sku
    :param integration_account: The integration account.
    :type integration_account: ~azure.mgmt.logic.models.ResourceReference
    :param integration_service_environment: The integration service environment.
    :type integration_service_environment: ~azure.mgmt.logic.models.ResourceReference
    :param definition: The definition.
    :type definition: object
    :param parameters: The parameters.
    :type parameters: dict[str, ~azure.mgmt.logic.models.WorkflowParameter]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'version': {'readonly': True},
        'access_endpoint': {'readonly': True},
        'sku': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'access_endpoint': {'key': 'properties.accessEndpoint', 'type': 'str'},
        'endpoints_configuration': {'key': 'properties.endpointsConfiguration', 'type': 'FlowEndpointsConfiguration'},
        'access_control': {'key': 'properties.accessControl', 'type': 'FlowAccessControlConfiguration'},
        'sku': {'key': 'properties.sku', 'type': 'Sku'},
        'integration_account': {'key': 'properties.integrationAccount', 'type': 'ResourceReference'},
        'integration_service_environment': {'key': 'properties.integrationServiceEnvironment', 'type': 'ResourceReference'},
        'definition': {'key': 'properties.definition', 'type': 'object'},
        'parameters': {'key': 'properties.parameters', 'type': '{WorkflowParameter}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        state: Optional[Union[str, "WorkflowState"]] = None,
        endpoints_configuration: Optional["FlowEndpointsConfiguration"] = None,
        access_control: Optional["FlowAccessControlConfiguration"] = None,
        integration_account: Optional["ResourceReference"] = None,
        integration_service_environment: Optional["ResourceReference"] = None,
        definition: Optional[object] = None,
        parameters: Optional[Dict[str, "WorkflowParameter"]] = None,
        **kwargs
    ):
        super(Workflow, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.created_time = None
        self.changed_time = None
        self.state = state
        self.version = None
        self.access_endpoint = None
        self.endpoints_configuration = endpoints_configuration
        self.access_control = access_control
        self.sku = None
        self.integration_account = integration_account
        self.integration_service_environment = integration_service_environment
        self.definition = definition
        self.parameters = parameters


class WorkflowFilter(msrest.serialization.Model):
    """The workflow filter.

    :param state: The state of workflows. Possible values include: "NotSpecified", "Completed",
     "Enabled", "Disabled", "Deleted", "Suspended".
    :type state: str or ~azure.mgmt.logic.models.WorkflowState
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "WorkflowState"]] = None,
        **kwargs
    ):
        super(WorkflowFilter, self).__init__(**kwargs)
        self.state = state


class WorkflowListResult(msrest.serialization.Model):
    """The list of workflows.

    :param value: The list of workflows.
    :type value: list[~azure.mgmt.logic.models.Workflow]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Workflow]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Workflow"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(WorkflowListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkflowParameter(msrest.serialization.Model):
    """The workflow parameters.

    :param type: The type. Possible values include: "NotSpecified", "String", "SecureString",
     "Int", "Float", "Bool", "Array", "Object", "SecureObject".
    :type type: str or ~azure.mgmt.logic.models.ParameterType
    :param value: The value.
    :type value: object
    :param metadata: The metadata.
    :type metadata: object
    :param description: The description.
    :type description: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ParameterType"]] = None,
        value: Optional[object] = None,
        metadata: Optional[object] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(WorkflowParameter, self).__init__(**kwargs)
        self.type = type
        self.value = value
        self.metadata = metadata
        self.description = description


class WorkflowOutputParameter(WorkflowParameter):
    """The workflow output parameter.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type: The type. Possible values include: "NotSpecified", "String", "SecureString",
     "Int", "Float", "Bool", "Array", "Object", "SecureObject".
    :type type: str or ~azure.mgmt.logic.models.ParameterType
    :param value: The value.
    :type value: object
    :param metadata: The metadata.
    :type metadata: object
    :param description: The description.
    :type description: str
    :ivar error: Gets the error.
    :vartype error: object
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'description': {'key': 'description', 'type': 'str'},
        'error': {'key': 'error', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ParameterType"]] = None,
        value: Optional[object] = None,
        metadata: Optional[object] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(WorkflowOutputParameter, self).__init__(type=type, value=value, metadata=metadata, description=description, **kwargs)
        self.error = None


class WorkflowReference(ResourceReference):
    """The workflow reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: The resource id.
    :type id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(WorkflowReference, self).__init__(id=id, **kwargs)


class WorkflowRun(SubResource):
    """The workflow run.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the workflow run name.
    :vartype name: str
    :ivar type: Gets the workflow run type.
    :vartype type: str
    :ivar wait_end_time: Gets the wait end time.
    :vartype wait_end_time: ~datetime.datetime
    :ivar start_time: Gets the start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets the end time.
    :vartype end_time: ~datetime.datetime
    :ivar status: Gets the status. Possible values include: "NotSpecified", "Paused", "Running",
     "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed", "Faulted", "TimedOut",
     "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :ivar code: Gets the code.
    :vartype code: str
    :ivar error: Gets the error.
    :vartype error: object
    :ivar correlation_id: Gets the correlation id.
    :vartype correlation_id: str
    :param correlation: The run correlation.
    :type correlation: ~azure.mgmt.logic.models.Correlation
    :ivar workflow: Gets the reference to workflow version.
    :vartype workflow: ~azure.mgmt.logic.models.ResourceReference
    :ivar trigger: Gets the fired trigger.
    :vartype trigger: ~azure.mgmt.logic.models.WorkflowRunTrigger
    :ivar outputs: Gets the outputs.
    :vartype outputs: dict[str, ~azure.mgmt.logic.models.WorkflowOutputParameter]
    :ivar response: Gets the response of the flow run.
    :vartype response: ~azure.mgmt.logic.models.WorkflowRunTrigger
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'wait_end_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'status': {'readonly': True},
        'code': {'readonly': True},
        'error': {'readonly': True},
        'correlation_id': {'readonly': True},
        'workflow': {'readonly': True},
        'trigger': {'readonly': True},
        'outputs': {'readonly': True},
        'response': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'wait_end_time': {'key': 'properties.waitEndTime', 'type': 'iso-8601'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'code': {'key': 'properties.code', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'object'},
        'correlation_id': {'key': 'properties.correlationId', 'type': 'str'},
        'correlation': {'key': 'properties.correlation', 'type': 'Correlation'},
        'workflow': {'key': 'properties.workflow', 'type': 'ResourceReference'},
        'trigger': {'key': 'properties.trigger', 'type': 'WorkflowRunTrigger'},
        'outputs': {'key': 'properties.outputs', 'type': '{WorkflowOutputParameter}'},
        'response': {'key': 'properties.response', 'type': 'WorkflowRunTrigger'},
    }

    def __init__(
        self,
        *,
        correlation: Optional["Correlation"] = None,
        **kwargs
    ):
        super(WorkflowRun, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.wait_end_time = None
        self.start_time = None
        self.end_time = None
        self.status = None
        self.code = None
        self.error = None
        self.correlation_id = None
        self.correlation = correlation
        self.workflow = None
        self.trigger = None
        self.outputs = None
        self.response = None


class WorkflowRunAction(SubResource):
    """The workflow run action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the workflow run action name.
    :vartype name: str
    :ivar type: Gets the workflow run action type.
    :vartype type: str
    :ivar start_time: Gets the start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets the end time.
    :vartype end_time: ~datetime.datetime
    :ivar status: Gets the status. Possible values include: "NotSpecified", "Paused", "Running",
     "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed", "Faulted", "TimedOut",
     "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :ivar code: Gets the code.
    :vartype code: str
    :ivar error: Gets the error.
    :vartype error: object
    :ivar tracking_id: Gets the tracking id.
    :vartype tracking_id: str
    :param correlation: The correlation properties.
    :type correlation: ~azure.mgmt.logic.models.RunActionCorrelation
    :ivar inputs_link: Gets the link to inputs.
    :vartype inputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar outputs_link: Gets the link to outputs.
    :vartype outputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar tracked_properties: Gets the tracked properties.
    :vartype tracked_properties: object
    :param retry_history: Gets the retry histories.
    :type retry_history: list[~azure.mgmt.logic.models.RetryHistory]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'status': {'readonly': True},
        'code': {'readonly': True},
        'error': {'readonly': True},
        'tracking_id': {'readonly': True},
        'inputs_link': {'readonly': True},
        'outputs_link': {'readonly': True},
        'tracked_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'code': {'key': 'properties.code', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'object'},
        'tracking_id': {'key': 'properties.trackingId', 'type': 'str'},
        'correlation': {'key': 'properties.correlation', 'type': 'RunActionCorrelation'},
        'inputs_link': {'key': 'properties.inputsLink', 'type': 'ContentLink'},
        'outputs_link': {'key': 'properties.outputsLink', 'type': 'ContentLink'},
        'tracked_properties': {'key': 'properties.trackedProperties', 'type': 'object'},
        'retry_history': {'key': 'properties.retryHistory', 'type': '[RetryHistory]'},
    }

    def __init__(
        self,
        *,
        correlation: Optional["RunActionCorrelation"] = None,
        retry_history: Optional[List["RetryHistory"]] = None,
        **kwargs
    ):
        super(WorkflowRunAction, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.start_time = None
        self.end_time = None
        self.status = None
        self.code = None
        self.error = None
        self.tracking_id = None
        self.correlation = correlation
        self.inputs_link = None
        self.outputs_link = None
        self.tracked_properties = None
        self.retry_history = retry_history


class WorkflowRunActionFilter(msrest.serialization.Model):
    """The workflow run action filter.

    :param status: The status of workflow run action. Possible values include: "NotSpecified",
     "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed",
     "Faulted", "TimedOut", "Aborted", "Ignored".
    :type status: str or ~azure.mgmt.logic.models.WorkflowStatus
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "WorkflowStatus"]] = None,
        **kwargs
    ):
        super(WorkflowRunActionFilter, self).__init__(**kwargs)
        self.status = status


class WorkflowRunActionListResult(msrest.serialization.Model):
    """The list of workflow run actions.

    :param value: A list of workflow run actions.
    :type value: list[~azure.mgmt.logic.models.WorkflowRunAction]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkflowRunAction]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["WorkflowRunAction"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(WorkflowRunActionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkflowRunActionRepetitionDefinition(Resource):
    """The workflow run action repetition definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param start_time: The start time of the workflow scope repetition.
    :type start_time: ~datetime.datetime
    :param end_time: The end time of the workflow scope repetition.
    :type end_time: ~datetime.datetime
    :param correlation: The correlation properties.
    :type correlation: ~azure.mgmt.logic.models.RunActionCorrelation
    :param status: The status of the workflow scope repetition. Possible values include:
     "NotSpecified", "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended",
     "Cancelled", "Failed", "Faulted", "TimedOut", "Aborted", "Ignored".
    :type status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :param code: The workflow scope repetition code.
    :type code: str
    :param error: Any object.
    :type error: object
    :ivar tracking_id: Gets the tracking id.
    :vartype tracking_id: str
    :ivar inputs: Gets the inputs.
    :vartype inputs: object
    :ivar inputs_link: Gets the link to inputs.
    :vartype inputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar outputs: Gets the outputs.
    :vartype outputs: object
    :ivar outputs_link: Gets the link to outputs.
    :vartype outputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar tracked_properties: Gets the tracked properties.
    :vartype tracked_properties: object
    :param retry_history: Gets the retry histories.
    :type retry_history: list[~azure.mgmt.logic.models.RetryHistory]
    :param iteration_count:
    :type iteration_count: int
    :param repetition_indexes: The repetition indexes.
    :type repetition_indexes: list[~azure.mgmt.logic.models.RepetitionIndex]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tracking_id': {'readonly': True},
        'inputs': {'readonly': True},
        'inputs_link': {'readonly': True},
        'outputs': {'readonly': True},
        'outputs_link': {'readonly': True},
        'tracked_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'correlation': {'key': 'properties.correlation', 'type': 'RunActionCorrelation'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'code': {'key': 'properties.code', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'object'},
        'tracking_id': {'key': 'properties.trackingId', 'type': 'str'},
        'inputs': {'key': 'properties.inputs', 'type': 'object'},
        'inputs_link': {'key': 'properties.inputsLink', 'type': 'ContentLink'},
        'outputs': {'key': 'properties.outputs', 'type': 'object'},
        'outputs_link': {'key': 'properties.outputsLink', 'type': 'ContentLink'},
        'tracked_properties': {'key': 'properties.trackedProperties', 'type': 'object'},
        'retry_history': {'key': 'properties.retryHistory', 'type': '[RetryHistory]'},
        'iteration_count': {'key': 'properties.iterationCount', 'type': 'int'},
        'repetition_indexes': {'key': 'properties.repetitionIndexes', 'type': '[RepetitionIndex]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        correlation: Optional["RunActionCorrelation"] = None,
        status: Optional[Union[str, "WorkflowStatus"]] = None,
        code: Optional[str] = None,
        error: Optional[object] = None,
        retry_history: Optional[List["RetryHistory"]] = None,
        iteration_count: Optional[int] = None,
        repetition_indexes: Optional[List["RepetitionIndex"]] = None,
        **kwargs
    ):
        super(WorkflowRunActionRepetitionDefinition, self).__init__(location=location, tags=tags, **kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.correlation = correlation
        self.status = status
        self.code = code
        self.error = error
        self.tracking_id = None
        self.inputs = None
        self.inputs_link = None
        self.outputs = None
        self.outputs_link = None
        self.tracked_properties = None
        self.retry_history = retry_history
        self.iteration_count = iteration_count
        self.repetition_indexes = repetition_indexes


class WorkflowRunActionRepetitionDefinitionCollection(msrest.serialization.Model):
    """A collection of workflow run action repetitions.

    :param next_link: The link used to get the next page of recommendations.
    :type next_link: str
    :param value:
    :type value: list[~azure.mgmt.logic.models.WorkflowRunActionRepetitionDefinition]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[WorkflowRunActionRepetitionDefinition]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["WorkflowRunActionRepetitionDefinition"]] = None,
        **kwargs
    ):
        super(WorkflowRunActionRepetitionDefinitionCollection, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class WorkflowRunActionRepetitionProperties(OperationResult):
    """The workflow run action repetition properties definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param start_time: The start time of the workflow scope repetition.
    :type start_time: ~datetime.datetime
    :param end_time: The end time of the workflow scope repetition.
    :type end_time: ~datetime.datetime
    :param correlation: The correlation properties.
    :type correlation: ~azure.mgmt.logic.models.RunActionCorrelation
    :param status: The status of the workflow scope repetition. Possible values include:
     "NotSpecified", "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended",
     "Cancelled", "Failed", "Faulted", "TimedOut", "Aborted", "Ignored".
    :type status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :param code: The workflow scope repetition code.
    :type code: str
    :param error: Any object.
    :type error: object
    :ivar tracking_id: Gets the tracking id.
    :vartype tracking_id: str
    :ivar inputs: Gets the inputs.
    :vartype inputs: object
    :ivar inputs_link: Gets the link to inputs.
    :vartype inputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar outputs: Gets the outputs.
    :vartype outputs: object
    :ivar outputs_link: Gets the link to outputs.
    :vartype outputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar tracked_properties: Gets the tracked properties.
    :vartype tracked_properties: object
    :param retry_history: Gets the retry histories.
    :type retry_history: list[~azure.mgmt.logic.models.RetryHistory]
    :param iteration_count:
    :type iteration_count: int
    :param repetition_indexes: The repetition indexes.
    :type repetition_indexes: list[~azure.mgmt.logic.models.RepetitionIndex]
    """

    _validation = {
        'tracking_id': {'readonly': True},
        'inputs': {'readonly': True},
        'inputs_link': {'readonly': True},
        'outputs': {'readonly': True},
        'outputs_link': {'readonly': True},
        'tracked_properties': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'correlation': {'key': 'correlation', 'type': 'RunActionCorrelation'},
        'status': {'key': 'status', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'error': {'key': 'error', 'type': 'object'},
        'tracking_id': {'key': 'trackingId', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': 'object'},
        'inputs_link': {'key': 'inputsLink', 'type': 'ContentLink'},
        'outputs': {'key': 'outputs', 'type': 'object'},
        'outputs_link': {'key': 'outputsLink', 'type': 'ContentLink'},
        'tracked_properties': {'key': 'trackedProperties', 'type': 'object'},
        'retry_history': {'key': 'retryHistory', 'type': '[RetryHistory]'},
        'iteration_count': {'key': 'iterationCount', 'type': 'int'},
        'repetition_indexes': {'key': 'repetitionIndexes', 'type': '[RepetitionIndex]'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        correlation: Optional["RunActionCorrelation"] = None,
        status: Optional[Union[str, "WorkflowStatus"]] = None,
        code: Optional[str] = None,
        error: Optional[object] = None,
        retry_history: Optional[List["RetryHistory"]] = None,
        iteration_count: Optional[int] = None,
        repetition_indexes: Optional[List["RepetitionIndex"]] = None,
        **kwargs
    ):
        super(WorkflowRunActionRepetitionProperties, self).__init__(start_time=start_time, end_time=end_time, correlation=correlation, status=status, code=code, error=error, retry_history=retry_history, iteration_count=iteration_count, **kwargs)
        self.repetition_indexes = repetition_indexes


class WorkflowRunFilter(msrest.serialization.Model):
    """The workflow run filter.

    :param status: The status of workflow run. Possible values include: "NotSpecified", "Paused",
     "Running", "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed", "Faulted",
     "TimedOut", "Aborted", "Ignored".
    :type status: str or ~azure.mgmt.logic.models.WorkflowStatus
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "WorkflowStatus"]] = None,
        **kwargs
    ):
        super(WorkflowRunFilter, self).__init__(**kwargs)
        self.status = status


class WorkflowRunListResult(msrest.serialization.Model):
    """The list of workflow runs.

    :param value: A list of workflow runs.
    :type value: list[~azure.mgmt.logic.models.WorkflowRun]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkflowRun]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["WorkflowRun"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(WorkflowRunListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkflowRunTrigger(msrest.serialization.Model):
    """The workflow run trigger.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Gets the name.
    :vartype name: str
    :ivar inputs: Gets the inputs.
    :vartype inputs: object
    :ivar inputs_link: Gets the link to inputs.
    :vartype inputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar outputs: Gets the outputs.
    :vartype outputs: object
    :ivar outputs_link: Gets the link to outputs.
    :vartype outputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar scheduled_time: Gets the scheduled time.
    :vartype scheduled_time: ~datetime.datetime
    :ivar start_time: Gets the start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets the end time.
    :vartype end_time: ~datetime.datetime
    :ivar tracking_id: Gets the tracking id.
    :vartype tracking_id: str
    :param correlation: The run correlation.
    :type correlation: ~azure.mgmt.logic.models.Correlation
    :ivar code: Gets the code.
    :vartype code: str
    :ivar status: Gets the status. Possible values include: "NotSpecified", "Paused", "Running",
     "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed", "Faulted", "TimedOut",
     "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :ivar error: Gets the error.
    :vartype error: object
    :ivar tracked_properties: Gets the tracked properties.
    :vartype tracked_properties: object
    """

    _validation = {
        'name': {'readonly': True},
        'inputs': {'readonly': True},
        'inputs_link': {'readonly': True},
        'outputs': {'readonly': True},
        'outputs_link': {'readonly': True},
        'scheduled_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'tracking_id': {'readonly': True},
        'code': {'readonly': True},
        'status': {'readonly': True},
        'error': {'readonly': True},
        'tracked_properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': 'object'},
        'inputs_link': {'key': 'inputsLink', 'type': 'ContentLink'},
        'outputs': {'key': 'outputs', 'type': 'object'},
        'outputs_link': {'key': 'outputsLink', 'type': 'ContentLink'},
        'scheduled_time': {'key': 'scheduledTime', 'type': 'iso-8601'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'tracking_id': {'key': 'trackingId', 'type': 'str'},
        'correlation': {'key': 'correlation', 'type': 'Correlation'},
        'code': {'key': 'code', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'object'},
        'tracked_properties': {'key': 'trackedProperties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        correlation: Optional["Correlation"] = None,
        **kwargs
    ):
        super(WorkflowRunTrigger, self).__init__(**kwargs)
        self.name = None
        self.inputs = None
        self.inputs_link = None
        self.outputs = None
        self.outputs_link = None
        self.scheduled_time = None
        self.start_time = None
        self.end_time = None
        self.tracking_id = None
        self.correlation = correlation
        self.code = None
        self.status = None
        self.error = None
        self.tracked_properties = None


class WorkflowTrigger(SubResource):
    """The workflow trigger.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the workflow trigger name.
    :vartype name: str
    :ivar type: Gets the workflow trigger type.
    :vartype type: str
    :ivar provisioning_state: Gets the provisioning state. Possible values include: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
     "Unregistered", "Completed".
    :vartype provisioning_state: str or ~azure.mgmt.logic.models.WorkflowTriggerProvisioningState
    :ivar created_time: Gets the created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: Gets the changed time.
    :vartype changed_time: ~datetime.datetime
    :ivar state: Gets the state. Possible values include: "NotSpecified", "Completed", "Enabled",
     "Disabled", "Deleted", "Suspended".
    :vartype state: str or ~azure.mgmt.logic.models.WorkflowState
    :ivar status: Gets the status. Possible values include: "NotSpecified", "Paused", "Running",
     "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed", "Faulted", "TimedOut",
     "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :ivar last_execution_time: Gets the last execution time.
    :vartype last_execution_time: ~datetime.datetime
    :ivar next_execution_time: Gets the next execution time.
    :vartype next_execution_time: ~datetime.datetime
    :ivar recurrence: Gets the workflow trigger recurrence.
    :vartype recurrence: ~azure.mgmt.logic.models.WorkflowTriggerRecurrence
    :ivar workflow: Gets the reference to workflow.
    :vartype workflow: ~azure.mgmt.logic.models.ResourceReference
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'state': {'readonly': True},
        'status': {'readonly': True},
        'last_execution_time': {'readonly': True},
        'next_execution_time': {'readonly': True},
        'recurrence': {'readonly': True},
        'workflow': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'last_execution_time': {'key': 'properties.lastExecutionTime', 'type': 'iso-8601'},
        'next_execution_time': {'key': 'properties.nextExecutionTime', 'type': 'iso-8601'},
        'recurrence': {'key': 'properties.recurrence', 'type': 'WorkflowTriggerRecurrence'},
        'workflow': {'key': 'properties.workflow', 'type': 'ResourceReference'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkflowTrigger, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.created_time = None
        self.changed_time = None
        self.state = None
        self.status = None
        self.last_execution_time = None
        self.next_execution_time = None
        self.recurrence = None
        self.workflow = None


class WorkflowTriggerCallbackUrl(msrest.serialization.Model):
    """The workflow trigger callback URL.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets the workflow trigger callback URL.
    :vartype value: str
    :ivar method: Gets the workflow trigger callback URL HTTP method.
    :vartype method: str
    :ivar base_path: Gets the workflow trigger callback URL base path.
    :vartype base_path: str
    :ivar relative_path: Gets the workflow trigger callback URL relative path.
    :vartype relative_path: str
    :param relative_path_parameters: Gets the workflow trigger callback URL relative path
     parameters.
    :type relative_path_parameters: list[str]
    :param queries: Gets the workflow trigger callback URL query parameters.
    :type queries: ~azure.mgmt.logic.models.WorkflowTriggerListCallbackUrlQueries
    """

    _validation = {
        'value': {'readonly': True},
        'method': {'readonly': True},
        'base_path': {'readonly': True},
        'relative_path': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'base_path': {'key': 'basePath', 'type': 'str'},
        'relative_path': {'key': 'relativePath', 'type': 'str'},
        'relative_path_parameters': {'key': 'relativePathParameters', 'type': '[str]'},
        'queries': {'key': 'queries', 'type': 'WorkflowTriggerListCallbackUrlQueries'},
    }

    def __init__(
        self,
        *,
        relative_path_parameters: Optional[List[str]] = None,
        queries: Optional["WorkflowTriggerListCallbackUrlQueries"] = None,
        **kwargs
    ):
        super(WorkflowTriggerCallbackUrl, self).__init__(**kwargs)
        self.value = None
        self.method = None
        self.base_path = None
        self.relative_path = None
        self.relative_path_parameters = relative_path_parameters
        self.queries = queries


class WorkflowTriggerFilter(msrest.serialization.Model):
    """The workflow trigger filter.

    :param state: The state of workflow trigger. Possible values include: "NotSpecified",
     "Completed", "Enabled", "Disabled", "Deleted", "Suspended".
    :type state: str or ~azure.mgmt.logic.models.WorkflowState
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "WorkflowState"]] = None,
        **kwargs
    ):
        super(WorkflowTriggerFilter, self).__init__(**kwargs)
        self.state = state


class WorkflowTriggerHistory(SubResource):
    """The workflow trigger history.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the workflow trigger history name.
    :vartype name: str
    :ivar type: Gets the workflow trigger history type.
    :vartype type: str
    :ivar start_time: Gets the start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets the end time.
    :vartype end_time: ~datetime.datetime
    :ivar scheduled_time: The scheduled time.
    :vartype scheduled_time: ~datetime.datetime
    :ivar status: Gets the status. Possible values include: "NotSpecified", "Paused", "Running",
     "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed", "Faulted", "TimedOut",
     "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :ivar code: Gets the code.
    :vartype code: str
    :ivar error: Gets the error.
    :vartype error: object
    :ivar tracking_id: Gets the tracking id.
    :vartype tracking_id: str
    :param correlation: The run correlation.
    :type correlation: ~azure.mgmt.logic.models.Correlation
    :ivar inputs_link: Gets the link to input parameters.
    :vartype inputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar outputs_link: Gets the link to output parameters.
    :vartype outputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar fired: The value indicating whether trigger was fired.
    :vartype fired: bool
    :ivar run: Gets the reference to workflow run.
    :vartype run: ~azure.mgmt.logic.models.ResourceReference
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'scheduled_time': {'readonly': True},
        'status': {'readonly': True},
        'code': {'readonly': True},
        'error': {'readonly': True},
        'tracking_id': {'readonly': True},
        'inputs_link': {'readonly': True},
        'outputs_link': {'readonly': True},
        'fired': {'readonly': True},
        'run': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'scheduled_time': {'key': 'properties.scheduledTime', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'code': {'key': 'properties.code', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'object'},
        'tracking_id': {'key': 'properties.trackingId', 'type': 'str'},
        'correlation': {'key': 'properties.correlation', 'type': 'Correlation'},
        'inputs_link': {'key': 'properties.inputsLink', 'type': 'ContentLink'},
        'outputs_link': {'key': 'properties.outputsLink', 'type': 'ContentLink'},
        'fired': {'key': 'properties.fired', 'type': 'bool'},
        'run': {'key': 'properties.run', 'type': 'ResourceReference'},
    }

    def __init__(
        self,
        *,
        correlation: Optional["Correlation"] = None,
        **kwargs
    ):
        super(WorkflowTriggerHistory, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.start_time = None
        self.end_time = None
        self.scheduled_time = None
        self.status = None
        self.code = None
        self.error = None
        self.tracking_id = None
        self.correlation = correlation
        self.inputs_link = None
        self.outputs_link = None
        self.fired = None
        self.run = None


class WorkflowTriggerHistoryFilter(msrest.serialization.Model):
    """The workflow trigger history filter.

    :param status: The status of workflow trigger history. Possible values include: "NotSpecified",
     "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed",
     "Faulted", "TimedOut", "Aborted", "Ignored".
    :type status: str or ~azure.mgmt.logic.models.WorkflowStatus
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "WorkflowStatus"]] = None,
        **kwargs
    ):
        super(WorkflowTriggerHistoryFilter, self).__init__(**kwargs)
        self.status = status


class WorkflowTriggerHistoryListResult(msrest.serialization.Model):
    """The list of workflow trigger histories.

    :param value: A list of workflow trigger histories.
    :type value: list[~azure.mgmt.logic.models.WorkflowTriggerHistory]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkflowTriggerHistory]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["WorkflowTriggerHistory"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(WorkflowTriggerHistoryListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkflowTriggerListCallbackUrlQueries(msrest.serialization.Model):
    """Gets the workflow trigger callback URL query parameters.

    :param api_version: The api version.
    :type api_version: str
    :param sp: The SAS permissions.
    :type sp: str
    :param sv: The SAS version.
    :type sv: str
    :param sig: The SAS signature.
    :type sig: str
    :param se: The SAS timestamp.
    :type se: str
    """

    _attribute_map = {
        'api_version': {'key': 'api-version', 'type': 'str'},
        'sp': {'key': 'sp', 'type': 'str'},
        'sv': {'key': 'sv', 'type': 'str'},
        'sig': {'key': 'sig', 'type': 'str'},
        'se': {'key': 'se', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        api_version: Optional[str] = None,
        sp: Optional[str] = None,
        sv: Optional[str] = None,
        sig: Optional[str] = None,
        se: Optional[str] = None,
        **kwargs
    ):
        super(WorkflowTriggerListCallbackUrlQueries, self).__init__(**kwargs)
        self.api_version = api_version
        self.sp = sp
        self.sv = sv
        self.sig = sig
        self.se = se


class WorkflowTriggerListResult(msrest.serialization.Model):
    """The list of workflow triggers.

    :param value: A list of workflow triggers.
    :type value: list[~azure.mgmt.logic.models.WorkflowTrigger]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkflowTrigger]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["WorkflowTrigger"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(WorkflowTriggerListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkflowTriggerRecurrence(msrest.serialization.Model):
    """The workflow trigger recurrence.

    :param frequency: The frequency. Possible values include: "NotSpecified", "Second", "Minute",
     "Hour", "Day", "Week", "Month", "Year".
    :type frequency: str or ~azure.mgmt.logic.models.RecurrenceFrequency
    :param interval: The interval.
    :type interval: int
    :param start_time: The start time.
    :type start_time: str
    :param end_time: The end time.
    :type end_time: str
    :param time_zone: The time zone.
    :type time_zone: str
    :param schedule: The recurrence schedule.
    :type schedule: ~azure.mgmt.logic.models.RecurrenceSchedule
    """

    _attribute_map = {
        'frequency': {'key': 'frequency', 'type': 'str'},
        'interval': {'key': 'interval', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'RecurrenceSchedule'},
    }

    def __init__(
        self,
        *,
        frequency: Optional[Union[str, "RecurrenceFrequency"]] = None,
        interval: Optional[int] = None,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        time_zone: Optional[str] = None,
        schedule: Optional["RecurrenceSchedule"] = None,
        **kwargs
    ):
        super(WorkflowTriggerRecurrence, self).__init__(**kwargs)
        self.frequency = frequency
        self.interval = interval
        self.start_time = start_time
        self.end_time = end_time
        self.time_zone = time_zone
        self.schedule = schedule


class WorkflowTriggerReference(ResourceReference):
    """The workflow trigger reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: The resource id.
    :type id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param flow_name: The workflow name.
    :type flow_name: str
    :param trigger_name: The workflow trigger name.
    :type trigger_name: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'flow_name': {'key': 'flowName', 'type': 'str'},
        'trigger_name': {'key': 'triggerName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        flow_name: Optional[str] = None,
        trigger_name: Optional[str] = None,
        **kwargs
    ):
        super(WorkflowTriggerReference, self).__init__(id=id, **kwargs)
        self.flow_name = flow_name
        self.trigger_name = trigger_name


class WorkflowVersion(Resource):
    """The workflow version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :ivar provisioning_state: The provisioning state. Possible values include: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
     "Unregistered", "Completed", "Renewing", "Pending", "Waiting", "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.logic.models.WorkflowProvisioningState
    :ivar created_time: Gets the created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: Gets the changed time.
    :vartype changed_time: ~datetime.datetime
    :param state: The state. Possible values include: "NotSpecified", "Completed", "Enabled",
     "Disabled", "Deleted", "Suspended".
    :type state: str or ~azure.mgmt.logic.models.WorkflowState
    :ivar version: Gets the version.
    :vartype version: str
    :ivar access_endpoint: Gets the access endpoint.
    :vartype access_endpoint: str
    :param endpoints_configuration: The endpoints configuration.
    :type endpoints_configuration: ~azure.mgmt.logic.models.FlowEndpointsConfiguration
    :param access_control: The access control configuration.
    :type access_control: ~azure.mgmt.logic.models.FlowAccessControlConfiguration
    :ivar sku: The sku.
    :vartype sku: ~azure.mgmt.logic.models.Sku
    :param integration_account: The integration account.
    :type integration_account: ~azure.mgmt.logic.models.ResourceReference
    :param definition: The definition.
    :type definition: object
    :param parameters: The parameters.
    :type parameters: dict[str, ~azure.mgmt.logic.models.WorkflowParameter]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'version': {'readonly': True},
        'access_endpoint': {'readonly': True},
        'sku': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'access_endpoint': {'key': 'properties.accessEndpoint', 'type': 'str'},
        'endpoints_configuration': {'key': 'properties.endpointsConfiguration', 'type': 'FlowEndpointsConfiguration'},
        'access_control': {'key': 'properties.accessControl', 'type': 'FlowAccessControlConfiguration'},
        'sku': {'key': 'properties.sku', 'type': 'Sku'},
        'integration_account': {'key': 'properties.integrationAccount', 'type': 'ResourceReference'},
        'definition': {'key': 'properties.definition', 'type': 'object'},
        'parameters': {'key': 'properties.parameters', 'type': '{WorkflowParameter}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        state: Optional[Union[str, "WorkflowState"]] = None,
        endpoints_configuration: Optional["FlowEndpointsConfiguration"] = None,
        access_control: Optional["FlowAccessControlConfiguration"] = None,
        integration_account: Optional["ResourceReference"] = None,
        definition: Optional[object] = None,
        parameters: Optional[Dict[str, "WorkflowParameter"]] = None,
        **kwargs
    ):
        super(WorkflowVersion, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.created_time = None
        self.changed_time = None
        self.state = state
        self.version = None
        self.access_endpoint = None
        self.endpoints_configuration = endpoints_configuration
        self.access_control = access_control
        self.sku = None
        self.integration_account = integration_account
        self.definition = definition
        self.parameters = parameters


class WorkflowVersionListResult(msrest.serialization.Model):
    """The list of workflow versions.

    :param value: A list of workflow versions.
    :type value: list[~azure.mgmt.logic.models.WorkflowVersion]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkflowVersion]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["WorkflowVersion"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(WorkflowVersionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WsdlService(msrest.serialization.Model):
    """The WSDL service.

    :param qualified_name: The qualified name.
    :type qualified_name: str
    :param endpoint_qualified_names: The list of endpoints' qualified names.
    :type endpoint_qualified_names: list[str]
    """

    _attribute_map = {
        'qualified_name': {'key': 'qualifiedName', 'type': 'str'},
        'endpoint_qualified_names': {'key': 'EndpointQualifiedNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        qualified_name: Optional[str] = None,
        endpoint_qualified_names: Optional[List[str]] = None,
        **kwargs
    ):
        super(WsdlService, self).__init__(**kwargs)
        self.qualified_name = qualified_name
        self.endpoint_qualified_names = endpoint_qualified_names


class X12AcknowledgementSettings(msrest.serialization.Model):
    """The X12 agreement acknowledgement settings.

    All required parameters must be populated in order to send to Azure.

    :param need_technical_acknowledgement: Required. The value indicating whether technical
     acknowledgement is needed.
    :type need_technical_acknowledgement: bool
    :param batch_technical_acknowledgements: Required. The value indicating whether to batch the
     technical acknowledgements.
    :type batch_technical_acknowledgements: bool
    :param need_functional_acknowledgement: Required. The value indicating whether functional
     acknowledgement is needed.
    :type need_functional_acknowledgement: bool
    :param functional_acknowledgement_version: The functional acknowledgement version.
    :type functional_acknowledgement_version: str
    :param batch_functional_acknowledgements: Required. The value indicating whether to batch
     functional acknowledgements.
    :type batch_functional_acknowledgements: bool
    :param need_implementation_acknowledgement: Required. The value indicating whether
     implementation acknowledgement is needed.
    :type need_implementation_acknowledgement: bool
    :param implementation_acknowledgement_version: The implementation acknowledgement version.
    :type implementation_acknowledgement_version: str
    :param batch_implementation_acknowledgements: Required. The value indicating whether to batch
     implementation acknowledgements.
    :type batch_implementation_acknowledgements: bool
    :param need_loop_for_valid_messages: Required. The value indicating whether a loop is needed
     for valid messages.
    :type need_loop_for_valid_messages: bool
    :param send_synchronous_acknowledgement: Required. The value indicating whether to send
     synchronous acknowledgement.
    :type send_synchronous_acknowledgement: bool
    :param acknowledgement_control_number_prefix: The acknowledgement control number prefix.
    :type acknowledgement_control_number_prefix: str
    :param acknowledgement_control_number_suffix: The acknowledgement control number suffix.
    :type acknowledgement_control_number_suffix: str
    :param acknowledgement_control_number_lower_bound: Required. The acknowledgement control number
     lower bound.
    :type acknowledgement_control_number_lower_bound: int
    :param acknowledgement_control_number_upper_bound: Required. The acknowledgement control number
     upper bound.
    :type acknowledgement_control_number_upper_bound: int
    :param rollover_acknowledgement_control_number: Required. The value indicating whether to
     rollover acknowledgement control number.
    :type rollover_acknowledgement_control_number: bool
    """

    _validation = {
        'need_technical_acknowledgement': {'required': True},
        'batch_technical_acknowledgements': {'required': True},
        'need_functional_acknowledgement': {'required': True},
        'batch_functional_acknowledgements': {'required': True},
        'need_implementation_acknowledgement': {'required': True},
        'batch_implementation_acknowledgements': {'required': True},
        'need_loop_for_valid_messages': {'required': True},
        'send_synchronous_acknowledgement': {'required': True},
        'acknowledgement_control_number_lower_bound': {'required': True},
        'acknowledgement_control_number_upper_bound': {'required': True},
        'rollover_acknowledgement_control_number': {'required': True},
    }

    _attribute_map = {
        'need_technical_acknowledgement': {'key': 'needTechnicalAcknowledgement', 'type': 'bool'},
        'batch_technical_acknowledgements': {'key': 'batchTechnicalAcknowledgements', 'type': 'bool'},
        'need_functional_acknowledgement': {'key': 'needFunctionalAcknowledgement', 'type': 'bool'},
        'functional_acknowledgement_version': {'key': 'functionalAcknowledgementVersion', 'type': 'str'},
        'batch_functional_acknowledgements': {'key': 'batchFunctionalAcknowledgements', 'type': 'bool'},
        'need_implementation_acknowledgement': {'key': 'needImplementationAcknowledgement', 'type': 'bool'},
        'implementation_acknowledgement_version': {'key': 'implementationAcknowledgementVersion', 'type': 'str'},
        'batch_implementation_acknowledgements': {'key': 'batchImplementationAcknowledgements', 'type': 'bool'},
        'need_loop_for_valid_messages': {'key': 'needLoopForValidMessages', 'type': 'bool'},
        'send_synchronous_acknowledgement': {'key': 'sendSynchronousAcknowledgement', 'type': 'bool'},
        'acknowledgement_control_number_prefix': {'key': 'acknowledgementControlNumberPrefix', 'type': 'str'},
        'acknowledgement_control_number_suffix': {'key': 'acknowledgementControlNumberSuffix', 'type': 'str'},
        'acknowledgement_control_number_lower_bound': {'key': 'acknowledgementControlNumberLowerBound', 'type': 'int'},
        'acknowledgement_control_number_upper_bound': {'key': 'acknowledgementControlNumberUpperBound', 'type': 'int'},
        'rollover_acknowledgement_control_number': {'key': 'rolloverAcknowledgementControlNumber', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        need_technical_acknowledgement: bool,
        batch_technical_acknowledgements: bool,
        need_functional_acknowledgement: bool,
        batch_functional_acknowledgements: bool,
        need_implementation_acknowledgement: bool,
        batch_implementation_acknowledgements: bool,
        need_loop_for_valid_messages: bool,
        send_synchronous_acknowledgement: bool,
        acknowledgement_control_number_lower_bound: int,
        acknowledgement_control_number_upper_bound: int,
        rollover_acknowledgement_control_number: bool,
        functional_acknowledgement_version: Optional[str] = None,
        implementation_acknowledgement_version: Optional[str] = None,
        acknowledgement_control_number_prefix: Optional[str] = None,
        acknowledgement_control_number_suffix: Optional[str] = None,
        **kwargs
    ):
        super(X12AcknowledgementSettings, self).__init__(**kwargs)
        self.need_technical_acknowledgement = need_technical_acknowledgement
        self.batch_technical_acknowledgements = batch_technical_acknowledgements
        self.need_functional_acknowledgement = need_functional_acknowledgement
        self.functional_acknowledgement_version = functional_acknowledgement_version
        self.batch_functional_acknowledgements = batch_functional_acknowledgements
        self.need_implementation_acknowledgement = need_implementation_acknowledgement
        self.implementation_acknowledgement_version = implementation_acknowledgement_version
        self.batch_implementation_acknowledgements = batch_implementation_acknowledgements
        self.need_loop_for_valid_messages = need_loop_for_valid_messages
        self.send_synchronous_acknowledgement = send_synchronous_acknowledgement
        self.acknowledgement_control_number_prefix = acknowledgement_control_number_prefix
        self.acknowledgement_control_number_suffix = acknowledgement_control_number_suffix
        self.acknowledgement_control_number_lower_bound = acknowledgement_control_number_lower_bound
        self.acknowledgement_control_number_upper_bound = acknowledgement_control_number_upper_bound
        self.rollover_acknowledgement_control_number = rollover_acknowledgement_control_number


class X12AgreementContent(msrest.serialization.Model):
    """The X12 agreement content.

    All required parameters must be populated in order to send to Azure.

    :param receive_agreement: Required. The X12 one-way receive agreement.
    :type receive_agreement: ~azure.mgmt.logic.models.X12OneWayAgreement
    :param send_agreement: Required. The X12 one-way send agreement.
    :type send_agreement: ~azure.mgmt.logic.models.X12OneWayAgreement
    """

    _validation = {
        'receive_agreement': {'required': True},
        'send_agreement': {'required': True},
    }

    _attribute_map = {
        'receive_agreement': {'key': 'receiveAgreement', 'type': 'X12OneWayAgreement'},
        'send_agreement': {'key': 'sendAgreement', 'type': 'X12OneWayAgreement'},
    }

    def __init__(
        self,
        *,
        receive_agreement: "X12OneWayAgreement",
        send_agreement: "X12OneWayAgreement",
        **kwargs
    ):
        super(X12AgreementContent, self).__init__(**kwargs)
        self.receive_agreement = receive_agreement
        self.send_agreement = send_agreement


class X12DelimiterOverrides(msrest.serialization.Model):
    """The X12 delimiter override settings.

    All required parameters must be populated in order to send to Azure.

    :param protocol_version: The protocol version.
    :type protocol_version: str
    :param message_id: The message id.
    :type message_id: str
    :param data_element_separator: Required. The data element separator.
    :type data_element_separator: int
    :param component_separator: Required. The component separator.
    :type component_separator: int
    :param segment_terminator: Required. The segment terminator.
    :type segment_terminator: int
    :param segment_terminator_suffix: Required. The segment terminator suffix. Possible values
     include: "NotSpecified", "None", "CR", "LF", "CRLF".
    :type segment_terminator_suffix: str or ~azure.mgmt.logic.models.SegmentTerminatorSuffix
    :param replace_character: Required. The replacement character.
    :type replace_character: int
    :param replace_separators_in_payload: Required. The value indicating whether to replace
     separators in payload.
    :type replace_separators_in_payload: bool
    :param target_namespace: The target namespace on which this delimiter settings has to be
     applied.
    :type target_namespace: str
    """

    _validation = {
        'data_element_separator': {'required': True},
        'component_separator': {'required': True},
        'segment_terminator': {'required': True},
        'segment_terminator_suffix': {'required': True},
        'replace_character': {'required': True},
        'replace_separators_in_payload': {'required': True},
    }

    _attribute_map = {
        'protocol_version': {'key': 'protocolVersion', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'data_element_separator': {'key': 'dataElementSeparator', 'type': 'int'},
        'component_separator': {'key': 'componentSeparator', 'type': 'int'},
        'segment_terminator': {'key': 'segmentTerminator', 'type': 'int'},
        'segment_terminator_suffix': {'key': 'segmentTerminatorSuffix', 'type': 'str'},
        'replace_character': {'key': 'replaceCharacter', 'type': 'int'},
        'replace_separators_in_payload': {'key': 'replaceSeparatorsInPayload', 'type': 'bool'},
        'target_namespace': {'key': 'targetNamespace', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_element_separator: int,
        component_separator: int,
        segment_terminator: int,
        segment_terminator_suffix: Union[str, "SegmentTerminatorSuffix"],
        replace_character: int,
        replace_separators_in_payload: bool,
        protocol_version: Optional[str] = None,
        message_id: Optional[str] = None,
        target_namespace: Optional[str] = None,
        **kwargs
    ):
        super(X12DelimiterOverrides, self).__init__(**kwargs)
        self.protocol_version = protocol_version
        self.message_id = message_id
        self.data_element_separator = data_element_separator
        self.component_separator = component_separator
        self.segment_terminator = segment_terminator
        self.segment_terminator_suffix = segment_terminator_suffix
        self.replace_character = replace_character
        self.replace_separators_in_payload = replace_separators_in_payload
        self.target_namespace = target_namespace


class X12EnvelopeOverride(msrest.serialization.Model):
    """The X12 envelope override settings.

    All required parameters must be populated in order to send to Azure.

    :param target_namespace: Required. The target namespace on which this envelope settings has to
     be applied.
    :type target_namespace: str
    :param protocol_version: Required. The protocol version on which this envelope settings has to
     be applied.
    :type protocol_version: str
    :param message_id: Required. The message id on which this envelope settings has to be applied.
    :type message_id: str
    :param responsible_agency_code: Required. The responsible agency code.
    :type responsible_agency_code: str
    :param header_version: Required. The header version.
    :type header_version: str
    :param sender_application_id: Required. The sender application id.
    :type sender_application_id: str
    :param receiver_application_id: Required. The receiver application id.
    :type receiver_application_id: str
    :param functional_identifier_code: The functional identifier code.
    :type functional_identifier_code: str
    :param date_format: Required. The date format. Possible values include: "NotSpecified",
     "CCYYMMDD", "YYMMDD".
    :type date_format: str or ~azure.mgmt.logic.models.X12DateFormat
    :param time_format: Required. The time format. Possible values include: "NotSpecified", "HHMM",
     "HHMMSS", "HHMMSSdd", "HHMMSSd".
    :type time_format: str or ~azure.mgmt.logic.models.X12TimeFormat
    """

    _validation = {
        'target_namespace': {'required': True},
        'protocol_version': {'required': True},
        'message_id': {'required': True},
        'responsible_agency_code': {'required': True},
        'header_version': {'required': True},
        'sender_application_id': {'required': True},
        'receiver_application_id': {'required': True},
        'date_format': {'required': True},
        'time_format': {'required': True},
    }

    _attribute_map = {
        'target_namespace': {'key': 'targetNamespace', 'type': 'str'},
        'protocol_version': {'key': 'protocolVersion', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'responsible_agency_code': {'key': 'responsibleAgencyCode', 'type': 'str'},
        'header_version': {'key': 'headerVersion', 'type': 'str'},
        'sender_application_id': {'key': 'senderApplicationId', 'type': 'str'},
        'receiver_application_id': {'key': 'receiverApplicationId', 'type': 'str'},
        'functional_identifier_code': {'key': 'functionalIdentifierCode', 'type': 'str'},
        'date_format': {'key': 'dateFormat', 'type': 'str'},
        'time_format': {'key': 'timeFormat', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_namespace: str,
        protocol_version: str,
        message_id: str,
        responsible_agency_code: str,
        header_version: str,
        sender_application_id: str,
        receiver_application_id: str,
        date_format: Union[str, "X12DateFormat"],
        time_format: Union[str, "X12TimeFormat"],
        functional_identifier_code: Optional[str] = None,
        **kwargs
    ):
        super(X12EnvelopeOverride, self).__init__(**kwargs)
        self.target_namespace = target_namespace
        self.protocol_version = protocol_version
        self.message_id = message_id
        self.responsible_agency_code = responsible_agency_code
        self.header_version = header_version
        self.sender_application_id = sender_application_id
        self.receiver_application_id = receiver_application_id
        self.functional_identifier_code = functional_identifier_code
        self.date_format = date_format
        self.time_format = time_format


class X12EnvelopeSettings(msrest.serialization.Model):
    """The X12 agreement envelope settings.

    All required parameters must be populated in order to send to Azure.

    :param control_standards_id: Required. The controls standards id.
    :type control_standards_id: int
    :param use_control_standards_id_as_repetition_character: Required. The value indicating whether
     to use control standards id as repetition character.
    :type use_control_standards_id_as_repetition_character: bool
    :param sender_application_id: Required. The sender application id.
    :type sender_application_id: str
    :param receiver_application_id: Required. The receiver application id.
    :type receiver_application_id: str
    :param control_version_number: Required. The control version number.
    :type control_version_number: str
    :param interchange_control_number_lower_bound: Required. The interchange  control number lower
     bound.
    :type interchange_control_number_lower_bound: int
    :param interchange_control_number_upper_bound: Required. The interchange  control number upper
     bound.
    :type interchange_control_number_upper_bound: int
    :param rollover_interchange_control_number: Required. The value indicating whether to rollover
     interchange control number.
    :type rollover_interchange_control_number: bool
    :param enable_default_group_headers: Required. The value indicating whether to enable default
     group headers.
    :type enable_default_group_headers: bool
    :param functional_group_id: The functional group id.
    :type functional_group_id: str
    :param group_control_number_lower_bound: Required. The group control number lower bound.
    :type group_control_number_lower_bound: int
    :param group_control_number_upper_bound: Required. The group control number upper bound.
    :type group_control_number_upper_bound: int
    :param rollover_group_control_number: Required. The value indicating whether to rollover group
     control number.
    :type rollover_group_control_number: bool
    :param group_header_agency_code: Required. The group header agency code.
    :type group_header_agency_code: str
    :param group_header_version: Required. The group header version.
    :type group_header_version: str
    :param transaction_set_control_number_lower_bound: Required. The transaction set control number
     lower bound.
    :type transaction_set_control_number_lower_bound: int
    :param transaction_set_control_number_upper_bound: Required. The transaction set control number
     upper bound.
    :type transaction_set_control_number_upper_bound: int
    :param rollover_transaction_set_control_number: Required. The value indicating whether to
     rollover transaction set control number.
    :type rollover_transaction_set_control_number: bool
    :param transaction_set_control_number_prefix: The transaction set control number prefix.
    :type transaction_set_control_number_prefix: str
    :param transaction_set_control_number_suffix: The transaction set control number suffix.
    :type transaction_set_control_number_suffix: str
    :param overwrite_existing_transaction_set_control_number: Required. The value indicating
     whether to overwrite existing transaction set control number.
    :type overwrite_existing_transaction_set_control_number: bool
    :param group_header_date_format: Required. The group header date format. Possible values
     include: "NotSpecified", "CCYYMMDD", "YYMMDD".
    :type group_header_date_format: str or ~azure.mgmt.logic.models.X12DateFormat
    :param group_header_time_format: Required. The group header time format. Possible values
     include: "NotSpecified", "HHMM", "HHMMSS", "HHMMSSdd", "HHMMSSd".
    :type group_header_time_format: str or ~azure.mgmt.logic.models.X12TimeFormat
    :param usage_indicator: Required. The usage indicator. Possible values include: "NotSpecified",
     "Test", "Information", "Production".
    :type usage_indicator: str or ~azure.mgmt.logic.models.UsageIndicator
    """

    _validation = {
        'control_standards_id': {'required': True},
        'use_control_standards_id_as_repetition_character': {'required': True},
        'sender_application_id': {'required': True},
        'receiver_application_id': {'required': True},
        'control_version_number': {'required': True},
        'interchange_control_number_lower_bound': {'required': True},
        'interchange_control_number_upper_bound': {'required': True},
        'rollover_interchange_control_number': {'required': True},
        'enable_default_group_headers': {'required': True},
        'group_control_number_lower_bound': {'required': True},
        'group_control_number_upper_bound': {'required': True},
        'rollover_group_control_number': {'required': True},
        'group_header_agency_code': {'required': True},
        'group_header_version': {'required': True},
        'transaction_set_control_number_lower_bound': {'required': True},
        'transaction_set_control_number_upper_bound': {'required': True},
        'rollover_transaction_set_control_number': {'required': True},
        'overwrite_existing_transaction_set_control_number': {'required': True},
        'group_header_date_format': {'required': True},
        'group_header_time_format': {'required': True},
        'usage_indicator': {'required': True},
    }

    _attribute_map = {
        'control_standards_id': {'key': 'controlStandardsId', 'type': 'int'},
        'use_control_standards_id_as_repetition_character': {'key': 'useControlStandardsIdAsRepetitionCharacter', 'type': 'bool'},
        'sender_application_id': {'key': 'senderApplicationId', 'type': 'str'},
        'receiver_application_id': {'key': 'receiverApplicationId', 'type': 'str'},
        'control_version_number': {'key': 'controlVersionNumber', 'type': 'str'},
        'interchange_control_number_lower_bound': {'key': 'interchangeControlNumberLowerBound', 'type': 'int'},
        'interchange_control_number_upper_bound': {'key': 'interchangeControlNumberUpperBound', 'type': 'int'},
        'rollover_interchange_control_number': {'key': 'rolloverInterchangeControlNumber', 'type': 'bool'},
        'enable_default_group_headers': {'key': 'enableDefaultGroupHeaders', 'type': 'bool'},
        'functional_group_id': {'key': 'functionalGroupId', 'type': 'str'},
        'group_control_number_lower_bound': {'key': 'groupControlNumberLowerBound', 'type': 'int'},
        'group_control_number_upper_bound': {'key': 'groupControlNumberUpperBound', 'type': 'int'},
        'rollover_group_control_number': {'key': 'rolloverGroupControlNumber', 'type': 'bool'},
        'group_header_agency_code': {'key': 'groupHeaderAgencyCode', 'type': 'str'},
        'group_header_version': {'key': 'groupHeaderVersion', 'type': 'str'},
        'transaction_set_control_number_lower_bound': {'key': 'transactionSetControlNumberLowerBound', 'type': 'int'},
        'transaction_set_control_number_upper_bound': {'key': 'transactionSetControlNumberUpperBound', 'type': 'int'},
        'rollover_transaction_set_control_number': {'key': 'rolloverTransactionSetControlNumber', 'type': 'bool'},
        'transaction_set_control_number_prefix': {'key': 'transactionSetControlNumberPrefix', 'type': 'str'},
        'transaction_set_control_number_suffix': {'key': 'transactionSetControlNumberSuffix', 'type': 'str'},
        'overwrite_existing_transaction_set_control_number': {'key': 'overwriteExistingTransactionSetControlNumber', 'type': 'bool'},
        'group_header_date_format': {'key': 'groupHeaderDateFormat', 'type': 'str'},
        'group_header_time_format': {'key': 'groupHeaderTimeFormat', 'type': 'str'},
        'usage_indicator': {'key': 'usageIndicator', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        control_standards_id: int,
        use_control_standards_id_as_repetition_character: bool,
        sender_application_id: str,
        receiver_application_id: str,
        control_version_number: str,
        interchange_control_number_lower_bound: int,
        interchange_control_number_upper_bound: int,
        rollover_interchange_control_number: bool,
        enable_default_group_headers: bool,
        group_control_number_lower_bound: int,
        group_control_number_upper_bound: int,
        rollover_group_control_number: bool,
        group_header_agency_code: str,
        group_header_version: str,
        transaction_set_control_number_lower_bound: int,
        transaction_set_control_number_upper_bound: int,
        rollover_transaction_set_control_number: bool,
        overwrite_existing_transaction_set_control_number: bool,
        group_header_date_format: Union[str, "X12DateFormat"],
        group_header_time_format: Union[str, "X12TimeFormat"],
        usage_indicator: Union[str, "UsageIndicator"],
        functional_group_id: Optional[str] = None,
        transaction_set_control_number_prefix: Optional[str] = None,
        transaction_set_control_number_suffix: Optional[str] = None,
        **kwargs
    ):
        super(X12EnvelopeSettings, self).__init__(**kwargs)
        self.control_standards_id = control_standards_id
        self.use_control_standards_id_as_repetition_character = use_control_standards_id_as_repetition_character
        self.sender_application_id = sender_application_id
        self.receiver_application_id = receiver_application_id
        self.control_version_number = control_version_number
        self.interchange_control_number_lower_bound = interchange_control_number_lower_bound
        self.interchange_control_number_upper_bound = interchange_control_number_upper_bound
        self.rollover_interchange_control_number = rollover_interchange_control_number
        self.enable_default_group_headers = enable_default_group_headers
        self.functional_group_id = functional_group_id
        self.group_control_number_lower_bound = group_control_number_lower_bound
        self.group_control_number_upper_bound = group_control_number_upper_bound
        self.rollover_group_control_number = rollover_group_control_number
        self.group_header_agency_code = group_header_agency_code
        self.group_header_version = group_header_version
        self.transaction_set_control_number_lower_bound = transaction_set_control_number_lower_bound
        self.transaction_set_control_number_upper_bound = transaction_set_control_number_upper_bound
        self.rollover_transaction_set_control_number = rollover_transaction_set_control_number
        self.transaction_set_control_number_prefix = transaction_set_control_number_prefix
        self.transaction_set_control_number_suffix = transaction_set_control_number_suffix
        self.overwrite_existing_transaction_set_control_number = overwrite_existing_transaction_set_control_number
        self.group_header_date_format = group_header_date_format
        self.group_header_time_format = group_header_time_format
        self.usage_indicator = usage_indicator


class X12FramingSettings(msrest.serialization.Model):
    """The X12 agreement framing settings.

    All required parameters must be populated in order to send to Azure.

    :param data_element_separator: Required. The data element separator.
    :type data_element_separator: int
    :param component_separator: Required. The component separator.
    :type component_separator: int
    :param replace_separators_in_payload: Required. The value indicating whether to replace
     separators in payload.
    :type replace_separators_in_payload: bool
    :param replace_character: Required. The replacement character.
    :type replace_character: int
    :param segment_terminator: Required. The segment terminator.
    :type segment_terminator: int
    :param character_set: Required. The X12 character set. Possible values include: "NotSpecified",
     "Basic", "Extended", "UTF8".
    :type character_set: str or ~azure.mgmt.logic.models.X12CharacterSet
    :param segment_terminator_suffix: Required. The segment terminator suffix. Possible values
     include: "NotSpecified", "None", "CR", "LF", "CRLF".
    :type segment_terminator_suffix: str or ~azure.mgmt.logic.models.SegmentTerminatorSuffix
    """

    _validation = {
        'data_element_separator': {'required': True},
        'component_separator': {'required': True},
        'replace_separators_in_payload': {'required': True},
        'replace_character': {'required': True},
        'segment_terminator': {'required': True},
        'character_set': {'required': True},
        'segment_terminator_suffix': {'required': True},
    }

    _attribute_map = {
        'data_element_separator': {'key': 'dataElementSeparator', 'type': 'int'},
        'component_separator': {'key': 'componentSeparator', 'type': 'int'},
        'replace_separators_in_payload': {'key': 'replaceSeparatorsInPayload', 'type': 'bool'},
        'replace_character': {'key': 'replaceCharacter', 'type': 'int'},
        'segment_terminator': {'key': 'segmentTerminator', 'type': 'int'},
        'character_set': {'key': 'characterSet', 'type': 'str'},
        'segment_terminator_suffix': {'key': 'segmentTerminatorSuffix', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_element_separator: int,
        component_separator: int,
        replace_separators_in_payload: bool,
        replace_character: int,
        segment_terminator: int,
        character_set: Union[str, "X12CharacterSet"],
        segment_terminator_suffix: Union[str, "SegmentTerminatorSuffix"],
        **kwargs
    ):
        super(X12FramingSettings, self).__init__(**kwargs)
        self.data_element_separator = data_element_separator
        self.component_separator = component_separator
        self.replace_separators_in_payload = replace_separators_in_payload
        self.replace_character = replace_character
        self.segment_terminator = segment_terminator
        self.character_set = character_set
        self.segment_terminator_suffix = segment_terminator_suffix


class X12MessageFilter(msrest.serialization.Model):
    """The X12 message filter for odata query.

    All required parameters must be populated in order to send to Azure.

    :param message_filter_type: Required. The message filter type. Possible values include:
     "NotSpecified", "Include", "Exclude".
    :type message_filter_type: str or ~azure.mgmt.logic.models.MessageFilterType
    """

    _validation = {
        'message_filter_type': {'required': True},
    }

    _attribute_map = {
        'message_filter_type': {'key': 'messageFilterType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_filter_type: Union[str, "MessageFilterType"],
        **kwargs
    ):
        super(X12MessageFilter, self).__init__(**kwargs)
        self.message_filter_type = message_filter_type


class X12MessageIdentifier(msrest.serialization.Model):
    """The X12 message identifier.

    All required parameters must be populated in order to send to Azure.

    :param message_id: Required. The message id.
    :type message_id: str
    """

    _validation = {
        'message_id': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_id: str,
        **kwargs
    ):
        super(X12MessageIdentifier, self).__init__(**kwargs)
        self.message_id = message_id


class X12OneWayAgreement(msrest.serialization.Model):
    """The X12 one-way agreement.

    All required parameters must be populated in order to send to Azure.

    :param sender_business_identity: Required. The sender business identity.
    :type sender_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :param receiver_business_identity: Required. The receiver business identity.
    :type receiver_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :param protocol_settings: Required. The X12 protocol settings.
    :type protocol_settings: ~azure.mgmt.logic.models.X12ProtocolSettings
    """

    _validation = {
        'sender_business_identity': {'required': True},
        'receiver_business_identity': {'required': True},
        'protocol_settings': {'required': True},
    }

    _attribute_map = {
        'sender_business_identity': {'key': 'senderBusinessIdentity', 'type': 'BusinessIdentity'},
        'receiver_business_identity': {'key': 'receiverBusinessIdentity', 'type': 'BusinessIdentity'},
        'protocol_settings': {'key': 'protocolSettings', 'type': 'X12ProtocolSettings'},
    }

    def __init__(
        self,
        *,
        sender_business_identity: "BusinessIdentity",
        receiver_business_identity: "BusinessIdentity",
        protocol_settings: "X12ProtocolSettings",
        **kwargs
    ):
        super(X12OneWayAgreement, self).__init__(**kwargs)
        self.sender_business_identity = sender_business_identity
        self.receiver_business_identity = receiver_business_identity
        self.protocol_settings = protocol_settings


class X12ProcessingSettings(msrest.serialization.Model):
    """The X12 processing settings.

    All required parameters must be populated in order to send to Azure.

    :param mask_security_info: Required. The value indicating whether to mask security information.
    :type mask_security_info: bool
    :param convert_implied_decimal: Required. The value indicating whether to convert numerical
     type to implied decimal.
    :type convert_implied_decimal: bool
    :param preserve_interchange: Required. The value indicating whether to preserve interchange.
    :type preserve_interchange: bool
    :param suspend_interchange_on_error: Required. The value indicating whether to suspend
     interchange on error.
    :type suspend_interchange_on_error: bool
    :param create_empty_xml_tags_for_trailing_separators: Required. The value indicating whether to
     create empty xml tags for trailing separators.
    :type create_empty_xml_tags_for_trailing_separators: bool
    :param use_dot_as_decimal_separator: Required. The value indicating whether to use dot as
     decimal separator.
    :type use_dot_as_decimal_separator: bool
    """

    _validation = {
        'mask_security_info': {'required': True},
        'convert_implied_decimal': {'required': True},
        'preserve_interchange': {'required': True},
        'suspend_interchange_on_error': {'required': True},
        'create_empty_xml_tags_for_trailing_separators': {'required': True},
        'use_dot_as_decimal_separator': {'required': True},
    }

    _attribute_map = {
        'mask_security_info': {'key': 'maskSecurityInfo', 'type': 'bool'},
        'convert_implied_decimal': {'key': 'convertImpliedDecimal', 'type': 'bool'},
        'preserve_interchange': {'key': 'preserveInterchange', 'type': 'bool'},
        'suspend_interchange_on_error': {'key': 'suspendInterchangeOnError', 'type': 'bool'},
        'create_empty_xml_tags_for_trailing_separators': {'key': 'createEmptyXmlTagsForTrailingSeparators', 'type': 'bool'},
        'use_dot_as_decimal_separator': {'key': 'useDotAsDecimalSeparator', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        mask_security_info: bool,
        convert_implied_decimal: bool,
        preserve_interchange: bool,
        suspend_interchange_on_error: bool,
        create_empty_xml_tags_for_trailing_separators: bool,
        use_dot_as_decimal_separator: bool,
        **kwargs
    ):
        super(X12ProcessingSettings, self).__init__(**kwargs)
        self.mask_security_info = mask_security_info
        self.convert_implied_decimal = convert_implied_decimal
        self.preserve_interchange = preserve_interchange
        self.suspend_interchange_on_error = suspend_interchange_on_error
        self.create_empty_xml_tags_for_trailing_separators = create_empty_xml_tags_for_trailing_separators
        self.use_dot_as_decimal_separator = use_dot_as_decimal_separator


class X12ProtocolSettings(msrest.serialization.Model):
    """The X12 agreement protocol settings.

    All required parameters must be populated in order to send to Azure.

    :param validation_settings: Required. The X12 validation settings.
    :type validation_settings: ~azure.mgmt.logic.models.X12ValidationSettings
    :param framing_settings: Required. The X12 framing settings.
    :type framing_settings: ~azure.mgmt.logic.models.X12FramingSettings
    :param envelope_settings: Required. The X12 envelope settings.
    :type envelope_settings: ~azure.mgmt.logic.models.X12EnvelopeSettings
    :param acknowledgement_settings: Required. The X12 acknowledgment settings.
    :type acknowledgement_settings: ~azure.mgmt.logic.models.X12AcknowledgementSettings
    :param message_filter: Required. The X12 message filter.
    :type message_filter: ~azure.mgmt.logic.models.X12MessageFilter
    :param security_settings: Required. The X12 security settings.
    :type security_settings: ~azure.mgmt.logic.models.X12SecuritySettings
    :param processing_settings: Required. The X12 processing settings.
    :type processing_settings: ~azure.mgmt.logic.models.X12ProcessingSettings
    :param envelope_overrides: The X12 envelope override settings.
    :type envelope_overrides: list[~azure.mgmt.logic.models.X12EnvelopeOverride]
    :param validation_overrides: The X12 validation override settings.
    :type validation_overrides: list[~azure.mgmt.logic.models.X12ValidationOverride]
    :param message_filter_list: The X12 message filter list.
    :type message_filter_list: list[~azure.mgmt.logic.models.X12MessageIdentifier]
    :param schema_references: Required. The X12 schema references.
    :type schema_references: list[~azure.mgmt.logic.models.X12SchemaReference]
    :param x12_delimiter_overrides: The X12 delimiter override settings.
    :type x12_delimiter_overrides: list[~azure.mgmt.logic.models.X12DelimiterOverrides]
    """

    _validation = {
        'validation_settings': {'required': True},
        'framing_settings': {'required': True},
        'envelope_settings': {'required': True},
        'acknowledgement_settings': {'required': True},
        'message_filter': {'required': True},
        'security_settings': {'required': True},
        'processing_settings': {'required': True},
        'schema_references': {'required': True},
    }

    _attribute_map = {
        'validation_settings': {'key': 'validationSettings', 'type': 'X12ValidationSettings'},
        'framing_settings': {'key': 'framingSettings', 'type': 'X12FramingSettings'},
        'envelope_settings': {'key': 'envelopeSettings', 'type': 'X12EnvelopeSettings'},
        'acknowledgement_settings': {'key': 'acknowledgementSettings', 'type': 'X12AcknowledgementSettings'},
        'message_filter': {'key': 'messageFilter', 'type': 'X12MessageFilter'},
        'security_settings': {'key': 'securitySettings', 'type': 'X12SecuritySettings'},
        'processing_settings': {'key': 'processingSettings', 'type': 'X12ProcessingSettings'},
        'envelope_overrides': {'key': 'envelopeOverrides', 'type': '[X12EnvelopeOverride]'},
        'validation_overrides': {'key': 'validationOverrides', 'type': '[X12ValidationOverride]'},
        'message_filter_list': {'key': 'messageFilterList', 'type': '[X12MessageIdentifier]'},
        'schema_references': {'key': 'schemaReferences', 'type': '[X12SchemaReference]'},
        'x12_delimiter_overrides': {'key': 'x12DelimiterOverrides', 'type': '[X12DelimiterOverrides]'},
    }

    def __init__(
        self,
        *,
        validation_settings: "X12ValidationSettings",
        framing_settings: "X12FramingSettings",
        envelope_settings: "X12EnvelopeSettings",
        acknowledgement_settings: "X12AcknowledgementSettings",
        message_filter: "X12MessageFilter",
        security_settings: "X12SecuritySettings",
        processing_settings: "X12ProcessingSettings",
        schema_references: List["X12SchemaReference"],
        envelope_overrides: Optional[List["X12EnvelopeOverride"]] = None,
        validation_overrides: Optional[List["X12ValidationOverride"]] = None,
        message_filter_list: Optional[List["X12MessageIdentifier"]] = None,
        x12_delimiter_overrides: Optional[List["X12DelimiterOverrides"]] = None,
        **kwargs
    ):
        super(X12ProtocolSettings, self).__init__(**kwargs)
        self.validation_settings = validation_settings
        self.framing_settings = framing_settings
        self.envelope_settings = envelope_settings
        self.acknowledgement_settings = acknowledgement_settings
        self.message_filter = message_filter
        self.security_settings = security_settings
        self.processing_settings = processing_settings
        self.envelope_overrides = envelope_overrides
        self.validation_overrides = validation_overrides
        self.message_filter_list = message_filter_list
        self.schema_references = schema_references
        self.x12_delimiter_overrides = x12_delimiter_overrides


class X12SchemaReference(msrest.serialization.Model):
    """The X12 schema reference.

    All required parameters must be populated in order to send to Azure.

    :param message_id: Required. The message id.
    :type message_id: str
    :param sender_application_id: The sender application id.
    :type sender_application_id: str
    :param schema_version: Required. The schema version.
    :type schema_version: str
    :param schema_name: Required. The schema name.
    :type schema_name: str
    """

    _validation = {
        'message_id': {'required': True},
        'schema_version': {'required': True},
        'schema_name': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'sender_application_id': {'key': 'senderApplicationId', 'type': 'str'},
        'schema_version': {'key': 'schemaVersion', 'type': 'str'},
        'schema_name': {'key': 'schemaName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_id: str,
        schema_version: str,
        schema_name: str,
        sender_application_id: Optional[str] = None,
        **kwargs
    ):
        super(X12SchemaReference, self).__init__(**kwargs)
        self.message_id = message_id
        self.sender_application_id = sender_application_id
        self.schema_version = schema_version
        self.schema_name = schema_name


class X12SecuritySettings(msrest.serialization.Model):
    """The X12 agreement security settings.

    All required parameters must be populated in order to send to Azure.

    :param authorization_qualifier: Required. The authorization qualifier.
    :type authorization_qualifier: str
    :param authorization_value: The authorization value.
    :type authorization_value: str
    :param security_qualifier: Required. The security qualifier.
    :type security_qualifier: str
    :param password_value: The password value.
    :type password_value: str
    """

    _validation = {
        'authorization_qualifier': {'required': True},
        'security_qualifier': {'required': True},
    }

    _attribute_map = {
        'authorization_qualifier': {'key': 'authorizationQualifier', 'type': 'str'},
        'authorization_value': {'key': 'authorizationValue', 'type': 'str'},
        'security_qualifier': {'key': 'securityQualifier', 'type': 'str'},
        'password_value': {'key': 'passwordValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        authorization_qualifier: str,
        security_qualifier: str,
        authorization_value: Optional[str] = None,
        password_value: Optional[str] = None,
        **kwargs
    ):
        super(X12SecuritySettings, self).__init__(**kwargs)
        self.authorization_qualifier = authorization_qualifier
        self.authorization_value = authorization_value
        self.security_qualifier = security_qualifier
        self.password_value = password_value


class X12ValidationOverride(msrest.serialization.Model):
    """The X12 validation override settings.

    All required parameters must be populated in order to send to Azure.

    :param message_id: Required. The message id on which the validation settings has to be applied.
    :type message_id: str
    :param validate_edi_types: Required. The value indicating whether to validate EDI types.
    :type validate_edi_types: bool
    :param validate_xsd_types: Required. The value indicating whether to validate XSD types.
    :type validate_xsd_types: bool
    :param allow_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     allow leading and trailing spaces and zeroes.
    :type allow_leading_and_trailing_spaces_and_zeroes: bool
    :param validate_character_set: Required. The value indicating whether to validate character
     Set.
    :type validate_character_set: bool
    :param trim_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     trim leading and trailing spaces and zeroes.
    :type trim_leading_and_trailing_spaces_and_zeroes: bool
    :param trailing_separator_policy: Required. The trailing separator policy. Possible values
     include: "NotSpecified", "NotAllowed", "Optional", "Mandatory".
    :type trailing_separator_policy: str or ~azure.mgmt.logic.models.TrailingSeparatorPolicy
    """

    _validation = {
        'message_id': {'required': True},
        'validate_edi_types': {'required': True},
        'validate_xsd_types': {'required': True},
        'allow_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'validate_character_set': {'required': True},
        'trim_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'trailing_separator_policy': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'validate_edi_types': {'key': 'validateEDITypes', 'type': 'bool'},
        'validate_xsd_types': {'key': 'validateXSDTypes', 'type': 'bool'},
        'allow_leading_and_trailing_spaces_and_zeroes': {'key': 'allowLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'validate_character_set': {'key': 'validateCharacterSet', 'type': 'bool'},
        'trim_leading_and_trailing_spaces_and_zeroes': {'key': 'trimLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'trailing_separator_policy': {'key': 'trailingSeparatorPolicy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_id: str,
        validate_edi_types: bool,
        validate_xsd_types: bool,
        allow_leading_and_trailing_spaces_and_zeroes: bool,
        validate_character_set: bool,
        trim_leading_and_trailing_spaces_and_zeroes: bool,
        trailing_separator_policy: Union[str, "TrailingSeparatorPolicy"],
        **kwargs
    ):
        super(X12ValidationOverride, self).__init__(**kwargs)
        self.message_id = message_id
        self.validate_edi_types = validate_edi_types
        self.validate_xsd_types = validate_xsd_types
        self.allow_leading_and_trailing_spaces_and_zeroes = allow_leading_and_trailing_spaces_and_zeroes
        self.validate_character_set = validate_character_set
        self.trim_leading_and_trailing_spaces_and_zeroes = trim_leading_and_trailing_spaces_and_zeroes
        self.trailing_separator_policy = trailing_separator_policy


class X12ValidationSettings(msrest.serialization.Model):
    """The X12 agreement validation settings.

    All required parameters must be populated in order to send to Azure.

    :param validate_character_set: Required. The value indicating whether to validate character set
     in the message.
    :type validate_character_set: bool
    :param check_duplicate_interchange_control_number: Required. The value indicating whether to
     check for duplicate interchange control number.
    :type check_duplicate_interchange_control_number: bool
    :param interchange_control_number_validity_days: Required. The validity period of interchange
     control number.
    :type interchange_control_number_validity_days: int
    :param check_duplicate_group_control_number: Required. The value indicating whether to check
     for duplicate group control number.
    :type check_duplicate_group_control_number: bool
    :param check_duplicate_transaction_set_control_number: Required. The value indicating whether
     to check for duplicate transaction set control number.
    :type check_duplicate_transaction_set_control_number: bool
    :param validate_edi_types: Required. The value indicating whether to Whether to validate EDI
     types.
    :type validate_edi_types: bool
    :param validate_xsd_types: Required. The value indicating whether to Whether to validate XSD
     types.
    :type validate_xsd_types: bool
    :param allow_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     allow leading and trailing spaces and zeroes.
    :type allow_leading_and_trailing_spaces_and_zeroes: bool
    :param trim_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     trim leading and trailing spaces and zeroes.
    :type trim_leading_and_trailing_spaces_and_zeroes: bool
    :param trailing_separator_policy: Required. The trailing separator policy. Possible values
     include: "NotSpecified", "NotAllowed", "Optional", "Mandatory".
    :type trailing_separator_policy: str or ~azure.mgmt.logic.models.TrailingSeparatorPolicy
    """

    _validation = {
        'validate_character_set': {'required': True},
        'check_duplicate_interchange_control_number': {'required': True},
        'interchange_control_number_validity_days': {'required': True},
        'check_duplicate_group_control_number': {'required': True},
        'check_duplicate_transaction_set_control_number': {'required': True},
        'validate_edi_types': {'required': True},
        'validate_xsd_types': {'required': True},
        'allow_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'trim_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'trailing_separator_policy': {'required': True},
    }

    _attribute_map = {
        'validate_character_set': {'key': 'validateCharacterSet', 'type': 'bool'},
        'check_duplicate_interchange_control_number': {'key': 'checkDuplicateInterchangeControlNumber', 'type': 'bool'},
        'interchange_control_number_validity_days': {'key': 'interchangeControlNumberValidityDays', 'type': 'int'},
        'check_duplicate_group_control_number': {'key': 'checkDuplicateGroupControlNumber', 'type': 'bool'},
        'check_duplicate_transaction_set_control_number': {'key': 'checkDuplicateTransactionSetControlNumber', 'type': 'bool'},
        'validate_edi_types': {'key': 'validateEDITypes', 'type': 'bool'},
        'validate_xsd_types': {'key': 'validateXSDTypes', 'type': 'bool'},
        'allow_leading_and_trailing_spaces_and_zeroes': {'key': 'allowLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'trim_leading_and_trailing_spaces_and_zeroes': {'key': 'trimLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'trailing_separator_policy': {'key': 'trailingSeparatorPolicy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        validate_character_set: bool,
        check_duplicate_interchange_control_number: bool,
        interchange_control_number_validity_days: int,
        check_duplicate_group_control_number: bool,
        check_duplicate_transaction_set_control_number: bool,
        validate_edi_types: bool,
        validate_xsd_types: bool,
        allow_leading_and_trailing_spaces_and_zeroes: bool,
        trim_leading_and_trailing_spaces_and_zeroes: bool,
        trailing_separator_policy: Union[str, "TrailingSeparatorPolicy"],
        **kwargs
    ):
        super(X12ValidationSettings, self).__init__(**kwargs)
        self.validate_character_set = validate_character_set
        self.check_duplicate_interchange_control_number = check_duplicate_interchange_control_number
        self.interchange_control_number_validity_days = interchange_control_number_validity_days
        self.check_duplicate_group_control_number = check_duplicate_group_control_number
        self.check_duplicate_transaction_set_control_number = check_duplicate_transaction_set_control_number
        self.validate_edi_types = validate_edi_types
        self.validate_xsd_types = validate_xsd_types
        self.allow_leading_and_trailing_spaces_and_zeroes = allow_leading_and_trailing_spaces_and_zeroes
        self.trim_leading_and_trailing_spaces_and_zeroes = trim_leading_and_trailing_spaces_and_zeroes
        self.trailing_separator_policy = trailing_separator_policy
