# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute.aio import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementCapacityReservationGroupsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_capacity_reservation_groups_create_or_update(self, resource_group):
        response = await self.client.capacity_reservation_groups.create_or_update(
            resource_group_name=resource_group.name,
            capacity_reservation_group_name="str",
            parameters={
                "location": "str",
                "capacityReservations": [{"id": "str"}],
                "id": "str",
                "instanceView": {
                    "capacityReservations": [
                        {
                            "name": "str",
                            "statuses": [
                                {
                                    "code": "str",
                                    "displayStatus": "str",
                                    "level": "str",
                                    "message": "str",
                                    "time": "2020-02-20 00:00:00",
                                }
                            ],
                            "utilizationInfo": {"currentCapacity": 0, "virtualMachinesAllocated": [{"id": "str"}]},
                        }
                    ],
                    "sharedSubscriptionIds": [{"id": "str"}],
                },
                "name": "str",
                "sharingProfile": {"subscriptionIds": [{"id": "str"}]},
                "tags": {"str": "str"},
                "type": "str",
                "virtualMachinesAssociated": [{"id": "str"}],
                "zones": ["str"],
            },
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_capacity_reservation_groups_update(self, resource_group):
        response = await self.client.capacity_reservation_groups.update(
            resource_group_name=resource_group.name,
            capacity_reservation_group_name="str",
            parameters={
                "capacityReservations": [{"id": "str"}],
                "instanceView": {
                    "capacityReservations": [
                        {
                            "name": "str",
                            "statuses": [
                                {
                                    "code": "str",
                                    "displayStatus": "str",
                                    "level": "str",
                                    "message": "str",
                                    "time": "2020-02-20 00:00:00",
                                }
                            ],
                            "utilizationInfo": {"currentCapacity": 0, "virtualMachinesAllocated": [{"id": "str"}]},
                        }
                    ],
                    "sharedSubscriptionIds": [{"id": "str"}],
                },
                "sharingProfile": {"subscriptionIds": [{"id": "str"}]},
                "tags": {"str": "str"},
                "virtualMachinesAssociated": [{"id": "str"}],
            },
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_capacity_reservation_groups_delete(self, resource_group):
        response = await self.client.capacity_reservation_groups.delete(
            resource_group_name=resource_group.name,
            capacity_reservation_group_name="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_capacity_reservation_groups_get(self, resource_group):
        response = await self.client.capacity_reservation_groups.get(
            resource_group_name=resource_group.name,
            capacity_reservation_group_name="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_capacity_reservation_groups_list_by_resource_group(self, resource_group):
        response = self.client.capacity_reservation_groups.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_capacity_reservation_groups_list_by_subscription(self, resource_group):
        response = self.client.capacity_reservation_groups.list_by_subscription(
            api_version="2024-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
