% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_variance_explained.R
\name{calculate_variance_explained_per_sample}
\alias{calculate_variance_explained_per_sample}
\title{Calculate variance explained by the MOFA factors for each sample}
\usage{
calculate_variance_explained_per_sample(
  object,
  views = "all",
  groups = "all",
  factors = "all"
)
}
\arguments{
\item{object}{a \code{\link{MOFA}} object.}

\item{views}{character vector with the view names, or numeric vector with view indexes. Default is 'all'}

\item{groups}{character vector with the group names, or numeric vector with group indexes. Default is 'all'}

\item{factors}{character vector with the factor names, or numeric vector with the factor indexes. Default is 'all'}
}
\value{
a list with matrices with the amount of variation explained per sample and view.
}
\description{
This function takes a trained MOFA model as input and calculates, **for each sample** the proportion of variance explained 
(i.e. the coefficient of determinations (R^2)) by the MOFA factors across the different views.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Calculate variance explained (R2)
r2 <- calculate_variance_explained_per_sample(model)

}
