% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/704-calcProtSeqSim.R
\name{calcTwoProtSeqSim}
\alias{calcTwoProtSeqSim}
\title{Protein Sequence Alignment for Two Protein Sequences}
\usage{
calcTwoProtSeqSim(seq1, seq2, type = "local", submat = "BLOSUM62")
}
\arguments{
\item{seq1}{A character string, containing one protein sequence.}

\item{seq2}{A character string, containing another protein sequence.}

\item{type}{Type of alignment, default is \code{'local'},
could be \code{'global'} or \code{'local'},
where \code{'global'} represents Needleman-Wunsch global alignment;
\code{'local'} represents Smith-Waterman local alignment.}

\item{submat}{Substitution matrix, default is \code{'BLOSUM62'},
could be one of \code{'BLOSUM45'}, \code{'BLOSUM50'}, \code{'BLOSUM62'},
\code{'BLOSUM80'}, \code{'BLOSUM100'}, \code{'PAM30'}, \code{'PAM40'},
\code{'PAM70'}, \code{'PAM120'}, \code{'PAM250'}.}
}
\value{
An Biostrings object containing the scores and other
alignment information.
}
\description{
Protein Sequence Alignment for Two Protein Sequences
}
\details{
This function implements the sequence alignment between two protein sequences.
}
\examples{
s1 = readFASTA(system.file('protseq/P00750.fasta', package = 'Rcpi'))[[1]]
s2 = readFASTA(system.file('protseq/P10323.fasta', package = 'Rcpi'))[[1]]
\donttest{
seqalign = calcTwoProtSeqSim(s1, s2)
seqalign
slot(seqalign, "score")}
}
\seealso{
See \code{\link{calcParProtSeqSim}} for paralleled pairwise
protein similarity calculation based on sequence alignment.
See \code{\link{calcTwoProtGOSim}} for calculating the
GO semantic similarity between two groups of GO terms or two Entrez gene IDs.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{Needleman-Wunsch}
\keyword{Smith-Waterman}
\keyword{alignment}
\keyword{calcTwoProtSeqSim}
\keyword{global}
\keyword{local}
\keyword{parallel}
\keyword{sequence}
\keyword{similarity}
