% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/306-extractDrugAromaticBondsCount.R
\name{extractDrugAromaticBondsCount}
\alias{extractDrugAromaticBondsCount}
\title{Calculate the Number of Aromatic Bonds Descriptor}
\usage{
extractDrugAromaticBondsCount(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns one column named \code{nAromBond}.
}
\description{
Calculate the Number of Aromatic Bonds Descriptor
}
\details{
Calculates the number of aromatic bonds of a molecule.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugAromaticBondsCount(mol)
head(dat)}
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{Aromatic}
\keyword{Bond}
\keyword{Count}
\keyword{extractDrugAromaticBondsCount}
