% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/378-extractDrugKR.R
\name{extractDrugKRComplete}
\alias{extractDrugKRComplete}
\title{Calculate the KR (Klekota and Roth) Molecular Fingerprints (in Complete Format)}
\usage{
extractDrugKRComplete(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
An integer vector or a matrix. Each row represents one molecule,
the columns represent the fingerprints.
}
\description{
Calculate the KR (Klekota and Roth) Molecular Fingerprints (in Complete Format)
}
\details{
Calculate the 4860 bit fingerprint defined by Klekota and Roth.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
fp  = extractDrugKRComplete(mol)
dim(fp)}
}
\seealso{
\link{extractDrugKR}
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{extractDrugKRComplete}
