% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_density.R
\name{compute_density}
\alias{compute_density}
\title{Compute density of data.}
\usage{
compute_density(x, x_var, w_var = NULL, kernel = "gaussian",
  trim = FALSE, n = 256L, na.rm = FALSE, ...)
}
\arguments{
\item{x}{Dataset (data frame, \code{grouped_df} or ggvis) object to work
with.}

\item{x_var, w_var}{Names of variables to use for x position, and for
weights.}

\item{kernel}{Smoothing kernel. See \code{\link{density}} for details.}

\item{trim}{If \code{TRUE}, the default, density estimates are trimmed to the
actual range of the data.  If \code{FALSE}, they are extended by the
default 3 bandwidths (as specified by the \code{cut} parameter to
\code{\link{density}}).}

\item{n}{Number of points (along x) to use in the density estimate.}

\item{na.rm}{If \code{TRUE} missing values will be silently removed,
otherwise they will be removed with a warning.}

\item{...}{Additional arguments passed on to \code{\link{density}}.}
}
\value{
A data frame with columns:
 \item{pred_}{regularly spaced grid of \code{n} locations}
 \item{resp_}{density estimate}
}
\description{
Compute density of data.
}
\examples{
mtcars \%>\% compute_density(~mpg, n = 5)
mtcars \%>\% group_by(cyl) \%>\% compute_density(~mpg, n = 5)
mtcars \%>\% ggvis(~mpg) \%>\% compute_density(~mpg, n = 5) \%>\%
  layer_points(~pred_, ~resp_)
}
