% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forge.R
\name{forge}
\alias{forge}
\title{Forge prediction-ready data}
\usage{
forge(new_data, blueprint, ..., outcomes = FALSE)
}
\arguments{
\item{new_data}{A data frame or matrix of predictors to process. If
\code{outcomes = TRUE}, this should also contain the outcomes to process.}

\item{blueprint}{A preprocessing \code{blueprint}.}

\item{...}{Not used.}

\item{outcomes}{A logical. Should the outcomes be processed and returned
as well?}
}
\value{
A named list with 3 elements:
\itemize{
\item \code{predictors}: A tibble containing the preprocessed
\code{new_data} predictors.
\item \code{outcomes}: If \code{outcomes = TRUE}, a tibble containing the preprocessed
outcomes found in \code{new_data}. Otherwise, \code{NULL}.
\item \code{extras}: Either \code{NULL} if the blueprint returns no extra information,
or a named list containing the extra information.
}
}
\description{
\code{forge()} applies the transformations requested by the specific \code{blueprint}
on a set of \code{new_data}. This \code{new_data} contains new predictors
(and potentially outcomes) that will be used to generate predictions.

All blueprints have consistent return values with the others, but each is
unique enough to have its own help page. Click through below to learn
how to use each one in conjunction with \code{forge()}.
\itemize{
\item XY Method - \code{\link[=default_xy_blueprint]{default_xy_blueprint()}}
\item Formula Method - \code{\link[=default_formula_blueprint]{default_formula_blueprint()}}
\item Recipes Method - \code{\link[=default_recipe_blueprint]{default_recipe_blueprint()}}
}
}
\details{
If the outcomes are present in \code{new_data}, they can optionally be processed
and returned in the \code{outcomes} slot of the returned list by setting
\code{outcomes = TRUE}. This is very useful when doing cross validation where
you need to preprocess the outcomes of a test set before computing
performance.
}
\examples{
# See the blueprint specific documentation linked above
# for various ways to call forge with different
# blueprints.

train <- iris[1:100, ]
test <- iris[101:150, ]

# Formula
processed <- mold(
  log(Sepal.Width) ~ Species,
  train,
  blueprint = default_formula_blueprint(indicators = "none")
)

forge(test, processed$blueprint, outcomes = TRUE)
}
