% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixPower.R
\name{matrixPower}
\alias{matrixPower}
\title{Power of a Matrix}
\usage{
matrixPower(object, power, symmetric, tol = 1e-12,
  print.warning = TRUE)
}
\arguments{
\item{object}{a matrix.}

\item{power}{[numeric] power to be applied to the matrix.}

\item{symmetric}{[logical] is the matrix symmetric? Argument passed to the function \code{eigen}.}

\item{tol}{[numeric >0] the threshold under which the eigenvalues are set to 0.}

\item{print.warning}{[logical] should a warning be print when some or the eigenvalues are not strictly positive.}
}
\value{
A matrix.
}
\description{
Compute the power of a matrix.
}
\examples{
## symmetric matrix
set.seed(10)
M <- matrix(rnorm(20*6),20,6)
Sigma <- var(M)
Sigma.half <- matrixPower(Sigma, power = 1/2, symmetric = TRUE)
round(Sigma.half \%*\% Sigma.half - Sigma,5)

iSigma <- matrixPower(Sigma, power = -1, symmetric = TRUE)
round(iSigma \%*\% Sigma,5)

iSigma.half <- matrixPower(Sigma, power = -1/2, symmetric = TRUE)
round(iSigma.half \%*\% iSigma.half - iSigma,5)

## non symmetric matrix
set.seed(10)
M <- matrix(abs(rnorm(9)), 3, 3) + diag(1,3,3)
M-t(M)

iM <- matrixPower(M, power = -1, symmetric = FALSE)
round(iM \%*\% M,5)

iM.half <- matrixPower(M, power = -1/2, symmetric = FALSE)
round(iM.half \%*\% iM.half \%*\% M,5)

}
