% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Measure.R
\name{makeMeasure}
\alias{makeMeasure}
\alias{Measure}
\title{Construct performance measure.}
\usage{
makeMeasure(
  id,
  minimize,
  properties = character(0L),
  fun,
  extra.args = list(),
  aggr = test.mean,
  best = NULL,
  worst = NULL,
  name = id,
  note = ""
)
}
\arguments{
\item{id}{(\code{character(1)})\cr
Name of measure.}

\item{minimize}{(\code{logical(1)})\cr
Should the measure be minimized?
Default is \code{TRUE}.}

\item{properties}{(\link{character})\cr
Set of measure properties. Some standard property names include:
- classif: Is the measure applicable for classification?
- classif.multi: Is the measure applicable for multi-class classification?
- multilabel: Is the measure applicable for multilabel classification?
- regr: Is the measure applicable for regression?
- surv: Is the measure applicable for survival?
- cluster: Is the measure applicable for cluster?
- costsens: Is the measure applicable for cost-sensitive learning?
- req.pred: Is prediction object required in calculation? Usually the case.
- req.truth: Is truth column required in calculation? Usually the case.
- req.task: Is task object required in calculation? Usually not the case
- req.model: Is model object required in calculation? Usually not the case.
- req.feats: Are feature values required in calculation? Usually not the case.
- req.prob: Are predicted probabilities required in calculation? Usually not the case, example would be AUC.

Default is \code{character(0)}.}

\item{fun}{(\verb{function(task, model, pred, feats, extra.args)})\cr
Calculates the performance value. Usually you will only need the prediction
object \code{pred}.
- \code{task} (\link{Task})\cr
The task.
- \code{model} (\link{WrappedModel})\cr
The fitted model.
- \code{pred} (\link{Prediction})\cr
Prediction object.
- \code{feats} (\link{data.frame})\cr
The features.
- \code{extra.args} (\link{list})\cr
See below.}

\item{extra.args}{(\link{list})\cr
List of extra arguments which will always be passed to \code{fun}.
Can be changed after construction via \code{\link[=setMeasurePars]{setMeasurePars()}}.
Default is empty list.}

\item{aggr}{(\link{Aggregation})\cr
Aggregation function, which is used to aggregate the values measured
on test / training sets of the measure to a single value.
Default is \link{test.mean}.}

\item{best}{(\code{numeric(1)})\cr
Best obtainable value for measure.
Default is -\code{Inf} or \code{Inf}, depending on \code{minimize}.}

\item{worst}{(\code{numeric(1)})\cr
Worst obtainable value for measure.
Default is \code{Inf} or -\code{Inf}, depending on \code{minimize}.}

\item{name}{(\link{character}) \cr
Name of the measure. Default is \code{id}.}

\item{note}{(\link{character}) \cr
Description and additional notes for the measure. Default is \dQuote{}.}
}
\value{
\link{Measure}.
}
\description{
A measure object encapsulates a function to evaluate the performance of a
prediction. Information about already implemented measures can be obtained
here: \link{measures}.

A learner is trained on a training set d1, results in a model m and predicts
another set d2 (which may be a different one or the training set) resulting
in the prediction. The performance measure can now be defined using all of
the information of the original task, the fitted model and the prediction.
}
\examples{
f = function(task, model, pred, extra.args) {
  sum((pred$data$response - pred$data$truth)^2)
}
makeMeasure(id = "my.sse", minimize = TRUE,
  properties = c("regr", "response"), fun = f)
}
\seealso{
Other performance: 
\code{\link{ConfusionMatrix}},
\code{\link{calculateConfusionMatrix}()},
\code{\link{calculateROCMeasures}()},
\code{\link{estimateRelativeOverfitting}()},
\code{\link{makeCostMeasure}()},
\code{\link{makeCustomResampledMeasure}()},
\code{\link{measures}},
\code{\link{performance}()},
\code{\link{setAggregation}()},
\code{\link{setMeasurePars}()}
}
\concept{performance}
