% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_rhat.R
\name{rhat_nested}
\alias{rhat_nested}
\alias{rhat_nested.default}
\alias{rhat_nested.rvar}
\title{Nested Rhat convergence diagnostic}
\usage{
rhat_nested(x, ...)

\method{rhat_nested}{default}(x, superchain_ids, ...)

\method{rhat_nested}{rvar}(x, superchain_ids, ...)
}
\arguments{
\item{x}{(multiple options) One of:
\itemize{
\item A matrix of draws for a single variable (iterations x chains). See
\code{\link[=extract_variable_matrix]{extract_variable_matrix()}}.
\item An \code{\link{rvar}}.
}}

\item{...}{Arguments passed to individual methods (if applicable).}

\item{superchain_ids}{(numeric) Vector of length nchains specifying
which superchain each chain belongs to. There should be equal
numbers of chains in each superchain. All chains within the same
superchain are assumed to have been initialized at the same
point.}
}
\value{
If the input is an array, returns a single numeric value. If any of the draws
is non-finite, that is, \code{NA}, \code{NaN}, \code{Inf}, or \code{-Inf}, the returned output
will be (numeric) \code{NA}. Also, if all draws within any of the chains of a
variable are the same (constant), the returned output will be (numeric) \code{NA}
as well. The reason for the latter is that, for constant draws, we cannot
distinguish between variables that are supposed to be constant (e.g., a
diagonal element of a correlation matrix is always 1) or variables that just
happened to be constant because of a failure of convergence or other problems
in the sampling process.

If the input is an \code{\link{rvar}}, returns an array of the same dimensions as the
\code{\link{rvar}}, where each element is equal to the value that would be returned by
passing the draws array for that element of the \code{\link{rvar}} to this function.
}
\description{
Compute the nested Rhat convergence diagnostic for a single
variable as proposed in Margossian et al. (2024).
}
\details{
Nested Rhat is a convergence diagnostic useful when
running many short chains. It is calculated on superchains, which
are groups of chains that have been initialized at the same
point.

Note that there is a slight difference in the calculation of Rhat
and nested Rhat, as nested Rhat is lower bounded by 1. This means
that nested Rhat with one chain per superchain will not be
exactly equal to basic Rhat (see Footnote 3 in Margossian et
al. (2024)).
}
\examples{
mu <- extract_variable_matrix(example_draws(), "mu")
rhat_nested(mu, superchain_ids = c(1, 1, 2, 2))

d <- as_draws_rvars(example_draws("multi_normal"))
rhat_nested(d$Sigma, superchain_ids = c(1, 1, 2, 2))

}
\references{
Charles C. Margossian, Matthew D. Hoffman, Pavel Sountsov, Lionel
Riou-Durand, Aki Vehtari and Andrew Gelman (2024). Nested R-hat:
Assessing the convergence of Markov chain Monte Carlo when running
many short chains. \emph{Bayesian Analysis}. doi:10.1214/24-BA1453
}
\seealso{
Other diagnostics: 
\code{\link{ess_basic}()},
\code{\link{ess_bulk}()},
\code{\link{ess_quantile}()},
\code{\link{ess_sd}()},
\code{\link{ess_tail}()},
\code{\link{mcse_mean}()},
\code{\link{mcse_quantile}()},
\code{\link{mcse_sd}()},
\code{\link{pareto_diags}()},
\code{\link{pareto_khat}()},
\code{\link{rhat}()},
\code{\link{rhat_basic}()},
\code{\link{rstar}()}
}
\concept{diagnostics}
