% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml.R
\name{yaml_load}
\alias{yaml_load}
\title{Read YAML data}
\usage{
yaml_load(
  x,
  ...,
  handlers = NULL,
  envir = parent.frame(),
  use_yaml = loadable("yaml")
)
}
\arguments{
\item{x}{A character vector of YAML data.}

\item{..., handlers}{Arguments to be passed to \code{\link[yaml:yaml.load]{yaml::yaml.load()}}.}

\item{envir}{The environment in which R expressions in YAML are evaluated. To
disable the evaluation, use \code{envir = FALSE}.}

\item{use_yaml}{Whether to use the \pkg{yaml} package.}
}
\value{
An R object (typically a list).
}
\description{
If the \pkg{yaml} package is installed, use \code{\link[yaml:yaml.load]{yaml::yaml.load()}} to read the
data. If not, use the simple parser \code{\link[=taml_load]{taml_load()}} instead.
}
\note{
R expressions in YAML will be returned as \link{expression}s when they are
not evaluated. This is different with \code{\link[yaml:yaml.load]{yaml::yaml.load()}}, which returns
character strings for expressions.
}
\examples{
yaml_load("a: 1")
yaml_load("a: 1", use_yaml = FALSE)
}
