# Announce: Rakudo compiler, Release #151 (2021.10)

On behalf of the Rakudo development team, I’m very happy to announce the
October 2021 release of Rakudo #151. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2021.10:

  + SPECIAL NOTES:
    + Introduce a new dispatch mechanism, including more general
      and efficient handling of various language constructs.
      For more info see  [The new MoarVM dispatch mechanism is here!](https://6guts.wordpress.com/2021/09/29/the-new-moarvm-dispatch-mechanism-is-here/)
      [d557f72b][3e086599][1f359956][959eaeab][dc456a1a][a114255c]
      [055ca78b][4e5e5329][41de71cf][4ecb1995][83f66c59][482f2561]
      [5c72c7b0][1023c381][8bd88c2e][d9b75e82][7d5f251c][10e5e32b]
      [54c085e9][e20ee30f][54f2d5ec][34d48682][69d8d938][734ecd2f]
      [b6359402][68aaeb1e][75a9cb65][52587136][38407083][d28a8aff]
      [3c5193d1][db03d022][e598691a][39cc4ee7][2b189a51][074c5fc7]
      [03b524dc][a42047fe][42b52ec9][997af70f][66dc358b][4302f94d]
      [f146f705][306a9e02][b4bb83c2][0d2db69c][b42f34e9][8ba49228]
      [868c05ff][90410697][753d269a][4f9ac059][8cc60acc][8845d57a]
      [71086d4f][c58d69eb][1360ffe1][3dd4314d][4956784e][db543fc6]
      [3aeb8e31][1ca8b728][417d17c5][8fc8a7f8][fba37c5b][85d4aaee]
      [dda0ea03][2baa490b][50fcef71][419d21a6][6e4a5420][21680e1f]
      [ccf7fa59][ca4d3f76][5973a1c6][5b4ee2e5][533978d0][192821f8]
      [c34964b3][7f15f505][39eb6778][049d1300][6bd5a86b][7055e93c]
      [df9c3939][26ee39e1][258610e8][fd9d62be][cff8e98f][9b39ae14]
      [269d9394][610a6c81][5d93c2ea][8b52034d][7e9aa39b][ce7e94e6]
      [29973253][13cae29b][b21bf9a8][7816de91][1c2b7149][c6342f8d]
      [de24aac1][ddcaf413][67501437][1355f036][3ebee705][1ab7674b]
      [8e760be0][4c14af68][25f0ef88][fa5b82af][dafb08cf][daa954fa]
      [652079e7][7afa7bf6][dc070055][11e73132][4e0ceea0][cf46a3c6]
      [8e20ea60][d17f00b5][5ba7cf0a][885f4ab5][84da856a][f8fa8844]
      [25d2f634][5d07d600][1f172ecb][5dedf062][20a3ed03][79e5919b]
      [605cd8e5][61f6984b][96e15cf5][439fc5bd][7583f21e][fa4efbf1]
      [52338a0c][b8183107][84b1820c][f496be1d][edf17b3d][9d7d164c]
      [c1a89bc0][1253f4bd][c0098e3f][ebd03058][3e5e217f][cee2053c]
      [9e7499ed][a267025f][33a6655e][fd383374][1220a3ec][a638cf61]
      [c1a89bc0][1253f4bd][c0098e3f][ebd03058][3e5e217f][cee2053c]
      [9e7499ed][a267025f][33a6655e][fd383374][1220a3ec][a638cf61]
      [c61d91a6][65b5b4a9][e7fee3ac][b63ff146][0400253c][6d05ce36]
      [90e650cf][73b82cf2][02d4e74f][336d488b][34df830a][558dccc0]
      [d2d21236][6d395816][72d9a0de][e8910a4e][e19bcbf2][d4062aa0]
      [69fb2d79][9441ef4a][8668ebf0][a04fe6c0][fab8e646][39b60a2c]
      [383a2fb2][36664650][2afbf2a2][7ff1a8a2][0805986b][a0c5c20e]
      [009f4d39][1bc136ac][0d4ba023][4d25d5d9][4c2be058][2051e7e6]
      [d9d30744][0da1bec2][41d478e8][45d642f6][0f323688][36738fac]
      [2ee73dbf][dc2efba6][b8e55656][8504a9a9][dfb8446b][080f772c]
      [19e0c985][4830a042][f488a6e8][305afb75][9a277af2][77a186f2]
      [3513296b][3ad1a93f][ebe6682d][32f1e20e][0b6f3b33][c412cd76]
      [de5ee1e8][0259d451][d2c88868][bfd8a36b][583a6da5][133807ca]
      [9ea760d8][dd2b274f][38f6f873][21271aa5][cddcdb71][191fbba9]
      [ff92bac5][aa728ef7][40bf3f3e][8d1f24f9][ca3355a8][d6d90f41]
      [02c13fad][8fc643ec][b34ae24a]
  + Deprecations:
   + The `$*PERL` variable usage will warn starting from `6.e` language release,
     using `$*RAKU` is preferred now [11fd2d70][3dc4aca2]
  + Additions:
    + Add Cool.Version coercer [dab7404c]
  + Changes:
    + De-unicodify `Raku` and `Rakudo` in the welcome message [ba15173f]
  + Fixes:
    + Fix a bug where using a signature constraint with a named callable parameter did not work
      [e9a0b18c][9c2cc9c2][ffb587f2][51968148][d47185eb]
    + Make sure name suggestions shown in the `X::Method::NotFound` exception are properly sorted
      [0152e3c3][569f90ea]
    + Fix a bug in module loading preventing the `Inline::Python` module to be loaded twice
      from different locations [88862a9f]
    + Ensure symbols installed into `GLOBAL` during loading of a compunit are not lost [0cb2cb50][bb607b6b]
    + Fix loading wrong version of a module among ones with the same name happening in some cases [33296d40]
    + Fix overwriting of the `.repo-id` file in some cases [fbb5228e][bc2cac13]
    + Fix `require` of a package with globally existing class names [d4f7d174]
    + Fix displaying a warning when using `is` routine from the `Test` module
      when comparing objects where calling `.Str` is impossible [69aaa424]
    + Prevent heredocs from improperly using block variables when continuing after the block [a78c9f0d]
    + Fix a bug where calling `substr` method on a `Str` object without arguments led to infinite loop [93f0d86f]
  + Internal:
    + Log event of exhausting system threads when `RAKUDO_SCHEDULER_DEBUG` env var is enabled [ffaf453d]
    + Pass `lib` in `RAKULIB` instead of `-I` in the `harness6` script [e09df02c]
    + Rewrite `INDIRECT_NAME_LOOKUP` [431c3d6b]
    + Use `$*RAKU` instead of `$*PERL` in more places [ff6951f5]
    + Add `:override` parameter to `Rakudo::Internals.REGISTER-DYNAMIC` [4b8b566a]
    + Consistently use a number for value in name suggestions hash [c99ffc51]


The following people contributed to this release:

Jonathan Worthington, Elizabeth Mattijsen, Stefan Seifert, Daniel Green,
Timo Paulssen, Vadim Belman, Nicholas Clark, Tom Browder,
Will "Coke" Coleda, Daniel Sockwell, Juan Julián Merelo Guervós, Jimmy Zhuo,
Christian Bartolomäus, Nick Logan, Peter du Marchie van Voorthuysen,
Geoffrey Broadwell, Joseph Brenner, Bart Wiegmans, Jan-Olof Hendig,
Leon Timmermans, Marcel Timmerman, Nigel Hamilton, Stoned Elipot,
Sylvain Colinet, Tony O'Dell, Oleksandr Kyriukhin

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2021 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on Libera.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#152), is tentatively scheduled for 2021-11-19.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
