/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

 // Disable symbol overrides so that we can use system headers.
#define FORBIDDEN_SYMBOL_ALLOW_ALL

#include "file.h"
#include "script_preresponses.h"

static const PreResponse BARBOT_PRERESPONSES_EN[] = {
	{ 0x0CA02, 0x3D102 },
	{ 0x0CA68, 0x3D102 },
	{ 0x0C9DA, 0x3D102 },
	{ 0x0CA6A, 0x3D103 },
	{ 0x0C922, 0x3D099 },
	{ 0x0C97C, 0x3D099 },
	{ 0x0CA0B, 0x3D099 },
	{ 0x0CA72, 0x3D099 },
	{ 0x0CA0E, 0x3D107 },
	{ 0x0CA73, 0x3D107 },
	{ 0x0CA12, 0x3D108 },
	{ 0x0CA1C, 0x3D10E },
	{ 0x0CA83, 0x3D10E },
	{ 0x0CA1F, 0x3D110 },
	{ 0x0CA86, 0x3D110 },
	{ 0x0CA23, 0x3D112 },
	{ 0x0CA8A, 0x3D112 },
	{ 0x0CA92, 0x3D122 },
	{ 0x0CA30, 0x3D116 },
	{ 0x0CA96, 0x3D116 },
	{ 0x0CA36, 0x3D117 },
	{ 0x0C9FC, 0x3D117 },
	{ 0x0CA9B, 0x3D117 },
	{ 0x0CA63, 0x3D117 },
	{ 0x0CA38, 0x3D11B },
	{ 0x0CA15, 0x3D109 },
	{ 0x0CA7B, 0x3D109 },
	{ 0x0CA2E, 0x3D115 },
	{ 0x0CA94, 0x3D115 },
	{ 0x0CA5C, 0x3D115 },
	{ 0x0CA21, 0x3D111 },
	{ 0x0CA88, 0x3D111 },
	{ 0x0CA2A, 0x3D114 },
	{ 0x0CA28, 0x3D119 },
	{ 0x0CA8E, 0x3D119 },
	{ 0x0CA17, 0x3D10B },
	{ 0x0CA7D, 0x3D10B },
	{ 0x0CA4C, 0x3D10B },
	{ 0x0CA06, 0x3D105 },
	{ 0x0CA6C, 0x3D105 },
	{ 0x0CA0A, 0x3D106 },
	{ 0x0CA70, 0x3D106 },
	{ 0x0CA19, 0x3D10C },
	{ 0x0CA7F, 0x3D10C },
	{ 0x0C9FF, 0x3D101 },
	{ 0x0CA65, 0x3D101 },
	{ 0x00000, 0x00000 }
};
static const PreResponse BARBOT_PRERESPONSES_DE[] = {
	{ 0x0ca11, 0x3d102 },
	{ 0x0ca77, 0x3d102 },
	{ 0x0c9e9, 0x3d102 },
	{ 0x0ca79, 0x3d103 },
	{ 0x0c931, 0x3d099 },
	{ 0x0c98b, 0x3d099 },
	{ 0x0ca1a, 0x3d099 },
	{ 0x0ca81, 0x3d099 },
	{ 0x0ca1d, 0x3d107 },
	{ 0x0ca82, 0x3d107 },
	{ 0x0ca21, 0x3d108 },
	{ 0x0ca2b, 0x3d10e },
	{ 0x0ca92, 0x3d10e },
	{ 0x0ca2e, 0x3d110 },
	{ 0x0ca95, 0x3d110 },
	{ 0x0ca32, 0x3d112 },
	{ 0x0ca99, 0x3d112 },
	{ 0x0caa1, 0x3d122 },
	{ 0x0ca3f, 0x3d116 },
	{ 0x0caa5, 0x3d116 },
	{ 0x0ca45, 0x3d117 },
	{ 0x0ca0b, 0x3d117 },
	{ 0x0caaa, 0x3d117 },
	{ 0x0ca72, 0x3d117 },
	{ 0x0ca47, 0x3d11b },
	{ 0x0ca24, 0x3d109 },
	{ 0x0ca8a, 0x3d109 },
	{ 0x0ca3d, 0x3d115 },
	{ 0x0caa3, 0x3d115 },
	{ 0x0ca6b, 0x3d115 },
	{ 0x0ca30, 0x3d111 },
	{ 0x0ca97, 0x3d111 },
	{ 0x0ca39, 0x3d114 },
	{ 0x0ca37, 0x3d119 },
	{ 0x0ca9d, 0x3d119 },
	{ 0x0ca26, 0x3d10b },
	{ 0x0ca8c, 0x3d10b },
	{ 0x0ca5b, 0x3d10b },
	{ 0x0ca15, 0x3d105 },
	{ 0x0ca7b, 0x3d105 },
	{ 0x0ca19, 0x3d106 },
	{ 0x0ca7f, 0x3d106 },
	{ 0x0ca28, 0x3d10c },
	{ 0x0ca8e, 0x3d10c },
	{ 0x0ca0e, 0x3d101 },
	{ 0x0ca74, 0x3d101 },
	{ 0x00000, 0x00000 }
};

static const PreResponse BELLBOT_PRERESPONSES_EN[] = {
	{ 0x052DC, 0x30D40 },
	{ 0x054E9, 0x30D40 },
	{ 0x054EC, 0x30D40 },
	{ 0x054F0, 0x30D40 },
	{ 0x0532C, 0x31625 },
	{ 0x05330, 0x31625 },
	{ 0x05368, 0x31625 },
	{ 0x05369, 0x31625 },
	{ 0x0536A, 0x31625 },
	{ 0x0536B, 0x31625 },
	{ 0x0536C, 0x31625 },
	{ 0x0536D, 0x31625 },
	{ 0x053A4, 0x31625 },
	{ 0x0558A, 0x31625 },
	{ 0x05485, 0x31625 },
	{ 0x04EE7, 0x31625 },
	{ 0x04EE8, 0x31625 },
	{ 0x0530A, 0x31625 },
	{ 0x0530B, 0x31625 },
	{ 0x053F6, 0x31625 },
	{ 0x053F7, 0x31625 },
	{ 0x053F8, 0x31625 },
	{ 0x053F9, 0x31625 },
	{ 0x053FA, 0x31625 },
	{ 0x053FB, 0x31625 },
	{ 0x053FC, 0x31625 },
	{ 0x053FD, 0x31625 },
	{ 0x0556B, 0x31041 },
	{ 0x05499, 0x30D40 },
	{ 0x053E9, 0x30E01 },
	{ 0x053EB, 0x30E01 },
	{ 0x053EC, 0x30E01 },
	{ 0x053ED, 0x30E01 },
	{ 0x053EE, 0x30E01 },
	{ 0x053EF, 0x30E01 },
	{ 0x053F0, 0x30E01 },
	{ 0x053F1, 0x30E01 },
	{ 0x053F2, 0x30E01 },
	{ 0x053EA, 0x30E01 },
	{ 0x05441, 0x30F00 },
	{ 0x05444, 0x30F00 },
	{ 0x05445, 0x30F00 },
	{ 0x05443, 0x30F00 },
	{ 0x05446, 0x30F00 },
	{ 0x05447, 0x30F00 },
	{ 0x05448, 0x30F00 },
	{ 0x05449, 0x30F00 },
	{ 0x0544A, 0x30F00 },
	{ 0x0544B, 0x30F00 },
	{ 0x05442, 0x30F00 },
	{ 0x0527C, 0x315C8 },
	{ 0x00000, 0x00000 }
};

static const PreResponse BELLBOT_PRERESPONSES_DE[] = {
	{ 0x052e2, 0x30d40 },
	{ 0x054f1, 0x30d40 },
	{ 0x054f4, 0x30d40 },
	{ 0x054f8, 0x30d40 },
	{ 0x05332, 0x31625 },
	{ 0x05336, 0x31625 },
	{ 0x0536e, 0x31625 },
	{ 0x0536f, 0x31625 },
	{ 0x05370, 0x31625 },
	{ 0x05371, 0x31625 },
	{ 0x05372, 0x31625 },
	{ 0x05373, 0x31625 },
	{ 0x053ab, 0x31625 },
	{ 0x05592, 0x31625 },
	{ 0x0548c, 0x31625 },
	{ 0x04ee7, 0x31625 },
	{ 0x04ee8, 0x31625 },
	{ 0x05310, 0x31625 },
	{ 0x05311, 0x31625 },
	{ 0x053fd, 0x31625 },
	{ 0x053fe, 0x31625 },
	{ 0x053ff, 0x31625 },
	{ 0x05400, 0x31625 },
	{ 0x05401, 0x31625 },
	{ 0x05402, 0x31625 },
	{ 0x05403, 0x31625 },
	{ 0x05404, 0x31625 },
	{ 0x05573, 0x31041 },
	{ 0x054a1, 0x30d40 },
	{ 0x053f0, 0x30e01 },
	{ 0x053f2, 0x30e01 },
	{ 0x053f3, 0x30e01 },
	{ 0x053f4, 0x30e01 },
	{ 0x053f5, 0x30e01 },
	{ 0x053f6, 0x30e01 },
	{ 0x053f7, 0x30e01 },
	{ 0x053f8, 0x30e01 },
	{ 0x053f9, 0x30e01 },
	{ 0x053f1, 0x30e01 },
	{ 0x05448, 0x30f00 },
	{ 0x0544b, 0x30f00 },
	{ 0x0544c, 0x30f00 },
	{ 0x0544a, 0x30f00 },
	{ 0x0544d, 0x30f00 },
	{ 0x0544e, 0x30f00 },
	{ 0x0544f, 0x30f00 },
	{ 0x05450, 0x30f00 },
	{ 0x05451, 0x30f00 },
	{ 0x05452, 0x30f00 },
	{ 0x05449, 0x30f00 },
	{ 0x05282, 0x315c8 },
	{ 0x00000, 0x00000 }
};

void writeScriptPreResponses(const char *name, const PreResponse *states) {
	outputFile.seek(dataOffset);

	for (; states->_src; ++states) {
		outputFile.writeLong(states->_src);
		outputFile.writeLong(states->_dest);
	}

	uint size = outputFile.size() - dataOffset;
	writeEntryHeader(name, dataOffset, size);
	dataOffset += size;
}

void writeAllScriptPreResponses() {
	writeScriptPreResponses("PreResponses/Barbot", BARBOT_PRERESPONSES_EN);
	writeScriptPreResponses("PreResponses/Barbot/DE", BARBOT_PRERESPONSES_DE);
	writeScriptPreResponses("PreResponses/Bellbot", BELLBOT_PRERESPONSES_EN);
	writeScriptPreResponses("PreResponses/Bellbot/DE", BELLBOT_PRERESPONSES_DE);
}
