/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef STATICDATA_H
#define STATICDATA_H

const int _cTableDialogIta[] = {
	-1,  -1,  -1, -1, -1, -1, -1, -1, -1,  -1,
	-1,  -1,  -1, -1, -1, -1, -1, -1, -1,  -1,
	-1,  -1,  -1, -1, -1, -1, -1, -1, -1,  -1,
	-1,  -1,  -1, 71, 77, -1, 80, 81, 82,  111,
	75,  76,  -1, 68, 63, 66, 64, 78, 52,  53,
	54,  55,  56, 57, 58, 59, 60, 61, 65,  62,
	69,  83,  70, 73, -1, 0,  1,  2,  3,   4,
	5,   6,   7,  8,  9,  10, 11, 12, 13,  14,
	15,  16,  17, 18, 19, 20, 21, 22, 23,  24,
	25,  -1,  -1, -1, 77, 67, -1, 26, 27,  28,
	29,  30,  31, 32, 33, 34, 35, 36, 37,  38,
	39,  40,  41, 42, 43, 44, 45, 46, 47,  48,
	49,  50,  51, -1, -1, -1, -1, -1, -1,  -1,
	-1,  -1,  -1, -1, -1, -1, -1, -1, -1,  -1,
	-1,  -1,  -1, -1, -1, -1, -1, -1, -1,  -1,
	-1,  -1,  -1, -1, -1, -1, -1, -1, -1,  -1,
	-1,  -1,  -1, 79, -1, -1, -1, -1, -1,  87,
	-1,  84,  -1, -1, 86, -1, -1, -1, -1,  -1,
	-1,  -1,  -1, -1, -1, -1, -1, 85, -1,  -1,
	-1,  -1,  -1, -1, -1, -1, -1, -1, 108, -1,
	-1,  -1,  -1, -1, -1, -1, -1, -1, -1,  105,
	-1,  -1,  -1, -1, -1, -1, -1, -1, -1,  -1,
	-1,  -1,  -1, -1, 88, -1, -1, -1, 93,  99,
	107, 106, 89, 89, -1, 94, 90, -1, -1,  95,
	-1,  104, 91, -1, -1, -1, 96, -1, 109, 92,
	-1,  -1,  97, -1, -1, 98};

const int _lTableDialogIta[] = {
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 9,  5,  5,  13, 13, 13, 13, 5,
	7,  7,  13, 13, 5,  13, 5,  13, 13, 13,
	13, 13, 10, 13, 13, 13, 13, 13, 5,  5,
	13, 13, 13, 10, 13, 13, 13, 13, 13, 10,
	11, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 5,  13, 13, 14, 15, 12,
	13, 12, 13, 13, 13, 6,  13, 13, 5,  16,
	12, 11, 11, 13, 13, 12, 13, 12, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13};

const int _cTableDialogPol[] = {
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1,  -1,
	-1,  -1,  -1,  71,  77,  -1,  80,  81, 82,  111,
	75,  76,  -1,  68,  63,  66,  64,  78, 52,  53,
	54,  55,  56,  57,  58,  59,  60,  61, 65,  62,
	69,  83,  70,  73,  -1,  0,   1,   2,  3,   4,
	5,   6,   7,   8,   9,   10,  11,  12, 13,  14,
	15,  16,  17,  18,  19,  20,  21,  22, 23,  24,
	25,  -1,  -1,  -1,  77,  67,  -1,  26, 27,  28,
	29,  30,  31,  32,  33,  34,  35,  36, 37,  38,
	39,  40,  41,  42,  43,  44,  45,  46, 47,  48,
	49,  50,  51,  -1,  -1,  -1,  -1,  -1, -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1,  -1,
	124, -1,  -1,  128, -1,  -1,  -1,  -1, -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  125, -1, -1,  129,
	-1,  -1,  -1,  118, -1,  112, -1,  -1, -1,  87,
	-1,  84,  -1,  -1,  86,  126, -1,  -1, -1,  119,
	-1,  -1,  -1,  -1,  -1,  113, -1,  85, -1,  -1,
	-1,  127, -1,  -1,  -1,  -1,  -1,  -1, 114, -1,
	-1,  -1,  116, -1,  -1,  -1,  -1,  -1, -1,  120,
	-1,  122, -1,  -1,  -1,  -1,  -1,  -1, -1,  -1,
	-1,  -1,  -1,  -1,  88,  -1,  -1,  -1, 93,  99,
	115, 106, 89,  89,  117, 94,  90,  -1, -1,  95,
	-1,  121, 91,  123, -1,  -1,  96,  -1, 109, 92,
	-1,  -1,  97,  -1,  -1,  98};

const int _lTableDialogPol[] = {
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 9,  5,  5,  13, 13, 13, 13, 5,
	7,  7,  13, 13, 5,  13, 5,  13, 13, 13,
	13, 13, 10, 13, 13, 13, 13, 13, 5,  5,
	13, 13, 13, 10, 13, 13, 13, 13, 13, 10,
	11, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 5,  13, 13, 14, 15, 12,
	13, 12, 13, 13, 13, 6,  13, 13, 5,  16,
	12, 11, 11, 13, 13, 12, 13, 12, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	12, 13, 13, 14, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 12, 13, 13, 13,
	13, 13, 13, 14, 13, 14, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 9,
	13, 13, 13, 13, 13, 16, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 12, 13,
	13, 13, 11, 13, 13, 13, 13, 13, 13, 10,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	12, 13, 13, 13, 12, 13, 13, 13, 13, 13,
	13, 11, 13, 11, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13};

const int _cTableDialogRus[] = {
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  71,  77,  -1,  80,  81,  82,  111,
	75,  76,  -1,  68,  63,  66,  64,  78,  52,  53,
	54,  55,  56,  57,  58,  59,  60,  61,  65,  62,
	69,  83,  70,  73,  -1,  0,   1,   2,   3,   4,
	5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
	15,  16,  17,  18,  19,  20,  21,  22,  23,  24,
	25,  -1,  -1,  -1,  77,  67,  -1,  26,  27,  28,
	29,  30,  31,  32,  33,  34,  35,  36,  37,  38,
	39,  40,  41,  42,  43,  44,  45,  46,  47,  48,
	49,  50,  51,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  79,  -1,  -1,  -1,  -1,  136, 87,
	-1,  84,  -1,  -1,  86,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  169, -1,  -1,  85,  -1,  -1,
	-1,  -1,  130, 131, 132, 133, 134, 135, 137, 138,
	139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
	149, 150, 151, 152, 153, 154, 155, 156, 158, 159,
	157, 160, 161, 162, 163, 164, 165, 166, 167, 168,
	170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
	180, 181, 182, 183, 184, 185, 186, 187, 188, 189,
	191, 192, 190, 193, 194, 195};

const int _lTableDialogRus[] = {
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 9,  5,  5,  13, 13, 13, 13, 5,
	7,  7,  13, 13, 5,  13, 5,  13, 13, 13,
	13, 13, 10, 13, 13, 13, 13, 13, 5,  5,
	13, 13, 13, 10, 13, 13, 13, 13, 13, 10,
	11, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 5,  13, 13, 14, 15, 12,
	13, 12, 13, 13, 13, 6,  13, 13, 5,  16,
	12, 11, 11, 13, 13, 12, 13, 12, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 11, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 12, 13, 13, 13, 13, 13,
	13, 13, 13, 15, 15, 11, 15, 11, 15, 10,
	13, 13, 12, 13, 14, 14, 13, 11, 12, 12,
	18, 11, 13, 12, 13, 12, 17, 18, 18, 19,
	16, 11, 16, 14, 14, 15, 10, 12, 13, 12,
	12, 10, 10, 10, 11, 12, 12, 12, 12, 10,
	11, 10, 14, 8,  11, 11, 12, 10, 15, 16,
	16, 16, 14, 9,  15, 14};

const int _cTableDialogCze[] = {
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  71,  77,  -1,  80,  81,  82,  111,
	75,  76,  -1,  68,  63,  66,  64,  78,  52,  53,
	54,  55,  56,  57,  58,  59,  60,  61,  65,  62,
	69,  83,  70,  73,  -1,  0,   1,   2,   3,   4,
	5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
	15,  16,  17,  18,  19,  20,  21,  22,  23,  24,
	25,  -1,  -1,  -1,  77,  67,  -1,  26,  27,  28,
	29,  30,  31,  32,  33,  34,  35,  36,  37,  38,
	39,  40,  41,  42,  43,  44,  45,  46,  47,  48,
	49,  50,  51,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  197, -1,
	-1,  206, 200, -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  212, -1,  -1,  221, 215, -1,
	-1,  -1,  -1,  79,  -1,  -1,  -1,  -1,  -1,  87,
	-1,  84,  -1,  -1,  86,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  85,  -1,  -1,
	-1,  -1,  -1,  202, -1,  -1,  -1,  -1,  108, -1,
	198, 204, -1,  -1,  196, 203, -1,  205, -1,  105,
	207, 208, -1,  -1,  -1,  -1,  199, 209, 210, -1,
	-1,  201, -1,  -1,  88,  217, -1,  -1,  93,  99,
	107, 106, 213, 219, -1,  94,  211, 218, -1,  220,
	-1,  104, 222, 223, -1,  -1,  96,  -1,  214, 224,
	225, -1,  97,  216, -1,  98};

const int _lTableDialogCze[] = {
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 9,  5,  5,  13, 13, 13, 13, 5,
	7,  7,  13, 13, 5,  13, 5,  13, 13, 13,
	13, 13, 10, 13, 13, 13, 13, 13, 5,  5,
	13, 13, 13, 10, 13, 13, 13, 13, 13, 10,
	11, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 5,  13, 13, 14, 15, 12,
	13, 12, 13, 13, 13, 6,  13, 13, 5,  16,
	12, 11, 11, 13, 13, 12, 13, 12, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 12, 13,
	13, 19, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 12, 13, 13, 16, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	12, 11, 13, 13, 11, 11, 13, 15, 13, 13,
	10, 13, 13, 13, 13, 13, 14, 13, 13, 13,
	13, 11, 13, 13, 13, 15, 13, 13, 13, 13,
	13, 13, 12, 12, 13, 13, 12, 7,  13, 17,
	13, 13, 11, 11, 13, 13, 13, 13, 12, 13,
	13, 13, 13, 11, 13, 13};

const int _cTableDialogFra[] = {
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, 71,  77,  -1, 80,  81, 82,  111,
	75,  76,  -1, 68,  63,  66, 64,  78, 52,  53,
	54,  55,  56, 57,  58,  59, 60,  61, 65,  62,
	69,  83,  70, 73,  -1,  0,  1,   2,  3,   4,
	5,   6,   7,  8,   9,   10, 11,  12, 13,  14,
	15,  16,  17, 18,  19,  20, 21,  22, 23,  24,
	25,  -1,  -1, -1,  77,  67, -1,  26, 27,  28,
	29,  30,  31, 32,  33,  34, 35,  36, 37,  38,
	39,  40,  41, 42,  43,  44, 45,  46, 47,  48,
	49,  50,  51, -1,  -1,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, 79,  -1,  -1, -1,  -1, -1,  87,
	-1,  84,  -1, -1,  86,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  85, -1,  -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, 108, -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1,  105,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, -1,  88,  -1, 226, -1, 93,  99,
	107, 106, 89, 227, 228, 94, 90,  -1, 229, 95,
	-1,  104, 91, -1,  232, -1, 233, -1, 109, 230,
	-1,  231, 97, -1, -1, 98};

const int _lTableDialogFra[] = {
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 9,  5,  5,  13, 13, 13, 13, 5,
	7,  7,  13, 13, 5,  13, 5,  13, 13, 13,
	13, 13, 10, 13, 13, 13, 13, 13, 5,  5,
	13, 13, 13, 10, 13, 13, 13, 13, 13, 10,
	11, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 5,  13, 13, 14, 15, 12,
	13, 12, 13, 13, 13, 6,  13, 13, 5,  16,
	12, 11, 11, 13, 13, 12, 13, 12, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 15, 13, 13, 13,
	13, 13, 13, 12, 12, 13, 13, 13, 9,  13,
	13, 13, 13, 13, 11, 13, 11, 13, 13, 13,
	13, 13, 13, 13, 13, 13};

const int _cTableDialogDeu[] = {
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, 71,  77,  -1, 80,  81, 82,  111,
	75,  76,  -1, 68,  63,  66, 64,  78, 52,  53,
	54,  55,  56, 57,  58,  59, 60,  61, 65,  62,
	69,  83,  70, 73,  -1,  0,  1,   2,  3,   4,
	5,   6,   7,  8,   9,   10, 11,  12, 13,  14,
	15,  16,  17, 18,  19,  20, 21,  22, 23,  24,
	25,  -1,  -1, -1,  77,  67, -1,  26, 27,  28,
	29,  30,  31, 32,  33,  34, 35,  36, 37,  38,
	39,  40,  41, 42,  43,  44, 45,  46, 47,  48,
	49,  50,  51, -1,  -1,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, 79,  -1,  -1, -1,  -1, -1,  87,
	-1,  84,  -1, -1,  86,  -1, -1,  -1, -1,  -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  85, -1,  -1,
	-1,  -1,  -1, -1,  -1,  -1, 236, -1, 108, -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1,  105,
	-1,  -1,  -1, -1,  237, -1, -1,  -1, -1,  -1,
	238, -1,  -1, 234, 88,  -1, -1,  -1, 93,  99,
	107, 106, 89, 89,  -1,  94, 90,  -1, -1,  95,
	-1,  104, 91, -1,  -1,  -1, 96,  -1, 109, 92,
	-1,  -1,  97, -1,  -1,  98};

const int _lTableDialogDeu[] = {
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 9,  5,  5,  13, 13, 13, 13, 5,
	7,  7,  13, 13, 5,  13, 5,  13, 13, 13,
	13, 13, 10, 13, 13, 13, 13, 13, 5,  5,
	13, 13, 13, 10, 13, 13, 13, 13, 13, 10,
	11, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 5,  13, 13, 14, 15, 12,
	13, 12, 13, 13, 13, 6,  13, 13, 5,  16,
	12, 11, 11, 13, 13, 12, 13, 12, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 15, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13};

const int _cTableMaccIta[] = {
	-1, -1,  -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1,  -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1,  -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1,  -1, 62, 64, -1, 65, 66, 67, -1,
	69, 70,  74, 75, 78, 81, 79, 84, 52, 53,
	54, 55,  56, 57, 58, 59, 60, 61, 80, 77,
	82, 71,  83, 72, -1, 0,  1,  2,  3,  4,
	5,  6,   7,  8,  9,  10, 11, 12, 13, 14,
	15, 16,  17, 18, 19, 20, 21, 22, 23, 24,
	25, -1,  -1, -1, -1, -1, -1, 26, 27, 28,
	29, 30,  31, 32, 33, 34, 35, 36, 37, 38,
	39, 40,  41, 42, 43, 44, 45, 46, 47, 48,
	49, 50,  51, -1, -1, -1, -1, -1, -1, -1,
	-1, -1,  -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1,  -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1,  -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1,  -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1,  -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1,  -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1,  -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1,  -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1,  -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1,  -1, -1, 86, -1, -1, -1, 87, 88,
	-1, 101, 89, -1, -1, 90, 92, -1, -1, 93,
	-1, 76,  95, -1, -1, -1, 96, -1, -1, 98,
	-1, -1,  99, -1, -1, 85};

const int _lTableMaccIta[] = {
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10};

const int _cTableMaccPol[] = {
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1,  -1,
	-1,  -1,  -1,  62,  64,  -1,  65,  66, 67,  -1,
	69,  70,  74,  75,  78,  81,  79,  84, 52,  53,
	54,  55,  56,  57,  58,  59,  60,  61, 80,  77,
	82,  71,  83,  72,  -1,  0,   1,   2,  3,   4,
	5,   6,   7,   8,   9,   10,  11,  12, 13,  14,
	15,  16,  17,  18,  19,  20,  21,  22, 23,  24,
	25,  -1,  -1,  -1,  -1,  -1,  -1,  26, 27,  28,
	29,  30,  31,  32,  33,  34,  35,  36, 37,  38,
	39,  40,  41,  42,  43,  44,  45,  46, 47,  48,
	49,  50,  51,  -1,  -1,  -1,  -1,  -1, -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1,  -1,
	114, -1,  -1,  118, -1,  -1,  -1,  -1, -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  115, -1, -1,  119,
	-1,  -1,  -1,  108, -1,  102, -1,  -1, -1,  -1,
	-1,  -1,  -1,  -1,  -1,  116, -1,  -1, -1,  109,
	-1,  -1,  -1,  -1,  -1,  103, -1,  -1, -1,  -1,
	-1,  117, -1,  -1,  -1,  -1,  -1,  -1, 104, -1,
	-1,  -1,  106, -1,  -1,  -1,  -1,  -1, -1,  110,
	-1,  112, -1,  -1,  -1,  -1,  -1,  -1, -1,  -1,
	-1,  -1,  -1,  -1,  86,  -1,  -1,  -1, 87,  88,
	105, 101, 89,  -1,  107, 90,  92,  -1, -1,  93,
	-1,  111, 95,  113, -1,  -1,  96,  -1, -1,  98,
	-1,  -1,  99,  -1,  -1,  85};

const int _lTableMaccPol[] = {
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	12, 10, 10, 14, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 12, 10, 10, 13,
	10, 10, 10, 14, 10, 14, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 13, 10, 10, 10, 9,
	10, 10, 10, 10, 10, 16, 10, 10, 10, 10,
	10, 13, 10, 10, 10, 10, 10, 10, 12, 10,
	10, 10, 11, 10, 10, 10, 10, 10, 10, 10,
	10, 13, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	12, 10, 10, 10, 12, 10, 10, 10, 10, 10,
	10, 11, 10, 11, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10};

const int _cTableMaccRus[] = {
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  62,  64,  -1,  65,  66,  67,  -1,
	69,  70,  74,  75,  78,  81,  79,  84,  52,  53,
	54,  55,  56,  57,  58,  59,  60,  61,  80,  77,
	82,  71,  83,  72,  -1,  0,   1,   2,   3,   4,
	5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
	15,  16,  17,  18,  19,  20,  21,  22,  23,  24,
	25,  -1,  -1,  -1,  -1,  -1,  -1,  26,  27,  28,
	29,  30,  31,  32,  33,  34,  35,  36,  37,  38,
	39,  40,  41,  42,  43,  44,  45,  46,  47,  48,
	49,  50,  51,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  126, -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  159, -1,  -1,  -1,  -1,  -1,
	-1,  -1,  120, 121, 122, 123, 124, 125, 127, 128,
	129, 130, 131, 132, 133, 134, 135, 136, 137, 138,
	139, 140, 141, 142, 143, 144, 145, 146, 148, 149,
	147, 150, 151, 152, 153, 154, 155, 156, 157, 158,
	160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
	170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
	181, 182, 180, 183, 184, 185};

const int _lTableMaccRus[] = {
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 9,  10, 10, 10, 10, 10,
	10, 10, 11, 11, 11, 9,  10, 10, 11, 10,
	10, 10, 11, 9,  11, 10, 11, 8,  10, 10,
	11, 11, 11, 11, 10, 10, 10, 10, 11, 11,
	11, 11, 11, 11, 10, 10, 11, 10, 9,  10,
	10, 9,  11, 11, 11, 11, 11, 11, 10, 9,
	11, 10, 9,  11, 10, 11, 10, 10, 11, 11,
	10, 10, 10, 9,  11, 11};

const int _cTableMaccCze[] = {
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  62,  64,  -1,  65,  66,  67,  -1,
	69,  70,  74,  75,  78,  81,  79,  84,  52,  53,
	54,  55,  56,  57,  58,  59,  60,  61,  80,  77,
	82,  71,  83,  72,  -1,  0,   1,   2,   3,   4,
	5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
	15,  16,  17,  18,  19,  20,  21,  22,  23,  24,
	25,  -1,  -1,  -1,  -1,  -1,  -1,  26,  27,  28,
	29,  30,  31,  32,  33,  34,  35,  36,  37,  38,
	39,  40,  41,  42,  43,  44,  45,  46,  47,  48,
	49,  50,  51,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  187, -1,
	-1,  196, 190, -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  202, -1,  -1,  211, 205, -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  192, -1,  -1,  -1,  -1,  -1,  -1,
	188, 194, -1,  -1,  186, 193, -1,  195, -1,  -1,
	197, 198, -1,  -1,  -1,  -1,  189, 199, 200, -1,
	-1,  191, -1,  -1,  86,  207, -1,  -1,  87,  88,
	-1,  101, 203, 209, -1,  90,  201, 208, -1,  210,
	-1,  76,  212, 213, -1,  -1,  96,  -1,  204, 214,
	215, -1,  99,  206, -1,  85};

const int _lTableMaccCze[] = {
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 11, 9,  10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 9,  10, 10, 11, 9,  10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 11, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 9,  10, 11, 10, 10,
	11, 11, 10, 10, 10, 10, 11, 11, 11, 10,
	10, 11, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 9,  10, 11,
	10, 10, 11, 10, 10, 10, 10, 10, 10, 11,
	11, 10, 10, 11, 10, 10};

const int _cTableMaccFra[] = {
	-1, -1,  -1,  -1,  -1,  -1, -1,  -1, -1,  -1,
	-1, -1,  -1,  -1,  -1,  -1, -1,  -1, -1,  -1,
	-1, -1,  -1,  -1,  -1,  -1, -1,  -1, -1,  -1,
	-1, -1,  -1,  62,  64,  -1, 65,  66, 67,  -1,
	69, 70,  74,  75,  78,  81, 79,  84, 52,  53,
	54, 55,  56,  57,  58,  59, 60,  61, 80,  77,
	82, 71,  83,  72,  -1,  0,  1,   2,  3,   4,
	5,  6,   7,   8,   9,   10, 11,  12, 13,  14,
	15, 16,  17,  18,  19,  20, 21,  22, 23,  24,
	25, -1,  -1,  -1,  -1,  -1, -1,  26, 27,  28,
	29, 30,  31,  32,  33,  34, 35,  36, 37,  38,
	39, 40,  41,  42,  43,  44, 45,  46, 47,  48,
	49, 50,  51,  -1,  -1,  -1, -1,  -1, -1,  -1,
	-1, -1,  -1,  -1,  -1,  -1, -1,  -1, -1,  -1,
	-1, -1,  -1,  -1,  -1,  -1, -1,  -1, -1,  -1,
	-1, -1,  -1,  -1,  -1,  -1, -1,  -1, -1,  -1,
	-1, -1,  -1,  -1,  -1,  -1, -1,  -1, -1,  -1,
	-1, -1,  -1,  -1,  -1,  -1, -1,  -1, -1,  -1,
	-1, -1,  -1,  -1,  -1,  -1, -1,  -1, -1,  -1,
	-1, -1,  -1,  -1,  -1,  -1, -1,  -1, -1,  -1,
	-1, -1,  -1,  -1,  -1,  -1, -1,  -1, -1,  -1,
	-1, -1,  -1,  -1,  -1,  -1, -1,  -1, -1,  -1,
	-1, -1,  -1,  -1,  86,  -1, 226, -1, 87,  88,
	-1, 101, 228, 227, -1,  90, 92,  -1, 229, 93,
	-1, 76,  95,  -1,  232, -1, 233, -1, -1,  230,
	-1, 231, 99,  -1,  -1,  85};

const int _lTableMaccFra[] = {
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 8,  10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 11,
	10, 11, 10, 10, 10, 10};

const int _cTableMaccDeu[] = {
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1, -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1, -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1, -1,
	-1,  -1,  -1, 62,  64,  -1, 65,  66, 67, -1,
	69,  70,  74, 75,  78,  81, 79,  84, 52, 53,
	54,  55,  56, 57,  58,  59, 60,  61, 80, 77,
	82,  71,  83, 72,  -1,  0,  1,   2,  3,  4,
	5,   6,   7,  8,   9,   10, 11,  12, 13, 14,
	15,  16,  17, 18,  19,  20, 21,  22, 23, 24,
	25,  -1,  -1, -1,  -1,  -1, -1,  26, 27, 28,
	29,  30,  31, 32,  33,  34, 35,  36, 37, 38,
	39,  40,  41, 42,  43,  44, 45,  46, 47, 48,
	49,  50,  51, -1,  -1,  -1, -1,  -1, -1, -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1, -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1, -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1, -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1, -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1, -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1, -1,
	-1,  -1,  -1, -1,  -1,  -1, 236, -1, -1, -1,
	-1,  -1,  -1, -1,  -1,  -1, -1,  -1, -1, -1,
	-1,  -1,  -1, -1,  237, -1, -1,  -1, -1, -1,
	238, -1,  -1, 234, 86,  -1, -1,  -1, 87, 88,
	-1,  101, 89, -1,  -1,  90, 92,  -1, -1, 93,
	-1,  76,  95, -1,  -1,  -1, 96,  -1, -1, 98,
	-1,  -1,  99, -1,  -1,  85};

const int _lTableMaccDeu[] = {
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 11, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10};

const int _cTableCredIta[] = {
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  81,  -1,  -1,  -1,  90,  91,  111,
	84,  85,  99,  93,  95,  -1,  100, 92,  101, 102,
	103, 104, 105, 106, 107, 108, 109, 110, 89,  94,
	-1,  97,  -1,  79,  -1,  0,   1,   2,   3,   4,
	5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
	15,  16,  17,  18,  19,  20,  21,  22,  23,  24,
	25,  -1,  -1,  -1,  96,  98,  -1,  26,  27,  28,
	29,  30,  31,  32,  33,  34,  35,  36,  37,  38,
	39,  40,  41,  42,  43,  44,  45,  46,  47,  48,
	49,  50,  51,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  77,
	-1,  86,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  87,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  52,  53,  -1,  -1,  -1,  -1,
	-1,  74,  56,  57,  -1,  -1,  60,  61,  -1,  -1,
	-1,  73,  64,  65,  -1,  -1,  -1,  -1,  -1,  68,
	69,  -1,  -1,  -1,  -1,  -1};

const int _lTableCredIta[] = {
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 11, 10, 10, 10, 10, 10, 10, 5,
	10, 10, 10, 10, 5,  10, 5,  10, 12, 8,
	10, 11, 12, 11, 12, 10, 11, 10, 5,  5,
	10, 10, 10, 10, 10, 19, 15, 14, 13, 14,
	13, 16, 15, 5,  8,  15, 13, 17, 15, 14,
	12, 14, 14, 15, 11, 12, 12, 16, 12, 13,
	14, 10, 10, 10, 9,  10, 10, 11, 9,  9,
	10, 9,  8,  9,  10, 5,  6,  12, 6,  14,
	10, 11, 11, 9,  9,  9,  6,  9,  10, 14,
	9,  10, 9,  10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 19, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10};

const int _cTableCredPol[] = {
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  81,  -1,  -1,  -1,  90,  91,  111,
	84,  85,  99,  93,  95,  -1,  100, 92,  101, 102,
	103, 104, 105, 106, 107, 108, 109, 110, 89,  94,
	-1,  97,  -1,  79,  -1,  0,   1,   2,   3,   4,
	5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
	15,  16,  17,  18,  19,  20,  21,  22,  23,  24,
	25,  -1,  -1,  -1,  96,  98,  -1,  26,  27,  28,
	29,  30,  31,  32,  33,  34,  35,  36,  37,  38,
	39,  40,  41,  42,  43,  44,  45,  46,  47,  48,
	49,  50,  51,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	124, -1,  -1,  128, -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  125, -1,  -1,  129,
	-1,  -1,  -1,  118, -1,  112, -1,  -1,  -1,  77,
	-1,  86,  -1,  -1,  -1,  126, -1,  -1,  -1,  119,
	-1,  -1,  -1,  -1,  -1,  113, -1,  87,  -1,  -1,
	-1,  127, -1,  -1,  -1,  -1,  -1,  -1,  114, -1,
	-1,  -1,  116, -1,  -1,  -1,  -1,  -1,  -1,  120,
	-1,  122, -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  52,  53,  -1,  -1,  -1,  -1,
	115, 74,  56,  57,  117, -1,  60,  61,  -1,  -1,
	-1,  121, 64,  123, -1,  -1,  -1,  -1,  -1,  68,
	69,  -1,  -1,  -1,  -1,  -1};

const int _lTableCredPol[] = {
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 11, 10, 10, 10, 10, 10, 10, 5,
	10, 10, 10, 10, 5,  10, 5,  10, 12, 8,
	10, 11, 12, 11, 12, 10, 11, 10, 5,  5,
	10, 10, 10, 10, 10, 19, 15, 14, 13, 14,
	13, 16, 15, 5,  8,  15, 13, 17, 15, 14,
	12, 14, 14, 15, 11, 12, 12, 16, 12, 13,
	14, 10, 10, 10, 9,  10, 10, 11, 9,  9,
	10, 9,  8,  9,  10, 5,  6,  12, 6,  14,
	10, 11, 11, 9,  9,  9,  6,  9,  10, 14,
	9,  10, 9,  10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	15, 10, 10, 15, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 14, 10, 20, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 15, 10, 10, 10, 11,
	10, 10, 10, 10, 10, 12, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 19, 10, 15, 10,
	10, 10, 15, 10, 10, 10, 10, 10, 10, 16,
	10, 15, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 11, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10};

const int _cTableCredRus[] = {
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  81,  -1,  -1,  -1,  90,  91,  111,
	84,  85,  99,  93,  95,  -1,  100, 92,  101, 102,
	103, 104, 105, 106, 107, 108, 109, 110, 89,  94,
	-1,  97,  -1,  79,  -1,  0,   1,   2,   3,   4,
	5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
	15,  16,  17,  18,  19,  20,  21,  22,  23,  24,
	25,  -1,  -1,  -1,  96,  98,  -1,  26,  27,  28,
	29,  30,  31,  32,  33,  34,  35,  36,  37,  38,
	39,  40,  41,  42,  43,  44,  45,  46,  47,  48,
	49,  50,  51,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  136, 77,
	-1,  86,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  169, -1,  -1,  87,  -1,  -1,
	-1,  -1,  130, 131, 132, 133, 134, 135, 137, 138,
	139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
	149, 150, 151, 152, 153, 154, 155, 156, 158, 159,
	157, 160, 161, 162, 163, 164, 165, 166, 167, 168,
	170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
	180, 181, 182, 183, 184, 185, 186, 187, 188, 189,
	191, 192, 190, 193, 194, 195};

const int _lTableCredRus[] = {
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 11, 10, 10, 10, 10, 10, 10, 5,
	10, 10, 10, 10, 5,  10, 5,  10, 12, 8,
	10, 11, 12, 11, 12, 10, 11, 10, 5,  5,
	10, 10, 10, 10, 10, 19, 15, 14, 13, 14,
	13, 16, 15, 5,  8,  15, 13, 17, 15, 14,
	12, 14, 14, 15, 11, 12, 12, 16, 12, 13,
	14, 10, 10, 10, 9,  10, 10, 11, 9,  9,
	10, 9,  8,  9,  10, 5,  6,  12, 6,  14,
	10, 11, 11, 9,  9,  9,  6,  9,  10, 14,
	9,  10, 9,  10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 15, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 11, 10, 10, 10, 10, 10,
	10, 10, 20, 16, 16, 14, 22, 15, 20, 12,
	16, 16, 16, 22, 18, 16, 15, 14, 13, 15,
	12, 14, 15, 13, 16, 14, 23, 23, 12, 16,
	10, 12, 20, 15, 12, 10, 10, 11, 16, 10,
	13, 12, 13, 13, 12, 13, 14, 11, 11, 11,
	12, 10, 10, 10, 11, 10, 11, 10, 15, 15,
	12, 16, 10, 11, 13, 11};

const int _cTableCredCze[] = {
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  81,  -1,  -1,  -1,  90,  91,  111,
	84,  85,  99,  93,  95,  -1,  100, 92,  101, 102,
	103, 104, 105, 106, 107, 108, 109, 110, 89,  94,
	-1,  97,  -1,  79,  -1,  0,   1,   2,   3,   4,
	5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
	15,  16,  17,  18,  19,  20,  21,  22,  23,  24,
	25,  -1,  -1,  -1,  96,  98,  -1,  26,  27,  28,
	29,  30,  31,  32,  33,  34,  35,  36,  37,  38,
	39,  40,  41,  42,  43,  44,  45,  46,  47,  48,
	49,  50,  51,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  197, -1,
	-1,  206, 200, -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  212, -1,  -1,  221, 215, -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  77,
	-1,  86,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  87,  -1,  -1,
	-1,  -1,  -1,  202, -1,  -1,  -1,  -1,  -1,  -1,
	198, 204, -1,  -1,  196, 203, -1,  205, -1,  -1,
	207, 208, -1,  -1,  -1,  -1,  199, 209, 210, -1,
	-1,  201, -1,  -1,  52,  217, -1,  -1,  -1,  -1,
	-1,  74,  213, 219, -1,  -1,  211, 218, -1,  220,
	-1,  73,  222, 223, -1,  -1,  -1,  -1,  214, 224,
	225, -1,  -1,  216, -1,  -1};

const int _lTableCredCze[] = {
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 11, 10, 10, 10, 10, 10, 10, 5,
	10, 10, 10, 10, 5,  10, 5,  10, 12, 8,
	10, 11, 12, 11, 12, 10, 11, 10, 5,  5,
	10, 10, 10, 10, 10, 19, 15, 14, 13, 14,
	13, 16, 15, 5,  8,  15, 13, 17, 15, 14,
	12, 14, 14, 15, 11, 12, 12, 16, 12, 13,
	14, 10, 10, 10, 9,  10, 10, 11, 9,  9,
	10, 9,  8,  9,  10, 5,  6,  12, 6,  14,
	10, 11, 11, 9,  9,  9,  6,  9,  10, 14,
	9,  10, 9,  10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 15, 10,
	10, 19, 15, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 11, 10, 10, 12, 11, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 20, 10, 10, 19, 10, 10, 10,
	15, 15, 10, 10, 15, 7,  10, 20, 10, 10,
	16, 15, 10, 10, 10, 10, 15, 13, 13, 10,
	10, 14, 10, 10, 10, 12, 10, 10, 10, 10,
	10, 10, 11, 10, 10, 10, 11, 6,  10, 15,
	10, 10, 11, 11, 10, 10, 10, 10, 11, 10,
	10, 10, 10, 10, 10, 10};

const int _cTableCredFra[] = {
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  81,  -1,  -1,  -1,  90,  91,  111,
	84,  85,  99,  93,  95,  -1,  100, 92,  101, 102,
	103, 104, 105, 106, 107, 108, 109, 110, 89,  94,
	-1,  97,  -1,  79,  -1,  0,   1,   2,   3,   4,
	5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
	15,  16,  17,  18,  19,  20,  21,  22,  23,  24,
	25,  -1,  -1,  -1,  96,  98,  -1,  26,  27,  28,
	29,  30,  31,  32,  33,  34,  35,  36,  37,  38,
	39,  40,  41,  42,  43,  44,  45,  46,  47,  48,
	49,  50,  51,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  77,
	-1,  86,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  87,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  52,  53,  226, -1,  -1,  -1,
	-1,  74,  56,  227, 228, -1,  60,  61,  229, -1,
	-1,  73,  64,  65,  232, -1,  233, -1,  -1,  230,
	69,  231, -1,  -1,  -1,  -1};

const int _lTableCredFra[] = {
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 11, 10, 10, 10, 10, 10, 10, 5,
	10, 10, 10, 10, 5,  10, 5,  10, 12, 8,
	10, 11, 12, 11, 12, 10, 11, 10, 5,  5,
	10, 10, 10, 10, 10, 19, 15, 14, 13, 14,
	13, 16, 15, 5,  8,  15, 13, 17, 15, 14,
	12, 14, 14, 15, 11, 12, 12, 16, 12, 13,
	14, 10, 10, 10, 9,  10, 10, 11, 9,  9,
	10, 9,  8,  9,  10, 5,  6,  12, 6,  14,
	10, 11, 11, 9,  9,  9,  6,  9,  10, 14,
	9,  10, 9,  10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 19, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 12, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 6,  10,
	10, 10, 10, 10, 11, 10, 11, 10, 10, 10,
	10, 10, 10, 10, 10, 10};

const int _cTableCredDeu[] = {
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  81,  -1,  -1,  -1,  90,  91,  111,
	84,  85,  99,  93,  95,  -1,  100, 92,  101, 102,
	103, 104, 105, 106, 107, 108, 109, 110, 89,  94,
	-1,  97,  -1,  79,  -1,  0,   1,   2,   3,   4,
	5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
	15,  16,  17,  18,  19,  20,  21,  22,  23,  24,
	25,  -1,  -1,  -1,  96,  98,  -1,  26,  27,  28,
	29,  30,  31,  32,  33,  34,  35,  36,  37,  38,
	39,  40,  41,  42,  43,  44,  45,  46,  47,  48,
	49,  50,  51,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  77,
	-1,  86,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  87,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  55,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  67,  -1,  -1,  -1,  -1,  -1,
	71,  -1,  -1,  234, 52,  53,  -1,  -1,  55,  -1,
	-1,  74,  56,  57,  -1,  -1 , 60,  61,  -1,  -1,
	-1,  73,  64,  65,  -1,  -1,  67,  -1,  -1,  68,
	69,  -1,  71,  -1,  -1,  -1};

const int _lTableCredDeu[] = {
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 11, 10, 10, 10, 10, 10, 10, 5,
	10, 10, 10, 10, 5,  10, 5,  10, 12, 8,
	10, 11, 12, 11, 12, 10, 11, 10, 5,  5,
	10, 10, 10, 10, 10, 19, 15, 14, 13, 14,
	13, 16, 15, 5,  8,  15, 13, 17, 15, 14,
	12, 14, 14, 15, 11, 12, 12, 16, 12, 13,
	14, 10, 10, 10, 9,  10, 10, 11, 9,  9,
	10, 9,  8,  9,  10, 5,  6,  12, 6,  14,
	10, 11, 11, 9,  9,  9,  6,  9,  10, 14,
	9,  10, 9,  10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 19, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 11, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10};

const int _cTableObjIta[] = {
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, 42, 51, -1, 53, 54, 55, 50,
	47, 48, 57, 41, 36, 40, 38, 46, 26, 27,
	28, 29, 30, 31, 32, 33, 34, 35, 39, 37,
	58, 49, 59, 44, -1, 0,  1,  2,  3,  4,
	5,  6,  7,  8,  9,  10, 11, 12, 13, 14,
	15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
	25, -1, -1, -1, 56, -1, -1, 0,  1,  2,
	3,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
	23, 24, 25, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	91, -1, -1, 93, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, 91, -1, -1, 93,
	-1, -1, -1, 88, -1, 85, -1, -1, -1, 67,
	-1, 60, -1, -1, 66, 92, -1, -1, -1, 88,
	-1, -1, -1, -1, -1, 85, -1, 61, -1, -1,
	-1, 92, -1, 69, -1, -1, 70, 71, 86, -1,
	72, -1, 87, 73, 75, -1, -1, 76, -1, 89,
	78, 90, -1, -1, 79, -1, -1, 81, -1, -1,
	82, -1, -1, -1, -1, -1, -1, -1, 70, -1,
	86, 63, -1, -1, 87, -1, -1, -1, -1, -1,
	-1, 89, -1, 90, -1, -1, 79, -1, 62, -1,
	-1, -1, 82, -1, -1, -1};

const int _lTableObjIta[] = {
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 11, 26, 26, 26, 26, 26, 26, 8,
	26, 26, 26, 26, 26, 12, 8,  26, 20, 20,
	15, 20, 20, 20, 20, 20, 20, 20, 26, 26,
	26, 26, 26, 26, 26, 17, 17, 19, 17, 15,
	17, 19, 17, 16, 26, 17, 14, 19, 17, 19,
	17, 19, 14, 13, 15, 15, 13, 19, 15, 13,
	20, 26, 26, 26, 26, 26, 26, 17, 17, 19,
	17, 15, 17, 19, 17, 16, 26, 17, 14, 19,
	17, 19, 17, 19, 14, 13, 15, 15, 13, 19,
	15, 13, 20, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	15, 26, 26, 21, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 15, 26, 26, 21,
	26, 26, 26, 19, 26, 20, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 21, 26, 26, 26, 19,
	26, 26, 26, 26, 26, 20, 26, 26, 26, 26,
	26, 21, 26, 26, 26, 26, 17, 26, 22, 26,
	26, 26, 17, 26, 26, 26, 26, 26, 26, 17,
	26, 22, 26, 26, 19, 26, 26, 26, 26, 26,
	15, 26, 26, 26, 26, 26, 26, 26, 17, 26,
	22, 26, 26, 26, 17, 26, 26, 26, 26, 26,
	26, 17, 26, 22, 26, 26, 19, 26, 26, 26,
	26, 26, 15, 26, 26, 26};

const int _cTableObjPol[] = {
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, 42, 51, -1, 53, 54, 55, 50,
	47, 48, 57, 41, 36, 40, 38, 46, 26, 27,
	28, 29, 30, 31, 32, 33, 34, 35, 39, 37,
	58, 49, 59, 44, -1, 0,  1,  2,  3,  4,
	5,  6,  7,  8,  9,  10, 11, 12, 13, 14,
	15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
	25, -1, -1, -1, 56, -1, -1, 0,  1,  2,
	3,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
	23, 24, 25, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	91, -1, -1, 93, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, 91, -1, -1, 93,
	-1, -1, -1, 88, -1, 85, -1, -1, -1, 67,
	-1, 60, -1, -1, 66, 92, -1, -1, -1, 88,
	-1, -1, -1, -1, -1, 85, -1, 61, -1, -1,
	-1, 92, -1, 69, -1, -1, 70, 71, 86, -1,
	72, -1, 87, 73, 75, -1, -1, 76, -1, 89,
	78, 90, -1, -1, 79, -1, -1, 81, -1, -1,
	82, -1, -1, -1, -1, -1, -1, -1, 70, -1,
	86, 63, -1, -1, 87, -1, -1, -1, -1, -1,
	-1, 89, -1, 90, -1, -1, 79, -1, 62, -1,
	-1, -1, 82, -1, -1, -1};

const int _lTableObjPol[] = {
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 11, 26, 26, 26, 26, 26, 26, 8,
	26, 26, 26, 26, 26, 12, 8,  26, 20, 20,
	15, 20, 20, 20, 20, 20, 20, 20, 26, 26,
	26, 26, 26, 26, 26, 17, 17, 19, 17, 15,
	17, 19, 17, 16, 26, 17, 14, 19, 17, 19,
	17, 19, 14, 13, 15, 15, 13, 19, 15, 13,
	20, 26, 26, 26, 26, 26, 26, 17, 17, 19,
	17, 15, 17, 19, 17, 16, 26, 17, 14, 19,
	17, 19, 17, 19, 14, 13, 15, 15, 13, 19,
	15, 13, 20, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	15, 26, 26, 21, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 15, 26, 26, 21,
	26, 26, 26, 19, 26, 20, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 21, 26, 26, 26, 19,
	26, 26, 26, 26, 26, 20, 26, 26, 26, 26,
	26, 21, 26, 26, 26, 26, 17, 26, 22, 26,
	26, 26, 17, 26, 26, 26, 26, 26, 26, 17,
	26, 22, 26, 26, 19, 26, 26, 26, 26, 26,
	15, 26, 26, 26, 26, 26, 26, 26, 17, 26,
	22, 26, 26, 26, 17, 26, 26, 26, 26, 26,
	26, 17, 26, 22, 26, 26, 19, 26, 26, 26,
	26, 26, 15, 26, 26, 26};

const int _cTableObjRus[] = {
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  42,  51,  -1,  53,  54,  55,  50,
	47,  48,  57,  41,  36,  40,  38,  46,  26,  27,
	28,  29,  30,  31,  32,  33,  34,  35,  39,  37,
	58,  49,  59,  44,  -1,  0,   1,   2,   3,   4,
	5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
	15,  16,  17,  18,  19,  20,  21,  22,  23,  24,
	25,  -1,  -1,  -1,  56,  -1,  -1,  0,   1,   2,
	3,   4,   5,   6,   7,   8,   9,   10,  11,  12,
	13,  14,  15,  16,  17,  18,  19,  20,  21,  22,
	23,  24,  25,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	91,  -1,  -1,  93,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  91,  -1,  -1,  93,
	-1,  -1,  -1,  88,  -1,  85,  -1,  -1,  100, 67,
	-1,  60,  -1,  -1,  66,  92,  -1,  -1,  -1,  88,
	-1,  -1,  -1,  -1,  100, 85,  -1,  61,  -1,  -1,
	-1,  92,  94,  95,  96,  97,  98,  99,  101, 102,
	103, 104, 105, 106, 107, 108, 109, 110, 111, 112,
	113, 114, 115, 116, 117, 118, 119, 120, 122, 123,
	121, 124, 125, 126, 94,  95,  96,  97,  98,  99,
	101, 102, 103, 104, 105, 106, 107, 108, 109, 110,
	111, 112, 113, 114, 115, 116, 117, 118, 119, 120,
	122, 123, 121, 124, 125, 126};

const int _lTableObjRus[] = {
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 11, 26, 26, 26, 26, 26, 26, 8,
	26, 26, 26, 26, 26, 12, 8,  26, 20, 20,
	15, 20, 20, 20, 20, 20, 20, 20, 26, 26,
	26, 26, 26, 26, 26, 17, 17, 19, 17, 15,
	17, 19, 17, 16, 26, 17, 14, 19, 17, 19,
	17, 19, 14, 13, 15, 15, 13, 19, 15, 13,
	20, 26, 26, 26, 26, 26, 26, 17, 17, 19,
	17, 15, 17, 19, 17, 16, 26, 17, 14, 19,
	17, 19, 17, 19, 14, 13, 15, 15, 13, 19,
	15, 13, 20, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	15, 26, 26, 21, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 15, 26, 26, 21,
	26, 26, 26, 19, 26, 20, 26, 26, 18, 26,
	26, 26, 26, 26, 26, 21, 26, 26, 26, 19,
	26, 26, 26, 26, 18, 20, 26, 26, 26, 26,
	26, 21, 18, 18, 18, 17, 16, 18, 20, 18,
	18, 18, 18, 16, 18, 15, 22, 15, 18, 22,
	19, 16, 21, 20, 16, 16, 19, 22, 19, 19,
	18, 15, 18, 18, 18, 18, 18, 17, 16, 18,
	20, 18, 18, 18, 18, 16, 18, 15, 22, 15,
	18, 22, 19, 16, 21, 20, 16, 16, 19, 22,
	19, 19, 18, 15, 18, 18};

const int _cTableObjCze[] = {
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  42,  51,  -1,  53,  54,  55,  50,
	47,  48,  57,  41,  36,  40,  38,  46,  26,  27,
	28,  29,  30,  31,  32,  33,  34,  35,  39,  37,
	58,  49,  59,  44,  -1,  0,   1,   2,   3,   4,
	5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
	15,  16,  17,  18,  19,  20,  21,  22,  23,  24,
	25,  -1,  -1,  -1,  56,  -1,  -1,  0,   1,   2,
	3,   4,   5,   6,   7,   8,   9,   10,  11,  12,
	13,  14,  15,  16,  17,  18,  19,  20,  21,  22,
	23,  24,  25,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  128, -1,
	91,  137, 131, 93,  -1,  -1,  -1,  -1,  -1,  -1,
	-1,  -1,  -1,  -1,  128, -1,  91,  137, 131, 93,
	-1,  -1,  -1,  88,  -1,  85,  -1,  -1,  -1,  67,
	-1,  60,  -1,  -1,  66,  92,  -1,  -1,  -1,  88,
	-1,  -1,  -1,  -1,  -1,  85,  -1,  61,  -1,  -1,
	-1,  92,  -1,  133, -1,  -1,  70,  71,  86,  -1,
	129, 135, 87,  73,  127, 134, -1,  136, -1,  89,
	138, 139, -1,  -1,  79,  -1,  130, 140, 141, -1,
	82,  132, -1,  -1,  -1,  133, -1,  -1,  70,  -1,
	86,  63,  129, 135, 87,  -1,  127, 134, -1,  136,
	-1,  89,  138, 139, -1,  -1,  79,  -1,  130, 140,
	141, -1,  82,  132, -1,  -1};

const int _lTableObjCze[] = {
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 11, 26, 26, 26, 26, 26, 26, 8,
	26, 26, 26, 26, 26, 12, 8,  26, 20, 20,
	15, 20, 20, 20, 20, 20, 20, 20, 26, 26,
	26, 26, 26, 26, 26, 17, 17, 19, 17, 15,
	17, 19, 17, 16, 26, 17, 14, 19, 17, 19,
	17, 19, 14, 13, 15, 15, 13, 19, 15, 13,
	20, 26, 26, 26, 26, 26, 26, 17, 17, 19,
	17, 15, 17, 19, 17, 16, 26, 17, 14, 19,
	17, 19, 17, 19, 14, 13, 15, 15, 13, 19,
	15, 13, 20, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 15, 26,
	15, 24, 21, 21, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 15, 26, 15, 24, 21, 21,
	26, 26, 26, 19, 26, 20, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 21, 26, 26, 26, 19,
	26, 26, 26, 26, 26, 20, 26, 26, 26, 26,
	26, 21, 26, 18, 26, 26, 17, 26, 22, 26,
	22, 17, 17, 26, 17, 19, 26, 23, 26, 17,
	17, 22, 26, 26, 19, 26, 18, 16, 16, 26,
	15, 16, 26, 26, 26, 18, 26, 26, 17, 26,
	22, 26, 22, 17, 17, 26, 17, 19, 26, 23,
	26, 17, 17, 22, 26, 26, 19, 26, 18, 16,
	16, 26, 15, 16, 26, 26};

const int _cTableObjFra[] = {
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, 42, 51, -1, 53, 54, 55, 50,
	47, 48, 57, 41, 36, 40, 38, 46, 26, 27,
	28, 29, 30, 31, 32, 33, 34, 35, 39, 37,
	58, 49, 59, 44, -1, 0,  1,  2,  3,  4,
	5,  6,  7,  8,  9,  10, 11, 12, 13, 14,
	15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
	25, -1, -1, -1, 56, -1, -1, 0,  1,  2,
	3,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
	23, 24, 25, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	91, -1, -1, 93, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, 91, -1, -1, 93,
	-1, -1, -1, 88, -1, 85, -1, -1, -1, 67,
	-1, 60, -1, -1, 66, 92, -1, -1, -1, 88,
	-1, -1, -1, -1, -1, 85, -1, 61, -1, -1,
	-1, 92, -1, 69, -1, -1, 70, 71, 86, -1,
	72, -1, 87, 73, 75, -1, -1, 76, -1, 89,
	78, 90, -1, -1, 79, -1, -1, 81, -1, -1,
	82, -1, -1, -1, 0,  0,  0,  -1, 70, -1,
	86, 63, 4,  4,  87, -1, 8,  8,  8,  -1,
	-1, 89, 14, 14, 14, -1, 14, -1, 62, 20,
	-1, 20, 82, -1, -1, -1};

const int _lTableObjFra[] = {
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 11, 26, 26, 26, 26, 26, 26, 8,
	26, 26, 26, 26, 26, 12, 8,  26, 20, 20,
	15, 20, 20, 20, 20, 20, 20, 20, 26, 26,
	26, 26, 26, 26, 26, 17, 17, 19, 17, 15,
	17, 19, 17, 16, 26, 17, 14, 19, 17, 19,
	17, 19, 14, 13, 15, 15, 13, 19, 15, 13,
	20, 26, 26, 26, 26, 26, 26, 17, 17, 19,
	17, 15, 17, 19, 17, 16, 26, 17, 14, 19,
	17, 19, 17, 19, 14, 13, 15, 15, 13, 19,
	15, 13, 20, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	15, 26, 26, 21, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 15, 26, 26, 21,
	26, 26, 26, 19, 26, 20, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 21, 26, 26, 26, 19,
	26, 26, 26, 26, 26, 20, 26, 26, 26, 26,
	26, 21, 26, 26, 26, 26, 17, 26, 22, 26,
	26, 26, 17, 26, 26, 26, 26, 26, 26, 17,
	26, 22, 26, 26, 19, 26, 26, 26, 26, 26,
	15, 26, 26, 26, 17, 17, 17, 26, 17, 26,
	22, 26, 15, 15, 17, 26, 16, 16, 16, 26,
	26, 17, 19, 19, 19, 26, 19, 26, 26, 15,
	26, 15, 15, 26, 26, 26};

const int _cTableObjDeu[] = {
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, 42, 51, -1, 53, 54, 55, 50,
	47, 48, 57, 41, 36, 40, 38, 46, 26, 27,
	28, 29, 30, 31, 32, 33, 34, 35, 39, 37,
	58, 49, 59, 44, -1, 0,  1,  2,  3,  4,
	5,  6,  7,  8,  9,  10, 11, 12, 13, 14,
	15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
	25, -1, -1, -1, 56, -1, -1, 0,  1,  2,
	3,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
	23, 24, 25, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	91, -1, -1, 93, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, 91, -1, -1, 93,
	-1, -1, -1, 88, -1, 85, -1, -1, -1, 67,
	-1, 60, -1, -1, 66, 92, -1, -1, -1, 88,
	-1, -1, -1, -1, -1, 85, -1, 61, -1, -1,
	-1, 92, -1, 69, -1, -1, 70, 71, 86, -1,
	72, -1, 87, 73, 75, -1, -1, 76, -1, 89,
	78, 90, -1, -1, 79, -1, -1, 81, -1, -1,
	82, -1, -1, 142, -1, -1, -1, -1, 70, -1,
	86, 63, -1, -1, 87, -1, -1, -1, -1, -1,
	-1, 89, -1, 90, -1, -1, 79, -1, 62, -1,
	-1, -1, 82, -1, -1, -1};

const int _lTableObjDeu[] = {
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 11, 26, 26, 26, 26, 26, 26, 8,
	26, 26, 26, 26, 26, 12, 8,  26, 20, 20,
	15, 20, 20, 20, 20, 20, 20, 20, 26, 26,
	26, 26, 26, 26, 26, 17, 17, 19, 17, 15,
	17, 19, 17, 16, 26, 17, 14, 19, 17, 19,
	17, 19, 14, 13, 15, 15, 13, 19, 15, 13,
	20, 26, 26, 26, 26, 26, 26, 17, 17, 19,
	17, 15, 17, 19, 17, 16, 26, 17, 14, 19,
	17, 19, 17, 19, 14, 13, 15, 15, 13, 19,
	15, 13, 20, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	15, 26, 26, 21, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 15, 26, 26, 21,
	26, 26, 26, 19, 26, 20, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 21, 26, 26, 26, 19,
	26, 26, 26, 26, 26, 20, 26, 26, 26, 26,
	26, 21, 26, 26, 26, 26, 17, 26, 22, 26,
	26, 26, 17, 26, 26, 26, 26, 26, 26, 17,
	26, 22, 26, 26, 19, 26, 26, 26, 26, 26,
	15, 26, 26, 24, 26, 26, 26, 26, 17, 26,
	22, 26, 26, 26, 17, 26, 26, 26, 26, 26,
	26, 17, 26, 22, 26, 26, 19, 26, 26, 26,
	26, 26, 15, 26, 26, 26};

#endif
