
/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

// NB: This file is AUTO-GENERATED by devtools/sci/scifx/scifx_to_cpp.py
// from devtools/sci/scifx/*.scifx

#include "sci/graphics/helpers.h"
#include "sci/graphics/screen.h"

namespace Sci {

static const PaletteMod paletteModsLSL2[] = {
	{    0,    0,    0 },
	{   32,   32,   32 },
	{  -13,  -13,  -13 },
	{  -38,  -38,  -38 },
	{   26,   26,   26 },
	{   13,   13,   13 },
	{  -51,  -51,  -51 },
	{  -13,    0,    0 },
	{  -64,  -64,  -64 },
	{  -26,  -26,  -26 },
	{  -51,  -13,    0 },
	{  -13,    0,   13 },
	{   38,   38,   38 },
	{  -19,  -19,  -19 },
	{   64,   64,   64 },
	{  -77,  -77,  -77 },
	{   13,    0,    0 }
};

static const PicMod picModsLSL2[] = {
	// LSL2 per-resource palette configuration
	// Copyright (C) 2006 Matt Hargett
	{  28,  1 }, {  99,  1 }, {  96,  5 }, {  92,  2 }, {  93,  2 },
	{  18,  2 }, {  20,  2 }, {  21,  2 }, {  22,  2 }, {  23,  2 },
	{  24,  2 }, {  25,  2 }, {  26,  2 }, { 134,  2 }, {  40,  2 },
	{  50,  2 }, {  76,  2 }, {  77,  2 }, {  78,  2 }, {  79,  2 },
	{  80,  2 }, {  81,  2 }, {  82,  2 }, { 181,  2 }, { 114, 13 },
	{ 115, 13 }, { 116, 13 }, { 117, 13 }, { 118, 13 }, { 125, 13 },
	{  11, 13 }, {  12, 13 }, {  13, 13 }, {  14, 13 }, {  15, 13 },
	{  16, 13 }, {  17, 13 }, {  19, 13 }, {  43, 13 }, {  70, 13 },
	{  71, 13 }, {  72, 13 }, {  73, 13 }, {  74, 13 }, {  44, 13 },
	{  86, 13 }, { 101, 13 }, { 102, 13 }, { 103, 13 }, { 104, 13 },
	{  32, 13 }, {  33, 13 }, {  35, 13 }, {  36, 13 }, {  95, 13 },
	{  10, 15 }, {  90, 15 }, {  91, 15 },
};

static const ViewMod viewModsLSL2[] = {
	// LSL2 per-resource palette configuration
	// Copyright (C) 2006 Matt Hargett
	{ 507, -1, -1,  1 }, { 155, -1, -1,  1 }, { 161, -1, -1,  1 }, { 163, -1, -1,  1 }, { 170, -1, -1,  1 },
	{ 197, -1, -1,  1 }, { 198, -1, -1,  1 }, { 431, -1, -1,  1 }, { 432, -1, -1,  1 }, { 145, -1, -1,  1 },
	{ 146, -1, -1,  1 }, { 147, -1, -1,  1 }, { 148, -1, -1,  1 }, { 149, -1, -1,  1 }, { 150, -1, -1,  1 },
	{ 151, -1, -1,  1 }, { 152, -1, -1,  1 }, { 153, -1, -1,  1 }, { 154, -1, -1,  1 }, { 155, -1, -1,  1 },
	{ 156, -1, -1,  1 }, { 157, -1, -1,  1 }, { 158, -1, -1,  1 }, { 159, -1, -1,  1 }, { 131, -1, -1,  1 },
	{ 132, -1, -1,  1 }, { 133, -1, -1,  1 }, { 134, -1, -1,  1 }, { 135, -1, -1,  1 }, { 136, -1, -1,  1 },
	{ 137, -1, -1,  1 }, { 138, -1, -1,  1 }, { 139, -1, -1,  1 }, { 140, -1, -1,  1 }, { 141, -1, -1,  1 },
	{ 191, -1, -1,  1 }, { 104, -1, -1,  1 }, { 244, -1, -1,  1 }, { 215, -1, -1,  1 }, { 217, -1, -1,  1 },
	{ 219, -1, -1,  1 }, { 100, -1, -1,  1 }, { 101, -1, -1,  1 }, { 110, -1, -1,  1 }, { 111, -1, -1,  1 },
	{ 112, -1, -1,  1 }, { 113, -1, -1,  1 }, { 192, -1, -1,  1 }, { 193, -1, -1,  1 }, { 604, -1, -1,  1 },
	{ 704, -1, -1,  1 }, { 705, -1, -1,  1 }, { 706, -1, -1,  1 }, { 717, -1, -1,  1 }, { 718, -1, -1,  1 },
	{ 818, -1, -1,  1 }, { 819, -1, -1,  1 }, { 822, -1, -1,  1 }, { 823, -1, -1,  1 }, { 824, -1, -1,  1 },
	{ 831, -1, -1,  1 }, { 832, -1, -1,  1 }, { 833, -1, -1,  1 }, { 834, -1, -1,  1 }, { 835, -1, -1,  1 },
	{ 218,  3, -1,  1 }, { 218,  0, -1,  2 }, { 218,  1, -1,  2 }, { 218,  2, -1,  2 }, { 820,  0, -1,  2 },
	{ 820,  1, -1,  2 }, { 227, -1, -1,  2 }, { 224, -1, -1,  2 }, { 206, -1, -1,  2 }, { 208, -1, -1,  2 },
	{ 209, -1, -1,  2 }, { 220, -1, -1,  2 }, { 221, -1, -1,  3 }, { 254, -1, -1,  3 }, { 252, -1, -1,  3 },
	{ 820,  2, -1,  4 }, { 820,  3, -1,  4 }, { 820,  4, -1,  4 }, { 816,  5,  0,  4 }, { 516, -1, -1,  5 },
	{ 509, -1, -1,  5 }, { 501, -1, -1,  5 }, { 502, -1, -1,  5 }, { 503, -1, -1,  5 }, { 504, -1, -1,  5 },
	{ 401, -1, -1,  5 }, { 402, -1, -1,  5 }, { 403, -1, -1,  5 }, { 408, -1, -1,  5 }, { 409, -1, -1,  5 },
	{ 411, -1, -1,  5 }, { 413, -1, -1,  5 }, { 414, -1, -1,  5 }, { 417, -1, -1,  5 }, { 418, -1, -1,  5 },
	{ 419, -1, -1,  5 }, { 430, -1, -1,  5 }, { 310, -1, -1,  5 }, { 302, -1, -1,  5 }, { 303, -1, -1,  5 },
	{ 120, -1, -1,  5 }, { 121, -1, -1,  5 }, { 122, -1, -1,  5 }, { 123, -1, -1,  5 }, { 124, -1, -1,  5 },
	{ 232, -1, -1,  5 }, { 223, -1, -1,  5 }, { 208, -1, -1,  5 }, { 710, -1, -1,  5 }, { 716, -1, -1,  5 },
	{ 714, -1, -1,  5 }, { 434, -1, -1,  4 }, { 435, -1, -1,  4 }, { 436, -1, -1,  4 }, { 437, -1, -1,  4 },
	{ 438, -1, -1,  4 }, { 311, -1, -1,  4 }, { 313, -1, -1,  4 }, { 316, -1, -1,  4 }, { 319, -1, -1,  4 },
	{ 321, -1, -1,  4 }, { 323, -1, -1,  4 }, { 324, -1, -1,  4 }, { 306, -1, -1,  4 }, { 307, -1, -1,  4 },
	{ 308, -1, -1,  4 }, { 309, -1, -1,  4 }, { 248, -1, -1,  4 }, { 245, -1, -1,  4 }, { 246, -1, -1,  4 },
	{ 233, -1, -1,  4 }, { 234, -1, -1,  4 }, { 235, -1, -1,  4 }, { 237, -1, -1,  4 }, { 226, -1, -1,  4 },
	{ 229, -1, -1,  4 }, { 222, -1, -1,  4 }, { 203, -1, -1,  4 }, { 204, -1, -1,  4 }, { 205, -1, -1,  4 },
	{ 600, -1, -1,  4 }, { 525, -1, -1,  4 }, { 524, -1, -1,  4 }, { 523, -1, -1,  4 }, { 522, -1, -1,  4 },
	{ 520, -1, -1,  4 }, { 602, -1, -1,  4 }, { 605, -1, -1,  4 }, { 608, -1, -1,  4 }, { 707, -1, -1,  4 },
	{ 708, -1, -1,  4 }, { 305,  4, -1,  5 }, { 305,  0, -1,  6 }, { 305,  1, -1,  6 }, { 305,  2, -1,  6 },
	{ 305,  3, -1,  6 }, { 661,  0, -1,  4 }, { 661,  1, -1,  4 }, { 661,  3, -1,  4 }, { 661,  4, -1,  4 },
	{ 661,  5, -1,  4 }, { 661,  2, -1,  3 }, { 711, -1, -1,  7 }, { 712, -1, -1,  7 }, { 713, -1, -1,  7 },
	{  60, -1, -1,  7 }, { 816,  0, -1,  2 }, { 816,  1, -1,  2 }, { 816,  2, -1,  2 }, { 816,  3, -1,  2 },
	{ 816,  4, -1,  2 }, { 506, -1, -1,  6 }, { 508, -1, -1,  6 }, { 500, -1, -1,  6 }, { 252, -1, -1,  6 },
	{ 803, -1, -1,  6 }, { 804, -1, -1,  6 }, { 433, -1, -1,  6 }, { 513,  0, -1,  8 }, { 513,  1, -1,  8 },
	{ 513,  2, -1,  8 }, { 513,  3, -1,  8 }, { 513,  4, -1,  8 }, { 513,  5, -1,  8 }, { 240, -1, -1,  9 },
	{ 241, -1, -1,  9 }, { 242, -1, -1,  9 }, { 243, -1, -1,  9 }, { 701, -1, -1,  9 }, { 722, -1, -1,  9 },
	{ 700,  1, -1, 10 }, { 610, -1, -1, 11 }, { 611, -1, -1, 11 }, { 607,  1, -1,  9 }, { 253, -1, -1,  9 },
	{ 228, -1, -1,  9 }, { 247, -1, -1,  9 }, { 300, -1, -1,  9 }, { 326, -1, -1,  9 }, { 412, -1, -1, 12 },
	{ 800, -1, -1, 14 }, { 801, -1, -1, 14 }, { 702, -1, -1, 16 }, { 519, -1, -1,  9 }, { 200,  0, -1,  3 },
	{ 201, -1, -1,  9 }, { 202, -1, -1,  9 },
};

static const PaletteMod paletteModsSQ3[] = {
	{    0,    0,    0 },
	{   32,   32,   32 },
	{   19,   19,   19 },
	{  -64,  -64,  -64 },
	{  -13,  -13,  -13 },
	{  -26,  -26,  -26 },
	{  -32,  -32,  -32 },
	{   26,   26,   26 },
	{  -38,  -38,  -38 },
	{  -51,  -51,  -51 },
	{   13,   13,   13 },
	{   64,   64,   64 }
};

static const PicMod picModsSQ3[] = {
	// SQ3 per-resource palette configuration
	// Copyright (C) 2006 Matt Hargett
	{  96,  2 }, {  81,  2 }, {  82,  2 }, { 430,  2 }, {  17,  6 },
	{  18,  6 }, { 162,  6 }, { 163,  6 }, { 164,  6 }, { 170,  6 },
	{ 180,  6 }, { 191,  6 }, { 300,  6 }, {   1,  4 }, { 926,  4 },
	{ 117,  2 }, { 205,  4 }, { 206,  4 }, { 207,  4 }, { 208,  4 },
	{ 209,  4 }, { 112,  4 }, { 113,  4 }, { 114,  4 }, { 115,  4 },
	{  60,  4 }, {  61,  4 }, {  62,  4 }, {  63,  4 }, {  64,  4 },
	{  65,  4 }, {  66,  4 }, {  67,  4 }, {  68,  4 }, {  69,  4 },
	{  70,  4 }, {  71,  4 }, {  72,  4 }, { 153,  5 }, { 690,  4 },
	{   1,  6 }, {   2,  6 }, {   3,  6 }, {   4,  6 }, {   5,  6 },
	{   6,  6 }, {   7,  6 }, {   8,  6 }, {   9,  6 }, {  10,  6 },
	{  11,  6 }, {  12,  6 }, {  13,  6 }, {  14,  6 }, {  15,  6 },
	{  16,  6 }, {  17,  6 }, {  18,  6 }, {  19,  6 }, {  20,  6 },
	{ 157,  9 },
};

static const ViewMod viewModsSQ3[] = {
	// SQ3 per-resource palette configuration
	// Copyright (C) 2006 Matt Hargett
	{   0, -1, -1,  1 }, {   8, -1, -1,  1 }, {  11, -1, -1,  1 }, {  12, -1, -1,  1 }, {  14, -1, -1,  1 },
	{  68, -1, -1,  1 }, {  17, -1, -1,  1 }, {  22, -1, -1,  1 }, {  23, -1, -1,  1 }, {  24, -1, -1,  1 },
	{  25, -1, -1,  1 }, {  26, -1, -1,  1 }, {  32, -1, -1,  1 }, {  35, -1, -1,  1 }, { 751, -1, -1,  1 },
	{ 289, -1, -1,  1 }, { 288, -1, -1,  1 }, { 261, -1, -1,  1 }, { 260, -1, -1,  1 }, { 257, -1, -1,  1 },
	{ 213, -1, -1,  1 }, { 199, -1, -1,  1 }, { 193, -1, -1,  1 }, { 192, -1, -1,  1 }, { 138, -1, -1,  1 },
	{ 137, -1, -1,  1 }, { 134, -1, -1,  1 }, { 109, -1, -1,  1 }, { 110, -1, -1,  1 }, { 113, -1, -1,  1 },
	{ 114, -1, -1,  1 }, { 117, -1, -1,  1 }, { 122, -1, -1,  1 }, { 123, -1, -1,  1 }, { 100, -1, -1,  1 },
	{  99, -1, -1,  1 }, {  97, -1, -1,  1 }, {  95, -1, -1,  1 }, {  89, -1, -1,  1 }, {  88, -1, -1,  1 },
	{  87, -1, -1,  1 }, {  85, -1, -1,  1 }, {  84, -1, -1,  1 }, {  82, -1, -1,  1 }, {  76, -1, -1,  1 },
	{  68, -1, -1,  1 }, {  63, -1, -1,  1 }, { 104, -1, -1,  1 }, { 136, -1, -1,  2 }, { 106,  4, -1,  1 },
	{ 106,  5, -1,  1 }, { 106,  9, -1,  1 }, { 105,  0, -1,  1 }, { 105,  1, -1,  1 }, {  13,  0,  2,  2 },
	{  31, -1, -1,  2 }, {  15,  3,  0,  1 }, {  16,  0, -1,  1 }, {  19,  0, -1,  1 }, {  57,  5, -1,  1 },
	{  57,  6, -1,  1 }, {  21,  1, -1,  1 }, {   7, -1, -1,  3 }, {  18, -1, -1,  3 }, {   6, -1, -1,  4 },
	{   7, -1, -1,  4 }, {   8, -1, -1,  4 }, {  18, -1, -1,  4 }, { 901, -1, -1,  1 }, { 751, -1, -1,  1 },
	{ 750,  1, -1,  1 }, {  92,  4, -1,  1 }, {  83,  0, -1,  1 }, {  83,  1,  2,  2 }, {  83,  2,  2,  2 },
	{  78,  3, -1,  1 }, {  64,  2, -1,  1 }, {  64,  3, -1,  1 }, {  40, -1, -1,  5 }, {  41, -1, -1,  5 },
	{  42, -1, -1,  5 }, { 149, -1, -1,  5 }, { 146, -1, -1,  5 }, { 141, -1, -1,  5 }, { 151, -1, -1,  5 },
	{ 152, -1, -1,  5 }, {  70, -1, -1,  4 }, {   2, -1, -1,  4 }, { 900, -1, -1,  4 }, { 593, -1, -1,  7 },
	{  93, -1, -1,  7 }, { 103, -1, -1,  7 }, { 131, -1, -1,  7 }, { 132, -1, -1,  7 }, { 133, -1, -1,  7 },
	{ 210, -1, -1,  7 }, { 130, -1, -1,  7 }, { 115, -1, -1,  7 }, { 116,  1, -1,  7 }, { 116,  2, -1,  7 },
	{  39, -1, -1,  4 }, {   1, -1, -1,  6 }, {  96, -1, -1,  4 }, {  77,  0, -1,  8 }, {  77,  1, -1,  8 },
	{  77,  2, -1,  8 }, { 259, -1, -1,  2 }, {  20,  0, -1,  3 }, {  15,  0, -1,  9 }, {  15,  1, -1,  9 },
	{  34, -1, -1,  9 }, { 128, -1, -1,  4 }, { 601, -1, -1,  4 }, { 602, -1, -1,  4 }, {  94, -1, -1, 10 },
	{  91, -1, -1, 11 }, {  73, -1, -1, 11 }, {  57,  3, -1, 11 }, {  57,  4, -1, 11 }, {  15,  4, -1, 11 },
	{  64,  0, -1, 11 }, {  71,  8, -1, 11 }, {  10,  6, -1, 11 },
};

static const SciFxMod mods[] = {
	{ GID_LSL2, paletteModsLSL2, ARRAYSIZE(paletteModsLSL2), picModsLSL2, ARRAYSIZE(picModsLSL2), viewModsLSL2, ARRAYSIZE(viewModsLSL2) },
	{ GID_SQ3, paletteModsSQ3, ARRAYSIZE(paletteModsSQ3), picModsSQ3, ARRAYSIZE(picModsSQ3), viewModsSQ3, ARRAYSIZE(viewModsSQ3) },
};

void setupCustomPaletteMods(GfxScreen *screen) {
	for (int i = 0; i < ARRAYSIZE(mods); i++) {
		if (mods[i].gameId == g_sci->getGameId()) {
			screen->setPaletteMods(mods[i].paletteMods, mods[i].paletteModsSize);
			break;
		}
	}
}

void doCustomViewPalette(GfxScreen *screen, GuiResourceId view, int16 loop, int16 cel) {
	for (int i = 0; i < ARRAYSIZE(mods); i++) {
		SciFxMod mod = mods[i];
		if (mod.gameId == g_sci->getGameId()) {
			for (int j = 0; j < mod.viewModsSize; j++) {
				ViewMod m = mod.viewMods[j];
				if (m.id == view && (m.loop == -1 || m.loop == loop) && (m.cel == -1 || m.cel == cel)) {
					screen->setCurPaletteMapValue(m.multiplier);
					break;
				}
			}
			break;
		}
	}
}

void doCustomPicPalette(GfxScreen *screen, GuiResourceId pic) {
	for (int i = 0; i < ARRAYSIZE(mods); i++) {
		SciFxMod mod = mods[i];
		if (mod.gameId == g_sci->getGameId()) {
			for (int j = 0; j < mod.picModsSize; j++) {
				PicMod m = mod.picMods[j];
				if (m.id == pic) {
					screen->setCurPaletteMapValue(m.multiplier);
					break;
				}
			}
			break;
		}
	}
}

}
