# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** document abstraction

** Author: Ralph Amissah
  [ralph@amissah.com]
  [ralph.amissah@gmail.com]

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see [http://www.gnu.org/licenses/].

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  [http://www.fsf.org/licensing/licenses/gpl.html]
  [http://www.gnu.org/licenses/gpl.html]

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  [http://www.jus.uio.no/sisu]
  [http://www.sisudoc.org]

** Git
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary]
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/ao_persist.rb;hb=HEAD]

=end
module SiSU_AO_Persist
  class Persist
    @@persistance=nil
    attr_accessor :fns, :ao_arr, :idx_arr_sst, :idx_arr_tex, :idx_arr_html, :idx_arr_xhtml, :map_arr_nametags, :map_arr_ocn_htmlseg
    def initialize(args=nil)
      @@persistance=args=(args ? args : (@@persistance || persist_init_hash_values))
      @fns=args[:fns]
      @ao_arr=args[:ao_arr]
      @idx_arr_sst=args[:idx_arr_sst]
      @idx_arr_tex=args[:idx_arr_tex]
      @idx_arr_html=args[:idx_arr_html]
      @idx_arr_xhtml=args[:idx_arr_xhtml]
      @map_arr_nametags=args[:map_arr_nametags]
      @map_arr_ocn_htmlseg=args[:map_arr_ocn_htmlseg]
    end
    def fns
      @fns
    end
    def ao_arr
      @ao_arr
    end
    def idx_arr_sst
      @idx_arr_sst
    end
    def idx_arr_tex
      @idx_arr_tex
    end
    def idx_arr_html
      @idx_arr_html
    end
    def idx_arr_xhtml
      @idx_arr_xhtml
    end
    def map_arr_nametags
      @map_arr_nametags
    end
    def map_arr_ocn_htmlseg
      @map_arr_ocn_htmlseg
    end
    def persist_init_hash_values
      {
        fns:                 nil,
        ao_arr:              [],
        idx_arr_sst:         [],
        idx_arr_tex:         [],
        idx_arr_html:        [],
        idx_arr_xhtml:       [],
        map_arr_nametags:    [],
        map_arr_ocn_htmlseg: [],
      }
    end
    def persist_init
      @@persistance=nil
      Persist.new(persist_init_hash_values)
    end
  end
  class PersistDocStructExt
    @@persist=nil
    attr_accessor :ocn, :lng, :lng_is, :code, :lngsyn, :poem, :block, :box, :group, :alt, :quote, :table, :table_to
    def initialize(args=nil)
      @@persist=args=(args ? args : (@@persist || persist_init_hash_values))
      @ocn=args[:ocn]
      @lng=args[:lng]
      @lng_is=args[:lng_is]
      @code=args[:code]
      @lngsyn=args[:lngsyn]
      @poem=args[:poem]
      @block=args[:block]
      @box=args[:box]
      @group=args[:group]
      @alt=args[:alt]
      @quote=args[:quote]
      @table=args[:table]
      @table_to=args[:table_to]
    end
    def ocn
      @ocn
    end
    def lng
      @lng
    end
    def lng_is
      @lng_is
    end
    def code
      @code
    end
    def lngsyn
      @lngsyn
    end
    def poem
      @poem
    end
    def block
      @block
    end
    def box
      @box
    end
    def group
      @group
    end
    def alt
      @alt
    end
    def quote
      @quote
    end
    def table
      @table
    end
    def table_to
      @table_to
    end
    def persist_init_hash_values
      {
        ocn:         :on,
        lng:         :off,
        lng_is:      :doc_default,
        code:        :off,
        lngsyn:      :txt,
        poem:        :off,
        block:       :off,
        box:         :off,
        group:       :off,
        alt:         :off,
        quote:       :off,
        table:       :off,
        table_to:    :off,
      }
    end
    def persist_init
      @@persist=nil
      PersistDocStructExt.new(persist_init_hash_values)
    end
  end
end
__END__
