#!/bin/sh
#this script is used by get-orig-source target

echo "# Downloading $1 from github.com ..." \
 && git clone https://github.com/sushi-irc/$1.git && cd $1 \
 && git reset --hard $2 \
 && [ -s ChangeLog ] || ( echo "# Generating $1 ChangeLog..." \
     ; git log --pretty="format:%ad  %aN  <%aE>%n%n%x09* %s%n" --date=short > ChangeLog \
     ; touch -d "$(git log -1 --format='%ci')" ChangeLog) \
 && echo "# Setting times..." \
 && git ls-tree -r --name-only HEAD | while read F ; do touch --no-dereference -d "$(git log -1 --format="%ai" -- "$F")" "$F"; done \
 && echo "# Cleaning-up..." \
 && rm -rf .git .git*