## TFSA-2021-175: Null pointer exception when `Exit` node is not preceded by `Enter` op

### CVE Number
CVE-2021-41217

### Impact
The [process of building the control flow graph](https://github.com/tensorflow/tensorflow/blob/8d72537c6abf5a44103b57b9c2e22c14f5f49698/tensorflow/core/common_runtime/immutable_executor_state.cc#L284-L346) for a TensorFlow model is vulnerable to a null pointer exception when nodes that should be paired are not:

```python
import tensorflow as tf

@tf.function
def func():
  return tf.raw_ops.Exit(data=[False,False])

func()
```

This occurs because the code assumes that the first node in the pairing (e.g., an `Enter` node) always exists when encountering the second node (e.g., an `Exit` node):

```cc
  ...
} else if (IsExit(curr_node)) {
  // Exit to the parent frame.
  parent = parent_nodes[curr_id];
  frame_name = cf_info->frame_names[parent->id()];
  ...
```

When this is not the case, `parent` is `nullptr` so dereferencing it causes a crash.

### Patches
We have patched the issue in GitHub commit [05cbebd3c6bb8f517a158b0155debb8df79017ff](https://github.com/tensorflow/tensorflow/commit/05cbebd3c6bb8f517a158b0155debb8df79017ff).

The fix will be included in TensorFlow 2.7.0. We will also cherrypick this commit on TensorFlow 2.6.1, TensorFlow 2.5.2, and TensorFlow 2.4.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo 360.
