This is the destination directory for the LDoc documentation of Vis' Lua API
as generated by the `make luadoc`.

Unfortunately `ldoc(1)` seems to have a bug which generates broken reference
links for custom types. The following patch seems to fix the issue:

```
From 96a1fbc8e972fedf665049a6351f46bc1aac1768 Mon Sep 17 00:00:00 2001
From: =?UTF-8?q?Marc=20Andr=C3=A9=20Tanner?= <mat@brain-dump.org>
Date: Tue, 6 Dec 2016 15:59:17 +0100
Subject: [PATCH] Fix references to class types.

For classes the generated HTML anchors need to be prefixed 'Class_'.
---
 ldoc/doc.lua | 6 +++---
 1 file changed, 3 insertions(+), 3 deletions(-)

diff --git a/ldoc/doc.lua b/ldoc/doc.lua
index e19b2df..f368b90 100644
--- a/ldoc/doc.lua
+++ b/ldoc/doc.lua
@@ -1073,9 +1073,9 @@ end
 local function reference (s, mod_ref, item_ref)
    local name = item_ref and item_ref.name or ''
    -- this is deeply hacky; classes have 'Class ' prepended.
---~    if item_ref and doc.class_tag(item_ref.type) then
---~       name = 'Class_'..name
---~    end
+       if item_ref and doc.class_tag(item_ref.type) then
+          name = 'Class_'..name
+       end
    return {mod = mod_ref, name = name, label=s}
 end
 
-- 
1.9.1
```
