// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_function_declarations.txt.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_test_autogen.cpp:
//   Tests for matching script-generated hashes with runtime computed hashes.

#include "compiler/translator/ImmutableString.h"
#include "gtest/gtest.h"

namespace sh
{

TEST(ImmutableStringTest, ScriptGeneratedHashesMatch)
{
    ASSERT_EQ(0x00000168u, ImmutableString("radians(00B").mangledNameHash());
    ASSERT_EQ(0x000000c2u, ImmutableString("radians(10B").mangledNameHash());
    ASSERT_EQ(0x000002afu, ImmutableString("radians(20B").mangledNameHash());
    ASSERT_EQ(0x00000210u, ImmutableString("radians(30B").mangledNameHash());
    ASSERT_EQ(0x00000762u, ImmutableString("degrees(00B").mangledNameHash());
    ASSERT_EQ(0x00000812u, ImmutableString("degrees(10B").mangledNameHash());
    ASSERT_EQ(0x00000035u, ImmutableString("degrees(20B").mangledNameHash());
    ASSERT_EQ(0x000000d0u, ImmutableString("degrees(30B").mangledNameHash());
    ASSERT_EQ(0x00000616u, ImmutableString("sin(00B").mangledNameHash());
    ASSERT_EQ(0x00000566u, ImmutableString("sin(10B").mangledNameHash());
    ASSERT_EQ(0x000007c8u, ImmutableString("sin(20B").mangledNameHash());
    ASSERT_EQ(0x0000009fu, ImmutableString("sin(30B").mangledNameHash());
    ASSERT_EQ(0x00000131u, ImmutableString("cos(00B").mangledNameHash());
    ASSERT_EQ(0x000001deu, ImmutableString("cos(10B").mangledNameHash());
    ASSERT_EQ(0x00000851u, ImmutableString("cos(20B").mangledNameHash());
    ASSERT_EQ(0x00000098u, ImmutableString("cos(30B").mangledNameHash());
    ASSERT_EQ(0x00000781u, ImmutableString("tan(00B").mangledNameHash());
    ASSERT_EQ(0x00000824u, ImmutableString("tan(10B").mangledNameHash());
    ASSERT_EQ(0x00000422u, ImmutableString("tan(20B").mangledNameHash());
    ASSERT_EQ(0x000006deu, ImmutableString("tan(30B").mangledNameHash());
    ASSERT_EQ(0x0000014au, ImmutableString("asin(00B").mangledNameHash());
    ASSERT_EQ(0x000001fbu, ImmutableString("asin(10B").mangledNameHash());
    ASSERT_EQ(0x00000666u, ImmutableString("asin(20B").mangledNameHash());
    ASSERT_EQ(0x00000704u, ImmutableString("asin(30B").mangledNameHash());
    ASSERT_EQ(0x00000256u, ImmutableString("acos(00B").mangledNameHash());
    ASSERT_EQ(0x000001a0u, ImmutableString("acos(10B").mangledNameHash());
    ASSERT_EQ(0x000005b1u, ImmutableString("acos(20B").mangledNameHash());
    ASSERT_EQ(0x00000506u, ImmutableString("acos(30B").mangledNameHash());
    ASSERT_EQ(0x00000775u, ImmutableString("atan(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000025u, ImmutableString("atan(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000549u, ImmutableString("atan(20B20B").mangledNameHash());
    ASSERT_EQ(0x000004eeu, ImmutableString("atan(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000010fu, ImmutableString("atan(00B").mangledNameHash());
    ASSERT_EQ(0x00000696u, ImmutableString("atan(10B").mangledNameHash());
    ASSERT_EQ(0x00000269u, ImmutableString("atan(20B").mangledNameHash());
    ASSERT_EQ(0x000001c0u, ImmutableString("atan(30B").mangledNameHash());
    ASSERT_EQ(0x000001fcu, ImmutableString("sinh(00B").mangledNameHash());
    ASSERT_EQ(0x00000814u, ImmutableString("sinh(10B").mangledNameHash());
    ASSERT_EQ(0x0000032du, ImmutableString("sinh(20B").mangledNameHash());
    ASSERT_EQ(0x000002a0u, ImmutableString("sinh(30B").mangledNameHash());
    ASSERT_EQ(0x000005b8u, ImmutableString("cosh(00B").mangledNameHash());
    ASSERT_EQ(0x00000802u, ImmutableString("cosh(10B").mangledNameHash());
    ASSERT_EQ(0x00000058u, ImmutableString("cosh(20B").mangledNameHash());
    ASSERT_EQ(0x0000059cu, ImmutableString("cosh(30B").mangledNameHash());
    ASSERT_EQ(0x00000684u, ImmutableString("tanh(00B").mangledNameHash());
    ASSERT_EQ(0x0000071du, ImmutableString("tanh(10B").mangledNameHash());
    ASSERT_EQ(0x000007c6u, ImmutableString("tanh(20B").mangledNameHash());
    ASSERT_EQ(0x0000000bu, ImmutableString("tanh(30B").mangledNameHash());
    ASSERT_EQ(0x000007b9u, ImmutableString("asinh(00B").mangledNameHash());
    ASSERT_EQ(0x00000855u, ImmutableString("asinh(10B").mangledNameHash());
    ASSERT_EQ(0x000002a5u, ImmutableString("asinh(20B").mangledNameHash());
    ASSERT_EQ(0x00000335u, ImmutableString("asinh(30B").mangledNameHash());
    ASSERT_EQ(0x000000d9u, ImmutableString("acosh(00B").mangledNameHash());
    ASSERT_EQ(0x000006b3u, ImmutableString("acosh(10B").mangledNameHash());
    ASSERT_EQ(0x0000022fu, ImmutableString("acosh(20B").mangledNameHash());
    ASSERT_EQ(0x00000186u, ImmutableString("acosh(30B").mangledNameHash());
    ASSERT_EQ(0x0000005au, ImmutableString("atanh(00B").mangledNameHash());
    ASSERT_EQ(0x00000230u, ImmutableString("atanh(10B").mangledNameHash());
    ASSERT_EQ(0x000005dbu, ImmutableString("atanh(20B").mangledNameHash());
    ASSERT_EQ(0x00000524u, ImmutableString("atanh(30B").mangledNameHash());
    ASSERT_EQ(0x0000051eu, ImmutableString("pow(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000270u, ImmutableString("pow(10B10B").mangledNameHash());
    ASSERT_EQ(0x000005f3u, ImmutableString("pow(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000339u, ImmutableString("pow(30B30B").mangledNameHash());
    ASSERT_EQ(0x000003c6u, ImmutableString("exp(00B").mangledNameHash());
    ASSERT_EQ(0x0000046au, ImmutableString("exp(10B").mangledNameHash());
    ASSERT_EQ(0x000000d6u, ImmutableString("exp(20B").mangledNameHash());
    ASSERT_EQ(0x0000017fu, ImmutableString("exp(30B").mangledNameHash());
    ASSERT_EQ(0x00000182u, ImmutableString("log(00B").mangledNameHash());
    ASSERT_EQ(0x000000dau, ImmutableString("log(10B").mangledNameHash());
    ASSERT_EQ(0x000002c6u, ImmutableString("log(20B").mangledNameHash());
    ASSERT_EQ(0x0000049eu, ImmutableString("log(30B").mangledNameHash());
    ASSERT_EQ(0x0000064cu, ImmutableString("exp2(00B").mangledNameHash());
    ASSERT_EQ(0x000006e1u, ImmutableString("exp2(10B").mangledNameHash());
    ASSERT_EQ(0x000004f8u, ImmutableString("exp2(20B").mangledNameHash());
    ASSERT_EQ(0x00000593u, ImmutableString("exp2(30B").mangledNameHash());
    ASSERT_EQ(0x0000071cu, ImmutableString("log2(00B").mangledNameHash());
    ASSERT_EQ(0x0000069fu, ImmutableString("log2(10B").mangledNameHash());
    ASSERT_EQ(0x00000600u, ImmutableString("log2(20B").mangledNameHash());
    ASSERT_EQ(0x00000306u, ImmutableString("log2(30B").mangledNameHash());
    ASSERT_EQ(0x00000318u, ImmutableString("sqrt(00B").mangledNameHash());
    ASSERT_EQ(0x00000286u, ImmutableString("sqrt(10B").mangledNameHash());
    ASSERT_EQ(0x0000046eu, ImmutableString("sqrt(20B").mangledNameHash());
    ASSERT_EQ(0x000003c5u, ImmutableString("sqrt(30B").mangledNameHash());
    ASSERT_EQ(0x00000319u, ImmutableString("sqrt(00C").mangledNameHash());
    ASSERT_EQ(0x00000285u, ImmutableString("sqrt(10C").mangledNameHash());
    ASSERT_EQ(0x0000046fu, ImmutableString("sqrt(20C").mangledNameHash());
    ASSERT_EQ(0x000003c4u, ImmutableString("sqrt(30C").mangledNameHash());
    ASSERT_EQ(0x0000003cu, ImmutableString("inversesqrt(00B").mangledNameHash());
    ASSERT_EQ(0x000007f0u, ImmutableString("inversesqrt(10B").mangledNameHash());
    ASSERT_EQ(0x00000152u, ImmutableString("inversesqrt(20B").mangledNameHash());
    ASSERT_EQ(0x000000d1u, ImmutableString("inversesqrt(30B").mangledNameHash());
    ASSERT_EQ(0x0000003bu, ImmutableString("inversesqrt(00C").mangledNameHash());
    ASSERT_EQ(0x000007f1u, ImmutableString("inversesqrt(10C").mangledNameHash());
    ASSERT_EQ(0x00000151u, ImmutableString("inversesqrt(20C").mangledNameHash());
    ASSERT_EQ(0x000000d2u, ImmutableString("inversesqrt(30C").mangledNameHash());
    ASSERT_EQ(0x0000036cu, ImmutableString("abs(00B").mangledNameHash());
    ASSERT_EQ(0x000002ddu, ImmutableString("abs(10B").mangledNameHash());
    ASSERT_EQ(0x0000024bu, ImmutableString("abs(20B").mangledNameHash());
    ASSERT_EQ(0x000005e6u, ImmutableString("abs(30B").mangledNameHash());
    ASSERT_EQ(0x0000036au, ImmutableString("abs(00D").mangledNameHash());
    ASSERT_EQ(0x000002dcu, ImmutableString("abs(10D").mangledNameHash());
    ASSERT_EQ(0x00000249u, ImmutableString("abs(20D").mangledNameHash());
    ASSERT_EQ(0x000007f2u, ImmutableString("abs(30D").mangledNameHash());
    ASSERT_EQ(0x0000036bu, ImmutableString("abs(00C").mangledNameHash());
    ASSERT_EQ(0x000002deu, ImmutableString("abs(10C").mangledNameHash());
    ASSERT_EQ(0x0000024au, ImmutableString("abs(20C").mangledNameHash());
    ASSERT_EQ(0x000007f4u, ImmutableString("abs(30C").mangledNameHash());
    ASSERT_EQ(0x000000c9u, ImmutableString("sign(00B").mangledNameHash());
    ASSERT_EQ(0x00000644u, ImmutableString("sign(10B").mangledNameHash());
    ASSERT_EQ(0x000001d0u, ImmutableString("sign(20B").mangledNameHash());
    ASSERT_EQ(0x000000e7u, ImmutableString("sign(30B").mangledNameHash());
    ASSERT_EQ(0x000005bdu, ImmutableString("sign(00D").mangledNameHash());
    ASSERT_EQ(0x00000806u, ImmutableString("sign(10D").mangledNameHash());
    ASSERT_EQ(0x00000059u, ImmutableString("sign(20D").mangledNameHash());
    ASSERT_EQ(0x000000e9u, ImmutableString("sign(30D").mangledNameHash());
    ASSERT_EQ(0x000005b7u, ImmutableString("sign(00C").mangledNameHash());
    ASSERT_EQ(0x00000803u, ImmutableString("sign(10C").mangledNameHash());
    ASSERT_EQ(0x00000057u, ImmutableString("sign(20C").mangledNameHash());
    ASSERT_EQ(0x000000e8u, ImmutableString("sign(30C").mangledNameHash());
    ASSERT_EQ(0x00000424u, ImmutableString("floor(00B").mangledNameHash());
    ASSERT_EQ(0x00000126u, ImmutableString("floor(10B").mangledNameHash());
    ASSERT_EQ(0x00000575u, ImmutableString("floor(20B").mangledNameHash());
    ASSERT_EQ(0x000004d8u, ImmutableString("floor(30B").mangledNameHash());
    ASSERT_EQ(0x00000423u, ImmutableString("floor(00C").mangledNameHash());
    ASSERT_EQ(0x00000127u, ImmutableString("floor(10C").mangledNameHash());
    ASSERT_EQ(0x00000574u, ImmutableString("floor(20C").mangledNameHash());
    ASSERT_EQ(0x000004d9u, ImmutableString("floor(30C").mangledNameHash());
    ASSERT_EQ(0x000006d6u, ImmutableString("trunc(00B").mangledNameHash());
    ASSERT_EQ(0x00000638u, ImmutableString("trunc(10B").mangledNameHash());
    ASSERT_EQ(0x00000821u, ImmutableString("trunc(20B").mangledNameHash());
    ASSERT_EQ(0x00000779u, ImmutableString("trunc(30B").mangledNameHash());
    ASSERT_EQ(0x00000793u, ImmutableString("trunc(00C").mangledNameHash());
    ASSERT_EQ(0x00000639u, ImmutableString("trunc(10C").mangledNameHash());
    ASSERT_EQ(0x00000820u, ImmutableString("trunc(20C").mangledNameHash());
    ASSERT_EQ(0x0000077au, ImmutableString("trunc(30C").mangledNameHash());
    ASSERT_EQ(0x00000082u, ImmutableString("round(00B").mangledNameHash());
    ASSERT_EQ(0x0000082fu, ImmutableString("round(10B").mangledNameHash());
    ASSERT_EQ(0x00000379u, ImmutableString("round(20B").mangledNameHash());
    ASSERT_EQ(0x000006e8u, ImmutableString("round(30B").mangledNameHash());
    ASSERT_EQ(0x00000081u, ImmutableString("round(00C").mangledNameHash());
    ASSERT_EQ(0x00000830u, ImmutableString("round(10C").mangledNameHash());
    ASSERT_EQ(0x00000376u, ImmutableString("round(20C").mangledNameHash());
    ASSERT_EQ(0x000006e9u, ImmutableString("round(30C").mangledNameHash());
    ASSERT_EQ(0x000005d9u, ImmutableString("roundEven(00B").mangledNameHash());
    ASSERT_EQ(0x00000522u, ImmutableString("roundEven(10B").mangledNameHash());
    ASSERT_EQ(0x000002ccu, ImmutableString("roundEven(20B").mangledNameHash());
    ASSERT_EQ(0x0000022du, ImmutableString("roundEven(30B").mangledNameHash());
    ASSERT_EQ(0x000005d8u, ImmutableString("roundEven(00C").mangledNameHash());
    ASSERT_EQ(0x00000523u, ImmutableString("roundEven(10C").mangledNameHash());
    ASSERT_EQ(0x000002cbu, ImmutableString("roundEven(20C").mangledNameHash());
    ASSERT_EQ(0x0000022eu, ImmutableString("roundEven(30C").mangledNameHash());
    ASSERT_EQ(0x000007a3u, ImmutableString("ceil(00B").mangledNameHash());
    ASSERT_EQ(0x000001c3u, ImmutableString("ceil(10B").mangledNameHash());
    ASSERT_EQ(0x00000278u, ImmutableString("ceil(20B").mangledNameHash());
    ASSERT_EQ(0x000001c7u, ImmutableString("ceil(30B").mangledNameHash());
    ASSERT_EQ(0x000007a2u, ImmutableString("ceil(00C").mangledNameHash());
    ASSERT_EQ(0x0000002cu, ImmutableString("ceil(10C").mangledNameHash());
    ASSERT_EQ(0x00000277u, ImmutableString("ceil(20C").mangledNameHash());
    ASSERT_EQ(0x00000303u, ImmutableString("ceil(30C").mangledNameHash());
    ASSERT_EQ(0x00000510u, ImmutableString("fract(00B").mangledNameHash());
    ASSERT_EQ(0x0000045fu, ImmutableString("fract(10B").mangledNameHash());
    ASSERT_EQ(0x000003b1u, ImmutableString("fract(20B").mangledNameHash());
    ASSERT_EQ(0x00000211u, ImmutableString("fract(30B").mangledNameHash());
    ASSERT_EQ(0x0000050fu, ImmutableString("fract(00C").mangledNameHash());
    ASSERT_EQ(0x00000460u, ImmutableString("fract(10C").mangledNameHash());
    ASSERT_EQ(0x000003b0u, ImmutableString("fract(20C").mangledNameHash());
    ASSERT_EQ(0x00000309u, ImmutableString("fract(30C").mangledNameHash());
    ASSERT_EQ(0x0000051fu, ImmutableString("mod(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000710u, ImmutableString("mod(10B00B").mangledNameHash());
    ASSERT_EQ(0x000006b7u, ImmutableString("mod(20B00B").mangledNameHash());
    ASSERT_EQ(0x000000f3u, ImmutableString("mod(30B00B").mangledNameHash());
    ASSERT_EQ(0x000007dcu, ImmutableString("mod(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000568u, ImmutableString("mod(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000058eu, ImmutableString("mod(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000047u, ImmutableString("mod(00C00C").mangledNameHash());
    ASSERT_EQ(0x000005eeu, ImmutableString("mod(10C00C").mangledNameHash());
    ASSERT_EQ(0x000001a7u, ImmutableString("mod(20C00C").mangledNameHash());
    ASSERT_EQ(0x0000084bu, ImmutableString("mod(30C00C").mangledNameHash());
    ASSERT_EQ(0x000002fbu, ImmutableString("mod(10C10C").mangledNameHash());
    ASSERT_EQ(0x00000308u, ImmutableString("mod(20C20C").mangledNameHash());
    ASSERT_EQ(0x00000427u, ImmutableString("mod(30C30C").mangledNameHash());
    ASSERT_EQ(0x0000075cu, ImmutableString("min(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000240u, ImmutableString("min(10B00B").mangledNameHash());
    ASSERT_EQ(0x00000282u, ImmutableString("min(20B00B").mangledNameHash());
    ASSERT_EQ(0x00000468u, ImmutableString("min(30B00B").mangledNameHash());
    ASSERT_EQ(0x0000026du, ImmutableString("min(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000789u, ImmutableString("min(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000068eu, ImmutableString("min(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000039u, ImmutableString("min(00C00C").mangledNameHash());
    ASSERT_EQ(0x0000062cu, ImmutableString("min(10C10C").mangledNameHash());
    ASSERT_EQ(0x00000741u, ImmutableString("min(20C20C").mangledNameHash());
    ASSERT_EQ(0x0000041cu, ImmutableString("min(30C30C").mangledNameHash());
    ASSERT_EQ(0x000006cbu, ImmutableString("min(10C00C").mangledNameHash());
    ASSERT_EQ(0x00000385u, ImmutableString("min(20C00C").mangledNameHash());
    ASSERT_EQ(0x00000106u, ImmutableString("min(30C00C").mangledNameHash());
    ASSERT_EQ(0x000001d4u, ImmutableString("min(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000044fu, ImmutableString("min(10D10D").mangledNameHash());
    ASSERT_EQ(0x000007bfu, ImmutableString("min(20D20D").mangledNameHash());
    ASSERT_EQ(0x000007abu, ImmutableString("min(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000390u, ImmutableString("min(10D00D").mangledNameHash());
    ASSERT_EQ(0x0000067bu, ImmutableString("min(20D00D").mangledNameHash());
    ASSERT_EQ(0x00000845u, ImmutableString("min(30D00D").mangledNameHash());
    ASSERT_EQ(0x0000034bu, ImmutableString("min(00E00E").mangledNameHash());
    ASSERT_EQ(0x0000082du, ImmutableString("min(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000665u, ImmutableString("min(20E20E").mangledNameHash());
    ASSERT_EQ(0x0000024du, ImmutableString("min(30E30E").mangledNameHash());
    ASSERT_EQ(0x0000007du, ImmutableString("min(10E00E").mangledNameHash());
    ASSERT_EQ(0x00000782u, ImmutableString("min(20E00E").mangledNameHash());
    ASSERT_EQ(0x00000511u, ImmutableString("min(30E00E").mangledNameHash());
    ASSERT_EQ(0x000004f3u, ImmutableString("max(00B00B").mangledNameHash());
    ASSERT_EQ(0x000007b3u, ImmutableString("max(10B00B").mangledNameHash());
    ASSERT_EQ(0x00000237u, ImmutableString("max(20B00B").mangledNameHash());
    ASSERT_EQ(0x00000360u, ImmutableString("max(30B00B").mangledNameHash());
    ASSERT_EQ(0x000001f8u, ImmutableString("max(10B10B").mangledNameHash());
    ASSERT_EQ(0x000005b3u, ImmutableString("max(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000a9u, ImmutableString("max(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000823u, ImmutableString("max(00C00C").mangledNameHash());
    ASSERT_EQ(0x000005e4u, ImmutableString("max(10C10C").mangledNameHash());
    ASSERT_EQ(0x000001f7u, ImmutableString("max(20C20C").mangledNameHash());
    ASSERT_EQ(0x0000037eu, ImmutableString("max(30C30C").mangledNameHash());
    ASSERT_EQ(0x00000688u, ImmutableString("max(10C00C").mangledNameHash());
    ASSERT_EQ(0x00000595u, ImmutableString("max(20C00C").mangledNameHash());
    ASSERT_EQ(0x000002e8u, ImmutableString("max(30C00C").mangledNameHash());
    ASSERT_EQ(0x000002d4u, ImmutableString("max(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000571u, ImmutableString("max(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000570u, ImmutableString("max(20D20D").mangledNameHash());
    ASSERT_EQ(0x000003c7u, ImmutableString("max(30D30D").mangledNameHash());
    ASSERT_EQ(0x000004d5u, ImmutableString("max(10D00D").mangledNameHash());
    ASSERT_EQ(0x000006bfu, ImmutableString("max(20D00D").mangledNameHash());
    ASSERT_EQ(0x00000040u, ImmutableString("max(30D00D").mangledNameHash());
    ASSERT_EQ(0x00000645u, ImmutableString("max(00E00E").mangledNameHash());
    ASSERT_EQ(0x000000a8u, ImmutableString("max(10E10E").mangledNameHash());
    ASSERT_EQ(0x000002dau, ImmutableString("max(20E20E").mangledNameHash());
    ASSERT_EQ(0x0000030cu, ImmutableString("max(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000327u, ImmutableString("max(10E00E").mangledNameHash());
    ASSERT_EQ(0x00000196u, ImmutableString("max(20E00E").mangledNameHash());
    ASSERT_EQ(0x0000070bu, ImmutableString("max(30E00E").mangledNameHash());
    ASSERT_EQ(0x00000722u, ImmutableString("clamp(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000004e3u, ImmutableString("clamp(10B00B00B").mangledNameHash());
    ASSERT_EQ(0x000005abu, ImmutableString("clamp(20B00B00B").mangledNameHash());
    ASSERT_EQ(0x000004d2u, ImmutableString("clamp(30B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000232u, ImmutableString("clamp(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000081du, ImmutableString("clamp(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000026u, ImmutableString("clamp(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x00000324u, ImmutableString("clamp(00C00C00C").mangledNameHash());
    ASSERT_EQ(0x0000048bu, ImmutableString("clamp(10C00C00C").mangledNameHash());
    ASSERT_EQ(0x00000261u, ImmutableString("clamp(20C00C00C").mangledNameHash());
    ASSERT_EQ(0x0000032bu, ImmutableString("clamp(30C00C00C").mangledNameHash());
    ASSERT_EQ(0x00000726u, ImmutableString("clamp(10C10C10C").mangledNameHash());
    ASSERT_EQ(0x00000073u, ImmutableString("clamp(20C20C20C").mangledNameHash());
    ASSERT_EQ(0x00000698u, ImmutableString("clamp(30C30C30C").mangledNameHash());
    ASSERT_EQ(0x000004d7u, ImmutableString("clamp(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000021du, ImmutableString("clamp(10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000f1u, ImmutableString("clamp(20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000414u, ImmutableString("clamp(30D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006aau, ImmutableString("clamp(10D10D10D").mangledNameHash());
    ASSERT_EQ(0x00000321u, ImmutableString("clamp(20D20D20D").mangledNameHash());
    ASSERT_EQ(0x000005ebu, ImmutableString("clamp(30D30D30D").mangledNameHash());
    ASSERT_EQ(0x00000227u, ImmutableString("clamp(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x000005dcu, ImmutableString("clamp(10E00E00E").mangledNameHash());
    ASSERT_EQ(0x000007fbu, ImmutableString("clamp(20E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000149u, ImmutableString("clamp(30E00E00E").mangledNameHash());
    ASSERT_EQ(0x000000aau, ImmutableString("clamp(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x00000287u, ImmutableString("clamp(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x000006b1u, ImmutableString("clamp(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x0000024fu, ImmutableString("mix(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000005e9u, ImmutableString("mix(10B10B00B").mangledNameHash());
    ASSERT_EQ(0x0000001bu, ImmutableString("mix(20B20B00B").mangledNameHash());
    ASSERT_EQ(0x00000682u, ImmutableString("mix(30B30B00B").mangledNameHash());
    ASSERT_EQ(0x0000053du, ImmutableString("mix(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000841u, ImmutableString("mix(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000003bfu, ImmutableString("mix(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x00000412u, ImmutableString("mix(00C00C00C").mangledNameHash());
    ASSERT_EQ(0x00000618u, ImmutableString("mix(10C10C00C").mangledNameHash());
    ASSERT_EQ(0x00000404u, ImmutableString("mix(20C20C00C").mangledNameHash());
    ASSERT_EQ(0x000006bcu, ImmutableString("mix(30C30C00C").mangledNameHash());
    ASSERT_EQ(0x00000844u, ImmutableString("mix(10C10C10C").mangledNameHash());
    ASSERT_EQ(0x0000029bu, ImmutableString("mix(20C20C20C").mangledNameHash());
    ASSERT_EQ(0x00000760u, ImmutableString("mix(30C30C30C").mangledNameHash());
    ASSERT_EQ(0x00000250u, ImmutableString("mix(00B00B00F").mangledNameHash());
    ASSERT_EQ(0x0000053bu, ImmutableString("mix(10B10B10F").mangledNameHash());
    ASSERT_EQ(0x0000015bu, ImmutableString("mix(20B20B20F").mangledNameHash());
    ASSERT_EQ(0x000003beu, ImmutableString("mix(30B30B30F").mangledNameHash());
    ASSERT_EQ(0x00000174u, ImmutableString("mix(00C00C00F").mangledNameHash());
    ASSERT_EQ(0x0000058fu, ImmutableString("mix(10C10C10F").mangledNameHash());
    ASSERT_EQ(0x00000298u, ImmutableString("mix(20C20C20F").mangledNameHash());
    ASSERT_EQ(0x0000075fu, ImmutableString("mix(30C30C30F").mangledNameHash());
    ASSERT_EQ(0x000002edu, ImmutableString("mix(00D00D00F").mangledNameHash());
    ASSERT_EQ(0x000002c4u, ImmutableString("mix(10D10D10F").mangledNameHash());
    ASSERT_EQ(0x00000034u, ImmutableString("mix(20D20D20F").mangledNameHash());
    ASSERT_EQ(0x00000121u, ImmutableString("mix(30D30D30F").mangledNameHash());
    ASSERT_EQ(0x000002ebu, ImmutableString("mix(00E00E00F").mangledNameHash());
    ASSERT_EQ(0x000007e2u, ImmutableString("mix(10E10E10F").mangledNameHash());
    ASSERT_EQ(0x00000415u, ImmutableString("mix(20E20E20F").mangledNameHash());
    ASSERT_EQ(0x00000264u, ImmutableString("mix(30E30E30F").mangledNameHash());
    ASSERT_EQ(0x00000183u, ImmutableString("mix(00F00F00F").mangledNameHash());
    ASSERT_EQ(0x000003ceu, ImmutableString("mix(10F10F10F").mangledNameHash());
    ASSERT_EQ(0x000001b5u, ImmutableString("mix(20F20F20F").mangledNameHash());
    ASSERT_EQ(0x00000245u, ImmutableString("mix(30F30F30F").mangledNameHash());
    ASSERT_EQ(0x00000739u, ImmutableString("step(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000016au, ImmutableString("step(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000008bu, ImmutableString("step(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000363u, ImmutableString("step(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000069au, ImmutableString("step(00B10B").mangledNameHash());
    ASSERT_EQ(0x00000443u, ImmutableString("step(00B20B").mangledNameHash());
    ASSERT_EQ(0x00000378u, ImmutableString("step(00B30B").mangledNameHash());
    ASSERT_EQ(0x0000006du, ImmutableString("step(00C00C").mangledNameHash());
    ASSERT_EQ(0x00000554u, ImmutableString("step(10C10C").mangledNameHash());
    ASSERT_EQ(0x00000045u, ImmutableString("step(20C20C").mangledNameHash());
    ASSERT_EQ(0x000003bau, ImmutableString("step(30C30C").mangledNameHash());
    ASSERT_EQ(0x00000102u, ImmutableString("step(00C10C").mangledNameHash());
    ASSERT_EQ(0x0000037cu, ImmutableString("step(00C20C").mangledNameHash());
    ASSERT_EQ(0x00000445u, ImmutableString("step(00C30C").mangledNameHash());
    ASSERT_EQ(0x0000079bu, ImmutableString("smoothstep(00C00C00C").mangledNameHash());
    ASSERT_EQ(0x00000242u, ImmutableString("smoothstep(10C10C10C").mangledNameHash());
    ASSERT_EQ(0x00000538u, ImmutableString("smoothstep(20C20C20C").mangledNameHash());
    ASSERT_EQ(0x000004f9u, ImmutableString("smoothstep(30C30C30C").mangledNameHash());
    ASSERT_EQ(0x000006eeu, ImmutableString("smoothstep(00C00C10C").mangledNameHash());
    ASSERT_EQ(0x00000087u, ImmutableString("smoothstep(00C00C20C").mangledNameHash());
    ASSERT_EQ(0x000007c9u, ImmutableString("smoothstep(00C00C30C").mangledNameHash());
    ASSERT_EQ(0x00000607u, ImmutableString("smoothstep(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000033bu, ImmutableString("smoothstep(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000208u, ImmutableString("smoothstep(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000001d1u, ImmutableString("smoothstep(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x00000557u, ImmutableString("smoothstep(00B00B10B").mangledNameHash());
    ASSERT_EQ(0x000002f1u, ImmutableString("smoothstep(00B00B20B").mangledNameHash());
    ASSERT_EQ(0x000001b6u, ImmutableString("smoothstep(00B00B30B").mangledNameHash());
    ASSERT_EQ(0x0000042eu, ImmutableString("modf(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000004fu, ImmutableString("modf(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000582u, ImmutableString("modf(20B20B").mangledNameHash());
    ASSERT_EQ(0x000002cau, ImmutableString("modf(30B30B").mangledNameHash());
    ASSERT_EQ(0x000005d1u, ImmutableString("modf(00C00C").mangledNameHash());
    ASSERT_EQ(0x000003f2u, ImmutableString("modf(10C10C").mangledNameHash());
    ASSERT_EQ(0x00000421u, ImmutableString("modf(20C20C").mangledNameHash());
    ASSERT_EQ(0x000002e1u, ImmutableString("modf(30C30C").mangledNameHash());
    ASSERT_EQ(0x00000344u, ImmutableString("isnan(00B").mangledNameHash());
    ASSERT_EQ(0x00000409u, ImmutableString("isnan(10B").mangledNameHash());
    ASSERT_EQ(0x00000705u, ImmutableString("isnan(20B").mangledNameHash());
    ASSERT_EQ(0x0000043bu, ImmutableString("isnan(30B").mangledNameHash());
    ASSERT_EQ(0x00000345u, ImmutableString("isnan(00C").mangledNameHash());
    ASSERT_EQ(0x00000408u, ImmutableString("isnan(10C").mangledNameHash());
    ASSERT_EQ(0x00000706u, ImmutableString("isnan(20C").mangledNameHash());
    ASSERT_EQ(0x000007b6u, ImmutableString("isnan(30C").mangledNameHash());
    ASSERT_EQ(0x000000efu, ImmutableString("isinf(00B").mangledNameHash());
    ASSERT_EQ(0x0000019au, ImmutableString("isinf(10B").mangledNameHash());
    ASSERT_EQ(0x0000082au, ImmutableString("isinf(20B").mangledNameHash());
    ASSERT_EQ(0x00000077u, ImmutableString("isinf(30B").mangledNameHash());
    ASSERT_EQ(0x000000f0u, ImmutableString("isinf(00C").mangledNameHash());
    ASSERT_EQ(0x00000199u, ImmutableString("isinf(10C").mangledNameHash());
    ASSERT_EQ(0x0000072au, ImmutableString("isinf(20C").mangledNameHash());
    ASSERT_EQ(0x000002c1u, ImmutableString("isinf(30C").mangledNameHash());
    ASSERT_EQ(0x00000419u, ImmutableString("floatBitsToInt(00B").mangledNameHash());
    ASSERT_EQ(0x00000416u, ImmutableString("floatBitsToInt(10B").mangledNameHash());
    ASSERT_EQ(0x000002d2u, ImmutableString("floatBitsToInt(20B").mangledNameHash());
    ASSERT_EQ(0x00000236u, ImmutableString("floatBitsToInt(30B").mangledNameHash());
    ASSERT_EQ(0x0000041bu, ImmutableString("floatBitsToUint(00B").mangledNameHash());
    ASSERT_EQ(0x00000492u, ImmutableString("floatBitsToUint(10B").mangledNameHash());
    ASSERT_EQ(0x00000032u, ImmutableString("floatBitsToUint(20B").mangledNameHash());
    ASSERT_EQ(0x0000035bu, ImmutableString("floatBitsToUint(30B").mangledNameHash());
    ASSERT_EQ(0x000007e8u, ImmutableString("intBitsToFloat(00D").mangledNameHash());
    ASSERT_EQ(0x00000740u, ImmutableString("intBitsToFloat(10D").mangledNameHash());
    ASSERT_EQ(0x000000d5u, ImmutableString("intBitsToFloat(20D").mangledNameHash());
    ASSERT_EQ(0x00000157u, ImmutableString("intBitsToFloat(30D").mangledNameHash());
    ASSERT_EQ(0x0000067du, ImmutableString("uintBitsToFloat(00E").mangledNameHash());
    ASSERT_EQ(0x00000712u, ImmutableString("uintBitsToFloat(10E").mangledNameHash());
    ASSERT_EQ(0x000007d9u, ImmutableString("uintBitsToFloat(20E").mangledNameHash());
    ASSERT_EQ(0x0000001du, ImmutableString("uintBitsToFloat(30E").mangledNameHash());
    ASSERT_EQ(0x00000836u, ImmutableString("fma(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000556u, ImmutableString("fma(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000017bu, ImmutableString("fma(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000025du, ImmutableString("fma(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x00000258u, ImmutableString("fma(00C00C00C").mangledNameHash());
    ASSERT_EQ(0x0000005fu, ImmutableString("fma(10C10C10C").mangledNameHash());
    ASSERT_EQ(0x00000200u, ImmutableString("fma(20C20C20C").mangledNameHash());
    ASSERT_EQ(0x0000006au, ImmutableString("fma(30C30C30C").mangledNameHash());
    ASSERT_EQ(0x00000274u, ImmutableString("frexp(00B00D").mangledNameHash());
    ASSERT_EQ(0x000002aau, ImmutableString("frexp(10B10D").mangledNameHash());
    ASSERT_EQ(0x00000541u, ImmutableString("frexp(20B20D").mangledNameHash());
    ASSERT_EQ(0x00000103u, ImmutableString("frexp(30B30D").mangledNameHash());
    ASSERT_EQ(0x00000134u, ImmutableString("frexp(00C00D").mangledNameHash());
    ASSERT_EQ(0x00000370u, ImmutableString("frexp(10C10D").mangledNameHash());
    ASSERT_EQ(0x0000010eu, ImmutableString("frexp(20C20D").mangledNameHash());
    ASSERT_EQ(0x00000843u, ImmutableString("frexp(30C30D").mangledNameHash());
    ASSERT_EQ(0x00000229u, ImmutableString("ldexp(00B00D").mangledNameHash());
    ASSERT_EQ(0x0000080du, ImmutableString("ldexp(10B10D").mangledNameHash());
    ASSERT_EQ(0x000001d7u, ImmutableString("ldexp(20B20D").mangledNameHash());
    ASSERT_EQ(0x0000035fu, ImmutableString("ldexp(30B30D").mangledNameHash());
    ASSERT_EQ(0x00000655u, ImmutableString("ldexp(00C00D").mangledNameHash());
    ASSERT_EQ(0x00000432u, ImmutableString("ldexp(10C10D").mangledNameHash());
    ASSERT_EQ(0x00000226u, ImmutableString("ldexp(20C20D").mangledNameHash());
    ASSERT_EQ(0x0000023du, ImmutableString("ldexp(30C30D").mangledNameHash());
    ASSERT_EQ(0x0000035au, ImmutableString("packSnorm2x16(10B").mangledNameHash());
    ASSERT_EQ(0x00000397u, ImmutableString("packHalf2x16(10B").mangledNameHash());
    ASSERT_EQ(0x00000773u, ImmutableString("unpackSnorm2x16(00E").mangledNameHash());
    ASSERT_EQ(0x00000099u, ImmutableString("unpackHalf2x16(00E").mangledNameHash());
    ASSERT_EQ(0x0000018bu, ImmutableString("packUnorm2x16(10B").mangledNameHash());
    ASSERT_EQ(0x0000046du, ImmutableString("unpackUnorm2x16(00E").mangledNameHash());
    ASSERT_EQ(0x00000476u, ImmutableString("packUnorm4x8(30B").mangledNameHash());
    ASSERT_EQ(0x000005e8u, ImmutableString("packSnorm4x8(30B").mangledNameHash());
    ASSERT_EQ(0x000007dau, ImmutableString("unpackUnorm4x8(00E").mangledNameHash());
    ASSERT_EQ(0x000006feu, ImmutableString("unpackSnorm4x8(00E").mangledNameHash());
    ASSERT_EQ(0x000004e2u, ImmutableString("packDouble2x32(10E").mangledNameHash());
    ASSERT_EQ(0x00000255u, ImmutableString("unpackDouble2x32(00C").mangledNameHash());
    ASSERT_EQ(0x0000077bu, ImmutableString("length(00B").mangledNameHash());
    ASSERT_EQ(0x000006d8u, ImmutableString("length(10B").mangledNameHash());
    ASSERT_EQ(0x00000228u, ImmutableString("length(20B").mangledNameHash());
    ASSERT_EQ(0x0000058cu, ImmutableString("length(30B").mangledNameHash());
    ASSERT_EQ(0x0000077cu, ImmutableString("length(00C").mangledNameHash());
    ASSERT_EQ(0x000006d7u, ImmutableString("length(10C").mangledNameHash());
    ASSERT_EQ(0x00000231u, ImmutableString("length(20C").mangledNameHash());
    ASSERT_EQ(0x0000058bu, ImmutableString("length(30C").mangledNameHash());
    ASSERT_EQ(0x000007a4u, ImmutableString("distance(00B00B").mangledNameHash());
    ASSERT_EQ(0x000000c7u, ImmutableString("distance(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000052bu, ImmutableString("distance(20B20B").mangledNameHash());
    ASSERT_EQ(0x000004bdu, ImmutableString("distance(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000043au, ImmutableString("distance(00C00C").mangledNameHash());
    ASSERT_EQ(0x00000310u, ImmutableString("distance(10C10C").mangledNameHash());
    ASSERT_EQ(0x0000079eu, ImmutableString("distance(20C20C").mangledNameHash());
    ASSERT_EQ(0x00000562u, ImmutableString("distance(30C30C").mangledNameHash());
    ASSERT_EQ(0x000006ddu, ImmutableString("dot(00B00B").mangledNameHash());
    ASSERT_EQ(0x000002acu, ImmutableString("dot(10B10B").mangledNameHash());
    ASSERT_EQ(0x000003dau, ImmutableString("dot(20B20B").mangledNameHash());
    ASSERT_EQ(0x000004c9u, ImmutableString("dot(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000037du, ImmutableString("dot(00C00C").mangledNameHash());
    ASSERT_EQ(0x0000072eu, ImmutableString("dot(10C10C").mangledNameHash());
    ASSERT_EQ(0x0000063cu, ImmutableString("dot(20C20C").mangledNameHash());
    ASSERT_EQ(0x00000601u, ImmutableString("dot(30C30C").mangledNameHash());
    ASSERT_EQ(0x000005a8u, ImmutableString("cross(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000336u, ImmutableString("cross(20C20C").mangledNameHash());
    ASSERT_EQ(0x00000489u, ImmutableString("normalize(00B").mangledNameHash());
    ASSERT_EQ(0x00000703u, ImmutableString("normalize(10B").mangledNameHash());
    ASSERT_EQ(0x0000010au, ImmutableString("normalize(20B").mangledNameHash());
    ASSERT_EQ(0x000003e3u, ImmutableString("normalize(30B").mangledNameHash());
    ASSERT_EQ(0x0000048au, ImmutableString("normalize(00C").mangledNameHash());
    ASSERT_EQ(0x000006fdu, ImmutableString("normalize(10C").mangledNameHash());
    ASSERT_EQ(0x0000010bu, ImmutableString("normalize(20C").mangledNameHash());
    ASSERT_EQ(0x000003e2u, ImmutableString("normalize(30C").mangledNameHash());
    ASSERT_EQ(0x000005c5u, ImmutableString("faceforward(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000038eu, ImmutableString("faceforward(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000178u, ImmutableString("faceforward(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000079du, ImmutableString("faceforward(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x000002fdu, ImmutableString("faceforward(00C00C00C").mangledNameHash());
    ASSERT_EQ(0x00000677u, ImmutableString("faceforward(10C10C10C").mangledNameHash());
    ASSERT_EQ(0x00000748u, ImmutableString("faceforward(20C20C20C").mangledNameHash());
    ASSERT_EQ(0x00000520u, ImmutableString("faceforward(30C30C30C").mangledNameHash());
    ASSERT_EQ(0x00000283u, ImmutableString("reflect(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000295u, ImmutableString("reflect(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000502u, ImmutableString("reflect(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000517u, ImmutableString("reflect(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000155u, ImmutableString("reflect(00C00C").mangledNameHash());
    ASSERT_EQ(0x0000053cu, ImmutableString("reflect(10C10C").mangledNameHash());
    ASSERT_EQ(0x0000068fu, ImmutableString("reflect(20C20C").mangledNameHash());
    ASSERT_EQ(0x000004dcu, ImmutableString("reflect(30C30C").mangledNameHash());
    ASSERT_EQ(0x000000f9u, ImmutableString("refract(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000296u, ImmutableString("refract(10B10B00B").mangledNameHash());
    ASSERT_EQ(0x00000302u, ImmutableString("refract(20B20B00B").mangledNameHash());
    ASSERT_EQ(0x00000573u, ImmutableString("refract(30B30B00B").mangledNameHash());
    ASSERT_EQ(0x0000071bu, ImmutableString("refract(00C00C00B").mangledNameHash());
    ASSERT_EQ(0x0000034au, ImmutableString("refract(10C10C00B").mangledNameHash());
    ASSERT_EQ(0x00000648u, ImmutableString("refract(20C20C00B").mangledNameHash());
    ASSERT_EQ(0x00000357u, ImmutableString("refract(30C30C00B").mangledNameHash());
    ASSERT_EQ(0x000002b9u, ImmutableString("ftransform(").mangledNameHash());
    ASSERT_EQ(0x000001efu, ImmutableString("matrixCompMult(50B50B").mangledNameHash());
    ASSERT_EQ(0x000006e6u, ImmutableString("matrixCompMult(A0BA0B").mangledNameHash());
    ASSERT_EQ(0x00000578u, ImmutableString("matrixCompMult(F0BF0B").mangledNameHash());
    ASSERT_EQ(0x00000145u, ImmutableString("matrixCompMult(90B90B").mangledNameHash());
    ASSERT_EQ(0x0000076fu, ImmutableString("matrixCompMult(60B60B").mangledNameHash());
    ASSERT_EQ(0x00000689u, ImmutableString("matrixCompMult(D0BD0B").mangledNameHash());
    ASSERT_EQ(0x00000714u, ImmutableString("matrixCompMult(70B70B").mangledNameHash());
    ASSERT_EQ(0x0000032eu, ImmutableString("matrixCompMult(E0BE0B").mangledNameHash());
    ASSERT_EQ(0x000005a6u, ImmutableString("matrixCompMult(B0BB0B").mangledNameHash());
    ASSERT_EQ(0x0000009au, ImmutableString("outerProduct(10B10B").mangledNameHash());
    ASSERT_EQ(0x000000b5u, ImmutableString("outerProduct(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000017eu, ImmutableString("outerProduct(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000728u, ImmutableString("outerProduct(20B10B").mangledNameHash());
    ASSERT_EQ(0x00000095u, ImmutableString("outerProduct(10B20B").mangledNameHash());
    ASSERT_EQ(0x000002cdu, ImmutableString("outerProduct(30B10B").mangledNameHash());
    ASSERT_EQ(0x0000012fu, ImmutableString("outerProduct(10B30B").mangledNameHash());
    ASSERT_EQ(0x000000e0u, ImmutableString("outerProduct(30B20B").mangledNameHash());
    ASSERT_EQ(0x00000014u, ImmutableString("outerProduct(20B30B").mangledNameHash());
    ASSERT_EQ(0x000007b7u, ImmutableString("transpose(50B").mangledNameHash());
    ASSERT_EQ(0x000005f2u, ImmutableString("transpose(A0B").mangledNameHash());
    ASSERT_EQ(0x000006adu, ImmutableString("transpose(F0B").mangledNameHash());
    ASSERT_EQ(0x000005c1u, ImmutableString("transpose(60B").mangledNameHash());
    ASSERT_EQ(0x000006bbu, ImmutableString("transpose(90B").mangledNameHash());
    ASSERT_EQ(0x00000670u, ImmutableString("transpose(70B").mangledNameHash());
    ASSERT_EQ(0x000007f3u, ImmutableString("transpose(D0B").mangledNameHash());
    ASSERT_EQ(0x000001b3u, ImmutableString("transpose(B0B").mangledNameHash());
    ASSERT_EQ(0x00000048u, ImmutableString("transpose(E0B").mangledNameHash());
    ASSERT_EQ(0x00000050u, ImmutableString("determinant(50B").mangledNameHash());
    ASSERT_EQ(0x00000434u, ImmutableString("determinant(A0B").mangledNameHash());
    ASSERT_EQ(0x000005f1u, ImmutableString("determinant(F0B").mangledNameHash());
    ASSERT_EQ(0x000002abu, ImmutableString("inverse(50B").mangledNameHash());
    ASSERT_EQ(0x00000545u, ImmutableString("inverse(A0B").mangledNameHash());
    ASSERT_EQ(0x0000010du, ImmutableString("inverse(F0B").mangledNameHash());
    ASSERT_EQ(0x000001a2u, ImmutableString("lessThan(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000053u, ImmutableString("lessThan(20B20B").mangledNameHash());
    ASSERT_EQ(0x000005a7u, ImmutableString("lessThan(30B30B").mangledNameHash());
    ASSERT_EQ(0x000004e5u, ImmutableString("lessThan(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000072u, ImmutableString("lessThan(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000774u, ImmutableString("lessThan(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000066u, ImmutableString("lessThan(10E10E").mangledNameHash());
    ASSERT_EQ(0x000005b4u, ImmutableString("lessThan(20E20E").mangledNameHash());
    ASSERT_EQ(0x0000066eu, ImmutableString("lessThan(30E30E").mangledNameHash());
    ASSERT_EQ(0x0000024cu, ImmutableString("lessThanEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000023fu, ImmutableString("lessThanEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000010u, ImmutableString("lessThanEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000612u, ImmutableString("lessThanEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x000001abu, ImmutableString("lessThanEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x0000043du, ImmutableString("lessThanEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000150u, ImmutableString("lessThanEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x000007d2u, ImmutableString("lessThanEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x0000007cu, ImmutableString("lessThanEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000411u, ImmutableString("greaterThan(10B10B").mangledNameHash());
    ASSERT_EQ(0x000007beu, ImmutableString("greaterThan(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000176u, ImmutableString("greaterThan(30B30B").mangledNameHash());
    ASSERT_EQ(0x000006ccu, ImmutableString("greaterThan(10D10D").mangledNameHash());
    ASSERT_EQ(0x000006d1u, ImmutableString("greaterThan(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000084u, ImmutableString("greaterThan(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000202u, ImmutableString("greaterThan(10E10E").mangledNameHash());
    ASSERT_EQ(0x000000f7u, ImmutableString("greaterThan(20E20E").mangledNameHash());
    ASSERT_EQ(0x00000113u, ImmutableString("greaterThan(30E30E").mangledNameHash());
    ASSERT_EQ(0x000006a9u, ImmutableString("greaterThanEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000002au, ImmutableString("greaterThanEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000019cu, ImmutableString("greaterThanEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x000000ceu, ImmutableString("greaterThanEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x000007b8u, ImmutableString("greaterThanEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x000001d8u, ImmutableString("greaterThanEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000023u, ImmutableString("greaterThanEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x000002beu, ImmutableString("greaterThanEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x0000015au, ImmutableString("greaterThanEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000406u, ImmutableString("equal(10B10B").mangledNameHash());
    ASSERT_EQ(0x000002e6u, ImmutableString("equal(20B20B").mangledNameHash());
    ASSERT_EQ(0x000001f0u, ImmutableString("equal(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000003fu, ImmutableString("equal(10D10D").mangledNameHash());
    ASSERT_EQ(0x000007e1u, ImmutableString("equal(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000358u, ImmutableString("equal(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000623u, ImmutableString("equal(10E10E").mangledNameHash());
    ASSERT_EQ(0x0000013eu, ImmutableString("equal(20E20E").mangledNameHash());
    ASSERT_EQ(0x0000037au, ImmutableString("equal(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000505u, ImmutableString("equal(10F10F").mangledNameHash());
    ASSERT_EQ(0x00000403u, ImmutableString("equal(20F20F").mangledNameHash());
    ASSERT_EQ(0x000005b6u, ImmutableString("equal(30F30F").mangledNameHash());
    ASSERT_EQ(0x00000777u, ImmutableString("notEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000350u, ImmutableString("notEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x000002f6u, ImmutableString("notEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000381u, ImmutableString("notEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x0000042fu, ImmutableString("notEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x000004a5u, ImmutableString("notEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x0000062bu, ImmutableString("notEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000543u, ImmutableString("notEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x0000014du, ImmutableString("notEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000606u, ImmutableString("notEqual(10F10F").mangledNameHash());
    ASSERT_EQ(0x0000049fu, ImmutableString("notEqual(20F20F").mangledNameHash());
    ASSERT_EQ(0x000003a5u, ImmutableString("notEqual(30F30F").mangledNameHash());
    ASSERT_EQ(0x00000160u, ImmutableString("any(10F").mangledNameHash());
    ASSERT_EQ(0x00000563u, ImmutableString("any(20F").mangledNameHash());
    ASSERT_EQ(0x000004bcu, ImmutableString("any(30F").mangledNameHash());
    ASSERT_EQ(0x00000075u, ImmutableString("all(10F").mangledNameHash());
    ASSERT_EQ(0x00000392u, ImmutableString("all(20F").mangledNameHash());
    ASSERT_EQ(0x00000450u, ImmutableString("all(30F").mangledNameHash());
    ASSERT_EQ(0x0000000eu, ImmutableString("not(10F").mangledNameHash());
    ASSERT_EQ(0x000000b1u, ImmutableString("not(20F").mangledNameHash());
    ASSERT_EQ(0x00000818u, ImmutableString("not(30F").mangledNameHash());
    ASSERT_EQ(0x000005b9u, ImmutableString("bitfieldExtract(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000e6u, ImmutableString("bitfieldExtract(10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000011du, ImmutableString("bitfieldExtract(20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007e5u, ImmutableString("bitfieldExtract(30D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000561u, ImmutableString("bitfieldExtract(00E00D00D").mangledNameHash());
    ASSERT_EQ(0x000006cdu, ImmutableString("bitfieldExtract(10E00D00D").mangledNameHash());
    ASSERT_EQ(0x000007d8u, ImmutableString("bitfieldExtract(20E00D00D").mangledNameHash());
    ASSERT_EQ(0x000000ccu, ImmutableString("bitfieldExtract(30E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000022au, ImmutableString("bitfieldInsert(00D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000060du, ImmutableString("bitfieldInsert(10D10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000681u, ImmutableString("bitfieldInsert(20D20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006cau, ImmutableString("bitfieldInsert(30D30D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000692u, ImmutableString("bitfieldInsert(00E00E00D00D").mangledNameHash());
    ASSERT_EQ(0x000005e7u, ImmutableString("bitfieldInsert(10E10E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000078eu, ImmutableString("bitfieldInsert(20E20E00D00D").mangledNameHash());
    ASSERT_EQ(0x000007d7u, ImmutableString("bitfieldInsert(30E30E00D00D").mangledNameHash());
    ASSERT_EQ(0x000000cau, ImmutableString("bitfieldReverse(00D").mangledNameHash());
    ASSERT_EQ(0x0000016fu, ImmutableString("bitfieldReverse(10D").mangledNameHash());
    ASSERT_EQ(0x00000455u, ImmutableString("bitfieldReverse(20D").mangledNameHash());
    ASSERT_EQ(0x0000050au, ImmutableString("bitfieldReverse(30D").mangledNameHash());
    ASSERT_EQ(0x000000cbu, ImmutableString("bitfieldReverse(00E").mangledNameHash());
    ASSERT_EQ(0x0000016eu, ImmutableString("bitfieldReverse(10E").mangledNameHash());
    ASSERT_EQ(0x00000456u, ImmutableString("bitfieldReverse(20E").mangledNameHash());
    ASSERT_EQ(0x00000509u, ImmutableString("bitfieldReverse(30E").mangledNameHash());
    ASSERT_EQ(0x00000234u, ImmutableString("bitCount(00D").mangledNameHash());
    ASSERT_EQ(0x00000181u, ImmutableString("bitCount(10D").mangledNameHash());
    ASSERT_EQ(0x00000526u, ImmutableString("bitCount(20D").mangledNameHash());
    ASSERT_EQ(0x0000046cu, ImmutableString("bitCount(30D").mangledNameHash());
    ASSERT_EQ(0x00000235u, ImmutableString("bitCount(00E").mangledNameHash());
    ASSERT_EQ(0x00000180u, ImmutableString("bitCount(10E").mangledNameHash());
    ASSERT_EQ(0x00000527u, ImmutableString("bitCount(20E").mangledNameHash());
    ASSERT_EQ(0x000001bfu, ImmutableString("bitCount(30E").mangledNameHash());
    ASSERT_EQ(0x000005adu, ImmutableString("findLSB(00D").mangledNameHash());
    ASSERT_EQ(0x00000742u, ImmutableString("findLSB(10D").mangledNameHash());
    ASSERT_EQ(0x000006a3u, ImmutableString("findLSB(20D").mangledNameHash());
    ASSERT_EQ(0x00000388u, ImmutableString("findLSB(30D").mangledNameHash());
    ASSERT_EQ(0x000007eau, ImmutableString("findLSB(00E").mangledNameHash());
    ASSERT_EQ(0x000001dau, ImmutableString("findLSB(10E").mangledNameHash());
    ASSERT_EQ(0x000006a2u, ImmutableString("findLSB(20E").mangledNameHash());
    ASSERT_EQ(0x00000389u, ImmutableString("findLSB(30E").mangledNameHash());
    ASSERT_EQ(0x0000083fu, ImmutableString("findMSB(00D").mangledNameHash());
    ASSERT_EQ(0x0000008eu, ImmutableString("findMSB(10D").mangledNameHash());
    ASSERT_EQ(0x000006f7u, ImmutableString("findMSB(20D").mangledNameHash());
    ASSERT_EQ(0x000007aeu, ImmutableString("findMSB(30D").mangledNameHash());
    ASSERT_EQ(0x00000840u, ImmutableString("findMSB(00E").mangledNameHash());
    ASSERT_EQ(0x0000008du, ImmutableString("findMSB(10E").mangledNameHash());
    ASSERT_EQ(0x0000000fu, ImmutableString("findMSB(20E").mangledNameHash());
    ASSERT_EQ(0x000007adu, ImmutableString("findMSB(30E").mangledNameHash());
    ASSERT_EQ(0x0000013fu, ImmutableString("uaddCarry(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000617u, ImmutableString("uaddCarry(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x00000213u, ImmutableString("uaddCarry(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x0000052du, ImmutableString("uaddCarry(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x0000054au, ImmutableString("usubBorrow(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000405u, ImmutableString("usubBorrow(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x000004cfu, ImmutableString("usubBorrow(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x0000059fu, ImmutableString("usubBorrow(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x00000807u, ImmutableString("umulExtended(00E00E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000579u, ImmutableString("umulExtended(10E10E10E10E").mangledNameHash());
    ASSERT_EQ(0x0000018du, ImmutableString("umulExtended(20E20E20E20E").mangledNameHash());
    ASSERT_EQ(0x0000057cu, ImmutableString("umulExtended(30E30E30E30E").mangledNameHash());
    ASSERT_EQ(0x00000671u, ImmutableString("imulExtended(00D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000346u, ImmutableString("imulExtended(10D10D10D10D").mangledNameHash());
    ASSERT_EQ(0x000004bbu, ImmutableString("imulExtended(20D20D20D20D").mangledNameHash());
    ASSERT_EQ(0x0000066fu, ImmutableString("imulExtended(30D30D30D30D").mangledNameHash());
    ASSERT_EQ(0x00000275u, ImmutableString("texture2D(00I10B").mangledNameHash());
    ASSERT_EQ(0x00000005u, ImmutableString("texture2DProj(00I20B").mangledNameHash());
    ASSERT_EQ(0x0000034du, ImmutableString("texture2DProj(00I30B").mangledNameHash());
    ASSERT_EQ(0x00000141u, ImmutableString("textureCube(00K20B").mangledNameHash());
    ASSERT_EQ(0x0000036fu, ImmutableString("texture1D(00g00B").mangledNameHash());
    ASSERT_EQ(0x0000066du, ImmutableString("texture1DProj(00g10B").mangledNameHash());
    ASSERT_EQ(0x0000050du, ImmutableString("texture1DProj(00g30B").mangledNameHash());
    ASSERT_EQ(0x00000745u, ImmutableString("texture3D(00J20B").mangledNameHash());
    ASSERT_EQ(0x000005a5u, ImmutableString("texture3DProj(00J30B").mangledNameHash());
    ASSERT_EQ(0x00000800u, ImmutableString("shadow1D(00m20B").mangledNameHash());
    ASSERT_EQ(0x00000834u, ImmutableString("shadow1DProj(00m30B").mangledNameHash());
    ASSERT_EQ(0x0000038bu, ImmutableString("shadow2D(00d20B").mangledNameHash());
    ASSERT_EQ(0x00000642u, ImmutableString("shadow2DProj(00d30B").mangledNameHash());
    ASSERT_EQ(0x000003e8u, ImmutableString("texture2D(00M10B").mangledNameHash());
    ASSERT_EQ(0x00000380u, ImmutableString("texture2DProj(00M20B").mangledNameHash());
    ASSERT_EQ(0x0000043fu, ImmutableString("texture2DProj(00M30B").mangledNameHash());
    ASSERT_EQ(0x00000088u, ImmutableString("texture2DRect(00O10B").mangledNameHash());
    ASSERT_EQ(0x00000420u, ImmutableString("texture2DRectProj(00O20B").mangledNameHash());
    ASSERT_EQ(0x000004d4u, ImmutableString("texture2DRectProj(00O30B").mangledNameHash());
    ASSERT_EQ(0x0000047bu, ImmutableString("texture(00O10B").mangledNameHash());
    ASSERT_EQ(0x000002a8u, ImmutableString("textureProj(00O20B").mangledNameHash());
    ASSERT_EQ(0x0000033cu, ImmutableString("textureProj(00O30B").mangledNameHash());
    ASSERT_EQ(0x00000259u, ImmutableString("texture2DGradEXT(00I10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000003b7u, ImmutableString("texture2DProjGradEXT(00I20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000025cu, ImmutableString("texture2DProjGradEXT(00I30B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000075bu, ImmutableString("textureCubeGradEXT(00K20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000006d0u, ImmutableString("texture2D(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x000000f2u, ImmutableString("texture2DProj(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x00000758u, ImmutableString("texture2DProj(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x000001a1u, ImmutableString("textureCube(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000004c4u, ImmutableString("texture3D(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x00000596u, ImmutableString("texture3DProj(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x0000042au, ImmutableString("texture3DLod(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x000002c0u, ImmutableString("texture3DProjLod(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x0000051du, ImmutableString("texture1D(00g00B00B").mangledNameHash());
    ASSERT_EQ(0x000001e7u, ImmutableString("texture1DProj(00g10B00B").mangledNameHash());
    ASSERT_EQ(0x000005ceu, ImmutableString("texture1DProj(00g30B00B").mangledNameHash());
    ASSERT_EQ(0x000000a7u, ImmutableString("shadow1D(00m20B00B").mangledNameHash());
    ASSERT_EQ(0x000004d1u, ImmutableString("shadow1DProj(00m30B00B").mangledNameHash());
    ASSERT_EQ(0x00000217u, ImmutableString("shadow2D(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x000007edu, ImmutableString("shadow2DProj(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x000005acu, ImmutableString("dFdx(00B").mangledNameHash());
    ASSERT_EQ(0x00000508u, ImmutableString("dFdx(10B").mangledNameHash());
    ASSERT_EQ(0x000006f0u, ImmutableString("dFdx(20B").mangledNameHash());
    ASSERT_EQ(0x0000065fu, ImmutableString("dFdx(30B").mangledNameHash());
    ASSERT_EQ(0x0000066bu, ImmutableString("dFdy(00B").mangledNameHash());
    ASSERT_EQ(0x00000708u, ImmutableString("dFdy(10B").mangledNameHash());
    ASSERT_EQ(0x000000ebu, ImmutableString("dFdy(20B").mangledNameHash());
    ASSERT_EQ(0x00000198u, ImmutableString("dFdy(30B").mangledNameHash());
    ASSERT_EQ(0x00000707u, ImmutableString("fwidth(00B").mangledNameHash());
    ASSERT_EQ(0x0000066au, ImmutableString("fwidth(10B").mangledNameHash());
    ASSERT_EQ(0x00000848u, ImmutableString("fwidth(20B").mangledNameHash());
    ASSERT_EQ(0x000007b0u, ImmutableString("fwidth(30B").mangledNameHash());
    ASSERT_EQ(0x0000073au, ImmutableString("texture2DLodEXT(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x0000019du, ImmutableString("texture2DProjLodEXT(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x00000735u, ImmutableString("texture2DProjLodEXT(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x000003ecu, ImmutableString("textureCubeLodEXT(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x00000372u, ImmutableString("texture2DLod(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x00000444u, ImmutableString("texture2DProjLod(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000005e2u, ImmutableString("texture2DProjLod(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000192u, ImmutableString("textureCubeLod(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000004c5u, ImmutableString("texture1DLod(00g00B00B").mangledNameHash());
    ASSERT_EQ(0x00000669u, ImmutableString("texture1DProjLod(00g10B00B").mangledNameHash());
    ASSERT_EQ(0x000004eau, ImmutableString("texture1DProjLod(00g30B00B").mangledNameHash());
    ASSERT_EQ(0x00000438u, ImmutableString("shadow1DLod(00m20B00B").mangledNameHash());
    ASSERT_EQ(0x00000634u, ImmutableString("shadow1DProjLod(00m30B00B").mangledNameHash());
    ASSERT_EQ(0x0000066cu, ImmutableString("shadow2DLod(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x0000068cu, ImmutableString("shadow2DProjLod(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x00000108u, ImmutableString("texture(00I10B").mangledNameHash());
    ASSERT_EQ(0x00000165u, ImmutableString("texture(00R10B").mangledNameHash());
    ASSERT_EQ(0x000007a1u, ImmutableString("texture(00X10B").mangledNameHash());
    ASSERT_EQ(0x00000611u, ImmutableString("texture(00J20B").mangledNameHash());
    ASSERT_EQ(0x000000e1u, ImmutableString("texture(00S20B").mangledNameHash());
    ASSERT_EQ(0x00000271u, ImmutableString("texture(00Y20B").mangledNameHash());
    ASSERT_EQ(0x00000813u, ImmutableString("texture(00K20B").mangledNameHash());
    ASSERT_EQ(0x0000069eu, ImmutableString("texture(00T20B").mangledNameHash());
    ASSERT_EQ(0x00000811u, ImmutableString("texture(00Z20B").mangledNameHash());
    ASSERT_EQ(0x000006f1u, ImmutableString("texture(00L20B").mangledNameHash());
    ASSERT_EQ(0x00000085u, ImmutableString("texture(00U20B").mangledNameHash());
    ASSERT_EQ(0x0000080au, ImmutableString("texture(00a20B").mangledNameHash());
    ASSERT_EQ(0x00000024u, ImmutableString("texture(00d20B").mangledNameHash());
    ASSERT_EQ(0x000001e0u, ImmutableString("texture(00e30B").mangledNameHash());
    ASSERT_EQ(0x000001cdu, ImmutableString("texture(00f30B").mangledNameHash());
    ASSERT_EQ(0x00000825u, ImmutableString("texture(00g00B").mangledNameHash());
    ASSERT_EQ(0x0000023eu, ImmutableString("texture(00o00B").mangledNameHash());
    ASSERT_EQ(0x00000090u, ImmutableString("texture(00t00B").mangledNameHash());
    ASSERT_EQ(0x00000815u, ImmutableString("texture(00m20B").mangledNameHash());
    ASSERT_EQ(0x000000b9u, ImmutableString("texture(00h20B").mangledNameHash());
    ASSERT_EQ(0x000000dfu, ImmutableString("texture(00p20B").mangledNameHash());
    ASSERT_EQ(0x0000045du, ImmutableString("texture(00u20B").mangledNameHash());
    ASSERT_EQ(0x000002efu, ImmutableString("texture(00i20B").mangledNameHash());
    ASSERT_EQ(0x000003cau, ImmutableString("texture(00q10B").mangledNameHash());
    ASSERT_EQ(0x0000054fu, ImmutableString("texture(00v10B").mangledNameHash());
    ASSERT_EQ(0x00000225u, ImmutableString("texture(00n20B").mangledNameHash());
    ASSERT_EQ(0x00000668u, ImmutableString("texture(00l30B00B").mangledNameHash());
    ASSERT_EQ(0x00000252u, ImmutableString("textureProj(00I20B").mangledNameHash());
    ASSERT_EQ(0x00000201u, ImmutableString("textureProj(00R20B").mangledNameHash());
    ASSERT_EQ(0x000002bau, ImmutableString("textureProj(00X20B").mangledNameHash());
    ASSERT_EQ(0x000002eau, ImmutableString("textureProj(00I30B").mangledNameHash());
    ASSERT_EQ(0x00000833u, ImmutableString("textureProj(00R30B").mangledNameHash());
    ASSERT_EQ(0x0000083eu, ImmutableString("textureProj(00X30B").mangledNameHash());
    ASSERT_EQ(0x000002ceu, ImmutableString("textureProj(00J30B").mangledNameHash());
    ASSERT_EQ(0x00000197u, ImmutableString("textureProj(00S30B").mangledNameHash());
    ASSERT_EQ(0x000000ecu, ImmutableString("textureProj(00Y30B").mangledNameHash());
    ASSERT_EQ(0x000007fcu, ImmutableString("textureProj(00d30B").mangledNameHash());
    ASSERT_EQ(0x000002e5u, ImmutableString("textureProj(00g10B").mangledNameHash());
    ASSERT_EQ(0x00000647u, ImmutableString("textureProj(00o10B").mangledNameHash());
    ASSERT_EQ(0x0000005du, ImmutableString("textureProj(00t10B").mangledNameHash());
    ASSERT_EQ(0x000007d5u, ImmutableString("textureProj(00g30B").mangledNameHash());
    ASSERT_EQ(0x0000011bu, ImmutableString("textureProj(00o30B").mangledNameHash());
    ASSERT_EQ(0x00000771u, ImmutableString("textureProj(00t30B").mangledNameHash());
    ASSERT_EQ(0x000000f6u, ImmutableString("textureProj(00m30B").mangledNameHash());
    ASSERT_EQ(0x000004fdu, ImmutableString("textureProj(00q20B").mangledNameHash());
    ASSERT_EQ(0x00000699u, ImmutableString("textureProj(00v20B").mangledNameHash());
    ASSERT_EQ(0x0000059du, ImmutableString("textureProj(00q30B").mangledNameHash());
    ASSERT_EQ(0x000005feu, ImmutableString("textureProj(00v30B").mangledNameHash());
    ASSERT_EQ(0x000000ddu, ImmutableString("textureProj(00n30B").mangledNameHash());
    ASSERT_EQ(0x000000cdu, ImmutableString("textureLod(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x0000036du, ImmutableString("textureLod(00R10B00B").mangledNameHash());
    ASSERT_EQ(0x000000beu, ImmutableString("textureLod(00X10B00B").mangledNameHash());
    ASSERT_EQ(0x00000493u, ImmutableString("textureLod(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x000003b9u, ImmutableString("textureLod(00S20B00B").mangledNameHash());
    ASSERT_EQ(0x00000675u, ImmutableString("textureLod(00Y20B00B").mangledNameHash());
    ASSERT_EQ(0x00000525u, ImmutableString("textureLod(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000006dfu, ImmutableString("textureLod(00T20B00B").mangledNameHash());
    ASSERT_EQ(0x000005bcu, ImmutableString("textureLod(00Z20B00B").mangledNameHash());
    ASSERT_EQ(0x0000021fu, ImmutableString("textureLod(00L20B00B").mangledNameHash());
    ASSERT_EQ(0x000001f2u, ImmutableString("textureLod(00U20B00B").mangledNameHash());
    ASSERT_EQ(0x00000355u, ImmutableString("textureLod(00a20B00B").mangledNameHash());
    ASSERT_EQ(0x0000070cu, ImmutableString("textureLod(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x00000565u, ImmutableString("textureLod(00g00B00B").mangledNameHash());
    ASSERT_EQ(0x000007cbu, ImmutableString("textureLod(00o00B00B").mangledNameHash());
    ASSERT_EQ(0x00000012u, ImmutableString("textureLod(00t00B00B").mangledNameHash());
    ASSERT_EQ(0x0000031eu, ImmutableString("textureLod(00m20B00B").mangledNameHash());
    ASSERT_EQ(0x0000071fu, ImmutableString("textureLod(00h10B00B").mangledNameHash());
    ASSERT_EQ(0x000001f6u, ImmutableString("textureLod(00p10B00B").mangledNameHash());
    ASSERT_EQ(0x0000055au, ImmutableString("textureLod(00u10B00B").mangledNameHash());
    ASSERT_EQ(0x00000153u, ImmutableString("textureLod(00i20B00B").mangledNameHash());
    ASSERT_EQ(0x00000718u, ImmutableString("textureLod(00k30B00B").mangledNameHash());
    ASSERT_EQ(0x000002f2u, ImmutableString("textureLod(00s30B00B").mangledNameHash());
    ASSERT_EQ(0x00000783u, ImmutableString("textureLod(00x30B00B").mangledNameHash());
    ASSERT_EQ(0x00000497u, ImmutableString("textureSize(00I00D").mangledNameHash());
    ASSERT_EQ(0x000006b2u, ImmutableString("textureSize(00R00D").mangledNameHash());
    ASSERT_EQ(0x00000410u, ImmutableString("textureSize(00X00D").mangledNameHash());
    ASSERT_EQ(0x0000072cu, ImmutableString("textureSize(00J00D").mangledNameHash());
    ASSERT_EQ(0x000001c4u, ImmutableString("textureSize(00S00D").mangledNameHash());
    ASSERT_EQ(0x00000548u, ImmutableString("textureSize(00Y00D").mangledNameHash());
    ASSERT_EQ(0x0000001fu, ImmutableString("textureSize(00K00D").mangledNameHash());
    ASSERT_EQ(0x000001e1u, ImmutableString("textureSize(00T00D").mangledNameHash());
    ASSERT_EQ(0x000007e4u, ImmutableString("textureSize(00Z00D").mangledNameHash());
    ASSERT_EQ(0x00000193u, ImmutableString("textureSize(00L00D").mangledNameHash());
    ASSERT_EQ(0x0000052eu, ImmutableString("textureSize(00U00D").mangledNameHash());
    ASSERT_EQ(0x000001bcu, ImmutableString("textureSize(00a00D").mangledNameHash());
    ASSERT_EQ(0x00000615u, ImmutableString("textureSize(00d00D").mangledNameHash());
    ASSERT_EQ(0x000000feu, ImmutableString("textureSize(00e00D").mangledNameHash());
    ASSERT_EQ(0x000001a5u, ImmutableString("textureSize(00f00D").mangledNameHash());
    ASSERT_EQ(0x000004e6u, ImmutableString("textureSize(00g00D").mangledNameHash());
    ASSERT_EQ(0x00000472u, ImmutableString("textureSize(00o00D").mangledNameHash());
    ASSERT_EQ(0x000001ccu, ImmutableString("textureSize(00t00D").mangledNameHash());
    ASSERT_EQ(0x000002a1u, ImmutableString("textureSize(00m00D").mangledNameHash());
    ASSERT_EQ(0x00000501u, ImmutableString("textureSize(00k00D").mangledNameHash());
    ASSERT_EQ(0x00000656u, ImmutableString("textureSize(00s00D").mangledNameHash());
    ASSERT_EQ(0x00000179u, ImmutableString("textureSize(00x00D").mangledNameHash());
    ASSERT_EQ(0x000007cau, ImmutableString("textureSize(00l00D").mangledNameHash());
    ASSERT_EQ(0x00000790u, ImmutableString("textureSize(00O").mangledNameHash());
    ASSERT_EQ(0x0000078au, ImmutableString("textureSize(00q").mangledNameHash());
    ASSERT_EQ(0x0000078du, ImmutableString("textureSize(00v").mangledNameHash());
    ASSERT_EQ(0x00000785u, ImmutableString("textureSize(00n").mangledNameHash());
    ASSERT_EQ(0x00000020u, ImmutableString("textureSize(00h00D").mangledNameHash());
    ASSERT_EQ(0x00000031u, ImmutableString("textureSize(00p00D").mangledNameHash());
    ASSERT_EQ(0x000001e3u, ImmutableString("textureSize(00u00D").mangledNameHash());
    ASSERT_EQ(0x0000013du, ImmutableString("textureSize(00i00D").mangledNameHash());
    ASSERT_EQ(0x00000784u, ImmutableString("textureSize(00j").mangledNameHash());
    ASSERT_EQ(0x0000078bu, ImmutableString("textureSize(00r").mangledNameHash());
    ASSERT_EQ(0x0000078cu, ImmutableString("textureSize(00w").mangledNameHash());
    ASSERT_EQ(0x0000069bu, ImmutableString("textureProjLod(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000004a4u, ImmutableString("textureProjLod(00R20B00B").mangledNameHash());
    ASSERT_EQ(0x0000079au, ImmutableString("textureProjLod(00X20B00B").mangledNameHash());
    ASSERT_EQ(0x000000f8u, ImmutableString("textureProjLod(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x0000031au, ImmutableString("textureProjLod(00R30B00B").mangledNameHash());
    ASSERT_EQ(0x00000599u, ImmutableString("textureProjLod(00X30B00B").mangledNameHash());
    ASSERT_EQ(0x000006b9u, ImmutableString("textureProjLod(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x000003dcu, ImmutableString("textureProjLod(00S30B00B").mangledNameHash());
    ASSERT_EQ(0x000001aeu, ImmutableString("textureProjLod(00Y30B00B").mangledNameHash());
    ASSERT_EQ(0x00000291u, ImmutableString("textureProjLod(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x0000081fu, ImmutableString("textureProjLod(00g10B00B").mangledNameHash());
    ASSERT_EQ(0x0000017cu, ImmutableString("textureProjLod(00o10B00B").mangledNameHash());
    ASSERT_EQ(0x000004feu, ImmutableString("textureProjLod(00t10B00B").mangledNameHash());
    ASSERT_EQ(0x000004f2u, ImmutableString("textureProjLod(00g30B00B").mangledNameHash());
    ASSERT_EQ(0x000006edu, ImmutableString("textureProjLod(00o30B00B").mangledNameHash());
    ASSERT_EQ(0x000005d2u, ImmutableString("textureProjLod(00t30B00B").mangledNameHash());
    ASSERT_EQ(0x000003f7u, ImmutableString("textureProjLod(00m30B00B").mangledNameHash());
    ASSERT_EQ(0x00000046u, ImmutableString("texelFetch(00I10D00D").mangledNameHash());
    ASSERT_EQ(0x000001cfu, ImmutableString("texelFetch(00R10D00D").mangledNameHash());
    ASSERT_EQ(0x000003a4u, ImmutableString("texelFetch(00X10D00D").mangledNameHash());
    ASSERT_EQ(0x0000020bu, ImmutableString("texelFetch(00J20D00D").mangledNameHash());
    ASSERT_EQ(0x000007b2u, ImmutableString("texelFetch(00S20D00D").mangledNameHash());
    ASSERT_EQ(0x000000e3u, ImmutableString("texelFetch(00Y20D00D").mangledNameHash());
    ASSERT_EQ(0x00000528u, ImmutableString("texelFetch(00L20D00D").mangledNameHash());
    ASSERT_EQ(0x000002d3u, ImmutableString("texelFetch(00U20D00D").mangledNameHash());
    ASSERT_EQ(0x00000101u, ImmutableString("texelFetch(00a20D00D").mangledNameHash());
    ASSERT_EQ(0x000005e5u, ImmutableString("texelFetch(00g00D00D").mangledNameHash());
    ASSERT_EQ(0x00000007u, ImmutableString("texelFetch(00o00D00D").mangledNameHash());
    ASSERT_EQ(0x0000030au, ImmutableString("texelFetch(00t00D00D").mangledNameHash());
    ASSERT_EQ(0x000007a5u, ImmutableString("texelFetch(00O10D").mangledNameHash());
    ASSERT_EQ(0x0000031cu, ImmutableString("texelFetch(00q10D").mangledNameHash());
    ASSERT_EQ(0x000001dfu, ImmutableString("texelFetch(00v10D").mangledNameHash());
    ASSERT_EQ(0x00000690u, ImmutableString("texelFetch(00h10D00D").mangledNameHash());
    ASSERT_EQ(0x000007ebu, ImmutableString("texelFetch(00p10D00D").mangledNameHash());
    ASSERT_EQ(0x0000063bu, ImmutableString("texelFetch(00u10D00D").mangledNameHash());
    ASSERT_EQ(0x00000071u, ImmutableString("texelFetch(00j00D").mangledNameHash());
    ASSERT_EQ(0x0000039du, ImmutableString("texelFetch(00r00D").mangledNameHash());
    ASSERT_EQ(0x0000014cu, ImmutableString("texelFetch(00w00D").mangledNameHash());
    ASSERT_EQ(0x00000442u, ImmutableString("textureGrad(00I10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001d3u, ImmutableString("textureGrad(00R10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000159u, ImmutableString("textureGrad(00X10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000073du, ImmutableString("textureGrad(00J20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000006e7u, ImmutableString("textureGrad(00S20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000002b2u, ImmutableString("textureGrad(00Y20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000007b1u, ImmutableString("textureGrad(00K20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000001e6u, ImmutableString("textureGrad(00T20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000000c8u, ImmutableString("textureGrad(00Z20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000002b1u, ImmutableString("textureGrad(00I00B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000040eu, ImmutableString("textureGrad(00R00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000068u, ImmutableString("textureGrad(00X00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000494u, ImmutableString("textureGrad(00O10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000005aau, ImmutableString("textureGrad(00q10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000006bu, ImmutableString("textureGrad(00v10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000002d7u, ImmutableString("textureGrad(00n20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000695u, ImmutableString("textureGrad(00d20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000072bu, ImmutableString("textureGrad(00e30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000470u, ImmutableString("textureGrad(00L20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000329u, ImmutableString("textureGrad(00U20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000002feu, ImmutableString("textureGrad(00a20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000057fu, ImmutableString("textureGrad(00f30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000006c8u, ImmutableString("textureGrad(00m20B00B00B").mangledNameHash());
    ASSERT_EQ(0x000005ccu, ImmutableString("textureGrad(00h10B00B00B").mangledNameHash());
    ASSERT_EQ(0x000007bcu, ImmutableString("textureGrad(00p10B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000484u, ImmutableString("textureGrad(00u10B00B00B").mangledNameHash());
    ASSERT_EQ(0x000002e4u, ImmutableString("textureGrad(00i20B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000056bu, ImmutableString("textureGrad(00k30B20B20B").mangledNameHash());
    ASSERT_EQ(0x000007a8u, ImmutableString("textureGrad(00s30B20B20B").mangledNameHash());
    ASSERT_EQ(0x000006ebu, ImmutableString("textureGrad(00x30B20B20B").mangledNameHash());
    ASSERT_EQ(0x000003e5u, ImmutableString("textureProjGrad(00I20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000003ddu, ImmutableString("textureProjGrad(00R20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000546u, ImmutableString("textureProjGrad(00X20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000065cu, ImmutableString("textureProjGrad(00I30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000006e0u, ImmutableString("textureProjGrad(00R30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000214u, ImmutableString("textureProjGrad(00X30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000000bau, ImmutableString("textureProjGrad(00J30B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000003eu, ImmutableString("textureProjGrad(00S30B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000022bu, ImmutableString("textureProjGrad(00Y30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000307u, ImmutableString("textureProjGrad(00d30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000002c5u, ImmutableString("textureProjGrad(00g10B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000347u, ImmutableString("textureProjGrad(00o10B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000062du, ImmutableString("textureProjGrad(00t10B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000641u, ImmutableString("textureProjGrad(00g30B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000474u, ImmutableString("textureProjGrad(00o30B00B00B").mangledNameHash());
    ASSERT_EQ(0x000000acu, ImmutableString("textureProjGrad(00t30B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000490u, ImmutableString("textureProjGrad(00m30B00B00B").mangledNameHash());
    ASSERT_EQ(0x000005ffu, ImmutableString("textureProjGrad(00O20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000035du, ImmutableString("textureProjGrad(00q20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000003dbu, ImmutableString("textureProjGrad(00v20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000007f5u, ImmutableString("textureProjGrad(00O30B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000021bu, ImmutableString("textureProjGrad(00q30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000320u, ImmutableString("textureProjGrad(00v30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000731u, ImmutableString("textureProjGrad(00n30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000004b1u, ImmutableString("textureQueryLevels(00g").mangledNameHash());
    ASSERT_EQ(0x000004aau, ImmutableString("textureQueryLevels(00o").mangledNameHash());
    ASSERT_EQ(0x000004b8u, ImmutableString("textureQueryLevels(00t").mangledNameHash());
    ASSERT_EQ(0x000004c0u, ImmutableString("textureQueryLevels(00I").mangledNameHash());
    ASSERT_EQ(0x000004ccu, ImmutableString("textureQueryLevels(00R").mangledNameHash());
    ASSERT_EQ(0x000004c6u, ImmutableString("textureQueryLevels(00X").mangledNameHash());
    ASSERT_EQ(0x000004c1u, ImmutableString("textureQueryLevels(00J").mangledNameHash());
    ASSERT_EQ(0x000004cdu, ImmutableString("textureQueryLevels(00S").mangledNameHash());
    ASSERT_EQ(0x000004c7u, ImmutableString("textureQueryLevels(00Y").mangledNameHash());
    ASSERT_EQ(0x000004c2u, ImmutableString("textureQueryLevels(00K").mangledNameHash());
    ASSERT_EQ(0x000004cau, ImmutableString("textureQueryLevels(00T").mangledNameHash());
    ASSERT_EQ(0x000004c8u, ImmutableString("textureQueryLevels(00Z").mangledNameHash());
    ASSERT_EQ(0x000004abu, ImmutableString("textureQueryLevels(00h").mangledNameHash());
    ASSERT_EQ(0x00000333u, ImmutableString("textureQueryLevels(00p").mangledNameHash());
    ASSERT_EQ(0x000004b9u, ImmutableString("textureQueryLevels(00u").mangledNameHash());
    ASSERT_EQ(0x000004bfu, ImmutableString("textureQueryLevels(00L").mangledNameHash());
    ASSERT_EQ(0x000004cbu, ImmutableString("textureQueryLevels(00U").mangledNameHash());
    ASSERT_EQ(0x000004b3u, ImmutableString("textureQueryLevels(00a").mangledNameHash());
    ASSERT_EQ(0x000004adu, ImmutableString("textureQueryLevels(00k").mangledNameHash());
    ASSERT_EQ(0x000004beu, ImmutableString("textureQueryLevels(00s").mangledNameHash());
    ASSERT_EQ(0x000004b7u, ImmutableString("textureQueryLevels(00x").mangledNameHash());
    ASSERT_EQ(0x000004a9u, ImmutableString("textureQueryLevels(00m").mangledNameHash());
    ASSERT_EQ(0x000004aeu, ImmutableString("textureQueryLevels(00d").mangledNameHash());
    ASSERT_EQ(0x000004afu, ImmutableString("textureQueryLevels(00e").mangledNameHash());
    ASSERT_EQ(0x000004acu, ImmutableString("textureQueryLevels(00i").mangledNameHash());
    ASSERT_EQ(0x000004b0u, ImmutableString("textureQueryLevels(00f").mangledNameHash());
    ASSERT_EQ(0x000004a8u, ImmutableString("textureQueryLevels(00l").mangledNameHash());
    ASSERT_EQ(0x00000215u, ImmutableString("textureSamples(00P").mangledNameHash());
    ASSERT_EQ(0x00000219u, ImmutableString("textureSamples(00V").mangledNameHash());
    ASSERT_EQ(0x00000209u, ImmutableString("textureSamples(00b").mangledNameHash());
    ASSERT_EQ(0x0000041du, ImmutableString("textureSamples(00Q").mangledNameHash());
    ASSERT_EQ(0x0000021au, ImmutableString("textureSamples(00W").mangledNameHash());
    ASSERT_EQ(0x000003ccu, ImmutableString("textureSamples(00c").mangledNameHash());
    ASSERT_EQ(0x00000796u, ImmutableString("textureSize(00P").mangledNameHash());
    ASSERT_EQ(0x00000383u, ImmutableString("textureSize(00V").mangledNameHash());
    ASSERT_EQ(0x00000788u, ImmutableString("textureSize(00b").mangledNameHash());
    ASSERT_EQ(0x00000795u, ImmutableString("textureSize(00Q").mangledNameHash());
    ASSERT_EQ(0x00000799u, ImmutableString("textureSize(00W").mangledNameHash());
    ASSERT_EQ(0x00000787u, ImmutableString("textureSize(00c").mangledNameHash());
    ASSERT_EQ(0x00000478u, ImmutableString("texelFetch(00P10D00D").mangledNameHash());
    ASSERT_EQ(0x000004ebu, ImmutableString("texelFetch(00V10D00D").mangledNameHash());
    ASSERT_EQ(0x00000447u, ImmutableString("texelFetch(00b10D00D").mangledNameHash());
    ASSERT_EQ(0x000005d7u, ImmutableString("texelFetch(00Q20D00D").mangledNameHash());
    ASSERT_EQ(0x0000081eu, ImmutableString("texelFetch(00W20D00D").mangledNameHash());
    ASSERT_EQ(0x00000317u, ImmutableString("texelFetch(00c20D00D").mangledNameHash());
    ASSERT_EQ(0x00000070u, ImmutableString("texture(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x0000042cu, ImmutableString("texture(00R10B00B").mangledNameHash());
    ASSERT_EQ(0x00000273u, ImmutableString("texture(00X10B00B").mangledNameHash());
    ASSERT_EQ(0x00000301u, ImmutableString("texture(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x00000674u, ImmutableString("texture(00S20B00B").mangledNameHash());
    ASSERT_EQ(0x000000eau, ImmutableString("texture(00Y20B00B").mangledNameHash());
    ASSERT_EQ(0x0000073bu, ImmutableString("texture(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x0000049du, ImmutableString("texture(00T20B00B").mangledNameHash());
    ASSERT_EQ(0x000001dbu, ImmutableString("texture(00Z20B00B").mangledNameHash());
    ASSERT_EQ(0x0000011eu, ImmutableString("texture(00L20B00B").mangledNameHash());
    ASSERT_EQ(0x000002e9u, ImmutableString("texture(00U20B00B").mangledNameHash());
    ASSERT_EQ(0x00000646u, ImmutableString("texture(00a20B00B").mangledNameHash());
    ASSERT_EQ(0x00000398u, ImmutableString("textureProj(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000005b0u, ImmutableString("textureProj(00R20B00B").mangledNameHash());
    ASSERT_EQ(0x0000038au, ImmutableString("textureProj(00X20B00B").mangledNameHash());
    ASSERT_EQ(0x00000364u, ImmutableString("textureProj(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000000u, ImmutableString("textureProj(00R30B00B").mangledNameHash());
    ASSERT_EQ(0x0000077fu, ImmutableString("textureProj(00X30B00B").mangledNameHash());
    ASSERT_EQ(0x00000448u, ImmutableString("textureProj(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x0000017au, ImmutableString("textureProj(00S30B00B").mangledNameHash());
    ASSERT_EQ(0x0000053eu, ImmutableString("textureProj(00Y30B00B").mangledNameHash());
    ASSERT_EQ(0x0000057au, ImmutableString("texture(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x0000047eu, ImmutableString("texture(00e30B00B").mangledNameHash());
    ASSERT_EQ(0x00000643u, ImmutableString("textureProj(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x00000711u, ImmutableString("texture(00g00B00B").mangledNameHash());
    ASSERT_EQ(0x0000084eu, ImmutableString("texture(00o00B00B").mangledNameHash());
    ASSERT_EQ(0x00000105u, ImmutableString("texture(00t00B00B").mangledNameHash());
    ASSERT_EQ(0x0000018eu, ImmutableString("texture(00m20B00B").mangledNameHash());
    ASSERT_EQ(0x0000018cu, ImmutableString("texture(00h20B00B").mangledNameHash());
    ASSERT_EQ(0x0000005eu, ImmutableString("texture(00p20B00B").mangledNameHash());
    ASSERT_EQ(0x00000636u, ImmutableString("texture(00u20B00B").mangledNameHash());
    ASSERT_EQ(0x0000025fu, ImmutableString("texture(00i20B00B").mangledNameHash());
    ASSERT_EQ(0x00000835u, ImmutableString("texture(00f30B00B").mangledNameHash());
    ASSERT_EQ(0x00000052u, ImmutableString("textureProj(00g10B00B").mangledNameHash());
    ASSERT_EQ(0x0000061eu, ImmutableString("textureProj(00o10B00B").mangledNameHash());
    ASSERT_EQ(0x000001d5u, ImmutableString("textureProj(00t10B00B").mangledNameHash());
    ASSERT_EQ(0x00000560u, ImmutableString("textureProj(00g30B00B").mangledNameHash());
    ASSERT_EQ(0x00000190u, ImmutableString("textureProj(00o30B00B").mangledNameHash());
    ASSERT_EQ(0x000004d0u, ImmutableString("textureProj(00t30B00B").mangledNameHash());
    ASSERT_EQ(0x000007c7u, ImmutableString("textureProj(00m30B00B").mangledNameHash());
    ASSERT_EQ(0x00000847u, ImmutableString("texture(00M10B00B").mangledNameHash());
    ASSERT_EQ(0x00000649u, ImmutableString("textureProj(00M20B00B").mangledNameHash());
    ASSERT_EQ(0x0000043eu, ImmutableString("textureProj(00M30B00B").mangledNameHash());
    ASSERT_EQ(0x00000659u, ImmutableString("texture(00N10B00B").mangledNameHash());
    ASSERT_EQ(0x000007f8u, ImmutableString("textureProj(00N20B00B").mangledNameHash());
    ASSERT_EQ(0x0000006cu, ImmutableString("textureProj(00N30B00B").mangledNameHash());
    ASSERT_EQ(0x000003abu, ImmutableString("textureQueryLod(00g00B").mangledNameHash());
    ASSERT_EQ(0x00000486u, ImmutableString("textureQueryLod(00o00B").mangledNameHash());
    ASSERT_EQ(0x0000083cu, ImmutableString("textureQueryLod(00t00B").mangledNameHash());
    ASSERT_EQ(0x000003efu, ImmutableString("textureQueryLod(00I10B").mangledNameHash());
    ASSERT_EQ(0x0000033du, ImmutableString("textureQueryLod(00R10B").mangledNameHash());
    ASSERT_EQ(0x00000759u, ImmutableString("textureQueryLod(00X10B").mangledNameHash());
    ASSERT_EQ(0x000005dfu, ImmutableString("textureQueryLod(00J20B").mangledNameHash());
    ASSERT_EQ(0x00000776u, ImmutableString("textureQueryLod(00S20B").mangledNameHash());
    ASSERT_EQ(0x000006acu, ImmutableString("textureQueryLod(00Y20B").mangledNameHash());
    ASSERT_EQ(0x00000462u, ImmutableString("textureQueryLod(00K20B").mangledNameHash());
    ASSERT_EQ(0x00000140u, ImmutableString("textureQueryLod(00T20B").mangledNameHash());
    ASSERT_EQ(0x0000072du, ImmutableString("textureQueryLod(00Z20B").mangledNameHash());
    ASSERT_EQ(0x000005cfu, ImmutableString("textureQueryLod(00h00B").mangledNameHash());
    ASSERT_EQ(0x00000092u, ImmutableString("textureQueryLod(00p00B").mangledNameHash());
    ASSERT_EQ(0x00000679u, ImmutableString("textureQueryLod(00u00B").mangledNameHash());
    ASSERT_EQ(0x000006c5u, ImmutableString("textureQueryLod(00L10B").mangledNameHash());
    ASSERT_EQ(0x00000683u, ImmutableString("textureQueryLod(00U10B").mangledNameHash());
    ASSERT_EQ(0x000000c5u, ImmutableString("textureQueryLod(00a10B").mangledNameHash());
    ASSERT_EQ(0x000001acu, ImmutableString("textureQueryLod(00k20B").mangledNameHash());
    ASSERT_EQ(0x0000054eu, ImmutableString("textureQueryLod(00s20B").mangledNameHash());
    ASSERT_EQ(0x00000555u, ImmutableString("textureQueryLod(00x20B").mangledNameHash());
    ASSERT_EQ(0x0000000du, ImmutableString("textureQueryLod(00m00B").mangledNameHash());
    ASSERT_EQ(0x000001bau, ImmutableString("textureQueryLod(00d10B").mangledNameHash());
    ASSERT_EQ(0x000002a4u, ImmutableString("textureQueryLod(00e20B").mangledNameHash());
    ASSERT_EQ(0x000000deu, ImmutableString("textureQueryLod(00i00B").mangledNameHash());
    ASSERT_EQ(0x00000241u, ImmutableString("textureQueryLod(00f10B").mangledNameHash());
    ASSERT_EQ(0x000003d8u, ImmutableString("textureQueryLod(00l20B").mangledNameHash());
    ASSERT_EQ(0x00000281u, ImmutableString("textureOffset(00I10B10D").mangledNameHash());
    ASSERT_EQ(0x0000035cu, ImmutableString("textureOffset(00R10B10D").mangledNameHash());
    ASSERT_EQ(0x00000164u, ImmutableString("textureOffset(00X10B10D").mangledNameHash());
    ASSERT_EQ(0x0000020au, ImmutableString("textureOffset(00J20B20D").mangledNameHash());
    ASSERT_EQ(0x000001ffu, ImmutableString("textureOffset(00S20B20D").mangledNameHash());
    ASSERT_EQ(0x000005beu, ImmutableString("textureOffset(00Y20B20D").mangledNameHash());
    ASSERT_EQ(0x0000065eu, ImmutableString("textureOffset(00d20B10D").mangledNameHash());
    ASSERT_EQ(0x0000007bu, ImmutableString("textureOffset(00L20B10D").mangledNameHash());
    ASSERT_EQ(0x00000467u, ImmutableString("textureOffset(00U20B10D").mangledNameHash());
    ASSERT_EQ(0x00000755u, ImmutableString("textureOffset(00a20B10D").mangledNameHash());
    ASSERT_EQ(0x000007d4u, ImmutableString("textureOffset(00g00B00D").mangledNameHash());
    ASSERT_EQ(0x000005d3u, ImmutableString("textureOffset(00o00B00D").mangledNameHash());
    ASSERT_EQ(0x00000429u, ImmutableString("textureOffset(00t00B00D").mangledNameHash());
    ASSERT_EQ(0x000003e4u, ImmutableString("textureOffset(00O10B10D").mangledNameHash());
    ASSERT_EQ(0x0000070du, ImmutableString("textureOffset(00q10B10D").mangledNameHash());
    ASSERT_EQ(0x0000029cu, ImmutableString("textureOffset(00v10B10D").mangledNameHash());
    ASSERT_EQ(0x0000046bu, ImmutableString("textureOffset(00n20B10D").mangledNameHash());
    ASSERT_EQ(0x00000064u, ImmutableString("textureOffset(00m20B00D").mangledNameHash());
    ASSERT_EQ(0x000001f5u, ImmutableString("textureOffset(00h10B00D").mangledNameHash());
    ASSERT_EQ(0x000000b8u, ImmutableString("textureOffset(00p10B00D").mangledNameHash());
    ASSERT_EQ(0x00000801u, ImmutableString("textureOffset(00u10B00D").mangledNameHash());
    ASSERT_EQ(0x00000353u, ImmutableString("textureOffset(00i20B00D").mangledNameHash());
    ASSERT_EQ(0x0000076au, ImmutableString("textureOffset(00f30B10D").mangledNameHash());
    ASSERT_EQ(0x000004a7u, ImmutableString("textureProjOffset(00I20B10D").mangledNameHash());
    ASSERT_EQ(0x0000027eu, ImmutableString("textureProjOffset(00R20B10D").mangledNameHash());
    ASSERT_EQ(0x0000015fu, ImmutableString("textureProjOffset(00X20B10D").mangledNameHash());
    ASSERT_EQ(0x00000163u, ImmutableString("textureProjOffset(00I30B10D").mangledNameHash());
    ASSERT_EQ(0x0000083du, ImmutableString("textureProjOffset(00R30B10D").mangledNameHash());
    ASSERT_EQ(0x000005e0u, ImmutableString("textureProjOffset(00X30B10D").mangledNameHash());
    ASSERT_EQ(0x00000628u, ImmutableString("textureProjOffset(00J30B20D").mangledNameHash());
    ASSERT_EQ(0x00000080u, ImmutableString("textureProjOffset(00S30B20D").mangledNameHash());
    ASSERT_EQ(0x000001beu, ImmutableString("textureProjOffset(00Y30B20D").mangledNameHash());
    ASSERT_EQ(0x00000400u, ImmutableString("textureProjOffset(00d30B10D").mangledNameHash());
    ASSERT_EQ(0x00000003u, ImmutableString("textureProjOffset(00g10B00D").mangledNameHash());
    ASSERT_EQ(0x0000056cu, ImmutableString("textureProjOffset(00o10B00D").mangledNameHash());
    ASSERT_EQ(0x00000729u, ImmutableString("textureProjOffset(00t10B00D").mangledNameHash());
    ASSERT_EQ(0x00000810u, ImmutableString("textureProjOffset(00g30B00D").mangledNameHash());
    ASSERT_EQ(0x0000043cu, ImmutableString("textureProjOffset(00o30B00D").mangledNameHash());
    ASSERT_EQ(0x00000713u, ImmutableString("textureProjOffset(00t30B00D").mangledNameHash());
    ASSERT_EQ(0x000006d5u, ImmutableString("textureProjOffset(00O20B10D").mangledNameHash());
    ASSERT_EQ(0x000002eeu, ImmutableString("textureProjOffset(00q20B10D").mangledNameHash());
    ASSERT_EQ(0x00000216u, ImmutableString("textureProjOffset(00v20B10D").mangledNameHash());
    ASSERT_EQ(0x00000125u, ImmutableString("textureProjOffset(00O30B10D").mangledNameHash());
    ASSERT_EQ(0x0000007au, ImmutableString("textureProjOffset(00q30B10D").mangledNameHash());
    ASSERT_EQ(0x000007bdu, ImmutableString("textureProjOffset(00v30B10D").mangledNameHash());
    ASSERT_EQ(0x000002bbu, ImmutableString("textureProjOffset(00n30B10D").mangledNameHash());
    ASSERT_EQ(0x00000621u, ImmutableString("textureProjOffset(00m30B00D").mangledNameHash());
    ASSERT_EQ(0x00000463u, ImmutableString("textureLodOffset(00I10B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000637u, ImmutableString("textureLodOffset(00R10B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000049cu, ImmutableString("textureLodOffset(00X10B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000034fu, ImmutableString("textureLodOffset(00J20B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000091u, ImmutableString("textureLodOffset(00S20B00B20D").mangledNameHash());
    ASSERT_EQ(0x0000071au, ImmutableString("textureLodOffset(00Y20B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000544u, ImmutableString("textureLodOffset(00d20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000826u, ImmutableString("textureLodOffset(00L20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000407u, ImmutableString("textureLodOffset(00U20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000029u, ImmutableString("textureLodOffset(00a20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000175u, ImmutableString("textureLodOffset(00g00B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000001cu, ImmutableString("textureLodOffset(00o00B00B00D").mangledNameHash());
    ASSERT_EQ(0x000002d1u, ImmutableString("textureLodOffset(00t00B00B00D").mangledNameHash());
    ASSERT_EQ(0x000007e9u, ImmutableString("textureLodOffset(00m20B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000026eu, ImmutableString("textureLodOffset(00h10B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000253u, ImmutableString("textureLodOffset(00p10B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000827u, ImmutableString("textureLodOffset(00u10B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000436u, ImmutableString("textureLodOffset(00i20B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000819u, ImmutableString("textureProjLodOffset(00I20B00B10D").mangledNameHash());
    ASSERT_EQ(0x000000b7u, ImmutableString("textureProjLodOffset(00R20B00B10D").mangledNameHash());
    ASSERT_EQ(0x000002e7u, ImmutableString("textureProjLodOffset(00X20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000060bu, ImmutableString("textureProjLodOffset(00I30B00B10D").mangledNameHash());
    ASSERT_EQ(0x000005cbu, ImmutableString("textureProjLodOffset(00R30B00B10D").mangledNameHash());
    ASSERT_EQ(0x000003f5u, ImmutableString("textureProjLodOffset(00X30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000311u, ImmutableString("textureProjLodOffset(00J30B00B20D").mangledNameHash());
    ASSERT_EQ(0x000000dbu, ImmutableString("textureProjLodOffset(00S30B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000743u, ImmutableString("textureProjLodOffset(00Y30B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000608u, ImmutableString("textureProjLodOffset(00d30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000553u, ImmutableString("textureProjLodOffset(00g10B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000012au, ImmutableString("textureProjLodOffset(00o10B00B00D").mangledNameHash());
    ASSERT_EQ(0x000006d4u, ImmutableString("textureProjLodOffset(00t10B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000148u, ImmutableString("textureProjLodOffset(00g30B00B00D").mangledNameHash());
    ASSERT_EQ(0x000005aeu, ImmutableString("textureProjLodOffset(00o30B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000069u, ImmutableString("textureProjLodOffset(00t30B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000831u, ImmutableString("textureProjLodOffset(00m30B00B00D").mangledNameHash());
    ASSERT_EQ(0x000006c0u, ImmutableString("texelFetchOffset(00I10D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000499u, ImmutableString("texelFetchOffset(00R10D00D10D").mangledNameHash());
    ASSERT_EQ(0x0000018au, ImmutableString("texelFetchOffset(00X10D00D10D").mangledNameHash());
    ASSERT_EQ(0x0000003du, ImmutableString("texelFetchOffset(00J20D00D20D").mangledNameHash());
    ASSERT_EQ(0x000004e4u, ImmutableString("texelFetchOffset(00S20D00D20D").mangledNameHash());
    ASSERT_EQ(0x00000239u, ImmutableString("texelFetchOffset(00Y20D00D20D").mangledNameHash());
    ASSERT_EQ(0x000007b5u, ImmutableString("texelFetchOffset(00L20D00D10D").mangledNameHash());
    ASSERT_EQ(0x000003f9u, ImmutableString("texelFetchOffset(00U20D00D10D").mangledNameHash());
    ASSERT_EQ(0x000000afu, ImmutableString("texelFetchOffset(00a20D00D10D").mangledNameHash());
    ASSERT_EQ(0x000007c0u, ImmutableString("texelFetchOffset(00g00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000218u, ImmutableString("texelFetchOffset(00o00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000576u, ImmutableString("texelFetchOffset(00t00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000005dau, ImmutableString("texelFetchOffset(00O10D10D").mangledNameHash());
    ASSERT_EQ(0x00000022u, ImmutableString("texelFetchOffset(00q10D10D").mangledNameHash());
    ASSERT_EQ(0x00000856u, ImmutableString("texelFetchOffset(00v10D10D").mangledNameHash());
    ASSERT_EQ(0x000001a6u, ImmutableString("texelFetchOffset(00h10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000116u, ImmutableString("texelFetchOffset(00p10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000064eu, ImmutableString("texelFetchOffset(00u10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000034eu, ImmutableString("textureGradOffset(00I10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000007afu, ImmutableString("textureGradOffset(00R10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000189u, ImmutableString("textureGradOffset(00X10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000257u, ImmutableString("textureGradOffset(00J20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x000006afu, ImmutableString("textureGradOffset(00S20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x0000057du, ImmutableString("textureGradOffset(00Y20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x000003fdu, ImmutableString("textureGradOffset(00d20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000003d3u, ImmutableString("textureGradOffset(00L20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000003cfu, ImmutableString("textureGradOffset(00U20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000002f0u, ImmutableString("textureGradOffset(00a20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000056fu, ImmutableString("textureGradOffset(00f30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000288u, ImmutableString("textureGradOffset(00g00B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000075du, ImmutableString("textureGradOffset(00o00B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000572u, ImmutableString("textureGradOffset(00t00B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x000003d1u, ImmutableString("textureGradOffset(00O10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000052cu, ImmutableString("textureGradOffset(00q10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000002d6u, ImmutableString("textureGradOffset(00v10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000004d6u, ImmutableString("textureGradOffset(00n20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000331u, ImmutableString("textureGradOffset(00m20B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x000006ceu, ImmutableString("textureGradOffset(00h10B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000147u, ImmutableString("textureGradOffset(00p10B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x000004b5u, ImmutableString("textureGradOffset(00u10B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000041eu, ImmutableString("textureGradOffset(00i20B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000293u,
              ImmutableString("textureProjGradOffset(00I20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000035eu,
              ImmutableString("textureProjGradOffset(00R20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000373u,
              ImmutableString("textureProjGradOffset(00X20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000059au,
              ImmutableString("textureProjGradOffset(00I30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000007b4u,
              ImmutableString("textureProjGradOffset(00R30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000006e3u,
              ImmutableString("textureProjGradOffset(00X30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000854u,
              ImmutableString("textureProjGradOffset(00J30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x000004dbu,
              ImmutableString("textureProjGradOffset(00S30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x000001e4u,
              ImmutableString("textureProjGradOffset(00Y30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x00000161u,
              ImmutableString("textureProjGradOffset(00d30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000832u,
              ImmutableString("textureProjGradOffset(00g10B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x000002aeu,
              ImmutableString("textureProjGradOffset(00o10B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000772u,
              ImmutableString("textureProjGradOffset(00t10B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000018fu,
              ImmutableString("textureProjGradOffset(00g30B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000055eu,
              ImmutableString("textureProjGradOffset(00o30B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000664u,
              ImmutableString("textureProjGradOffset(00t30B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000338u,
              ImmutableString("textureProjGradOffset(00O20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000171u,
              ImmutableString("textureProjGradOffset(00q20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000158u,
              ImmutableString("textureProjGradOffset(00v20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000013u,
              ImmutableString("textureProjGradOffset(00O30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000003fcu,
              ImmutableString("textureProjGradOffset(00q30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000006u,
              ImmutableString("textureProjGradOffset(00v30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000073cu,
              ImmutableString("textureProjGradOffset(00n30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000055bu,
              ImmutableString("textureProjGradOffset(00m30B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x000007ccu, ImmutableString("textureOffset(00I10B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000013au, ImmutableString("textureOffset(00R10B10D00B").mangledNameHash());
    ASSERT_EQ(0x000000edu, ImmutableString("textureOffset(00X10B10D00B").mangledNameHash());
    ASSERT_EQ(0x000007d1u, ImmutableString("textureOffset(00J20B20D00B").mangledNameHash());
    ASSERT_EQ(0x0000059eu, ImmutableString("textureOffset(00S20B20D00B").mangledNameHash());
    ASSERT_EQ(0x000006aeu, ImmutableString("textureOffset(00Y20B20D00B").mangledNameHash());
    ASSERT_EQ(0x00000063u, ImmutableString("textureOffset(00d20B10D00B").mangledNameHash());
    ASSERT_EQ(0x000006b6u, ImmutableString("textureOffset(00L20B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000073fu, ImmutableString("textureOffset(00U20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000136u, ImmutableString("textureOffset(00a20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000366u, ImmutableString("textureOffset(00g00B00D00B").mangledNameHash());
    ASSERT_EQ(0x000002b6u, ImmutableString("textureOffset(00o00B00D00B").mangledNameHash());
    ASSERT_EQ(0x000005a3u, ImmutableString("textureOffset(00t00B00D00B").mangledNameHash());
    ASSERT_EQ(0x00000768u, ImmutableString("textureOffset(00m20B00D00B").mangledNameHash());
    ASSERT_EQ(0x000002c9u, ImmutableString("textureOffset(00h10B00D00B").mangledNameHash());
    ASSERT_EQ(0x00000725u, ImmutableString("textureOffset(00p10B00D00B").mangledNameHash());
    ASSERT_EQ(0x00000154u, ImmutableString("textureOffset(00u10B00D00B").mangledNameHash());
    ASSERT_EQ(0x000005a4u, ImmutableString("textureOffset(00i20B00D00B").mangledNameHash());
    ASSERT_EQ(0x00000603u, ImmutableString("textureProjOffset(00I20B10D00B").mangledNameHash());
    ASSERT_EQ(0x000005a2u, ImmutableString("textureProjOffset(00R20B10D00B").mangledNameHash());
    ASSERT_EQ(0x000006e2u, ImmutableString("textureProjOffset(00X20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000822u, ImmutableString("textureProjOffset(00I30B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000417u, ImmutableString("textureProjOffset(00R30B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000064bu, ImmutableString("textureProjOffset(00X30B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000014bu, ImmutableString("textureProjOffset(00J30B20D00B").mangledNameHash());
    ASSERT_EQ(0x000006fbu, ImmutableString("textureProjOffset(00S30B20D00B").mangledNameHash());
    ASSERT_EQ(0x0000004du, ImmutableString("textureProjOffset(00Y30B20D00B").mangledNameHash());
    ASSERT_EQ(0x000001e8u, ImmutableString("textureProjOffset(00d30B10D00B").mangledNameHash());
    ASSERT_EQ(0x000005b5u, ImmutableString("textureProjOffset(00g10B00D00B").mangledNameHash());
    ASSERT_EQ(0x0000052fu, ImmutableString("textureProjOffset(00o10B00D00B").mangledNameHash());
    ASSERT_EQ(0x0000019fu, ImmutableString("textureProjOffset(00t10B00D00B").mangledNameHash());
    ASSERT_EQ(0x000003f8u, ImmutableString("textureProjOffset(00g30B00D00B").mangledNameHash());
    ASSERT_EQ(0x00000613u, ImmutableString("textureProjOffset(00o30B00D00B").mangledNameHash());
    ASSERT_EQ(0x00000033u, ImmutableString("textureProjOffset(00t30B00D00B").mangledNameHash());
    ASSERT_EQ(0x0000031fu, ImmutableString("textureProjOffset(00m30B00D00B").mangledNameHash());
    ASSERT_EQ(0x0000026cu, ImmutableString("texture(00M10B").mangledNameHash());
    ASSERT_EQ(0x000002bfu, ImmutableString("textureProj(00M20B").mangledNameHash());
    ASSERT_EQ(0x000003d2u, ImmutableString("textureProj(00M30B").mangledNameHash());
    ASSERT_EQ(0x000003cbu, ImmutableString("textureSize(00M00D").mangledNameHash());
    ASSERT_EQ(0x000006abu, ImmutableString("texelFetch(00M10D00D").mangledNameHash());
    ASSERT_EQ(0x000000abu, ImmutableString("texture(00N10B").mangledNameHash());
    ASSERT_EQ(0x000003eeu, ImmutableString("textureProj(00N20B").mangledNameHash());
    ASSERT_EQ(0x00000356u, ImmutableString("textureProj(00N30B").mangledNameHash());
    ASSERT_EQ(0x0000069cu, ImmutableString("rgb_2_yuv(20B00H").mangledNameHash());
    ASSERT_EQ(0x00000446u, ImmutableString("yuv_2_rgb(20B00H").mangledNameHash());
    ASSERT_EQ(0x00000567u, ImmutableString("textureSize(00N00D").mangledNameHash());
    ASSERT_EQ(0x000001bbu, ImmutableString("texelFetch(00N10D00D").mangledNameHash());
    ASSERT_EQ(0x000007a9u, ImmutableString("textureGather(00I10B").mangledNameHash());
    ASSERT_EQ(0x00000449u, ImmutableString("textureGather(00R10B").mangledNameHash());
    ASSERT_EQ(0x00000138u, ImmutableString("textureGather(00X10B").mangledNameHash());
    ASSERT_EQ(0x000004e9u, ImmutableString("textureGather(00I10B00D").mangledNameHash());
    ASSERT_EQ(0x000007e3u, ImmutableString("textureGather(00R10B00D").mangledNameHash());
    ASSERT_EQ(0x00000750u, ImmutableString("textureGather(00X10B00D").mangledNameHash());
    ASSERT_EQ(0x000000dcu, ImmutableString("textureGather(00L20B").mangledNameHash());
    ASSERT_EQ(0x000005d6u, ImmutableString("textureGather(00U20B").mangledNameHash());
    ASSERT_EQ(0x00000337u, ImmutableString("textureGather(00a20B").mangledNameHash());
    ASSERT_EQ(0x000000a1u, ImmutableString("textureGather(00L20B00D").mangledNameHash());
    ASSERT_EQ(0x00000418u, ImmutableString("textureGather(00U20B00D").mangledNameHash());
    ASSERT_EQ(0x00000653u, ImmutableString("textureGather(00a20B00D").mangledNameHash());
    ASSERT_EQ(0x0000081au, ImmutableString("textureGather(00K20B").mangledNameHash());
    ASSERT_EQ(0x00000853u, ImmutableString("textureGather(00T20B").mangledNameHash());
    ASSERT_EQ(0x000007bbu, ImmutableString("textureGather(00Z20B").mangledNameHash());
    ASSERT_EQ(0x000003ebu, ImmutableString("textureGather(00K20B00D").mangledNameHash());
    ASSERT_EQ(0x000003edu, ImmutableString("textureGather(00T20B00D").mangledNameHash());
    ASSERT_EQ(0x000003c0u, ImmutableString("textureGather(00Z20B00D").mangledNameHash());
    ASSERT_EQ(0x00000610u, ImmutableString("textureGather(00k30B").mangledNameHash());
    ASSERT_EQ(0x00000519u, ImmutableString("textureGather(00s30B").mangledNameHash());
    ASSERT_EQ(0x000003bdu, ImmutableString("textureGather(00x30B").mangledNameHash());
    ASSERT_EQ(0x000006f6u, ImmutableString("textureGather(00k30B00D").mangledNameHash());
    ASSERT_EQ(0x00000251u, ImmutableString("textureGather(00s30B00D").mangledNameHash());
    ASSERT_EQ(0x0000012bu, ImmutableString("textureGather(00x30B00D").mangledNameHash());
    ASSERT_EQ(0x0000004cu, ImmutableString("textureGather(00O20B").mangledNameHash());
    ASSERT_EQ(0x00000289u, ImmutableString("textureGather(00q20B").mangledNameHash());
    ASSERT_EQ(0x0000045eu, ImmutableString("textureGather(00v20B").mangledNameHash());
    ASSERT_EQ(0x00000720u, ImmutableString("textureGather(00O20B00D").mangledNameHash());
    ASSERT_EQ(0x0000062fu, ImmutableString("textureGather(00q20B00D").mangledNameHash());
    ASSERT_EQ(0x000000d4u, ImmutableString("textureGather(00v20B00D").mangledNameHash());
    ASSERT_EQ(0x00000723u, ImmutableString("textureGather(00d10B").mangledNameHash());
    ASSERT_EQ(0x000007ecu, ImmutableString("textureGather(00d10B00B").mangledNameHash());
    ASSERT_EQ(0x0000063fu, ImmutableString("textureGather(00f20B").mangledNameHash());
    ASSERT_EQ(0x000000f5u, ImmutableString("textureGather(00f20B00B").mangledNameHash());
    ASSERT_EQ(0x000003e6u, ImmutableString("textureGather(00e20B").mangledNameHash());
    ASSERT_EQ(0x000000c6u, ImmutableString("textureGather(00e20B00B").mangledNameHash());
    ASSERT_EQ(0x00000702u, ImmutableString("textureGather(00l30B00B").mangledNameHash());
    ASSERT_EQ(0x0000074du, ImmutableString("textureGather(00n10B00B").mangledNameHash());
    ASSERT_EQ(0x00000817u,
              ImmutableString("textureGatherOffsets(00I10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000859u,
              ImmutableString("textureGatherOffsets(00R10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000094u,
              ImmutableString("textureGatherOffsets(00X10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x0000054cu,
              ImmutableString("textureGatherOffsets(00L20B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000660u,
              ImmutableString("textureGatherOffsets(00U20B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x0000032cu,
              ImmutableString("textureGatherOffsets(00a20B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000248u,
              ImmutableString("textureGatherOffsets(00O10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000632u,
              ImmutableString("textureGatherOffsets(00q10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x0000050eu,
              ImmutableString("textureGatherOffsets(00v10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000146u, ImmutableString("textureGatherOffsets(00I10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x00000766u, ImmutableString("textureGatherOffsets(00R10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x0000045cu, ImmutableString("textureGatherOffsets(00X10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000005ecu, ImmutableString("textureGatherOffsets(00L20B10Dx4").mangledNameHash());
    ASSERT_EQ(0x00000550u, ImmutableString("textureGatherOffsets(00U20B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000002d9u, ImmutableString("textureGatherOffsets(00a20B10Dx4").mangledNameHash());
    ASSERT_EQ(0x0000047au,
              ImmutableString("textureGatherOffsets(00d10B00B10Dx4").mangledNameHash());
    ASSERT_EQ(0x00000169u,
              ImmutableString("textureGatherOffsets(00f20B00B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000004d3u, ImmutableString("textureGatherOffsets(00O10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000001aau, ImmutableString("textureGatherOffsets(00q10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x00000757u, ImmutableString("textureGatherOffsets(00v10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x00000206u,
              ImmutableString("textureGatherOffsets(00n10B00B10Dx4").mangledNameHash());
    ASSERT_EQ(0x00000542u, ImmutableString("textureGatherOffset(00I10B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000110u, ImmutableString("textureGatherOffset(00R10B10D00D").mangledNameHash());
    ASSERT_EQ(0x0000082cu, ImmutableString("textureGatherOffset(00X10B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000233u, ImmutableString("textureGatherOffset(00L20B10D00D").mangledNameHash());
    ASSERT_EQ(0x000004e7u, ImmutableString("textureGatherOffset(00U20B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000078u, ImmutableString("textureGatherOffset(00a20B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000461u, ImmutableString("textureGatherOffset(00O10B10D00D").mangledNameHash());
    ASSERT_EQ(0x000004e8u, ImmutableString("textureGatherOffset(00q10B10D00D").mangledNameHash());
    ASSERT_EQ(0x0000083au, ImmutableString("textureGatherOffset(00v10B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000079u, ImmutableString("textureGatherOffset(00I10B10D").mangledNameHash());
    ASSERT_EQ(0x0000081bu, ImmutableString("textureGatherOffset(00R10B10D").mangledNameHash());
    ASSERT_EQ(0x000003b2u, ImmutableString("textureGatherOffset(00X10B10D").mangledNameHash());
    ASSERT_EQ(0x000006f8u, ImmutableString("textureGatherOffset(00L20B10D").mangledNameHash());
    ASSERT_EQ(0x0000038cu, ImmutableString("textureGatherOffset(00U20B10D").mangledNameHash());
    ASSERT_EQ(0x0000057eu, ImmutableString("textureGatherOffset(00a20B10D").mangledNameHash());
    ASSERT_EQ(0x0000013bu, ImmutableString("textureGatherOffset(00d10B00B10D").mangledNameHash());
    ASSERT_EQ(0x000002f7u, ImmutableString("textureGatherOffset(00f20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000021cu, ImmutableString("textureGatherOffset(00O10B10D").mangledNameHash());
    ASSERT_EQ(0x00000652u, ImmutableString("textureGatherOffset(00q10B10D").mangledNameHash());
    ASSERT_EQ(0x000004dfu, ImmutableString("textureGatherOffset(00v10B10D").mangledNameHash());
    ASSERT_EQ(0x000000c3u, ImmutableString("textureGatherOffset(00n10B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000529u, ImmutableString("dFdxFine(00B").mangledNameHash());
    ASSERT_EQ(0x0000049au, ImmutableString("dFdxFine(10B").mangledNameHash());
    ASSERT_EQ(0x0000067eu, ImmutableString("dFdxFine(20B").mangledNameHash());
    ASSERT_EQ(0x000005ddu, ImmutableString("dFdxFine(30B").mangledNameHash());
    ASSERT_EQ(0x00000354u, ImmutableString("dFdyFine(00B").mangledNameHash());
    ASSERT_EQ(0x000003f1u, ImmutableString("dFdyFine(10B").mangledNameHash());
    ASSERT_EQ(0x00000495u, ImmutableString("dFdyFine(20B").mangledNameHash());
    ASSERT_EQ(0x0000054du, ImmutableString("dFdyFine(30B").mangledNameHash());
    ASSERT_EQ(0x000002ffu, ImmutableString("dFdxCoarse(00B").mangledNameHash());
    ASSERT_EQ(0x0000036eu, ImmutableString("dFdxCoarse(10B").mangledNameHash());
    ASSERT_EQ(0x000007fau, ImmutableString("dFdxCoarse(20B").mangledNameHash());
    ASSERT_EQ(0x0000026bu, ImmutableString("dFdxCoarse(30B").mangledNameHash());
    ASSERT_EQ(0x00000076u, ImmutableString("dFdyCoarse(00B").mangledNameHash());
    ASSERT_EQ(0x0000082bu, ImmutableString("dFdyCoarse(10B").mangledNameHash());
    ASSERT_EQ(0x0000055du, ImmutableString("dFdyCoarse(20B").mangledNameHash());
    ASSERT_EQ(0x000004a3u, ImmutableString("dFdyCoarse(30B").mangledNameHash());
    ASSERT_EQ(0x0000032fu, ImmutableString("fwidthFine(00B").mangledNameHash());
    ASSERT_EQ(0x00000097u, ImmutableString("fwidthFine(10B").mangledNameHash());
    ASSERT_EQ(0x00000485u, ImmutableString("fwidthFine(20B").mangledNameHash());
    ASSERT_EQ(0x000003eau, ImmutableString("fwidthFine(30B").mangledNameHash());
    ASSERT_EQ(0x0000055cu, ImmutableString("fwidthCoarse(00B").mangledNameHash());
    ASSERT_EQ(0x00000602u, ImmutableString("fwidthCoarse(10B").mangledNameHash());
    ASSERT_EQ(0x000003feu, ImmutableString("fwidthCoarse(20B").mangledNameHash());
    ASSERT_EQ(0x000004a6u, ImmutableString("fwidthCoarse(30B").mangledNameHash());
    ASSERT_EQ(0x00000471u, ImmutableString("interpolateAtCentroid(00B").mangledNameHash());
    ASSERT_EQ(0x000003c9u, ImmutableString("interpolateAtCentroid(10B").mangledNameHash());
    ASSERT_EQ(0x000005cau, ImmutableString("interpolateAtCentroid(20B").mangledNameHash());
    ASSERT_EQ(0x00000518u, ImmutableString("interpolateAtCentroid(30B").mangledNameHash());
    ASSERT_EQ(0x000006efu, ImmutableString("interpolateAtSample(00B00D").mangledNameHash());
    ASSERT_EQ(0x0000012cu, ImmutableString("interpolateAtSample(10B00D").mangledNameHash());
    ASSERT_EQ(0x00000294u, ImmutableString("interpolateAtSample(20B00D").mangledNameHash());
    ASSERT_EQ(0x0000026au, ImmutableString("interpolateAtSample(30B00D").mangledNameHash());
    ASSERT_EQ(0x0000008fu, ImmutableString("interpolateAtOffset(00B10B").mangledNameHash());
    ASSERT_EQ(0x000005e3u, ImmutableString("interpolateAtOffset(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000514u, ImmutableString("interpolateAtOffset(20B10B").mangledNameHash());
    ASSERT_EQ(0x00000002u, ImmutableString("interpolateAtOffset(30B10B").mangledNameHash());
    ASSERT_EQ(0x000006c7u, ImmutableString("atomicCounter(00G").mangledNameHash());
    ASSERT_EQ(0x00000619u, ImmutableString("atomicCounterIncrement(00G").mangledNameHash());
    ASSERT_EQ(0x000001c6u, ImmutableString("atomicCounterDecrement(00G").mangledNameHash());
    ASSERT_EQ(0x0000079fu, ImmutableString("atomicCounterAdd(00G00E").mangledNameHash());
    ASSERT_EQ(0x00000580u, ImmutableString("atomicCounterSubtract(00G00E").mangledNameHash());
    ASSERT_EQ(0x000004b4u, ImmutableString("atomicCounterMin(00G00E").mangledNameHash());
    ASSERT_EQ(0x00000440u, ImmutableString("atomicCounterMax(00G00E").mangledNameHash());
    ASSERT_EQ(0x0000079cu, ImmutableString("atomicCounterAnd(00G00E").mangledNameHash());
    ASSERT_EQ(0x00000361u, ImmutableString("atomicCounterOr(00G00E").mangledNameHash());
    ASSERT_EQ(0x00000531u, ImmutableString("atomicCounterXor(00G00E").mangledNameHash());
    ASSERT_EQ(0x00000441u, ImmutableString("atomicCounterExchange(00G00E").mangledNameHash());
    ASSERT_EQ(0x00000135u, ImmutableString("atomicCounterCompSwap(00G00E00E").mangledNameHash());
    ASSERT_EQ(0x00000156u, ImmutableString("atomicAdd(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000030u, ImmutableString("atomicAdd(00D00D").mangledNameHash());
    ASSERT_EQ(0x000002d5u, ImmutableString("atomicMin(00E00E").mangledNameHash());
    ASSERT_EQ(0x0000040fu, ImmutableString("atomicMin(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000083bu, ImmutableString("atomicMax(00E00E").mangledNameHash());
    ASSERT_EQ(0x0000048fu, ImmutableString("atomicMax(00D00D").mangledNameHash());
    ASSERT_EQ(0x000006beu, ImmutableString("atomicAnd(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000469u, ImmutableString("atomicAnd(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000053au, ImmutableString("atomicOr(00E00E").mangledNameHash());
    ASSERT_EQ(0x0000037fu, ImmutableString("atomicOr(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000173u, ImmutableString("atomicXor(00E00E").mangledNameHash());
    ASSERT_EQ(0x000000e2u, ImmutableString("atomicXor(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000023au, ImmutableString("atomicExchange(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000767u, ImmutableString("atomicExchange(00D00D").mangledNameHash());
    ASSERT_EQ(0x000002b0u, ImmutableString("atomicCompSwap(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000351u, ImmutableString("atomicCompSwap(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002fau, ImmutableString("imageSize(00z").mangledNameHash());
    ASSERT_EQ(0x000005b2u, ImmutableString("imageSize(01A").mangledNameHash());
    ASSERT_EQ(0x0000039bu, ImmutableString("imageSize(01B").mangledNameHash());
    ASSERT_EQ(0x0000039cu, ImmutableString("imageSize(01C").mangledNameHash());
    ASSERT_EQ(0x000003a0u, ImmutableString("imageSize(01D").mangledNameHash());
    ASSERT_EQ(0x000003a1u, ImmutableString("imageSize(01E").mangledNameHash());
    ASSERT_EQ(0x0000039eu, ImmutableString("imageSize(01F").mangledNameHash());
    ASSERT_EQ(0x0000039fu, ImmutableString("imageSize(01G").mangledNameHash());
    ASSERT_EQ(0x00000395u, ImmutableString("imageSize(01H").mangledNameHash());
    ASSERT_EQ(0x00000396u, ImmutableString("imageSize(01I").mangledNameHash());
    ASSERT_EQ(0x00000393u, ImmutableString("imageSize(01J").mangledNameHash());
    ASSERT_EQ(0x00000394u, ImmutableString("imageSize(01K").mangledNameHash());
    ASSERT_EQ(0x00000399u, ImmutableString("imageSize(01L").mangledNameHash());
    ASSERT_EQ(0x0000039au, ImmutableString("imageSize(01M").mangledNameHash());
    ASSERT_EQ(0x00000559u, ImmutableString("imageSize(01N").mangledNameHash());
    ASSERT_EQ(0x000003b5u, ImmutableString("imageSize(01a").mangledNameHash());
    ASSERT_EQ(0x000005eau, ImmutableString("imageSize(01b").mangledNameHash());
    ASSERT_EQ(0x000003b3u, ImmutableString("imageSize(01c").mangledNameHash());
    ASSERT_EQ(0x000003b8u, ImmutableString("imageSize(01d").mangledNameHash());
    ASSERT_EQ(0x000005f8u, ImmutableString("imageSize(01e").mangledNameHash());
    ASSERT_EQ(0x000003b6u, ImmutableString("imageSize(01f").mangledNameHash());
    ASSERT_EQ(0x000005a9u, ImmutableString("imageSize(01O").mangledNameHash());
    ASSERT_EQ(0x000003a8u, ImmutableString("imageSize(01P").mangledNameHash());
    ASSERT_EQ(0x000003a9u, ImmutableString("imageSize(01Q").mangledNameHash());
    ASSERT_EQ(0x000005f4u, ImmutableString("imageSize(01g").mangledNameHash());
    ASSERT_EQ(0x000003aeu, ImmutableString("imageSize(01h").mangledNameHash());
    ASSERT_EQ(0x000003afu, ImmutableString("imageSize(01i").mangledNameHash());
    ASSERT_EQ(0x000003a6u, ImmutableString("imageSize(01R").mangledNameHash());
    ASSERT_EQ(0x000003a7u, ImmutableString("imageSize(01S").mangledNameHash());
    ASSERT_EQ(0x000003acu, ImmutableString("imageSize(01T").mangledNameHash());
    ASSERT_EQ(0x000003adu, ImmutableString("imageSize(01U").mangledNameHash());
    ASSERT_EQ(0x000003aau, ImmutableString("imageSize(01V").mangledNameHash());
    ASSERT_EQ(0x00000629u, ImmutableString("imageSize(01W").mangledNameHash());
    ASSERT_EQ(0x000001ceu, ImmutableString("imageSamples(01R").mangledNameHash());
    ASSERT_EQ(0x0000001au, ImmutableString("imageSamples(01S").mangledNameHash());
    ASSERT_EQ(0x00000019u, ImmutableString("imageSamples(01T").mangledNameHash());
    ASSERT_EQ(0x00000018u, ImmutableString("imageSamples(01U").mangledNameHash());
    ASSERT_EQ(0x00000017u, ImmutableString("imageSamples(01V").mangledNameHash());
    ASSERT_EQ(0x00000016u, ImmutableString("imageSamples(01W").mangledNameHash());
    ASSERT_EQ(0x00000011u, ImmutableString("imageAtomicAdd(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x0000084du, ImmutableString("imageAtomicAdd(01A10D00E").mangledNameHash());
    ASSERT_EQ(0x000001adu, ImmutableString("imageAtomicAdd(01B10D00E").mangledNameHash());
    ASSERT_EQ(0x00000323u, ImmutableString("imageAtomicAdd(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x0000002fu, ImmutableString("imageAtomicAdd(01D20D00E").mangledNameHash());
    ASSERT_EQ(0x000000c1u, ImmutableString("imageAtomicAdd(01E20D00E").mangledNameHash());
    ASSERT_EQ(0x0000011cu, ImmutableString("imageAtomicAdd(01I20D00E").mangledNameHash());
    ASSERT_EQ(0x0000061bu, ImmutableString("imageAtomicAdd(01J20D00E").mangledNameHash());
    ASSERT_EQ(0x00000597u, ImmutableString("imageAtomicAdd(01K20D00E").mangledNameHash());
    ASSERT_EQ(0x00000371u, ImmutableString("imageAtomicAdd(01g00D00E").mangledNameHash());
    ASSERT_EQ(0x000001eeu, ImmutableString("imageAtomicAdd(01h00D00E").mangledNameHash());
    ASSERT_EQ(0x00000585u, ImmutableString("imageAtomicAdd(01i00D00E").mangledNameHash());
    ASSERT_EQ(0x00000673u, ImmutableString("imageAtomicAdd(01F20D00E").mangledNameHash());
    ASSERT_EQ(0x00000386u, ImmutableString("imageAtomicAdd(01G20D00E").mangledNameHash());
    ASSERT_EQ(0x000006dbu, ImmutableString("imageAtomicAdd(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x000003e9u, ImmutableString("imageAtomicAdd(01a20D00E").mangledNameHash());
    ASSERT_EQ(0x00000693u, ImmutableString("imageAtomicAdd(01b20D00E").mangledNameHash());
    ASSERT_EQ(0x0000070eu, ImmutableString("imageAtomicAdd(01c20D00E").mangledNameHash());
    ASSERT_EQ(0x000005deu, ImmutableString("imageAtomicAdd(01L00D00E").mangledNameHash());
    ASSERT_EQ(0x00000797u, ImmutableString("imageAtomicAdd(01M00D00E").mangledNameHash());
    ASSERT_EQ(0x00000115u, ImmutableString("imageAtomicAdd(01N00D00E").mangledNameHash());
    ASSERT_EQ(0x000005c4u, ImmutableString("imageAtomicAdd(01O10D00E").mangledNameHash());
    ASSERT_EQ(0x00000709u, ImmutableString("imageAtomicAdd(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x00000185u, ImmutableString("imageAtomicAdd(01Q10D00E").mangledNameHash());
    ASSERT_EQ(0x00000747u, ImmutableString("imageAtomicAdd(01X10D00E").mangledNameHash());
    ASSERT_EQ(0x0000016du, ImmutableString("imageAtomicAdd(01Y10D00E").mangledNameHash());
    ASSERT_EQ(0x000002c2u, ImmutableString("imageAtomicAdd(01Z10D00E").mangledNameHash());
    ASSERT_EQ(0x0000033fu, ImmutableString("imageAtomicAdd(01R10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000009u, ImmutableString("imageAtomicAdd(01S10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000007efu, ImmutableString("imageAtomicAdd(01T10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000620u, ImmutableString("imageAtomicAdd(01U20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000001d6u, ImmutableString("imageAtomicAdd(01V20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000022cu, ImmutableString("imageAtomicAdd(01W20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000238u, ImmutableString("imageAtomicAdd(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x0000084cu, ImmutableString("imageAtomicAdd(01A10D00D").mangledNameHash());
    ASSERT_EQ(0x00000204u, ImmutableString("imageAtomicAdd(01B10D00D").mangledNameHash());
    ASSERT_EQ(0x000002a6u, ImmutableString("imageAtomicAdd(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x000006fcu, ImmutableString("imageAtomicAdd(01D20D00D").mangledNameHash());
    ASSERT_EQ(0x00000719u, ImmutableString("imageAtomicAdd(01E20D00D").mangledNameHash());
    ASSERT_EQ(0x00000715u, ImmutableString("imageAtomicAdd(01I20D00D").mangledNameHash());
    ASSERT_EQ(0x0000061au, ImmutableString("imageAtomicAdd(01J20D00D").mangledNameHash());
    ASSERT_EQ(0x00000598u, ImmutableString("imageAtomicAdd(01K20D00D").mangledNameHash());
    ASSERT_EQ(0x000001fdu, ImmutableString("imageAtomicAdd(01g00D00D").mangledNameHash());
    ASSERT_EQ(0x000001edu, ImmutableString("imageAtomicAdd(01h00D00D").mangledNameHash());
    ASSERT_EQ(0x00000586u, ImmutableString("imageAtomicAdd(01i00D00D").mangledNameHash());
    ASSERT_EQ(0x00000672u, ImmutableString("imageAtomicAdd(01F20D00D").mangledNameHash());
    ASSERT_EQ(0x00000387u, ImmutableString("imageAtomicAdd(01G20D00D").mangledNameHash());
    ASSERT_EQ(0x000006dau, ImmutableString("imageAtomicAdd(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x000006f5u, ImmutableString("imageAtomicAdd(01a20D00D").mangledNameHash());
    ASSERT_EQ(0x000005c9u, ImmutableString("imageAtomicAdd(01b20D00D").mangledNameHash());
    ASSERT_EQ(0x0000070fu, ImmutableString("imageAtomicAdd(01c20D00D").mangledNameHash());
    ASSERT_EQ(0x0000025eu, ImmutableString("imageAtomicAdd(01L00D00D").mangledNameHash());
    ASSERT_EQ(0x00000798u, ImmutableString("imageAtomicAdd(01M00D00D").mangledNameHash());
    ASSERT_EQ(0x00000114u, ImmutableString("imageAtomicAdd(01N00D00D").mangledNameHash());
    ASSERT_EQ(0x000005c3u, ImmutableString("imageAtomicAdd(01O10D00D").mangledNameHash());
    ASSERT_EQ(0x0000070au, ImmutableString("imageAtomicAdd(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x00000734u, ImmutableString("imageAtomicAdd(01Q10D00D").mangledNameHash());
    ASSERT_EQ(0x0000074au, ImmutableString("imageAtomicAdd(01X10D00D").mangledNameHash());
    ASSERT_EQ(0x0000016cu, ImmutableString("imageAtomicAdd(01Y10D00D").mangledNameHash());
    ASSERT_EQ(0x000002c3u, ImmutableString("imageAtomicAdd(01Z10D00D").mangledNameHash());
    ASSERT_EQ(0x0000033eu, ImmutableString("imageAtomicAdd(01R10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000063au, ImmutableString("imageAtomicAdd(01S10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007eeu, ImmutableString("imageAtomicAdd(01T10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000061fu, ImmutableString("imageAtomicAdd(01U20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002e0u, ImmutableString("imageAtomicAdd(01V20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000059bu, ImmutableString("imageAtomicAdd(01W20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000590u, ImmutableString("imageAtomicMin(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x0000056du, ImmutableString("imageAtomicMin(01A10D00E").mangledNameHash());
    ASSERT_EQ(0x000001eau, ImmutableString("imageAtomicMin(01B10D00E").mangledNameHash());
    ASSERT_EQ(0x0000028eu, ImmutableString("imageAtomicMin(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x000003fbu, ImmutableString("imageAtomicMin(01D20D00E").mangledNameHash());
    ASSERT_EQ(0x000005bbu, ImmutableString("imageAtomicMin(01E20D00E").mangledNameHash());
    ASSERT_EQ(0x0000071eu, ImmutableString("imageAtomicMin(01I20D00E").mangledNameHash());
    ASSERT_EQ(0x0000017du, ImmutableString("imageAtomicMin(01J20D00E").mangledNameHash());
    ASSERT_EQ(0x00000332u, ImmutableString("imageAtomicMin(01K20D00E").mangledNameHash());
    ASSERT_EQ(0x00000368u, ImmutableString("imageAtomicMin(01g00D00E").mangledNameHash());
    ASSERT_EQ(0x00000111u, ImmutableString("imageAtomicMin(01h00D00E").mangledNameHash());
    ASSERT_EQ(0x00000362u, ImmutableString("imageAtomicMin(01i00D00E").mangledNameHash());
    ASSERT_EQ(0x0000012du, ImmutableString("imageAtomicMin(01F20D00E").mangledNameHash());
    ASSERT_EQ(0x00000267u, ImmutableString("imageAtomicMin(01G20D00E").mangledNameHash());
    ASSERT_EQ(0x00000212u, ImmutableString("imageAtomicMin(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x00000694u, ImmutableString("imageAtomicMin(01a20D00E").mangledNameHash());
    ASSERT_EQ(0x00000279u, ImmutableString("imageAtomicMin(01b20D00E").mangledNameHash());
    ASSERT_EQ(0x00000500u, ImmutableString("imageAtomicMin(01c20D00E").mangledNameHash());
    ASSERT_EQ(0x00000537u, ImmutableString("imageAtomicMin(01L00D00E").mangledNameHash());
    ASSERT_EQ(0x0000047du, ImmutableString("imageAtomicMin(01M00D00E").mangledNameHash());
    ASSERT_EQ(0x000002a2u, ImmutableString("imageAtomicMin(01N00D00E").mangledNameHash());
    ASSERT_EQ(0x0000047fu, ImmutableString("imageAtomicMin(01O10D00E").mangledNameHash());
    ASSERT_EQ(0x00000322u, ImmutableString("imageAtomicMin(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x00000341u, ImmutableString("imageAtomicMin(01Q10D00E").mangledNameHash());
    ASSERT_EQ(0x000000fcu, ImmutableString("imageAtomicMin(01X10D00E").mangledNameHash());
    ASSERT_EQ(0x00000104u, ImmutableString("imageAtomicMin(01Y10D00E").mangledNameHash());
    ASSERT_EQ(0x000006c2u, ImmutableString("imageAtomicMin(01Z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000049u, ImmutableString("imageAtomicMin(01R10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000006fau, ImmutableString("imageAtomicMin(01S10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000002e2u, ImmutableString("imageAtomicMin(01T10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000732u, ImmutableString("imageAtomicMin(01U20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000662u, ImmutableString("imageAtomicMin(01V20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000007c2u, ImmutableString("imageAtomicMin(01W20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000591u, ImmutableString("imageAtomicMin(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x0000056eu, ImmutableString("imageAtomicMin(01A10D00D").mangledNameHash());
    ASSERT_EQ(0x000001e9u, ImmutableString("imageAtomicMin(01B10D00D").mangledNameHash());
    ASSERT_EQ(0x0000028du, ImmutableString("imageAtomicMin(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x00000765u, ImmutableString("imageAtomicMin(01D20D00D").mangledNameHash());
    ASSERT_EQ(0x000005bau, ImmutableString("imageAtomicMin(01E20D00D").mangledNameHash());
    ASSERT_EQ(0x000000d3u, ImmutableString("imageAtomicMin(01I20D00D").mangledNameHash());
    ASSERT_EQ(0x000003bbu, ImmutableString("imageAtomicMin(01J20D00D").mangledNameHash());
    ASSERT_EQ(0x000004bau, ImmutableString("imageAtomicMin(01K20D00D").mangledNameHash());
    ASSERT_EQ(0x00000792u, ImmutableString("imageAtomicMin(01g00D00D").mangledNameHash());
    ASSERT_EQ(0x00000112u, ImmutableString("imageAtomicMin(01h00D00D").mangledNameHash());
    ASSERT_EQ(0x00000635u, ImmutableString("imageAtomicMin(01i00D00D").mangledNameHash());
    ASSERT_EQ(0x0000012eu, ImmutableString("imageAtomicMin(01F20D00D").mangledNameHash());
    ASSERT_EQ(0x00000266u, ImmutableString("imageAtomicMin(01G20D00D").mangledNameHash());
    ASSERT_EQ(0x0000040au, ImmutableString("imageAtomicMin(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x00000300u, ImmutableString("imageAtomicMin(01a20D00D").mangledNameHash());
    ASSERT_EQ(0x0000027au, ImmutableString("imageAtomicMin(01b20D00D").mangledNameHash());
    ASSERT_EQ(0x000004ffu, ImmutableString("imageAtomicMin(01c20D00D").mangledNameHash());
    ASSERT_EQ(0x0000067fu, ImmutableString("imageAtomicMin(01L00D00D").mangledNameHash());
    ASSERT_EQ(0x0000047cu, ImmutableString("imageAtomicMin(01M00D00D").mangledNameHash());
    ASSERT_EQ(0x000002a3u, ImmutableString("imageAtomicMin(01N00D00D").mangledNameHash());
    ASSERT_EQ(0x00000480u, ImmutableString("imageAtomicMin(01O10D00D").mangledNameHash());
    ASSERT_EQ(0x0000029fu, ImmutableString("imageAtomicMin(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x00000342u, ImmutableString("imageAtomicMin(01Q10D00D").mangledNameHash());
    ASSERT_EQ(0x000000fbu, ImmutableString("imageAtomicMin(01X10D00D").mangledNameHash());
    ASSERT_EQ(0x00000036u, ImmutableString("imageAtomicMin(01Y10D00D").mangledNameHash());
    ASSERT_EQ(0x000006c1u, ImmutableString("imageAtomicMin(01Z10D00D").mangledNameHash());
    ASSERT_EQ(0x0000004au, ImmutableString("imageAtomicMin(01R10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006f9u, ImmutableString("imageAtomicMin(01S10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002e3u, ImmutableString("imageAtomicMin(01T10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000733u, ImmutableString("imageAtomicMin(01U20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000661u, ImmutableString("imageAtomicMin(01V20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007c3u, ImmutableString("imageAtomicMin(01W20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000003e0u, ImmutableString("imageAtomicMax(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x000000d7u, ImmutableString("imageAtomicMax(01A10D00E").mangledNameHash());
    ASSERT_EQ(0x000005f6u, ImmutableString("imageAtomicMax(01B10D00E").mangledNameHash());
    ASSERT_EQ(0x00000701u, ImmutableString("imageAtomicMax(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x000002c7u, ImmutableString("imageAtomicMax(01D20D00E").mangledNameHash());
    ASSERT_EQ(0x000003f4u, ImmutableString("imageAtomicMax(01E20D00E").mangledNameHash());
    ASSERT_EQ(0x00000540u, ImmutableString("imageAtomicMax(01I20D00E").mangledNameHash());
    ASSERT_EQ(0x00000763u, ImmutableString("imageAtomicMax(01J20D00E").mangledNameHash());
    ASSERT_EQ(0x000004a2u, ImmutableString("imageAtomicMax(01K20D00E").mangledNameHash());
    ASSERT_EQ(0x000005fdu, ImmutableString("imageAtomicMax(01g00D00E").mangledNameHash());
    ASSERT_EQ(0x00000744u, ImmutableString("imageAtomicMax(01h00D00E").mangledNameHash());
    ASSERT_EQ(0x00000349u, ImmutableString("imageAtomicMax(01i00D00E").mangledNameHash());
    ASSERT_EQ(0x000004f6u, ImmutableString("imageAtomicMax(01F20D00E").mangledNameHash());
    ASSERT_EQ(0x000005f0u, ImmutableString("imageAtomicMax(01G20D00E").mangledNameHash());
    ASSERT_EQ(0x00000313u, ImmutableString("imageAtomicMax(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x000004f1u, ImmutableString("imageAtomicMax(01a20D00E").mangledNameHash());
    ASSERT_EQ(0x000001c1u, ImmutableString("imageAtomicMax(01b20D00E").mangledNameHash());
    ASSERT_EQ(0x000005edu, ImmutableString("imageAtomicMax(01c20D00E").mangledNameHash());
    ASSERT_EQ(0x00000751u, ImmutableString("imageAtomicMax(01L00D00E").mangledNameHash());
    ASSERT_EQ(0x00000717u, ImmutableString("imageAtomicMax(01M00D00E").mangledNameHash());
    ASSERT_EQ(0x00000686u, ImmutableString("imageAtomicMax(01N00D00E").mangledNameHash());
    ASSERT_EQ(0x00000425u, ImmutableString("imageAtomicMax(01O10D00E").mangledNameHash());
    ASSERT_EQ(0x0000027cu, ImmutableString("imageAtomicMax(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x00000477u, ImmutableString("imageAtomicMax(01Q10D00E").mangledNameHash());
    ASSERT_EQ(0x00000262u, ImmutableString("imageAtomicMax(01X10D00E").mangledNameHash());
    ASSERT_EQ(0x0000009du, ImmutableString("imageAtomicMax(01Y10D00E").mangledNameHash());
    ASSERT_EQ(0x00000096u, ImmutableString("imageAtomicMax(01Z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000128u, ImmutableString("imageAtomicMax(01R10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000003au, ImmutableString("imageAtomicMax(01S10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000246u, ImmutableString("imageAtomicMax(01T10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000142u, ImmutableString("imageAtomicMax(01U20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000003e7u, ImmutableString("imageAtomicMax(01V20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000005a0u, ImmutableString("imageAtomicMax(01W20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000003e1u, ImmutableString("imageAtomicMax(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x000000d8u, ImmutableString("imageAtomicMax(01A10D00D").mangledNameHash());
    ASSERT_EQ(0x000005f5u, ImmutableString("imageAtomicMax(01B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000700u, ImmutableString("imageAtomicMax(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x000002c8u, ImmutableString("imageAtomicMax(01D20D00D").mangledNameHash());
    ASSERT_EQ(0x000003f3u, ImmutableString("imageAtomicMax(01E20D00D").mangledNameHash());
    ASSERT_EQ(0x0000053fu, ImmutableString("imageAtomicMax(01I20D00D").mangledNameHash());
    ASSERT_EQ(0x00000764u, ImmutableString("imageAtomicMax(01J20D00D").mangledNameHash());
    ASSERT_EQ(0x000004a1u, ImmutableString("imageAtomicMax(01K20D00D").mangledNameHash());
    ASSERT_EQ(0x000005fcu, ImmutableString("imageAtomicMax(01g00D00D").mangledNameHash());
    ASSERT_EQ(0x00000297u, ImmutableString("imageAtomicMax(01h00D00D").mangledNameHash());
    ASSERT_EQ(0x00000348u, ImmutableString("imageAtomicMax(01i00D00D").mangledNameHash());
    ASSERT_EQ(0x000004f7u, ImmutableString("imageAtomicMax(01F20D00D").mangledNameHash());
    ASSERT_EQ(0x000005efu, ImmutableString("imageAtomicMax(01G20D00D").mangledNameHash());
    ASSERT_EQ(0x00000314u, ImmutableString("imageAtomicMax(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x000004f0u, ImmutableString("imageAtomicMax(01a20D00D").mangledNameHash());
    ASSERT_EQ(0x000001c2u, ImmutableString("imageAtomicMax(01b20D00D").mangledNameHash());
    ASSERT_EQ(0x00000369u, ImmutableString("imageAtomicMax(01c20D00D").mangledNameHash());
    ASSERT_EQ(0x00000752u, ImmutableString("imageAtomicMax(01L00D00D").mangledNameHash());
    ASSERT_EQ(0x00000716u, ImmutableString("imageAtomicMax(01M00D00D").mangledNameHash());
    ASSERT_EQ(0x00000687u, ImmutableString("imageAtomicMax(01N00D00D").mangledNameHash());
    ASSERT_EQ(0x00000426u, ImmutableString("imageAtomicMax(01O10D00D").mangledNameHash());
    ASSERT_EQ(0x0000027bu, ImmutableString("imageAtomicMax(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x00000482u, ImmutableString("imageAtomicMax(01Q10D00D").mangledNameHash());
    ASSERT_EQ(0x00000483u, ImmutableString("imageAtomicMax(01X10D00D").mangledNameHash());
    ASSERT_EQ(0x0000009eu, ImmutableString("imageAtomicMax(01Y10D00D").mangledNameHash());
    ASSERT_EQ(0x00000374u, ImmutableString("imageAtomicMax(01Z10D00D").mangledNameHash());
    ASSERT_EQ(0x00000129u, ImmutableString("imageAtomicMax(01R10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000011au, ImmutableString("imageAtomicMax(01S10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000247u, ImmutableString("imageAtomicMax(01T10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000143u, ImmutableString("imageAtomicMax(01U20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006cfu, ImmutableString("imageAtomicMax(01V20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000005a1u, ImmutableString("imageAtomicMax(01W20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007ceu, ImmutableString("imageAtomicAnd(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x000000f4u, ImmutableString("imageAtomicAnd(01A10D00E").mangledNameHash());
    ASSERT_EQ(0x000007deu, ImmutableString("imageAtomicAnd(01B10D00E").mangledNameHash());
    ASSERT_EQ(0x00000062u, ImmutableString("imageAtomicAnd(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x000006a1u, ImmutableString("imageAtomicAnd(01D20D00E").mangledNameHash());
    ASSERT_EQ(0x00000487u, ImmutableString("imageAtomicAnd(01E20D00E").mangledNameHash());
    ASSERT_EQ(0x0000075au, ImmutableString("imageAtomicAnd(01I20D00E").mangledNameHash());
    ASSERT_EQ(0x00000118u, ImmutableString("imageAtomicAnd(01J20D00E").mangledNameHash());
    ASSERT_EQ(0x0000052au, ImmutableString("imageAtomicAnd(01K20D00E").mangledNameHash());
    ASSERT_EQ(0x000001e2u, ImmutableString("imageAtomicAnd(01g00D00E").mangledNameHash());
    ASSERT_EQ(0x0000038fu, ImmutableString("imageAtomicAnd(01h00D00E").mangledNameHash());
    ASSERT_EQ(0x000003deu, ImmutableString("imageAtomicAnd(01i00D00E").mangledNameHash());
    ASSERT_EQ(0x0000028fu, ImmutableString("imageAtomicAnd(01F20D00E").mangledNameHash());
    ASSERT_EQ(0x00000804u, ImmutableString("imageAtomicAnd(01G20D00E").mangledNameHash());
    ASSERT_EQ(0x0000077eu, ImmutableString("imageAtomicAnd(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x00000791u, ImmutableString("imageAtomicAnd(01a20D00E").mangledNameHash());
    ASSERT_EQ(0x0000008cu, ImmutableString("imageAtomicAnd(01b20D00E").mangledNameHash());
    ASSERT_EQ(0x000001cau, ImmutableString("imageAtomicAnd(01c20D00E").mangledNameHash());
    ASSERT_EQ(0x00000244u, ImmutableString("imageAtomicAnd(01L00D00E").mangledNameHash());
    ASSERT_EQ(0x00000203u, ImmutableString("imageAtomicAnd(01M00D00E").mangledNameHash());
    ASSERT_EQ(0x000002f9u, ImmutableString("imageAtomicAnd(01N00D00E").mangledNameHash());
    ASSERT_EQ(0x00000749u, ImmutableString("imageAtomicAnd(01O10D00E").mangledNameHash());
    ASSERT_EQ(0x00000609u, ImmutableString("imageAtomicAnd(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x000001c9u, ImmutableString("imageAtomicAnd(01Q10D00E").mangledNameHash());
    ASSERT_EQ(0x0000068bu, ImmutableString("imageAtomicAnd(01X10D00E").mangledNameHash());
    ASSERT_EQ(0x00000584u, ImmutableString("imageAtomicAnd(01Y10D00E").mangledNameHash());
    ASSERT_EQ(0x000003c1u, ImmutableString("imageAtomicAnd(01Z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000491u, ImmutableString("imageAtomicAnd(01R10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000452u, ImmutableString("imageAtomicAnd(01S10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000605u, ImmutableString("imageAtomicAnd(01T10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000001b1u, ImmutableString("imageAtomicAnd(01U20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000005bu, ImmutableString("imageAtomicAnd(01V20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000006d3u, ImmutableString("imageAtomicAnd(01W20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000007cdu, ImmutableString("imageAtomicAnd(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x0000002eu, ImmutableString("imageAtomicAnd(01A10D00D").mangledNameHash());
    ASSERT_EQ(0x000006e4u, ImmutableString("imageAtomicAnd(01B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000065u, ImmutableString("imageAtomicAnd(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x000006a0u, ImmutableString("imageAtomicAnd(01D20D00D").mangledNameHash());
    ASSERT_EQ(0x00000488u, ImmutableString("imageAtomicAnd(01E20D00D").mangledNameHash());
    ASSERT_EQ(0x0000025bu, ImmutableString("imageAtomicAnd(01I20D00D").mangledNameHash());
    ASSERT_EQ(0x00000117u, ImmutableString("imageAtomicAnd(01J20D00D").mangledNameHash());
    ASSERT_EQ(0x00000144u, ImmutableString("imageAtomicAnd(01K20D00D").mangledNameHash());
    ASSERT_EQ(0x000001a8u, ImmutableString("imageAtomicAnd(01g00D00D").mangledNameHash());
    ASSERT_EQ(0x00000384u, ImmutableString("imageAtomicAnd(01h00D00D").mangledNameHash());
    ASSERT_EQ(0x000003dfu, ImmutableString("imageAtomicAnd(01i00D00D").mangledNameHash());
    ASSERT_EQ(0x0000031du, ImmutableString("imageAtomicAnd(01F20D00D").mangledNameHash());
    ASSERT_EQ(0x00000805u, ImmutableString("imageAtomicAnd(01G20D00D").mangledNameHash());
    ASSERT_EQ(0x0000077du, ImmutableString("imageAtomicAnd(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x00000794u, ImmutableString("imageAtomicAnd(01a20D00D").mangledNameHash());
    ASSERT_EQ(0x00000738u, ImmutableString("imageAtomicAnd(01b20D00D").mangledNameHash());
    ASSERT_EQ(0x000001cbu, ImmutableString("imageAtomicAnd(01c20D00D").mangledNameHash());
    ASSERT_EQ(0x00000243u, ImmutableString("imageAtomicAnd(01L00D00D").mangledNameHash());
    ASSERT_EQ(0x00000205u, ImmutableString("imageAtomicAnd(01M00D00D").mangledNameHash());
    ASSERT_EQ(0x000002f8u, ImmutableString("imageAtomicAnd(01N00D00D").mangledNameHash());
    ASSERT_EQ(0x000000a0u, ImmutableString("imageAtomicAnd(01O10D00D").mangledNameHash());
    ASSERT_EQ(0x0000060au, ImmutableString("imageAtomicAnd(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x000001c8u, ImmutableString("imageAtomicAnd(01Q10D00D").mangledNameHash());
    ASSERT_EQ(0x0000068du, ImmutableString("imageAtomicAnd(01X10D00D").mangledNameHash());
    ASSERT_EQ(0x00000583u, ImmutableString("imageAtomicAnd(01Y10D00D").mangledNameHash());
    ASSERT_EQ(0x000003c2u, ImmutableString("imageAtomicAnd(01Z10D00D").mangledNameHash());
    ASSERT_EQ(0x000000c0u, ImmutableString("imageAtomicAnd(01R10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000453u, ImmutableString("imageAtomicAnd(01S10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000604u, ImmutableString("imageAtomicAnd(01T10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000001b0u, ImmutableString("imageAtomicAnd(01U20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000005cu, ImmutableString("imageAtomicAnd(01V20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006d2u, ImmutableString("imageAtomicAnd(01W20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000015u, ImmutableString("imageAtomicOr(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x0000048cu, ImmutableString("imageAtomicOr(01A10D00E").mangledNameHash());
    ASSERT_EQ(0x00000829u, ImmutableString("imageAtomicOr(01B10D00E").mangledNameHash());
    ASSERT_EQ(0x000002f4u, ImmutableString("imageAtomicOr(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x000004deu, ImmutableString("imageAtomicOr(01D20D00E").mangledNameHash());
    ASSERT_EQ(0x000000aeu, ImmutableString("imageAtomicOr(01E20D00E").mangledNameHash());
    ASSERT_EQ(0x00000439u, ImmutableString("imageAtomicOr(01I20D00E").mangledNameHash());
    ASSERT_EQ(0x000004f4u, ImmutableString("imageAtomicOr(01J20D00E").mangledNameHash());
    ASSERT_EQ(0x0000014fu, ImmutableString("imageAtomicOr(01K20D00E").mangledNameHash());
    ASSERT_EQ(0x00000533u, ImmutableString("imageAtomicOr(01g00D00E").mangledNameHash());
    ASSERT_EQ(0x00000569u, ImmutableString("imageAtomicOr(01h00D00E").mangledNameHash());
    ASSERT_EQ(0x000007ffu, ImmutableString("imageAtomicOr(01i00D00E").mangledNameHash());
    ASSERT_EQ(0x000002cfu, ImmutableString("imageAtomicOr(01F20D00E").mangledNameHash());
    ASSERT_EQ(0x0000028cu, ImmutableString("imageAtomicOr(01G20D00E").mangledNameHash());
    ASSERT_EQ(0x0000084fu, ImmutableString("imageAtomicOr(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x00000577u, ImmutableString("imageAtomicOr(01a20D00E").mangledNameHash());
    ASSERT_EQ(0x00000838u, ImmutableString("imageAtomicOr(01b20D00E").mangledNameHash());
    ASSERT_EQ(0x00000516u, ImmutableString("imageAtomicOr(01c20D00E").mangledNameHash());
    ASSERT_EQ(0x0000011fu, ImmutableString("imageAtomicOr(01L00D00E").mangledNameHash());
    ASSERT_EQ(0x000003d9u, ImmutableString("imageAtomicOr(01M00D00E").mangledNameHash());
    ASSERT_EQ(0x000006f3u, ImmutableString("imageAtomicOr(01N00D00E").mangledNameHash());
    ASSERT_EQ(0x000005c7u, ImmutableString("imageAtomicOr(01O10D00E").mangledNameHash());
    ASSERT_EQ(0x000000e5u, ImmutableString("imageAtomicOr(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x00000513u, ImmutableString("imageAtomicOr(01Q10D00E").mangledNameHash());
    ASSERT_EQ(0x000006a6u, ImmutableString("imageAtomicOr(01X10D00E").mangledNameHash());
    ASSERT_EQ(0x00000187u, ImmutableString("imageAtomicOr(01Y10D00E").mangledNameHash());
    ASSERT_EQ(0x0000050cu, ImmutableString("imageAtomicOr(01Z10D00E").mangledNameHash());
    ASSERT_EQ(0x000000bbu, ImmutableString("imageAtomicOr(01R10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000084au, ImmutableString("imageAtomicOr(01S10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000401u, ImmutableString("imageAtomicOr(01T10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000006a8u, ImmutableString("imageAtomicOr(01U20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000044cu, ImmutableString("imageAtomicOr(01V20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000002bcu, ImmutableString("imageAtomicOr(01W20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000004u, ImmutableString("imageAtomicOr(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x0000048du, ImmutableString("imageAtomicOr(01A10D00D").mangledNameHash());
    ASSERT_EQ(0x00000828u, ImmutableString("imageAtomicOr(01B10D00D").mangledNameHash());
    ASSERT_EQ(0x000002f3u, ImmutableString("imageAtomicOr(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x000004e0u, ImmutableString("imageAtomicOr(01D20D00D").mangledNameHash());
    ASSERT_EQ(0x000000adu, ImmutableString("imageAtomicOr(01E20D00D").mangledNameHash());
    ASSERT_EQ(0x00000658u, ImmutableString("imageAtomicOr(01I20D00D").mangledNameHash());
    ASSERT_EQ(0x000004f5u, ImmutableString("imageAtomicOr(01J20D00D").mangledNameHash());
    ASSERT_EQ(0x0000014eu, ImmutableString("imageAtomicOr(01K20D00D").mangledNameHash());
    ASSERT_EQ(0x00000532u, ImmutableString("imageAtomicOr(01g00D00D").mangledNameHash());
    ASSERT_EQ(0x0000056au, ImmutableString("imageAtomicOr(01h00D00D").mangledNameHash());
    ASSERT_EQ(0x000007feu, ImmutableString("imageAtomicOr(01i00D00D").mangledNameHash());
    ASSERT_EQ(0x000002d0u, ImmutableString("imageAtomicOr(01F20D00D").mangledNameHash());
    ASSERT_EQ(0x0000028bu, ImmutableString("imageAtomicOr(01G20D00D").mangledNameHash());
    ASSERT_EQ(0x00000850u, ImmutableString("imageAtomicOr(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x0000024eu, ImmutableString("imageAtomicOr(01a20D00D").mangledNameHash());
    ASSERT_EQ(0x00000839u, ImmutableString("imageAtomicOr(01b20D00D").mangledNameHash());
    ASSERT_EQ(0x00000515u, ImmutableString("imageAtomicOr(01c20D00D").mangledNameHash());
    ASSERT_EQ(0x00000120u, ImmutableString("imageAtomicOr(01L00D00D").mangledNameHash());
    ASSERT_EQ(0x0000009bu, ImmutableString("imageAtomicOr(01M00D00D").mangledNameHash());
    ASSERT_EQ(0x000006f4u, ImmutableString("imageAtomicOr(01N00D00D").mangledNameHash());
    ASSERT_EQ(0x000005c8u, ImmutableString("imageAtomicOr(01O10D00D").mangledNameHash());
    ASSERT_EQ(0x000000e4u, ImmutableString("imageAtomicOr(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x00000475u, ImmutableString("imageAtomicOr(01Q10D00D").mangledNameHash());
    ASSERT_EQ(0x000006a5u, ImmutableString("imageAtomicOr(01X10D00D").mangledNameHash());
    ASSERT_EQ(0x00000188u, ImmutableString("imageAtomicOr(01Y10D00D").mangledNameHash());
    ASSERT_EQ(0x0000050bu, ImmutableString("imageAtomicOr(01Z10D00D").mangledNameHash());
    ASSERT_EQ(0x000000bcu, ImmutableString("imageAtomicOr(01R10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000849u, ImmutableString("imageAtomicOr(01S10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000402u, ImmutableString("imageAtomicOr(01T10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006b0u, ImmutableString("imageAtomicOr(01U20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000044bu, ImmutableString("imageAtomicOr(01V20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002bdu, ImmutableString("imageAtomicOr(01W20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000074u, ImmutableString("imageAtomicXor(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x0000040cu, ImmutableString("imageAtomicXor(01A10D00E").mangledNameHash());
    ASSERT_EQ(0x00000133u, ImmutableString("imageAtomicXor(01B10D00E").mangledNameHash());
    ASSERT_EQ(0x00000581u, ImmutableString("imageAtomicXor(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x0000062au, ImmutableString("imageAtomicXor(01D20D00E").mangledNameHash());
    ASSERT_EQ(0x00000857u, ImmutableString("imageAtomicXor(01E20D00E").mangledNameHash());
    ASSERT_EQ(0x000001f3u, ImmutableString("imageAtomicXor(01I20D00E").mangledNameHash());
    ASSERT_EQ(0x000007e7u, ImmutableString("imageAtomicXor(01J20D00E").mangledNameHash());
    ASSERT_EQ(0x0000072fu, ImmutableString("imageAtomicXor(01K20D00E").mangledNameHash());
    ASSERT_EQ(0x000002f5u, ImmutableString("imageAtomicXor(01g00D00E").mangledNameHash());
    ASSERT_EQ(0x0000023cu, ImmutableString("imageAtomicXor(01h00D00E").mangledNameHash());
    ASSERT_EQ(0x000005afu, ImmutableString("imageAtomicXor(01i00D00E").mangledNameHash());
    ASSERT_EQ(0x00000132u, ImmutableString("imageAtomicXor(01F20D00E").mangledNameHash());
    ASSERT_EQ(0x00000753u, ImmutableString("imageAtomicXor(01G20D00E").mangledNameHash());
    ASSERT_EQ(0x000000a6u, ImmutableString("imageAtomicXor(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x0000007eu, ImmutableString("imageAtomicXor(01a20D00E").mangledNameHash());
    ASSERT_EQ(0x000001b4u, ImmutableString("imageAtomicXor(01b20D00E").mangledNameHash());
    ASSERT_EQ(0x00000465u, ImmutableString("imageAtomicXor(01c20D00E").mangledNameHash());
    ASSERT_EQ(0x00000194u, ImmutableString("imageAtomicXor(01L00D00E").mangledNameHash());
    ASSERT_EQ(0x0000054bu, ImmutableString("imageAtomicXor(01M00D00E").mangledNameHash());
    ASSERT_EQ(0x00000326u, ImmutableString("imageAtomicXor(01N00D00E").mangledNameHash());
    ASSERT_EQ(0x000007c5u, ImmutableString("imageAtomicXor(01O10D00E").mangledNameHash());
    ASSERT_EQ(0x00000657u, ImmutableString("imageAtomicXor(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x000005c0u, ImmutableString("imageAtomicXor(01Q10D00E").mangledNameHash());
    ASSERT_EQ(0x0000051au, ImmutableString("imageAtomicXor(01X10D00E").mangledNameHash());
    ASSERT_EQ(0x00000061u, ImmutableString("imageAtomicXor(01Y10D00E").mangledNameHash());
    ASSERT_EQ(0x0000074eu, ImmutableString("imageAtomicXor(01Z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000166u, ImmutableString("imageAtomicXor(01R10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000001dcu, ImmutableString("imageAtomicXor(01S10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000737u, ImmutableString("imageAtomicXor(01T10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000001ecu, ImmutableString("imageAtomicXor(01U20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000503u, ImmutableString("imageAtomicXor(01V20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000074cu, ImmutableString("imageAtomicXor(01W20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000041fu, ImmutableString("imageAtomicXor(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x0000040bu, ImmutableString("imageAtomicXor(01A10D00D").mangledNameHash());
    ASSERT_EQ(0x00000727u, ImmutableString("imageAtomicXor(01B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000816u, ImmutableString("imageAtomicXor(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x000000b6u, ImmutableString("imageAtomicXor(01D20D00D").mangledNameHash());
    ASSERT_EQ(0x00000858u, ImmutableString("imageAtomicXor(01E20D00D").mangledNameHash());
    ASSERT_EQ(0x000001f4u, ImmutableString("imageAtomicXor(01I20D00D").mangledNameHash());
    ASSERT_EQ(0x000007e6u, ImmutableString("imageAtomicXor(01J20D00D").mangledNameHash());
    ASSERT_EQ(0x00000730u, ImmutableString("imageAtomicXor(01K20D00D").mangledNameHash());
    ASSERT_EQ(0x000002fcu, ImmutableString("imageAtomicXor(01g00D00D").mangledNameHash());
    ASSERT_EQ(0x0000023bu, ImmutableString("imageAtomicXor(01h00D00D").mangledNameHash());
    ASSERT_EQ(0x000007dfu, ImmutableString("imageAtomicXor(01i00D00D").mangledNameHash());
    ASSERT_EQ(0x00000786u, ImmutableString("imageAtomicXor(01F20D00D").mangledNameHash());
    ASSERT_EQ(0x00000754u, ImmutableString("imageAtomicXor(01G20D00D").mangledNameHash());
    ASSERT_EQ(0x000000a5u, ImmutableString("imageAtomicXor(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x0000007fu, ImmutableString("imageAtomicXor(01a20D00D").mangledNameHash());
    ASSERT_EQ(0x00000224u, ImmutableString("imageAtomicXor(01b20D00D").mangledNameHash());
    ASSERT_EQ(0x00000466u, ImmutableString("imageAtomicXor(01c20D00D").mangledNameHash());
    ASSERT_EQ(0x0000030bu, ImmutableString("imageAtomicXor(01L00D00D").mangledNameHash());
    ASSERT_EQ(0x0000068au, ImmutableString("imageAtomicXor(01M00D00D").mangledNameHash());
    ASSERT_EQ(0x00000325u, ImmutableString("imageAtomicXor(01N00D00D").mangledNameHash());
    ASSERT_EQ(0x000007c4u, ImmutableString("imageAtomicXor(01O10D00D").mangledNameHash());
    ASSERT_EQ(0x00000272u, ImmutableString("imageAtomicXor(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x000005bfu, ImmutableString("imageAtomicXor(01Q10D00D").mangledNameHash());
    ASSERT_EQ(0x0000051bu, ImmutableString("imageAtomicXor(01X10D00D").mangledNameHash());
    ASSERT_EQ(0x00000060u, ImmutableString("imageAtomicXor(01Y10D00D").mangledNameHash());
    ASSERT_EQ(0x0000074fu, ImmutableString("imageAtomicXor(01Z10D00D").mangledNameHash());
    ASSERT_EQ(0x00000037u, ImmutableString("imageAtomicXor(01R10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000001ddu, ImmutableString("imageAtomicXor(01S10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000736u, ImmutableString("imageAtomicXor(01T10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000001ebu, ImmutableString("imageAtomicXor(01U20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000504u, ImmutableString("imageAtomicXor(01V20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000074bu, ImmutableString("imageAtomicXor(01W20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000004fbu, ImmutableString("imageAtomicExchange(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000222u, ImmutableString("imageAtomicExchange(01A10D00E").mangledNameHash());
    ASSERT_EQ(0x0000080fu, ImmutableString("imageAtomicExchange(01B10D00E").mangledNameHash());
    ASSERT_EQ(0x000007a7u, ImmutableString("imageAtomicExchange(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x00000365u, ImmutableString("imageAtomicExchange(01D20D00E").mangledNameHash());
    ASSERT_EQ(0x00000343u, ImmutableString("imageAtomicExchange(01E20D00E").mangledNameHash());
    ASSERT_EQ(0x00000458u, ImmutableString("imageAtomicExchange(01I20D00E").mangledNameHash());
    ASSERT_EQ(0x000003d6u, ImmutableString("imageAtomicExchange(01J20D00E").mangledNameHash());
    ASSERT_EQ(0x000007dbu, ImmutableString("imageAtomicExchange(01K20D00E").mangledNameHash());
    ASSERT_EQ(0x00000001u, ImmutableString("imageAtomicExchange(01g00D00E").mangledNameHash());
    ASSERT_EQ(0x000004ecu, ImmutableString("imageAtomicExchange(01h00D00E").mangledNameHash());
    ASSERT_EQ(0x0000004bu, ImmutableString("imageAtomicExchange(01i00D00E").mangledNameHash());
    ASSERT_EQ(0x00000433u, ImmutableString("imageAtomicExchange(01F20D00E").mangledNameHash());
    ASSERT_EQ(0x000005fau, ImmutableString("imageAtomicExchange(01G20D00E").mangledNameHash());
    ASSERT_EQ(0x00000650u, ImmutableString("imageAtomicExchange(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x0000076du, ImmutableString("imageAtomicExchange(01a20D00E").mangledNameHash());
    ASSERT_EQ(0x00000043u, ImmutableString("imageAtomicExchange(01b20D00E").mangledNameHash());
    ASSERT_EQ(0x0000045au, ImmutableString("imageAtomicExchange(01c20D00E").mangledNameHash());
    ASSERT_EQ(0x000003a3u, ImmutableString("imageAtomicExchange(01L00D00E").mangledNameHash());
    ASSERT_EQ(0x000001b9u, ImmutableString("imageAtomicExchange(01M00D00E").mangledNameHash());
    ASSERT_EQ(0x00000630u, ImmutableString("imageAtomicExchange(01N00D00E").mangledNameHash());
    ASSERT_EQ(0x00000627u, ImmutableString("imageAtomicExchange(01O10D00E").mangledNameHash());
    ASSERT_EQ(0x00000451u, ImmutableString("imageAtomicExchange(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x0000029du, ImmutableString("imageAtomicExchange(01Q10D00E").mangledNameHash());
    ASSERT_EQ(0x0000029au, ImmutableString("imageAtomicExchange(01X10D00E").mangledNameHash());
    ASSERT_EQ(0x00000624u, ImmutableString("imageAtomicExchange(01Y10D00E").mangledNameHash());
    ASSERT_EQ(0x0000038du, ImmutableString("imageAtomicExchange(01Z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000430u, ImmutableString("imageAtomicExchange(01R10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000172u, ImmutableString("imageAtomicExchange(01S10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000015cu, ImmutableString("imageAtomicExchange(01T10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000005d0u, ImmutableString("imageAtomicExchange(01U20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000020cu, ImmutableString("imageAtomicExchange(01V20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000002b7u, ImmutableString("imageAtomicExchange(01W20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000004fcu, ImmutableString("imageAtomicExchange(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x00000223u, ImmutableString("imageAtomicExchange(01A10D00D").mangledNameHash());
    ASSERT_EQ(0x0000080eu, ImmutableString("imageAtomicExchange(01B10D00D").mangledNameHash());
    ASSERT_EQ(0x000007a6u, ImmutableString("imageAtomicExchange(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x0000049bu, ImmutableString("imageAtomicExchange(01D20D00D").mangledNameHash());
    ASSERT_EQ(0x00000340u, ImmutableString("imageAtomicExchange(01E20D00D").mangledNameHash());
    ASSERT_EQ(0x00000457u, ImmutableString("imageAtomicExchange(01I20D00D").mangledNameHash());
    ASSERT_EQ(0x000003d7u, ImmutableString("imageAtomicExchange(01J20D00D").mangledNameHash());
    ASSERT_EQ(0x00000521u, ImmutableString("imageAtomicExchange(01K20D00D").mangledNameHash());
    ASSERT_EQ(0x00000680u, ImmutableString("imageAtomicExchange(01g00D00D").mangledNameHash());
    ASSERT_EQ(0x000004edu, ImmutableString("imageAtomicExchange(01h00D00D").mangledNameHash());
    ASSERT_EQ(0x00000435u, ImmutableString("imageAtomicExchange(01i00D00D").mangledNameHash());
    ASSERT_EQ(0x000000b2u, ImmutableString("imageAtomicExchange(01F20D00D").mangledNameHash());
    ASSERT_EQ(0x000005f9u, ImmutableString("imageAtomicExchange(01G20D00D").mangledNameHash());
    ASSERT_EQ(0x00000651u, ImmutableString("imageAtomicExchange(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x0000076cu, ImmutableString("imageAtomicExchange(01a20D00D").mangledNameHash());
    ASSERT_EQ(0x00000044u, ImmutableString("imageAtomicExchange(01b20D00D").mangledNameHash());
    ASSERT_EQ(0x00000676u, ImmutableString("imageAtomicExchange(01c20D00D").mangledNameHash());
    ASSERT_EQ(0x000004c3u, ImmutableString("imageAtomicExchange(01L00D00D").mangledNameHash());
    ASSERT_EQ(0x000001b8u, ImmutableString("imageAtomicExchange(01M00D00D").mangledNameHash());
    ASSERT_EQ(0x00000631u, ImmutableString("imageAtomicExchange(01N00D00D").mangledNameHash());
    ASSERT_EQ(0x00000316u, ImmutableString("imageAtomicExchange(01O10D00D").mangledNameHash());
    ASSERT_EQ(0x0000044du, ImmutableString("imageAtomicExchange(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x0000029eu, ImmutableString("imageAtomicExchange(01Q10D00D").mangledNameHash());
    ASSERT_EQ(0x00000299u, ImmutableString("imageAtomicExchange(01X10D00D").mangledNameHash());
    ASSERT_EQ(0x00000625u, ImmutableString("imageAtomicExchange(01Y10D00D").mangledNameHash());
    ASSERT_EQ(0x00000382u, ImmutableString("imageAtomicExchange(01Z10D00D").mangledNameHash());
    ASSERT_EQ(0x00000431u, ImmutableString("imageAtomicExchange(01R10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000268u, ImmutableString("imageAtomicExchange(01S10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000015du, ImmutableString("imageAtomicExchange(01T10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000005d4u, ImmutableString("imageAtomicExchange(01U20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000003d4u, ImmutableString("imageAtomicExchange(01V20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002b8u, ImmutableString("imageAtomicExchange(01W20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000004fau, ImmutableString("imageAtomicExchange(00z10D00B").mangledNameHash());
    ASSERT_EQ(0x00000220u, ImmutableString("imageAtomicExchange(01A10D00B").mangledNameHash());
    ASSERT_EQ(0x0000080cu, ImmutableString("imageAtomicExchange(01B10D00B").mangledNameHash());
    ASSERT_EQ(0x000007aau, ImmutableString("imageAtomicExchange(01C20D00B").mangledNameHash());
    ASSERT_EQ(0x00000367u, ImmutableString("imageAtomicExchange(01D20D00B").mangledNameHash());
    ASSERT_EQ(0x000001f1u, ImmutableString("imageAtomicExchange(01E20D00B").mangledNameHash());
    ASSERT_EQ(0x00000459u, ImmutableString("imageAtomicExchange(01I20D00B").mangledNameHash());
    ASSERT_EQ(0x000003d5u, ImmutableString("imageAtomicExchange(01J20D00B").mangledNameHash());
    ASSERT_EQ(0x000007ddu, ImmutableString("imageAtomicExchange(01K20D00B").mangledNameHash());
    ASSERT_EQ(0x0000080bu, ImmutableString("imageAtomicExchange(01g00D00B").mangledNameHash());
    ASSERT_EQ(0x000004efu, ImmutableString("imageAtomicExchange(01h00D00B").mangledNameHash());
    ASSERT_EQ(0x00000437u, ImmutableString("imageAtomicExchange(01i00D00B").mangledNameHash());
    ASSERT_EQ(0x000000b3u, ImmutableString("imageAtomicExchange(01F20D00B").mangledNameHash());
    ASSERT_EQ(0x000005f7u, ImmutableString("imageAtomicExchange(01G20D00B").mangledNameHash());
    ASSERT_EQ(0x0000064du, ImmutableString("imageAtomicExchange(01H20D00B").mangledNameHash());
    ASSERT_EQ(0x0000076eu, ImmutableString("imageAtomicExchange(01a20D00B").mangledNameHash());
    ASSERT_EQ(0x00000042u, ImmutableString("imageAtomicExchange(01b20D00B").mangledNameHash());
    ASSERT_EQ(0x0000067au, ImmutableString("imageAtomicExchange(01c20D00B").mangledNameHash());
    ASSERT_EQ(0x000003a2u, ImmutableString("imageAtomicExchange(01L00D00B").mangledNameHash());
    ASSERT_EQ(0x000001b7u, ImmutableString("imageAtomicExchange(01M00D00B").mangledNameHash());
    ASSERT_EQ(0x0000062eu, ImmutableString("imageAtomicExchange(01N00D00B").mangledNameHash());
    ASSERT_EQ(0x00000626u, ImmutableString("imageAtomicExchange(01O10D00B").mangledNameHash());
    ASSERT_EQ(0x0000027du, ImmutableString("imageAtomicExchange(01P10D00B").mangledNameHash());
    ASSERT_EQ(0x0000075eu, ImmutableString("imageAtomicExchange(01Q10D00B").mangledNameHash());
    ASSERT_EQ(0x00000756u, ImmutableString("imageAtomicExchange(01X10D00B").mangledNameHash());
    ASSERT_EQ(0x00000622u, ImmutableString("imageAtomicExchange(01Y10D00B").mangledNameHash());
    ASSERT_EQ(0x000007acu, ImmutableString("imageAtomicExchange(01Z10D00B").mangledNameHash());
    ASSERT_EQ(0x0000001eu, ImmutableString("imageAtomicExchange(01R10D00D00B").mangledNameHash());
    ASSERT_EQ(0x000001c5u, ImmutableString("imageAtomicExchange(01S10D00D00B").mangledNameHash());
    ASSERT_EQ(0x000001d2u, ImmutableString("imageAtomicExchange(01T10D00D00B").mangledNameHash());
    ASSERT_EQ(0x000005cdu, ImmutableString("imageAtomicExchange(01U20D00D00B").mangledNameHash());
    ASSERT_EQ(0x0000020du, ImmutableString("imageAtomicExchange(01V20D00D00B").mangledNameHash());
    ASSERT_EQ(0x000002b5u, ImmutableString("imageAtomicExchange(01W20D00D00B").mangledNameHash());
    ASSERT_EQ(0x000003fau, ImmutableString("imageAtomicCompSwap(00z10D00E00E").mangledNameHash());
    ASSERT_EQ(0x000003f0u, ImmutableString("imageAtomicCompSwap(01A10D00E00E").mangledNameHash());
    ASSERT_EQ(0x000001a3u, ImmutableString("imageAtomicCompSwap(01B10D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000780u, ImmutableString("imageAtomicCompSwap(01C20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000006ecu, ImmutableString("imageAtomicCompSwap(01D20D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000124u, ImmutableString("imageAtomicCompSwap(01E20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000000cfu, ImmutableString("imageAtomicCompSwap(01I20D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000051u, ImmutableString("imageAtomicCompSwap(01J20D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000846u, ImmutableString("imageAtomicCompSwap(01K20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007c1u, ImmutableString("imageAtomicCompSwap(01g00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000001feu, ImmutableString("imageAtomicCompSwap(01h00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000006c3u, ImmutableString("imageAtomicCompSwap(01i00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000001fau, ImmutableString("imageAtomicCompSwap(01F20D00E00E").mangledNameHash());
    ASSERT_EQ(0x0000033au, ImmutableString("imageAtomicCompSwap(01G20D00E00E").mangledNameHash());
    ASSERT_EQ(0x0000064fu, ImmutableString("imageAtomicCompSwap(01H20D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000027u, ImmutableString("imageAtomicCompSwap(01a20D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000137u, ImmutableString("imageAtomicCompSwap(01b20D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000552u, ImmutableString("imageAtomicCompSwap(01c20D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000589u, ImmutableString("imageAtomicCompSwap(01L00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000002a9u, ImmutableString("imageAtomicCompSwap(01M00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000003ffu, ImmutableString("imageAtomicCompSwap(01N00D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000130u, ImmutableString("imageAtomicCompSwap(01O10D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000086u, ImmutableString("imageAtomicCompSwap(01P10D00E00E").mangledNameHash());
    ASSERT_EQ(0x0000048eu, ImmutableString("imageAtomicCompSwap(01Q10D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000107u, ImmutableString("imageAtomicCompSwap(01X10D00E00E").mangledNameHash());
    ASSERT_EQ(0x0000020eu, ImmutableString("imageAtomicCompSwap(01Y10D00E00E").mangledNameHash());
    ASSERT_EQ(0x000006b5u, ImmutableString("imageAtomicCompSwap(01Z10D00E00E").mangledNameHash());
    ASSERT_EQ(0x0000037bu,
              ImmutableString("imageAtomicCompSwap(01R10D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000464u,
              ImmutableString("imageAtomicCompSwap(01S10D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000191u,
              ImmutableString("imageAtomicCompSwap(01T10D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000667u,
              ImmutableString("imageAtomicCompSwap(01U20D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x0000073eu,
              ImmutableString("imageAtomicCompSwap(01V20D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000054u,
              ImmutableString("imageAtomicCompSwap(01W20D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000770u, ImmutableString("imageAtomicCompSwap(00z10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000067u, ImmutableString("imageAtomicCompSwap(01A10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006a4u, ImmutableString("imageAtomicCompSwap(01B10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000040du, ImmutableString("imageAtomicCompSwap(01C20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000038u, ImmutableString("imageAtomicCompSwap(01D20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000000cu, ImmutableString("imageAtomicCompSwap(01E20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002a7u, ImmutableString("imageAtomicCompSwap(01I20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000391u, ImmutableString("imageAtomicCompSwap(01J20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006c4u, ImmutableString("imageAtomicCompSwap(01K20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000697u, ImmutableString("imageAtomicCompSwap(01g00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002ecu, ImmutableString("imageAtomicCompSwap(01h00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000479u, ImmutableString("imageAtomicCompSwap(01i00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002dbu, ImmutableString("imageAtomicCompSwap(01F20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000025au, ImmutableString("imageAtomicCompSwap(01G20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000010cu, ImmutableString("imageAtomicCompSwap(01H20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000558u, ImmutableString("imageAtomicCompSwap(01a20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000002du, ImmutableString("imageAtomicCompSwap(01b20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000044au, ImmutableString("imageAtomicCompSwap(01c20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000060fu, ImmutableString("imageAtomicCompSwap(01L00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000184u, ImmutableString("imageAtomicCompSwap(01M00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000060eu, ImmutableString("imageAtomicCompSwap(01N00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000633u, ImmutableString("imageAtomicCompSwap(01O10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000067cu, ImmutableString("imageAtomicCompSwap(01P10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000195u, ImmutableString("imageAtomicCompSwap(01Q10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000842u, ImmutableString("imageAtomicCompSwap(01X10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000065bu, ImmutableString("imageAtomicCompSwap(01Y10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002b3u, ImmutableString("imageAtomicCompSwap(01Z10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000028u,
              ImmutableString("imageAtomicCompSwap(01R10D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000061cu,
              ImmutableString("imageAtomicCompSwap(01S10D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000006fu,
              ImmutableString("imageAtomicCompSwap(01T10D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000539u,
              ImmutableString("imageAtomicCompSwap(01U20D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000221u,
              ImmutableString("imageAtomicCompSwap(01V20D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007cfu,
              ImmutableString("imageAtomicCompSwap(01W20D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000032au, ImmutableString("imageLoad(00z10D").mangledNameHash());
    ASSERT_EQ(0x0000064au, ImmutableString("imageLoad(01A10D").mangledNameHash());
    ASSERT_EQ(0x00000312u, ImmutableString("imageLoad(01B10D").mangledNameHash());
    ASSERT_EQ(0x000006ffu, ImmutableString("imageLoad(01C20D").mangledNameHash());
    ASSERT_EQ(0x000001d9u, ImmutableString("imageLoad(01D20D").mangledNameHash());
    ASSERT_EQ(0x000007f7u, ImmutableString("imageLoad(01E20D").mangledNameHash());
    ASSERT_EQ(0x0000002bu, ImmutableString("imageLoad(01F20D").mangledNameHash());
    ASSERT_EQ(0x00000778u, ImmutableString("imageLoad(01G20D").mangledNameHash());
    ASSERT_EQ(0x00000292u, ImmutableString("imageLoad(01H20D").mangledNameHash());
    ASSERT_EQ(0x0000000au, ImmutableString("imageLoad(01I20D").mangledNameHash());
    ASSERT_EQ(0x00000547u, ImmutableString("imageLoad(01J20D").mangledNameHash());
    ASSERT_EQ(0x000000bdu, ImmutableString("imageLoad(01K20D").mangledNameHash());
    ASSERT_EQ(0x00000008u, ImmutableString("imageLoad(01g00D").mangledNameHash());
    ASSERT_EQ(0x00000123u, ImmutableString("imageLoad(01h00D").mangledNameHash());
    ASSERT_EQ(0x00000263u, ImmutableString("imageLoad(01i00D").mangledNameHash());
    ASSERT_EQ(0x0000041au, ImmutableString("imageLoad(01a20D").mangledNameHash());
    ASSERT_EQ(0x000006b4u, ImmutableString("imageLoad(01b20D").mangledNameHash());
    ASSERT_EQ(0x00000328u, ImmutableString("imageLoad(01c20D").mangledNameHash());
    ASSERT_EQ(0x0000044eu, ImmutableString("imageLoad(01L00D").mangledNameHash());
    ASSERT_EQ(0x00000588u, ImmutableString("imageLoad(01M00D").mangledNameHash());
    ASSERT_EQ(0x00000089u, ImmutableString("imageLoad(01N00D").mangledNameHash());
    ASSERT_EQ(0x00000276u, ImmutableString("imageLoad(01O10D").mangledNameHash());
    ASSERT_EQ(0x0000069du, ImmutableString("imageLoad(01P10D").mangledNameHash());
    ASSERT_EQ(0x0000042bu, ImmutableString("imageLoad(01Q10D").mangledNameHash());
    ASSERT_EQ(0x00000162u, ImmutableString("imageLoad(01X10D").mangledNameHash());
    ASSERT_EQ(0x000005fbu, ImmutableString("imageLoad(01Y10D").mangledNameHash());
    ASSERT_EQ(0x000005c6u, ImmutableString("imageLoad(01Z10D").mangledNameHash());
    ASSERT_EQ(0x000006d9u, ImmutableString("imageLoad(01R10D00D").mangledNameHash());
    ASSERT_EQ(0x000002d8u, ImmutableString("imageLoad(01S10D00D").mangledNameHash());
    ASSERT_EQ(0x00000139u, ImmutableString("imageLoad(01T10D00D").mangledNameHash());
    ASSERT_EQ(0x000006b8u, ImmutableString("imageLoad(01U20D00D").mangledNameHash());
    ASSERT_EQ(0x000000b0u, ImmutableString("imageLoad(01V20D00D").mangledNameHash());
    ASSERT_EQ(0x00000496u, ImmutableString("imageLoad(01W20D00D").mangledNameHash());
    ASSERT_EQ(0x00000093u, ImmutableString("imageStore(00z10D30B").mangledNameHash());
    ASSERT_EQ(0x000000a3u, ImmutableString("imageStore(01A10D30D").mangledNameHash());
    ASSERT_EQ(0x0000058du, ImmutableString("imageStore(01B10D30E").mangledNameHash());
    ASSERT_EQ(0x0000004eu, ImmutableString("imageStore(01C20D30B").mangledNameHash());
    ASSERT_EQ(0x00000359u, ImmutableString("imageStore(01D20D30D").mangledNameHash());
    ASSERT_EQ(0x000003c3u, ImmutableString("imageStore(01E20D30E").mangledNameHash());
    ASSERT_EQ(0x000004e1u, ImmutableString("imageStore(01F20D30B").mangledNameHash());
    ASSERT_EQ(0x000005c2u, ImmutableString("imageStore(01G20D30D").mangledNameHash());
    ASSERT_EQ(0x000005d5u, ImmutableString("imageStore(01H20D30E").mangledNameHash());
    ASSERT_EQ(0x00000592u, ImmutableString("imageStore(01I20D30B").mangledNameHash());
    ASSERT_EQ(0x000006c6u, ImmutableString("imageStore(01J20D30D").mangledNameHash());
    ASSERT_EQ(0x00000055u, ImmutableString("imageStore(01K20D30E").mangledNameHash());
    ASSERT_EQ(0x00000170u, ImmutableString("imageStore(01g00D30B").mangledNameHash());
    ASSERT_EQ(0x00000315u, ImmutableString("imageStore(01h00D30D").mangledNameHash());
    ASSERT_EQ(0x000000a2u, ImmutableString("imageStore(01i00D30E").mangledNameHash());
    ASSERT_EQ(0x00000290u, ImmutableString("imageStore(01a20D30B").mangledNameHash());
    ASSERT_EQ(0x0000055fu, ImmutableString("imageStore(01b20D30D").mangledNameHash());
    ASSERT_EQ(0x0000076bu, ImmutableString("imageStore(01c20D30E").mangledNameHash());
    ASSERT_EQ(0x000000b4u, ImmutableString("imageStore(01L00D30B").mangledNameHash());
    ASSERT_EQ(0x00000167u, ImmutableString("imageStore(01M00D30D").mangledNameHash());
    ASSERT_EQ(0x000000ffu, ImmutableString("imageStore(01N00D30E").mangledNameHash());
    ASSERT_EQ(0x000007a0u, ImmutableString("imageStore(01O10D30B").mangledNameHash());
    ASSERT_EQ(0x000004dau, ImmutableString("imageStore(01P10D30D").mangledNameHash());
    ASSERT_EQ(0x0000061du, ImmutableString("imageStore(01Q10D30E").mangledNameHash());
    ASSERT_EQ(0x00000837u, ImmutableString("imageStore(01X10D30B").mangledNameHash());
    ASSERT_EQ(0x0000042du, ImmutableString("imageStore(01Y10D30D").mangledNameHash());
    ASSERT_EQ(0x00000678u, ImmutableString("imageStore(01Z10D30E").mangledNameHash());
    ASSERT_EQ(0x000003b4u, ImmutableString("imageStore(01R10D00D30B").mangledNameHash());
    ASSERT_EQ(0x00000654u, ImmutableString("imageStore(01S10D00D30D").mangledNameHash());
    ASSERT_EQ(0x0000034cu, ImmutableString("imageStore(01T10D00D30E").mangledNameHash());
    ASSERT_EQ(0x000006e5u, ImmutableString("imageStore(01U20D00D30B").mangledNameHash());
    ASSERT_EQ(0x0000027fu, ImmutableString("imageStore(01V20D00D30D").mangledNameHash());
    ASSERT_EQ(0x000003f6u, ImmutableString("imageStore(01W20D00D30E").mangledNameHash());
    ASSERT_EQ(0x00000587u, ImmutableString("noise1(00B").mangledNameHash());
    ASSERT_EQ(0x00000640u, ImmutableString("noise1(10B").mangledNameHash());
    ASSERT_EQ(0x00000413u, ImmutableString("noise1(20B").mangledNameHash());
    ASSERT_EQ(0x00000305u, ImmutableString("noise1(30B").mangledNameHash());
    ASSERT_EQ(0x000002adu, ImmutableString("noise2(00B").mangledNameHash());
    ASSERT_EQ(0x000000c4u, ImmutableString("noise2(10B").mangledNameHash());
    ASSERT_EQ(0x0000008au, ImmutableString("noise2(20B").mangledNameHash());
    ASSERT_EQ(0x000006a7u, ImmutableString("noise2(30B").mangledNameHash());
    ASSERT_EQ(0x0000028au, ImmutableString("noise3(00B").mangledNameHash());
    ASSERT_EQ(0x0000031bu, ImmutableString("noise3(10B").mangledNameHash());
    ASSERT_EQ(0x000006c9u, ImmutableString("noise3(20B").mangledNameHash());
    ASSERT_EQ(0x000001e5u, ImmutableString("noise3(30B").mangledNameHash());
    ASSERT_EQ(0x0000030fu, ImmutableString("noise4(00B").mangledNameHash());
    ASSERT_EQ(0x00000284u, ImmutableString("noise4(10B").mangledNameHash());
    ASSERT_EQ(0x000000fdu, ImmutableString("noise4(20B").mangledNameHash());
    ASSERT_EQ(0x0000063eu, ImmutableString("noise4(30B").mangledNameHash());
    ASSERT_EQ(0x0000051cu, ImmutableString("memoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x00000691u, ImmutableString("memoryBarrierAtomicCounter(").mangledNameHash());
    ASSERT_EQ(0x000000eeu, ImmutableString("memoryBarrierBuffer(").mangledNameHash());
    ASSERT_EQ(0x0000082eu, ImmutableString("memoryBarrierImage(").mangledNameHash());
    ASSERT_EQ(0x000006f2u, ImmutableString("barrier(").mangledNameHash());
    ASSERT_EQ(0x0000081cu, ImmutableString("memoryBarrierShared(").mangledNameHash());
    ASSERT_EQ(0x00000041u, ImmutableString("groupMemoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x00000207u, ImmutableString("EmitVertex(").mangledNameHash());
    ASSERT_EQ(0x00000377u, ImmutableString("EndPrimitive(").mangledNameHash());
    ASSERT_EQ(0x000001bdu, ImmutableString("EmitStreamVertex(00D").mangledNameHash());
    ASSERT_EQ(0x0000026fu, ImmutableString("EndStreamPrimitive(00D").mangledNameHash());
    ASSERT_EQ(0x000006dcu, ImmutableString("subpassLoad(01j").mangledNameHash());
    ASSERT_EQ(0x000006bau, ImmutableString("subpassLoad(01k").mangledNameHash());
    ASSERT_EQ(0x000006bdu, ImmutableString("subpassLoad(01l").mangledNameHash());
    ASSERT_EQ(0x00000280u, ImmutableString("subpassLoad(01m00D").mangledNameHash());
    ASSERT_EQ(0x00000551u, ImmutableString("subpassLoad(01n00D").mangledNameHash());
    ASSERT_EQ(0x00000685u, ImmutableString("subpassLoad(01o00D").mangledNameHash());
    ASSERT_EQ(0x000006eau, ImmutableString("anyInvocation(00F").mangledNameHash());
    ASSERT_EQ(0x00000594u, ImmutableString("allInvocations(00F").mangledNameHash());
    ASSERT_EQ(0x000004a0u, ImmutableString("allInvocationsEqual(00F").mangledNameHash());
    ASSERT_EQ(0x00000507u, ImmutableString("textureVideoWEBGL(00y10B").mangledNameHash());
    ASSERT_EQ(0x0000058au, ImmutableString("texture(00y10B").mangledNameHash());
    ASSERT_EQ(0x0000063du, ImmutableString("gl_DepthRangeParameters").mangledNameHash());
    ASSERT_EQ(0x00000119u, ImmutableString("gl_DepthRange").mangledNameHash());
    ASSERT_EQ(0x00000808u, ImmutableString("gl_MaxVertexAttribs").mangledNameHash());
    ASSERT_EQ(0x000002b4u, ImmutableString("gl_MaxVertexUniformVectors").mangledNameHash());
    ASSERT_EQ(0x0000019bu, ImmutableString("gl_MaxVertexTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x000004b6u, ImmutableString("gl_MaxCombinedTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x000004ceu, ImmutableString("gl_MaxTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x000005e1u, ImmutableString("gl_MaxFragmentUniformVectors").mangledNameHash());
    ASSERT_EQ(0x00000614u, ImmutableString("gl_MaxVaryingVectors").mangledNameHash());
    ASSERT_EQ(0x000004b2u, ImmutableString("gl_MaxDrawBuffers").mangledNameHash());
    ASSERT_EQ(0x0000016bu, ImmutableString("gl_MaxDualSourceDrawBuffersEXT").mangledNameHash());
    ASSERT_EQ(0x000007fdu, ImmutableString("gl_MaxVertexOutputVectors").mangledNameHash());
    ASSERT_EQ(0x00000056u, ImmutableString("gl_MaxFragmentInputVectors").mangledNameHash());
    ASSERT_EQ(0x00000512u, ImmutableString("gl_MinProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x0000078fu, ImmutableString("gl_MaxProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x00000473u, ImmutableString("gl_MaxImageUnits").mangledNameHash());
    ASSERT_EQ(0x000007e0u, ImmutableString("gl_MaxVertexImageUniforms").mangledNameHash());
    ASSERT_EQ(0x0000013cu, ImmutableString("gl_MaxFragmentImageUniforms").mangledNameHash());
    ASSERT_EQ(0x0000021eu, ImmutableString("gl_MaxComputeImageUniforms").mangledNameHash());
    ASSERT_EQ(0x00000530u, ImmutableString("gl_MaxCombinedImageUniforms").mangledNameHash());
    ASSERT_EQ(0x0000006eu,
              ImmutableString("gl_MaxCombinedShaderOutputResources").mangledNameHash());
    ASSERT_EQ(0x00000260u, ImmutableString("gl_MaxComputeWorkGroupCount").mangledNameHash());
    ASSERT_EQ(0x00000498u, ImmutableString("gl_MaxComputeWorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x00000122u, ImmutableString("gl_MaxComputeUniformComponents").mangledNameHash());
    ASSERT_EQ(0x0000009cu, ImmutableString("gl_MaxComputeTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000375u, ImmutableString("gl_MaxComputeAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x000001a4u, ImmutableString("gl_MaxComputeAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x0000015eu, ImmutableString("gl_MaxVertexAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000177u, ImmutableString("gl_MaxFragmentAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x0000060cu, ImmutableString("gl_MaxCombinedAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000021u, ImmutableString("gl_MaxAtomicCounterBindings").mangledNameHash());
    ASSERT_EQ(0x00000254u, ImmutableString("gl_MaxVertexAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x0000030du, ImmutableString("gl_MaxFragmentAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x0000057bu, ImmutableString("gl_MaxCombinedAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x000007d0u, ImmutableString("gl_MaxAtomicCounterBufferSize").mangledNameHash());
    ASSERT_EQ(0x0000045bu, ImmutableString("gl_MaxGeometryInputComponents").mangledNameHash());
    ASSERT_EQ(0x00000304u, ImmutableString("gl_MaxGeometryOutputComponents").mangledNameHash());
    ASSERT_EQ(0x000000fau, ImmutableString("gl_MaxGeometryImageUniforms").mangledNameHash());
    ASSERT_EQ(0x000003c8u, ImmutableString("gl_MaxGeometryTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x000000a4u, ImmutableString("gl_MaxGeometryOutputVertices").mangledNameHash());
    ASSERT_EQ(0x000007d6u,
              ImmutableString("gl_MaxGeometryTotalOutputComponents").mangledNameHash());
    ASSERT_EQ(0x00000852u, ImmutableString("gl_MaxGeometryUniformComponents").mangledNameHash());
    ASSERT_EQ(0x00000769u, ImmutableString("gl_MaxGeometryAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000724u, ImmutableString("gl_MaxGeometryAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x00000481u, ImmutableString("gl_FragCoord").mangledNameHash());
    ASSERT_EQ(0x0000019eu, ImmutableString("gl_FrontFacing").mangledNameHash());
    ASSERT_EQ(0x000004ddu, ImmutableString("gl_PointCoord").mangledNameHash());
    ASSERT_EQ(0x00000265u, ImmutableString("gl_FragColor").mangledNameHash());
    ASSERT_EQ(0x000007f9u, ImmutableString("gl_FragData").mangledNameHash());
    ASSERT_EQ(0x000003bcu, ImmutableString("gl_FragDepth").mangledNameHash());
    ASSERT_EQ(0x00000564u, ImmutableString("gl_HelperInvocation").mangledNameHash());
    ASSERT_EQ(0x000001afu, ImmutableString("gl_SecondaryFragColorEXT").mangledNameHash());
    ASSERT_EQ(0x00000746u, ImmutableString("gl_SecondaryFragDataEXT").mangledNameHash());
    ASSERT_EQ(0x000002dfu, ImmutableString("gl_FragDepthEXT").mangledNameHash());
    ASSERT_EQ(0x00000083u, ImmutableString("gl_LastFragData").mangledNameHash());
    ASSERT_EQ(0x00000663u, ImmutableString("gl_LastFragColor").mangledNameHash());
    ASSERT_EQ(0x000001a9u, ImmutableString("gl_LastFragColorARM").mangledNameHash());
    ASSERT_EQ(0x0000065au, ImmutableString("gl_PrimitiveID").mangledNameHash());
    ASSERT_EQ(0x0000065du, ImmutableString("gl_Layer").mangledNameHash());
    ASSERT_EQ(0x000003d0u, ImmutableString("gl_Position").mangledNameHash());
    ASSERT_EQ(0x000001f9u, ImmutableString("gl_PointSize").mangledNameHash());
    ASSERT_EQ(0x00000109u, ImmutableString("gl_InstanceID").mangledNameHash());
    ASSERT_EQ(0x00000536u, ImmutableString("gl_VertexID").mangledNameHash());
    ASSERT_EQ(0x00000428u, ImmutableString("gl_DrawID").mangledNameHash());
    ASSERT_EQ(0x000007d3u, ImmutableString("gl_BaseVertex").mangledNameHash());
    ASSERT_EQ(0x000001b2u, ImmutableString("gl_BaseInstance").mangledNameHash());
    ASSERT_EQ(0x00000454u, ImmutableString("angle_BaseVertex").mangledNameHash());
    ASSERT_EQ(0x000003cdu, ImmutableString("angle_BaseInstance").mangledNameHash());
    ASSERT_EQ(0x00000100u, ImmutableString("gl_NumWorkGroups").mangledNameHash());
    ASSERT_EQ(0x00000334u, ImmutableString("gl_WorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x00000761u, ImmutableString("gl_WorkGroupID").mangledNameHash());
    ASSERT_EQ(0x00000721u, ImmutableString("gl_LocalInvocationID").mangledNameHash());
    ASSERT_EQ(0x00000534u, ImmutableString("gl_GlobalInvocationID").mangledNameHash());
    ASSERT_EQ(0x00000535u, ImmutableString("gl_LocalInvocationIndex").mangledNameHash());
    ASSERT_EQ(0x000007bau, ImmutableString("gl_PrimitiveIDIn").mangledNameHash());
    ASSERT_EQ(0x000000bfu, ImmutableString("gl_InvocationID").mangledNameHash());
    ASSERT_EQ(0x00000330u, ImmutableString("gl_PerVertex").mangledNameHash());
    ASSERT_EQ(0x0000030eu, ImmutableString("gl_in").mangledNameHash());
    ASSERT_EQ(0x0000020fu, ImmutableString("gl_ViewID_OVR").mangledNameHash());
    ASSERT_EQ(0x00000023u, ImmutableString("radians").unmangledNameHash());
    ASSERT_EQ(0x00000013u, ImmutableString("degrees").unmangledNameHash());
    ASSERT_EQ(0x000000a9u, ImmutableString("sin").unmangledNameHash());
    ASSERT_EQ(0x00000053u, ImmutableString("cos").unmangledNameHash());
    ASSERT_EQ(0x00000097u, ImmutableString("tan").unmangledNameHash());
    ASSERT_EQ(0x00000039u, ImmutableString("asin").unmangledNameHash());
    ASSERT_EQ(0x0000005du, ImmutableString("acos").unmangledNameHash());
    ASSERT_EQ(0x000000b0u, ImmutableString("atan").unmangledNameHash());
    ASSERT_EQ(0x00000050u, ImmutableString("sinh").unmangledNameHash());
    ASSERT_EQ(0x00000034u, ImmutableString("cosh").unmangledNameHash());
    ASSERT_EQ(0x00000088u, ImmutableString("tanh").unmangledNameHash());
    ASSERT_EQ(0x00000094u, ImmutableString("asinh").unmangledNameHash());
    ASSERT_EQ(0x00000032u, ImmutableString("acosh").unmangledNameHash());
    ASSERT_EQ(0x000000a1u, ImmutableString("atanh").unmangledNameHash());
    ASSERT_EQ(0x00000062u, ImmutableString("pow").unmangledNameHash());
    ASSERT_EQ(0x000000c9u, ImmutableString("exp").unmangledNameHash());
    ASSERT_EQ(0x0000006cu, ImmutableString("log").unmangledNameHash());
    ASSERT_EQ(0x0000006fu, ImmutableString("exp2").unmangledNameHash());
    ASSERT_EQ(0x00000048u, ImmutableString("log2").unmangledNameHash());
    ASSERT_EQ(0x000000a4u, ImmutableString("sqrt").unmangledNameHash());
    ASSERT_EQ(0x00000083u, ImmutableString("inversesqrt").unmangledNameHash());
    ASSERT_EQ(0x00000042u, ImmutableString("abs").unmangledNameHash());
    ASSERT_EQ(0x00000082u, ImmutableString("sign").unmangledNameHash());
    ASSERT_EQ(0x0000009eu, ImmutableString("floor").unmangledNameHash());
    ASSERT_EQ(0x00000052u, ImmutableString("trunc").unmangledNameHash());
    ASSERT_EQ(0x0000002bu, ImmutableString("round").unmangledNameHash());
    ASSERT_EQ(0x00000018u, ImmutableString("roundEven").unmangledNameHash());
    ASSERT_EQ(0x0000001cu, ImmutableString("ceil").unmangledNameHash());
    ASSERT_EQ(0x00000072u, ImmutableString("fract").unmangledNameHash());
    ASSERT_EQ(0x00000021u, ImmutableString("mod").unmangledNameHash());
    ASSERT_EQ(0x000000c5u, ImmutableString("min").unmangledNameHash());
    ASSERT_EQ(0x00000044u, ImmutableString("max").unmangledNameHash());
    ASSERT_EQ(0x0000002du, ImmutableString("clamp").unmangledNameHash());
    ASSERT_EQ(0x000000a6u, ImmutableString("mix").unmangledNameHash());
    ASSERT_EQ(0x0000004fu, ImmutableString("step").unmangledNameHash());
    ASSERT_EQ(0x00000024u, ImmutableString("smoothstep").unmangledNameHash());
    ASSERT_EQ(0x00000029u, ImmutableString("modf").unmangledNameHash());
    ASSERT_EQ(0x0000003au, ImmutableString("isnan").unmangledNameHash());
    ASSERT_EQ(0x000000b7u, ImmutableString("isinf").unmangledNameHash());
    ASSERT_EQ(0x00000022u, ImmutableString("floatBitsToInt").unmangledNameHash());
    ASSERT_EQ(0x00000066u, ImmutableString("floatBitsToUint").unmangledNameHash());
    ASSERT_EQ(0x00000090u, ImmutableString("intBitsToFloat").unmangledNameHash());
    ASSERT_EQ(0x0000005eu, ImmutableString("uintBitsToFloat").unmangledNameHash());
    ASSERT_EQ(0x00000077u, ImmutableString("fma").unmangledNameHash());
    ASSERT_EQ(0x00000012u, ImmutableString("frexp").unmangledNameHash());
    ASSERT_EQ(0x00000065u, ImmutableString("ldexp").unmangledNameHash());
    ASSERT_EQ(0x000000c7u, ImmutableString("packSnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x000000cdu, ImmutableString("packHalf2x16").unmangledNameHash());
    ASSERT_EQ(0x00000047u, ImmutableString("unpackSnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000060u, ImmutableString("unpackHalf2x16").unmangledNameHash());
    ASSERT_EQ(0x0000005fu, ImmutableString("packUnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x000000b1u, ImmutableString("unpackUnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000081u, ImmutableString("packUnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x0000000du, ImmutableString("packSnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000002u, ImmutableString("unpackUnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x0000002au, ImmutableString("unpackSnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x000000c1u, ImmutableString("packDouble2x32").unmangledNameHash());
    ASSERT_EQ(0x0000002eu, ImmutableString("unpackDouble2x32").unmangledNameHash());
    ASSERT_EQ(0x0000005bu, ImmutableString("length").unmangledNameHash());
    ASSERT_EQ(0x00000085u, ImmutableString("distance").unmangledNameHash());
    ASSERT_EQ(0x000000cfu, ImmutableString("dot").unmangledNameHash());
    ASSERT_EQ(0x000000a3u, ImmutableString("cross").unmangledNameHash());
    ASSERT_EQ(0x0000009au, ImmutableString("normalize").unmangledNameHash());
    ASSERT_EQ(0x00000041u, ImmutableString("faceforward").unmangledNameHash());
    ASSERT_EQ(0x000000b6u, ImmutableString("reflect").unmangledNameHash());
    ASSERT_EQ(0x000000c3u, ImmutableString("refract").unmangledNameHash());
    ASSERT_EQ(0x000000a7u, ImmutableString("ftransform").unmangledNameHash());
    ASSERT_EQ(0x00000061u, ImmutableString("matrixCompMult").unmangledNameHash());
    ASSERT_EQ(0x000000c0u, ImmutableString("outerProduct").unmangledNameHash());
    ASSERT_EQ(0x0000004eu, ImmutableString("transpose").unmangledNameHash());
    ASSERT_EQ(0x00000079u, ImmutableString("determinant").unmangledNameHash());
    ASSERT_EQ(0x0000000eu, ImmutableString("inverse").unmangledNameHash());
    ASSERT_EQ(0x00000027u, ImmutableString("lessThan").unmangledNameHash());
    ASSERT_EQ(0x0000004du, ImmutableString("lessThanEqual").unmangledNameHash());
    ASSERT_EQ(0x0000007eu, ImmutableString("greaterThan").unmangledNameHash());
    ASSERT_EQ(0x0000007cu, ImmutableString("greaterThanEqual").unmangledNameHash());
    ASSERT_EQ(0x00000057u, ImmutableString("equal").unmangledNameHash());
    ASSERT_EQ(0x000000bfu, ImmutableString("notEqual").unmangledNameHash());
    ASSERT_EQ(0x00000098u, ImmutableString("any").unmangledNameHash());
    ASSERT_EQ(0x00000000u, ImmutableString("all").unmangledNameHash());
    ASSERT_EQ(0x0000001fu, ImmutableString("not").unmangledNameHash());
    ASSERT_EQ(0x00000091u, ImmutableString("bitfieldExtract").unmangledNameHash());
    ASSERT_EQ(0x0000007fu, ImmutableString("bitfieldInsert").unmangledNameHash());
    ASSERT_EQ(0x0000003cu, ImmutableString("bitfieldReverse").unmangledNameHash());
    ASSERT_EQ(0x0000006du, ImmutableString("bitCount").unmangledNameHash());
    ASSERT_EQ(0x00000009u, ImmutableString("findLSB").unmangledNameHash());
    ASSERT_EQ(0x00000030u, ImmutableString("findMSB").unmangledNameHash());
    ASSERT_EQ(0x00000036u, ImmutableString("uaddCarry").unmangledNameHash());
    ASSERT_EQ(0x00000059u, ImmutableString("usubBorrow").unmangledNameHash());
    ASSERT_EQ(0x000000b9u, ImmutableString("umulExtended").unmangledNameHash());
    ASSERT_EQ(0x00000014u, ImmutableString("imulExtended").unmangledNameHash());
    ASSERT_EQ(0x00000095u, ImmutableString("texture2D").unmangledNameHash());
    ASSERT_EQ(0x0000004bu, ImmutableString("texture2DProj").unmangledNameHash());
    ASSERT_EQ(0x000000c6u, ImmutableString("textureCube").unmangledNameHash());
    ASSERT_EQ(0x0000001du, ImmutableString("texture1D").unmangledNameHash());
    ASSERT_EQ(0x000000b4u, ImmutableString("texture1DProj").unmangledNameHash());
    ASSERT_EQ(0x000000b8u, ImmutableString("texture3D").unmangledNameHash());
    ASSERT_EQ(0x00000080u, ImmutableString("texture3DProj").unmangledNameHash());
    ASSERT_EQ(0x0000007du, ImmutableString("shadow1D").unmangledNameHash());
    ASSERT_EQ(0x0000009bu, ImmutableString("shadow1DProj").unmangledNameHash());
    ASSERT_EQ(0x000000aau, ImmutableString("shadow2D").unmangledNameHash());
    ASSERT_EQ(0x0000003fu, ImmutableString("shadow2DProj").unmangledNameHash());
    ASSERT_EQ(0x00000031u, ImmutableString("texture2DRect").unmangledNameHash());
    ASSERT_EQ(0x00000020u, ImmutableString("texture2DRectProj").unmangledNameHash());
    ASSERT_EQ(0x00000011u, ImmutableString("texture").unmangledNameHash());
    ASSERT_EQ(0x00000001u, ImmutableString("textureProj").unmangledNameHash());
    ASSERT_EQ(0x00000089u, ImmutableString("texture2DGradEXT").unmangledNameHash());
    ASSERT_EQ(0x00000015u, ImmutableString("texture2DProjGradEXT").unmangledNameHash());
    ASSERT_EQ(0x0000000bu, ImmutableString("textureCubeGradEXT").unmangledNameHash());
    ASSERT_EQ(0x0000007bu, ImmutableString("texture3DLod").unmangledNameHash());
    ASSERT_EQ(0x00000092u, ImmutableString("texture3DProjLod").unmangledNameHash());
    ASSERT_EQ(0x0000003du, ImmutableString("dFdx").unmangledNameHash());
    ASSERT_EQ(0x00000028u, ImmutableString("dFdy").unmangledNameHash());
    ASSERT_EQ(0x00000005u, ImmutableString("fwidth").unmangledNameHash());
    ASSERT_EQ(0x00000058u, ImmutableString("texture2DLodEXT").unmangledNameHash());
    ASSERT_EQ(0x00000019u, ImmutableString("texture2DProjLodEXT").unmangledNameHash());
    ASSERT_EQ(0x00000068u, ImmutableString("textureCubeLodEXT").unmangledNameHash());
    ASSERT_EQ(0x000000ceu, ImmutableString("texture2DLod").unmangledNameHash());
    ASSERT_EQ(0x00000064u, ImmutableString("texture2DProjLod").unmangledNameHash());
    ASSERT_EQ(0x0000000fu, ImmutableString("textureCubeLod").unmangledNameHash());
    ASSERT_EQ(0x000000c8u, ImmutableString("texture1DLod").unmangledNameHash());
    ASSERT_EQ(0x0000008bu, ImmutableString("texture1DProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000075u, ImmutableString("shadow1DLod").unmangledNameHash());
    ASSERT_EQ(0x0000000au, ImmutableString("shadow1DProjLod").unmangledNameHash());
    ASSERT_EQ(0x000000acu, ImmutableString("shadow2DLod").unmangledNameHash());
    ASSERT_EQ(0x00000056u, ImmutableString("shadow2DProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000040u, ImmutableString("textureLod").unmangledNameHash());
    ASSERT_EQ(0x0000005cu, ImmutableString("textureSize").unmangledNameHash());
    ASSERT_EQ(0x00000067u, ImmutableString("textureProjLod").unmangledNameHash());
    ASSERT_EQ(0x000000bbu, ImmutableString("texelFetch").unmangledNameHash());
    ASSERT_EQ(0x00000049u, ImmutableString("textureGrad").unmangledNameHash());
    ASSERT_EQ(0x00000025u, ImmutableString("textureProjGrad").unmangledNameHash());
    ASSERT_EQ(0x00000026u, ImmutableString("textureQueryLevels").unmangledNameHash());
    ASSERT_EQ(0x000000a2u, ImmutableString("textureSamples").unmangledNameHash());
    ASSERT_EQ(0x000000b2u, ImmutableString("textureQueryLod").unmangledNameHash());
    ASSERT_EQ(0x0000002cu, ImmutableString("textureOffset").unmangledNameHash());
    ASSERT_EQ(0x00000051u, ImmutableString("textureProjOffset").unmangledNameHash());
    ASSERT_EQ(0x0000009fu, ImmutableString("textureLodOffset").unmangledNameHash());
    ASSERT_EQ(0x0000006bu, ImmutableString("textureProjLodOffset").unmangledNameHash());
    ASSERT_EQ(0x0000005au, ImmutableString("texelFetchOffset").unmangledNameHash());
    ASSERT_EQ(0x000000afu, ImmutableString("textureGradOffset").unmangledNameHash());
    ASSERT_EQ(0x00000017u, ImmutableString("textureProjGradOffset").unmangledNameHash());
    ASSERT_EQ(0x00000006u, ImmutableString("rgb_2_yuv").unmangledNameHash());
    ASSERT_EQ(0x00000008u, ImmutableString("yuv_2_rgb").unmangledNameHash());
    ASSERT_EQ(0x0000007au, ImmutableString("textureGather").unmangledNameHash());
    ASSERT_EQ(0x00000076u, ImmutableString("textureGatherOffsets").unmangledNameHash());
    ASSERT_EQ(0x0000006au, ImmutableString("textureGatherOffset").unmangledNameHash());
    ASSERT_EQ(0x0000001bu, ImmutableString("dFdxFine").unmangledNameHash());
    ASSERT_EQ(0x0000006eu, ImmutableString("dFdyFine").unmangledNameHash());
    ASSERT_EQ(0x00000086u, ImmutableString("dFdxCoarse").unmangledNameHash());
    ASSERT_EQ(0x0000009du, ImmutableString("dFdyCoarse").unmangledNameHash());
    ASSERT_EQ(0x000000a0u, ImmutableString("fwidthFine").unmangledNameHash());
    ASSERT_EQ(0x0000008cu, ImmutableString("fwidthCoarse").unmangledNameHash());
    ASSERT_EQ(0x000000b5u, ImmutableString("interpolateAtCentroid").unmangledNameHash());
    ASSERT_EQ(0x00000054u, ImmutableString("interpolateAtSample").unmangledNameHash());
    ASSERT_EQ(0x00000033u, ImmutableString("interpolateAtOffset").unmangledNameHash());
    ASSERT_EQ(0x0000008fu, ImmutableString("atomicCounter").unmangledNameHash());
    ASSERT_EQ(0x00000007u, ImmutableString("atomicCounterIncrement").unmangledNameHash());
    ASSERT_EQ(0x0000004cu, ImmutableString("atomicCounterDecrement").unmangledNameHash());
    ASSERT_EQ(0x000000a8u, ImmutableString("atomicCounterAdd").unmangledNameHash());
    ASSERT_EQ(0x00000073u, ImmutableString("atomicCounterSubtract").unmangledNameHash());
    ASSERT_EQ(0x0000008eu, ImmutableString("atomicCounterMin").unmangledNameHash());
    ASSERT_EQ(0x0000008du, ImmutableString("atomicCounterMax").unmangledNameHash());
    ASSERT_EQ(0x00000046u, ImmutableString("atomicCounterAnd").unmangledNameHash());
    ASSERT_EQ(0x0000002fu, ImmutableString("atomicCounterOr").unmangledNameHash());
    ASSERT_EQ(0x0000001eu, ImmutableString("atomicCounterXor").unmangledNameHash());
    ASSERT_EQ(0x000000bdu, ImmutableString("atomicCounterExchange").unmangledNameHash());
    ASSERT_EQ(0x000000a5u, ImmutableString("atomicCounterCompSwap").unmangledNameHash());
    ASSERT_EQ(0x00000093u, ImmutableString("atomicAdd").unmangledNameHash());
    ASSERT_EQ(0x000000cbu, ImmutableString("atomicMin").unmangledNameHash());
    ASSERT_EQ(0x0000003bu, ImmutableString("atomicMax").unmangledNameHash());
    ASSERT_EQ(0x00000016u, ImmutableString("atomicAnd").unmangledNameHash());
    ASSERT_EQ(0x000000bau, ImmutableString("atomicOr").unmangledNameHash());
    ASSERT_EQ(0x00000099u, ImmutableString("atomicXor").unmangledNameHash());
    ASSERT_EQ(0x00000063u, ImmutableString("atomicExchange").unmangledNameHash());
    ASSERT_EQ(0x00000070u, ImmutableString("atomicCompSwap").unmangledNameHash());
    ASSERT_EQ(0x000000c2u, ImmutableString("imageSize").unmangledNameHash());
    ASSERT_EQ(0x00000071u, ImmutableString("imageSamples").unmangledNameHash());
    ASSERT_EQ(0x00000010u, ImmutableString("imageAtomicAdd").unmangledNameHash());
    ASSERT_EQ(0x000000adu, ImmutableString("imageAtomicMin").unmangledNameHash());
    ASSERT_EQ(0x000000b3u, ImmutableString("imageAtomicMax").unmangledNameHash());
    ASSERT_EQ(0x0000009cu, ImmutableString("imageAtomicAnd").unmangledNameHash());
    ASSERT_EQ(0x00000037u, ImmutableString("imageAtomicOr").unmangledNameHash());
    ASSERT_EQ(0x00000035u, ImmutableString("imageAtomicXor").unmangledNameHash());
    ASSERT_EQ(0x000000ccu, ImmutableString("imageAtomicExchange").unmangledNameHash());
    ASSERT_EQ(0x00000004u, ImmutableString("imageAtomicCompSwap").unmangledNameHash());
    ASSERT_EQ(0x00000038u, ImmutableString("imageLoad").unmangledNameHash());
    ASSERT_EQ(0x00000069u, ImmutableString("imageStore").unmangledNameHash());
    ASSERT_EQ(0x00000084u, ImmutableString("noise1").unmangledNameHash());
    ASSERT_EQ(0x00000087u, ImmutableString("noise2").unmangledNameHash());
    ASSERT_EQ(0x000000c4u, ImmutableString("noise3").unmangledNameHash());
    ASSERT_EQ(0x000000beu, ImmutableString("noise4").unmangledNameHash());
    ASSERT_EQ(0x0000008au, ImmutableString("memoryBarrier").unmangledNameHash());
    ASSERT_EQ(0x0000001au, ImmutableString("memoryBarrierAtomicCounter").unmangledNameHash());
    ASSERT_EQ(0x00000096u, ImmutableString("memoryBarrierBuffer").unmangledNameHash());
    ASSERT_EQ(0x0000000cu, ImmutableString("memoryBarrierImage").unmangledNameHash());
    ASSERT_EQ(0x0000004au, ImmutableString("barrier").unmangledNameHash());
    ASSERT_EQ(0x0000003eu, ImmutableString("memoryBarrierShared").unmangledNameHash());
    ASSERT_EQ(0x000000cau, ImmutableString("groupMemoryBarrier").unmangledNameHash());
    ASSERT_EQ(0x00000074u, ImmutableString("EmitVertex").unmangledNameHash());
    ASSERT_EQ(0x000000bcu, ImmutableString("EndPrimitive").unmangledNameHash());
    ASSERT_EQ(0x00000055u, ImmutableString("EmitStreamVertex").unmangledNameHash());
    ASSERT_EQ(0x00000078u, ImmutableString("EndStreamPrimitive").unmangledNameHash());
    ASSERT_EQ(0x00000045u, ImmutableString("subpassLoad").unmangledNameHash());
    ASSERT_EQ(0x000000abu, ImmutableString("anyInvocation").unmangledNameHash());
    ASSERT_EQ(0x00000043u, ImmutableString("allInvocations").unmangledNameHash());
    ASSERT_EQ(0x000000aeu, ImmutableString("allInvocationsEqual").unmangledNameHash());
    ASSERT_EQ(0x00000003u, ImmutableString("textureVideoWEBGL").unmangledNameHash());
}

}  // namespace sh
